/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.Molecule;
import WIMSchem.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogEdit
extends JDialog
implements ActionListener {
    Molecule mol;
    Molecule retMol = null;
    ArrayList<Integer> aselidx;
    ArrayList<Integer> bselidx;
    JTabbedPane tabs;
    JButton accept;
    JButton reject;
    JTable atoms;
    JTable bonds;
    static final String[] BOND_TYPES = new String[]{"Normal", "Inclined", "Declined", "Unknown"};

    public DialogEdit(Frame Parent, Molecule Mol, ArrayList<Integer> SelIdx) {
        super(Parent, "Edit Molecule", true);
        this.mol = Mol.Clone();
        this.aselidx = SelIdx;
        this.bselidx = new ArrayList();
        for (int n = 1; n <= this.mol.NumBonds(); ++n) {
            if (this.aselidx.indexOf(this.mol.BondFrom(n)) < 0 || this.aselidx.indexOf(this.mol.BondTo(n)) < 0) continue;
            this.bselidx.add(n);
        }
        this.setLayout(new BorderLayout());
        this.atoms = new JTable(this.CompileAtomData(), new String[]{"#", "El", "X", "Y", "Charge", "Unpaired", "HExplicit", "MapNum"}){

            public boolean isCellEditable(int row, int column) {
                return column > 0;
            }
        };
        this.bonds = new JTable(this.CompileBondData(), new String[]{"#", "From", "To", "Order", "Type"}){

            public boolean isCellEditable(int row, int column) {
                return column > 2;
            }
        };
        this.atoms.getColumnModel().getColumn(0).setCellEditor(null);
        JComboBox<String> bondTypes = new JComboBox<String>();
        for (int n = 0; n < BOND_TYPES.length; ++n) {
            bondTypes.addItem(BOND_TYPES[n]);
        }
        this.bonds.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(bondTypes));
        JPanel tabAtoms = new JPanel();
        JPanel tabBonds = new JPanel();
        tabAtoms.setLayout(new BorderLayout());
        tabBonds.setLayout(new BorderLayout());
        this.atoms.setPreferredScrollableViewportSize(new Dimension(350, 200));
        this.bonds.setPreferredScrollableViewportSize(new Dimension(350, 200));
        tabAtoms.add(new JScrollPane(this.atoms));
        tabBonds.add(new JScrollPane(this.bonds));
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Atoms", tabAtoms);
        this.tabs.addTab("Bonds", tabBonds);
        this.add((Component)this.tabs, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2));
        this.accept = new JButton("Accept");
        this.accept.addActionListener(this);
        this.accept.setMnemonic(65);
        this.reject = new JButton("Reject");
        this.reject.addActionListener(this);
        this.reject.setMnemonic(82);
        buttons.add(this.accept);
        buttons.add(this.reject);
        this.add((Component)buttons, "South");
        this.pack();
    }

    public Molecule exec() {
        this.setVisible(true);
        return this.retMol;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.accept) {
            if (!this.ReadData()) {
                return;
            }
            this.retMol = this.mol;
            this.setVisible(false);
        }
        if (e.getSource() == this.reject) {
            this.setVisible(false);
        }
    }

    Object[][] CompileAtomData() {
        Object[][] data = new Object[this.aselidx.size()][];
        DecimalFormat fmt = new DecimalFormat("0.0000");
        for (int n = 0; n < this.aselidx.size(); ++n) {
            int i = this.aselidx.get(n);
            Object[] da = new Object[]{new Integer(i), new String(this.mol.AtomElement(i)), fmt.format(this.mol.AtomX(i)), fmt.format(this.mol.AtomY(i)), String.valueOf(this.mol.AtomCharge(i)), String.valueOf(this.mol.AtomUnpaired(i)), this.mol.AtomHExplicit(i) == -1 ? "?" : String.valueOf(this.mol.AtomHExplicit(i)), String.valueOf(this.mol.AtomMapNum(i))};
            data[n] = da;
        }
        return data;
    }

    Object[][] CompileBondData() {
        Object[][] data = new Object[this.bselidx.size()][];
        for (int n = 0; n < this.bselidx.size(); ++n) {
            int i = this.bselidx.get(n);
            Object[] db = new Object[]{new Integer(i), new Integer(this.mol.BondFrom(i)), new Integer(this.mol.BondTo(i)), String.valueOf(this.mol.BondOrder(i)), new String(BOND_TYPES[this.mol.BondType(i)])};
            data[n] = db;
        }
        return data;
    }

    boolean ReadData() {
        int i;
        int n;
        for (n = 0; n < this.atoms.getRowCount(); ++n) {
            i = (Integer)this.atoms.getValueAt(n, 0);
            this.mol.SetAtomElement(i, (String)this.atoms.getValueAt(n, 1));
            this.mol.SetAtomPos(i, Utils.safeDouble((String)this.atoms.getValueAt(n, 2)), Utils.safeDouble((String)this.atoms.getValueAt(n, 3)));
            this.mol.SetAtomCharge(i, Utils.safeInt((String)this.atoms.getValueAt(n, 4)));
            this.mol.SetAtomUnpaired(i, Utils.safeInt((String)this.atoms.getValueAt(n, 5)));
            String hyStr = (String)this.atoms.getValueAt(n, 6);
            int hy = Utils.safeInt(hyStr);
            this.mol.SetAtomHExplicit(i, hyStr.compareTo("0") == 0 ? 0 : (hy > 0 ? hy : -1));
            this.mol.SetAtomMapNum(i, Utils.safeInt((String)this.atoms.getValueAt(n, 7)));
        }
        block1: for (n = 0; n < this.bonds.getRowCount(); ++n) {
            i = (Integer)this.bonds.getValueAt(n, 0);
            this.mol.SetBondOrder(i, new Integer((String)this.bonds.getValueAt(n, 3)));
            for (int j = BOND_TYPES.length - 1; j >= 0; --j) {
                if (BOND_TYPES[j].compareTo((String)this.bonds.getValueAt(n, 4)) != 0) continue;
                this.mol.SetBondType(i, j);
                continue block1;
            }
        }
        return true;
    }
}

