/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

class FlyApplet_panel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int CURVE = 0;
    public static final int RECT = 1;
    public static final int CIRCLE = 2;
    public static final int LINES = 3;
    public static final int LINE = 4;
    public static final int SLINE = 5;
    public static final int SEG = 6;
    public static final int POLY = 7;
    public static final int POINTS = 8;
    public static final int VEC = 9;
    public static final int NULL = -1;
    public static int ctype;
    static int ll;
    Image bg;
    Vector lines = new Vector(16384);
    int x1;
    int y1;
    int x2;
    int y2;
    int radius;
    double Radius;
    int drag;
    int st;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    double precision;
    int xsize;
    int ysize;
    int linewidth;
    boolean dashed;
    boolean use_coords;
    boolean stopdrawing;
    boolean display_coords = true;
    boolean cross = true;
    public static boolean filled;
    public static String coordinates;
    Font font;
    Color fgcolor;
    Color bgcolor;
    public static FontMetrics fm;

    public FlyApplet_panel(Color color, Color color2, Image image, int n, int n2, int n3, boolean bl, boolean bl2, double d, double d2, double d3, double d4, double d5, Font font, boolean bl3) {
        this.bgcolor = color;
        this.fgcolor = color2;
        this.setBackground(this.bgcolor);
        this.setForeground(this.fgcolor);
        this.bg = image;
        this.dashed = bl;
        this.linewidth = n;
        this.st = 0;
        this.xmin = d2;
        this.xmax = d4;
        this.ymin = d3;
        this.ymax = d5;
        this.font = font;
        this.xsize = n2;
        this.ysize = n3;
        this.use_coords = bl2;
        this.cross = bl3;
        this.precision = d;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public String points2string(String string) {
        StringBuffer stringBuffer = new StringBuffer(16384);
        stringBuffer.append(string);
        switch (ctype) {
            case -1: {
                break;
            }
            case 0: 
            case 3: 
            case 7: 
            case 8: {
                Point point = null;
                int n = this.lines.size();
                for (int i = 0; i < n; ++i) {
                    point = (Point)this.lines.elementAt(i);
                    stringBuffer.append(point.x).append(",").append(point.y).append(";");
                }
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                if (this.st <= 0) break;
                stringBuffer.append(this.x1).append(",").append(this.y1).append(",").append(this.x2).append(",").append(this.y2);
                break;
            }
            case 2: {
                if (this.st <= 0) break;
                stringBuffer.append(this.x1).append(",").append(this.y1).append(",").append(this.radius);
            }
        }
        return stringBuffer.toString();
    }

    public String Coords2String() {
        StringBuffer stringBuffer = new StringBuffer(16384);
        if ((ctype == 1 || ctype == 4 || ctype == 5 || ctype == 6 || ctype == 9) && this.st > 0) {
            stringBuffer.append(this.px2x(this.x1)).append(",").append(this.py2y(this.y1)).append(",").append(this.px2x(this.x2)).append(",").append(this.py2y(this.y2));
        } else if (ctype == 2 && this.st > 0) {
            stringBuffer.append(this.px2x(this.x1)).append(",").append(this.py2y(this.y1)).append(",").append((double)Math.round(this.precision * this.Radius) / this.precision);
        } else {
            Point point = null;
            int n = this.lines.size();
            for (int i = 0; i < n; ++i) {
                point = (Point)this.lines.elementAt(i);
                if (i != 0) {
                    stringBuffer.append(",").append(this.px2x(point.x)).append(",").append(this.py2y(point.y));
                    continue;
                }
                stringBuffer.append(this.px2x(point.x)).append(",").append(this.py2y(point.y));
            }
        }
        return stringBuffer.toString();
    }

    public void retry() {
        this.lines.removeAllElements();
        this.st = 0;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.lines.size();
        mouseEvent.consume();
        switch (ctype) {
            case -1: {
                break;
            }
            case 0: {
                if (n < 2000) {
                    this.x1 = mouseEvent.getX();
                    this.y1 = mouseEvent.getY();
                    this.lines.addElement(new Point(this.x1, this.y1));
                    this.repaint();
                }
                this.st = 2;
                return;
            }
            default: {
                int n2 = this.drag;
                this.mouseMoved(mouseEvent);
                this.drag = n2 + 1;
                return;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.drag = 0;
        if (this.use_coords) {
            double d = this.px2x(mouseEvent.getX());
            double d2 = this.py2y(mouseEvent.getY());
            coordinates = ctype == 2 ? "(" + d + ":" + d2 + ")" + " R=" + this.Radius : "(" + d + ":" + d2 + ")";
            this.repaint();
        }
        switch (ctype) {
            case -1: {
                break;
            }
            case 7: {
                if (this.stopdrawing) {
                    this.mouseExited(mouseEvent);
                    return;
                }
            }
            case 3: 
            case 8: {
                if (this.st == 1) {
                    this.mouseClicked(mouseEvent);
                }
                return;
            }
            case 0: {
                if (this.st == 0) {
                    return;
                }
                this.st = 1;
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                if (this.st != 1) {
                    return;
                }
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                this.radius = (int)Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
                this.Radius = (double)Math.round(this.precision * Math.sqrt((this.px2x(this.x2) - this.px2x(this.x1)) * (this.px2x(this.x2) - this.px2x(this.x1)) + (this.py2y(this.y2) - this.py2y(this.y1)) * (this.py2y(this.y2) - this.py2y(this.y1)))) / this.precision;
                break;
            }
            default: {
                return;
            }
        }
        if (ctype != 8) {
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseClicked(mouseEvent);
        mouseEvent.consume();
        switch (ctype) {
            case -1: {
                break;
            }
            case 0: {
                this.mouseClicked(mouseEvent);
                if (this.st > 0) {
                    return;
                }
                this.x1 = mouseEvent.getX();
                this.y1 = mouseEvent.getY();
                this.x2 = this.x1;
                this.y2 = this.y1;
                this.lines.removeAllElements();
                this.lines.addElement(new Point(this.x1, this.y1));
                this.repaint();
                this.st = 2;
                return;
            }
            case 7: {
                if (this.stopdrawing) {
                    this.mouseExited(mouseEvent);
                    return;
                }
            }
            case 3: 
            case 8: {
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                if (this.st == 0) {
                    this.lines.removeAllElements();
                }
                this.lines.addElement(new Point(this.x2, this.y2));
                this.st = 1;
                this.x1 = this.x2;
                this.y1 = this.y2;
                this.repaint();
                return;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                switch (this.st) {
                    case 0: 
                    case 2: {
                        this.x1 = this.x2;
                        this.y1 = this.y2;
                        this.radius = 0;
                        this.st = 1;
                        this.repaint();
                        return;
                    }
                    case 1: {
                        this.radius = (int)Math.sqrt((this.x2 - this.x1) * (this.x2 - this.x1) + (this.y2 - this.y1) * (this.y2 - this.y1));
                        this.st = 2;
                        return;
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.consume();
        switch (ctype) {
            case -1: {
                break;
            }
            case 0: {
                if (this.st == 2) {
                    return;
                }
                this.x2 = mouseEvent.getX();
                this.y2 = mouseEvent.getY();
                if (this.st == 0) {
                    this.lines.removeAllElements();
                }
                this.lines.addElement(new Point(this.x2, this.y2));
                this.st = 1;
                this.x1 = this.x2;
                this.y1 = this.y2;
                return;
            }
            case 8: {
                return;
            }
            default: {
                if (this.st > 0 && this.drag >= 8) {
                    this.mousePressed(mouseEvent);
                }
                return;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.display_coords = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.display_coords = false;
        if (this.use_coords) {
            this.repaint();
        }
        if (ctype != 0 && ctype != 3 && ctype != 7) {
            return;
        }
        mouseEvent.consume();
        this.x2 = this.x1;
        this.y2 = this.y1;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.stopdrawing = false;
            switch (ctype) {
                case -1: {
                    break;
                }
                case 0: 
                case 7: {
                    if (this.lines.size() > 0) {
                        this.RemoveRange(this.lines.size() - 1, this.lines.size());
                        this.x1 = mouseEvent.getX();
                        this.y1 = mouseEvent.getY();
                        this.repaint();
                    }
                    return;
                }
                case 8: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                case 3: {
                    if (this.lines.size() > 0) {
                        this.RemoveRange(this.lines.size() - 1, this.lines.size());
                        this.x1 = mouseEvent.getX();
                        this.y1 = mouseEvent.getY();
                        this.repaint();
                    }
                    return;
                }
                case 2: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                case 5: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                case 4: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                case 6: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                case 9: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                case 1: {
                    this.RemoveElement(mouseEvent.getX(), mouseEvent.getY());
                    this.repaint();
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void repaint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        this.paintComponent(graphics);
    }

    public void RemoveRange(int n, int n2) {
        if (n == 0) {
            this.lines.removeAllElements();
        } else {
            for (int i = n; i < n2; ++i) {
                this.lines.remove(i);
            }
        }
    }

    public void RemoveElement(int n, int n2) {
        Point point = null;
        int n3 = this.lines.size();
        int n4 = 2 * this.linewidth;
        for (int i = 0; i < n3; ++i) {
            point = (Point)this.lines.elementAt(i);
            if (point.x - n4 >= n || point.x + n4 <= n || point.y - n4 >= n2 || point.y + n4 <= n2) continue;
            this.lines.remove(i);
            break;
        }
    }

    public void paintComponent(Graphics graphics) {
        graphics.clearRect(0, 0, this.xsize, this.ysize);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.bg != null) {
            graphics2D.drawImage(this.bg, 0, 0, this);
        }
        if (this.dashed) {
            graphics2D.setStroke(new BasicStroke(this.linewidth, 1, 2, 1.0f, new float[]{9.0f}, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.linewidth));
        }
        int n = this.lines.size();
        if (this.use_coords && this.display_coords) {
            graphics2D.setFont(this.font);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(coordinates, 0, 20);
            graphics2D.setColor(this.fgcolor);
        }
        switch (ctype) {
            case 8: {
                if (n <= 0) break;
                for (int i = 0; i < n; ++i) {
                    this.pointPaint(graphics2D, (Point)this.lines.elementAt(i), this.cross);
                }
                break;
            }
            case 0: 
            case 3: 
            case 7: {
                Object object;
                if (n > 0) {
                    Object object2 = (Point)this.lines.elementAt(0);
                    for (int i = 1; i < n; ++i) {
                        object = (Point)this.lines.elementAt(i);
                        graphics2D.drawLine(((Point)object2).x, ((Point)object2).y, object.x, object.y);
                        object2 = object;
                    }
                    if (this.st == 1) {
                        graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
                    }
                }
                if (ctype != 7 || n <= 1) break;
                if (!filled) {
                    Point point = (Point)this.lines.elementAt(0);
                    object = (Point)this.lines.elementAt(n - 1);
                    if (this.st == 0) {
                        graphics2D.drawLine(point.x, point.y, object.x, object.y);
                        break;
                    }
                    graphics2D.drawLine(point.x, point.y, this.x2, this.y2);
                    break;
                }
                int[] nArray = new int[n];
                object = new int[n];
                for (int i = 0; i < n; ++i) {
                    Point point = (Point)this.lines.elementAt(i);
                    nArray[i] = point.x;
                    object[i] = point.y;
                }
                graphics2D.fillPolygon(nArray, (int[])object, n);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                if (this.st <= 0) break;
                int n2 = Math.min(this.x1, this.x2);
                int n3 = Math.min(this.y1, this.y2);
                int n4 = Math.max(this.x1, this.x2);
                int n5 = Math.max(this.y1, this.y2);
                int n6 = Math.max(Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
                if (n6 < 10) {
                    n6 = 10;
                }
                n6 = 500 / n6 + 1;
                switch (ctype) {
                    case 1: {
                        if (!filled) {
                            graphics2D.drawRect(n2, n3, n4 - n2, n5 - n3);
                            break;
                        }
                        graphics2D.fillRect(n2, n3, n4 - n2, n5 - n3);
                        break;
                    }
                    case 5: {
                        graphics2D.fillOval(this.x1 - 2, this.y1 - 2, 4, 4);
                        graphics2D.drawLine(this.x1, this.y1, n6 * this.x2 - (n6 - 1) * this.x1, n6 * this.y2 - (n6 - 1) * this.y1);
                        break;
                    }
                    case 4: {
                        graphics2D.fillOval(this.x1 - 2, this.y1 - 2, 4, 4);
                        graphics2D.fillOval(this.x2 - 2, this.y2 - 2, 4, 4);
                        graphics2D.drawLine(n6 * this.x1 - (n6 - 1) * this.x2, n6 * this.y1 - (n6 - 1) * this.y2, n6 * this.x2 - (n6 - 1) * this.x1, n6 * this.y2 - (n6 - 1) * this.y1);
                        break;
                    }
                    case 6: {
                        graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 9: {
                        graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
                        if (this.radius <= 5) break;
                        double[] dArray = new double[6];
                        int[] nArray = new int[3];
                        int[] nArray2 = new int[3];
                        double d = this.linewidth;
                        double d2 = (double)this.linewidth * 0.3;
                        nArray[0] = this.x2;
                        nArray2[0] = this.y2;
                        double d3 = this.x1 - this.x2;
                        double d4 = this.y1 - this.y2;
                        dArray[0] = d * d3 / (double)this.radius;
                        dArray[1] = d * d4 / (double)this.radius;
                        dArray[2] = dArray[0] + dArray[1] * d2;
                        dArray[3] = dArray[1] - dArray[0] * d2;
                        dArray[4] = dArray[0] - dArray[1] * d2;
                        dArray[5] = dArray[1] + dArray[0] * d2;
                        nArray[1] = (int)(dArray[2] + (double)nArray[0]);
                        nArray2[1] = (int)(dArray[3] + (double)nArray2[0]);
                        nArray[2] = (int)(dArray[4] + (double)nArray[0]);
                        nArray2[2] = (int)(dArray[5] + (double)nArray2[0]);
                        graphics2D.fillPolygon(nArray, nArray2, 3);
                    }
                }
                break;
            }
            case 2: {
                if (this.st <= 0) break;
                this.pointPaint(graphics2D, new Point(this.x1, this.y1), this.cross);
                if (!filled) {
                    graphics2D.drawOval(this.x1 - this.radius, this.y1 - this.radius, this.radius * 2, this.radius * 2);
                    break;
                }
                graphics2D.fillOval(this.x1 - this.radius, this.y1 - this.radius, this.radius * 2, this.radius * 2);
            }
        }
    }

    void pointPaint(Graphics graphics, Point point, boolean bl) {
        if (bl) {
            graphics.drawLine(point.x - ll, point.y + ll, point.x + ll, point.y - ll);
            graphics.drawLine(point.x + ll, point.y + ll, point.x - ll, point.y - ll);
        } else {
            graphics.fillOval(point.x - this.linewidth, point.y - this.linewidth, 2 * this.linewidth, 2 * this.linewidth);
        }
    }

    public double px2x(int n) {
        double d = (double)n * (this.xmax - this.xmin) / (double)this.xsize + this.xmin;
        d = (double)Math.round(this.precision * d) / this.precision;
        return d;
    }

    public double py2y(int n) {
        double d = this.ymax - (double)n * (this.ymax - this.ymin) / (double)this.ysize;
        d = (double)Math.round(this.precision * d) / this.precision;
        return d;
    }

    static {
        ll = 4;
        filled = false;
        coordinates = " ";
    }
}

