/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ppm;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;

public abstract class ImageEncoder
implements ImageConsumer {
    protected DataOutput out;
    private ImageProducer producer;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    protected Hashtable props = null;
    private boolean accumulate = false;
    private int[] accumulator;

    public ImageEncoder(Image image, DataOutput dataOutput) throws IOException {
        this(image.getSource(), dataOutput);
    }

    public ImageEncoder(ImageProducer imageProducer, DataOutput dataOutput) throws IOException {
        this.producer = imageProducer;
        this.out = dataOutput;
    }

    protected abstract void encodeStart(int var1, int var2) throws IOException;

    protected abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;

    protected abstract void encodeDone() throws IOException;

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    private void encodePixelsWrapper(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            for (int i2 = 0; i2 < n5; ++i2) {
                System.arraycopy(nArray, i2 * n7 + n6, this.accumulator, (n3 + i2) * this.width + n2, n4);
            }
        } else {
            this.encodePixels(n2, n3, n4, n5, nArray, n6, n7);
        }
    }

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    public void setDimensions(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void setProperties(Hashtable hashtable) {
        this.props = hashtable;
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n2) {
        this.hintflags = n2;
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        int[] nArray = new int[n4];
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = n6 + i2 * n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                nArray[i3] = colorModel.getRGB(byArray[n8 + i3] & 0xFF);
            }
            try {
                this.encodePixelsWrapper(n2, n3 + i2, n4, 1, nArray, 0, n4);
                continue;
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        if (colorModel == rgbModel) {
            try {
                this.encodePixelsWrapper(n2, n3, n4, n5, nArray, n6, n7);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        } else {
            int[] nArray2 = new int[n4];
            for (int i2 = 0; i2 < n5; ++i2) {
                int n8 = n6 + i2 * n7;
                for (int i3 = 0; i3 < n4; ++i3) {
                    nArray2[i3] = colorModel.getRGB(nArray[n8 + i3]);
                }
                try {
                    this.encodePixelsWrapper(n2, n3 + i2, n4, 1, nArray2, 0, n4);
                    continue;
                }
                catch (IOException iOException) {
                    this.iox = iOException;
                    this.stop();
                    return;
                }
            }
        }
    }

    public void imageComplete(int n2) {
        this.producer.removeConsumer(this);
        if (n2 == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException iOException) {
                this.iox = iOException;
            }
        }
        this.stop();
    }
}

