/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import WIMSchem.EditorPane;
import WIMSchem.Molecule;
import WIMSchem.ds.DataSheet;
import WIMSchem.ds.DataSheetCache;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DataTableModel
extends AbstractTableModel {
    DataSheet ds = null;
    DataSheetCache cache = null;
    int temporaryEdit = -1;

    public MoleculeRenderer NewMoleculeRenderer() {
        return new MoleculeRenderer();
    }

    public MoleculeEditor NewMoleculeEditor(ActionListener ActList) {
        return new MoleculeEditor(ActList);
    }

    public DataTableModel(DataSheet DS, DataSheetCache Cache2) {
        this.ds = DS;
        this.cache = Cache2;
    }

    public void SetDataSheet(DataSheet DS, DataSheetCache Cache2) {
        this.ds = DS;
        this.cache = Cache2;
    }

    public void SetTemporaryEdit(int Col) {
        this.temporaryEdit = Col;
    }

    public void ClearTemporaryEdit() {
        this.temporaryEdit = -1;
    }

    public int getColumnCount() {
        return this.ds.NumCols();
    }

    public int getRowCount() {
        return this.ds.NumRows();
    }

    public String getColumnName(int col) {
        return this.ds.ColName(col);
    }

    public Object getValueAt(int row, int col) {
        int t = this.ds.ColType(col);
        if (this.ds.IsNull(row, col)) {
            if (t == 1) {
                return null;
            }
            if (t == 5) {
                return new Boolean(false);
            }
            return "";
        }
        if (t == 1) {
            return this.ds.GetMolecule(row, col);
        }
        if (t == 2) {
            return this.ds.GetString(row, col);
        }
        if (t == 3) {
            return new Integer(this.ds.GetInteger(row, col));
        }
        if (t == 4) {
            return new Double(this.ds.GetReal(row, col));
        }
        if (t == 5) {
            return new Boolean(this.ds.GetBoolean(row, col));
        }
        return "";
    }

    public Class getColumnClass(int col) {
        int t = this.ds.ColType(col);
        if (t == 1) {
            return new Molecule().getClass();
        }
        if (t == 2) {
            return new String("").getClass();
        }
        if (t == 3) {
            return new String("").getClass();
        }
        if (t == 4) {
            return new String("").getClass();
        }
        if (t == 5) {
            return new Boolean(false).getClass();
        }
        return new String("").getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return this.temporaryEdit == col;
    }

    public void setValueAt(Object val, int row, int col) {
        int t = this.ds.ColType(col);
        try {
            this.cache.CacheUndo(this.ds);
            if (t == 1) {
                this.ds.SetMolecule(row, col, (Molecule)val);
            } else if (t == 2) {
                this.ds.SetString(row, col, (String)val);
            } else if (t == 3) {
                String str = (String)val;
                if (str.length() == 0) {
                    this.ds.SetToNull(row, col);
                } else {
                    this.ds.SetInteger(row, col, Integer.parseInt(str));
                }
            } else if (t == 4) {
                String str = (String)val;
                if (str.length() == 0) {
                    this.ds.SetToNull(row, col);
                } else {
                    this.ds.SetReal(row, col, Double.parseDouble(str));
                }
            } else if (t == 5) {
                this.ds.SetBoolean(row, col, (Boolean)val);
            }
            this.ds.SetDirty();
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    public TableCellRenderer getCellRenderer(int row, int col, TableCellRenderer def) {
        if (this.ds.ColType(col) == 1) {
            return new MoleculeRenderer();
        }
        return def;
    }

    class MoleculeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        ActionListener actlist;

        public MoleculeEditor(ActionListener ActList) {
            this.actlist = ActList;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.actlist.actionPerformed(new ActionEvent(table, 0, row + "," + col));
            this.fireEditingStopped();
            return null;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    class MoleculeRenderer
    extends EditorPane
    implements TableCellRenderer {
        Border focusBorder = null;

        public MoleculeRenderer() {
            this.setOpaque(true);
            this.SetEditable(false);
            this.SetAutoScale(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object mol, boolean isSelected, boolean hasFocus, int row, int col) {
            if (mol != null) {
                this.Replace((Molecule)mol);
            } else {
                this.Clear();
            }
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            if (hasFocus) {
                if (this.focusBorder == null) {
                    this.focusBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, table.getSelectionBackground().darker());
                }
                this.setBorder(this.focusBorder);
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }
}

