/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.AppletMenu;
import WIMSchem.DialogEdit;
import WIMSchem.EditorPane;
import WIMSchem.FileExtFilter;
import WIMSchem.FileMolPreview;
import WIMSchem.MainWindow;
import WIMSchem.MolSelectListener;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import WIMSchem.TemplSelectListener;
import WIMSchem.TemplateSelector;
import WIMSchem.Templates;
import WIMSchem.ToolButton;
import WIMSchem.ds.DataSheetStream;
import WIMSchem.ds.DataWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class MainPanel
extends JPanel
implements ActionListener,
MouseListener,
WindowListener,
KeyListener,
ClipboardOwner,
TemplSelectListener,
MolSelectListener {
    public String LICENSE = "This program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n\nor see http://www.gnu.org for details.";
    public static String VERSION = "0.1";
    MainWindow frameParent;
    ImageIcon mainIcon = null;
    ImageIcon mainLogo = null;
    public static boolean viewH;
    public static boolean viewC;
    static final int TOOL_CURSOR = 0;
    static final int TOOL_ROTATOR = 1;
    static final int TOOL_ERASOR = 2;
    static final int TOOL_DIALOG = 3;
    static final int TOOL_EDIT = 4;
    static final int TOOL_SETATOM = 5;
    static final int TOOL_SINGLE = 6;
    static final int TOOL_DOUBLE = 7;
    static final int TOOL_TRIPLE = 8;
    static final int TOOL_ZERO = 9;
    static final int TOOL_INCLINED = 10;
    static final int TOOL_DECLINED = 11;
    static final int TOOL_UNKNOWN = 12;
    static final int TOOL_CHARGE = 13;
    static final int TOOL_UNDO = 14;
    static final int TOOL_REDO = 15;
    static final int TOOL_TEMPLATE = 16;
    static final int TOOL_CUT = 17;
    static final int TOOL_COPY = 18;
    static final int TOOL_PASTE = 19;
    static final int TOOL_COUNT = 20;
    public String[] TOOL_TIPS;
    public String[] IMAGE_TOOL = new String[]{"Cursor", "Rotator", "Erasor", "EDialog", "AEdit", "ASelect", "BSingle", "BDouble", "BTriple", "BZero", "BInclined", "BDeclined", "BUnknown", "ACharge", "Undo", "Redo", "Template", "ECut", "ECopy", "EPaste"};
    public boolean[] selected_tools = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    public boolean[] selected_menus = new boolean[]{true, true, true, true, true, true, true, true};
    public String[] my_atoms;
    AbstractButton[] toolButtons;
    ButtonGroup toolGroup;
    ImageIcon[] toolIcons;
    EditorPane editor;
    Templates templ;
    JCheckBoxMenuItem chkShowHydr;
    JCheckBoxMenuItem chkShowSter;
    boolean firstResize = true;
    String filename = null;
    String lastElement = null;
    String typedElement = "";
    Molecule lastTemplate = null;
    int templateIdx = -1;
    boolean streamMode = false;
    boolean appletMode = false;
    String language = "";
    Properties translation;
    boolean useLocalClipboard = false;
    String appletClipboard = "";

    public Properties loadProperties(String lang) {
        Properties P = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream("/lang/WIMSchemProperties_" + lang + ".properties");
            P.load(in);
            in.close();
            return P;
        }
        catch (Exception e) {
            System.out.println("error reading /lang/WIMSchemProperties_" + lang + ".properties\n" + e);
            return null;
        }
    }

    public String getToolTips(int p) {
        if (p > 20) {
            return "error";
        }
        this.TOOL_TIPS[0] = this.translation.getProperty("CURSOR_TIP");
        this.TOOL_TIPS[1] = this.translation.getProperty("ROTATOR_TIP");
        this.TOOL_TIPS[2] = this.translation.getProperty("ERASOR_TIP");
        this.TOOL_TIPS[3] = this.translation.getProperty("EDIT_DIALOG_TIP");
        this.TOOL_TIPS[4] = this.translation.getProperty("EDIT_ELEMENT_TIP");
        this.TOOL_TIPS[5] = this.translation.getProperty("PLACE_ELEMENT_TIP");
        this.TOOL_TIPS[6] = this.translation.getProperty("SINGLE_BOND_TIP");
        this.TOOL_TIPS[7] = this.translation.getProperty("DOUBLE_BOND_TIP");
        this.TOOL_TIPS[8] = this.translation.getProperty("TRIPLE_BOND_TIP");
        this.TOOL_TIPS[9] = this.translation.getProperty("ZERO_BOND_TIP");
        this.TOOL_TIPS[10] = this.translation.getProperty("INCLINED_BOND_TIP");
        this.TOOL_TIPS[11] = this.translation.getProperty("DECLINE_BOND_TIP");
        this.TOOL_TIPS[12] = this.translation.getProperty("SQUIGGLY_BOND_TIP");
        this.TOOL_TIPS[13] = this.translation.getProperty("CHARGE_TIP");
        this.TOOL_TIPS[14] = this.translation.getProperty("UNDO_TIP");
        this.TOOL_TIPS[15] = this.translation.getProperty("REDO_TIP");
        this.TOOL_TIPS[16] = this.translation.getProperty("TEMPLATE_TIP");
        this.TOOL_TIPS[17] = this.translation.getProperty("CUT_TIP");
        this.TOOL_TIPS[18] = this.translation.getProperty("COPY_TIP");
        this.TOOL_TIPS[19] = this.translation.getProperty("PASTE");
        return this.TOOL_TIPS[p];
    }

    public MainPanel(String LoadFN, boolean StreamMode, boolean AppletMode, MainWindow FrameParent, String Language, Properties Translation, boolean[] Selected_Tools, boolean[] Selected_Menus, String[] My_Atoms, boolean ViewH, boolean ViewC) {
        this.streamMode = StreamMode;
        this.appletMode = AppletMode;
        if (this.appletMode) {
            viewH = ViewH;
            viewC = ViewC;
            this.selected_tools = Selected_Tools;
            this.selected_menus = Selected_Menus;
            this.my_atoms = My_Atoms;
            this.mainIcon = new ImageIcon(this.getClass().getResource("/images/wims_icon.gif"));
            this.mainLogo = new ImageIcon(this.getClass().getResource("/images/wims_logo.gif"));
            this.language = Language;
            this.translation = Translation;
            System.out.println("Hi, I'm the applet version....language is :" + this.language);
        } else {
            this.language = "en";
            this.my_atoms = null;
            viewH = true;
            viewC = true;
            this.mainIcon = new ImageIcon(this.getClass().getResource("/images/MainIcon.png"));
            this.mainLogo = new ImageIcon(this.getClass().getResource("/images/MainLogo.png"));
            this.translation = this.loadProperties("en");
            System.out.println("Hi, I'm the standalone version....language is :" + this.language);
        }
        this.frameParent = FrameParent;
        this.useLocalClipboard = this.appletMode;
        this.templ = new Templates(this.getClass());
        this.TOOL_TIPS = new String[20];
        JToolBar tools = new JToolBar(1);
        tools.setFloatable(!AppletMode);
        this.toolButtons = new AbstractButton[20];
        this.toolIcons = new ImageIcon[20];
        this.toolGroup = new ButtonGroup();
        for (int n = 0; n < 20; ++n) {
            this.toolIcons[n] = new ImageIcon(this.getClass().getResource("/images/" + this.IMAGE_TOOL[n] + ".png"));
            if (!this.selected_tools[n]) continue;
            this.toolButtons[n] = new ToolButton(this.toolIcons[n]);
            this.toolGroup.add(this.toolButtons[n]);
            tools.add(this.toolButtons[n]);
            this.toolButtons[n].addActionListener(this);
            this.toolButtons[n].setToolTipText(this.getToolTips(n));
        }
        if (this.selected_tools[0]) {
            this.toolGroup.setSelected(this.toolButtons[0].getModel(), true);
        }
        if (this.selected_tools[5]) {
            this.toolButtons[5].addMouseListener(this);
            this.toolButtons[5].addKeyListener(this);
            this.SelectElement("C");
        }
        if (this.selected_tools[16]) {
            this.toolButtons[16].addMouseListener(this);
        }
        JMenuBar menubar = AppletMode ? this.MenuBarApplet() : this.MenuBarApplication();
        this.editor = new EditorPane();
        this.editor.SetMolSelectListener(this);
        JScrollPane scroll = new JScrollPane(this.editor);
        if (!AppletMode) {
            this.setLayout(new BorderLayout());
            this.add((Component)scroll, "Center");
            this.add((Component)menubar, "North");
            this.add((Component)tools, "West");
        } else {
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)menubar, "North");
            p.add((Component)scroll, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)tools, "West");
            this.add((Component)p, "Center");
        }
        this.editor.grabFocus();
        this.editor.SetToolCursor();
        if (LoadFN != null) {
            try {
                FileInputStream istr = new FileInputStream(LoadFN);
                Molecule frag = MoleculeStream.ReadUnknown(istr);
                this.editor.AddArbitraryFragment(frag);
                istr.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Open Failed", 0);
                return;
            }
            this.SetFilename(LoadFN);
            this.editor.NotifySaved();
        }
        if (this.streamMode) {
            this.ReadStream();
        }
        this.addKeyListener(this);
        this.editor.addKeyListener(this);
        if (this.frameParent != null) {
            this.frameParent.addWindowListener(this);
        }
    }

    public JMenuBar MenuBarApplication() {
        JMenuBar menubar = new JMenuBar();
        JMenu menufile = new JMenu(this.translation.getProperty("File"));
        menufile.setMnemonic(70);
        menufile.add(this.MenuItem(this.translation.getProperty("New"), 78, null, KeyStroke.getKeyStroke(78, 2)));
        menufile.add(this.MenuItem(this.translation.getProperty("New_Window"), 87, null, KeyStroke.getKeyStroke(78, 3)));
        menufile.add(this.MenuItem(this.translation.getProperty("New_DataSheet"), 68, null));
        menufile.add(this.MenuItem(this.translation.getProperty("Open"), 79, null, KeyStroke.getKeyStroke(79, 2)));
        if (!this.streamMode) {
            menufile.add(this.MenuItem(this.translation.getProperty("Save"), 83, null, KeyStroke.getKeyStroke(83, 2)));
        }
        menufile.add(this.MenuItem(this.translation.getProperty("Save_As"), 65));
        JMenu menuexport = new JMenu(this.translation.getProperty("Export"));
        menuexport.setMnemonic(88);
        menuexport.add(this.MenuItem("Native2Javascript (wims)", 77, null, KeyStroke.getKeyStroke(87, 3)));
        menuexport.add(this.MenuItem("MDLMol2Javascript (wims)", 77, null, KeyStroke.getKeyStroke(86, 3)));
        menuexport.add(this.MenuItem(this.translation.getProperty("as_MDL_MOL"), 77, null, KeyStroke.getKeyStroke(77, 3)));
        menuexport.add(this.MenuItem(this.translation.getProperty("as_CML_XML"), 88, null, KeyStroke.getKeyStroke(88, 3)));
        menufile.add(menuexport);
        menufile.addSeparator();
        if (!this.streamMode) {
            menufile.add(this.MenuItem(this.translation.getProperty("Quit"), 81, null, KeyStroke.getKeyStroke(81, 2)));
        } else {
            menufile.add(this.MenuItem(this.translation.getProperty("Save_and_Quit"), 81, null, KeyStroke.getKeyStroke(81, 2)));
        }
        JMenu menuedit = new JMenu(this.translation.getProperty("Edit"));
        menuedit.setMnemonic(69);
        menuedit.add(this.MenuItem(this.translation.getProperty("Editttt"), 69, this.toolIcons[3], KeyStroke.getKeyStroke(32, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Undo"), 85, this.toolIcons[14], KeyStroke.getKeyStroke(90, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Redo"), 82, this.toolIcons[15], KeyStroke.getKeyStroke(90, 3)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Cut"), 88, this.toolIcons[17], KeyStroke.getKeyStroke(88, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Copy"), 67, this.toolIcons[18], KeyStroke.getKeyStroke(67, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Paste"), 86, this.toolIcons[19], KeyStroke.getKeyStroke(86, 2)));
        menuedit.addSeparator();
        menuedit.add(this.MenuItem(this.translation.getProperty("Select_All"), 83, null, KeyStroke.getKeyStroke(65, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Next_Atom"), 78, null, KeyStroke.getKeyStroke(69, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Previous_Atom"), 80, null, KeyStroke.getKeyStroke(69, 3)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Next_Group"), 71, null, KeyStroke.getKeyStroke(71, 2)));
        menuedit.add(this.MenuItem(this.translation.getProperty("Previous_Group"), 82, null, KeyStroke.getKeyStroke(71, 3)));
        menuedit.addSeparator();
        menuedit.add(this.MenuItem(this.translation.getProperty("Flip_Horizontal"), 72, null, null));
        menuedit.add(this.MenuItem(this.translation.getProperty("Flip_Vertical"), 86, null, null));
        menuedit.add(this.MenuItem(this.translation.getProperty("Rotate_P45"), 52, null, null));
        menuedit.add(this.MenuItem(this.translation.getProperty("Rotate_M45"), 53, null, null));
        menuedit.add(this.MenuItem(this.translation.getProperty("Rotate_P90"), 57, null, null));
        menuedit.add(this.MenuItem(this.translation.getProperty("Rotate_M90"), 48, null, null));
        menuedit.addSeparator();
        menuedit.add(this.MenuItem(this.translation.getProperty("Add_Temporary_Template"), 84, null, null));
        menuedit.add(this.MenuItem(this.translation.getProperty("Normalise_Bond_Lengths"), 78, null, null));
        JMenu menuview = new JMenu(this.translation.getProperty("View"));
        menuview.setMnemonic(86);
        menuview.add(this.MenuItem(this.translation.getProperty("Zoom_Full"), 70, null, KeyStroke.getKeyStroke(48, 2)));
        menuview.add(this.MenuItem(this.translation.getProperty("Zoom_In"), 73, null, KeyStroke.getKeyStroke(61, 2)));
        menuview.add(this.MenuItem(this.translation.getProperty("Zoom_Out"), 79, null, KeyStroke.getKeyStroke(45, 2)));
        menuview.addSeparator();
        ButtonGroup showBG = new ButtonGroup();
        menuview.add(this.RadioMenuItem(this.translation.getProperty("Show_Elements"), 69, true, showBG));
        menuview.add(this.RadioMenuItem(this.translation.getProperty("Show_All_Elements"), 65, false, showBG));
        menuview.add(this.RadioMenuItem(this.translation.getProperty("Show_Indices"), 73, false, showBG));
        menuview.add(this.RadioMenuItem(this.translation.getProperty("Show_Ring_ID"), 82, false, showBG));
        menuview.add(this.RadioMenuItem(this.translation.getProperty("Show_CIP_Priority"), 67, false, showBG));
        menuview.add(this.RadioMenuItem(this.translation.getProperty("Show_Mapping_Number"), 77, false, showBG));
        JMenu menutool = new JMenu(this.translation.getProperty("Tool"));
        menutool.setMnemonic(84);
        menutool.add(this.MenuItem(this.translation.getProperty("Cursor"), 67, this.toolIcons[0], KeyStroke.getKeyStroke(27, 0)));
        menutool.add(this.MenuItem(this.translation.getProperty("Rotator"), 82, this.toolIcons[1], KeyStroke.getKeyStroke(82, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Erasor"), 69, this.toolIcons[2], KeyStroke.getKeyStroke(68, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Edit_Atom"), 65, this.toolIcons[4], KeyStroke.getKeyStroke(44, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Set_Atom"), 83, new ImageIcon(this.getClass().getResource("/images/ASelMenu.png")), KeyStroke.getKeyStroke(46, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Single_Bond"), 49, this.toolIcons[6], KeyStroke.getKeyStroke(49, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Double_Bond"), 50, this.toolIcons[7], KeyStroke.getKeyStroke(50, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Triple_Bond"), 51, this.toolIcons[8], KeyStroke.getKeyStroke(51, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Zero_Bond"), 48, this.toolIcons[9], KeyStroke.getKeyStroke(48, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Inclined_Bond"), 73, this.toolIcons[10]));
        menutool.add(this.MenuItem(this.translation.getProperty("Declined_Bond"), 68, this.toolIcons[11]));
        menutool.add(this.MenuItem(this.translation.getProperty("Unknown_Bond"), 85, this.toolIcons[12]));
        menutool.add(this.MenuItem(this.translation.getProperty("Charge"), 72, this.toolIcons[13], KeyStroke.getKeyStroke(72, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Template_Tool"), 84, this.toolIcons[16], KeyStroke.getKeyStroke(84, 2)));
        menutool.add(this.MenuItem(this.translation.getProperty("Select_Template"), 84, this.toolIcons[16], KeyStroke.getKeyStroke(84, 3)));
        JMenu menuhydr = new JMenu(this.translation.getProperty("Hydrogen"));
        menuhydr.setMnemonic(89);
        this.chkShowHydr = new JCheckBoxMenuItem(this.translation.getProperty("Show_Hydrogen"));
        this.chkShowHydr.setMnemonic(89);
        this.chkShowHydr.setSelected(true);
        this.chkShowHydr.addActionListener(this);
        menuhydr.add(this.chkShowHydr);
        menuhydr.add(this.MenuItem(this.translation.getProperty("Set_Explicit"), 69));
        menuhydr.add(this.MenuItem(this.translation.getProperty("Clear_Explicit"), 88));
        menuhydr.add(this.MenuItem(this.translation.getProperty("Zero_Explicit"), 90));
        menuhydr.add(this.MenuItem(this.translation.getProperty("Create_Actual"), 67));
        menuhydr.add(this.MenuItem(this.translation.getProperty("Delete_Actual"), 68));
        JMenu menuster = new JMenu(this.translation.getProperty("Stereochemistry"));
        menuster.setMnemonic(83);
        this.chkShowSter = new JCheckBoxMenuItem(this.translation.getProperty("Show_Stereolabels"));
        this.chkShowSter.setMnemonic(76);
        this.chkShowSter.setSelected(false);
        this.chkShowSter.addActionListener(this);
        menuster.add(this.chkShowSter);
        menuster.add(this.MenuItem(this.translation.getProperty("Invert_Stereochemistry"), 73));
        menuster.add(this.MenuItem(this.translation.getProperty("Set_RZ"), 82));
        menuster.add(this.MenuItem(this.translation.getProperty("Set_SE"), 83));
        menuster.add(this.MenuItem(this.translation.getProperty("Cycle_Wedges"), 67));
        menuster.add(this.MenuItem(this.translation.getProperty("Remove_Wedges"), 87));
        JMenu menuhelp = new JMenu(this.translation.getProperty("Help"));
        menuhelp.setMnemonic(72);
        menuhelp.add(this.MenuItem(this.translation.getProperty("About"), 65));
        menubar.add(menufile);
        menubar.add(menuedit);
        menubar.add(menuview);
        menubar.add(menutool);
        menubar.add(menuhydr);
        menubar.add(menuster);
        menubar.add(Box.createHorizontalGlue());
        menubar.add(menuhelp);
        return menubar;
    }

    public JMenuBar MenuBarApplet() {
        JMenuBar menubar = new JMenuBar();
        if (this.selected_menus[0]) {
            AppletMenu menublock = new AppletMenu(this.translation.getProperty("Block"));
            menublock.setMnemonic(66);
            menublock.add(this.MenuItem(this.translation.getProperty("New"), 78, null, KeyStroke.getKeyStroke(78, 2)));
            menublock.add(this.MenuItem(this.translation.getProperty("Editttt"), 69, null, KeyStroke.getKeyStroke(32, 2)));
            menublock.add(this.MenuItem(this.translation.getProperty("Undo"), 85, null, KeyStroke.getKeyStroke(90, 2)));
            menublock.add(this.MenuItem(this.translation.getProperty("Redo"), 82, null, KeyStroke.getKeyStroke(90, 3)));
            menublock.add(this.MenuItem(this.translation.getProperty("Cut"), 88, null, KeyStroke.getKeyStroke(88, 2)));
            menublock.add(this.MenuItem(this.translation.getProperty("Copy"), 67, null, KeyStroke.getKeyStroke(67, 2)));
            menublock.add(this.MenuItem(this.translation.getProperty("Paste"), 86, null, KeyStroke.getKeyStroke(86, 2)));
            menubar.add(menublock);
        }
        if (this.selected_menus[1]) {
            AppletMenu menuselect = new AppletMenu(this.translation.getProperty("Select"));
            menuselect.setMnemonic(83);
            menuselect.add(this.MenuItem(this.translation.getProperty("Select_All"), 83, null, KeyStroke.getKeyStroke(65, 2)));
            menuselect.add(this.MenuItem(this.translation.getProperty("Next_Atom"), 78, null, KeyStroke.getKeyStroke(69, 2)));
            menuselect.add(this.MenuItem(this.translation.getProperty("Previous_Atom"), 80, null, KeyStroke.getKeyStroke(69, 3)));
            menuselect.add(this.MenuItem(this.translation.getProperty("Next_Group"), 71, null, KeyStroke.getKeyStroke(71, 2)));
            menuselect.add(this.MenuItem(this.translation.getProperty("Previous_Group"), 82, null, KeyStroke.getKeyStroke(71, 3)));
            menubar.add(menuselect);
        }
        if (this.selected_menus[2]) {
            AppletMenu menutransform = new AppletMenu(this.translation.getProperty("Transform"));
            menutransform.setMnemonic(84);
            menutransform.add(this.MenuItem(this.translation.getProperty("Flip_Horizontal"), 72, null, null));
            menutransform.add(this.MenuItem(this.translation.getProperty("Flip_Vertical"), 86, null, null));
            menutransform.add(this.MenuItem(this.translation.getProperty("Rotate_P45"), 52, null, null));
            menutransform.add(this.MenuItem(this.translation.getProperty("Rotate_M45"), 53, null, null));
            menutransform.add(this.MenuItem(this.translation.getProperty("Rotate_P90"), 57, null, null));
            menutransform.add(this.MenuItem(this.translation.getProperty("Rotate_M90"), 48, null, null));
            menutransform.addSeparator();
            menutransform.add(this.MenuItem(this.translation.getProperty("Add_Temporary_Template"), 84, null, null));
            menutransform.add(this.MenuItem(this.translation.getProperty("Normalise_Bond_Lengths"), 78, null, null));
            menubar.add(menutransform);
        }
        if (this.selected_menus[3]) {
            AppletMenu menuzoom = new AppletMenu(this.translation.getProperty("Zoom"));
            menuzoom.setMnemonic(90);
            menuzoom.add(this.MenuItem(this.translation.getProperty("Zoom_Full"), 70, null, KeyStroke.getKeyStroke(48, 2)));
            menuzoom.add(this.MenuItem(this.translation.getProperty("Zoom_In"), 73, null, KeyStroke.getKeyStroke(61, 2)));
            menuzoom.add(this.MenuItem(this.translation.getProperty("Zoom_Out"), 79, null, KeyStroke.getKeyStroke(45, 2)));
            menubar.add(menuzoom);
        }
        if (this.selected_menus[4]) {
            AppletMenu menushow = new AppletMenu(this.translation.getProperty("Show"));
            menushow.setMnemonic(79);
            ButtonGroup showBG = new ButtonGroup();
            menushow.add(this.RadioMenuItem(this.translation.getProperty("Show_Elements"), 69, true, showBG));
            menushow.add(this.RadioMenuItem(this.translation.getProperty("Show_All_Elements"), 65, false, showBG));
            menushow.add(this.RadioMenuItem(this.translation.getProperty("Show_Indices"), 73, false, showBG));
            menushow.add(this.RadioMenuItem(this.translation.getProperty("Show_Ring_ID"), 82, false, showBG));
            menushow.add(this.RadioMenuItem(this.translation.getProperty("Show_CIP_Priority"), 67, false, showBG));
            menushow.add(this.RadioMenuItem(this.translation.getProperty("Show_Mapping_Number"), 77, false, showBG));
            menubar.add(menushow);
        }
        if (this.selected_menus[5]) {
            AppletMenu menuhydrogen = new AppletMenu(this.translation.getProperty("Hydrogen"));
            menuhydrogen.setMnemonic(72);
            if (viewH) {
                this.chkShowHydr = new JCheckBoxMenuItem(this.translation.getProperty("Show_Hydrogen"));
                this.chkShowHydr.setMnemonic(89);
                this.chkShowHydr.setSelected(true);
                this.chkShowHydr.addActionListener(this);
                menuhydrogen.add(this.chkShowHydr);
            }
            menuhydrogen.add(this.MenuItem(this.translation.getProperty("Set_Explicit"), 69));
            menuhydrogen.add(this.MenuItem(this.translation.getProperty("Clear_Explicit"), 88));
            menuhydrogen.add(this.MenuItem(this.translation.getProperty("Zero_Explicit"), 90));
            menuhydrogen.add(this.MenuItem(this.translation.getProperty("Create_Actual"), 67));
            menuhydrogen.add(this.MenuItem(this.translation.getProperty("Delete_Actual"), 68));
            menubar.add(menuhydrogen);
        }
        if (this.selected_menus[6]) {
            AppletMenu menustereo = new AppletMenu(this.translation.getProperty("Stereo"));
            menustereo.setMnemonic(69);
            this.chkShowSter = new JCheckBoxMenuItem(this.translation.getProperty("Show_Stereolabels"));
            this.chkShowSter.setMnemonic(76);
            this.chkShowSter.setSelected(false);
            this.chkShowSter.addActionListener(this);
            menustereo.add(this.chkShowSter);
            menustereo.add(this.MenuItem(this.translation.getProperty("Invert_Stereochemistry"), 73));
            menustereo.add(this.MenuItem(this.translation.getProperty("Set_RZ"), 82));
            menustereo.add(this.MenuItem(this.translation.getProperty("Set_SE"), 83));
            menustereo.add(this.MenuItem(this.translation.getProperty("Cycle_Wedges"), 67));
            menustereo.add(this.MenuItem(this.translation.getProperty("Remove_Wedges"), 87));
            menubar.add(menustereo);
        }
        if (this.selected_menus[7]) {
            AppletMenu menuhelp = new AppletMenu(this.translation.getProperty("Help"));
            menuhelp.setMnemonic(80);
            menuhelp.add(this.MenuItem(this.translation.getProperty("About"), 65));
            menubar.add(menuhelp);
        }
        return menubar;
    }

    public Molecule MolData() {
        return this.editor.MolData();
    }

    public void SetMolecule(Molecule Mol) {
        this.editor.Replace(Mol);
        this.editor.ScaleToFit();
        this.editor.NormaliseBondLengths();
        this.editor.NotifySaved();
    }

    public void AddMolecule(Molecule Mol) {
        this.editor.AddArbitraryFragment(Mol);
        this.editor.NormaliseBondLengths();
        this.editor.ScaleToFit();
        this.editor.NotifySaved();
    }

    public void ScaleToFit() {
        this.editor.ScaleToFit();
    }

    JMenuItem MenuItem(String txt, int key) {
        return this.MenuItem(txt, key, null, null);
    }

    JMenuItem MenuItem(String txt, int key, Icon icon) {
        return this.MenuItem(txt, key, icon, null);
    }

    JMenuItem MenuItem(String txt, int key, Icon icon, KeyStroke accel) {
        JMenuItem mi = new JMenuItem(txt, key);
        mi.addActionListener(this);
        if (icon != null) {
            mi.setIcon(icon);
        }
        if (accel != null) {
            mi.setAccelerator(accel);
        }
        return mi;
    }

    JRadioButtonMenuItem RadioMenuItem(String txt, int key, boolean sel, ButtonGroup bg) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(txt, sel);
        mi.addActionListener(this);
        mi.setMnemonic(key);
        bg.add(mi);
        return mi;
    }

    void FileQuit() {
        if (!this.streamMode) {
            if (this.editor.IsDirty()) {
                Object[] opt = new String[]{"Yes", "No"};
                if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Current_structure_has_been_modified"), this.translation.getProperty("Quit"), 0, 0, null, opt, opt[0]) != 0) {
                    return;
                }
            }
        } else {
            this.WriteStream();
        }
        if (this.frameParent != null) {
            this.frameParent.dispose();
        }
    }

    void FileNew() {
        if (this.editor.MolData().NumAtoms() > 0) {
            Object[] opt = new String[]{this.translation.getProperty("Yes"), this.translation.getProperty("No")};
            if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Clear_current_structure_and_start_anew"), this.translation.getProperty("New"), 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        this.editor.Clear();
        this.filename = null;
        if (this.frameParent != null) {
            this.frameParent.setTitle("WIMSchem");
        }
        this.editor.NotifySaved();
    }

    void FileNewWindow() {
        MainWindow mw = new MainWindow(null, false, this.translation);
        mw.setVisible(true);
    }

    void FileNewDataSheet() {
        DataWindow dw = new DataWindow(null);
        dw.setVisible(true);
    }

    void FileOpen() {
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter(this.translation.getProperty("Molecular_Structures"), ".el;.mol;.sdf;*.xml"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showOpenDialog(this.frameParent) != 0) {
            return;
        }
        boolean fresh = this.editor.IsEmpty();
        String newfn = chooser.getSelectedFile().getPath();
        boolean anything = this.editor.MolData().NumAtoms() > 0;
        try {
            FileInputStream istr = new FileInputStream(newfn);
            if (DataSheetStream.ExamineIsXMLDS(istr) || DataSheetStream.ExamineIsMDLSDF(istr)) {
                istr.close();
                DataWindow dw = new DataWindow(newfn);
                dw.setVisible(true);
            } else {
                Molecule frag = MoleculeStream.ReadUnknown(istr);
                this.editor.AddArbitraryFragment(frag);
                this.editor.NormaliseBondLengths();
                istr.close();
                if (fresh) {
                    this.SetFilename(newfn);
                }
                if (!anything) {
                    this.editor.NotifySaved();
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Open_Failed"), 0);
            return;
        }
    }

    void FileSave() {
        if (this.filename == null) {
            this.FileSaveAs();
            return;
        }
        this.SaveCurrent();
    }

    void FileSaveAs() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter(this.translation.getProperty("WIMSchem_Files"), ".el"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".el";
        }
        if ((newf = new File(fn)).exists()) {
            Object[] opt = new String[]{this.translation.getProperty("Yes"), this.translation.getProperty("No")};
            if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Overwrite_existing_file") + " [" + newf.getName() + "]?", this.translation.getProperty("Save_As"), 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        this.SetFilename(fn);
        this.SaveCurrent();
    }

    void FileExportNative2JavaScript() {
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        File newf = new File(fn);
        if (newf.exists()) {
            Object[] opt = new String[]{this.translation.getProperty("Yes"), this.translation.getProperty("No")};
            if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Overwrite_existing_file") + " [" + newf.getName() + "]?", this.translation.getProperty("Export_MDL_MOL"), 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            MoleculeStream.WriteNative2JavaScript(ostr, this.editor.MolData());
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Export_Failed"), 0);
        }
    }

    void FileExportMDLMol2JavaScript() {
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        File newf = new File(fn);
        if (newf.exists()) {
            Object[] opt = new String[]{this.translation.getProperty("Yes"), this.translation.getProperty("No")};
            if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Overwrite_existing_file") + " [" + newf.getName() + "]?", this.translation.getProperty("Export_MDL_MOL"), 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            MoleculeStream.WriteMDLMol2JavaScript(ostr, this.editor.MolData());
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Export_Failed"), 0);
        }
    }

    void FileExportMDLMOL() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter(this.translation.getProperty("MDL_MOL_Files"), ".mol"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".mol";
        }
        if ((newf = new File(fn)).exists()) {
            Object[] opt = new String[]{this.translation.getProperty("Yes"), this.translation.getProperty("No")};
            if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Overwrite_existing_file") + " [" + newf.getName() + "]?", this.translation.getProperty("Export_MDL_MOL"), 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            MoleculeStream.WriteMDLMOL(ostr, this.editor.MolData());
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Export_Failed"), 0);
        }
    }

    void FileExportCMLXML() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter(this.translation.getProperty("XML_Files"), ".xml"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".xml";
        }
        if ((newf = new File(fn)).exists()) {
            Object[] opt = new String[]{this.translation.getProperty("Yes"), this.translation.getProperty("No")};
            if (JOptionPane.showOptionDialog(null, this.translation.getProperty("Overwrite_existing_file") + " [" + newf.getName() + "]?", this.translation.getProperty("Export_CML_XML"), 0, 0, null, opt, opt[0]) != 0) {
                return;
            }
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            MoleculeStream.WriteCMLXML(ostr, this.editor.MolData());
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Export_Failed"), 0);
        }
    }

    void SetFilename(String fn) {
        if (fn.length() == 0) {
            this.filename = null;
            return;
        }
        this.filename = fn;
        if (!this.streamMode) {
            String chopfn = fn;
            int i = chopfn.lastIndexOf("/");
            if (i >= 0) {
                chopfn = chopfn.substring(i + 1);
            }
            if (this.frameParent != null) {
                this.frameParent.setTitle(chopfn + " - WIMSchem");
            }
        } else if (this.frameParent != null) {
            this.frameParent.setTitle("WIMSchem");
        }
    }

    void SaveCurrent() {
        try {
            FileOutputStream ostr = new FileOutputStream(this.filename);
            MoleculeStream.WriteNative(ostr, this.editor.MolData());
            ostr.close();
            this.editor.NotifySaved();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Save_Failed"), 0);
        }
    }

    void ReadStream() {
        try {
            Molecule frag = MoleculeStream.ReadUnknown(System.in);
            this.editor.AddArbitraryFragment(frag);
            this.editor.NormaliseBondLengths();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("stdin_Read_Failed"), 0);
            return;
        }
    }

    void WriteStream() {
        Molecule mol = this.editor.MolData();
        try {
            MoleculeStream.WriteMDLMOL(System.out, mol);
            MoleculeStream.WriteNative(System.out, mol);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("stdout_Write_Failed"), 0);
        }
    }

    void TestMol() {
        Molecule mol = new Molecule();
        mol.AddAtom("N", 0.0, 0.0);
        mol.AddAtom("C", 1.2, 0.0);
        mol.AddAtom("O", 2.0, 0.8);
        mol.AddAtom("H", 3.0, -0.8);
        mol.AddAtom("H", 4.0, 0.0);
        mol.AddBond(1, 2, 1);
        mol.AddBond(2, 3, 2);
        mol.AddBond(3, 4, 1);
        mol.AddBond(4, 5, 0);
        this.editor.Replace(mol);
    }

    void EditCut() {
        Molecule frag = this.editor.SelectedSubgraph();
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.WriteMDLMOL(bw, frag);
            MoleculeStream.WriteNative(bw, frag);
            if (this.useLocalClipboard) {
                this.appletClipboard = sw.toString();
            } else {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(sw.toString()), this);
            }
            this.editor.DeleteSelected();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Cut_Failed"), 0);
        }
    }

    void EditCopy() {
        Molecule frag = this.editor.SelectedSubgraph();
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.WriteMDLMOL(bw, frag);
            MoleculeStream.WriteNative(bw, frag);
            if (this.useLocalClipboard) {
                this.appletClipboard = sw.toString();
            } else {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(sw.toString()), this);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Copy_Failed"), 0);
        }
    }

    void EditPaste() {
        try {
            Molecule frag;
            String cliptext = null;
            if (this.useLocalClipboard) {
                cliptext = this.appletClipboard;
            } else {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = clip.getContents(null);
                if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    cliptext = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
            }
            if (cliptext != null && (frag = MoleculeStream.ReadUnknown(new BufferedReader(new StringReader(cliptext)))) != null) {
                this.editor.AddArbitraryFragment(frag);
            }
        }
        catch (UnsupportedFlavorException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Clipboard_Read_Failed"), 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), this.translation.getProperty("Paste_Failed"), 0);
        }
    }

    void SelectElement(String El) {
        if (this.lastElement != null) {
            if (this.lastElement.compareTo(El) == 0) {
                return;
            }
            this.toolIcons[5] = new ImageIcon(this.getClass().getResource("/images/" + this.IMAGE_TOOL[5] + ".png"));
        }
        int w = this.toolIcons[5].getImage().getWidth(null);
        int h = this.toolIcons[5].getImage().getHeight(null);
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(new Color(0, true));
        g.fillRect(0, 0, w, h);
        g.drawImage(this.toolIcons[5].getImage(), 0, 0, null);
        Font font = new Font("SansSerif", 0, El.length() == 1 ? 20 : 14);
        g.setFont(font);
        g.setColor(new Color(0, 192, 0));
        FontMetrics metrics = g.getFontMetrics();
        g.drawString(El, (w - metrics.stringWidth(El)) / 2 - 3, (h + metrics.getAscent()) / 2 - 2);
        this.toolButtons[5].setIcon(new ImageIcon(img));
        this.lastElement = El;
    }

    void TemplateTool() {
        if (this.lastTemplate == null) {
            this.TemplateSelect();
            return;
        }
        this.editor.SetToolTemplate(this.lastTemplate, this.templateIdx);
    }

    void TemplateSelect() {
        int heightFudge = this.appletMode ? 30 : 0;
        TemplateSelector sel = new TemplateSelector(this.templ, this, heightFudge);
        Point pos = this.toolButtons[16].getLocationOnScreen();
        Dimension ssz = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getScreenDevices()[0].getConfigurations()[0];
        ssz.width -= Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).right;
        ssz.height -= Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).bottom;
        if (pos.x + sel.getWidth() > ssz.width) {
            pos.x = ssz.width - sel.getWidth();
        }
        if (pos.y + sel.getHeight() > ssz.height) {
            pos.y = ssz.height - sel.getHeight();
        }
        sel.setLocation(pos);
        sel.setVisible(true);
    }

    void TemplateAddTo() {
        this.templ.AddTemplate(this.editor.SelectedSubgraph());
    }

    void EditDialog() {
        Molecule newMol = new DialogEdit((Frame)this.frameParent, this.editor.MolData(), this.editor.SelectedIndices()).exec();
        if (newMol != null) {
            this.editor.CacheUndo();
            this.editor.Replace(newMol, false);
        }
    }

    void HelpAbout() {
        String msg = "        WIMSchem v" + VERSION + "           \n" + "                                        \n" + "   Molecule drawing tool for WIMS       \n" + "   [ the Interactive Education Server ] \n" + "   http://wims.unice.fr/wims/wims.cgi?  \n" + "   A slightly modified version of:      \n" + "                                        \n" + "      SketchEl  version1.19             \n" + "   \u00a9 2005-2008 Dr. Alex M. Clark        \n" + "   Released under the Gnu Public        \n" + "   License (GPL), see www.gnu.org       \n" + "   Home page and documentation:         \n" + "   http://sketchel.sf.net               \n";
        JOptionPane.showMessageDialog(null, msg, this.translation.getProperty("About_WIMSchem"), 1, this.mainLogo);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        int setsel = -1;
        if (cmd.equals(this.translation.getProperty("Quit")) || cmd.equals(this.translation.getProperty("Save_and_Quit"))) {
            this.FileQuit();
        } else if (cmd.equals(this.translation.getProperty("New"))) {
            this.FileNew();
        } else if (cmd.equals(this.translation.getProperty("New_Window"))) {
            this.FileNewWindow();
        } else if (cmd.equals(this.translation.getProperty("New_DataSheet"))) {
            this.FileNewDataSheet();
        } else if (cmd.equals(this.translation.getProperty("Open"))) {
            this.FileOpen();
        } else if (cmd.equals(this.translation.getProperty("Save"))) {
            this.FileSave();
        } else if (cmd.equals(this.translation.getProperty("Save_As"))) {
            this.FileSaveAs();
        } else if (cmd.equals(this.translation.getProperty("as_MDL_MOL"))) {
            this.FileExportMDLMOL();
        } else if (cmd.equals(this.translation.getProperty("as_CML_XML"))) {
            this.FileExportCMLXML();
        } else if (cmd.equals("Native2Javascript (wims)")) {
            this.FileExportNative2JavaScript();
        } else if (cmd.equals("MDLMol2Javascript (wims)")) {
            this.FileExportMDLMol2JavaScript();
        } else if (cmd.equals(this.translation.getProperty("Cursor")) || e.getSource() == this.toolButtons[0]) {
            this.editor.SetToolCursor();
            setsel = 0;
        } else if (cmd.equals(this.translation.getProperty("Rotator")) || e.getSource() == this.toolButtons[1]) {
            this.editor.SetToolRotator();
            setsel = 1;
        } else if (cmd.equals(this.translation.getProperty("Erasor")) || e.getSource() == this.toolButtons[2]) {
            this.editor.SetToolErasor();
            setsel = 2;
        } else if (cmd.equals(this.translation.getProperty("Editttt")) || e.getSource() == this.toolButtons[3]) {
            this.EditDialog();
        } else if (cmd.equals(this.translation.getProperty("Select_All"))) {
            this.editor.SelectAll();
        } else if (cmd.equals(this.translation.getProperty("Next_Atom"))) {
            this.editor.CycleSelection(true, false);
        } else if (cmd.equals(this.translation.getProperty("Previous_Atom"))) {
            this.editor.CycleSelection(false, false);
        } else if (cmd.equals(this.translation.getProperty("Next_Group"))) {
            this.editor.CycleSelection(true, true);
        } else if (cmd.equals(this.translation.getProperty("Previous_Group"))) {
            this.editor.CycleSelection(false, true);
        } else if (cmd.equals(this.translation.getProperty("Edit_Atom")) || e.getSource() == this.toolButtons[4]) {
            this.editor.SetToolAtom(null);
            setsel = 4;
        } else if (cmd.equals(this.translation.getProperty("Set_Atom")) || e.getSource() == this.toolButtons[5]) {
            this.editor.SetToolAtom(this.lastElement);
            setsel = 5;
        } else if (cmd.equals(this.translation.getProperty("Single_Bond")) || e.getSource() == this.toolButtons[6]) {
            this.editor.SetToolBond(1);
            setsel = 6;
        } else if (cmd.equals(this.translation.getProperty("Double_Bond")) || e.getSource() == this.toolButtons[7]) {
            this.editor.SetToolBond(2);
            setsel = 7;
        } else if (cmd.equals(this.translation.getProperty("Triple_Bond")) || e.getSource() == this.toolButtons[8]) {
            this.editor.SetToolBond(3);
            setsel = 8;
        } else if (cmd.equals(this.translation.getProperty("Zero_Bond")) || e.getSource() == this.toolButtons[9]) {
            this.editor.SetToolBond(0);
            setsel = 9;
        } else if (cmd.equals(this.translation.getProperty("Inclined_Bond")) || e.getSource() == this.toolButtons[10]) {
            this.editor.SetToolBond(-1);
            setsel = 10;
        } else if (cmd.equals(this.translation.getProperty("Declined_Bond")) || e.getSource() == this.toolButtons[11]) {
            this.editor.SetToolBond(-2);
            setsel = 11;
        } else if (cmd.equals(this.translation.getProperty("Unknown_Bond")) || e.getSource() == this.toolButtons[12]) {
            this.editor.SetToolBond(-3);
            setsel = 12;
        } else if (cmd.equals(this.translation.getProperty("Charge")) || e.getSource() == this.toolButtons[13]) {
            this.editor.SetToolCharge(1);
            setsel = 13;
        } else if (cmd.equals(this.translation.getProperty("Undo")) || e.getSource() == this.toolButtons[14]) {
            this.editor.Undo();
        } else if (cmd.equals(this.translation.getProperty("Redo")) || e.getSource() == this.toolButtons[15]) {
            this.editor.Redo();
        } else if (cmd.equals(this.translation.getProperty("Cut"))) {
            this.EditCut();
        } else if (cmd.equals(this.translation.getProperty("Copy"))) {
            this.EditCopy();
        } else if (cmd.equals(this.translation.getProperty("Paste"))) {
            this.EditPaste();
        } else if (cmd.equals(this.translation.getProperty("Flip_Horizontal"))) {
            this.editor.FlipSelectedAtoms(false);
        } else if (cmd.equals(this.translation.getProperty("Flip_Vertical"))) {
            this.editor.FlipSelectedAtoms(true);
        } else if (cmd.equals(this.translation.getProperty("Rotate_P45"))) {
            this.editor.RotateSelectedAtoms(45.0);
        } else if (cmd.equals(this.translation.getProperty("Rotate_M45"))) {
            this.editor.RotateSelectedAtoms(-45.0);
        } else if (cmd.equals(this.translation.getProperty("Rotate_P90"))) {
            this.editor.RotateSelectedAtoms(90.0);
        } else if (cmd.equals(this.translation.getProperty("Rotate_M90"))) {
            this.editor.RotateSelectedAtoms(-90.0);
        } else if (cmd.equals(this.translation.getProperty("Add_Temporary_Template"))) {
            this.TemplateAddTo();
        } else if (cmd.equals(this.translation.getProperty("Normalise_Bond_Lengths"))) {
            this.editor.NormaliseBondLengths();
        } else if (cmd.equals(this.translation.getProperty("Template_Tool")) || e.getSource() == this.toolButtons[16]) {
            this.TemplateTool();
            setsel = 16;
        } else if (cmd.equals(this.translation.getProperty("Select_Template"))) {
            this.TemplateSelect();
            setsel = 16;
        } else if (cmd.equals(this.translation.getProperty("Zoom_Full"))) {
            this.editor.ZoomFull();
        } else if (cmd.equals(this.translation.getProperty("Zoom_In"))) {
            this.editor.ZoomIn(1.5);
        } else if (cmd.equals(this.translation.getProperty("Zoom_Out"))) {
            this.editor.ZoomOut(1.5);
        } else if (cmd.equals(this.translation.getProperty("Show_Elements"))) {
            this.editor.SetShowMode(0);
        } else if (cmd.equals(this.translation.getProperty("Show_All_Elements"))) {
            this.editor.SetShowMode(1);
        } else if (cmd.equals(this.translation.getProperty("Show_Indices"))) {
            this.editor.SetShowMode(2);
        } else if (cmd.equals(this.translation.getProperty("Show_Ring_ID"))) {
            this.editor.SetShowMode(3);
        } else if (cmd.equals(this.translation.getProperty("Show_CIP_Priority"))) {
            this.editor.SetShowMode(4);
        } else if (cmd.equals(this.translation.getProperty("Show_Mapping_Number"))) {
            this.editor.SetShowMode(5);
        } else if (cmd.equals(this.translation.getProperty("Show_Hydrogen"))) {
            this.editor.SetShowHydrogens(this.chkShowHydr.isSelected());
        } else if (cmd.equals(this.translation.getProperty("Set_Explicit"))) {
            this.editor.HydrogenSetExplicit(true);
        } else if (cmd.equals(this.translation.getProperty("Clear_Explicit"))) {
            this.editor.HydrogenSetExplicit(false);
        } else if (cmd.equals(this.translation.getProperty("Zero_Explicit"))) {
            this.editor.HydrogenSetExplicit(false, 0);
        } else if (cmd.equals(this.translation.getProperty("Create_Actual"))) {
            this.editor.HydrogenCreateActual();
        } else if (cmd.equals(this.translation.getProperty("Delete_Actual"))) {
            this.editor.HydrogenDeleteActual();
        } else if (cmd.equals(this.translation.getProperty("Show_Stereolabels"))) {
            this.editor.SetShowStereolabels(this.chkShowSter.isSelected());
        } else if (cmd.equals(this.translation.getProperty("Invert_Stereochemistry"))) {
            this.editor.SetStereo(3);
        } else if (cmd.equals(this.translation.getProperty("Set_RZ"))) {
            this.editor.SetStereo(1);
        } else if (cmd.equals(this.translation.getProperty("Set_SE"))) {
            this.editor.SetStereo(2);
        } else if (cmd.equals(this.translation.getProperty("Cycle_Wedges"))) {
            this.editor.CycleChiralWedges();
        } else if (cmd.equals(this.translation.getProperty("Remove_Wedges"))) {
            this.editor.RemoveChiralWedges();
        } else if (cmd.equals(this.translation.getProperty("About"))) {
            this.HelpAbout();
        } else if (cmd.length() <= 2) {
            this.SelectElement(cmd);
            this.editor.SetToolAtom(this.lastElement);
        }
        if (setsel != -1) {
            this.toolGroup.setSelected(this.toolButtons[setsel].getModel(), true);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.toolButtons[5] && e.getButton() == 3) {
            this.toolButtons[5].setSelected(true);
            JPopupMenu popup = new JPopupMenu();
            if (this.my_atoms == null) {
                popup.add(this.MenuItem("C", 0));
                popup.add(this.MenuItem("H", 0));
                popup.add(this.MenuItem("O", 0));
                popup.add(this.MenuItem("N", 0));
                popup.add(this.MenuItem("S", 0));
                popup.add(this.MenuItem("P", 0));
                popup.add(this.MenuItem("Li", 0));
                popup.add(this.MenuItem("Na", 0));
                popup.add(this.MenuItem("K", 0));
                popup.add(this.MenuItem("Mg", 0));
                popup.add(this.MenuItem("Ca", 0));
                popup.add(this.MenuItem("Ti", 0));
                popup.add(this.MenuItem("Zr", 0));
                popup.add(this.MenuItem("Cr", 0));
                popup.add(this.MenuItem("Mo", 0));
                popup.add(this.MenuItem("Mn", 0));
                popup.add(this.MenuItem("Fe", 0));
                popup.add(this.MenuItem("Cu", 0));
                popup.add(this.MenuItem("Zn", 0));
                popup.add(this.MenuItem("Ag", 0));
                popup.add(this.MenuItem("Hg", 0));
                popup.add(this.MenuItem("Al", 0));
                popup.add(this.MenuItem("Si", 0));
                popup.add(this.MenuItem("F", 0));
                popup.add(this.MenuItem("Cl", 0));
                popup.add(this.MenuItem("Br", 0));
                popup.add(this.MenuItem("I", 0));
            } else {
                for (int p = 0; p < this.my_atoms.length; ++p) {
                    popup.add(this.MenuItem(this.my_atoms[p], 0));
                }
            }
            popup.show(this.toolButtons[5], 0, 0);
        }
        if (e.getSource() == this.toolButtons[16] && e.getButton() == 3) {
            this.toolGroup.setSelected(this.toolButtons[16].getModel(), true);
            this.TemplateSelect();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (!(e.isAltDown() || e.isShiftDown() || e.isControlDown() || e.isMetaDown())) {
            if (e.getKeyCode() == 38) {
                this.editor.NudgeSelectedAtoms(0.0, 0.05);
                return;
            }
            if (e.getKeyCode() == 40) {
                this.editor.NudgeSelectedAtoms(0.0, -0.05);
                return;
            }
            if (e.getKeyCode() == 37) {
                this.editor.NudgeSelectedAtoms(-0.05, 0.0);
                return;
            }
            if (e.getKeyCode() == 39) {
                this.editor.NudgeSelectedAtoms(0.05, 0.0);
                return;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch >= 'A' && ch <= 'Z') {
            this.typedElement = "" + ch;
        } else if (this.typedElement.length() == 1 && ch >= 'a' && ch <= 'z') {
            this.typedElement = this.typedElement + ch;
        } else if (this.typedElement.compareTo("R") == 0 && ch >= '0' && ch <= '9') {
            this.typedElement = this.typedElement + ch;
        } else {
            this.typedElement = "";
            return;
        }
        String elset = null;
        if (this.typedElement.length() >= 2 && this.typedElement.charAt(0) == 'R' && this.typedElement.charAt(1) >= '0' && this.typedElement.charAt(1) <= '9') {
            elset = this.typedElement;
        } else {
            for (int n = 1; n < Molecule.ELEMENTS.length; ++n) {
                if (this.typedElement.compareTo(Molecule.ELEMENTS[n]) != 0) continue;
                elset = this.typedElement;
            }
        }
        if (elset != null) {
            this.SelectElement(elset);
            this.toolGroup.setSelected(this.toolButtons[5].getModel(), true);
            this.editor.SetToolAtom(elset);
        }
    }

    public void TemplSelected(Molecule mol, int idx) {
        this.lastTemplate = mol;
        this.templateIdx = idx;
        this.editor.SetToolTemplate(mol, idx);
    }

    public void MolSelected(EditorPane source, int idx, boolean dblclick) {
        if (dblclick && idx != 0) {
            ArrayList<Integer> selidx = new ArrayList<Integer>();
            if (idx > 0) {
                selidx.add(idx);
            } else {
                selidx.add(this.editor.MolData().BondFrom(-idx));
                selidx.add(this.editor.MolData().BondTo(-idx));
            }
            Molecule newMol = new DialogEdit((Frame)this.frameParent, this.editor.MolData(), selidx).exec();
            if (newMol != null) {
                this.editor.Replace(newMol);
            }
        }
    }

    public void DirtyChanged(boolean isdirty) {
        String str;
        String string = str = this.frameParent == null ? "WIMSchem" : this.frameParent.getTitle();
        if (str.charAt(0) == '*') {
            str = str.substring(1);
        }
        if (isdirty) {
            str = "*" + str;
        }
        if (this.frameParent != null) {
            this.frameParent.setTitle(str);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.FileQuit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        if (this.firstResize) {
            this.editor.ScaleToFit();
            this.editor.repaint();
            this.firstResize = false;
        }
        this.editor.requestFocusInWindow();
    }
}

