/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class ASCIIHexOutputStream
extends FilterOutputStream
implements FinishableOutputStream {
    private static final int MAX_CHARS_PER_LINE = 80;
    private int characters = 80;
    private boolean end = false;
    private String newline = "\n";

    public ASCIIHexOutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this.newline = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void write(int n2) throws IOException {
        String string = Integer.toHexString(n2 & 0xFF);
        switch (string.length()) {
            case 1: {
                this.writeChar(48);
                this.writeChar(string.charAt(0));
                break;
            }
            case 2: {
                this.writeChar(string.charAt(0));
                this.writeChar(string.charAt(1));
                break;
            }
            default: {
                throw new IOException("ASCIIHexOutputStream: byte '" + n2 + "' was encoded in less than 1 or more than 2 chars");
            }
        }
    }

    public void finish() throws IOException {
        if (!this.end) {
            this.end = true;
            this.writeChar(62);
            this.writeNewLine();
            this.flush();
            if (this.out instanceof FinishableOutputStream) {
                ((FinishableOutputStream)((Object)this.out)).finish();
            }
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeChar(int n2) throws IOException {
        if (this.characters == 0) {
            this.characters = 80;
            this.writeNewLine();
        }
        --this.characters;
        super.write(n2);
    }

    private void writeNewLine() throws IOException {
        for (int i2 = 0; i2 < this.newline.length(); ++i2) {
            super.write(this.newline.charAt(i2));
        }
    }
}

