/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFLocaTable;
import org.freehep.graphicsio.font.truetype.TTFMaxPTable;
import org.freehep.graphicsio.font.truetype.TTFVersionTable;

public class TTFGlyfTable
extends TTFVersionTable {
    private static final boolean READ_GLYPHS = false;
    public Glyph[] glyphs;
    private long[] offsets;

    public String getTag() {
        return "glyf";
    }

    public void readTable() throws IOException {
        this.glyphs = new Glyph[((TTFMaxPTable)this.getTable((String)"maxp")).numGlyphs];
        this.offsets = ((TTFLocaTable)this.getTable((String)"loca")).offset;
    }

    public Glyph getGlyph(int n2) throws IOException {
        if (this.glyphs[n2] != null) {
            return this.glyphs[n2];
        }
        this.ttf.pushPos();
        this.ttf.seek(this.offsets[n2]);
        short s2 = this.ttf.readShort();
        this.glyphs[n2] = s2 >= 0 ? new SimpleGlyph(s2) : new CompositeGlyph();
        this.glyphs[n2].read();
        this.ttf.popPos();
        return this.glyphs[n2];
    }

    public String toString() {
        String string = super.toString();
        for (int i2 = 0; i2 < this.glyphs.length; ++i2) {
            string = string + "\n  #" + i2 + ": " + this.glyphs[i2];
        }
        return string;
    }

    public class CompositeGlyph
    extends Glyph {
        private static final int ARGS_WORDS = 0;
        private static final int ARGS_XY = 1;
        private static final int SCALE = 3;
        private static final int XY_SCALE = 6;
        private static final int TWO_BY_TWO = 7;
        private static final int MORE_COMPONENTS = 5;
        private GeneralPath shape;
        private int noComponents;

        public String getType() {
            return "Composite Glyph";
        }

        public GeneralPath getShape() {
            return this.shape;
        }

        public void read() throws IOException {
            super.read();
            this.shape = new GeneralPath();
            this.noComponents = 0;
            boolean bl2 = true;
            while (bl2) {
                short s2;
                short s3;
                ++this.noComponents;
                TTFGlyfTable.this.ttf.readUShortFlags();
                bl2 = TTFGlyfTable.this.ttf.flagBit(5);
                int n2 = TTFGlyfTable.this.ttf.readUShort();
                if (TTFGlyfTable.this.ttf.flagBit(0)) {
                    s3 = TTFGlyfTable.this.ttf.readShort();
                    s2 = TTFGlyfTable.this.ttf.readShort();
                } else {
                    s3 = TTFGlyfTable.this.ttf.readChar();
                    s2 = TTFGlyfTable.this.ttf.readChar();
                }
                AffineTransform affineTransform = new AffineTransform();
                if (TTFGlyfTable.this.ttf.flagBit(1)) {
                    affineTransform.translate(s3, s2);
                } else {
                    System.err.println("TTFGlyfTable: ARGS_ARE_POINTS not implemented.");
                }
                if (TTFGlyfTable.this.ttf.flagBit(3)) {
                    double d2 = TTFGlyfTable.this.ttf.readF2Dot14();
                    affineTransform.scale(d2, d2);
                } else if (TTFGlyfTable.this.ttf.flagBit(6)) {
                    double d3 = TTFGlyfTable.this.ttf.readF2Dot14();
                    double d4 = TTFGlyfTable.this.ttf.readF2Dot14();
                    affineTransform.scale(d3, d4);
                } else if (TTFGlyfTable.this.ttf.flagBit(7)) {
                    System.err.println("TTFGlyfTable: WE_HAVE_A_TWO_BY_TWO not implemented.");
                }
                GeneralPath generalPath = (GeneralPath)TTFGlyfTable.this.getGlyph(n2).getShape().clone();
                generalPath.transform(affineTransform);
                this.shape.append(generalPath, false);
            }
        }

        public String toString() {
            return super.toString() + ", " + this.noComponents + " components";
        }
    }

    public abstract class Glyph {
        public int xMin;
        public int yMin;
        public int xMax;
        public int yMax;

        public abstract String getType();

        public abstract GeneralPath getShape();

        public void read() throws IOException {
            this.xMin = TTFGlyfTable.this.ttf.readFWord();
            this.yMin = TTFGlyfTable.this.ttf.readFWord();
            this.xMax = TTFGlyfTable.this.ttf.readFWord();
            this.yMax = TTFGlyfTable.this.ttf.readFWord();
        }

        public Rectangle getBBox() {
            return new Rectangle(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
        }

        public String toString() {
            return "[" + this.getType() + "] (" + this.xMin + "," + this.yMin + "):(" + this.xMax + "," + this.yMax + ")";
        }

        public String toDetailedString() {
            return this.toString();
        }
    }

    public class SimpleGlyph
    extends Glyph {
        private static final int ON_CURVE = 0;
        private static final int X_SHORT = 1;
        private static final int Y_SHORT = 2;
        private static final int REPEAT_FLAG = 3;
        private static final int X_SAME = 4;
        private static final int Y_SAME = 5;
        private static final int X_POSITIVE = 4;
        private static final int Y_POSITIVE = 5;
        public int numberOfContours;
        public int[] endPtsOfContours;
        public int[] instructions;
        public int[] flags;
        public int[] xCoordinates;
        public int[] yCoordinates;
        public boolean[] onCurve;
        public GeneralPath shape;

        public SimpleGlyph(int n2) {
            this.numberOfContours = n2;
            this.endPtsOfContours = new int[n2];
        }

        public String getType() {
            return "Simple Glyph";
        }

        public void read() throws IOException {
            int n2;
            int n3;
            int n4;
            super.read();
            for (n4 = 0; n4 < this.endPtsOfContours.length; ++n4) {
                this.endPtsOfContours[n4] = TTFGlyfTable.this.ttf.readUShort();
            }
            this.instructions = new int[TTFGlyfTable.this.ttf.readUShort()];
            for (n4 = 0; n4 < this.instructions.length; ++n4) {
                this.instructions[n4] = TTFGlyfTable.this.ttf.readByte();
            }
            n4 = this.endPtsOfContours[this.endPtsOfContours.length - 1] + 1;
            this.flags = new int[n4];
            this.xCoordinates = new int[n4];
            this.yCoordinates = new int[n4];
            this.onCurve = new boolean[n4];
            int n5 = 0;
            int n6 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                if (n5 > 0) {
                    this.flags[n3] = n6;
                    --n5;
                } else {
                    this.flags[n3] = TTFGlyfTable.this.ttf.readRawByte();
                    if (TTFInput.flagBit(this.flags[n3], 3)) {
                        n5 = TTFGlyfTable.this.ttf.readByte();
                        n6 = this.flags[n3];
                    }
                }
                TTFInput.checkZeroBit(this.flags[n3], 6, "flags");
                TTFInput.checkZeroBit(this.flags[n3], 7, "flags");
                this.onCurve[n3] = TTFInput.flagBit(this.flags[n3], 0);
            }
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (TTFInput.flagBit(this.flags[n2], 1)) {
                    if (TTFInput.flagBit(this.flags[n2], 4)) {
                        n3 = this.xCoordinates[n2] = n3 + TTFGlyfTable.this.ttf.readByte();
                        continue;
                    }
                    n3 = this.xCoordinates[n2] = n3 - TTFGlyfTable.this.ttf.readByte();
                    continue;
                }
                n3 = TTFInput.flagBit(this.flags[n2], 4) ? (this.xCoordinates[n2] = n3) : (this.xCoordinates[n2] = n3 + TTFGlyfTable.this.ttf.readShort());
            }
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (TTFInput.flagBit(this.flags[n2], 2)) {
                    if (TTFInput.flagBit(this.flags[n2], 5)) {
                        n3 = this.yCoordinates[n2] = n3 + TTFGlyfTable.this.ttf.readByte();
                        continue;
                    }
                    n3 = this.yCoordinates[n2] = n3 - TTFGlyfTable.this.ttf.readByte();
                    continue;
                }
                n3 = TTFInput.flagBit(this.flags[n2], 5) ? (this.yCoordinates[n2] = n3) : (this.yCoordinates[n2] = n3 + TTFGlyfTable.this.ttf.readShort());
            }
        }

        public String toString() {
            String string = super.toString() + ", " + this.numberOfContours + " contours, endPts={";
            for (int i2 = 0; i2 < this.numberOfContours; ++i2) {
                string = string + (i2 == 0 ? "" : ",") + this.endPtsOfContours[i2];
            }
            string = string + "}, " + this.instructions.length + " instructions";
            return string;
        }

        public String toDetailedString() {
            String string = this.toString() + "\n  instructions = {";
            for (int i2 = 0; i2 < this.instructions.length; ++i2) {
                string = string + Integer.toHexString(this.instructions[i2]) + " ";
            }
            return string + "}";
        }

        public GeneralPath getShape() {
            if (this.shape != null) {
                return this.shape;
            }
            this.shape = new GeneralPath(1);
            int n2 = 0;
            for (int i2 = 0; i2 < this.endPtsOfContours.length; ++i2) {
                int n3 = n2++;
                this.shape.moveTo(this.xCoordinates[n3], this.yCoordinates[n3]);
                boolean bl2 = true;
                while (n2 <= this.endPtsOfContours[i2]) {
                    if (this.onCurve[n2]) {
                        if (bl2) {
                            this.shape.lineTo(this.xCoordinates[n2], this.yCoordinates[n2]);
                        } else {
                            this.shape.quadTo(this.xCoordinates[n2 - 1], this.yCoordinates[n2 - 1], this.xCoordinates[n2], this.yCoordinates[n2]);
                        }
                        bl2 = true;
                    } else {
                        if (!bl2) {
                            int n4 = this.xCoordinates[n2 - 1];
                            int n5 = this.yCoordinates[n2 - 1];
                            int n6 = (int)((double)(n4 + this.xCoordinates[n2]) / 2.0);
                            int n7 = (int)((double)(n5 + this.yCoordinates[n2]) / 2.0);
                            this.shape.quadTo(n4, n5, n6, n7);
                        }
                        bl2 = false;
                    }
                    ++n2;
                }
                if (!this.onCurve[n2 - 1]) {
                    this.shape.quadTo(this.xCoordinates[n2 - 1], this.yCoordinates[n2 - 1], this.xCoordinates[n3], this.yCoordinates[n3]);
                    continue;
                }
                if (this.xCoordinates[n2 - 1] == this.xCoordinates[n3] && this.yCoordinates[n2 - 1] == this.yCoordinates[n3]) continue;
                this.shape.closePath();
            }
            return this.shape;
        }
    }
}

