/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.StackOfDouble;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.functions.FunctionParserExtension;

public class WrapperFunction
extends FunctionParserExtension {
    private Function func;
    private double[] params;
    private int serialNumber;
    private WrapperFunction derivativeOf;
    private Variable derivativeVar;
    private int derivativeIndex;

    public WrapperFunction(Function function) {
        this.setFunction(function);
        this.serialNumber = 0;
    }

    private void check() {
        if (this.derivativeOf == null || this.derivativeOf.serialNumber == this.serialNumber) {
            return;
        }
        this.serialNumber = this.derivativeOf.serialNumber;
        this.func = this.derivativeVar != null ? this.derivativeOf.derivative(this.derivativeVar) : this.derivativeOf.derivative(this.derivativeIndex);
    }

    public void setFunction(Function function) {
        if (function == null) {
            throw new IllegalArgumentException("Function supplied to WrapperFunction object can't be null.");
        }
        if (this.func != null && function.getArity() != this.func.getArity()) {
            throw new IllegalArgumentException("Attempt to change the arity of a WrapperFunction.");
        }
        if (this.derivativeOf != null) {
            throw new IllegalArgumentException("Can't change the definition of a function that is a derivative of another function.");
        }
        this.func = function;
        this.params = new double[function.getArity()];
        ++this.serialNumber;
    }

    public Function getFunction() {
        return this.func;
    }

    public int getArity() {
        return this.func.getArity();
    }

    public double getVal(double[] dArray) {
        this.check();
        return this.func.getValueWithCases(dArray, null);
    }

    public double getValueWithCases(double[] dArray, Cases cases) {
        this.check();
        return this.func == null ? 1.0 : this.func.getValueWithCases(dArray, cases);
    }

    public Function derivative(int n) {
        this.check();
        WrapperFunction wrapperFunction = new WrapperFunction(this.func.derivative(n));
        wrapperFunction.derivativeOf = this;
        wrapperFunction.derivativeIndex = n;
        wrapperFunction.serialNumber = this.serialNumber;
        return wrapperFunction;
    }

    public Function derivative(Variable variable) {
        this.check();
        WrapperFunction wrapperFunction = new WrapperFunction(this.func.derivative(variable));
        wrapperFunction.derivativeOf = this;
        wrapperFunction.derivativeVar = variable;
        wrapperFunction.serialNumber = this.serialNumber;
        return wrapperFunction;
    }

    public boolean dependsOn(Variable variable) {
        this.check();
        return this.func.dependsOn(variable);
    }

    public void apply(StackOfDouble stackOfDouble, Cases cases) {
        this.check();
        int n = this.params.length - 1;
        while (n >= 0) {
            this.params[n] = stackOfDouble.pop();
            --n;
        }
        stackOfDouble.push(this.getValueWithCases(this.params, cases));
    }
}

