/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.functions;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DisplayCanvas;
import edu.hws.jcm.draw.Drawable;
import edu.hws.jcm.functions.TableFunction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TableFunctionGraph
extends Drawable
implements MouseListener,
MouseMotionListener {
    private TableFunction function;
    private boolean showPoints;
    private boolean interactive;
    private Computable onDrag;
    private Computable onFinishDrag;
    private Color color;
    private int dragPoint = -1;
    private int startX;
    private int startY;
    private int prevY;
    private boolean moved;

    public TableFunctionGraph() {
        this(null);
    }

    public TableFunctionGraph(TableFunction tableFunction) {
        this.function = tableFunction;
        this.color = Color.magenta;
        this.showPoints = true;
    }

    public void setFunction(TableFunction tableFunction) {
        this.function = tableFunction;
        this.needsRedraw();
    }

    public TableFunction getFunction() {
        return this.function;
    }

    public void setOnDrag(Computable computable) {
        this.onDrag = computable;
    }

    public Computable getOnDrag() {
        return this.onDrag;
    }

    public void setOnFinishDrag(Computable computable) {
        this.onFinishDrag = computable;
    }

    public Computable getOnFinishDrag() {
        return this.onFinishDrag;
    }

    public void setInteractive(boolean bl) {
        if (this.interactive == bl) {
            return;
        }
        if (this.interactive && this.canvas != null) {
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
        }
        this.interactive = bl;
        if (this.interactive && this.canvas != null) {
            this.canvas.addMouseListener(this);
            this.canvas.addMouseMotionListener(this);
        }
    }

    public boolean getInteractive() {
        return this.interactive;
    }

    public void setShowPoints(boolean bl) {
        this.showPoints = bl;
        this.needsRedraw();
    }

    public boolean getShowPoints() {
        return this.showPoints;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
            this.needsRedraw();
        }
    }

    public Color getColor() {
        return this.color;
    }

    protected void setOwnerData(DisplayCanvas displayCanvas, CoordinateRect coordinateRect) {
        if (this.interactive && this.canvas != null) {
            displayCanvas.removeMouseListener(this);
            displayCanvas.removeMouseMotionListener(this);
        }
        super.setOwnerData(displayCanvas, coordinateRect);
        if (this.interactive && this.canvas != null) {
            displayCanvas.addMouseListener(this);
            displayCanvas.addMouseMotionListener(this);
        }
    }

    public void setFunctionStyle(int n) {
        if (this.function != null && this.function.getStyle() != n) {
            this.function.setStyle(n);
            this.needsRedraw();
        }
    }

    public void draw(Graphics graphics, boolean bl) {
        int n;
        int n2;
        double d;
        double d2;
        if (this.function == null || this.coords == null) {
            return;
        }
        int n3 = this.function.getPointCount();
        if (n3 == 0) {
            return;
        }
        double d3 = this.coords.pixelToX(this.coords.getLeft());
        double d4 = this.coords.pixelToX(this.coords.getLeft() + this.coords.getWidth());
        if (this.function.getX(0) > d4 || this.function.getX(n3 - 1) < d3) {
            return;
        }
        int n4 = 0;
        while (n4 < n3 - 1 && this.function.getX(n4 + 1) <= d3) {
            ++n4;
        }
        int n5 = n3 - 1;
        while (n5 > 1 && this.function.getX(n5 - 1) >= d4) {
            --n5;
        }
        graphics.setColor(this.color);
        switch (this.function.getStyle()) {
            case 0: {
                int n6;
                double d5;
                double d6;
                if (n5 <= n4) break;
                d2 = this.function.getX(n4);
                d = this.function.getVal(d2);
                n2 = this.coords.xToPixel(d2);
                n = this.coords.yToPixel(d);
                double d7 = d4;
                if (this.function.getX(n5) < d7) {
                    d7 = this.function.getX(n5);
                }
                this.coords.xToPixel(this.function.getX(n3 - 1));
                int n7 = n2;
                while (d2 < d7) {
                    d6 = this.coords.pixelToX(n7 += 3);
                    if (d6 > d7) {
                        d6 = d7;
                    }
                    d5 = this.function.getVal(d6);
                    n6 = this.coords.yToPixel(d5);
                    graphics.drawLine(n2, n, n7, n6);
                    d2 = d6;
                    n2 = n7;
                    n = n6;
                }
                break;
            }
            case 1: {
                int n6;
                double d5;
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                d = this.function.getY(n4);
                n = this.coords.yToPixel(d);
                int n8 = n4 + 1;
                while (n8 <= n5) {
                    d6 = this.function.getX(n8);
                    n7 = this.coords.xToPixel(d6);
                    d5 = this.function.getY(n8);
                    n6 = this.coords.yToPixel(d5);
                    graphics.drawLine(n2, n, n7, n6);
                    n2 = n7;
                    n = n6;
                    ++n8;
                }
                break;
            }
            case 2: {
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                int n9 = n4;
                while (n9 <= n5) {
                    if (n9 < n5) {
                        double d8 = this.function.getX(n9 + 1);
                        d6 = (d2 + d8) / 2.0;
                        d2 = d8;
                    } else {
                        d6 = d2;
                    }
                    n7 = this.coords.xToPixel(d6);
                    d = this.function.getY(n9);
                    n = this.coords.yToPixel(d);
                    graphics.drawLine(n2, n, n7, n);
                    n2 = n7;
                    ++n9;
                }
                break;
            }
            case 3: {
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                int n10 = n4 + 1;
                while (n10 <= n5) {
                    d6 = this.function.getX(n10);
                    n7 = this.coords.xToPixel(d6);
                    d = this.function.getY(n10 - 1);
                    n = this.coords.yToPixel(d);
                    graphics.drawLine(n2, n, n7, n);
                    n2 = n7;
                    ++n10;
                }
                break;
            }
            case 4: {
                double d6;
                int n7;
                d2 = this.function.getX(n4);
                n2 = this.coords.xToPixel(d2);
                int n11 = n4 + 1;
                while (n11 <= n5) {
                    d6 = this.function.getX(n11);
                    n7 = this.coords.xToPixel(d6);
                    d = this.function.getY(n11);
                    n = this.coords.yToPixel(d);
                    graphics.drawLine(n2, n, n7, n);
                    n2 = n7;
                    ++n11;
                }
                break;
            }
        }
        if (!this.showPoints) {
            return;
        }
        int n12 = n4;
        while (n12 <= n5) {
            d2 = this.function.getX(n12);
            d = this.function.getY(n12);
            n2 = this.coords.xToPixel(d2);
            n = this.coords.yToPixel(d);
            graphics.fillOval(n2 - 2, n - 2, 5, 5);
            ++n12;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragPoint = -1;
        if (this.function == null || !this.getVisible() || this.canvas == null || this.coords == null || mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.isShiftDown() || mouseEvent.isMetaDown() || mouseEvent.isControlDown() || mouseEvent.isAltDown()) {
            return;
        }
        this.moved = false;
        int n = this.function.getPointCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.coords.xToPixel(this.function.getX(n2));
            int n4 = this.coords.yToPixel(this.function.getY(n2));
            if (mouseEvent.getX() >= n3 - 3 && mouseEvent.getX() <= n3 + 3 && mouseEvent.getY() >= n4 - 3 && mouseEvent.getY() <= n4 + 3) {
                this.startX = mouseEvent.getX();
                this.prevY = this.startY = mouseEvent.getY();
                this.dragPoint = n2;
                mouseEvent.consume();
                return;
            }
            ++n2;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragPoint == -1) {
            return;
        }
        mouseEvent.consume();
        if (!this.moved) {
            this.dragPoint = -1;
            return;
        }
        this.mouseDragged(mouseEvent);
        this.dragPoint = -1;
        if (this.onFinishDrag != null) {
            this.onFinishDrag.compute();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragPoint == -1 || this.prevY == mouseEvent.getY()) {
            return;
        }
        mouseEvent.consume();
        if (!this.moved && Math.abs(mouseEvent.getY() - this.startY) < 3) {
            return;
        }
        this.moved = true;
        int n = mouseEvent.getY();
        if (n < this.coords.getTop() + 4) {
            n = this.coords.getTop() + 4;
        } else if (n > this.coords.getTop() + this.coords.getHeight() - 4) {
            n = this.coords.getTop() + this.coords.getHeight() - 4;
        }
        if (Math.abs(mouseEvent.getX() - this.startX) > 72) {
            n = this.startY;
        }
        if (n == this.prevY) {
            return;
        }
        this.prevY = n;
        this.function.setY(this.dragPoint, this.coords.pixelToY(this.prevY));
        this.needsRedraw();
        if (this.onDrag != null) {
            this.onDrag.compute();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

