/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.ErrorReporter;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.awt.Limits;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.awt.VariableInput;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.DisplayCanvas;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.util.Vector;

public class LimitControlPanel
extends Panel
implements InputObject,
Tieable,
Limits,
ActionListener {
    public static final int SET_LIMITS = 1;
    public static final int EQUALIZE = 2;
    public static final int ZOOM_IN = 4;
    public static final int ZOOM_OUT = 8;
    public static final int SAVE = 16;
    public static final int RESTORE = 32;
    public static final int ALL_BUTTONS = 63;
    private static final String[] buttonNames = new String[]{"Set Limits", "Equalize Axes", "Zoom In", "Zoom Out", "Save Limits", "Restore Limits"};
    protected int buttons;
    protected boolean twoColumn;
    protected VariableInput xmin;
    protected VariableInput xmax;
    protected VariableInput ymin;
    protected VariableInput ymax;
    protected long serialNumber = -1L;
    protected Tie syncWith;
    protected ErrorReporter errorReporter;
    protected CoordinateRect coords;
    protected Vector items = new Vector();

    public LimitControlPanel() {
        this("xmin", "xmax", "ymin", "ymax", 1, false);
    }

    public LimitControlPanel(int n, boolean bl) {
        this("xmin", "xmax", "ymin", "ymax", n, bl);
    }

    public LimitControlPanel(String string, String string2, String string3, String string4, int n, boolean bl) {
        this.setLayout(null);
        this.enableEvents(1L);
        this.xmin = new VariableInput(string, "-5");
        this.xmax = new VariableInput(string2, "5");
        this.addRange(this.xmin, this.xmax);
        this.ymin = new VariableInput(string3, "-5");
        this.ymax = new VariableInput(string4, "5");
        this.addRange(this.ymin, this.ymax);
        this.addButtons(n);
        this.twoColumn = bl;
    }

    public void addCoords(CoordinateRect coordinateRect) {
        if (this.syncWith == null) {
            this.syncWith = new Tie(this);
        }
        this.syncWith.add(coordinateRect);
        coordinateRect.setSyncWith(this.syncWith);
        if (this.coords == null) {
            this.coords = coordinateRect;
        }
    }

    public void addCoords(DisplayCanvas displayCanvas) {
        this.addCoords(displayCanvas.getCoordinateRect());
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setUseTwoColumnsIfPossible(boolean bl) {
        this.twoColumn = bl;
    }

    public boolean getUseTwoColumnsIfPossible() {
        return this.twoColumn;
    }

    public void addComponent(Component component) {
        super.add(component);
        this.items.addElement(component);
    }

    public void addComponentPair(Component component, Component component2) {
        super.add(component);
        super.add(component2);
        this.items.addElement(new Component[]{component, component2});
    }

    public void addRange(VariableInput variableInput, VariableInput variableInput2) {
        super.add(variableInput);
        super.add(variableInput2);
        variableInput.addActionListener(this);
        variableInput2.addActionListener(this);
        this.items.addElement(new Component[]{variableInput, variableInput2, null});
    }

    public void addButtons(int n) {
        if ((n & 1) != 0 && (this.buttons & 1) == 0 && (n & 2) != 0 && (this.buttons & 2) == 0) {
            this.addComponentPair(this.makeButton(0), this.makeButton(1));
        } else if ((n & 1) != 0 && (this.buttons & 1) == 0) {
            this.addComponent(this.makeButton(0));
        } else if ((n & 2) != 0 && (this.buttons & 2) == 0) {
            this.addComponent(this.makeButton(1));
        }
        if ((n & 4) != 0 && (this.buttons & 4) == 0 && (n & 8) != 0 && (this.buttons & 8) == 0) {
            this.addComponentPair(this.makeButton(2), this.makeButton(3));
        } else if ((n & 4) != 0 && (this.buttons & 4) == 0) {
            this.addComponent(this.makeButton(2));
        } else if ((n & 8) != 0 && (this.buttons & 8) == 0) {
            this.addComponent(this.makeButton(3));
        }
        if ((n & 0x10) != 0 && (this.buttons & 0x10) == 0 && (n & 0x20) != 0 && (this.buttons & 0x20) == 0) {
            this.addComponentPair(this.makeButton(4), this.makeButton(5));
        } else if ((n & 0x10) != 0 && (this.buttons & 0x10) == 0) {
            this.addComponent(this.makeButton(4));
        } else if ((n & 0x20) != 0 && (this.buttons & 0x20) == 0) {
            this.addComponent(this.makeButton(5));
        }
        this.buttons |= n;
    }

    public Button getButton(int n) {
        int n2;
        if (n == 1) {
            n2 = 0;
        } else if (n == 2) {
            n2 = 1;
        } else if (n == 4) {
            n2 = 2;
        } else if (n == 8) {
            n2 = 3;
        } else if (n == 16) {
            n2 = 4;
        } else if (n == 32) {
            n2 = 5;
        } else {
            throw new IllegalArgumentException("Unknown button code passed to getButton().");
        }
        Button button = this.makeButton(n2);
        button.setActionCommand(buttonNames[n2]);
        return button;
    }

    private Button makeButton(int n) {
        Button button = new Button(buttonNames[n]);
        button.setBackground(Color.lightGray);
        button.addActionListener(this);
        return button;
    }

    public Component add(Component component) {
        this.addComponent(component);
        return component;
    }

    public void notifyControllerOnChange(Controller controller) {
    }

    public void checkInput() {
        try {
            boolean bl = false;
            int n = 0;
            while (n < this.items.size()) {
                Object e = this.items.elementAt(n);
                if (e instanceof Component[] && ((Component[])e).length == 3) {
                    VariableInput variableInput = (VariableInput)((Component[])e)[0];
                    VariableInput variableInput2 = (VariableInput)((Component[])e)[1];
                    double d = variableInput.getVal();
                    variableInput.checkInput();
                    double d2 = variableInput.getVal();
                    if (d != d2) {
                        bl = true;
                    }
                    d = variableInput2.getVal();
                    variableInput2.checkInput();
                    double d3 = variableInput2.getVal();
                    if (d != d3) {
                        bl = true;
                    }
                    if (d2 >= d3) {
                        throw new JCMError("The value of " + variableInput2.getName() + " must be greater than the value of " + variableInput.getName() + ".", variableInput2);
                    }
                }
                ++n;
            }
            if (this.errorReporter != null) {
                this.errorReporter.clearErrorMessage();
            }
            if (bl) {
                ++this.serialNumber;
                if (this.syncWith != null) {
                    this.syncWith.check();
                }
            }
        }
        catch (JCMError jCMError) {
            if (this.errorReporter != null) {
                this.errorReporter.setErrorMessage(null, jCMError.getMessage());
            } else {
                System.out.println("***** Error:  " + jCMError.getMessage());
            }
            if (jCMError.object instanceof TextField) {
                ((TextField)jCMError.object).selectAll();
                ((TextField)jCMError.object).requestFocus();
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.errorReporter != null) {
                this.errorReporter.setErrorMessage(null, runtimeException.toString());
            }
            runtimeException.printStackTrace();
        }
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public void sync(Tie tie, Tieable tieable) {
        if (tieable == this) {
            return;
        }
        if (!(tieable instanceof Tieable)) {
            throw new IllegalArgumentException("Internal Error:  A LimitControlPanel can only sync with a Limits object.");
        }
        this.setLimits(((Limits)((Object)tieable)).getLimits());
        this.serialNumber = tieable.getSerialNumber();
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.xmin.getVal(), this.xmax.getVal(), this.ymin.getVal(), this.ymax.getVal()};
        return dArray;
    }

    public void setLimits(double[] dArray) {
        if (dArray == null || dArray.length < 4) {
            throw new IllegalArgumentException("Internal Error:  Not enough values supplied for setLimits.");
        }
        int n = 0;
        while (n < 4) {
            if (Double.isNaN(dArray[n]) || Double.isInfinite(dArray[n])) {
                return;
            }
            ++n;
        }
        boolean bl = false;
        if (dArray[0] != this.xmin.getVal()) {
            bl = true;
            this.xmin.setVal(dArray[0]);
        }
        if (dArray[1] != this.xmax.getVal()) {
            bl = true;
            this.xmax.setVal(dArray[1]);
        }
        if (dArray[2] != this.ymin.getVal()) {
            bl = true;
            this.ymin.setVal(dArray[2]);
        }
        if (dArray[3] != this.ymax.getVal()) {
            bl = true;
            this.ymax.setVal(dArray[3]);
        }
        if (bl) {
            ++this.serialNumber;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() instanceof VariableInput || string.equals(buttonNames[0])) {
            this.checkInput();
        } else {
            if (this.coords == null) {
                return;
            }
            if (string.equals(buttonNames[1])) {
                this.coords.equalizeAxes();
            } else if (string.equals(buttonNames[2])) {
                this.coords.zoomIn();
            } else if (string.equals(buttonNames[3])) {
                this.coords.zoomOut();
            } else if (string.equals(buttonNames[4])) {
                this.coords.setRestoreBuffer();
            } else if (string.equals(buttonNames[5])) {
                this.coords.restore();
            }
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof VariableInput) {
                Point point = component.getLocation();
                graphics.drawString(component.getName(), point.x + 4, point.y - 4);
            }
            ++n2;
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 5;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n3 = fontMetrics == null ? 12 : 4 + fontMetrics.getAscent();
        int n4 = 0;
        while (n4 < this.items.size()) {
            Dimension dimension;
            Component[] componentArray;
            Object e = this.items.elementAt(n4);
            if (e instanceof Component) {
                componentArray = (Component[])e;
                dimension = componentArray.getPreferredSize();
                n2 += dimension.height + 5;
                if (componentArray instanceof VariableInput) {
                    n2 += n3;
                }
                if (dimension.width > n) {
                    n = dimension.width;
                }
            } else {
                componentArray = (Component[])e;
                dimension = componentArray[0].getPreferredSize();
                if (componentArray[0] instanceof VariableInput) {
                    dimension.height += n3;
                }
                Dimension dimension2 = componentArray[1].getPreferredSize();
                if (componentArray[1] instanceof VariableInput) {
                    dimension2.height += n3;
                }
                if (this.twoColumn) {
                    n = Math.max(n, dimension.width + dimension2.width);
                    n2 = n2 + Math.max(dimension.height, dimension2.height) + 5;
                } else {
                    n2 += dimension.height + dimension2.height + 10;
                    n = Math.max(n, dimension.width);
                    n2 = Math.max(n2, dimension2.height);
                }
            }
            ++n4;
        }
        return new Dimension(n + (this.twoColumn ? 15 : 10), n2);
    }

    public void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101) {
            int n;
            double d;
            double d2;
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.getPreferredSize();
            boolean bl = this.twoColumn;
            if (bl && dimension.width < dimension2.width - 20) {
                bl = false;
                this.twoColumn = false;
                dimension2 = this.getPreferredSize();
                this.twoColumn = true;
            }
            int n2 = this.items.size();
            if (!bl) {
                int n3 = 0;
                while (n3 < this.items.size()) {
                    if (this.items.elementAt(n3) instanceof Component[]) {
                        ++n2;
                    }
                    ++n3;
                }
            }
            if (dimension.height >= dimension2.height) {
                d2 = 1.0;
                d = 5 + (dimension.height - dimension2.height) / (n2 + 2);
                if (d > 15.0) {
                    d = 15.0;
                }
            } else if (dimension.height >= dimension2.height - 4 * (n2 + 2)) {
                d2 = 1.0;
                d = (dimension.height - (dimension2.height - 5 * (n2 + 2))) / (n2 + 2);
            } else {
                d2 = (double)dimension.height / (double)(dimension2.height - 4 * (n2 + 2));
                d = 1.0;
            }
            if ((n = (dimension.width - (dimension2.width - (bl ? 15 : 10))) / (bl ? 3 : 2)) < 1) {
                n = 1;
            } else if (n > 10) {
                n = 10;
            }
            double d3 = d;
            int n4 = 4 + this.getFontMetrics(this.getFont()).getAscent();
            int n5 = 0;
            while (n5 < this.items.size()) {
                Dimension dimension3;
                Component[] componentArray;
                Object e = this.items.elementAt(n5);
                if (e instanceof Component) {
                    componentArray = (Component[])e;
                    dimension3 = componentArray.getPreferredSize();
                    if (componentArray instanceof VariableInput) {
                        d3 += (double)n4 * d2;
                    }
                    if (dimension3.width + 2 * n < dimension.width - 10) {
                        componentArray.setBounds((dimension.width - dimension3.width) / 2, (int)d3, dimension3.width, (int)((double)dimension3.height * d2));
                    } else {
                        componentArray.setBounds(n, (int)d3, dimension3.width - 2 * n, (int)((double)dimension3.height * d2));
                    }
                    d3 += d2 * (double)dimension3.height + d;
                } else {
                    componentArray = (Component[])e;
                    dimension3 = componentArray[0].getPreferredSize();
                    Dimension dimension4 = componentArray[1].getPreferredSize();
                    if (bl) {
                        if (componentArray[0] instanceof VariableInput || componentArray[1] instanceof VariableInput) {
                            d3 += (double)n4 * d2;
                        }
                        int n6 = (int)(d2 * (double)Math.max(dimension3.height, dimension4.height));
                        componentArray[0].setBounds(n, (int)d3, (dimension.width - 3 * n) / 2, n6);
                        componentArray[1].setBounds(n * 2 + (dimension.width - 3 * n) / 2, (int)d3, (dimension.width - 3 * n) / 2, n6);
                        d3 += d2 * (double)Math.max(dimension3.height, dimension4.height) + d;
                    } else {
                        if (componentArray[0] instanceof VariableInput) {
                            d3 += (double)n4 * d2;
                        }
                        componentArray[0].setBounds(n, (int)d3, dimension.width - 2 * n, (int)((double)dimension3.height * d2));
                        d3 += (double)dimension3.height * d2 + d;
                        if (componentArray[1] instanceof VariableInput) {
                            d3 += (double)n4 * d2;
                        }
                        componentArray[1].setBounds(n, (int)d3, dimension.width - 2 * n, (int)((double)dimension4.height * d2));
                        d3 += (double)dimension4.height * d2 + d;
                    }
                }
                ++n5;
            }
        }
        super.processComponentEvent(componentEvent);
    }
}

