/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.data.ExpressionProgram;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;

public class VariableInput
extends TextField
implements InputObject,
Tieable,
Value {
    protected VI variable;
    protected boolean throwErrors;
    protected String errorMessage;
    protected long serialNumber;
    protected boolean hasChanged;
    private Controller onUserAction;
    private Controller onTextChange;
    protected double minValue = -1.7976931348623157E308;
    protected double maxValue = Double.MAX_VALUE;
    protected int inputStyle = 0;
    public static final int EXPRESSION = 0;
    public static final int REAL = 1;
    public static final int INTEGER = 2;
    private transient Parser constantParser;

    public VariableInput() {
        this(null, null);
    }

    public VariableInput(String string, String string2) {
        super(string2 == null ? "0" : string2, 12);
        ((Component)this).setBackground(Color.white);
        this.variable = new VI(string);
        if (string != null) {
            super.setName(string);
        }
        this.hasChanged = true;
        this.variable.checkInput();
        this.enableEvents(8L);
        this.throwErrors = true;
    }

    public VariableInput(String string, String string2, Parser parser) {
        this(string, string2);
        this.addTo(parser);
    }

    public Variable getVariable() {
        return this.variable;
    }

    public JCMPanel withLabel() {
        return this.withLabel(null, null);
    }

    public JCMPanel withLabel(Color color, Color color2) {
        Label label = new Label(" " + this.variable.getName() + " =");
        JCMPanel jCMPanel = new JCMPanel();
        if (color != null) {
            jCMPanel.setBackground(color);
            label.setBackground(color);
        }
        if (color2 != null) {
            jCMPanel.setForeground(color2);
            label.setBackground(color2);
        }
        jCMPanel.add((Component)label, "West");
        jCMPanel.add((Component)this, "Center");
        return jCMPanel;
    }

    public void setName(String string) {
        this.variable.setName(string);
        if (string != null) {
            super.setName(string);
        }
    }

    public void addTo(Parser parser) {
        if (parser != null && this.variable.getName() != null) {
            parser.add(this.variable);
        }
    }

    public void setOnUserAction(Controller controller) {
        this.onUserAction = controller;
        this.enableEvents(128L);
    }

    public Controller getOnUserAction() {
        return this.onUserAction;
    }

    public void notifyControllerOnChange(Controller controller) {
        this.setOnUserAction(controller);
    }

    public void setOnTextChange(Controller controller) {
        this.onTextChange = controller;
        this.enableEvents(1024L);
        if (controller != null) {
            this.throwErrors = false;
        }
    }

    public Controller getOnTextChange() {
        return this.onTextChange;
    }

    public double getVal() {
        return this.variable.getVal();
    }

    public void setVal(double d) {
        this.variable.setVal(d);
    }

    public void setThrowErrors(boolean bl) {
        this.throwErrors = bl;
    }

    public boolean getThrowErrors() {
        return this.throwErrors;
    }

    public void setMin(double d) {
        if (!Double.isNaN(d)) {
            this.minValue = d;
            this.hasChanged = true;
        }
    }

    public double getMin() {
        return this.minValue;
    }

    public void setMax(double d) {
        if (!Double.isNaN(d)) {
            this.maxValue = d;
            this.hasChanged = true;
        }
    }

    public double getMax() {
        return this.maxValue;
    }

    public void setInputStyle(int n) {
        if ((n == 0 || n == 1 || n == 2) && n != this.inputStyle) {
            this.hasChanged = true;
            this.inputStyle = n;
        }
    }

    public int getInputStyle() {
        return this.inputStyle;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void checkInput() {
        this.variable.checkInput();
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public void sync(Tie tie, Tieable tieable) {
        if (tieable == this) {
            return;
        }
        if (!(tieable instanceof Value)) {
            throw new IllegalArgumentException("Internal Error:  A VariableInput can only sync with Value objects.");
        }
        this.variable.setVal(((Value)((Object)tieable)).getVal());
        this.serialNumber = tieable.getSerialNumber();
    }

    protected double convertInput(String string) {
        double d;
        block17: {
            d = Double.NaN;
            if (this.inputStyle == 0) {
                if (this.constantParser == null) {
                    this.constantParser = new Parser();
                }
                try {
                    ExpressionProgram expressionProgram = this.constantParser.parse(string);
                    d = expressionProgram.getVal();
                }
                catch (ParseError parseError) {
                    this.errorMessage = "Illegal constant expression:  " + parseError.getMessage();
                    if (this.throwErrors) {
                        this.setCaretPosition(parseError.context.pos);
                        this.requestFocus();
                    }
                    break block17;
                }
            }
            if (this.inputStyle == 1) {
                try {
                    Double d2 = new Double(string);
                    d = d2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = "Value is not a legal real number.";
                    if (this.throwErrors) {
                        this.requestFocus();
                    }
                    break block17;
                }
            }
            try {
                d = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorMessage = "Value is not a legal integer.";
                if (!this.throwErrors) break block17;
                this.requestFocus();
            }
        }
        if (this.errorMessage == null && (d < this.minValue || d > this.maxValue)) {
            this.errorMessage = "Value outside legal range. It should be ";
            if (this.inputStyle == 2) {
                this.errorMessage = String.valueOf(this.errorMessage) + "an integer ";
            } else if (this.inputStyle == 1) {
                this.errorMessage = String.valueOf(this.errorMessage) + "a real number ";
            }
            this.errorMessage = this.minValue > -1.7976931348623157E308 && this.maxValue < Double.MAX_VALUE ? String.valueOf(this.errorMessage) + "between " + NumUtils.realToString(this.minValue) + " and " + NumUtils.realToString(this.maxValue) : (this.minValue > -1.7976931348623157E308 ? String.valueOf(this.errorMessage) + "greater than or equal to " + NumUtils.realToString(this.minValue) : String.valueOf(this.errorMessage) + "less than or equal to " + NumUtils.realToString(this.maxValue));
            if (this.throwErrors) {
                this.requestFocus();
            }
        }
        if (this.errorMessage != null) {
            throw new JCMError(this.errorMessage, this);
        }
        return d;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            boolean bl;
            boolean bl2;
            int n = keyEvent.getKeyCode();
            char c = keyEvent.getKeyChar();
            boolean bl3 = bl2 = c != '\u0000' && Character.isDigit(c) || c == '-' || c == '+' || n == 127 || n == 8;
            if (this.inputStyle != 2) {
                boolean bl4 = bl2 = bl2 || c == '.' || c == 'e' || c == 'E';
            }
            if (this.inputStyle == 0) {
                bl2 = bl2 || Character.isLetter(c) || c == '(' || c == ')' || c == '*' || c == '/' || c == '^' || c == ':' || c == '?' || c == '|' || c == '&' || c == '~' || c == '=' || c == '<' || c == '>' || c == '!' || n == 32;
            }
            boolean bl5 = bl = bl2 || n == 9 || n == 10 || c == '\u0000';
            if (!bl) {
                keyEvent.consume();
                Toolkit.getDefaultToolkit().beep();
            } else if (bl2) {
                this.hasChanged = true;
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void setText(String string) {
        super.setText(string);
        this.hasChanged = true;
    }

    private void justSetText(String string) {
        super.setText(string);
    }

    public void processActionEvent(ActionEvent actionEvent) {
        if (this.onUserAction != null) {
            this.onUserAction.compute();
        }
        super.processActionEvent(actionEvent);
    }

    public void processTextEvent(TextEvent textEvent) {
        this.hasChanged = true;
        if (this.onTextChange != null) {
            this.onTextChange.compute();
        }
        super.processTextEvent(textEvent);
    }

    private class VI
    extends Variable {
        VI(String string) {
            super(string);
        }

        public void setVal(double d) {
            double d2 = this.getVal();
            if (!VariableInput.this.hasChanged && (Double.isNaN(d) && Double.isNaN(d2) || d == d2)) {
                return;
            }
            ++VariableInput.this.serialNumber;
            VariableInput.this.justSetText(NumUtils.realToString(d));
            VariableInput.this.hasChanged = false;
            VariableInput.this.errorMessage = null;
            super.setVal(d);
        }

        void checkInput() {
            block5: {
                if (!VariableInput.this.hasChanged) {
                    return;
                }
                VariableInput.this.errorMessage = null;
                String string = VariableInput.this.getText();
                try {
                    double d = VariableInput.this.convertInput(string);
                    double d2 = this.getVal();
                    if (Double.isNaN(d) && Double.isNaN(d2) || d == d2) {
                        return;
                    }
                    ++VariableInput.this.serialNumber;
                    super.setVal(d);
                }
                catch (JCMError jCMError) {
                    if (!Double.isNaN(this.getVal())) {
                        ++VariableInput.this.serialNumber;
                    }
                    super.setVal(Double.NaN);
                    if (!VariableInput.this.throwErrors) break block5;
                    throw jCMError;
                }
            }
        }
    }
}

