/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.Logger;

public class IsosurfaceRenderer
extends MeshRenderer {
    private boolean iShowNormals;
    protected boolean iHideBackground;
    protected boolean isBicolorMap;
    protected short backgroundColix;
    protected int nError = 0;
    protected float[] vertexValues;
    protected IsosurfaceMesh imesh;
    private final Point3f ptTemp = new Point3f();
    private final Point3i ptTempi = new Point3i();

    protected void render() {
        this.iShowNormals = this.viewer.getTestFlag4();
        Isosurface isosurface = (Isosurface)this.shape;
        int n = isosurface.meshCount;
        while (--n >= 0) {
            this.imesh = (IsosurfaceMesh)isosurface.meshes[n];
            this.render1(this.imesh);
        }
    }

    protected void transform() {
        this.vertexValues = this.imesh.vertexValues;
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[n]) && !this.imesh.hasGridPoints) continue;
            this.viewer.transformPoint(this.vertices[n], this.screens[n]);
        }
    }

    protected void render2() {
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        super.render2();
        if (!this.g3d.setColix((short)4)) {
            return;
        }
        if (this.imesh.showContourLines) {
            this.renderContourLines();
        }
    }

    private void renderContourLines() {
        Vector[] vectorArray = this.imesh.getContours();
        if (vectorArray == null) {
            return;
        }
        int n = vectorArray.length;
        block0: while (--n >= 0) {
            Vector vector = vectorArray[n];
            if (vector.size() < 5) continue;
            if (!this.g3d.setColix(this.mesh.fillTriangles ? (short)4 : Graphics3D.getColix(((int[])vector.get(3))[0]))) {
                return;
            }
            int n2 = vector.size() - 1;
            for (int i = 5; i < n2; ++i) {
                Point3f point3f = (Point3f)vector.get(i);
                Point3f point3f2 = (Point3f)vector.get(++i);
                this.viewer.transformPoint(point3f, this.pt1i);
                this.viewer.transformPoint(point3f2, this.pt2i);
                if (Float.isNaN(point3f.x) || Float.isNaN(point3f2.x)) continue block0;
                this.g3d.drawLine(this.pt1i, this.pt2i);
            }
        }
    }

    protected void renderPoints() {
        int n;
        int n2 = this.imesh.vertexIncrement;
        int n3 = 4;
        boolean bl = this.viewer.getTestFlag2();
        if (bl) {
            this.g3d.setFont(this.g3d.getFontFid("Monospaced", 10.0f));
        }
        int n4 = n = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
        while (n < this.vertexCount) {
            if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[n]) || this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f)) {
                if (this.imesh.vertexColixes != null) {
                    this.g3d.setColix(this.imesh.vertexColixes[n]);
                }
                this.g3d.fillSphereCentered(n3, this.screens[n]);
                if (bl && this.screens[n].z > 10) {
                    this.g3d.drawStringNoSlab(n + (this.imesh.isColorSolid ? "" : " " + this.imesh.vertexValues[n]), null, this.screens[n].x, this.screens[n].y, this.screens[n].z);
                }
            }
            n += n2;
        }
        if (n2 != 3) {
            return;
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)12, true, 0.5f) : (short)12);
        for (n = 1; n < this.vertexCount; n += 3) {
            this.g3d.fillCylinder((byte)3, 1, this.screens[n], this.screens[n + 1]);
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)21, true, 0.5f) : (short)21);
        for (n = 1; n < this.vertexCount; n += 3) {
            this.g3d.fillSphereCentered(4, this.screens[n]);
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)7, true, 0.5f) : (short)7);
        for (n = 2; n < this.vertexCount; n += 3) {
            this.g3d.fillSphereCentered(4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2) {
        boolean bl3;
        int[][] nArray = this.imesh.polygonIndexes;
        this.colix = this.imesh.colix;
        short[] sArray = this.imesh.vertexColixes;
        this.g3d.setColix(this.imesh.colix);
        boolean bl4 = bl3 = this.isGenerator && bl;
        if (bl3) {
            this.frontOnly = false;
            this.bsFaces.clear();
        }
        boolean bl5 = sArray == null || this.imesh.isColorSolid;
        short s = this.colix;
        if (!bl5 && !bl && this.imesh.fillTriangles && this.imesh.jvxlData.jvxlPlane != null) {
            bl5 = true;
            s = 4;
        }
        boolean bl6 = bl && bl5 && this.imesh.polygonColixes != null;
        int n = this.imesh.polygonCount;
        while (--n >= 0) {
            short s2;
            short s3;
            short s4;
            short s5;
            int[] nArray2 = nArray[n];
            if (nArray2 == null) continue;
            int n2 = nArray2[0];
            int n3 = nArray2[1];
            int n4 = nArray2[2];
            short s6 = this.normixes[n2];
            short s7 = this.normixes[n3];
            short s8 = this.normixes[n4];
            if (this.frontOnly && this.transformedVectors[s6].z < 0.0f && this.transformedVectors[s7].z < 0.0f && this.transformedVectors[s8].z < 0.0f) continue;
            if (bl5) {
                if (bl6 && n < this.imesh.polygonColixes.length && (s5 = this.imesh.polygonColixes[n]) != 0) {
                    s = s5;
                }
                s3 = s4 = s;
                s2 = s4;
            } else {
                s2 = sArray[n2];
                s3 = sArray[n3];
                s4 = sArray[n4];
                if (this.isBicolorMap && (s2 != s3 || s3 != s4)) continue;
            }
            if (bl) {
                block14: {
                    if (bl3) {
                        this.bsFaces.set(n);
                        continue;
                    }
                    if (bl2) {
                        this.g3d.fillTriangle(this.screens[n2], s2, s6, this.screens[n3], s3, s7, this.screens[n4], s4, s8, 0.1f);
                    } else {
                        try {
                            this.g3d.fillTriangle(this.screens[n2], s2, s6, this.screens[n3], s3, s7, this.screens[n4], s4, s8);
                        }
                        catch (Exception exception) {
                            if (this.nError++ >= 1) break block14;
                            Logger.warn("IsosurfaceRenderer -- competing thread bug?\n", exception);
                        }
                    }
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            s5 = nArray2[3];
            if (s5 == 0) continue;
            if (sArray == null) {
                this.g3d.drawTriangle(this.screens[n2], this.screens[n3], this.screens[n4], s5);
                continue;
            }
            this.g3d.drawTriangle(this.screens[n2], s2, this.screens[n3], s3, this.screens[n4], s4, s5);
        }
        if (bl3) {
            this.renderExport();
        }
    }

    private void renderNormals() {
        if (!this.g3d.setColix((short)8)) {
            return;
        }
        int n = this.vertexCount;
        while (--n >= 0) {
            short s;
            if (this.vertexValues != null && !Float.isNaN(this.vertexValues[n])) {
                this.ptTemp.set(this.mesh.vertices[n]);
            }
            if ((s = this.mesh.normixes[n]) < 0) continue;
            this.ptTemp.add(this.g3d.getNormixVector(s));
            this.viewer.transformPoint(this.ptTemp, this.ptTempi);
            this.g3d.fillCylinder((byte)3, 1, this.screens[n], this.ptTempi);
        }
    }
}

