/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class Atom
extends Point3fi {
    private static final byte VIBRATION_VECTOR_FLAG = 1;
    private static final byte IS_HETERO_FLAG = 2;
    private static final byte FLAG_MASK = 3;
    Group group;
    int atomIndex;
    BitSet atomSymmetry;
    int atomSite;
    private float userDefinedVanDerWaalRadius;
    short modelIndex;
    private short atomicAndIsotopeNumber;
    private byte formalChargeAndFlags;
    private byte valence;
    char alternateLocationID;
    short madAtom;
    short colixAtom;
    byte paletteID = 1;
    Bond[] bonds;
    int nBondsDisplayed = 0;
    int nBackbonesDisplayed = 0;
    int clickabilityFlags;
    int shapeVisibilityFlags;
    boolean isSimple = false;

    public int getScreenRadius() {
        return this.screenDiameter / 2;
    }

    public short getMadAtom() {
        return this.madAtom;
    }

    public int getNBackbonesDisplayed() {
        return this.nBackbonesDisplayed;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public Atom(Point3f point3f) {
        this.isSimple = true;
        this.x = point3f.x;
        this.y = point3f.y;
        this.z = point3f.z;
    }

    Atom(Viewer viewer, int n, int n2, BitSet bitSet, int n3, short s, int n4, int n5, float f, float f2, float f3, boolean bl, char c, char c2, float f4) {
        this.modelIndex = (short)n;
        this.atomSymmetry = bitSet;
        this.atomSite = n3;
        this.atomIndex = n2;
        this.atomicAndIsotopeNumber = s;
        if (bl) {
            this.formalChargeAndFlags = (byte)2;
        }
        this.setFormalCharge(n5);
        this.alternateLocationID = c2;
        this.userDefinedVanDerWaalRadius = f4;
        this.setMadAtom(viewer, n4);
        this.set(f, f2, f3);
    }

    public final void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public boolean isBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(atom) == null) continue;
                return this.bonds[n];
            }
        }
        return null;
    }

    void addDisplayedBond(int n, boolean bl) {
        this.nBondsDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    public void addDisplayedBackbone(int n, boolean bl) {
        this.nBackbonesDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    void deleteBond(Bond bond) {
        int n = this.bonds.length;
        while (--n >= 0) {
            if (this.bonds[n] != bond) continue;
            this.deleteBond(n);
            return;
        }
    }

    private void deleteBond(int n) {
        int n2;
        int n3 = this.bonds.length - 1;
        if (n3 == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondArray = new Bond[n3];
        for (n2 = 0; n2 < n; ++n2) {
            bondArray[n2] = this.bonds[n2];
        }
        while (n2 < n3) {
            bondArray[n2] = this.bonds[n2 + 1];
            ++n2;
        }
        this.bonds = bondArray;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int n) {
        return this.bonds[n].getOtherAtom((Atom)this).atomIndex;
    }

    public void setMadAtom(Viewer viewer, int n) {
        this.madAtom = this.convertEncodedMad(viewer, n);
    }

    public short convertEncodedMad(Viewer viewer, int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case -1000: {
                int n2 = this.getBfactor100() * 10 * 2;
                if (n2 > 4000) {
                    n2 = 4000;
                }
                n = n2;
                break;
            }
            case -1001: {
                n = this.getBondingMar() * 2;
                break;
            }
            case -100: {
                n = this.getVanderwaalsMad(viewer);
            }
            default: {
                if (n <= Short.MIN_VALUE) {
                    float f = 2000.0f * this.getADPMinMax(false);
                    if (n < Short.MIN_VALUE) {
                        n = (int)(f * (float)(Short.MIN_VALUE - n) / 100.0f);
                        break;
                    }
                    n = (int)f;
                    break;
                }
                if (n < -2000) {
                    int n3 = -n / 1000 - 2;
                    n = -n % 1000;
                    n = (int)((float)n / 50.0f * (float)viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128, n3));
                    break;
                }
                if (n < 0) {
                    if ((n = -n) > 200) {
                        n = 200;
                    }
                    n = (int)((float)n / 100.0f * (float)this.getVanderwaalsMad(viewer));
                    break;
                }
                if (n >= Short.MAX_VALUE) {
                    float f = 2000.0f * this.getADPMinMax(true);
                    if (n > Short.MAX_VALUE) {
                        n = (int)(f * (float)(n - Short.MAX_VALUE) / 100.0f);
                        break;
                    }
                    n = (int)f;
                    break;
                }
                if (n < 10000) break;
                n = n - 10000 + this.getVanderwaalsMad(viewer);
            }
        }
        return (short)n;
    }

    public float getADPMinMax(boolean bl) {
        Object[] objectArray = this.getEllipsoid();
        if (objectArray == null) {
            return 0.0f;
        }
        return ((float[])objectArray[1])[bl ? 5 : 3];
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0) continue;
            ++n;
        }
        return n;
    }

    int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0 || this.bonds[n2].getOtherAtom(this).getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public void setColixAtom(short s) {
        this.colixAtom = s;
    }

    public void setPaletteID(byte by) {
        this.paletteID = by;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colixAtom = Graphics3D.getColixTranslucent(this.colixAtom, bl, f);
    }

    public boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colixAtom);
    }

    public short getElementNumber() {
        return (short)(this.atomicAndIsotopeNumber % 128);
    }

    public short getIsotopeNumber() {
        return (short)(this.atomicAndIsotopeNumber >> 7);
    }

    public short getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || n % 128 >= JmolConstants.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomicAndIsotopeNumber = (short)n;
    }

    public String getElementSymbol() {
        return JmolConstants.elementSymbolFromNumber(this.atomicAndIsotopeNumber);
    }

    public char getAlternateLocationID() {
        return this.alternateLocationID;
    }

    boolean isAlternateLocationMatch(String string) {
        if (string == null) {
            return this.alternateLocationID == '\u0000';
        }
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return c == '*' || c == '?' && this.alternateLocationID != '\u0000' || this.alternateLocationID == c;
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    void setFormalCharge(int n) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 3 | (n == Integer.MIN_VALUE ? 0 : (n > 7 ? 7 : (n < -3 ? -3 : n))) << 2);
    }

    void setVibrationVector() {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 1);
    }

    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 2;
    }

    public int getOccupancy() {
        byte[] byArray = this.group.chain.modelSet.occupancies;
        return byArray == null ? 100 : byArray[this.atomIndex];
    }

    public int getBfactor100() {
        short[] sArray = this.group.chain.modelSet.bfactor100s;
        if (sArray == null) {
            return 0;
        }
        return sArray[this.atomIndex];
    }

    public boolean setRadius(float f) {
        this.userDefinedVanDerWaalRadius = f > 0.0f ? f : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void setValence(int n) {
        this.valence = (byte)(n < 0 ? 0 : (n < 239 ? n : 239));
    }

    public int getValence() {
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        return n;
    }

    public float getDimensionValue(int n) {
        return n == 0 ? this.x : (n == 1 ? this.y : this.z);
    }

    private int getVanderwaalsMad(Viewer viewer) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128) * 2 : (int)(this.userDefinedVanDerWaalRadius * 2000.0f);
    }

    public float getVanderwaalsRadiusFloat() {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)this.group.chain.modelSet.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, this.getFormalCharge());
    }

    public float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public byte getPaletteID() {
        return this.paletteID;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    public int getAtomIndex() {
        return this.atomIndex;
    }

    public int getAtomSite() {
        return this.atomSite;
    }

    public BitSet getAtomSymmetry() {
        return this.atomSymmetry;
    }

    void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Viewer var1_1) {
        if ((this.formalChargeAndFlags & 1) == 0) ** GOTO lbl-1000
        var3_2 = this.group.chain.modelSet.vibrationVectors;
        if (this.group.chain.modelSet.vibrationVectors == null) lbl-1000:
        // 2 sources

        {
            var2_3 = var1_1.transformPoint(this);
        } else {
            var2_3 = var1_1.transformPoint((Point3f)this, var3_2[this.atomIndex]);
        }
        this.screenX = var2_3.x;
        this.screenY = var2_3.y;
        this.screenZ = var2_3.z;
        this.screenDiameter = var1_1.scaleToScreen(this.screenZ, Math.abs(this.madAtom));
    }

    String getAtomName() {
        return this.group.chain.modelSet.atomNames[this.atomIndex];
    }

    String getAtomType() {
        String[] stringArray = this.group.chain.modelSet.atomTypes;
        String string = stringArray == null ? null : stringArray[this.atomIndex];
        return string == null ? this.group.chain.modelSet.atomNames[this.atomIndex] : string;
    }

    public int getAtomNumber() {
        int[] nArray = this.group.chain.modelSet.atomSerials;
        return nArray != null ? nArray[this.atomIndex] : this.atomIndex;
    }

    public boolean isModelVisible() {
        return (this.shapeVisibilityFlags & 1) != 0;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    public boolean isShapeVisible(int n) {
        return this.isModelVisible() && (this.shapeVisibilityFlags & n) != 0;
    }

    public float getPartialCharge() {
        float[] fArray = this.group.chain.modelSet.partialCharges;
        return fArray == null ? 0.0f : fArray[this.atomIndex];
    }

    public float getStraightness() {
        return this.group.getStraightness();
    }

    public Object[] getEllipsoid() {
        return this.group.chain.modelSet.getEllipsoid(this.atomIndex);
    }

    public int getSymmetryTranslation(int n, int[] nArray, int n2) {
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.atomSymmetry.get(n3 += n2)) continue;
            return nArray[i];
        }
        return 0;
    }

    public int getCellTranslation(int n, int[] nArray, int n2) {
        int n3 = n2;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = 0;
            while (n4 < n2) {
                if (this.atomSymmetry.get(n3) && nArray[i] == n) {
                    return nArray[i];
                }
                ++n4;
                ++n3;
            }
        }
        return 0;
    }

    private String getSymmetryOperatorList() {
        int n;
        String string = "";
        ModelSet modelSet = this.group.chain.modelSet;
        if (this.atomSymmetry == null || modelSet.unitCells == null || modelSet.unitCells[this.modelIndex] == null) {
            return "";
        }
        int[] nArray = modelSet.getModelCellRange(this.modelIndex);
        if (nArray == null) {
            return "";
        }
        int n2 = n = modelSet.getModelSymmetryCount(this.modelIndex);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.atomSymmetry.get(n2++)) continue;
                string = string + "," + (j + 1) + "" + nArray[i];
            }
        }
        return string.substring(1);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getMoleculeNumber() {
        return this.group.chain.modelSet.getMoleculeIndex(this.atomIndex) + 1;
    }

    String getClientAtomStringProperty(String string) {
        Object[] objectArray = this.group.chain.modelSet.clientAtomReferences;
        return objectArray == null || objectArray.length <= this.atomIndex ? null : this.group.chain.modelSet.viewer.getClientAtomStringProperty(objectArray[this.atomIndex], string);
    }

    public byte getSpecialAtomID() {
        byte[] byArray = this.group.chain.modelSet.specialAtomIDs;
        return byArray == null ? (byte)0 : byArray[this.atomIndex];
    }

    public float getFractionalCoord(char c) {
        Point3f point3f = this.getFractionalCoord();
        return c == 'X' ? point3f.x : (c == 'Y' ? point3f.y : point3f.z);
    }

    public Point3f getFractionalCoord() {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray == null) {
            return this;
        }
        Point3f point3f = new Point3f(this);
        symmetryInterfaceArray[this.modelIndex].toFractional(point3f);
        return point3f;
    }

    void setFractionalCoord(int n, float f) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toFractional(this);
        }
        switch (n) {
            case 3146115: {
                this.x = f;
                break;
            }
            case 3146116: {
                this.y = f;
                break;
            }
            case 3146117: {
                this.z = f;
            }
        }
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toCartesian(this);
        }
    }

    void setFractionalCoord(Point3f point3f) {
        this.set(point3f);
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray != null) {
            symmetryInterfaceArray[this.modelIndex].toCartesian(this);
        }
    }

    boolean isCursorOnTopOf(int n, int n2, int n3, Atom atom) {
        int n4;
        int n5;
        int n6;
        int n7 = this.screenDiameter / 2;
        if (n7 < n3) {
            n7 = n3;
        }
        if ((n6 = (n5 = this.screenX - n) * n5) > (n4 = n7 * n7)) {
            return false;
        }
        int n8 = this.screenY - n2;
        int n9 = n8 * n8;
        int n10 = n4 - (n6 + n9);
        if (n10 < 0) {
            return false;
        }
        if (atom == null) {
            return true;
        }
        int n11 = this.screenZ;
        int n12 = atom.screenZ;
        int n13 = atom.screenDiameter / 2;
        if (n11 < n12 - n13) {
            return true;
        }
        int n14 = atom.screenX - n;
        int n15 = n14 * n14;
        int n16 = atom.screenY - n2;
        int n17 = n16 * n16;
        int n18 = n13 * n13;
        int n19 = n18 - (n15 + n17);
        return (double)n11 - Math.sqrt(n10) < (double)n12 - Math.sqrt(n19);
    }

    public String getInfo() {
        return this.getIdentity(true);
    }

    String getInfoXYZ(boolean bl) {
        if (bl) {
            String string = this.getGroup3();
            char c = this.getChainID();
            Point3f point3f = this.group.chain.modelSet.unitCells == null ? null : this.getFractionalCoord();
            return "Atom: " + (string == null ? this.getElementSymbol() : this.getAtomName()) + " " + this.getAtomNumber() + (string != null && string.length() > 0 ? (this.isHetero() ? " Hetero: " : " Group: ") + string + " " + this.getResno() + (c != '\u0000' && c != ' ' ? " Chain: " + c : "") : "") + " Model: " + this.getModelNumber() + " Coordinates: " + this.x + " " + this.y + " " + this.z + (point3f == null ? "" : " Fractional: " + point3f.x + " " + point3f.y + " " + point3f.z);
        }
        return this.getIdentity(true) + " " + this.x + " " + this.y + " " + this.z;
    }

    private String getIdentityXYZ() {
        return this.getIdentity(false) + " " + this.x + " " + this.y + " " + this.z;
    }

    private String getIdentity(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getGroup3();
        String string2 = this.getSeqcodeString();
        char c = this.getChainID();
        if (string != null && string.length() > 0) {
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append("]");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (c != '\u0000' && c != ' ') {
            stringBuffer.append(":");
            stringBuffer.append(c);
        }
        if (!bl) {
            return stringBuffer.toString();
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.getAtomName());
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.getElementSymbol());
            stringBuffer.append(" ");
            stringBuffer.append(this.getAtomNumber());
        }
        if (this.alternateLocationID != '\u0000') {
            stringBuffer.append("%");
            stringBuffer.append(this.alternateLocationID);
        }
        if (this.group.chain.modelSet.getModelCount() > 1) {
            stringBuffer.append("/");
            stringBuffer.append(this.getModelNumberForLabel());
        }
        stringBuffer.append(" #");
        stringBuffer.append(this.getAtomNumber());
        return stringBuffer.toString();
    }

    String getGroup3() {
        return this.group.getGroup3();
    }

    String getGroup1() {
        char c = this.group.getGroup1();
        return c == '\u0000' ? "" : "" + c;
    }

    boolean isGroup3(String string) {
        return this.group.isGroup3(string);
    }

    boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    boolean isNucleic() {
        return this.group.isNucleic();
    }

    boolean isDna() {
        return this.group.isDna();
    }

    boolean isRna() {
        return this.group.isRna();
    }

    boolean isPurine() {
        return this.group.isPurine();
    }

    boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    int getSeqcode() {
        return this.group.getSeqcode();
    }

    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        if (!this.isVisible()) {
            return false;
        }
        int n = this.shapeVisibilityFlags | this.group.shapeVisibilityFlags;
        return (n & this.clickabilityFlags) != 0;
    }

    public int getClickabilityFlags() {
        return this.clickabilityFlags;
    }

    public void setClickable(int n) {
        this.clickabilityFlags = n == 0 ? 0 : (this.clickabilityFlags |= n);
    }

    public boolean isVisible() {
        if (!this.isModelVisible() || this.group.chain.modelSet.isAtomHidden(this.atomIndex)) {
            return false;
        }
        int n = this.shapeVisibilityFlags;
        return ((n |= this.group.shapeVisibilityFlags) & 0xFFFFFFFE) != 0;
    }

    public float getGroupPhi() {
        return this.group.phi;
    }

    public float getGroupPsi() {
        return this.group.psi;
    }

    public char getChainID() {
        return this.group.chain.chainID;
    }

    public int getSurfaceDistance100() {
        return this.group.chain.modelSet.getSurfaceDistance100(this.atomIndex);
    }

    public Vector3f getVibrationVector() {
        return this.group.chain.modelSet.getVibrationVector(this.atomIndex);
    }

    public int getPolymerLength() {
        return this.group.getBioPolymerLength();
    }

    public Quaternion getQuaternion(char c) {
        return this.group.getQuaternion(c);
    }

    int getPolymerIndex() {
        return this.group.getBioPolymerIndex();
    }

    public int getSelectedGroupCountWithinChain() {
        return this.group.chain.getSelectedGroupCount();
    }

    public int getSelectedGroupIndexWithinChain() {
        return this.group.getSelectedGroupIndex();
    }

    public int getSelectedMonomerCountWithinPolymer() {
        return this.group.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndexWithinPolymer() {
        return this.group.getSelectedMonomerIndex();
    }

    Chain getChain() {
        return this.group.chain;
    }

    String getModelNumberForLabel() {
        return this.group.chain.modelSet.getModelNumberForAtomLabel(this.modelIndex);
    }

    public int getModelNumber() {
        return this.group.chain.modelSet.getModelNumber(this.modelIndex) % 1000000;
    }

    public int getModelFileIndex() {
        return this.group.chain.model.fileIndex;
    }

    public int getModelFileNumber() {
        return this.group.chain.modelSet.getModelFileNumber(this.modelIndex);
    }

    public byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public int getProteinStructureID() {
        return this.group.getProteinStructureID();
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    int getSeqNumber() {
        return this.group.getSeqNumber();
    }

    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public String formatLabel(String string) {
        return this.formatLabel(string, '\u0000', null);
    }

    public String formatLabel(String string, char c, int[] nArray) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = "";
        int n2 = string.length();
        int n3 = 0;
        while ((n = string.indexOf(37, n3)) != -1) {
            if (n3 != n) {
                string2 = string2 + string.substring(n3, n);
            }
            n3 = n + 1;
            try {
                char c2;
                String string3 = "";
                float f = Float.NaN;
                boolean bl = false;
                if (string.charAt(n3) == '-') {
                    bl = true;
                    ++n3;
                }
                boolean bl2 = false;
                if (string.charAt(n3) == '0') {
                    bl2 = true;
                    ++n3;
                }
                int n4 = 0;
                while ((c2 = string.charAt(n3)) >= '0' && c2 <= '9') {
                    n4 = 10 * n4 + (c2 - 48);
                    ++n3;
                }
                int n5 = Integer.MAX_VALUE;
                if (string.charAt(n3) == '.' && (c2 = string.charAt(++n3)) >= '0' && c2 <= '9') {
                    n5 = c2 - 48;
                }
                int n6 = ++n3;
                char c3 = c2 = string.charAt(n6);
                if (c != '\u0000' && ++n3 < n2) {
                    if (string.charAt(n3) != c) {
                        string2 = string2 + "%";
                        n3 = n + 1;
                        continue;
                    }
                    ++n3;
                }
                block1 : switch (c2) {
                    case 'A': {
                        string3 = this.alternateLocationID != '\u0000' ? this.alternateLocationID + "" : "";
                        break;
                    }
                    case 'a': {
                        string3 = this.getAtomName();
                        break;
                    }
                    case 'B': {
                        string3 = this.getAtomType();
                        break;
                    }
                    case 'C': {
                        int n7 = this.getFormalCharge();
                        if (n7 > 0) {
                            string3 = "" + n7 + "+";
                            break;
                        }
                        if (n7 < 0) {
                            string3 = "" + -n7 + "-";
                            break;
                        }
                        string3 = "0";
                        break;
                    }
                    case 'D': {
                        string3 = "" + (nArray == null ? this.atomIndex : nArray[this.atomIndex]);
                        break;
                    }
                    case 'e': {
                        string3 = this.getElementSymbol();
                        break;
                    }
                    case 'E': {
                        c2 = this.getInsertionCode();
                        string3 = c2 == '\u0000' ? "" : "" + c2;
                        break;
                    }
                    case 'f': {
                        f = this.getGroupPhi();
                        break;
                    }
                    case 'g': {
                        string3 = "" + this.getSelectedGroupIndexWithinChain();
                        break;
                    }
                    case 'I': {
                        f = this.getBondingRadiusFloat();
                        break;
                    }
                    case 'i': {
                        string3 = "" + this.getAtomNumber();
                        break;
                    }
                    case 'L': {
                        string3 = "" + this.getPolymerLength();
                        break;
                    }
                    case 'l': {
                        string3 = "" + this.getElementNumber();
                        break;
                    }
                    case 'M': {
                        string3 = this.getModelNumberForLabel();
                        break;
                    }
                    case 'm': {
                        string3 = this.getGroup1();
                        break;
                    }
                    case 'N': {
                        string3 = "" + this.getMoleculeNumber();
                        break;
                    }
                    case 'n': {
                        string3 = this.getGroup3();
                        if (string3 != null && string3.length() != 0) break;
                        string3 = "UNK";
                        break;
                    }
                    case 'o': {
                        string3 = this.getSymmetryOperatorList();
                        break;
                    }
                    case 'P': {
                        f = this.getPartialCharge();
                        break;
                    }
                    case 'p': {
                        f = this.getGroupPsi();
                        break;
                    }
                    case 'q': {
                        string3 = "" + this.getOccupancy();
                        break;
                    }
                    case 'Q': {
                        f = (float)this.getOccupancy() / 100.0f;
                        break;
                    }
                    case 'R': {
                        string3 = "" + this.getResno();
                        break;
                    }
                    case 'r': {
                        string3 = this.getSeqcodeString();
                        break;
                    }
                    case 'S': {
                        string3 = "" + this.atomSite;
                        break;
                    }
                    case 'c': 
                    case 's': {
                        c2 = this.getChainID();
                        string3 = c2 == '\u0000' ? "" : "" + c2;
                        break;
                    }
                    case 'T': {
                        f = this.getStraightness();
                        break;
                    }
                    case 'b': 
                    case 't': {
                        f = (float)this.getBfactor100() / 100.0f;
                        break;
                    }
                    case 'U': {
                        string3 = this.getIdentity(true);
                        break;
                    }
                    case 'u': {
                        f = (float)this.getSurfaceDistance100() / 100.0f;
                        break;
                    }
                    case 'V': {
                        f = this.getVanderwaalsRadiusFloat();
                        break;
                    }
                    case 'v': {
                        Vector3f vector3f;
                        c2 = n3 < string.length() ? string.charAt(n3++) : (char)'\u0000';
                        switch (c2) {
                            case 'x': 
                            case 'y': 
                            case 'z': {
                                f = this.group.chain.modelSet.getVibrationCoord(this.atomIndex, c2);
                                break block1;
                            }
                        }
                        if (c2 != '\u0000') {
                            --n3;
                        }
                        if ((vector3f = this.getVibrationVector()) == null) {
                            f = 0.0f;
                            break;
                        }
                        string3 = vector3f.x + " " + vector3f.y + " " + vector3f.z;
                        break;
                    }
                    case 'W': {
                        string3 = this.getIdentityXYZ();
                        break;
                    }
                    case 'x': {
                        f = this.x;
                        break;
                    }
                    case 'y': {
                        f = this.y;
                        break;
                    }
                    case 'z': {
                        f = this.z;
                        break;
                    }
                    case 'X': 
                    case 'Y': 
                    case 'Z': {
                        f = this.getFractionalCoord(c2);
                        break;
                    }
                    case '%': {
                        string3 = "%";
                        break;
                    }
                    case '{': {
                        int n8 = string.indexOf(125, n3);
                        if (n8 > n3) {
                            String string4 = string.substring(n3, n8);
                            f = this.group.chain.modelSet.viewer.getDataFloat(string4, this.atomIndex);
                            if (Float.isNaN(f)) {
                                string3 = this.getClientAtomStringProperty(string4);
                            }
                            if (string3 != null || !Float.isNaN(f)) {
                                n3 = n8 + 1;
                                break;
                            }
                        }
                    }
                    default: {
                        string3 = "%" + c3;
                    }
                }
                if (!Float.isNaN(f)) {
                    string2 = string2 + TextFormat.format(f, n4, n5, bl, bl2);
                    continue;
                }
                if (string3 == null) continue;
                string2 = string2 + TextFormat.format(string3, n4, n5, bl, bl2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n3 = n;
                break;
            }
        }
        if ((string2 = string2 + string.substring(n3)).length() == 0) {
            return null;
        }
        return string2.intern();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.atomIndex;
    }

    public Atom findAromaticNeighbor(BitSet bitSet) {
        int n = this.bonds.length;
        while (--n >= 0) {
            Bond bond = this.bonds[n];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || bitSet != null && bitSet.get(atom.atomIndex)) continue;
            return atom;
        }
        return null;
    }

    public Atom findAromaticNeighbor(int n) {
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || atom.atomIndex == n) continue;
            return atom;
        }
        return null;
    }
}

