/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

class PmeshReader
extends PolygonFileReader {
    private int nPolygons;
    private boolean isBinary;
    static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    String pmeshError;
    private String[] tokens = new String[0];
    private int iToken = 0;

    PmeshReader(SurfaceGenerator surfaceGenerator, String string, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("pmesh file format\nvertices and triangles only\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
        this.isBinary = this.checkBinary(string);
    }

    private boolean checkBinary(String string) {
        try {
            this.br.mark(4);
            char[] cArray = new char[5];
            this.br.read(cArray);
            if (new String(cArray).startsWith(PMESH_BINARY_MAGIC_NUMBER)) {
                this.br.close();
                this.binarydoc = new BinaryDocument();
                this.binarydoc.setStream(this.sg.getAtomDataServer().getBufferedInputStream(string), cArray[4] == '\u0000');
                return true;
            }
            this.br.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void getSurfaceData() throws Exception {
        if (this.readPmesh()) {
            Logger.info((this.isBinary ? "binary " : "") + "pmesh file contains " + this.nVertices + " vertices and " + this.nPolygons + " polygons for " + this.nTriangles + " triangles");
        } else {
            Logger.error(this.params.fileName + ": " + (this.pmeshError == null ? "Error reading pmesh data " : this.pmeshError));
        }
    }

    private boolean readPmesh() {
        block4: {
            try {
                if (this.isBinary && !this.readBinaryHeader()) {
                    return false;
                }
                if (this.readVertices() && this.readPolygons()) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (this.pmeshError != null) break block4;
                this.pmeshError = "pmesh ERROR: " + exception;
            }
        }
        return false;
    }

    boolean readBinaryHeader() {
        this.pmeshError = "could not read binary Pmesh file header";
        try {
            byte[] byArray = new byte[64];
            this.binarydoc.readByteArray(byArray, 0, 8);
            this.nVertices = this.binarydoc.readInt();
            this.nPolygons = this.binarydoc.readInt();
            this.binarydoc.readByteArray(byArray, 0, 64);
        }
        catch (Exception exception) {
            this.pmeshError = this.pmeshError + " " + exception.getMessage();
            this.binarydoc.close();
            return false;
        }
        this.pmeshError = null;
        return true;
    }

    private boolean readVertices() throws Exception {
        this.pmeshError = "pmesh ERROR: vertex count must be positive";
        if (!this.isBinary) {
            this.nVertices = this.getInt();
        }
        if (this.nVertices <= 0) {
            this.pmeshError = this.pmeshError + " (" + this.nVertices + ")";
            return false;
        }
        this.pmeshError = "pmesh ERROR: invalid vertex list";
        Point3f point3f = new Point3f();
        for (int i = 0; i < this.nVertices; ++i) {
            point3f.set(this.getFloat(), this.getFloat(), this.getFloat());
            this.addVertexCopy(point3f, 0.0f, i);
        }
        this.pmeshError = null;
        return true;
    }

    private boolean readPolygons() throws Exception {
        this.pmeshError = "pmesh ERROR: polygon count must be zero or positive";
        if (!this.isBinary) {
            this.nPolygons = this.getInt();
        }
        if (this.nPolygons < 0) {
            this.pmeshError = this.pmeshError + " (" + this.nPolygons + ")";
            return false;
        }
        int[] nArray = new int[5];
        for (int i = 0; i < this.nPolygons; ++i) {
            int n;
            int n2 = this.getInt();
            int n3 = n2 - (this.isBinary ? 0 : 1);
            if (n3 < 1 || n3 > 4) {
                this.pmeshError = "pmesh ERROR: bad polygon (must have 1-4 vertices) at #" + (i + 1);
                return false;
            }
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.getInt();
                if (nArray[n] >= 0 && nArray[n] < this.nVertices) continue;
                this.pmeshError = "pmesh ERROR: invalid vertex index: " + nArray[n];
                return false;
            }
            if (n3 < 3) {
                for (n = n3; n < 3; ++n) {
                    nArray[n] = nArray[n - 1];
                }
            }
            if (n3 == 4) {
                this.nTriangles += 2;
                this.addTriangleCheck(nArray[0], nArray[1], nArray[3], 5, false, 0);
                this.addTriangleCheck(nArray[1], nArray[2], nArray[3], 3, false, 0);
                continue;
            }
            ++this.nTriangles;
            this.addTriangleCheck(nArray[0], nArray[1], nArray[2], 7, false, 0);
        }
        return true;
    }

    private String nextToken() throws Exception {
        while (this.iToken >= this.tokens.length) {
            this.iToken = 0;
            this.line = this.br.readLine();
            this.tokens = this.getTokens();
        }
        return this.tokens[this.iToken++];
    }

    private int getInt() throws Exception {
        return this.isBinary ? this.binarydoc.readInt() : this.parseInt(this.nextToken());
    }

    private float getFloat() throws Exception {
        return this.isBinary ? this.binarydoc.readFloat() : this.parseFloat(this.nextToken());
    }
}

