/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.Interface;
import org.jmol.api.MOCalculationInterface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class IsoMOReader
extends AtomDataReader {
    IsoMOReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
    }

    protected void setup() {
        super.setup();
        this.doAddHydrogens = false;
        this.getAtoms(this.params.qm_marginAngstroms, true, false);
        this.setHeader("MO", "calculation type: " + this.params.moData.get("calculationType"));
        this.setRangesAndAddAtoms(this.params.qm_ptsPerAngstrom, this.params.qm_gridMax, this.myAtomCount);
        int n = this.params.title.length;
        while (--n >= 0) {
            this.fixTitleLine(n, this.params.mo);
        }
    }

    private void fixTitleLine(int n, Hashtable hashtable) {
        if (!this.fixTitleLine(n)) {
            return;
        }
        String string = this.params.title[n];
        int n2 = string.indexOf("%");
        if (string.length() == 0 || n2 < 0) {
            return;
        }
        int n3 = 0;
        if (string.indexOf("%F") >= 0) {
            string = TextFormat.formatString(string, "F", this.params.fileName);
        }
        if (string.indexOf("%I") >= 0) {
            string = TextFormat.formatString(string, "I", "" + this.params.qm_moNumber);
        }
        if (string.indexOf("%N") >= 0) {
            string = TextFormat.formatString(string, "N", "" + this.params.qmOrbitalCount);
        }
        if (string.indexOf("%E") >= 0) {
            string = TextFormat.formatString(string, "E", "" + hashtable.get("energy"));
        }
        if (string.indexOf("%U") >= 0) {
            string = TextFormat.formatString(string, "U", this.params.moData.containsKey("energyUnits") && ++n3 != 0 ? (String)this.params.moData.get("energyUnits") : "");
        }
        if (string.indexOf("%S") >= 0) {
            string = TextFormat.formatString(string, "S", hashtable.containsKey("symmetry") && ++n3 != 0 ? "" + hashtable.get("symmetry") : "");
        }
        if (string.indexOf("%O") >= 0) {
            string = TextFormat.formatString(string, "O", hashtable.containsKey("occupancy") && ++n3 != 0 ? "" + hashtable.get("occupancy") : "");
        }
        if (string.indexOf("%T") >= 0) {
            string = TextFormat.formatString(string, "T", hashtable.containsKey("type") && ++n3 != 0 ? "" + hashtable.get("type") : "");
        }
        boolean bl = string.indexOf("?") == 0;
        this.params.title[n] = !bl ? string : (n3 > 0 ? string.substring(1) : "");
    }

    protected void generateCube() {
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.voxelData = this.voxelData;
        MOCalculationInterface mOCalculationInterface = (MOCalculationInterface)Interface.getOptionInterface("quantum.MOCalculation");
        Hashtable hashtable = this.params.moData;
        float[] fArray = this.params.moCoefficients;
        if (fArray == null) {
            Vector vector = (Vector)hashtable.get("mos");
            int n = this.params.qm_moNumber;
            while (--n >= 0) {
                Logger.info(" generating isosurface data for MO " + (n + 1));
                Hashtable hashtable2 = (Hashtable)vector.get(n);
                fArray = (float[])hashtable2.get("coefficients");
                this.getData(mOCalculationInterface, hashtable, fArray, this.params.theProperty);
            }
        } else {
            this.getData(mOCalculationInterface, hashtable, fArray, null);
        }
    }

    private void getData(MOCalculationInterface mOCalculationInterface, Hashtable hashtable, float[] fArray, float[] fArray2) {
        switch (this.params.qmOrbitalType) {
            case 1: {
                mOCalculationInterface.calculate(this.volumeData, this.bsMySelected, (String)hashtable.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, (Vector)hashtable.get("shells"), (float[][])hashtable.get("gaussians"), (Hashtable)hashtable.get("atomicOrbitalOrder"), null, null, fArray, fArray2);
                break;
            }
            case 2: {
                mOCalculationInterface.calculate(this.volumeData, this.bsMySelected, (String)hashtable.get("calculationType"), this.atomData.atomXyz, this.atomData.firstAtomIndex, null, null, null, (int[][])hashtable.get("slaterInfo"), (float[][])hashtable.get("slaterData"), fArray, fArray2);
                break;
            }
        }
    }
}

