/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Point3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class EfvetReader
extends PolygonFileReader {
    EfvetReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("efvet file format\nvertices and triangles only\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
        this.hasColorData = true;
    }

    void getSurfaceData() throws Exception {
        this.getHeader();
        this.getVertices();
        this.getTriangles();
        Logger.info("efvet file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles");
    }

    private void getHeader() throws Exception {
        this.skipTo("<efvet", null);
        while ((this.line = this.br.readLine()).length() > 0 && this.line.indexOf(">") < 0) {
            this.jvxlFileHeaderBuffer.append("# " + this.line + "\n");
        }
        Logger.info(this.jvxlFileHeaderBuffer.toString());
    }

    private void getVertices() throws Exception {
        Point3f point3f = new Point3f();
        float f = 0.0f;
        this.skipTo("<vertices", "count");
        this.jvxlData.vertexCount = this.nVertices = this.parseInt();
        this.skipTo("property=", null);
        this.line = this.line.replace('\"', ' ');
        String[] stringArray = this.getTokens();
        int n = this.params.fileIndex;
        if (n > 0 && n < stringArray.length) {
            Logger.info("property " + stringArray[n]);
        } else {
            Logger.info(this.line);
        }
        for (int i = 0; i < this.nVertices; ++i) {
            this.skipTo("<vertex", "image");
            point3f.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
            this.skipTo(null, "property");
            for (int j = 0; j < n; ++j) {
                f = this.parseFloat();
            }
            this.addVertexCopy(point3f, f, i);
        }
    }

    private void getTriangles() throws Exception {
        this.skipTo("<triangle_array", "count");
        this.nTriangles = this.parseInt();
        for (int i = 0; i < this.nTriangles; ++i) {
            this.skipTo("<triangle", "vertex");
            this.addTriangleCheck(this.parseInt() - 1, this.parseInt() - 1, this.parseInt() - 1, 7, false, 0);
        }
    }
}

