/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;

public class Hermite3D {
    private JmolRendererInterface g3d;
    private final Point3i[] pLeft = new Point3i[16];
    private final Point3i[] pRight = new Point3i[16];
    private final float[] sLeft = new float[16];
    private final float[] sRight = new float[16];
    int sp;
    private final Point3f[] pTopLeft = new Point3f[16];
    private final Point3f[] pTopRight = new Point3f[16];
    private final Point3f[] pBotLeft = new Point3f[16];
    private final Point3f[] pBotRight = new Point3f[16];
    private final boolean[] needToFill = new boolean[16];
    private final Point3f a1;
    private final Point3f a2;
    private final Point3f b1;
    private final Point3f b2;
    private final Point3f c1;
    private final Point3f c2;
    private final Point3f d1;
    private final Point3f d2;
    private final Vector3f depth1;
    private final Vector3f T1;
    private final Vector3f T2;

    public Hermite3D(JmolRendererInterface jmolRendererInterface) {
        int n = 16;
        while (--n >= 0) {
            this.pLeft[n] = new Point3i();
            this.pRight[n] = new Point3i();
            this.pTopLeft[n] = new Point3f();
            this.pTopRight[n] = new Point3f();
            this.pBotLeft[n] = new Point3f();
            this.pBotRight[n] = new Point3f();
        }
        this.a1 = new Point3f();
        this.a2 = new Point3f();
        this.b1 = new Point3f();
        this.b2 = new Point3f();
        this.c1 = new Point3f();
        this.c2 = new Point3f();
        this.d1 = new Point3f();
        this.d2 = new Point3f();
        this.depth1 = new Vector3f();
        this.T1 = new Vector3f();
        this.T2 = new Vector3f();
        this.g3d = jmolRendererInterface;
    }

    public void render(boolean bl, int n, int n2, int n3, int n4, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        if (point3i.z == 1 || point3i2.z == 1 || point3i3.z == 1 || point3i4.z == 1) {
            return;
        }
        if (this.g3d.isClippedZ(point3i2.z) || this.g3d.isClippedZ(point3i3.z)) {
            return;
        }
        int n5 = point3i2.x;
        int n6 = point3i2.y;
        int n7 = point3i2.z;
        int n8 = point3i3.x;
        int n9 = point3i3.y;
        int n10 = point3i3.z;
        int n11 = (n8 - point3i.x) * n / 8;
        int n12 = (n9 - point3i.y) * n / 8;
        int n13 = (n10 - point3i.z) * n / 8;
        int n14 = (point3i4.x - n5) * n / 8;
        int n15 = (point3i4.y - n6) * n / 8;
        int n16 = (point3i4.z - n7) * n / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].set(point3i2);
        this.sRight[0] = 1.0f;
        this.pRight[0].set(point3i3);
        this.sp = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        if (bl) {
            n18 = 2 * (n3 - n2);
            n19 = 2 * (n4 - n3);
        }
        do {
            int n20;
            Point3i point3i5 = this.pLeft[this.sp];
            Point3i point3i6 = this.pRight[this.sp];
            int n21 = point3i6.x - point3i5.x;
            if (n21 >= -1 && n21 <= 1 && (n20 = point3i6.y - point3i5.y) >= -1 && n20 <= 1) {
                ++n17;
                float f = this.sLeft[this.sp];
                if (bl) {
                    int n22 = f < 0.5f ? n2 + (int)((float)n18 * f) : n3 + (int)((float)n19 * (f - 0.5f));
                    this.g3d.fillSphereCentered(n22, point3i5);
                } else {
                    this.g3d.plotPixelClipped(point3i5);
                }
                --this.sp;
                continue;
            }
            double d = (this.sLeft[this.sp] + this.sRight[this.sp]) / 2.0f;
            double d2 = d * d;
            double d3 = d2 * d;
            double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
            double d5 = -2.0 * d3 + 3.0 * d2;
            double d6 = d3 - 2.0 * d2 + d;
            double d7 = d3 - d2;
            if (this.sp >= 15) break;
            Point3i point3i7 = this.pRight[this.sp + 1];
            point3i7.x = (int)(d4 * (double)n5 + d5 * (double)n8 + d6 * (double)n11 + d7 * (double)n14);
            point3i7.y = (int)(d4 * (double)n6 + d5 * (double)n9 + d6 * (double)n12 + d7 * (double)n15);
            point3i7.z = (int)(d4 * (double)n7 + d5 * (double)n10 + d6 * (double)n13 + d7 * (double)n16);
            this.pRight[this.sp + 1] = this.pRight[this.sp];
            this.sRight[this.sp + 1] = this.sRight[this.sp];
            this.pRight[this.sp] = point3i7;
            this.sRight[this.sp] = (float)d;
            ++this.sp;
            this.pLeft[this.sp].set(point3i7);
            this.sLeft[this.sp] = (float)d;
        } while (this.sp >= 0);
    }

    private void render2x(boolean bl, int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4, Point3i point3i5, Point3i point3i6, Point3i point3i7, Point3i point3i8) {
        int n2;
        Point3i point3i9;
        Point3i point3i10;
        int n3;
        Point3i[] point3iArray = new Point3i[]{point3i3, point3i2, point3i7, point3i6};
        Vector<Point3i> vector = new Vector<Point3i>(10);
        int n4 = 0;
        int n5 = 2;
        float f = 5.0f;
        if (bl) {
            f = 10.0f;
        }
        float f2 = 1.0f / f;
        float f3 = 0.0f;
        int n6 = point3i2.x;
        int n7 = point3i2.y;
        int n8 = point3i2.z;
        int n9 = point3i3.x;
        int n10 = point3i3.y;
        int n11 = point3i3.z;
        int n12 = (n9 - point3i.x) * n / 8;
        int n13 = (n10 - point3i.y) * n / 8;
        int n14 = (n11 - point3i.z) * n / 8;
        int n15 = (point3i4.x - n6) * n / 8;
        int n16 = (point3i4.y - n7) * n / 8;
        int n17 = (point3i4.z - n8) * n / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].set(point3i2);
        this.sRight[0] = 1.0f;
        this.pRight[0].set(point3i3);
        this.sp = 0;
        for (n3 = 2; n3 > 0; --n3) {
            if (n3 == 1) {
                n6 = point3i6.x;
                n7 = point3i6.y;
                n8 = point3i6.z;
                n9 = point3i7.x;
                n10 = point3i7.y;
                n11 = point3i7.z;
                n12 = (n9 - point3i5.x) * n / 8;
                n13 = (n10 - point3i5.y) * n / 8;
                n14 = (n11 - point3i5.z) * n / 8;
                n15 = (point3i8.x - n6) * n / 8;
                n16 = (point3i8.y - n7) * n / 8;
                n17 = (point3i8.z - n8) * n / 8;
                this.sLeft[0] = 0.0f;
                this.pLeft[0].set(point3i6);
                this.sRight[0] = 1.0f;
                this.pRight[0].set(point3i7);
                this.sp = 0;
            }
            vector.addElement(point3iArray[n4++]);
            f3 = f2;
            do {
                point3i10 = this.pLeft[this.sp];
                point3i9 = this.pRight[this.sp];
                int n18 = point3i9.x - point3i10.x;
                int n19 = point3i9.y - point3i10.y;
                n2 = n18 * n18 + n19 * n19;
                if (n2 <= 2) {
                    float f4 = this.sLeft[this.sp];
                    this.g3d.fillSphereCentered(3, point3i10);
                    if (f4 < 1.0f - f3) {
                        Point3i point3i11 = new Point3i();
                        point3i11.set(point3i10);
                        vector.addElement(point3i11);
                        f3 += f2;
                        if (n3 == 2) {
                            ++n5;
                        }
                    }
                    --this.sp;
                    continue;
                }
                double d = (this.sLeft[this.sp] + this.sRight[this.sp]) / 2.0f;
                double d2 = d * d;
                double d3 = d2 * d;
                double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
                double d5 = -2.0 * d3 + 3.0 * d2;
                double d6 = d3 - 2.0 * d2 + d;
                double d7 = d3 - d2;
                if (this.sp >= 15) break;
                Point3i point3i12 = this.pRight[this.sp + 1];
                point3i12.x = (int)(d4 * (double)n6 + d5 * (double)n9 + d6 * (double)n12 + d7 * (double)n15);
                point3i12.y = (int)(d4 * (double)n7 + d5 * (double)n10 + d6 * (double)n13 + d7 * (double)n16);
                point3i12.z = (int)(d4 * (double)n8 + d5 * (double)n11 + d6 * (double)n14 + d7 * (double)n17);
                this.pRight[this.sp + 1] = this.pRight[this.sp];
                this.sRight[this.sp + 1] = this.sRight[this.sp];
                this.pRight[this.sp] = point3i12;
                this.sRight[this.sp] = (float)d;
                ++this.sp;
                this.pLeft[this.sp].set(point3i12);
                this.sLeft[this.sp] = (float)d;
            } while (this.sp >= 0);
            vector.addElement(point3iArray[n4++]);
        }
        n3 = vector.size();
        if (bl) {
            point3i10 = null;
            point3i9 = null;
            Point3i point3i13 = null;
            Point3i point3i14 = null;
            for (n2 = 1; n2 < n5 && n2 + n5 < n3; ++n2) {
                point3i10 = (Point3i)vector.elementAt(n2 - 1);
                point3i9 = (Point3i)vector.elementAt(n5 + (n2 - 1));
                point3i13 = (Point3i)vector.elementAt(n2);
                point3i14 = (Point3i)vector.elementAt(n5 + n2);
                this.g3d.fillTriangle(point3i10, point3i9, point3i13);
                this.g3d.fillTriangle(point3i14, point3i13, point3i9);
            }
            if (n5 * 2 != n3) {
                this.g3d.fillTriangle(point3i2, point3i6, point3i13);
                this.g3d.fillTriangle(point3i14, point3i13, point3i6);
            }
        } else {
            for (int i = 0; i < n5 && i + n5 < n3; ++i) {
                this.g3d.drawLine((Point3i)vector.elementAt(i), (Point3i)vector.elementAt(i + n5));
            }
        }
    }

    private static void set(Point3f point3f, Point3i point3i) {
        point3f.x = point3i.x;
        point3f.y = point3i.y;
        point3f.z = point3i.z;
    }

    public void render2(boolean bl, boolean bl2, int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4, Point3i point3i5, Point3i point3i6, Point3i point3i7, Point3i point3i8, int n2) {
        if (point3i.z == 1 || point3i2.z == 1 || point3i3.z == 1 || point3i4.z == 1 || point3i5.z == 1 || point3i6.z == 1 || point3i7.z == 1 || point3i8.z == 1) {
            return;
        }
        if (!bl) {
            this.render2x(bl, n, point3i, point3i2, point3i3, point3i4, point3i5, point3i6, point3i7, point3i8);
            return;
        }
        float f = 1.0f / (float)n2;
        int n3 = point3i2.x;
        int n4 = point3i2.y;
        int n5 = point3i2.z;
        int n6 = point3i3.x;
        int n7 = point3i3.y;
        int n8 = point3i3.z;
        int n9 = (n6 - point3i.x) * n / 8;
        int n10 = (n7 - point3i.y) * n / 8;
        int n11 = (n8 - point3i.z) * n / 8;
        int n12 = (point3i4.x - n3) * n / 8;
        int n13 = (point3i4.y - n4) * n / 8;
        int n14 = (point3i4.z - n5) * n / 8;
        Hermite3D.set(this.pTopLeft[0], point3i2);
        Hermite3D.set(this.pTopRight[0], point3i3);
        int n15 = point3i6.x;
        int n16 = point3i6.y;
        int n17 = point3i6.z;
        int n18 = point3i7.x;
        int n19 = point3i7.y;
        int n20 = point3i7.z;
        int n21 = (n18 - point3i5.x) * n / 8;
        int n22 = (n19 - point3i5.y) * n / 8;
        int n23 = (n20 - point3i5.z) * n / 8;
        int n24 = (point3i8.x - n15) * n / 8;
        int n25 = (point3i8.y - n16) * n / 8;
        int n26 = (point3i8.z - n17) * n / 8;
        Hermite3D.set(this.pBotLeft[0], point3i6);
        Hermite3D.set(this.pBotRight[0], point3i7);
        this.sLeft[0] = 0.0f;
        this.sRight[0] = 1.0f;
        this.needToFill[0] = true;
        this.sp = 0;
        boolean bl3 = false;
        do {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            Point3f point3f = this.pTopLeft[this.sp];
            Point3f point3f2 = this.pTopRight[this.sp];
            double d7 = point3f2.x - point3f.x;
            double d8 = d7 * d7;
            if (d8 < 10.0 && (d6 = (d5 = (double)(point3f2.y - point3f.y)) * d5) < 10.0) {
                Point3f point3f3 = this.pBotLeft[this.sp];
                Point3f point3f4 = this.pBotRight[this.sp];
                d4 = point3f4.x - point3f3.x;
                d3 = d4 * d4;
                if (d3 < 8.0 && (d2 = (d = (double)(point3f4.y - point3f3.y)) * d) < 8.0) {
                    if (bl2) {
                        this.g3d.fillSphereCentered(3, point3f);
                        this.g3d.fillSphereCentered(3, point3f3);
                    }
                    if (this.needToFill[this.sp]) {
                        if (n2 > 0) {
                            this.setDepth(this.depth1, point3f3, point3f, point3f2, f);
                            this.setPoint(this.a1, point3f, this.depth1, 1);
                            this.setPoint(this.a2, point3f, this.depth1, -1);
                            this.setPoint(this.b1, point3f2, this.depth1, 1);
                            this.setPoint(this.b2, point3f2, this.depth1, -1);
                            this.setPoint(this.c1, point3f3, this.depth1, 1);
                            this.setPoint(this.c2, point3f3, this.depth1, -1);
                            this.setPoint(this.d1, point3f4, this.depth1, 1);
                            this.setPoint(this.d2, point3f4, this.depth1, -1);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.d1, this.c1);
                            this.g3d.fillQuadrilateral(this.a2, this.b2, this.d2, this.c2);
                            this.g3d.fillQuadrilateral(this.a1, this.b1, this.b2, this.a2);
                            this.g3d.fillQuadrilateral(this.c1, this.d1, this.d2, this.c2);
                            bl3 = true;
                        } else {
                            this.g3d.fillQuadrilateral(point3f, point3f2, point3f4, point3f3);
                        }
                        this.needToFill[this.sp] = false;
                    }
                    if (d8 + d6 < 2.0 && d3 + d2 < 2.0) {
                        --this.sp;
                        continue;
                    }
                }
            }
            d5 = (this.sLeft[this.sp] + this.sRight[this.sp]) / 2.0f;
            d6 = d5 * d5;
            double d9 = d6 * d5;
            d4 = 2.0 * d9 - 3.0 * d6 + 1.0;
            d3 = -2.0 * d9 + 3.0 * d6;
            d = d9 - 2.0 * d6 + d5;
            d2 = d9 - d6;
            if (this.sp >= 15) break;
            int n27 = this.sp + 1;
            Point3f point3f5 = this.pTopRight[n27];
            point3f5.x = (float)(d4 * (double)n3 + d3 * (double)n6 + d * (double)n9 + d2 * (double)n12);
            point3f5.y = (float)(d4 * (double)n4 + d3 * (double)n7 + d * (double)n10 + d2 * (double)n13);
            point3f5.z = (float)(d4 * (double)n5 + d3 * (double)n8 + d * (double)n11 + d2 * (double)n14);
            Point3f point3f6 = this.pBotRight[n27];
            point3f6.x = (float)(d4 * (double)n15 + d3 * (double)n18 + d * (double)n21 + d2 * (double)n24);
            point3f6.y = (float)(d4 * (double)n16 + d3 * (double)n19 + d * (double)n22 + d2 * (double)n25);
            point3f6.z = (float)(d4 * (double)n17 + d3 * (double)n20 + d * (double)n23 + d2 * (double)n26);
            this.pTopRight[n27] = this.pTopRight[this.sp];
            this.pTopRight[this.sp] = point3f5;
            this.pBotRight[n27] = this.pBotRight[this.sp];
            this.pBotRight[this.sp] = point3f6;
            this.sRight[n27] = this.sRight[this.sp];
            this.sRight[this.sp] = (float)d5;
            this.needToFill[n27] = this.needToFill[this.sp];
            this.pTopLeft[n27].set(point3f5);
            this.pBotLeft[n27].set(point3f6);
            this.sLeft[n27] = (float)d5;
            ++this.sp;
        } while (this.sp >= 0);
        if (bl3) {
            this.a1.z += 1.0f;
            this.c1.z += 1.0f;
            this.c2.z += 1.0f;
            this.a2.z += 1.0f;
            this.g3d.fillQuadrilateral(this.a1, this.c1, this.c2, this.a2);
        }
    }

    private void setDepth(Vector3f vector3f, Point3f point3f, Point3f point3f2, Point3f point3f3, float f) {
        this.T1.sub(point3f2, point3f);
        this.T1.scale(f);
        this.T2.sub(point3f2, point3f3);
        vector3f.cross(this.T1, this.T2);
        vector3f.scale(this.T1.length() / vector3f.length());
    }

    private void setPoint(Point3f point3f, Point3f point3f2, Vector3f vector3f, int n) {
        point3f.set(point3f2);
        if (n == 1) {
            point3f.add(vector3f);
        } else {
            point3f.sub(vector3f);
        }
    }

    static void getHermiteList(int n, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, Tuple3f tuple3f5, Tuple3f[] tuple3fArray, int n2, int n3) {
        int n4 = n3 + 1;
        float f = n3 - 1;
        float f2 = tuple3f2.x;
        float f3 = tuple3f2.y;
        float f4 = tuple3f2.z;
        float f5 = tuple3f3.x;
        float f6 = tuple3f3.y;
        float f7 = tuple3f3.z;
        float f8 = (f5 - tuple3f.x) * (float)n / 8.0f;
        float f9 = (f6 - tuple3f.y) * (float)n / 8.0f;
        float f10 = (f7 - tuple3f.z) * (float)n / 8.0f;
        float f11 = (tuple3f4.x - f2) * (float)n / 8.0f;
        float f12 = (tuple3f4.y - f3) * (float)n / 8.0f;
        float f13 = (tuple3f4.z - f4) * (float)n / 8.0f;
        float f14 = (tuple3f5.x - f5) * (float)n / 8.0f;
        float f15 = (tuple3f5.y - f6) * (float)n / 8.0f;
        float f16 = (tuple3f5.z - f7) * (float)n / 8.0f;
        tuple3fArray[n2] = tuple3f2;
        for (int i = 0; i < n4; ++i) {
            double d = (float)i / f;
            if (i == n4 - 1) {
                f2 = f5;
                f3 = f6;
                f4 = f7;
                f5 = tuple3f4.x;
                f6 = tuple3f4.y;
                f7 = tuple3f4.z;
                f8 = f11;
                f9 = f12;
                f10 = f13;
                f11 = f14;
                f12 = f15;
                f13 = f16;
                d -= 1.0;
            }
            double d2 = d * d;
            double d3 = d2 * d;
            double d4 = 2.0 * d3 - 3.0 * d2 + 1.0;
            double d5 = -2.0 * d3 + 3.0 * d2;
            double d6 = d3 - 2.0 * d2 + d;
            double d7 = d3 - d2;
            float f17 = (float)(d4 * (double)f2 + d5 * (double)f5 + d6 * (double)f8 + d7 * (double)f11);
            float f18 = (float)(d4 * (double)f3 + d5 * (double)f6 + d6 * (double)f9 + d7 * (double)f12);
            float f19 = (float)(d4 * (double)f4 + d5 * (double)f7 + d6 * (double)f10 + d7 * (double)f13);
            tuple3fArray[n2 + i] = tuple3fArray instanceof Point3f[] ? new Point3f(f17, f18, f19) : new Vector3f(f17, f18, f19);
        }
    }
}

