/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class GamessUSReader
extends GamessReader {
    private int headerType;
    private String[] filterTokens;
    private boolean filterIsNot;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("gamess");
        try {
            this.readLine();
            boolean bl = false;
            while (this.line != null) {
                boolean bl2 = this.line.indexOf("COORDINATES (BOHR)") >= 0;
                if (bl2 || this.line.indexOf("COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
                    if (this.doGetModel(++this.modelNumber)) {
                        if (bl2) {
                            this.readAtomsInBohrCoordinates();
                        } else {
                            this.readAtomsInAngstromCoordinates();
                        }
                        bl = true;
                        this.readLine();
                        continue;
                    }
                    if (this.isLastModel(this.modelNumber) && bl) break;
                    bl = false;
                }
                if (bl) {
                    if (this.line.indexOf("FREQUENCIES IN CM") >= 0) {
                        this.readFrequencies();
                    } else {
                        if (this.line.indexOf("ATOMIC BASIS SET") >= 0) {
                            this.readGaussianBasis("SHELL TYPE", "TOTAL");
                            continue;
                        }
                        if (this.line.indexOf("SUMMARY OF THE EFFECTIVE FRAGMENT") >= 0) {
                            this.readEFPInBohrCoordinates();
                            continue;
                        }
                        if (this.line.indexOf("  EIGENVECTORS") >= 0 || this.line.indexOf("  INITIAL GUESS ORBITALS") >= 0 || this.line.indexOf("  MCSCF OPTIMIZED ORBITALS") >= 0 || this.line.indexOf("  MCSCF NATURAL ORBITALS") >= 0 || this.line.indexOf("  MOLECULAR ORBITALS") >= 0 && this.line.indexOf("  MOLECULAR ORBITALS LOCALIZED BY THE POPULATION METHOD") < 0) {
                            if (this.filterMO()) {
                                this.headerType = 1;
                                this.readMolecularOrbitals();
                                continue;
                            }
                        } else if (this.line.indexOf("EDMISTON-RUEDENBERG ENERGY LOCALIZED ORBITALS") >= 0 || this.line.indexOf("  THE PIPEK-MEZEY POPULATION LOCALIZED ORBITALS ARE") >= 0) {
                            if (this.filterMO()) {
                                this.headerType = 0;
                                this.readMolecularOrbitals();
                                continue;
                            }
                        } else if (this.line.indexOf("  NATURAL ORBITALS IN ATOMIC ORBITAL BASIS") >= 0 && this.filterMO()) {
                            this.headerType = 2;
                            this.readMolecularOrbitals();
                            continue;
                        }
                    }
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private boolean filterMO() {
        boolean bl = true;
        int n = 0;
        if (this.filter != null) {
            this.line = this.line.toLowerCase();
            if (this.filterTokens == null) {
                this.filterIsNot = this.filter.indexOf("!") >= 0;
                this.filterTokens = AtomSetCollectionReader.getTokens(this.filter.replace('!', ' ').replace(',', ' ').replace(';', ' ').toLowerCase());
            }
            for (int i = 0; i < this.filterTokens.length; ++i) {
                if (this.line.indexOf(this.filterTokens[i]) >= 0) {
                    if (this.filterIsNot) continue;
                    n = this.filterTokens.length;
                    break;
                }
                if (!this.filterIsNot) continue;
                ++n;
            }
            bl = n == this.filterTokens.length;
        }
        Logger.info("filter MOs: " + bl + " " + this.line);
        return bl;
    }

    protected void readEFPInBohrCoordinates() throws Exception {
        int n = this.atomSetCollection.getAtomCount();
        this.discardLinesUntilContains("MULTIPOLE COORDINATES");
        this.readLine();
        this.readLine();
        while (this.readLine() != null && this.line.length() >= 72) {
            String string = this.line.substring(1, 2);
            if (string.charAt(0) == 'Z') {
                string = this.line.substring(2, 3);
            } else if (this.parseFloat(this.line, 67, 73) == 0.0f) continue;
            float f = this.parseFloat(this.line, 8, 25);
            float f2 = this.parseFloat(this.line, 25, 40);
            float f3 = this.parseFloat(this.line, 40, 56);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f, f2, f3);
            atom.scale(0.5291772f);
            this.atomNames.addElement(string);
        }
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        String string;
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (string = this.parseToken(this.line, 1, 6)) != null) {
            float f = this.parseFloat(this.line, 17, 37);
            float f2 = this.parseFloat(this.line, 37, 57);
            float f3 = this.parseFloat(this.line, 57, 77);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f, f2, f3);
            atom.scale(0.5291772f);
            this.atomNames.addElement(string);
        }
    }

    private void readAtomsInAngstromCoordinates() throws Exception {
        Atom atom;
        float f;
        float f2;
        float f3;
        String string;
        this.readLine();
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (string = this.parseToken(this.line, 1, 6)) != null) {
            f3 = this.parseFloat(this.line, 16, 31);
            f2 = this.parseFloat(this.line, 31, 46);
            f = this.parseFloat(this.line, 46, 61);
            if (Float.isNaN(f3) || Float.isNaN(f2) || Float.isNaN(f)) break;
            atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f3, f2, f);
            this.atomNames.addElement(string);
        }
        if (this.line.indexOf("COORDINATES OF FRAGMENT MULTIPOLE CENTERS (ANGS)") >= 0) {
            this.readLine();
            this.readLine();
            this.readLine();
            while (this.readLine() != null && (string = this.parseToken(this.line, 1, 2)) != null) {
                if (this.parseToken(this.line, 1, 2).equals("Z")) {
                    string = this.parseToken(this.line, 2, 3);
                } else {
                    if (this.parseToken(this.line, 1, 9).equals("FRAGNAME")) continue;
                    string = this.parseToken(this.line, 1, 2);
                }
                f3 = this.parseFloat(this.line, 16, 31);
                f2 = this.parseFloat(this.line, 31, 46);
                f = this.parseFloat(this.line, 46, 61);
                if (Float.isNaN(f3) || Float.isNaN(f2) || Float.isNaN(f)) break;
                atom = this.atomSetCollection.addNewAtom();
                atom.atomName = string + ++n;
                atom.set(f3, f2, f);
                this.atomNames.addElement(string);
            }
        }
    }

    protected String fixShellTag(String string) {
        return string;
    }

    protected void getMOHeader(String[] stringArray, Hashtable[] hashtableArray, int n) throws Exception {
        int n2;
        this.readLine();
        switch (this.headerType) {
            default: {
                return;
            }
            case 1: {
                stringArray = this.getTokens();
                if (stringArray.length == 0) {
                    stringArray = AtomSetCollectionReader.getTokens(this.readLine());
                }
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2].put("energy", new Float(stringArray[n2]));
                }
                this.readLine();
                break;
            }
            case 2: {
                n2 = this.line.length() > 0 || this.readLine() != null ? 1 : 0;
                stringArray = this.getTokens();
                for (int i = 0; i < n; ++i) {
                    hashtableArray[i].put("occupancy", new Float(stringArray[i].charAt(0) == '-' ? 2.0f : this.parseFloat(stringArray[i])));
                }
                this.readLine();
                if (n2 != 0) break;
                return;
            }
        }
        if (this.line.length() > 0) {
            stringArray = this.getTokens();
            for (n2 = 0; n2 < n; ++n2) {
                hashtableArray[n2].put("symmetry", stringArray[n2]);
            }
        }
    }
}

