/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

void secure_exec(void);

	/* write to a writable file. */
void _filewrite(char *prefix, char *fname, char *content, char *type)
{
    char buf[MAX_LINELEN+1];
    FILE *f;
    if(strstr(fname,parent_dir_string)!=NULL){
	setenv(error_data_string,fname,1);
	module_error("illegal_fname"); return;
    }
    snprintf(buf,sizeof(buf),"%s/writable",prefix);
    mkdirs(buf);
    snprintf(buf+strlen(buf),sizeof(buf)-strlen(buf),"/%s",fname);
    f=fopen(buf,type); if(f==NULL) return;
    fprintf(f,"%s\n",content);
    fclose(f);
}

	/* write to a file in module */
void filewrite(char *p)
{
    char *p1, *p2;
    secure_exec();
    p1=find_word_start(p);
    p2=find_word_end(p1);
    if(*p1==0) {*p=0;return;}
    if(*p2!=0) *p2++=0;
    _filewrite(module_prefix,p1,p2,"w");
    *p=0;
}

	/* append to a file in module */
void fileappend(char *p)
{
    char *p1, *p2;
    secure_exec();
    p1=find_word_start(p);
    p2=find_word_end(p1);
    if(*p1==0) {*p=0;return;}
    if(*p2!=0) *p2++=0;
    _filewrite(module_prefix,p1,p2,"a");
    *p=0;
}

