/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

enum {pt_int, pt_rat, pt_real, pt_complex, pt_func, pt_text, pt_matrix};
int prepcnt;
int ex_statement=0, ex_hint=0, ex_help=0, ex_solution=0;
char vbuf_statement[MAX_LINELEN+1];
char vbuf_hint[MAX_LINELEN+1];
char vbuf_help[MAX_LINELEN+1];
char vbuf_solution[MAX_LINELEN+1];

#include "sp.c"

	/* empty processor, template. */
void empty(char *p[MAX_PARM]) {}

void p_author(char *p[MAX_PARM])
{
    p[0]=find_word_start(p[0]);
    if(strlen(p[0])>128) p[0][128]=0;
    fprintf(outf,"author=%s\n",p[0]);
}

void p_email(char *p[MAX_PARM])
{
    p[0]=find_word_start(p[0]);
    if(strlen(p[0])>128) p[0][128]=0;
    fprintf(outf,"email=%s\n",p[0]);
}

void p_computeanswer(char *p[MAX_PARM])
{   
    p[0]=find_word_start(p[0]);
    *find_word_end(p[0])=0;
    if(strcasecmp(p[0],"yes"))
      fprintf(outf,"computeanswer=no\n");
    else fprintf(outf,"computeanswer=%s\n",p[0]);
}

void p_precision(char *p[MAX_PARM])
{
    int pr;
    pr=atoi(p[0]);
    if(pr<0 || pr>100000000) return;
    fprintf(outf,"precision=%d\n",pr);
}

void p_wims(char *p[MAX_PARM])
{
    char vbuf[MAX_LINELEN+1];
    snprintf(vbuf,sizeof(vbuf),"%s",p[0]); subst(vbuf);
    	/* the second condition could be removed?
	 * To be very careful! */
    if(strchr(vbuf,'=')==NULL || strchr(vbuf,'!')!=NULL) return;
    fprintf(outf,"%s\n",vbuf);    
}

void p_mdef(char *p[MAX_PARM])
{
    char vbuf[MAX_LINELEN+1];
    if(wordchr(mdef,p[0])==NULL) return;
    snprintf(vbuf,sizeof(vbuf),"%s",p[1]); subst(vbuf);
    	/* the second condition could be removed?
	 * To be very careful! */
    if(strchr(vbuf,'!')!=NULL) return;
    fprintf(outf,"m_%s=%s\n",p[0],vbuf);
}

void p_range(char *p[MAX_PARM])
{
    double left, right;
    char *pp;
    pp=strstr(p[0],"..");
    if(pp==NULL) return;
    *pp=0;pp+=strlen("..");
    left=atof(p[0]); right=atof(pp);
    if(left>=right-1E-50 || left<-1E50 || right>1E50) return;
    fprintf(outf,"leftrange=%f\nrightrange=%f\n",left,right);
}

void p_language(char *p[MAX_PARM])
{   
    p[0]=find_word_start(p[0]);
    *find_word_end(p[0])=0;
    if(strlen(p[0])==2) fprintf(outf,"language=%s\n",p[0]); 
}

void p_statement(char *p[MAX_PARM])
{
    if(ex_statement<0) return;
    if(ex_statement>0 || p==NULL) {
	out_exec(vbuf_statement,"question");
	ex_statement=-1; return;
    }
    if(p==NULL) return;
    snprintf(vbuf_statement,sizeof(vbuf_statement),"%s",p[0]);
    subst(vbuf_statement);
    if(strcmp(format,"html")!=0) {
	fprintf(outf,"question=!nosubst %s\n",vbuf_statement);
	ex_statement=-1;
    }
    else {
	fprintf(outf,"question=%s\n",executed_str);
	ex_statement=1;
    }
}

void p_hint(char *p[MAX_PARM])
{
    if(ex_hint<0) return;
    if(ex_hint>0 || p==NULL) {
	out_exec(vbuf_hint,"hint");
	ex_hint=-1; return;
    }
    snprintf(vbuf_hint,sizeof(vbuf_hint),"%s",p[0]); subst(vbuf_hint);
    fprintf(outf,"hint=%s\n",executed_str);
    ex_hint=1;
}

void p_help(char *p[MAX_PARM])
{
    if(ex_help<0) return;
    if(ex_help>0 || p==NULL) {
	out_exec(vbuf_help,"help");
	ex_help=-1; return;
    }
    snprintf(vbuf_help,sizeof(vbuf_help),"%s",p[0]); subst(vbuf_help);
    fprintf(outf,"help=%s\n",executed_str);
    ex_help=1;
}

void p_solution(char *p[MAX_PARM])
{
    if(ex_solution<0) return;
    if(ex_solution>0 || p==NULL) {
	out_exec(vbuf_solution,"solution");
	ex_solution=-1; return;
    }
    snprintf(vbuf_solution,sizeof(vbuf_solution),"%s",p[0]);
    subst(vbuf_solution);
    fprintf(outf,"solution=%s\n",executed_str);
    ex_solution=1;
}

enum {typ_default, typ_num, typ_func, typ_units, typ_text,
      typ_formal,typ_matrix,typ_vector,typ_set,typ_equation,
      typ_case, typ_nocase, typ_atext, typ_wlist,
      typ_algexp, typ_litexp, typ_menu
};

struct {
    char *name;
    int  type;
    char *def;
} anstype[]={
      {"algexp",	typ_algexp,	"algexp"},
      {"aset",		typ_set,	"aset"},
      {"atext",		typ_atext,	"atext"},
      {"case",		typ_case,	"case"},
      {"checkbox",	typ_menu,	"checkbox"},
      {"chset",		typ_atext,	"chset"},
      {"click",		typ_menu,	"click"},
      {"default",	typ_default,	"default"},
      {"equation",	typ_equation,	"equation"},
      {"expalg",	typ_algexp,	"algexp"},
      {"formal",	typ_formal,	"formal"},
      {"fset",		typ_set,	"fset"},
      {"function",	typ_func,	"function"},
      {"link",		typ_menu,	"click"},
      {"litexp",	typ_litexp,	"litexp"},
      {"matrix",	typ_matrix,	"matrix"},
      {"menu",		typ_menu,	"menu"},
      {"nocase",	typ_nocase,	"nocase"},
      {"number",	typ_num,	"numeric"},
      {"numeric",	typ_num,	"numeric"},
      {"radio",		typ_menu,	"radio"},
      {"select",	typ_menu,	"menu"},
      {"set",		typ_set,	"set"},
      {"text",		typ_text,	"case"},
      {"unit",		typ_units,	"units"},
      {"units",		typ_units,	"units"},
      {"vector",	typ_vector,	"vector"},
      {"wlist",		typ_wlist,	"wlist"}
};

#define anstype_no (sizeof(anstype)/sizeof(anstype[0]))

void p_answer(char *p[MAX_PARM])
{
    char *pp, vbuf[MAX_LINELEN+1],nbuf[MAX_LINELEN+1];
    int i,j,k,typ;
    
	/* look for type definition */
    typ=typ_default;
    for(i=0;i<3;i++) {
	p[i]=find_word_start(p[i]);
	if(strncasecmp(p[i],"type",strlen("type"))==0) {
	    char *tt;
	    tt=find_word_start(p[i]+strlen("type"));
	    if(*tt=='=') {
		for(j=i+1;j<3;j++) p[j-1]=p[j];
		tt=find_word_start(tt+1); *find_word_end(tt)=0;
		if(isalpha(*tt)) {
		    k=search_list(anstype,anstype_no,sizeof(anstype[0]),tt);
		    	/* unknown type is simply ignored */
		    if(k>=0) {
			fprintf(outf,"replytype%d=%s\n",
				answercnt,anstype[k].def);
			typ=anstype[k].type;
		    }
		}
		break;
	    }
	}
    }
    p[0]=find_word_start(p[0]);
    strncpy(nbuf,p[0],MAX_LINELEN); nbuf[MAX_LINELEN]=0; subst(nbuf);
    nbuf[MAX_PROMPTLEN]=0;
    strip_trailing_spaces(nbuf); pp=nbuf+strlen(nbuf)-1;
    if(*pp=='=') *pp=0;
    p[1]=find_word_start(p[1]);
    if(*p[1]=='\\' && (isalnum(*(p[1]+1)) || *(p[1]+1)=='_')) {
		/* check for analyzed answers */
	int i,n;
	strncpy(vbuf,p[1]+1,MAX_LINELEN); vbuf[MAX_LINELEN]=0;
	strip_trailing_spaces(vbuf); n=strlen(vbuf);
	if(n>=MAX_NAMELEN) goto normal;
	for(i=0;i<n && (isalnum(vbuf[i]) || vbuf[i]=='_');i++);
	if(i<n) goto normal;
	for(i=varcnt-1;i>=1 && strcmp(vbuf,param[i].name)!=0;i--);
	if(i<1) {	/* unused name; the answer should be analyzed */
	    char *pm;
	    pm=xmalloc(MAX_NAMELEN+2);
	    strcpy(pm,vbuf); param[varcnt].name=pm;
	    param[varcnt].type=pt_real;
	    param[varcnt].save=1;
	    fprintf(outf,"replyname%d=%s\nreplygood%d=?analyze %d\n",
		    answercnt,nbuf,answercnt,varcnt);
	    condans++; answercnt++; varcnt++; return;
	}
    }
    normal:
    strncpy(vbuf,p[1],MAX_LINELEN); vbuf[MAX_LINELEN]=0;
    subst(vbuf);
    switch(typ) {
	default:
	case typ_default: {
	    fprintf(outf,"replyname%d=%s\nreplygood%d=%s\n",
		    answercnt,nbuf,answercnt,vbuf);
	    break;
	}
	case typ_num: {
	    fprintf(outf,"replyname%d=%s\nreplygood%d=$[%s]\n",
		    answercnt,nbuf,answercnt,vbuf);
	    break;
	}
	case typ_equation:
	case typ_func: {
	    fprintf(outf,"replyname%d=%s\nreplygood%d=!rawmath %s\n",
		    answercnt,nbuf,answercnt,vbuf);
	    break;
	}
	case typ_units: {
	    fprintf(outf,"replyname%d=%s\nreplygood%d=%s\n",
		    answercnt,nbuf,answercnt,vbuf);
	    break;
	}
    }
    answercnt++;
}

void p_choice(char *p[MAX_PARM])
{
    char buf1[MAX_LINELEN+1],buf2[MAX_LINELEN+1],nbuf[MAX_LINELEN+1];
    p[0]=find_word_start(p[0]);
    snprintf(buf1,sizeof(buf1),"%s",p[1]); subst(buf1);
    snprintf(buf2,sizeof(buf2),"%s",p[2]); subst(buf2);
    snprintf(nbuf,sizeof(nbuf),"%s",p[0]); subst(nbuf);
    nbuf[MAX_PROMPTLEN]=0;
    fprintf(outf,"choicename%d=%s\nchoicegood%d=%s\nchoicebad%d=%s\n",
	    choicecnt,nbuf,choicecnt,buf1,choicecnt,buf2);
    choicecnt++;
}

void putval(char *p, int n, int ptype)
{
    switch(ptype) {
	case pt_int: {
	    fprintf(outf,"val%d=$[rint(%s)]\n",n,p);
	    break;
	}
	case pt_real: {
	    fprintf(outf,"val%d=$[%s]\n",n,p);
	    break;
	}
	case pt_func: {
	    fprintf(outf,"val%d=!rawmath %s\n",n,p);
	    break;
	}
	case pt_complex: {
	    fprintf(outf,"t_=!rawmath %s\nt_=!exec pari print($t_)\n\
val%d=!mathsubst I=i in $t_\n",p,n);
	    break;
	}
	case pt_matrix: {
	    fprintf(outf,"tmp=!trim %s\n\
val%d=!translate internal $	\\\n$ to ;; in $tmp\n",p,n);
	    break;
	}
	case pt_rat: {
	    fprintf(outf,"t_=!rawmath %s\n\
val%d=!exec pari print($t_)\n",p,n);
	    break;
	}
	default: {
	    fprintf(outf,"val%d=%s\n",n,p);
	    break;
	}
    }
}

void parm(char *p[MAX_PARM], int ptype)
{
    char *pp, *p2;
    char vbuf[MAX_LINELEN+1];
    int i;

    p[0]=find_word_start(p[0]);
    if(*p[0]=='\\') p[0]++;
    	/* bad name */
    if(!isalpha(*p[0])) return;
    strip_trailing_spaces(p[0]);
    for(pp=p[0];*pp;pp++) if(!isalnum(*pp) && *pp!='_') {
	/* bad name and security risk */
	if(!isspace(*pp)) return;
	strcpy(pp,pp+1); pp--;
    }
    for(i=1;i<varcnt && strcmp(p[0],param[i].name)!=0;i++);
    p[1]=find_word_start(p[1]);
    snprintf(vbuf,sizeof(vbuf),"%s",p[1]); subst(vbuf);
    if(deftag) repsubst(vbuf);
    if((pp=strparchr(vbuf,'?'))!=NULL) {
	char buf[MAX_LINELEN+1];
	p2=strparchr(pp,':'); *pp++=0; if(p2!=NULL) *p2++=0;
	snprintf(buf,sizeof(buf),"%s",vbuf);
	prepcnt=0; parmprep(buf,ptype);
	fprintf(outf,"\n!ifval %s\n",buf);
	snprintf(buf,sizeof(buf),"%s",pp);
	parmprep(buf,ptype); putval(buf,i,ptype);
	if(p2!=NULL) {
	    fprintf(outf,"!else\n");
	    snprintf(buf,sizeof(buf),"%s",p2);
	    parmprep(buf,ptype); putval(buf,i,ptype);
	}
	fprintf(outf,"!endif\n");
    }
    else {
	prepcnt=0; parmprep(vbuf, ptype);
	putval(vbuf,i,ptype);
    }
    if(i>=varcnt && i<MAX_PARAM) {
	param[varcnt].name=p[0];
	param[varcnt].type=ptype;
	param[varcnt].save=0;
	varcnt++;
    }
}

void p_int(char *p[MAX_PARM]) {parm(p,pt_int);}
void p_rational(char *p[MAX_PARM]) {parm(p,pt_rat);}
void p_real(char *p[MAX_PARM]) {parm(p,pt_real);}
void p_complex(char *p[MAX_PARM]) {parm(p,pt_complex);}
void p_func(char *p[MAX_PARM]) {parm(p,pt_func);}
void p_text(char *p[MAX_PARM]) {parm(p,pt_text);}
void p_matrix(char *p[MAX_PARM]) {parm(p,pt_matrix);}

void p_parm(char *p[MAX_PARM])
{
    parm(p,pt_real);
}

void p_if(char *p[MAX_PARM])
{
    char vbuf[MAX_LINELEN+1];
    snprintf(vbuf,sizeof(vbuf),"%s",p[0]); subst(vbuf);
    if(deftag) repsubst(vbuf);
    prepcnt=0; parmprep(vbuf, pt_real);
    fprintf(outf,"!if %s \n",vbuf);
}

void p_else(char *p[MAX_PARM])
{
    fprintf(outf,"!else\n");
}

void p_endif(char *p[MAX_PARM])
{
    fprintf(outf,"!endif\n");
}

void p_endwhile(char *p[MAX_PARM])
{
    fprintf(outf,"!endwhile\n");
}

void p_for(char *p[MAX_PARM])
{
    char *p1, *p2, buf[256];
    char vbuf[MAX_LINELEN+1];
    int i;

    p1=find_word_start(p[0]);
    if(!isalpha(*p1)) return;
    for(p2=p1; isalnum(*p2); p2++);
    if(p2-p1>64) return;
    memmove(buf,p1,p2-p1); buf[p2-p1]=0;
    for(i=1;i<varcnt && strcmp(buf,param[i].name)!=0;i++);
    if(i>=varcnt && i<MAX_PARAM) {
	param[varcnt].name=p1;
	param[varcnt].type=pt_real;
	param[varcnt].save=0;
	varcnt++;
    }
    snprintf(vbuf,sizeof(vbuf),"%s",p2); subst(vbuf); *p2=0;
    if(deftag) repsubst(vbuf);
    prepcnt=0; parmprep(vbuf, pt_real);
    fprintf(outf,"!for val%d %s \n", i, vbuf);
}

void p_next(char *p[MAX_PARM])
{
    fprintf(outf,"!next\n");
}

void p_plot(char *p[MAX_PARM])
{
    int i, f, xr, yr;
    char *pp, *p2;
    char buf[MAX_LINELEN+1];
    f=xr=yr=-1;      
    for(i=0;i<3;i++) {
	if(*p[i]==0) continue;
	if((pp=strchr(p[i],'='))==NULL) f=i;
	else {
	    *pp=0; pp++;
	    p2=find_word_start(p[i]);
	    if(*p2=='x' || *p2=='X') xr=i;
	    else if (*p2=='y' || *p2=='Y') yr=i;
	    strcpy(p[i],pp);
	}
    }
    if(xr>=0 && (pp=strstr(p[xr],".."))!=NULL) {
	
    }
    if(f<0) return;
    strcpy(buf, p[f]);
    prepcnt=0; parmprep(buf,pt_func);
    fprintf(outf,"plot_fn=!rawmath %s\n",buf);
    
}

void p_condition(char *p[MAX_PARM])
{
    char buf1[MAX_LINELEN+1],buf2[MAX_LINELEN+1];
    if(p[1][0]==0) {p[1]=p[0]; p[0]="";}
    snprintf(buf1,sizeof(buf1),"%s",p[0]); subst(buf1);
    snprintf(buf2,sizeof(buf2),"%s",p[1]); subst(buf2);
    prepcnt=0; parmprep(buf2, pt_real);
    repsubst(buf2);
    fprintf(outf,"\n!ifval %s\n condtest%d=1\n!else\n condtest%d=0\n!endif\n\
condname%d=%s\n", buf2,conditioncnt,conditioncnt,conditioncnt,buf1);
    conditioncnt++;
}

void p_feedback(char *p[MAX_PARM])
{
    char buf1[MAX_LINELEN+1],buf2[MAX_LINELEN+1];
    char *cmpstr="ifval";
    
    snprintf(buf1,sizeof(buf1),"%s",p[0]); subst(buf1);
    snprintf(buf2,sizeof(buf2),"%s",p[1]); subst(buf2);
    repsubst(buf1); repsubst(buf2);
    if(strstr(buf1,"$m_choice")!=NULL) cmpstr="if";
    prepcnt=0; setpre="!set "; parmprep(buf1, pt_real); setpre="";
    fprintf(outf,"!%s %s\n <p>",cmpstr, buf1);
    out_exec(buf2,NULL);
    fprintf(outf,"\n!endif\n");
}

	/* definition of steps */
void p_steps(char *p[MAX_PARM])
{
    char vbuf[MAX_LINELEN+1];
    char *pp, *p2;
    snprintf(vbuf,sizeof(vbuf),"%s",find_word_start(p[0])); subst(vbuf);
    strip_trailing_spaces(vbuf);
    if(vbuf[0]==0) return;
    if((pp=strparchr(vbuf,'?'))!=NULL) {
	char buf[MAX_LINELEN+1];
	p2=strparchr(pp,':'); *pp++=0; if(p2!=NULL) *p2++=0;
	snprintf(buf,sizeof(buf),"%s",vbuf);
	prepcnt=0; parmprep(buf,pt_text);
	fprintf(outf,"\n!ifval %s \n",buf);
	snprintf(buf,sizeof(buf),"%s",pp);
	parmprep(buf,pt_text); 
	fprintf(outf,"oefsteps=%s \n",buf);
	if(p2!=NULL) {
	    fprintf(outf,"!else\n");
	    snprintf(buf,sizeof(buf),"%s",p2);
	    parmprep(buf,pt_text);
	    fprintf(outf,"oefsteps=%s \n",buf);
	}
	fprintf(outf,"!endif\n");
    }
    else {
	prepcnt=0; parmprep(vbuf, pt_text);
	fprintf(outf,"oefsteps=%s \n",vbuf);
    }
    fprintf(outf,"!readproc oef/steps.proc\n");
}

