/*    Copyright (C) 1998 XIAO, Gang of Universite de Nice - Sophia Antipolis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
	/* line input / output / translation routines
	 * and error routines */
#include <stdarg.h>

	/* critical error situation */
void error(char *s)
{
    /* fputs(s,stderr); */
    printf("\nERROR %s\n",s);
    exit(1);
}

char *substit(char *p)
{
    char *pp;
    while((pp=strchr(p,'$'))!=NULL) *pp=' ';
    return p;
}

	/* replace newline by tab */
void replace_newline(char *p)
{
    for(;*p;p++) {
	if(*p=='	') *p=' ';
	if(*p=='\n') *p='	';
    }
}

	/* variable substitution. buffer p must have MAX_LINELEN */
void subst(char *p)
{
    char *pp, *pe, nbuf[MAX_NAMELEN];
    int i;

    for(pp=p;pp-p<MAX_LINELEN && *pp; pp++) {
	if(*pp=='$') {
	    string_modify(p,pp,pp+1,"&#36;");
	    pp+=3;
	    continue;
	}
	if(*pp=='!' && isalnum(*(pp+1))) {
	    string_modify(p,pp,pp+1,"&#33;");
	    pp+=3; continue;
	}
	if(*pp!='\\') continue;
	if(*(pp+1)=='\\') {
	    pp++; continue;
	}
	if(!isalpha(*(pp+1))) continue;
	for(pe=pp+1;isalnum(*pe) || *pe=='_'; pe++);
	if(pe-pp>=MAX_NAMELEN) continue;
	memmove(nbuf,pp+1,pe-pp-1);nbuf[pe-pp-1]=0;
	for(i=varcnt-1;i>=1 && strcmp(nbuf,param[i].name)!=0;i--);
	if(i>=1) {
	    if(deftag) param[i].save=1;
	    string_modify(p,pp,pe,"$val%d",i);
	}
	else if(wordchr(mdef,nbuf)!=NULL) string_modify(p,pp,pp+1,"$m_");
    }
}

void repsubst(char *p)
{
    char *p1;
    for(p1=strstr(p,"\\reply"); p1!=NULL; p1=strstr(p1+1,"\\reply")) {
	if(p1>p && *(p1-1)=='\\') continue;
	string_modify(p,p1,p1+strlen("\\reply"),"$m_reply");
    }
    for(p1=strstr(p,"\\choice"); p1!=NULL; p1=strstr(p1+1,"\\choice")) {
	if(p1>p && *(p1-1)=='\\') continue;
	string_modify(p,p1,p1+strlen("\\choice"),"$m_choice");
    }
    for(p1=strstr(p,"\\step"); p1!=NULL; p1=strstr(p1+1,"\\step")) {
	if(p1>p && *(p1-1)=='\\') continue;
	string_modify(p,p1,p1+strlen("\\step"),"$m_step");
    }
}

	/* Check whether parentheses are balanced in a given string.
	 * Returns 0 if OK. */
	/* style=0: simple check. style<>0: strong check. */
int checkparentheses(char *p, int style)
{
    int i,j,k;
    j=strlen(p);
    if(j>=MAX_FILELEN) return 65535;
    if(style!=0) {
	char buf[MAX_FILELEN+1];
	char *pp, *pe, c;
	for(pp=p;pp<p+j;pp++) {
	    switch (*pp) {
		case ')':
		case ']':
		case '}': return -1;
		case '(': c=')'; goto find;
		case '[': c=']'; goto find;
		case '{': c='}';
		find: {
		    pe=find_matching(pp+1,c);
		    if(pe==NULL) return 1;
		    memcpy(buf,pp+1,pe-pp-1);
		    buf[pe-pp-1]=0;
		    if((k=check_parentheses(buf,1))!=0) return k;
		    else pp=pe;
		}
		default: break;
	    }
	}
	return 0;
    }
    for(i=k=0;i<j && k>=0;i++) {
	if(*(p+i)=='(') k++;
	if(*(p+i)==')') k--;
    }
    return k;
}

