
/*  A Bison parser, made from unites.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	REAL	257
#define	SPC	258
#define	Uh	259
#define	Umin	260
#define	Um	261
#define	Ug	262
#define	Us	263
#define	UA	264
#define	UK	265
#define	Umol	266
#define	Ucd	267
#define	UHz	268
#define	UN	269
#define	UPa	270
#define	UJ	271
#define	UW	272
#define	UC	273
#define	UV	274
#define	Uohm	275
#define	US	276
#define	UF	277
#define	UT	278
#define	UWb	279
#define	UH	280
#define	Ulm	281
#define	Ulx	282
#define	UBq	283
#define	UGy	284
#define	USv	285
#define	Urad	286
#define	Usr	287
#define	PUIS	288
#define	PP	289
#define	POINT	290
#define	BARRE	291
#define	Uda	292
#define	Upc	293
#define	Uma	294
#define	Usa	295
#define	Uangs	296
#define	Ubarn	297
#define	Ul	298
#define	Ut	299
#define	Ubar	300
#define	UeV	301
#define	Uuam	302

#line 1 "unites.y"

/* inclusions, dfinition */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "unites.h"

  typedef struct{
    int i;
    double multip, maxmultip;
    uniteSI unite;
    int base[BU_LAST];
    char * s;
    double val;
  } yystype;
  
#define YYSTYPE yystype 

 extern char * yytext;
 extern FILE * yyin;

/* variables globales */
 char buffer[128], buffer2[128];
 yystype result;
 double val_real;
 long pos;

/* les units du SI */
/* Handbook of Chemistry & Physics 78, CRC Press 1997, page 1-20 */
unite_data unites[TU_LAST] ={
/*TUh*/   {"h",    "seconde",3600.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUmin*/ {"min",   "seconde", 60.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUm*/   {"m",      "mtre",   1.0,     { 1, 0, 0, 0, 0, 0, 0}},
/*TUg*/   {"g",    "kilogramme",1.0e-3,  { 0, 1, 0, 0, 0, 0, 0}},
/*TUs*/   {"s",      "seconde", 1.0,     { 0, 0, 1, 0, 0, 0, 0}},
/*TUA*/   {"A",      "ampre",  1.0,     { 0, 0, 0, 1, 0, 0, 0}},
/*TUK*/   {"K",      "kelvin",  1.0,     { 0, 0, 0, 0, 1, 0, 0}},
/*TUmol*/ {"mol",    "mol",     1.0,     { 0, 0, 0, 0, 0, 1, 0}},
/*TUcd*/  {"cd",     "candela", 1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUHz*/  {"Hz",     "hetrz",   1.0,     { 0, 0,-1, 0, 0, 0, 0}},
/*TUN*/   {"N",      "newton",  1.0,     { 1, 1,-2, 0, 0, 0, 0}},
/*TUPa*/  {"Pa",     "pascal",  1.0,     {-1, 1,-2, 0, 0, 0, 0}},
/*TUJ*/   {"J",      "joule",   1.0,     { 2, 1,-2, 0, 0, 0, 0}},
/*TUW */  {"W",      "watt",    1.0,     { 2, 1,-3, 0, 0, 0, 0}},
/*TUC*/   {"C",      "coulomb", 1.0,     { 0, 0, 1, 1, 0, 0, 0}},
/*TUV*/   {"V",      "volt",    1.0,     { 2, 1,-3,-1, 0, 0, 0}},
/*TUohm*/ {"\\Omega","ohm",     1.0,     { 2, 1,-3,-2, 0, 0, 0}},
/*TUS*/   {"S",      "siemens", 1.0,     {-2,-1, 3, 2, 0, 0, 0}},
/*TUF*/   {"F",      "farad",   1.0,     {-2,-1, 4, 2, 0, 0, 0}},
/*TUT*/   {"T",      "tesla",   1.0,     { 0, 1,-2,-1, 0, 0, 0}},
/*TUWb*/  {"Wb",     "weber",   1.0,     { 2, 1,-2,-1, 0, 0, 0}},
/*TUH*/   {"H",      "henry",   1.0,     { 2, 1,-2,-2, 0, 0, 0}},
/*TUlm*/  {"lm",     "lumen",   1.0,     { 0, 0, 0, 0, 0, 0, 1}},
/*TUlx*/  {"lx",     "lux",     1.0,     {-2, 0, 0, 0, 0, 0, 1}},
/*TUBq */ {"Bq",     "becquerel",1.0,    { 0, 0,-1, 0, 0, 0, 0}},
/*TUGy*/  {"Gy",     "gray",     1.0,    { 2, 0,-2, 0, 0, 0, 0}},
/*TUSv*/  {"Sv",     "sievert",  1.0,    { 2, 0,-2, 0, 0, 0, 0}},
/*TUrad*/ {"rad",    "radian",   1.0,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUsr*/  {"sr" ,    "stradian",1.0,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUnull*/{"" ,    "sans unit",1.0,     { 0, 0, 0, 0, 0, 0, 0}},
/*TUda*/  {"", "degr", M_PI/180.0,     { 0, 0, 0, 0, 0, 0, 0}},
/*TUpc*/  {"%", "pour cent", 0.01,       { 0, 0, 0, 0, 0, 0, 0}},
/*TUma*/  {"'", "minute", M_PI/10800,    { 0, 0, 0, 0, 0, 0, 0}},
/*TUsa*/  {"''","seconde",M_PI/648000 ,  { 0, 0, 0, 0, 0, 0, 0}},
/*TUangs*/ {"\\o{A}", "angstrm", 1e-10, { 1, 0, 0, 0, 0, 0, 0}},
/*TUbarn*/ {"b", "barn", 1e-28,          { 2, 0, 0, 0, 0, 0, 0}},
/*TUl*/    {"L", "litre", 1e-3,          { 3, 0, 0, 0, 0, 0, 0}},
/*TUt*/ {"t", "tonne", 1e3,              { 0, 1, 0, 0, 0, 0, 0}},
/*TUbar*/ {"bar", "bar", 1e5,            {-1, 1,-2, 0, 0, 0, 0}},
/*TUeV*/ {"eV", "eV", 1.60218e-19,       { 0, 0, 1, 1, 0, 0, 0}},
/*TUuam*/ {"uma", "uma", 1.66054e-27,    { 0, 1, 0, 0, 0, 0, 0}}
};

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		73
#define	YYFLAG		-32768
#define	YYNTBASE	49

#define YYTRANSLATE(x) ((unsigned)(x) <= 302 ? yytranslate[x] : 62)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     4,     8,    10,    14,    16,    17,    19,    22,
    24,    27,    30,    32,    35,    38,    41,    44,    46,    49,
    50,    52,    54,    56,    58,    60,    62,    64,    66,    68,
    70,    72,    74,    76,    78,    80,    82,    84,    86,    88,
    90,    92,    94,    96,    98,   100,   102,   104,   106,   108,
   110,   112,   114,   116,   118,   120,   122,   124,   126,   128,
   130,   132
};

static const short yyrhs[] = {    50,
     0,    52,     0,    51,    53,    50,     0,    51,     0,     3,
    53,    54,     0,     3,     0,     0,     4,     0,    54,    55,
     0,    58,     0,    56,    58,     0,    37,    58,     0,    36,
     0,     7,    61,     0,    24,    61,     0,     5,    61,     0,
    60,    61,     0,    61,     0,    57,    59,     0,     0,    34,
     0,    35,     0,     5,     0,     6,     0,     7,     0,     8,
     0,     9,     0,    10,     0,    11,     0,    12,     0,    13,
     0,    14,     0,    15,     0,    16,     0,    17,     0,    24,
     0,    18,     0,    19,     0,    20,     0,    21,     0,    22,
     0,    23,     0,    25,     0,    26,     0,    27,     0,    28,
     0,    29,     0,    30,     0,    31,     0,    32,     0,    33,
     0,    38,     0,    39,     0,    40,     0,    41,     0,    42,
     0,    43,     0,    44,     0,    45,     0,    46,     0,    47,
     0,    48,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   129,   130,   133,   143,   146,   149,   158,   159,   162,   172,
   175,   179,   191,   194,   200,   205,   210,   216,   221,   243,
   244,   247,   272,   274,   275,   276,   277,   278,   279,   280,
   281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
   291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
   301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
   311,   312
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","REAL","SPC",
"Uh","Umin","Um","Ug","Us","UA","UK","Umol","Ucd","UHz","UN","UPa","UJ","UW",
"UC","UV","Uohm","US","UF","UT","UWb","UH","Ulm","Ulx","UBq","UGy","USv","Urad",
"Usr","PUIS","PP","POINT","BARRE","Uda","Upc","Uma","Usa","Uangs","Ubarn","Ul",
"Ut","Ubar","UeV","Uuam","but","valeur_mixte","valeur","sans_unite","spc","unite",
"suiv_unit","point","prim_unit1","prim_unit","puissance01","prefixe","base_unite", NULL
};
#endif

static const short yyr1[] = {     0,
    49,    49,    50,    50,    51,    52,    53,    53,    54,    54,
    55,    55,    56,    57,    57,    57,    57,    57,    58,    59,
    59,    60,    61,    61,    61,    61,    61,    61,    61,    61,
    61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
    61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
    61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
    61,    61
};

static const short yyr2[] = {     0,
     1,     1,     3,     1,     3,     1,     0,     1,     2,     1,
     2,     2,     1,     2,     2,     2,     2,     1,     2,     0,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1
};

static const short yydefact[] = {     0,
     7,     1,     4,     2,     8,     0,     0,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    37,    38,    39,    40,    41,    42,    36,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    22,    52,    53,    54,
    55,    56,    57,    58,    59,    60,    61,    62,     5,    20,
    10,     0,    18,     7,     3,    23,    25,    36,    16,    14,
    15,    13,     0,     9,     0,    21,    19,    17,    12,    11,
     0,     0,     0
};

static const short yydefgoto[] = {    71,
     2,     3,     4,     6,    49,    64,    65,    50,    51,    67,
    52,    53
};

static const short yypact[] = {     0,
     1,-32768,     4,-32768,-32768,    40,     8,    84,-32768,    84,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    84,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   -27,   -22,
-32768,    84,-32768,     9,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,    40,-32768,    40,-32768,-32768,-32768,-32768,-32768,
    14,    15,-32768
};

static const short yypgoto[] = {-32768,
    10,-32768,-32768,    13,-32768,-32768,-32768,-32768,   -59,-32768,
-32768,    -8
};


#define	YYLAST		132


static const short yytable[] = {    59,
    -6,    60,     1,    69,     5,    70,    -7,     5,    62,    63,
    54,    66,     5,    72,    73,     7,    55,     0,    61,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    68,     8,     9,    10,    11,    12,    13,
    14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
    24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
    34,    35,    36,     0,    37,     0,     0,    38,    39,    40,
    41,    42,    43,    44,    45,    46,    47,    48,    56,     9,
    57,    11,    12,    13,    14,    15,    16,    17,    18,    19,
    20,    21,    22,    23,    24,    25,    26,    58,    28,    29,
    30,    31,    32,    33,    34,    35,    36,     0,     0,     0,
     0,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48
};

static const short yycheck[] = {     8,
     0,    10,     3,    63,     4,    65,     3,     4,    36,    37,
     3,    34,     4,     0,     0,     3,     7,    -1,    27,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    52,     5,     6,     7,     8,     9,    10,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
    21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
    31,    32,    33,    -1,    35,    -1,    -1,    38,    39,    40,
    41,    42,    43,    44,    45,    46,    47,    48,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    -1,    -1,    -1,
    -1,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 129 "unites.y"
{result = yyvsp[0];;
    break;}
case 2:
#line 130 "unites.y"
{result = yyvsp[0];;
    break;}
case 3:
#line 133 "unites.y"
{
  int i;
  for(i=0; i < BU_LAST; i++){
    if (yyvsp[-2].base[i] != yyvsp[0].base[i]) yyerror ("homogen: not homogeneous units");
  }
  if (yyvsp[-2].multip <= yyvsp[0].maxmultip) 
    yyerror ("order: incorrect mutiple units ordering");
  yyval.val=yyvsp[-2].val*yyvsp[-2].multip+yyvsp[0].val*yyvsp[0].multip;
  yyval.multip=1; yyval.maxmultip = yyvsp[-2].multip;
;
    break;}
case 4:
#line 143 "unites.y"
{yyval=yyvsp[0]; yyval.maxmultip=yyvsp[0].multip;;
    break;}
case 5:
#line 146 "unites.y"
{yyval=yyvsp[0]; yyval.val=val_real; ;
    break;}
case 6:
#line 149 "unites.y"
{
  int i;
  yyval.val=val_real; 
  for (i=0; i < BU_LAST; i++){yyval.base[i]=unites[TUnull].base[i];} 
  yyval.multip=1.0; 
  yyval.s="";
;
    break;}
case 9:
#line 162 "unites.y"
{
  int index;
  yyval.unite = TU_LAST; /* unit non renseigne */
  strcpy(buffer,yyvsp[-1].s); strcat(buffer,yyvsp[0].s); free(yyvsp[-1].s); free(yyvsp[0].s);
  yyval.s=strdup(buffer);
  for(index=0; index< BU_LAST; index++){
    yyval.base[index] = yyvsp[-1].base[index]+yyvsp[0].base[index] ; 
  }
  yyval.multip = yyvsp[-1].multip*yyvsp[0].multip;
;
    break;}
case 10:
#line 172 "unites.y"
{ yyval=yyvsp[0]; ;
    break;}
case 11:
#line 175 "unites.y"
{
  yyval=yyvsp[0]; strcpy(buffer,"."); strcat(buffer,yyvsp[0].s); free(yyvsp[0].s);
  yyval.s=strdup(buffer);
;
    break;}
case 12:
#line 179 "unites.y"
{
  int index;
  yyval=yyvsp[0]; 
  yyval.multip = 1/ yyval.multip;
  strcpy(buffer,"/"); strcat(buffer,yyvsp[0].s); free(yyvsp[0].s);
  yyval.s=strdup(buffer);
  for(index=0; index< BU_LAST; index++){
    yyval.base[index] *= -1; 
  }
;
    break;}
case 14:
#line 195 "unites.y"
{
  yyval=yyvsp[0];
  strcpy(buffer,"m"); strcat(buffer,yyvsp[0].s); free(yyvsp[0].s);
  yyval.s = strdup(buffer); yyval.multip*=1e-3; 
;
    break;}
case 15:
#line 200 "unites.y"
{
  yyval=yyvsp[0];
  strcpy(buffer,"T"); strcat(buffer,yyvsp[0].s); free(yyvsp[0].s);
  yyval.s = strdup(buffer); yyval.multip*=1e12;
;
    break;}
case 16:
#line 205 "unites.y"
{
  yyval=yyvsp[0];
  strcpy(buffer,"h"); strcat(buffer,yyvsp[0].s); free(yyvsp[0].s);
  yyval.s = strdup(buffer); yyval.multip*=1e2;
;
    break;}
case 17:
#line 210 "unites.y"
{
  yyval=yyvsp[0];
  strcpy(buffer, yyvsp[-1].s); strcat(buffer, yyvsp[0].s);
  free(yyvsp[-1].s); free(yyvsp[0].s);yyval.s=strdup(buffer); 
  yyval.multip*=yyvsp[-1].multip;
  ;
    break;}
case 18:
#line 216 "unites.y"
{
  yyval=yyvsp[0];
;
    break;}
case 19:
#line 221 "unites.y"
{
  int index;
  double r;

  yyval.i=yyvsp[0].i;
  strcpy(buffer, yyvsp[-1].s);
  if (yyvsp[0].i!=1){
    strcat(buffer, "^{%d}"); 
    sprintf(buffer2, buffer, yyvsp[0].i);
  }
  else strcpy(buffer2,buffer);
  yyval.s=strdup(buffer2); free(yyvsp[-1].s);
  for(index=0; index< BU_LAST; index++){
    yyval.base[index] = unites[yyvsp[-1].unite].base[index]*yyvsp[0].i;
  }
  for(index=0, r=1; index<yyvsp[0].i ; index++){
    r*= yyval.multip;
  }
  yyval.multip=r;
;
    break;}
case 20:
#line 243 "unites.y"
{yyval.i=1;;
    break;}
case 21:
#line 244 "unites.y"
{yyval.i = atoi(yytext);;
    break;}
case 22:
#line 248 "unites.y"
{yyval.s = strdup(yytext); yyval.multip=1.0;
 switch (yytext[0]){
 case 'y' : yyval.multip = 1e-24; break;
 case 'z' : yyval.multip = 1e-21; break;
 case 'a' : yyval.multip = 1e-18; break;
 case 'f' : yyval.multip = 1e-15; break;
 case 'p' : yyval.multip = 1e-12; break;
 case 'n' : yyval.multip = 1e-9; break;
 case '' : yyval.multip = 1e-6; break;
 case 'c' : yyval.multip = 1e-2; break;
 case 'd' : if (!strcmp (yytext,"da") ) yyval.multip = 10.0;
    else yyval.multip = 0.1; break;
 case 'h' : yyval.multip = 1e2; break;
 case 'k' : yyval.multip = 1e3; break;
 case 'M' : yyval.multip = 1e6; break;
 case 'G' : yyval.multip = 1e9; break;
 case 'P' : yyval.multip = 1e15; break;
 case 'E' : yyval.multip = 1e18; break;
 case 'Z' : yyval.multip = 1e21; break;
 case 'Y': yyval.multip = 1e24; break;
 }
;
    break;}
case 23:
#line 273 "unites.y"
{yyval.unite=TUh; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 24:
#line 274 "unites.y"
{yyval.unite=TUmin; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 25:
#line 275 "unites.y"
{yyval.unite=TUm; yyval.s = strdup("m"); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 26:
#line 276 "unites.y"
{yyval.unite=TUg; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 27:
#line 277 "unites.y"
{yyval.unite=TUs; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 28:
#line 278 "unites.y"
{ yyval.unite = TUA; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 29:
#line 279 "unites.y"
{ yyval.unite = TUK; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 30:
#line 280 "unites.y"
{ yyval.unite = TUmol; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 31:
#line 281 "unites.y"
{ yyval.unite = TUcd; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 32:
#line 282 "unites.y"
{ yyval.unite = TUHz; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 33:
#line 283 "unites.y"
{ yyval.unite = TUN; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 34:
#line 284 "unites.y"
{ yyval.unite = TUPa; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 35:
#line 285 "unites.y"
{ yyval.unite = TUJ; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 36:
#line 286 "unites.y"
{ yyval.unite = TUT; yyval.s = strdup("T"); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 37:
#line 287 "unites.y"
{ yyval.unite = TUW; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 38:
#line 288 "unites.y"
{ yyval.unite = TUC; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 39:
#line 289 "unites.y"
{ yyval.unite = TUV; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 40:
#line 290 "unites.y"
{ yyval.unite = TUohm; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 41:
#line 291 "unites.y"
{ yyval.unite = TUS; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 42:
#line 292 "unites.y"
{ yyval.unite = TUF; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 43:
#line 293 "unites.y"
{ yyval.unite = TUWb; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 44:
#line 294 "unites.y"
{ yyval.unite = TUH; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 45:
#line 295 "unites.y"
{ yyval.unite = TUlm; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 46:
#line 296 "unites.y"
{ yyval.unite = TUlx; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 47:
#line 297 "unites.y"
{ yyval.unite = TUBq; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 48:
#line 298 "unites.y"
{ yyval.unite = TUGy; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 49:
#line 299 "unites.y"
{ yyval.unite = TUSv; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 50:
#line 300 "unites.y"
{ yyval.unite = TUrad; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 51:
#line 301 "unites.y"
{ yyval.unite = TUsr; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 52:
#line 302 "unites.y"
{ yyval.unite = TUda; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 53:
#line 303 "unites.y"
{ yyval.unite = TUpc; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 54:
#line 304 "unites.y"
{ yyval.unite = TUma; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 55:
#line 305 "unites.y"
{ yyval.unite = TUsa; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 56:
#line 306 "unites.y"
{ yyval.unite = TUangs; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 57:
#line 307 "unites.y"
{ yyval.unite = TUbarn; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 58:
#line 308 "unites.y"
{ yyval.unite = TUl; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 59:
#line 309 "unites.y"
{ yyval.unite = TUt; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 60:
#line 310 "unites.y"
{ yyval.unite = TUbar; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 61:
#line 311 "unites.y"
{ yyval.unite = TUeV; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
case 62:
#line 312 "unites.y"
{ yyval.unite = TUuam; yyval.s = strdup(yytext); yyval.multip=unites[yyval.unite].multiplicateur;;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 317 "unites.y"


#include "lex.yy.c"
/* le programme lui-mme */

inline int yyerror(char * msg){
  if (strstr(msg, "parse")!=0) printf("ERROR syntax: at %d, %s\n", pos, msg);
  else printf("ERROR %s\n", msg);
  exit(1);
}

void test_verbeux(){
  int i;
  yyparse();
  if (result.s) {
    if (result.unite == TU_LAST){
      printf("%s %g SI (quation aux dimensions : ", result.s, 
	     result.multip*result.val );
      for (i=0; i<BU_LAST; i++){
	printf("%3d", result.base[i]);
      }
      printf(")\n");
    }
    else {
      if (result.i!=1) 
	printf ("%s (%g %s)^{%d}\n", result.s, 
		result.multip*result.val, 
		unites[result.unite].nom, result.i);
      else printf("%s %g %s\n", result.s, 
		  result.multip*result.val, 
		  unites[result.unite].nom);
    }
  }
  else fprintf(stderr, "problme : result.s = null\n");
}

void sortie_normalisee(){
  /***************************************************/
  /* le format des donnes en sortie est :           */
  /* double int int int int int int int              */
  /* et signifie  dans l'ordre                       */
  /***************************************************/
  /* valeur                                          */
  /* puissance en unit de longueur (m)              */
  /* puissance en unit de masse (kg)                */
  /* puissance en unit de temps (s)                 */
  /* puissance en unit de courant (A)               */
  /* puissance en unit de temprature (K)           */
  /* puissance en unit de quantit de matire (mol) */
  /* puissance en unit de inutensit lumineuse (cd) */
  /* deux zros pour des extensions futures          */
  /***************************************************/
  int i;

  yyparse();
  printf("%g", result.multip*result.val );
  for (i=0; i<BU_LAST; i++){
    printf(" %3d", result.base[i]);
  }
  printf("    0    0\n");
}

int main(void){
  /*test_verbeux();*/
  sortie_normalisee();
  return 0;
}
