#!/usr/bin/python

from distutils.core import setup
import glob, os, commands, sys

data_files = [('share/willowng', ['willowng.glade', 'builtin.db', ]), ('share/willowng/error_pages', ['error_pages/content.html', 'error_pages/domain.html']), ('sbin', ['willowng']), ('/etc/dbus-1/system.d/', ['willowng.conf']), ('/etc/willowng/', ['main.conf'])]
if sys.argv[1] == 'install':
    if not os.path.isdir('build'):
        os.makedirs('build')
    os.system('intltool-merge -d po willowng.desktop.in build/willowng.desktop')
    os.system('intltool-merge -d po willowng-kde.desktop.in build/willowng-kde.desktop')
    data_files.append(('share/applications', ['build/willowng.desktop']))
    data_files.append(('share/applications/kde/', ['build/willowng-kde.desktop']))
    for name in os.listdir(os.path.join(os.path.realpath('.'), 'po')):
        if name[-2:] == 'po':
            if not os.path.isdir('build/locale/' + name[:-3]):
                os.makedirs('build/locale/' + name[:-3])
            os.system('msgfmt -o build/locale/' + name[:-3] + '/willowng.mo po/' + name[:-3] + '.po')
            data_files.append(('share/locale/' + name[:-3] + '/LC_MESSAGES', ['build/locale/' + name[:-3] + '/willowng.mo']))

    prefix = None
    for arg in sys.argv:
        if arg.startswith('--prefix'):
            prefix = arg.split('=', 1)[1].strip().replace('~', os.environ['HOME'])

    temp = open('WillowNG/config.py.in').read()
    if prefix == None:
        temp = temp.replace('@PKGDATADIR@', '"/usr/share/willowng"')
        temp = temp.replace('@CONFDIR@', '"/etc/willowng"')
#        os.makedirs('/etc/willowng')
    else:
        temp = temp.replace('@CONFDIR@', '"' + os.path.join(prefix, 'etc', 'willowng') + '"')
        temp = temp.replace('@PKGDATADIR@', '"' + os.path.join(prefix, 'share', 'willowng') + '"')
#        os.makedirs(os.path.join(prefix, 'etc', 'willowng'))
    open('WillowNG/config.py', 'w').write(temp)

setup(
    name = 'willowng',
    version = '0.1',
    description = '',
    author = 'Travis Watkins',
    author_email = 'alleykat@gmail.com',
    url = '',
    packages = ['WillowNG'],
    scripts = ['willowng-config', 'willowng-config-kde'],
    data_files = data_files,
    license = 'GNU LGPL',
    platforms = 'posix',
    )

if sys.argv[1] == 'clean':
    for root, dirs, files in os.walk('build', topdown=False):
        for name in files:
            os.remove(os.path.join(root, name))
        for name in dirs:
            os.rmdir(os.path.join(root, name))
    if os.path.isdir('build'):
        os.rmdir('build')
