(********************************************************************)
(*                                                                  *)
(*  The Why3 Verification Platform   /   The Why3 Development Team  *)
(*  Copyright 2010-2017   --   INRIA - CNRS - Paris-Sud University  *)
(*                                                                  *)
(*  This software is distributed under the terms of the GNU Lesser  *)
(*  General Public License version 2.1, with the special exception  *)
(*  on linking described in file LICENSE.                           *)
(*                                                                  *)
(********************************************************************)

(* This file is generated by Why3's Coq-realize driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require list.List.

(* Why3 assumption *)
Fixpoint mem {a:Type} {a_WT:WhyType a} (x:a) (l:(list a)) {struct l}: Prop :=
  match l with
  | Init.Datatypes.nil => False
  | (Init.Datatypes.cons y r) => (x = y) \/ (mem x r)
  end.

Lemma mem_std :
  forall {a:Type} {a_WT:WhyType a} (x:a) (l:list a),
  mem x l <-> List.In x l.
Proof.
intros a a_WT x l.
induction l as [|h q].
easy.
simpl.
split ; intros [H|H].
now left.
right.
now apply IHq.
now left.
right.
now apply IHq.
Qed.
