(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Require int.Int.

(* Why3 assumption *)
Definition implb(x:bool) (y:bool): bool := match (x,
  y) with
  | (true, false) => false
  | (_, _) => true
  end.

(* Why3 assumption *)
Inductive datatype  :=
  | TYunit : datatype 
  | TYint : datatype 
  | TYbool : datatype .

(* Why3 assumption *)
Inductive value  :=
  | Vvoid : value 
  | Vint : Z -> value 
  | Vbool : bool -> value .

(* Why3 assumption *)
Inductive operator  :=
  | Oplus : operator 
  | Ominus : operator 
  | Omult : operator 
  | Ole : operator .

(* Why3 assumption *)
Definition ident  := Z.

(* Why3 assumption *)
Inductive term  :=
  | Tvalue : value -> term 
  | Tvar : Z -> term 
  | Tderef : Z -> term 
  | Tbin : term -> operator -> term -> term .

(* Why3 assumption *)
Inductive fmla  :=
  | Fterm : term -> fmla 
  | Fand : fmla -> fmla -> fmla 
  | Fnot : fmla -> fmla 
  | Fimplies : fmla -> fmla -> fmla 
  | Flet : Z -> term -> fmla -> fmla 
  | Fforall : Z -> datatype -> fmla -> fmla .

Parameter map : forall (a:Type) (b:Type), Type.

Parameter get: forall (a:Type) (b:Type), (map a b) -> a -> b.
Implicit Arguments get.

Parameter set: forall (a:Type) (b:Type), (map a b) -> a -> b -> (map a b).
Implicit Arguments set.

Axiom Select_eq : forall (a:Type) (b:Type), forall (m:(map a b)),
  forall (a1:a) (a2:a), forall (b1:b), (a1 = a2) -> ((get (set m a1 b1)
  a2) = b1).

Axiom Select_neq : forall (a:Type) (b:Type), forall (m:(map a b)),
  forall (a1:a) (a2:a), forall (b1:b), (~ (a1 = a2)) -> ((get (set m a1 b1)
  a2) = (get m a2)).

Parameter const: forall (b:Type) (a:Type), b -> (map a b).
Set Contextual Implicit.
Implicit Arguments const.
Unset Contextual Implicit.

Axiom Const : forall (b:Type) (a:Type), forall (b1:b) (a1:a),
  ((get (const b1:(map a b)) a1) = b1).

(* Why3 assumption *)
Definition env  := (map Z value).

Parameter eval_bin: value -> operator -> value -> value.

Axiom eval_bin_def : forall (x:value) (op:operator) (y:value), match (x,
  y) with
  | ((Vint x1), (Vint y1)) =>
      match op with
      | Oplus => ((eval_bin x op y) = (Vint (x1 + y1)%Z))
      | Ominus => ((eval_bin x op y) = (Vint (x1 - y1)%Z))
      | Omult => ((eval_bin x op y) = (Vint (x1 * y1)%Z))
      | Ole => ((x1 <= y1)%Z -> ((eval_bin x op y) = (Vbool true))) /\
          ((~ (x1 <= y1)%Z) -> ((eval_bin x op y) = (Vbool false)))
      end
  | (_, _) => ((eval_bin x op y) = (Vbool false))
  end.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint eval_term(sigma:(map Z value)) (pi:(map Z value))
  (t:term) {struct t}: value :=
  match t with
  | (Tvalue v) => v
  | (Tvar id) => (get pi id)
  | (Tderef id) => (get sigma id)
  | (Tbin t1 op t2) => (eval_bin (eval_term sigma pi t1) op (eval_term sigma
      pi t2))
  end.
Unset Implicit Arguments.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint eval_fmla(sigma:(map Z value)) (pi:(map Z value))
  (f:fmla) {struct f}: Prop :=
  match f with
  | (Fterm t) => ((eval_term sigma pi t) = (Vbool true))
  | (Fand f1 f2) => (eval_fmla sigma pi f1) /\ (eval_fmla sigma pi f2)
  | (Fnot f1) => ~ (eval_fmla sigma pi f1)
  | (Fimplies f1 f2) => (eval_fmla sigma pi f1) -> (eval_fmla sigma pi f2)
  | (Flet x t f1) => (eval_fmla sigma (set pi x (eval_term sigma pi t)) f1)
  | (Fforall x TYint f1) => forall (n:Z), (eval_fmla sigma (set pi x
      (Vint n)) f1)
  | (Fforall x TYbool f1) => forall (b:bool), (eval_fmla sigma (set pi x
      (Vbool b)) f1)
  | (Fforall x TYunit f1) => (eval_fmla sigma (set pi x Vvoid) f1)
  end.
Unset Implicit Arguments.

Parameter subst_term: term -> Z -> Z -> term.

Axiom subst_term_def : forall (e:term) (r:Z) (v:Z),
  match e with
  | ((Tvalue _)|(Tvar _)) => ((subst_term e r v) = e)
  | (Tderef x) => ((r = x) -> ((subst_term e r v) = (Tvar v))) /\
      ((~ (r = x)) -> ((subst_term e r v) = e))
  | (Tbin e1 op e2) => ((subst_term e r v) = (Tbin (subst_term e1 r v) op
      (subst_term e2 r v)))
  end.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint fresh_in_term(id:Z) (t:term) {struct t}: Prop :=
  match t with
  | (Tvalue _) => True
  | (Tvar v) => ~ (id = v)
  | (Tderef _) => True
  | (Tbin t1 _ t2) => (fresh_in_term id t1) /\ (fresh_in_term id t2)
  end.
Unset Implicit Arguments.

Axiom eval_subst_term : forall (sigma:(map Z value)) (pi:(map Z value))
  (e:term) (x:Z) (v:Z), (fresh_in_term v e) -> ((eval_term sigma pi
  (subst_term e x v)) = (eval_term (set sigma x (get pi v)) pi e)).

Axiom eval_term_change_free : forall (t:term) (sigma:(map Z value)) (pi:(map
  Z value)) (id:Z) (v:value), (fresh_in_term id t) -> ((eval_term sigma
  (set pi id v) t) = (eval_term sigma pi t)).

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint fresh_in_fmla(id:Z) (f:fmla) {struct f}: Prop :=
  match f with
  | (Fterm e) => (fresh_in_term id e)
  | ((Fand f1 f2)|(Fimplies f1 f2)) => (fresh_in_fmla id f1) /\
      (fresh_in_fmla id f2)
  | (Fnot f1) => (fresh_in_fmla id f1)
  | (Flet y t f1) => (~ (id = y)) /\ ((fresh_in_term id t) /\
      (fresh_in_fmla id f1))
  | (Fforall y ty f1) => (~ (id = y)) /\ (fresh_in_fmla id f1)
  end.
Unset Implicit Arguments.

(* Why3 assumption *)
Set Implicit Arguments.
Fixpoint subst(f:fmla) (x:Z) (v:Z) {struct f}: fmla :=
  match f with
  | (Fterm e) => (Fterm (subst_term e x v))
  | (Fand f1 f2) => (Fand (subst f1 x v) (subst f2 x v))
  | (Fnot f1) => (Fnot (subst f1 x v))
  | (Fimplies f1 f2) => (Fimplies (subst f1 x v) (subst f2 x v))
  | (Flet y t f1) => (Flet y (subst_term t x v) (subst f1 x v))
  | (Fforall y ty f1) => (Fforall y ty (subst f1 x v))
  end.
Unset Implicit Arguments.

Axiom eval_subst : forall (f:fmla) (sigma:(map Z value)) (pi:(map Z value))
  (x:Z) (v:Z), (fresh_in_fmla v f) -> ((eval_fmla sigma pi (subst f x v)) <->
  (eval_fmla (set sigma x (get pi v)) pi f)).

Axiom eval_swap : forall (f:fmla) (sigma:(map Z value)) (pi:(map Z value))
  (id1:Z) (id2:Z) (v1:value) (v2:value), (~ (id1 = id2)) -> ((eval_fmla sigma
  (set (set pi id1 v1) id2 v2) f) <-> (eval_fmla sigma (set (set pi id2 v2)
  id1 v1) f)).

Axiom eval_change_free : forall (f:fmla) (sigma:(map Z value)) (pi:(map Z
  value)) (id:Z) (v:value), (fresh_in_fmla id f) -> ((eval_fmla sigma (set pi
  id v) f) <-> (eval_fmla sigma pi f)).

(* Why3 assumption *)
Inductive expr  :=
  | Evalue : value -> expr 
  | Ebin : expr -> operator -> expr -> expr 
  | Evar : Z -> expr 
  | Ederef : Z -> expr 
  | Eassign : Z -> expr -> expr 
  | Eseq : expr -> expr -> expr 
  | Elet : Z -> expr -> expr -> expr 
  | Eif : expr -> expr -> expr -> expr 
  | Eassert : fmla -> expr 
  | Ewhile : expr -> fmla -> expr -> expr .

(* Why3 assumption *)
Inductive one_step : (map Z value) -> (map Z value) -> expr -> (map Z value)
  -> (map Z value) -> expr -> Prop :=
  | one_step_assign_ctxt : forall (sigma:(map Z value)) (pi:(map Z value))
      (sigmaqt:(map Z value)) (piqt:(map Z value)) (x:Z) (e:expr) (eqt:expr),
      (one_step sigma pi e sigmaqt piqt eqt) -> (one_step sigma pi (Eassign x
      e) sigmaqt piqt (Eassign x eqt))
  | one_step_assign_value : forall (sigma:(map Z value)) (pi:(map Z value))
      (x:Z) (v:value), (one_step sigma pi (Eassign x (Evalue v)) (set sigma x
      v) pi (Evalue Vvoid))
  | one_step_seq_ctxt : forall (sigma:(map Z value)) (pi:(map Z value))
      (sigmaqt:(map Z value)) (piqt:(map Z value)) (e1:expr) (e1qt:expr)
      (e2:expr), (one_step sigma pi e1 sigmaqt piqt e1qt) -> (one_step sigma
      pi (Eseq e1 e2) sigmaqt piqt (Eseq e1qt e2))
  | one_step_seq_value : forall (sigma:(map Z value)) (pi:(map Z value))
      (e:expr), (one_step sigma pi (Eseq (Evalue Vvoid) e) sigma pi e)
  | one_step_let_ctxt : forall (sigma:(map Z value)) (pi:(map Z value))
      (sigmaqt:(map Z value)) (piqt:(map Z value)) (id:Z) (e1:expr)
      (e1qt:expr) (e2:expr), (one_step sigma pi e1 sigmaqt piqt e1qt) ->
      (one_step sigma pi (Elet id e1 e2) sigmaqt piqt (Elet id e1qt e2))
  | one_step_let_value : forall (sigma:(map Z value)) (pi:(map Z value))
      (id:Z) (v:value) (e:expr), (one_step sigma pi (Elet id (Evalue v) e)
      sigma (set pi id v) e)
  | one_step_if_ctxt : forall (sigma:(map Z value)) (pi:(map Z value))
      (sigmaqt:(map Z value)) (piqt:(map Z value)) (e1:expr) (e1qt:expr)
      (e2:expr) (e3:expr), (one_step sigma pi e1 sigmaqt piqt e1qt) ->
      (one_step sigma pi (Eif e1 e2 e3) sigmaqt piqt (Eif e1qt e2 e3))
  | one_step_if_true : forall (sigma:(map Z value)) (pi:(map Z value))
      (e1:expr) (e2:expr), (one_step sigma pi (Eif (Evalue (Vbool true)) e1
      e2) sigma pi e1)
  | one_step_if_false : forall (sigma:(map Z value)) (pi:(map Z value))
      (e1:expr) (e2:expr), (one_step sigma pi (Eif (Evalue (Vbool false)) e1
      e2) sigma pi e2)
  | one_step_assert : forall (sigma:(map Z value)) (pi:(map Z value))
      (f:fmla), (eval_fmla sigma pi f) -> (one_step sigma pi (Eassert f)
      sigma pi (Evalue Vvoid))
  | one_step_while : forall (sigma:(map Z value)) (pi:(map Z value)) (e:expr)
      (inv:fmla) (eqt:expr), (one_step sigma pi (Ewhile e inv eqt) sigma pi
      (Eif e (Eseq eqt (Ewhile e inv eqt)) (Evalue Vvoid))).

(* Why3 assumption *)
Inductive many_steps : (map Z value) -> (map Z value) -> expr -> (map Z
  value) -> (map Z value) -> expr -> Z -> Prop :=
  | many_steps_refl : forall (sigma:(map Z value)) (pi:(map Z value))
      (i:expr), (many_steps sigma pi i sigma pi i 0%Z)
  | many_steps_trans : forall (sigma1:(map Z value)) (pi1:(map Z value))
      (sigma2:(map Z value)) (pi2:(map Z value)) (sigma3:(map Z value))
      (pi3:(map Z value)) (i1:expr) (i2:expr) (i3:expr) (n:Z),
      (one_step sigma1 pi1 i1 sigma2 pi2 i2) -> ((many_steps sigma2 pi2 i2
      sigma3 pi3 i3 n) -> (many_steps sigma1 pi1 i1 sigma3 pi3 i3
      (n + 1%Z)%Z)).

Axiom steps_non_neg : forall (sigma1:(map Z value)) (pi1:(map Z value))
  (sigma2:(map Z value)) (pi2:(map Z value)) (i1:expr) (i2:expr) (n:Z),
  (many_steps sigma1 pi1 i1 sigma2 pi2 i2 n) -> (0%Z <= n)%Z.

Axiom many_steps_seq : forall (sigma1:(map Z value)) (pi1:(map Z value))
  (sigma3:(map Z value)) (pi3:(map Z value)) (e1:expr) (e2:expr) (n:Z),
  (many_steps sigma1 pi1 (Eseq e1 e2) sigma3 pi3 (Evalue Vvoid) n) ->
  exists sigma2:(map Z value), exists pi2:(map Z value), exists n1:Z,
  exists n2:Z, (many_steps sigma1 pi1 e1 sigma2 pi2 (Evalue Vvoid) n1) /\
  ((many_steps sigma2 pi2 e2 sigma3 pi3 (Evalue Vvoid) n2) /\
  (n = ((1%Z + n1)%Z + n2)%Z)).

(* Why3 assumption *)
Definition valid_fmla(p:fmla): Prop := forall (sigma:(map Z value)) (pi:(map
  Z value)), (eval_fmla sigma pi p).

(* Why3 assumption *)
Definition valid_triple(p:fmla) (e:expr) (q:fmla): Prop := forall (sigma:(map
  Z value)) (pi:(map Z value)), (eval_fmla sigma pi p) ->
  forall (sigmaqt:(map Z value)) (piqt:(map Z value)) (v:value) (n:Z),
  (many_steps sigma pi e sigmaqt piqt (Evalue v) n) -> (eval_fmla sigmaqt
  (set piqt (-1%Z)%Z v) q).

(* Why3 goal *)
Theorem consequence_rule : forall (p:fmla) (pqt:fmla) (q:fmla) (qqt:fmla)
  (e:expr), (valid_fmla (Fimplies pqt p)) -> ((valid_triple p e q) ->
  ((valid_fmla (Fimplies q qqt)) -> (valid_triple pqt e qqt))).
unfold valid_triple.
intros p p' q q' e.
intros Hp'_p Hvalid Hq_q'.
intros sigma pi Hp' sigma' pi' v n Hexec.
unfold valid_fmla in *.
simpl in Hq_q'.
apply Hq_q'.
eapply Hvalid.
simpl in Hp'_p.
apply Hp'_p.
apply Hp'.
eauto.
Qed.


