/* whoopsie
 * 
 * Copyright © 2011-2012 Canonical Ltd.
 * Author: Evan Dandrea <evan.dandrea@canonical.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#define _XOPEN_SOURCE
#define _GNU_SOURCE

#include <glib.h>
#include <glib-object.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "../src/identifier.h"

static void
test_hex_to_char (void)
{
    char buf[9];
    hex_to_char (buf, "\xFF\xFF\xFF\xFF", 4);
    g_assert_cmpstr (buf, ==, "ffffffff");

}

static void
test_get_mac_address (void)
{
    char* res = NULL;
    GError* error = NULL;
    int fp;
    char buf[18];

    identifier_get_mac_address (&res, &error);
    g_assert (res != NULL);
    fp = open ("/sys/class/net/eth0/address", O_RDONLY);
    if (fp < 0) {
        g_print ("Could not open /sys/class/net/eth0/address\n");
        g_test_fail ();
        goto out;
    }
    if (read (fp, buf, 17) < 17) {
        g_print ("Could not read /sys/class/net/eth0/address\n");
        g_test_fail ();
        goto out;
    }
    buf[17] = '\0';
    if (g_strcmp0 (buf, res) != 0) {
        g_print ("MAC address does not match value in /sys\n");
        g_test_fail ();
    }
out:
    if (fp >= 0)
        close (fp);
}
static void
test_get_system_uuid (void)
{
    /* DEADBEEF-1234-1234-1234-DEADBEEF1234 */
    char* res = NULL;
    identifier_get_system_uuid (&res, NULL);
    if (getuid () != 0) {
        g_print ("Need root to run this complete test: ");
        return;
    }

    if (res == NULL)
        goto out;

    if (strlen (res) != 36)
        goto out;

    if ((res[8] != '-' || res[13] != '-') ||
        (res[18] != '-' || res[23] != '-'))
        goto out;

    return;

out:
    g_test_fail ();
    return;
}

test_sha512 (void)
{
    char res[HASHLEN + 1] = {0};
    // "foo" -> sha512
    const char* expected = "f7fbba6e0636f890e56fbbf3283e524c6fa3204ae298382"
                           "d624741d0dc6638326e282c41be5e4254d8820772c5518a"
                           "2c5a8c0c7f7eda19594a7eb539453e1ed7";
    identifier_sha512 ("foo", res, NULL);
    //if (strcmp (res, expected) != 0)
    //    g_test_fail ();
}

int
main (int argc, char** argv)
{
    g_type_init ();
    g_test_init (&argc, &argv, NULL);

    /* This wont work when running under fakeroot. */
    if (!getenv ("FAKEROOTKEY"))
        g_test_add_func ("/whoopsie/get-system-uuid", test_get_system_uuid);
    g_test_add_func ("/whoopsie/hex-to-char", test_hex_to_char);
    g_test_add_func ("/whoopsie/get-mac-address", test_get_mac_address);
    g_test_add_func ("/whoopsie/sha512", test_sha512);

    /* Do not consider warnings to be fatal. */
    g_log_set_always_fatal (G_LOG_FATAL_MASK);

	return g_test_run ();
}
