/* whoopsie
 * 
 * Copyright © 2011 Canonical Ltd.
 * Author: Evan Dandrea <evan.dandrea@canonical.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "whoopsie.h"

static void
test_parse_report (void)
{
    GHashTable* report = NULL;
    int i = 0;
    gpointer key = NULL;
    char* keys[] = {
        "ProblemType",
        "Architecture",
        "Package",
        "Date",
        "DistroRelease",
        "ExecutablePath",
        "ProcCmdline",
        "ProcCwd",
        "ProcEnviron",
        "ProcMaps",
        "ProcStatus",
        "Signal",
        "Uname",
        "UserGroups",
        "CoreDump",
        NULL,
    };
    report = parse_report (TEST_DIR "/data/_usr_bin_gedit.1000.crash");
    g_assert (report != NULL);
    while (keys[i] != NULL) {
        key = NULL;
        key = g_hash_table_lookup (report, keys[i]);
        if (key == NULL)
            g_error ("%s was not found.", keys[i]);
        i++;
    }
}

int
main (int argc, char** argv)
{
    g_type_init ();
    g_test_init (&argc, &argv, NULL);

    g_test_add_func("/whoopsie/parse-report", test_parse_report);

	return g_test_run ();
}
