#!/usr/bin/python
# -*- coding: utf-8 -*-
# 
# Copyright © 2011 Canonical Ltd.
# Author: Evan Dandrea <evan.dandrea@canonical.com>
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pika
import atexit
import os
from subprocess import Popen, PIPE
import apport
from pycassa.pool import ConnectionPool
from pycassa.columnfamily import ColumnFamily
from hashlib import md5

cas_host = '10.55.60.75:9160'
pool = ConnectionPool('testing', [cas_host])
oops_fam = ColumnFamily(pool, 'OOPS')
indexes_fam = ColumnFamily(pool, 'Indexes')
stack_fam = ColumnFamily(pool, 'Stacktrace')

mq_host = '10.55.60.168'
# TODO envar or parameters
sandbox = 'sandbox'
cache = '/tmp/cache'
connection = pika.BlockingConnection(pika.ConnectionParameters(host=mq_host))
atexit.register(connection.close)
channel = connection.channel()

for queue in ('retrace_amd64', 'retrace_i386'):
    channel.queue_declare(queue=queue, durable=True)

def callback(ch, method, props, path):
    print 'Processing', path
    if not os.path.exists(path):
        print path, 'does not exist, skipping.'
        # We've processed this. Delete it off the MQ.
        ch.basic_ack(delivery_tag=method.delivery_tag)
        os.remove(path)

    new_path = '%s.core' % path
    with open(new_path, 'wb') as fp:
        print 'Decompressing to', new_path
        p1 = Popen(['base64', '-d', path], stdout=PIPE)
        p2 = Popen(['zcat'], stdin=p1.stdout, stdout=fp)
        ret = p2.communicate()
    if p2.returncode != 0:
        print >>sys.stderr, 'Error processing %s:\n%s' % (path, ret[1])
        # We've processed this. Delete it off the MQ.
        ch.basic_ack(delivery_tag=method.delivery_tag)
        os.remove(path)
        os.remove(new_path)
        return

    report = apport.Report()
    uuid = path.rsplit('/', 1)[1]
    # TODO use oops-repository instead
    col = oops_fam.get(uuid)
    for k in col:
        report[k] = col[k]
    
    report['CoreDump'] = (new_path,)
    report_path = '%s.crash' % path
    with open(report_path, 'w') as fp:
        report.write(fp)
    print 'Retracing'
    proc = Popen(['apport-retrace', report_path, '-S', sandbox, '-C',
                  cache, '-o', '%s.new' % report_path])
    proc.communicate()
    # TODO Put failed traces on a failed queue.
    if proc.returncode == 0:
        print 'Writing back to Cassandra'
        report = apport.Report()
        report.load(open('%s.new' % report_path, 'r'))
        stacktrace_addr_sig = report['StacktraceAddressSignature']
        stacktrace = report['Stacktrace']
        hashed_stack = md5(stacktrace).hexdigest()

        # We want really quick lookups of whether we have a stacktrace
        # for this signature, so that we can quickly tell the client
        # whether we need a core dump from it.
        indexes_fam.insert('stacktrace_hashes_by_signature',
            {stacktrace_addr_sig : hashed_stack})
        stack_fam.insert(hashed_stack, {'stacktrace' : stacktrace})
    else:
        print 'Could not retrace.'

    # We've processed this. Delete it off the MQ.
    ch.basic_ack(delivery_tag=method.delivery_tag)
    for p in (path, new_path, report_path, '%s.new' % report_path):
        try:
            os.remove(p)
        except OSError:
            if errno != 2:
                raise
    print 'Done processing', path

channel.basic_qos(prefetch_count=1)
p = Popen(['dpkg-architecture', '-qDEB_HOST_ARCH'], stdout=PIPE)
arch = p.communicate()[0].strip('\n')
print 'Waiting for messages. ^C to exit.'
channel.basic_consume(callback, queue='retrace_%s' % arch)
try:
    channel.start_consuming()
except KeyboardInterrupt:
    pass
