#include <gtk/gtk.h>
#include <gio/gio.h>
#include <libgnome-control-center/cc-panel.h>
#include <polkit/polkit.h>

#include "whoopsie-generated.h"

static WhoopsiePreferences* proxy = NULL;

extern void* whoopsie_daisy_preferences_new (void);

#define POL_PATH "com.ubuntu.whoopsiepreferences.change"

#define WHOOPSIE_DAISY_TYPE_PREFERENCES_PANEL whoopsie_daisy_preferences_panel_get_type()
#define WHOOPSIE_DAISY_PREFERENCES_PANEL(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
    WHOOPSIE_DAISY_TYPE_PREFERENCES_PANEL, WhoopsieDaisyPreferencesPanel))
#define WHOOPSIE_DAISY_PREFERENCES_PANEL_PRIVATE(o) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((o), WHOOPSIE_DAISY_TYPE_PREFERENCES_PANEL, WhoopsieDaisyPreferencesPanelPrivate))

GType whoopsie_daisy_preferences_panel_get_type (void) G_GNUC_CONST;

typedef struct _WhoopsieDaisyPreferencesPanel WhoopsieDaisyPreferencesPanel;
typedef struct _WhoopsieDaisyPreferencesPanelClass WhoopsieDaisyPreferencesPanelClass;
typedef struct _WhoopsieDaisyPreferencesPanelPrivate WhoopsieDaisyPreferencesPanelPrivate;

struct _WhoopsieDaisyPreferencesPanelPrivate
{
    GtkBuilder* builder;
    GPermission* permission;
};

struct _WhoopsieDaisyPreferencesPanel
{
  CcPanel parent;
  WhoopsieDaisyPreferencesPanelPrivate* priv;
};

struct _WhoopsieDaisyPreferencesPanelClass
{
  CcPanelClass parent_class;
};

G_DEFINE_DYNAMIC_TYPE (WhoopsieDaisyPreferencesPanel, whoopsie_daisy_preferences_panel, CC_TYPE_PANEL)

static void
whoopsie_daisy_preferences_panel_class_finalize (WhoopsieDaisyPreferencesPanelClass *klass)
{
}

static void
whoopsie_daisy_preferences_panel_dispose (GObject* object)
{
    WhoopsieDaisyPreferencesPanelPrivate* priv = WHOOPSIE_DAISY_PREFERENCES_PANEL (object)->priv;

    if (priv->builder) {
        g_object_unref (priv->builder);
        priv->builder = NULL;
    }
    if (priv->permission) {
        g_object_unref (priv->permission);
        priv->permission = NULL;
    }
}

static void
whoopsie_daisy_preferences_panel_class_init (WhoopsieDaisyPreferencesPanelClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  g_type_class_add_private (klass, sizeof (WhoopsieDaisyPreferencesPanelPrivate));
  object_class->dispose = whoopsie_daisy_preferences_panel_dispose;
}

static void
on_permission_changed (GPermission* permission, GParamSpec* pspec, gpointer data)
{
    gboolean allowed;
    GtkWidget* error_reports_box = NULL;
    GtkWidget* metrics_reports_box = NULL;
    WhoopsieDaisyPreferencesPanelPrivate* priv = WHOOPSIE_DAISY_PREFERENCES_PANEL (data)->priv;

    error_reports_box = GTK_WIDGET (gtk_builder_get_object (
                                    priv->builder, "error_reports_box"));
    metrics_reports_box = GTK_WIDGET (gtk_builder_get_object (
                                      priv->builder, "metrics_reports_box"));

    allowed = g_permission_get_allowed (permission);
    gtk_widget_set_sensitive (error_reports_box, allowed);
    gtk_widget_set_sensitive (metrics_reports_box, allowed);
}

static void
on_submit_error_reports_checked (GtkToggleButton* button, gpointer user_data)
{
    GError* error = NULL;

    whoopsie_preferences_call_set_report_crashes_sync (proxy,
        gtk_toggle_button_get_active (button), NULL, &error);
    if (error != NULL) {
        g_printerr ("Error setting crash reporting: %s\n", error->message);
        g_error_free (error);
    }
}

static void
on_submit_metrics_reports_checked (GtkToggleButton* button, gpointer user_data)
{
    GError* error = NULL;

    whoopsie_preferences_call_set_report_metrics_sync (proxy,
        gtk_toggle_button_get_active (button), NULL, &error);
    if (error != NULL) {
        g_printerr ("Error setting metrics reporting: %s\n", error->message);
        g_error_free (error);
    }
}

static void
on_properties_changed (WhoopsiePreferences* interface,
                       GVariant* changed_properties,
                       const gchar* const* invalidated_properties,
                       gpointer user_data)
{
    WhoopsieDaisyPreferencesPanelPrivate* priv = WHOOPSIE_DAISY_PREFERENCES_PANEL (user_data)->priv;
    gboolean report_errors, report_metrics;
    GtkWidget* submit_error_reports = NULL;
    GtkWidget* submit_metrics_reports = NULL;

    submit_error_reports = GTK_WIDGET (
        gtk_builder_get_object (priv->builder, "submit_error_reports"));
    submit_metrics_reports = GTK_WIDGET (
        gtk_builder_get_object (priv->builder, "submit_metrics_reports"));

    report_errors = whoopsie_preferences_get_report_crashes (interface);
    report_metrics = whoopsie_preferences_get_report_metrics (interface);

    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (submit_error_reports), report_errors);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (submit_metrics_reports), report_metrics);
}

static void
whoopsie_daisy_preferences_panel_setup_dbus (WhoopsieDaisyPreferencesPanel *self)
{
    GError* error = NULL;
    WhoopsieDaisyPreferencesPanelPrivate* priv = WHOOPSIE_DAISY_PREFERENCES_PANEL (self)->priv;
    proxy = whoopsie_preferences_proxy_new_for_bus_sync (G_BUS_TYPE_SYSTEM,
                                         G_DBUS_PROXY_FLAGS_NONE,
                                         "com.ubuntu.WhoopsiePreferences",
                                         "/com/ubuntu/WhoopsiePreferences",
                                         NULL, &error);
    if (proxy == NULL) {
        // TODO handle error
    }
    g_signal_connect (proxy, "g-properties-changed",
                                   G_CALLBACK (on_properties_changed), self);
    on_properties_changed (proxy, NULL, NULL, self);
}
static void
whoopsie_daisy_preferences_panel_init (WhoopsieDaisyPreferencesPanel *self)
{
    GError *error = NULL;
    GtkWidget* privacy_page = NULL;
    GtkWidget* unlock_align = NULL;
    GtkWidget* unlock_button = NULL;
    GtkWidget* submit_error_reports = NULL;
    GtkWidget* submit_metrics_reports = NULL;
    GtkBuilder* builder = NULL;
    WhoopsieDaisyPreferencesPanelPrivate* priv;
    priv = self->priv = WHOOPSIE_DAISY_PREFERENCES_PANEL_PRIVATE (self);
    
    priv->builder = gtk_builder_new ();
    gtk_builder_add_from_file(priv->builder, GNOMECC_UI_DIR "/whoopsie.ui", &error);
    if (error != NULL) {
        g_warning ("Could not load interface file %s", error->message);
        g_error_free (error);
        return;
    }
    submit_error_reports = GTK_WIDGET (
        gtk_builder_get_object (priv->builder, "submit_error_reports"));
    submit_metrics_reports = GTK_WIDGET (
        gtk_builder_get_object (priv->builder, "submit_metrics_reports"));
    privacy_page = GTK_WIDGET (
        gtk_builder_get_object (priv->builder, "privacy_page_box"));
    unlock_align = GTK_WIDGET (
        gtk_builder_get_object (priv->builder, "unlock_alignment"));

    gtk_widget_reparent (privacy_page, (GtkWidget *) self);
    g_object_set (self, "valign", GTK_ALIGN_START, NULL);

    priv->permission = polkit_permission_new_sync (POL_PATH, NULL, NULL, NULL);
    if (priv->permission == NULL)
        g_warning ("Could not acquire permission.");

    unlock_button = gtk_lock_button_new (priv->permission);
    gtk_container_add (GTK_CONTAINER (unlock_align), GTK_WIDGET (unlock_button));
    gtk_widget_show (unlock_button);

    g_signal_connect (priv->permission, "notify", G_CALLBACK (on_permission_changed), self);
    on_permission_changed (priv->permission, NULL, self);

    whoopsie_daisy_preferences_panel_setup_dbus (self);
    g_signal_connect (submit_error_reports, "toggled",
                      G_CALLBACK (on_submit_error_reports_checked), NULL);
    g_signal_connect (submit_metrics_reports, "toggled",
                      G_CALLBACK (on_submit_metrics_reports_checked), NULL);
}

void
g_io_module_load (GIOModule *module)
{
  whoopsie_daisy_preferences_panel_register_type (G_TYPE_MODULE (module));
  g_io_extension_point_implement (CC_SHELL_PANEL_EXTENSION_POINT,
                                  WHOOPSIE_DAISY_TYPE_PREFERENCES_PANEL,
                                  "whoopsie-daisy", 0);

}

void
g_io_module_unload (GIOModule *module)
{
}
