#!/usr/bin/python
# -*- coding: utf-8 -*-
# 
# Copyright © 2011 Canonical Ltd.
# Author: Evan Dandrea <evan.dandrea@canonical.com>
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from cgi import parse_qs, escape
import pika
import shutil
import atexit

host = '10.55.60.168'
connection = pika.BlockingConnection(pika.ConnectionParameters(host=host))
channel = connection.channel()
channel.queue_declare(queue='process_cores', durable=True)
atexit.register(connection.close)

def application(environ, start_response):
    params = parse_qs(environ.get('QUERY_STRING'))
    if params and 'uuid' in params:
        uuid = escape(params['uuid'][0])
        if environ.has_key('CONTENT_TYPE') and environ['CONTENT_TYPE'] == 'application/octet-stream':
            path = '/tmp/%s' % uuid
            with open (path, 'w') as fp:
                shutil.copyfileobj(environ['wsgi.input'], fp, 512)
                channel.basic_publish(
                    exchange='', routing_key='process_cores', body=path,
                    properties=pika.BasicProperties(delivery_mode=2))
        start_response('200 OK', [])
        return [uuid]
        
    start_response('200 OK', [])
    return ['']
