/* whoopsie
 * 
 * Copyright © 2011 Canonical Ltd.
 * Author: Evan Dandrea <evan.dandrea@canonical.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

static void
test_parse_report (void)
{
    GHashTable* report = NULL;
    int i = 0;
    gpointer key = NULL;
    char* keys[] = {
        "ProblemType",
        "Architecture",
        "Package",
        "Date",
        "DistroRelease",
        "ExecutablePath",
        "ProcCmdline",
        "ProcCwd",
        "ProcEnviron",
        "ProcMaps",
        "ProcStatus",
        "Signal",
        "Uname",
        "UserGroups",
        "CoreDump",
        NULL,
    };
    report = parse_report (TEST_DIR "/data/_usr_bin_gedit.1000.crash");
    g_assert (report != NULL);
    while (keys[i] != NULL) {
        key = NULL;
        key = g_hash_table_lookup (report, keys[i]);
        if (key == NULL)
            g_error ("%s was not found.", keys[i]);
        i++;
    }
}

static void
test_hex_to_char (void)
{
    char buf[9];
    hex_to_char (buf, "\xFF\xFF\xFF\xFF", 4);
    g_assert_cmpstr (buf, ==, "ffffffff");

}

static void
test_get_system_uuid (void)
{
    /* DEADBEEF-1234-1234-1234-DEADBEEF1234 */
    char res[129] = {0};
    get_system_uuid (res);
    if (getuid () == 0) {
        g_assert (res[0] != 0);
    } else {
        g_print ("Need root to run this complete test: ");
    }
    memset (res, 0, 129);
    seteuid (1000);
    get_system_uuid (res);
    g_assert (res[0] == 0);
    seteuid (0);
}

static void
test_get_crash_db_url (void)
{
    char* url = NULL;
    setenv ("CRASH_DB_URL", "http://localhost:8080");
    url = get_crash_db_url ();
    g_assert_cmpstr (url, ==, "http://localhost:8080");
    unsetenv ("CRASH_DB_URL");
    free (url);
    url = NULL;
    url = get_crash_db_url ();
    g_assert (url == NULL);
}

int
main (int argc, char** argv)
{
    g_type_init ();
    g_test_init (&argc, &argv, NULL);

    g_test_add_func("/whoopsie/parse-report", test_parse_report);
    g_test_add_func("/whoopsie/get-system-uuid", test_get_system_uuid);
    g_test_add_func("/whoopsie/get-crash-db-url", test_get_crash_db_url);
    g_test_add_func("/whoopsie/hex-to-char", test_hex_to_char);

	return g_test_run ();
}
