#!/usr/bin/python
# -*- coding: utf-8 -*-
# 
# Copyright © 2011 Canonical Ltd.
# Author: Evan Dandrea <evan.dandrea@canonical.com>
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pika
import atexit
import os
from subprocess import Popen, PIPE

host = '10.55.60.168'
connection = pika.BlockingConnection(pika.ConnectionParameters(host=host))
atexit.register(connection.close)
channel = connection.channel()

for queue in ('process_cores', 'retrace_amd64', 'retrace_i386'):
    channel.queue_declare(queue=queue, durable=True)

def callback(ch, method, props, body):
    path = body
    if os.path.exists(path):
        new_path = '%s.core' % path
        with open(new_path, 'wb') as fp:
            p1 = Popen(['base64', '-d', path], stdout=PIPE)
            p2 = Popen(['zcat'], stdin=p1.stdout, stdout=fp)
            p2.communicate()
        cmd = ['objdump', '-a', new_path]
        result = Popen(cmd, stdout=PIPE).communicate()[0]
        arch = None
        for line in result.splitlines():
            if line.endswith('elf64-x86-64'):
                arch = 'amd64'
                break
            elif line.endswith('elf32-i386'):
                arch = 'i386'
                break
        if arch:
            # Ready to be retraced. Put on a retracing MQ.
            channel.basic_publish(
                exchange='', routing_key='retrace_%s' % arch, body=new_path,
                properties=pika.BasicProperties(delivery_mode=2))
    # We've processed this. Delete it off the MQ.
    ch.basic_ack(delivery_tag=method.delivery_tag)
    os.remove(path)

channel.basic_qos(prefetch_count=1)
channel.basic_consume(callback, queue='process_cores')
print 'Waiting for messages. ^C to exit.'
try:
    channel.start_consuming()
except KeyboardInterrupt:
    pass
