#!/usr/bin/python
from mod_python import apache, util
import bson
import simplejson
import pycassa
import uuid
import time
from meter import Meter

# Remember, oopsrepository is merely the API layer over Cassandra.  The rest
# lives here. So in the future, we'll call oopsrepository.insert().

content_type = 'Content-Type'
ostream = 'application/octet-stream'
meter = Meter('10.55.60.163', 8125, 'crashdb')
teapot = 418 # :)

def timed_call(func):
    def wrapped(*args, **kwargs):
        global meter
        name = '%s.%s' % ('frontend', func.__name__)
        start = time.time()
        ret = func(*args, **kwargs)
        meter.timing(name, time.time() - start)
        return ret
    return wrapped

@timed_call
def handler(req):
    data = None
    headers = req.headers_in
    if headers.has_key(content_type) and headers[content_type] == ostream:
        try:
            data = bson.BSON(req.read()).to_dict()
        except bson.errors.InvalidBSON:
            return teapot
    else:
        # Old way of doing things.  Kept around for posterity, but should be
        # removed before we go to production.
        fs = util.FieldStorage(req)
        if fs.has_key('json'):
            try:
                data = simplejson.loads(fs['json'])
            except ValueError:
                return teapot
    if data:
        row_key = uuid.uuid1()
        # TODO exceptions
        pool = pycassa.connect('testing', ['10.55.60.75:9160'])
        col_fam = pycassa.ColumnFamily(pool, 'crashes')
        col_fam.insert(row_key, data)
        if 'StacktraceAddressSignature' in data:
            req.write(str(row_key))
        else:
            req.write('%s CORE' % str(row_key))
            
    return apache.OK
