/*
 * DefDialog.cpp
 *
 * Copyright (C) 2003 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#include "stdafx.h"
#include <ctype.h>
#include "resource.h"
#include "MyString.h"
#include "newline.h"
#include "Path.h"
#include "Node.h"
#include "DefDialog.h"
#include "DuneApp.h"

DefDialog::DefDialog(SWND parent, Scene* scene)
  : Dialog(parent, IDD_DEF)
{
    _scene = scene;
    _node = _scene->getSelection()->getNode();
    _valid = false;
    LoadData();
}

DefDialog::~DefDialog()
{
}

bool
DefDialog::Validate()
{
    return _valid;
}

void
DefDialog::LoadData()
{
    const char *nodeName = _node->getName();
    if (strlen(nodeName) != 0)
        swSetText(swGetDialogItem(_dlg, IDC_DEF_NAME), nodeName);
    else
        swSetText(swGetDialogItem(_dlg, IDC_DEF_NAME), 
                  _scene->getUniqueNodeName(_node));
}

void
DefDialog::SaveData()
{
    char name[1024] = "";
    swGetText(swGetDialogItem(_dlg, IDC_DEF_NAME), name, 1024);
    unsigned char invalidChar = (char) 0;
    if (!isalpha(name[0]))
        invalidChar = name[0];
    else
        for (int i=1; i < strlen(name); i++)
            if (!((isalnum(name[i])) || (name[i] == '_'))) {
                invalidChar = name[i];
                break;
            }
    if (invalidChar != (char) 0) {
        char msg[256];
        swLoadString(IDS_INVALID_DEF_ERROR, msg, 255);
        char msg2[256];
        mysnprintf(msg2, 256, msg, invalidChar);
        swMessageBox(TheApp->mainWnd(), msg2, "invalid DEF", SW_MB_OK, 
                     SW_MB_ERROR);
    } else if (_scene->hasAlreadyName(name)) {
        char msg[256];
        swLoadString(IDS_DEF_ALREADY_ERROR, msg, 255);
        swMessageBox(TheApp->mainWnd(), msg,
                     "invalid DEF", SW_MB_OK, SW_MB_ERROR);
    } else {
        _valid = true;
        _scene->def(name, _node);
    }
}

