/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_HOST_H
#define _WF_HOST_H

#include <iostream>
#include <list>
#include <string>

#include "wfipaddr.h"
#include "wfiface.h"
#include "wfservice.h"

/* List of supported Operating Systems. */
/* Please update array in host.cc when updating this. */
enum wf_os {
  WF_OS_UNKNOWN, WF_OS_LINUX, WF_OS_FREEBSD, WF_OS_NETBSD, WF_OS_OPENBSD,
  WF_OS_SOLARIS, WF_OS_SUNOS, WF_OS_IRIX, WF_OS_HPUX
};

/* List of supported Linux distributions. */
/* Please update array in host.cc when updating this. */
enum wf_lindistrib {
  WF_LINDISTRIB_UNKNOWN, WF_LINDISTRIB_DEBIAN, WF_LINDISTRIB_MANDRAKE,
  WF_LINDISTRIB_REDHAT
};
/* ALL@@1
{ WF_LINDISTRIB_UNKNOWN, WF_LINDISTRIB_DEBIAN, WF_LINDISTRIB_SLACKWARE,
  WF_LINDISTRIB_MANDRAKE, WF_LINDISTRIB_REDHAT, WF_LINDISTRIB_SUSE,
  WF_LINDISTRIB_TURBOLINUX };
*/

/**
 * host: contains:
 * <ul>
 *  <li>an IP address
 *  <li>a list of interfaces
 *  <li>a list of services
 * </ul>
 */
class wf_host {
 public:
  wf_host();
  virtual ~wf_host();
  // wf_host(const wf_host& host);

  bool iface_isdefined(const string& name) const;
  bool iface_add(const wf_iface& iface);
  void iface_del(const wf_iface& iface);
  void iface_del(const string& name);
  
  bool service_add(const wf_service& service);
  void service_del(const wf_service& service);
  
  bool os_version_guess();
  bool os_guess();
  string os_tostr() const;
  string os_version_tostr() const;
#ifdef linux
  bool linux_distribution_guess();
#endif
  string linux_distribution_tostr() const;
  string linux_distribution_version_tostr() const;
  bool name_guess();
  bool ifaces_guess(bool skip_useless = false);
  bool guess(bool skip_useless = false);

  bool check() const;

  ostream& debugprint(ostream& os) const;
  
 public:
  string name;
  string fqdn; /* optional */
  string comment; /* optional */
  wf_ipaddr ipaddr;
  list<wf_iface> ifaces; /* optional */
  list<wf_service> services; /* optional */

  /* Operating System */
  enum wf_os os; /* optional */
  short int os_version_major; /* optional */
  short int os_version_minor; /* optional */
  short int os_version_micro; /* optional */

  /* Linux distribution, if os is Linux */
  enum wf_lindistrib lindistrib; /* optional */
  short int lindistrib_version_major; /* optional */
  short int lindistrib_version_minor; /* optional */
};

#endif
