/* 
 * Copyright © 2012 Intel Corporation
 * 
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 * 
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>
#include <stdint.h>
#include "wayland-util.h"

extern const struct wl_interface wl_seat_interface;
extern const struct wl_interface wl_surface_interface;
extern const struct wl_interface wl_seat_interface;
extern const struct wl_interface wl_surface_interface;
extern const struct wl_interface text_model_interface;

static const struct wl_interface *types[] = {
	NULL,
	NULL,
	NULL,
	NULL,
	&wl_seat_interface,
	&wl_surface_interface,
	&wl_seat_interface,
	&wl_surface_interface,
	&text_model_interface,
};

static const struct wl_message text_model_requests[] = {
	{ "set_surrounding_text", "suu", types + 0 },
	{ "activate", "oo", types + 4 },
	{ "deactivate", "o", types + 6 },
	{ "reset", "", types + 0 },
	{ "set_micro_focus", "iiii", types + 0 },
	{ "set_preedit", "", types + 0 },
	{ "set_content_type", "", types + 0 },
};

static const struct wl_message text_model_events[] = {
	{ "commit_string", "su", types + 0 },
	{ "preedit_string", "su", types + 0 },
	{ "delete_surrounding_text", "iu", types + 0 },
	{ "preedit_styling", "", types + 0 },
	{ "key", "uu", types + 0 },
	{ "selection_replacement", "", types + 0 },
	{ "direction", "", types + 0 },
	{ "locale", "", types + 0 },
	{ "enter", "o", types + 7 },
	{ "leave", "", types + 0 },
};

WL_EXPORT const struct wl_interface text_model_interface = {
	"text_model", 1,
	7, text_model_requests,
	10, text_model_events,
};

static const struct wl_message text_model_factory_requests[] = {
	{ "create_text_model", "n", types + 8 },
};

WL_EXPORT const struct wl_interface text_model_factory_interface = {
	"text_model_factory", 1,
	1, text_model_factory_requests,
	0, NULL,
};

