/* 
 * Copyright © 2012 Intel Corporation
 * 
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 * 
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 */

#include <stdlib.h>
#include <stdint.h>
#include "wayland-util.h"

extern const struct wl_interface input_method_context_interface;
extern const struct wl_interface input_method_context_interface;

static const struct wl_interface *types[] = {
	NULL,
	NULL,
	NULL,
	&input_method_context_interface,
	&input_method_context_interface,
};

static const struct wl_message input_method_context_requests[] = {
	{ "destroy", "", types + 0 },
	{ "commit_string", "su", types + 0 },
	{ "preedit_string", "su", types + 0 },
	{ "delete_surrounding_text", "iu", types + 0 },
	{ "key", "uu", types + 0 },
};

static const struct wl_message input_method_context_events[] = {
	{ "surrounding_text", "suu", types + 0 },
	{ "reset", "", types + 0 },
};

WL_EXPORT const struct wl_interface input_method_context_interface = {
	"input_method_context", 1,
	5, input_method_context_requests,
	2, input_method_context_events,
};

static const struct wl_message input_method_events[] = {
	{ "activate", "n", types + 3 },
	{ "deactivate", "o", types + 4 },
};

WL_EXPORT const struct wl_interface input_method_interface = {
	"input_method", 1,
	0, NULL,
	2, input_method_events,
};

