#!/bin/bash
# Rapport des comptes bancaires
# Liste l'intégralité des comptes dans Boobank, leurs dernières opérations et les opérations à venir
# et envoie ça par mail si --mail machin@example.tld est spécifié, sinon ça affiche
# (Compatible Debian Squeze)
# Public domain <BohwaZ>

SUBJECT="[Bank] Accounts report"
TMPSTORAGE=`mktemp -d`

boobank -q -f table list > ${TMPSTORAGE}/account_list

ACCOUNTS=`awk '/@/ {print $2}' ${TMPSTORAGE}/account_list`

for i in $ACCOUNTS
do
	boobank -q -f table history "$i" > ${TMPSTORAGE}/account_history_${i}
	boobank -q -f table coming "$i"  > ${TMPSTORAGE}/account_coming_${i}
done

printf "Bank accounts report, generated by boobank\n" > ${TMPSTORAGE}/account_mail
cat ${TMPSTORAGE}/account_list >> ${TMPSTORAGE}/account_mail
printf "\n" >> ${TMPSTORAGE}/account_mail

for i in $ACCOUNTS
do
	printf "Last operations for account $i \n" >> ${TMPSTORAGE}/account_mail
	cat ${TMPSTORAGE}/account_history_${i} >> ${TMPSTORAGE}/account_mail
	printf "\n" >> ${TMPSTORAGE}/account_mail
	if [ -s ${TMPSTORAGE}/account_coming_${i} ]
	then
		printf "Coming operations for account $i \n" >> ${TMPSTORAGE}/account_mail
		cat ${TMPSTORAGE}/account_coming_${i} >> ${TMPSTORAGE}/account_mail
                printf "\n" >> ${TMPSTORAGE}/account_mail
	else
		printf "No coming operation for $i \n" >> ${TMPSTORAGE}/account_mail
	fi
done

if [ "$1" = "--mail" ]
then
        cat ${TMPSTORAGE}/account_mail | mail -s "$SUBJECT" -a "Content-type: text/plain; charset=UTF-8" "$2"
else
        cat ${TMPSTORAGE}/account_mail
fi

rm -rf ${TMPSTORAGE}
