SET @OLD_CHARACTER_SET_CLIENT       = @@CHARACTER_SET_CLIENT;
SET @OLD_CHARACTER_SET_RESULTS      = @@CHARACTER_SET_RESULTS;
SET @OLD_CHARACTER_SET_CONNECTION   = @@CHARACTER_SET_CONNECTION;
SET @OLD_COLLATION_CONNECTION       = @@COLLATION_CONNECTION;
SET @OLD_TIME_ZONE                  = @@TIME_ZONE;
SET @OLD_UNIQUE_CHECKS              = @@UNIQUE_CHECKS;
SET @OLD_FOREIGN_KEY_CHECKS         = @@FOREIGN_KEY_CHECKS;
SET @OLD_SQL_MODE                   = @@SQL_MODE;
SET @OLD_SQL_NOTES                  = @@SQL_NOTES;

SET CHARACTER_SET_CLIENT            = 'utf8';
SET CHARACTER_SET_RESULTS           = 'utf8';
SET CHARACTER_SET_CONNECTION        = 'utf8';
SET TIME_ZONE                       = '+00:00';
SET UNIQUE_CHECKS                   = 0;
SET FOREIGN_KEY_CHECKS              = 0;
SET SQL_MODE                        = 'NO_AUTO_VALUE_ON_ZERO';
SET SQL_NOTES                       = 0;
CREATE TABLE `AdSku` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `purchaseTemplate` char(22) binary NOT NULL,
  `manageTemplate` char(22) binary NOT NULL,
  `adSpace` char(22) binary NOT NULL,
  `priority` int(11) DEFAULT '1',
  `pricePerClick` float DEFAULT '0',
  `pricePerImpression` float DEFAULT '0',
  `clickDiscounts` char(22) DEFAULT NULL,
  `impressionDiscounts` char(22) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Article` (
  `linkTitle` char(255) DEFAULT NULL,
  `linkURL` text,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `storageId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Calendar` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `defaultDate` enum('current','first','last') DEFAULT 'current',
  `defaultView` enum('month','week','day','list') DEFAULT 'month',
  `visitorCacheTimeout` int(11) unsigned DEFAULT NULL,
  `templateIdMonth` char(22) binary DEFAULT 'CalendarMonth000000001',
  `templateIdWeek` char(22) binary DEFAULT 'CalendarWeek0000000001',
  `templateIdDay` char(22) binary DEFAULT 'CalendarDay00000000001',
  `templateIdEvent` char(22) binary DEFAULT 'CalendarEvent000000001',
  `templateIdEventEdit` char(22) binary DEFAULT 'CalendarEventEdit00001',
  `templateIdSearch` char(22) binary DEFAULT 'CalendarSearch00000001',
  `templateIdPrintMonth` char(22) binary DEFAULT 'CalendarPrintMonth0001',
  `templateIdPrintWeek` char(22) binary DEFAULT 'CalendarPrintWeek00001',
  `templateIdPrintDay` char(22) binary DEFAULT 'CalendarPrintDay000001',
  `templateIdPrintEvent` char(22) binary DEFAULT 'CalendarPrintEvent0001',
  `groupIdEventEdit` char(22) binary DEFAULT '3',
  `groupIdSubscribed` char(22) binary DEFAULT NULL,
  `subscriberNotifyOffset` int(11) DEFAULT NULL,
  `sortEventsBy` enum('time','sequencenumber') DEFAULT 'time',
  `listViewPageInterval` bigint(20) DEFAULT NULL,
  `templateIdList` char(22) binary DEFAULT NULL,
  `templateIdPrintList` char(22) binary DEFAULT NULL,
  `icalInterval` bigint(20) DEFAULT NULL,
  `workflowIdCommit` char(22) binary DEFAULT NULL,
  `icalFeeds` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Carousel` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `items` mediumtext,
  `templateId` char(22) binary DEFAULT NULL,
  `slideWidth` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Collaboration` (
  `assetId` char(22) binary NOT NULL,
  `postGroupId` char(22) binary NOT NULL DEFAULT '2',
  `canStartThreadGroupId` char(22) binary NOT NULL DEFAULT '2',
  `karmaPerPost` int(11) NOT NULL DEFAULT '0',
  `collaborationTemplateId` char(22) binary NOT NULL,
  `threadTemplateId` char(22) binary NOT NULL,
  `postFormTemplateId` char(22) binary NOT NULL,
  `searchTemplateId` char(22) binary NOT NULL,
  `notificationTemplateId` char(22) binary NOT NULL,
  `sortBy` char(35) NOT NULL DEFAULT 'assetData.revisionDate',
  `sortOrder` char(4) NOT NULL DEFAULT 'desc',
  `usePreview` int(11) NOT NULL DEFAULT '1',
  `addEditStampToPosts` int(11) NOT NULL DEFAULT '0',
  `editTimeout` int(11) NOT NULL DEFAULT '3600',
  `attachmentsPerPost` int(11) NOT NULL DEFAULT '0',
  `filterCode` char(30) NOT NULL DEFAULT 'javascript',
  `useContentFilter` int(11) NOT NULL DEFAULT '1',
  `threads` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `replies` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `lastPostId` char(22) binary DEFAULT NULL,
  `lastPostDate` bigint(20) DEFAULT NULL,
  `archiveAfter` int(11) NOT NULL DEFAULT '31536000',
  `postsPerPage` int(11) NOT NULL DEFAULT '10',
  `threadsPerPage` int(11) NOT NULL DEFAULT '30',
  `subscriptionGroupId` char(22) binary DEFAULT NULL,
  `allowReplies` int(11) NOT NULL DEFAULT '0',
  `displayLastReply` int(11) NOT NULL DEFAULT '0',
  `richEditor` char(22) binary NOT NULL DEFAULT 'PBrichedit000000000002',
  `karmaRatingMultiplier` int(11) NOT NULL DEFAULT '0',
  `karmaSpentToRate` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `avatarsEnabled` int(11) NOT NULL DEFAULT '0',
  `approvalWorkflow` char(22) binary NOT NULL DEFAULT 'pbworkflow000000000003',
  `threadApprovalWorkflow` char(22) binary NOT NULL DEFAULT 'pbworkflow000000000003',
  `defaultKarmaScale` int(11) NOT NULL DEFAULT '1',
  `mailServer` char(255) DEFAULT NULL,
  `mailAccount` char(255) DEFAULT NULL,
  `mailPassword` char(255) DEFAULT NULL,
  `mailAddress` char(255) DEFAULT NULL,
  `mailPrefix` char(255) DEFAULT NULL,
  `getMail` int(11) NOT NULL DEFAULT '0',
  `getMailInterval` int(11) NOT NULL DEFAULT '300',
  `getMailCronId` char(22) binary DEFAULT NULL,
  `visitorCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `autoSubscribeToThread` int(11) NOT NULL DEFAULT '1',
  `requireSubscriptionForEmailPosting` int(11) NOT NULL DEFAULT '1',
  `thumbnailSize` int(11) NOT NULL DEFAULT '0',
  `maxImageSize` int(11) NOT NULL DEFAULT '0',
  `enablePostMetaData` int(11) NOT NULL DEFAULT '0',
  `useCaptcha` int(11) NOT NULL DEFAULT '0',
  `groupToEditPost` char(22) binary NOT NULL,
  `archiveEnabled` int(1) DEFAULT '1',
  `postReceivedTemplateId` char(22) binary DEFAULT 'default_post_received1',
  `replyRichEditor` char(22) binary DEFAULT 'PBrichedit000000000002',
  `replyFilterCode` char(30) binary DEFAULT 'javascript',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Dashboard` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `adminsGroupId` char(22) binary NOT NULL DEFAULT '4',
  `usersGroupId` char(22) binary NOT NULL DEFAULT '2',
  `templateId` char(22) binary NOT NULL DEFAULT 'DashboardViewTmpl00001',
  `isInitialized` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `assetsToHide` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `DataForm` (
  `acknowledgement` text,
  `mailData` int(11) NOT NULL DEFAULT '1',
  `emailTemplateId` char(22) binary NOT NULL,
  `acknowlegementTemplateId` char(22) binary NOT NULL,
  `listTemplateId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `defaultView` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `groupToViewEntries` char(22) binary NOT NULL DEFAULT '7',
  `mailAttachments` int(11) DEFAULT '0',
  `useCaptcha` int(1) DEFAULT '0',
  `storeData` int(1) DEFAULT '1',
  `fieldConfiguration` longtext,
  `tabConfiguration` longtext,
  `workflowIdAddEntry` char(22) binary DEFAULT NULL,
  `htmlAreaRichEditor` char(22) binary DEFAULT '**Use_Default_Editor**',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `DataForm_entry` (
  `DataForm_entryId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `username` char(255) DEFAULT NULL,
  `ipAddress` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `entryData` longtext,
  `submissionDate` datetime DEFAULT NULL,
  PRIMARY KEY (`DataForm_entryId`),
  KEY `assetId` (`assetId`),
  KEY `assetId_submissionDate` (`assetId`,`submissionDate`)
) TYPE=MyISAM;
CREATE TABLE `DataTable` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `data` longtext,
  `templateId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `EMSBadge` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  `seatsAvailable` int(11) NOT NULL DEFAULT '100',
  `relatedBadgeGroups` mediumtext,
  `templateId` char(22) binary NOT NULL,
  `earlyBirdPrice` float NOT NULL DEFAULT '0',
  `earlyBirdPriceEndDate` bigint(20) DEFAULT NULL,
  `preRegistrationPrice` float NOT NULL DEFAULT '0',
  `preRegistrationPriceEndDate` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `EMSBadgeGroup` (
  `badgeGroupId` char(22) binary NOT NULL,
  `emsAssetId` char(22) binary NOT NULL,
  `name` char(100) DEFAULT NULL,
  PRIMARY KEY (`badgeGroupId`)
) TYPE=MyISAM;
CREATE TABLE `EMSEventMetaField` (
  `fieldId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `label` char(100) DEFAULT NULL,
  `dataType` char(20) DEFAULT NULL,
  `visible` tinyint(4) DEFAULT '0',
  `required` tinyint(4) DEFAULT '0',
  `possibleValues` text,
  `defaultValues` text,
  `sequenceNumber` int(5) DEFAULT NULL,
  PRIMARY KEY (`fieldId`)
) TYPE=MyISAM;
CREATE TABLE `EMSRegistrant` (
  `badgeId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `badgeNumber` int(11) NOT NULL AUTO_INCREMENT,
  `badgeAssetId` char(22) binary NOT NULL,
  `emsAssetId` char(22) binary NOT NULL,
  `name` char(35) NOT NULL,
  `address1` char(35) DEFAULT NULL,
  `address2` char(35) DEFAULT NULL,
  `address3` char(35) DEFAULT NULL,
  `city` char(35) DEFAULT NULL,
  `state` char(35) DEFAULT NULL,
  `zipcode` char(35) DEFAULT NULL,
  `country` char(35) DEFAULT NULL,
  `phoneNumber` char(35) DEFAULT NULL,
  `organization` char(35) DEFAULT NULL,
  `email` char(255) DEFAULT NULL,
  `notes` mediumtext,
  `purchaseComplete` tinyint(1) DEFAULT NULL,
  `hasCheckedIn` tinyint(1) DEFAULT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`badgeId`),
  UNIQUE KEY `badgeNumber` (`badgeNumber`),
  KEY `badgeAssetId_purchaseComplete` (`badgeAssetId`,`purchaseComplete`)
) TYPE=MyISAM;
CREATE TABLE `EMSRegistrantRibbon` (
  `badgeId` char(22) binary NOT NULL,
  `ribbonAssetId` char(22) binary NOT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`badgeId`,`ribbonAssetId`)
) TYPE=MyISAM;
CREATE TABLE `EMSRegistrantTicket` (
  `badgeId` char(22) binary NOT NULL,
  `ticketAssetId` char(22) binary NOT NULL,
  `purchaseComplete` tinyint(1) DEFAULT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`badgeId`,`ticketAssetId`),
  KEY `ticketAssetId_purchaseComplete` (`ticketAssetId`,`purchaseComplete`)
) TYPE=MyISAM;
CREATE TABLE `EMSRegistrantToken` (
  `badgeId` char(22) binary NOT NULL,
  `tokenAssetId` char(22) binary NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `transactionItemIds` text,
  PRIMARY KEY (`badgeId`,`tokenAssetId`)
) TYPE=MyISAM;
CREATE TABLE `EMSRibbon` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `percentageDiscount` float NOT NULL DEFAULT '10',
  `price` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `EMSTicket` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  `seatsAvailable` int(11) NOT NULL DEFAULT '100',
  `startDate` datetime DEFAULT NULL,
  `duration` float NOT NULL DEFAULT '1',
  `eventNumber` int(11) DEFAULT NULL,
  `location` char(100) DEFAULT NULL,
  `relatedBadgeGroups` mediumtext,
  `relatedRibbons` mediumtext,
  `eventMetaData` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `EMSToken` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Event` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `feedId` char(22) binary DEFAULT NULL,
  `feedUid` char(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `recurId` char(22) binary DEFAULT NULL,
  `description` longtext,
  `startTime` time DEFAULT NULL,
  `endTime` time DEFAULT NULL,
  `relatedLinks` longtext,
  `location` char(255) DEFAULT NULL,
  `storageId` char(22) binary NOT NULL,
  `timeZone` char(255) DEFAULT 'America/Chicago',
  `sequenceNumber` bigint(20) DEFAULT NULL,
  `iCalSequenceNumber` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `EventManagementSystem` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupToApproveEvents` char(22) binary DEFAULT NULL,
  `timezone` char(30) NOT NULL DEFAULT 'America/Chicago',
  `templateId` char(22) binary NOT NULL DEFAULT '2rC4ErZ3c77OJzJm7O5s3w',
  `badgeBuilderTemplateId` char(22) binary NOT NULL DEFAULT 'BMybD3cEnmXVk2wQ_qEsRQ',
  `lookupRegistrantTemplateId` char(22) binary NOT NULL DEFAULT 'OOyMH33plAy6oCj_QWrxtg',
  `printBadgeTemplateId` char(22) binary NOT NULL DEFAULT 'PsFn7dJt4wMwBa8hiE3hOA',
  `printTicketTemplateId` char(22) binary NOT NULL DEFAULT 'yBwydfooiLvhEFawJb0VTQ',
  `badgeInstructions` mediumtext,
  `ribbonInstructions` mediumtext,
  `ticketInstructions` mediumtext,
  `tokenInstructions` mediumtext,
  `registrationStaffGroupId` char(22) binary NOT NULL,
  `scheduleTemplateId` char(22) binary DEFAULT NULL,
  `scheduleColumnsPerPage` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Event_recur` (
  `recurId` char(22) binary NOT NULL,
  `recurType` char(16) DEFAULT NULL,
  `pattern` char(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` char(10) DEFAULT NULL,
  PRIMARY KEY (`recurId`)
) TYPE=MyISAM;
CREATE TABLE `Event_relatedlink` (
  `eventlinkId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `linkURL` tinytext,
  `linktext` char(80) DEFAULT NULL,
  `groupIdView` char(22) binary NOT NULL,
  `sequenceNumber` bigint(20) DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `FileAsset` (
  `assetId` char(22) binary NOT NULL,
  `storageId` char(22) binary NOT NULL,
  `filename` char(255) NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `FlatDiscount` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT '63ix2-hU0FchXGIWkG3tow',
  `mustSpend` float NOT NULL DEFAULT '0',
  `percentageDiscount` int(3) NOT NULL DEFAULT '0',
  `priceDiscount` float NOT NULL DEFAULT '0',
  `thankYouMessage` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Folder` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `visitorCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `sortAlphabetically` int(11) NOT NULL DEFAULT '0',
  `sortOrder` enum('ASC','DESC') DEFAULT 'ASC',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Gallery` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupIdAddComment` char(22) binary DEFAULT NULL,
  `groupIdAddFile` char(22) binary DEFAULT NULL,
  `imageResolutions` text,
  `imageViewSize` int(11) DEFAULT NULL,
  `imageThumbnailSize` int(11) DEFAULT NULL,
  `maxSpacePerUser` char(20) DEFAULT NULL,
  `richEditIdComment` char(22) binary DEFAULT NULL,
  `templateIdAddArchive` char(22) binary DEFAULT NULL,
  `templateIdDeleteAlbum` char(22) binary DEFAULT NULL,
  `templateIdDeleteFile` char(22) binary DEFAULT NULL,
  `templateIdEditAlbum` char(22) binary DEFAULT NULL,
  `templateIdEditFile` char(22) binary DEFAULT NULL,
  `templateIdListAlbums` char(22) binary DEFAULT NULL,
  `templateIdListAlbumsRss` char(22) binary DEFAULT NULL,
  `templateIdListFilesForUser` char(22) binary DEFAULT NULL,
  `templateIdListFilesForUserRss` char(22) binary DEFAULT NULL,
  `templateIdMakeShortcut` char(22) binary DEFAULT NULL,
  `templateIdSearch` char(22) binary DEFAULT NULL,
  `templateIdViewSlideshow` char(22) binary DEFAULT NULL,
  `templateIdViewThumbnails` char(22) binary DEFAULT NULL,
  `templateIdViewAlbum` char(22) binary DEFAULT NULL,
  `templateIdViewAlbumRss` char(22) binary DEFAULT NULL,
  `templateIdViewFile` char(22) binary DEFAULT NULL,
  `viewAlbumAssetId` char(22) binary DEFAULT NULL,
  `viewDefault` enum('album','list') DEFAULT NULL,
  `viewListOrderBy` char(40) DEFAULT NULL,
  `viewListOrderDirection` enum('ASC','DESC') DEFAULT NULL,
  `workflowIdCommit` char(22) binary DEFAULT NULL,
  `templateIdEditComment` char(22) binary DEFAULT NULL,
  `richEditIdAlbum` char(22) binary DEFAULT NULL,
  `richEditIdFile` char(22) binary DEFAULT NULL,
  `defaultFilesPerPage` int(11) DEFAULT NULL,
  `imageDensity` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `GalleryAlbum` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `allowComments` int(11) DEFAULT NULL,
  `assetIdThumbnail` char(22) binary DEFAULT NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `othersCanAdd` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `GalleryFile` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `userDefined1` longtext,
  `userDefined2` longtext,
  `userDefined3` longtext,
  `userDefined4` longtext,
  `userDefined5` longtext,
  `views` bigint(20) DEFAULT '0',
  `friendsOnly` int(1) DEFAULT '0',
  `rating` int(1) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `GalleryFile_comment` (
  `assetId` char(22) binary NOT NULL,
  `commentId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `visitorIp` char(255) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `bodyText` longtext,
  PRIMARY KEY (`assetId`,`commentId`),
  KEY `commentId` (`commentId`)
) TYPE=MyISAM;
CREATE TABLE `HttpProxy` (
  `proxiedUrl` text,
  `timeout` int(11) DEFAULT NULL,
  `removeStyle` int(11) DEFAULT NULL,
  `filterHtml` char(30) DEFAULT NULL,
  `followExternal` int(11) DEFAULT NULL,
  `followRedirect` int(11) DEFAULT NULL,
  `cacheHttp` int(11) DEFAULT '0',
  `useCache` int(11) DEFAULT '0',
  `debug` int(11) DEFAULT '0',
  `rewriteUrls` int(11) DEFAULT NULL,
  `searchFor` char(255) DEFAULT NULL,
  `stopAt` char(255) DEFAULT NULL,
  `cookieJarStorageId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '0',
  `useAmpersand` int(11) NOT NULL DEFAULT '0',
  `urlPatternFilter` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `ImageAsset` (
  `assetId` char(22) binary NOT NULL,
  `thumbnailSize` int(11) NOT NULL DEFAULT '50',
  `parameters` text,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `annotations` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `InOutBoard` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `statusList` text,
  `reportViewerGroup` char(22) binary NOT NULL DEFAULT '3',
  `inOutGroup` char(22) binary NOT NULL DEFAULT '2',
  `inOutTemplateId` char(22) binary NOT NULL DEFAULT 'IOB0000000000000000001',
  `reportTemplateId` char(22) binary NOT NULL DEFAULT 'IOB0000000000000000002',
  `paginateAfter` int(11) NOT NULL DEFAULT '50',
  `reportPaginateAfter` int(11) NOT NULL DEFAULT '50',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `InOutBoard_delegates` (
  `userId` char(22) binary NOT NULL,
  `delegateUserId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL
) TYPE=MyISAM;
CREATE TABLE `InOutBoard_status` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `status` char(255) DEFAULT NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text
) TYPE=MyISAM;
CREATE TABLE `InOutBoard_statusLog` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `status` char(255) DEFAULT NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text,
  `createdBy` char(22) binary DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `Layout` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `contentPositions` text,
  `assetsToHide` text,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `assetOrder` char(20) DEFAULT 'asc',
  `mobileTemplateId` char(22) binary DEFAULT 'PBtmpl0000000000000054',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Map` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupIdAddPoint` char(22) binary DEFAULT NULL,
  `mapApiKey` text,
  `mapHeight` char(12) DEFAULT NULL,
  `mapWidth` char(12) DEFAULT NULL,
  `startLatitude` float DEFAULT NULL,
  `startLongitude` float DEFAULT NULL,
  `startZoom` tinyint(3) unsigned DEFAULT NULL,
  `templateIdEditPoint` char(22) binary DEFAULT NULL,
  `templateIdView` char(22) binary DEFAULT NULL,
  `templateIdViewPoint` char(22) binary DEFAULT NULL,
  `workflowIdPoint` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `MapPoint` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `latitude` float DEFAULT NULL,
  `longitude` float DEFAULT NULL,
  `website` char(22) binary DEFAULT NULL,
  `address1` char(22) binary DEFAULT NULL,
  `address2` char(22) binary DEFAULT NULL,
  `city` char(22) binary DEFAULT NULL,
  `state` char(22) binary DEFAULT NULL,
  `zipCode` char(22) binary DEFAULT NULL,
  `country` char(22) binary DEFAULT NULL,
  `phone` char(22) binary DEFAULT NULL,
  `fax` char(22) binary DEFAULT NULL,
  `email` char(22) binary DEFAULT NULL,
  `storageIdPhoto` char(22) binary DEFAULT NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Matrix` (
  `detailTemplateId` char(22) binary DEFAULT NULL,
  `compareTemplateId` char(22) binary DEFAULT NULL,
  `searchTemplateId` char(22) binary DEFAULT NULL,
  `categories` text,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `maxComparisons` int(11) NOT NULL DEFAULT '10',
  `maxComparisonsPrivileged` int(11) NOT NULL DEFAULT '10',
  `defaultSort` char(22) binary NOT NULL DEFAULT 'score',
  `compareColorNo` char(22) binary DEFAULT '#ffaaaa',
  `compareColorLimited` char(22) binary NOT NULL DEFAULT '#ffffaa',
  `compareColorCostsExtra` char(22) binary NOT NULL DEFAULT '#ffffaa',
  `compareColorFreeAddOn` char(22) binary NOT NULL DEFAULT '#ffffaa',
  `compareColorYes` char(22) binary NOT NULL DEFAULT '#aaffaa',
  `submissionApprovalWorkflowId` char(22) binary NOT NULL,
  `ratingsDuration` int(11) NOT NULL DEFAULT '7776000',
  `editListingTemplateId` char(22) binary DEFAULT NULL,
  `groupToAdd` char(22) binary DEFAULT '2',
  `screenshotsConfigTemplateId` char(22) binary DEFAULT NULL,
  `screenshotsTemplateId` char(22) binary DEFAULT NULL,
  `statisticsCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `maxScreenshotWidth` int(11) DEFAULT NULL,
  `maxScreenshotHeight` int(11) DEFAULT NULL,
  `listingsCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `maxComparisonsGroup` char(22) binary DEFAULT NULL,
  `maxComparisonsGroupInt` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `MatrixListing` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `screenshots` char(22) binary DEFAULT NULL,
  `description` text,
  `version` char(255) DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `compares` int(11) DEFAULT NULL,
  `clicks` int(11) DEFAULT NULL,
  `viewsLastIp` char(255) DEFAULT NULL,
  `comparesLastIp` char(255) DEFAULT NULL,
  `clicksLastIp` char(255) DEFAULT NULL,
  `lastUpdated` int(11) DEFAULT NULL,
  `maintainer` char(22) binary DEFAULT NULL,
  `manufacturerName` char(255) DEFAULT NULL,
  `manufacturerURL` char(255) DEFAULT NULL,
  `productURL` char(255) DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `MatrixListing_attribute` (
  `matrixId` char(22) binary NOT NULL,
  `matrixListingId` char(22) binary NOT NULL,
  `attributeId` char(22) binary NOT NULL,
  `value` char(255) DEFAULT NULL,
  PRIMARY KEY (`attributeId`,`matrixListingId`)
) TYPE=MyISAM;
CREATE TABLE `MatrixListing_rating` (
  `timeStamp` int(11) NOT NULL DEFAULT '0',
  `category` char(255) DEFAULT NULL,
  `rating` int(11) NOT NULL DEFAULT '1',
  `listingId` char(22) binary NOT NULL,
  `ipAddress` char(15) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `MatrixListing_ratingSummary` (
  `listingId` char(22) binary NOT NULL,
  `category` char(255) NOT NULL,
  `meanValue` decimal(3,2) DEFAULT NULL,
  `medianValue` int(11) DEFAULT NULL,
  `countValue` int(11) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  PRIMARY KEY (`listingId`,`category`)
) TYPE=MyISAM;
CREATE TABLE `Matrix_attribute` (
  `attributeId` char(22) binary NOT NULL,
  `category` char(255) NOT NULL,
  `name` char(255) DEFAULT NULL,
  `description` text,
  `fieldType` char(255) NOT NULL DEFAULT 'MatrixCompare',
  `defaultValue` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `options` text,
  PRIMARY KEY (`attributeId`),
  KEY `categoryIndex` (`category`)
) TYPE=MyISAM;
CREATE TABLE `MessageBoard` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `visitorCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `MultiSearch` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT 'MultiSearchTmpl0000001',
  `predefinedSearches` text,
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Navigation` (
  `assetId` char(22) binary NOT NULL,
  `assetsToInclude` text,
  `startType` char(35) DEFAULT NULL,
  `startPoint` char(255) DEFAULT NULL,
  `descendantEndPoint` int(11) NOT NULL DEFAULT '55',
  `showSystemPages` int(11) NOT NULL DEFAULT '0',
  `showHiddenPages` int(11) NOT NULL DEFAULT '0',
  `showUnprivilegedPages` int(11) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL,
  `ancestorEndPoint` int(11) NOT NULL DEFAULT '55',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `mimeType` char(50) DEFAULT 'text/html',
  `reversePageLoop` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Newsletter` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `newsletterTemplateId` char(22) binary NOT NULL DEFAULT 'newsletter000000000001',
  `mySubscriptionsTemplateId` char(22) binary NOT NULL DEFAULT 'newslettersubscrip0001',
  `newsletterHeader` mediumtext,
  `newsletterFooter` mediumtext,
  `newsletterCategories` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Newsletter_subscriptions` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `subscriptions` text,
  `lastTimeSent` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`userId`),
  KEY `lastTimeSent_assetId_userId` (`lastTimeSent`,`assetId`,`userId`)
) TYPE=MyISAM;
CREATE TABLE `PM_project` (
  `projectId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `name` char(255) NOT NULL,
  `description` text,
  `startDate` bigint(20) DEFAULT NULL,
  `endDate` bigint(20) DEFAULT NULL,
  `projectManager` char(22) binary DEFAULT NULL,
  `durationUnits` enum('hours','days') DEFAULT 'hours',
  `hoursPerDay` float DEFAULT NULL,
  `targetBudget` float(15,2) DEFAULT '0.00',
  `percentComplete` float NOT NULL DEFAULT '0',
  `parentId` char(22) binary DEFAULT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `projectObserver` char(22) binary DEFAULT '7',
  PRIMARY KEY (`projectId`)
) TYPE=MyISAM;
CREATE TABLE `PM_task` (
  `taskId` char(22) binary NOT NULL,
  `projectId` char(22) binary NOT NULL,
  `taskName` char(255) NOT NULL,
  `duration` float DEFAULT NULL,
  `startDate` bigint(20) DEFAULT NULL,
  `endDate` bigint(20) DEFAULT NULL,
  `dependants` char(50) DEFAULT NULL,
  `parentId` char(22) binary DEFAULT NULL,
  `percentComplete` float DEFAULT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `lagTime` bigint(20) DEFAULT '0',
  `taskType` enum('timed','progressive','milestone') NOT NULL DEFAULT 'timed',
  PRIMARY KEY (`taskId`)
) TYPE=MyISAM;
CREATE TABLE `PM_taskResource` (
  `taskResourceId` char(22) binary NOT NULL,
  `taskId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `resourceKind` enum('user','group') NOT NULL,
  `resourceId` char(22) binary NOT NULL,
  PRIMARY KEY (`taskResourceId`),
  UNIQUE KEY `taskId` (`taskId`,`resourceKind`,`resourceId`),
  UNIQUE KEY `taskId_2` (`taskId`,`sequenceNumber`)
) TYPE=MyISAM;
CREATE TABLE `PM_wobject` (
  `assetId` char(22) binary NOT NULL,
  `projectDashboardTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0001',
  `projectDisplayTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0002',
  `ganttChartTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0003',
  `editTaskTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0004',
  `groupToAdd` char(22) binary NOT NULL DEFAULT '3',
  `revisionDate` bigint(20) NOT NULL,
  `resourcePopupTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0005',
  `resourceListTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0006',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Photo` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `exifData` longtext,
  `location` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Photo_rating` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `visitorIp` char(255) DEFAULT NULL,
  `rating` int(11) DEFAULT NULL,
  KEY `assetId` (`assetId`)
) TYPE=MyISAM;
CREATE TABLE `Poll` (
  `active` int(11) NOT NULL DEFAULT '1',
  `graphWidth` int(11) NOT NULL DEFAULT '150',
  `voteGroup` char(22) binary DEFAULT NULL,
  `question` char(255) DEFAULT NULL,
  `a1` char(255) DEFAULT NULL,
  `a2` char(255) DEFAULT NULL,
  `a3` char(255) DEFAULT NULL,
  `a4` char(255) DEFAULT NULL,
  `a5` char(255) DEFAULT NULL,
  `a6` char(255) DEFAULT NULL,
  `a7` char(255) DEFAULT NULL,
  `a8` char(255) DEFAULT NULL,
  `a9` char(255) DEFAULT NULL,
  `a10` char(255) DEFAULT NULL,
  `a11` char(255) DEFAULT NULL,
  `a12` char(255) DEFAULT NULL,
  `a13` char(255) DEFAULT NULL,
  `a14` char(255) DEFAULT NULL,
  `a15` char(255) DEFAULT NULL,
  `a16` char(255) DEFAULT NULL,
  `a17` char(255) DEFAULT NULL,
  `a18` char(255) DEFAULT NULL,
  `a19` char(255) DEFAULT NULL,
  `a20` char(255) DEFAULT NULL,
  `karmaPerVote` int(11) NOT NULL DEFAULT '0',
  `randomizeAnswers` int(11) NOT NULL DEFAULT '0',
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `graphConfiguration` blob,
  `generateGraph` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Poll_answer` (
  `answer` char(3) DEFAULT NULL,
  `userId` char(22) binary NOT NULL,
  `ipAddress` char(50) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL
) TYPE=MyISAM;
CREATE TABLE `Post` (
  `assetId` char(22) binary NOT NULL,
  `threadId` char(22) binary NOT NULL,
  `username` char(30) DEFAULT NULL,
  `content` mediumtext,
  `views` int(11) NOT NULL DEFAULT '0',
  `contentType` char(35) NOT NULL DEFAULT 'mixed',
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `storageId` char(22) binary NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `originalEmail` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `threadId_rating` (`threadId`,`rating`)
) TYPE=MyISAM;
CREATE TABLE `Post_rating` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `ipAddress` char(15) NOT NULL,
  `dateOfRating` bigint(20) DEFAULT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  KEY `assetId_userId` (`assetId`,`userId`),
  KEY `assetId_ipAddress` (`assetId`,`ipAddress`)
) TYPE=MyISAM;
CREATE TABLE `Product` (
  `image1` char(255) DEFAULT NULL,
  `image2` char(255) DEFAULT NULL,
  `image3` char(255) DEFAULT NULL,
  `brochure` char(255) DEFAULT NULL,
  `manual` char(255) DEFAULT NULL,
  `warranty` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `thankYouMessage` mediumtext,
  `accessoryJSON` longtext,
  `benefitJSON` longtext,
  `featureJSON` longtext,
  `relatedJSON` longtext,
  `specificationJSON` longtext,
  `variantsJSON` longtext,
  `isShippingRequired` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `RichEdit` (
  `assetId` char(22) binary NOT NULL,
  `askAboutRichEdit` int(11) NOT NULL DEFAULT '0',
  `preformatted` int(11) NOT NULL DEFAULT '0',
  `editorWidth` int(11) NOT NULL DEFAULT '0',
  `editorHeight` int(11) NOT NULL DEFAULT '0',
  `sourceEditorWidth` int(11) NOT NULL DEFAULT '0',
  `sourceEditorHeight` int(11) NOT NULL DEFAULT '0',
  `useBr` int(11) NOT NULL DEFAULT '0',
  `nowrap` int(11) NOT NULL DEFAULT '0',
  `removeLineBreaks` int(11) NOT NULL DEFAULT '0',
  `npwrap` int(11) NOT NULL DEFAULT '0',
  `directionality` char(3) NOT NULL DEFAULT 'ltr',
  `toolbarLocation` char(6) NOT NULL DEFAULT 'bottom',
  `cssFile` char(255) DEFAULT NULL,
  `validElements` mediumtext,
  `toolbarRow1` text,
  `toolbarRow2` text,
  `toolbarRow3` text,
  `enableContextMenu` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `disableRichEditor` int(11) DEFAULT '0',
  `inlinePopups` int(11) NOT NULL DEFAULT '0',
  `allowMedia` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `SQLReport` (
  `dbQuery1` text,
  `paginateAfter` int(11) NOT NULL DEFAULT '50',
  `preprocessMacros1` int(11) DEFAULT '0',
  `debugMode` int(11) NOT NULL DEFAULT '0',
  `databaseLinkId1` char(22) binary NOT NULL,
  `placeholderParams1` text,
  `preprocessMacros2` int(11) DEFAULT '0',
  `dbQuery2` text,
  `placeholderParams2` text,
  `databaseLinkId2` char(22) binary NOT NULL,
  `preprocessMacros3` int(11) DEFAULT '0',
  `dbQuery3` text,
  `placeholderParams3` text,
  `databaseLinkId3` char(22) binary NOT NULL,
  `preprocessMacros4` int(11) DEFAULT '0',
  `dbQuery4` text,
  `placeholderParams4` text,
  `databaseLinkId4` char(22) binary NOT NULL,
  `preprocessMacros5` int(11) DEFAULT '0',
  `dbQuery5` text,
  `placeholderParams5` text,
  `databaseLinkId5` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '0',
  `prequeryStatements1` text,
  `prequeryStatements2` text,
  `prequeryStatements3` text,
  `prequeryStatements4` text,
  `prequeryStatements5` text,
  `downloadType` char(255) DEFAULT NULL,
  `downloadFilename` char(255) DEFAULT NULL,
  `downloadTemplateId` char(22) binary DEFAULT NULL,
  `downloadMimeType` char(255) DEFAULT NULL,
  `downloadUserGroup` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Shelf` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT 'nFen0xjkZn8WkpM93C9ceQ',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Shortcut` (
  `overrideTitle` int(11) NOT NULL DEFAULT '0',
  `overrideDescription` int(11) NOT NULL DEFAULT '0',
  `overrideTemplate` int(11) NOT NULL DEFAULT '0',
  `overrideDisplayTitle` int(11) NOT NULL DEFAULT '0',
  `overrideTemplateId` char(22) binary NOT NULL,
  `shortcutByCriteria` int(11) NOT NULL DEFAULT '0',
  `resolveMultiples` char(30) DEFAULT 'mostRecent',
  `shortcutCriteria` text NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `shortcutToAssetId` char(22) binary NOT NULL,
  `disableContentLock` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `prefFieldsToShow` text,
  `prefFieldsToImport` text,
  `showReloadIcon` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Shortcut_overrides` (
  `assetId` char(22) binary NOT NULL,
  `fieldName` char(255) NOT NULL,
  `newValue` text,
  PRIMARY KEY (`assetId`,`fieldName`)
) TYPE=MyISAM;
CREATE TABLE `StockData` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL DEFAULT 'StockListTMPL000000001',
  `displayTemplateId` char(22) binary NOT NULL DEFAULT 'StockListTMPL000000002',
  `defaultStocks` text,
  `source` char(50) DEFAULT 'usa',
  `failover` int(11) DEFAULT '1',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Story` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `headline` char(255) DEFAULT NULL,
  `subtitle` char(255) DEFAULT NULL,
  `byline` char(255) DEFAULT NULL,
  `location` char(255) DEFAULT NULL,
  `highlights` text,
  `story` mediumtext,
  `photo` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `StoryArchive` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `storiesPerPage` int(11) DEFAULT NULL,
  `groupToPost` char(22) binary DEFAULT NULL,
  `templateId` char(22) binary DEFAULT NULL,
  `storyTemplateId` char(22) binary DEFAULT NULL,
  `editStoryTemplateId` char(22) binary DEFAULT NULL,
  `keywordListTemplateId` char(22) binary DEFAULT NULL,
  `archiveAfter` int(11) DEFAULT NULL,
  `richEditorId` char(22) binary DEFAULT NULL,
  `approvalWorkflowId` char(22) binary DEFAULT 'pbworkflow000000000003',
  `photoWidth` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `StoryTopic` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `storiesPer` int(11) DEFAULT NULL,
  `storiesShort` int(11) DEFAULT NULL,
  `templateId` char(22) binary DEFAULT NULL,
  `storyTemplateId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Subscription` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `thankYouMessage` mediumtext,
  `price` float NOT NULL DEFAULT '0',
  `subscriptionGroup` char(22) binary NOT NULL DEFAULT '2',
  `duration` char(12) NOT NULL DEFAULT 'Monthly',
  `executeOnSubscription` char(255) DEFAULT NULL,
  `karma` int(6) DEFAULT '0',
  `recurringSubscription` tinyint(1) NOT NULL DEFAULT '1',
  `redeemSubscriptionCodeTemplateId` char(22) binary NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Subscription_code` (
  `code` char(64) NOT NULL,
  `batchId` char(22) binary NOT NULL,
  `status` char(10) NOT NULL DEFAULT 'Unused',
  `dateUsed` bigint(20) DEFAULT NULL,
  `usedBy` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`code`)
) TYPE=MyISAM;
CREATE TABLE `Subscription_codeBatch` (
  `batchId` char(22) binary NOT NULL,
  `name` char(255) DEFAULT NULL,
  `description` mediumtext,
  `subscriptionId` char(22) binary NOT NULL,
  `expirationDate` bigint(20) NOT NULL,
  `dateCreated` bigint(20) NOT NULL,
  PRIMARY KEY (`batchId`)
) TYPE=MyISAM;
CREATE TABLE `Survey` (
  `groupToTakeSurvey` char(22) binary NOT NULL DEFAULT '2',
  `groupToEditSurvey` char(22) binary NOT NULL DEFAULT '3',
  `groupToViewReports` char(22) binary NOT NULL DEFAULT '3',
  `overviewTemplateId` char(22) binary NOT NULL,
  `maxResponsesPerUser` int(11) NOT NULL DEFAULT '1',
  `gradebookTemplateId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `surveyEditTemplateId` char(22) binary DEFAULT NULL,
  `answerEditTemplateId` char(22) binary DEFAULT NULL,
  `questionEditTemplateId` char(22) binary DEFAULT NULL,
  `sectionEditTemplateId` char(22) binary DEFAULT NULL,
  `surveyTakeTemplateId` char(22) binary DEFAULT NULL,
  `surveyQuestionsId` char(22) binary DEFAULT NULL,
  `exitURL` text,
  `surveyJSON` longtext,
  `timeLimit` mediumint(8) unsigned NOT NULL,
  `showProgress` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `showTimeLimit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `doAfterTimeLimit` char(22) binary DEFAULT NULL,
  `onSurveyEndWorkflowId` char(22) binary DEFAULT NULL,
  `quizModeSummary` tinyint(3) DEFAULT NULL,
  `surveySummaryTemplateId` char(22) binary DEFAULT NULL,
  `allowBackBtn` tinyint(3) DEFAULT NULL,
  `feedbackTemplateId` char(22) binary DEFAULT NULL,
  `testResultsTemplateId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Survey_questionTypes` (
  `questionType` char(56) NOT NULL,
  `answers` text NOT NULL,
  PRIMARY KEY (`questionType`)
) TYPE=MyISAM;
CREATE TABLE `Survey_response` (
  `assetId` char(22) binary NOT NULL,
  `Survey_responseId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `username` char(255) DEFAULT NULL,
  `ipAddress` char(15) DEFAULT NULL,
  `startDate` bigint(20) NOT NULL DEFAULT '0',
  `endDate` bigint(20) NOT NULL DEFAULT '0',
  `isComplete` int(11) NOT NULL DEFAULT '0',
  `anonId` char(255) DEFAULT NULL,
  `responseJSON` longtext,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Survey_responseId`)
) TYPE=MyISAM;
CREATE TABLE `Survey_tempReport` (
  `assetId` char(22) binary NOT NULL,
  `Survey_responseId` char(22) binary NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `sectionNumber` smallint(5) unsigned NOT NULL,
  `sectionName` text,
  `questionNumber` smallint(5) unsigned NOT NULL,
  `questionName` text,
  `questionComment` mediumtext,
  `answerNumber` smallint(5) unsigned DEFAULT NULL,
  `answerValue` mediumtext,
  `answerComment` mediumtext,
  `entryDate` bigint(20) unsigned NOT NULL COMMENT 'UTC Unix Time',
  `isCorrect` tinyint(3) unsigned DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `fileStoreageId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`Survey_responseId`,`order`),
  KEY `assetId` (`assetId`)
) TYPE=MyISAM;
CREATE TABLE `Survey_test` (
  `testId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `assetId` char(255) DEFAULT NULL,
  `name` char(255) DEFAULT NULL,
  `test` mediumtext NOT NULL,
  PRIMARY KEY (`testId`),
  KEY `assetId` (`assetId`)
) TYPE=MyISAM;
CREATE TABLE `SyndicatedContent` (
  `rssUrl` text,
  `maxHeadlines` int(11) NOT NULL DEFAULT '0',
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `hasTerms` char(255) NOT NULL,
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `processMacroInRssUrl` int(11) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `TT_projectList` (
  `projectId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `projectName` char(255) NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  PRIMARY KEY (`projectId`)
) TYPE=MyISAM;
CREATE TABLE `TT_projectResourceList` (
  `projectId` char(22) binary NOT NULL,
  `resourceId` char(22) binary NOT NULL,
  PRIMARY KEY (`projectId`,`resourceId`)
) TYPE=MyISAM;
CREATE TABLE `TT_projectTasks` (
  `taskId` char(22) binary NOT NULL,
  `projectId` char(22) binary NOT NULL,
  `taskName` char(255) NOT NULL,
  PRIMARY KEY (`taskId`)
) TYPE=MyISAM;
CREATE TABLE `TT_report` (
  `reportId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `startDate` char(10) NOT NULL,
  `endDate` char(10) NOT NULL,
  `reportComplete` int(11) NOT NULL DEFAULT '0',
  `resourceId` char(22) binary NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL
) TYPE=MyISAM;
CREATE TABLE `TT_timeEntry` (
  `entryId` char(22) binary NOT NULL,
  `projectId` char(22) binary NOT NULL,
  `taskId` char(22) binary NOT NULL,
  `taskDate` char(10) NOT NULL,
  `hours` float DEFAULT '0',
  `comments` text,
  `reportId` char(22) binary NOT NULL,
  PRIMARY KEY (`entryId`)
) TYPE=MyISAM;
CREATE TABLE `TT_wobject` (
  `assetId` char(22) binary NOT NULL,
  `userViewTemplateId` char(22) binary NOT NULL DEFAULT 'TimeTrackingTMPL000001',
  `managerViewTemplateId` char(22) binary NOT NULL DEFAULT 'TimeTrackingTMPL000002',
  `timeRowTemplateId` char(22) binary NOT NULL DEFAULT 'TimeTrackingTMPL000003',
  `pmAssetId` char(22) binary DEFAULT NULL,
  `groupToManage` char(22) binary NOT NULL DEFAULT '3',
  `revisionDate` bigint(20) NOT NULL,
  `pmIntegration` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Thingy` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `defaultThingId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `ThingyRecord` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateIdView` char(22) binary DEFAULT NULL,
  `thingId` char(22) binary DEFAULT NULL,
  `thingFields` longtext,
  `thankYouText` longtext,
  `price` float DEFAULT NULL,
  `duration` bigint(20) DEFAULT NULL,
  `fieldPrice` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `ThingyRecord_record` (
  `recordId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `transactionId` char(255) DEFAULT NULL,
  `assetId` char(255) DEFAULT NULL,
  `expires` bigint(20) NOT NULL DEFAULT '0',
  `userId` char(255) DEFAULT NULL,
  `fields` longtext,
  `isHidden` tinyint(1) NOT NULL DEFAULT '0',
  `sentExpiresNotice` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`recordId`)
) TYPE=MyISAM;
CREATE TABLE `Thingy_fields` (
  `assetId` char(22) binary NOT NULL,
  `thingId` char(22) binary NOT NULL,
  `fieldId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `dateCreated` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `dateUpdated` bigint(20) NOT NULL,
  `updatedBy` char(22) binary NOT NULL,
  `label` char(255) NOT NULL,
  `fieldType` char(255) NOT NULL,
  `defaultValue` longtext,
  `possibleValues` text,
  `subtext` char(255) DEFAULT NULL,
  `status` char(255) NOT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `vertical` smallint(1) DEFAULT NULL,
  `extras` char(255) DEFAULT NULL,
  `display` int(11) DEFAULT NULL,
  `viewScreenTitle` int(11) DEFAULT NULL,
  `displayInSearch` int(11) DEFAULT NULL,
  `searchIn` int(11) DEFAULT NULL,
  `fieldInOtherThingId` char(22) binary DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `pretext` char(255) DEFAULT NULL,
  PRIMARY KEY (`fieldId`,`thingId`,`assetId`)
) TYPE=MyISAM;
CREATE TABLE `Thingy_things` (
  `assetId` char(22) binary NOT NULL,
  `thingId` char(22) binary NOT NULL,
  `label` char(255) NOT NULL,
  `editScreenTitle` char(255) NOT NULL,
  `editInstructions` text,
  `groupIdAdd` char(22) binary NOT NULL,
  `groupIdEdit` char(22) binary NOT NULL,
  `saveButtonLabel` char(255) NOT NULL,
  `afterSave` char(255) NOT NULL,
  `editTemplateId` char(22) binary NOT NULL,
  `onAddWorkflowId` char(22) binary DEFAULT NULL,
  `onEditWorkflowId` char(22) binary DEFAULT NULL,
  `onDeleteWorkflowId` char(22) binary DEFAULT NULL,
  `groupIdView` char(22) binary NOT NULL,
  `viewTemplateId` char(22) binary NOT NULL,
  `defaultView` char(255) NOT NULL,
  `searchScreenTitle` char(255) NOT NULL,
  `searchDescription` text,
  `groupIdSearch` char(22) binary NOT NULL,
  `groupIdImport` char(22) binary NOT NULL,
  `groupIdExport` char(22) binary NOT NULL,
  `searchTemplateId` char(22) binary NOT NULL,
  `thingsPerPage` int(11) NOT NULL DEFAULT '25',
  `sortBy` char(22) binary DEFAULT NULL,
  `display` int(11) DEFAULT NULL,
  `exportMetaData` int(11) DEFAULT NULL,
  `maxEntriesPerUser` int(11) DEFAULT NULL,
  PRIMARY KEY (`thingId`)
) TYPE=MyISAM;
CREATE TABLE `Thread` (
  `assetId` char(22) binary NOT NULL,
  `replies` int(11) NOT NULL DEFAULT '0',
  `lastPostId` char(22) binary NOT NULL,
  `lastPostDate` bigint(20) DEFAULT NULL,
  `isLocked` int(11) NOT NULL DEFAULT '0',
  `isSticky` int(11) NOT NULL DEFAULT '0',
  `subscriptionGroupId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `karma` int(11) NOT NULL DEFAULT '0',
  `karmaScale` int(11) NOT NULL DEFAULT '1',
  `karmaRank` float(11,6) DEFAULT NULL,
  `threadRating` int(11) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Thread_read` (
  `threadId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  KEY `threadId_userId` (`threadId`,`userId`)
) TYPE=MyISAM;
CREATE TABLE `UserList` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary DEFAULT NULL,
  `showGroupId` char(22) binary DEFAULT NULL,
  `hideGroupId` char(22) binary DEFAULT NULL,
  `usersPerPage` int(11) DEFAULT NULL,
  `alphabet` text,
  `alphabetSearchField` char(128) DEFAULT NULL,
  `showOnlyVisibleAsNamed` int(11) DEFAULT NULL,
  `sortBy` char(128) DEFAULT NULL,
  `sortOrder` char(4) DEFAULT NULL,
  `overridePublicEmail` int(11) DEFAULT NULL,
  `overridePublicProfile` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `WeatherData` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) unsigned NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT 'WeatherDataTmpl0000001',
  `locations` text,
  `partnerId` char(100) DEFAULT NULL,
  `licenseKey` char(100) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `WikiMaster` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupToEditPages` char(22) binary NOT NULL DEFAULT '2',
  `groupToAdminister` char(22) binary NOT NULL DEFAULT '3',
  `richEditor` char(22) binary NOT NULL DEFAULT 'PBrichedit000000000002',
  `frontPageTemplateId` char(22) binary NOT NULL DEFAULT 'WikiFrontTmpl000000001',
  `pageTemplateId` char(22) binary NOT NULL DEFAULT 'WikiPageTmpl0000000001',
  `pageEditTemplateId` char(22) binary NOT NULL DEFAULT 'WikiPageEditTmpl000001',
  `recentChangesTemplateId` char(22) binary NOT NULL DEFAULT 'WikiRCTmpl000000000001',
  `mostPopularTemplateId` char(22) binary NOT NULL DEFAULT 'WikiMPTmpl000000000001',
  `pageHistoryTemplateId` char(22) binary NOT NULL DEFAULT 'WikiPHTmpl000000000001',
  `searchTemplateId` char(22) binary NOT NULL DEFAULT 'WikiSearchTmpl00000001',
  `recentChangesCount` int(11) NOT NULL DEFAULT '50',
  `recentChangesCountFront` int(11) NOT NULL DEFAULT '10',
  `mostPopularCount` int(11) NOT NULL DEFAULT '50',
  `mostPopularCountFront` int(11) NOT NULL DEFAULT '10',
  `thumbnailSize` int(11) NOT NULL DEFAULT '0',
  `maxImageSize` int(11) NOT NULL DEFAULT '0',
  `approvalWorkflow` char(22) binary NOT NULL DEFAULT 'pbworkflow000000000003',
  `useContentFilter` int(11) DEFAULT '0',
  `filterCode` char(30) DEFAULT 'javascript',
  `byKeywordTemplateId` char(22) binary NOT NULL DEFAULT 'WikiKeyword00000000001',
  `allowAttachments` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `WikiPage` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `content` mediumtext,
  `views` bigint(20) NOT NULL DEFAULT '0',
  `isProtected` int(11) NOT NULL DEFAULT '0',
  `actionTaken` char(35) NOT NULL,
  `actionTakenBy` char(22) binary NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `Workflow` (
  `workflowId` char(22) binary NOT NULL,
  `title` char(255) NOT NULL DEFAULT 'Untitled',
  `description` text,
  `enabled` int(11) NOT NULL DEFAULT '0',
  `type` char(255) NOT NULL DEFAULT 'None',
  `mode` char(20) NOT NULL DEFAULT 'parallel',
  PRIMARY KEY (`workflowId`)
) TYPE=MyISAM;
CREATE TABLE `WorkflowActivity` (
  `activityId` char(22) binary NOT NULL,
  `workflowId` char(22) binary NOT NULL,
  `title` char(255) NOT NULL DEFAULT 'Untitled',
  `description` text,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `className` char(255) DEFAULT NULL,
  PRIMARY KEY (`activityId`)
) TYPE=MyISAM;
CREATE TABLE `WorkflowActivityData` (
  `activityId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`activityId`,`name`)
) TYPE=MyISAM;
CREATE TABLE `WorkflowInstance` (
  `instanceId` char(22) binary NOT NULL,
  `workflowId` char(22) binary NOT NULL,
  `currentActivityId` char(22) binary NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '2',
  `className` char(255) DEFAULT NULL,
  `methodName` char(255) DEFAULT NULL,
  `parameters` longtext,
  `runningSince` bigint(20) DEFAULT NULL,
  `lastUpdate` bigint(20) DEFAULT NULL,
  `lastStatus` char(15) DEFAULT NULL,
  `noSession` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`instanceId`)
) TYPE=MyISAM;
CREATE TABLE `WorkflowInstanceScratch` (
  `instanceId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`instanceId`,`name`)
) TYPE=MyISAM;
CREATE TABLE `WorkflowSchedule` (
  `taskId` char(22) binary NOT NULL,
  `title` char(255) NOT NULL DEFAULT 'Untitled',
  `enabled` int(11) NOT NULL DEFAULT '0',
  `runOnce` int(11) NOT NULL DEFAULT '0',
  `minuteOfHour` char(255) NOT NULL DEFAULT '0',
  `hourOfDay` char(255) NOT NULL DEFAULT '*',
  `dayOfMonth` char(255) NOT NULL DEFAULT '*',
  `monthOfYear` char(255) NOT NULL DEFAULT '*',
  `dayOfWeek` char(255) NOT NULL DEFAULT '*',
  `workflowId` char(22) binary NOT NULL,
  `className` char(255) DEFAULT NULL,
  `methodName` char(255) DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '2',
  `parameters` longtext,
  PRIMARY KEY (`taskId`)
) TYPE=MyISAM;
CREATE TABLE `ZipArchiveAsset` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `showPage` char(255) NOT NULL DEFAULT 'index.html',
  `revisionDate` bigint(20) NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `adSkuPurchase` (
  `adSkuPurchaseId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `isDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `clicksPurchased` bigint(20) DEFAULT NULL,
  `dateOfPurchase` bigint(20) DEFAULT NULL,
  `impressionsPurchased` bigint(20) DEFAULT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `adId` char(22) binary DEFAULT NULL,
  `storedImage` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`adSkuPurchaseId`)
) TYPE=MyISAM;
CREATE TABLE `adSpace` (
  `adSpaceId` char(22) binary NOT NULL,
  `name` char(35) NOT NULL,
  `title` char(255) NOT NULL,
  `description` text,
  `costPerImpression` decimal(11,2) NOT NULL DEFAULT '0.00',
  `minimumImpressions` int(11) NOT NULL DEFAULT '1000',
  `costPerClick` decimal(11,2) NOT NULL DEFAULT '0.00',
  `minimumClicks` int(11) NOT NULL DEFAULT '1000',
  `width` int(11) NOT NULL DEFAULT '468',
  `height` int(11) NOT NULL DEFAULT '60',
  `groupToPurchase` char(22) binary NOT NULL DEFAULT '3',
  PRIMARY KEY (`adSpaceId`),
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM;
CREATE TABLE `address` (
  `addressId` char(22) binary NOT NULL,
  `addressBookId` char(22) binary NOT NULL,
  `label` char(35) DEFAULT NULL,
  `firstName` char(35) DEFAULT NULL,
  `lastName` char(35) DEFAULT NULL,
  `address1` char(35) DEFAULT NULL,
  `address2` char(35) DEFAULT NULL,
  `address3` char(35) DEFAULT NULL,
  `city` char(35) DEFAULT NULL,
  `state` char(35) DEFAULT NULL,
  `country` char(35) DEFAULT NULL,
  `code` char(35) DEFAULT NULL,
  `phoneNumber` char(35) DEFAULT NULL,
  `organization` char(255) DEFAULT NULL,
  `email` char(255) DEFAULT NULL,
  PRIMARY KEY (`addressId`),
  KEY `addressBookId_addressId` (`addressBookId`,`addressId`)
) TYPE=MyISAM;
CREATE TABLE `addressBook` (
  `addressBookId` char(22) binary NOT NULL,
  `sessionId` char(22) binary DEFAULT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `defaultAddressId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`addressBookId`),
  KEY `userId` (`sessionId`),
  KEY `sessionId` (`sessionId`)
) TYPE=MyISAM;
CREATE TABLE `advertisement` (
  `adId` char(22) binary NOT NULL,
  `adSpaceId` char(22) binary NOT NULL,
  `ownerUserId` char(22) binary NOT NULL,
  `isActive` int(11) NOT NULL DEFAULT '0',
  `title` char(255) NOT NULL,
  `type` char(15) NOT NULL DEFAULT 'text',
  `storageId` char(22) binary DEFAULT NULL,
  `adText` char(255) DEFAULT NULL,
  `url` text,
  `richMedia` text,
  `borderColor` char(7) NOT NULL DEFAULT '#000000',
  `textColor` char(7) NOT NULL DEFAULT '#000000',
  `backgroundColor` char(7) NOT NULL DEFAULT '#ffffff',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clicksBought` int(11) NOT NULL DEFAULT '0',
  `impressions` int(11) NOT NULL DEFAULT '0',
  `impressionsBought` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `nextInPriority` bigint(20) NOT NULL DEFAULT '0',
  `renderedAd` text,
  PRIMARY KEY (`adId`),
  KEY `adSpaceId_isActive` (`adSpaceId`,`isActive`)
) TYPE=MyISAM;
CREATE TABLE `analyticRule` (
  `ruleId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `bucketName` char(255) DEFAULT NULL,
  `regexp` char(255) NOT NULL DEFAULT '.+',
  PRIMARY KEY (`ruleId`)
) TYPE=MyISAM;
CREATE TABLE `asset` (
  `assetId` char(22) binary NOT NULL,
  `parentId` char(22) binary NOT NULL,
  `lineage` char(255) NOT NULL,
  `state` char(35) NOT NULL,
  `className` char(255) NOT NULL,
  `creationDate` bigint(20) NOT NULL DEFAULT '997995720',
  `createdBy` char(22) binary NOT NULL DEFAULT '3',
  `stateChanged` char(22) binary NOT NULL DEFAULT '997995720',
  `stateChangedBy` char(22) binary NOT NULL DEFAULT '3',
  `isLockedBy` char(22) binary DEFAULT NULL,
  `isSystem` int(11) NOT NULL DEFAULT '0',
  `lastExportedAs` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`),
  UNIQUE KEY `lineage` (`lineage`),
  KEY `parentId` (`parentId`),
  KEY `state_parentId_lineage` (`state`,`parentId`,`lineage`),
  KEY `isPrototype_className_assetId` (`className`,`assetId`),
  KEY `className_assetId_state` (`className`,`assetId`,`state`),
  KEY `state_lineage` (`state`,`lineage`)
) TYPE=MyISAM;
CREATE TABLE `assetAspectComments` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `comments` longtext,
  `averageCommentRating` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `assetAspectRssFeed` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `itemsPerFeed` int(11) DEFAULT '25',
  `feedCopyright` text,
  `feedTitle` text,
  `feedDescription` mediumtext,
  `feedImage` char(22) binary DEFAULT NULL,
  `feedImageLink` text,
  `feedImageDescription` mediumtext,
  `feedHeaderLinks` char(32) DEFAULT 'rss\natom',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `assetData` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `revisedBy` char(22) binary NOT NULL,
  `tagId` char(22) binary NOT NULL,
  `status` char(35) NOT NULL DEFAULT 'pending',
  `title` char(255) NOT NULL DEFAULT 'untitled',
  `menuTitle` char(255) NOT NULL DEFAULT 'untitled',
  `url` char(255) NOT NULL,
  `ownerUserId` char(22) binary NOT NULL,
  `groupIdView` char(22) binary NOT NULL,
  `groupIdEdit` char(22) binary NOT NULL,
  `synopsis` text,
  `newWindow` int(11) NOT NULL DEFAULT '0',
  `isHidden` int(11) NOT NULL DEFAULT '0',
  `isPackage` int(11) NOT NULL DEFAULT '0',
  `isPrototype` int(11) NOT NULL DEFAULT '0',
  `encryptPage` int(11) NOT NULL DEFAULT '0',
  `assetSize` int(11) NOT NULL DEFAULT '0',
  `extraHeadTags` text,
  `skipNotification` int(11) NOT NULL DEFAULT '0',
  `isExportable` int(11) NOT NULL DEFAULT '1',
  `inheritUrlFromParent` int(11) NOT NULL DEFAULT '0',
  `lastModified` bigint(20) DEFAULT NULL,
  `extraHeadTagsPacked` longtext,
  `usePackedHeadTags` int(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `assetId_url` (`assetId`,`url`),
  KEY `assetId_revisionDate_status_tagId` (`assetId`,`revisionDate`,`status`,`tagId`),
  KEY `url` (`url`),
  KEY `assetId_status_tagId_revisionDate` (`assetId`,`status`,`tagId`,`revisionDate`),
  KEY `assetId_status` (`assetId`,`status`)
) TYPE=MyISAM;
CREATE TABLE `assetHistory` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `dateStamp` bigint(20) NOT NULL DEFAULT '0',
  `actionTaken` char(255) NOT NULL,
  `url` char(255) DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `assetIndex` (
  `assetId` char(22) binary NOT NULL,
  `title` char(255) DEFAULT NULL,
  `synopsis` text,
  `url` char(255) DEFAULT NULL,
  `creationDate` bigint(20) DEFAULT NULL,
  `revisionDate` bigint(20) DEFAULT NULL,
  `ownerUserId` char(22) binary DEFAULT NULL,
  `groupIdView` char(22) binary DEFAULT NULL,
  `groupIdEdit` char(22) binary DEFAULT NULL,
  `className` char(255) DEFAULT NULL,
  `isPublic` int(11) NOT NULL DEFAULT '1',
  `keywords` mediumtext,
  `lineage` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`),
  FULLTEXT KEY `keywords` (`keywords`)
) TYPE=MyISAM;
CREATE TABLE `assetKeyword` (
  `keyword` char(64) NOT NULL,
  `assetId` char(22) binary NOT NULL,
  PRIMARY KEY (`keyword`,`assetId`),
  KEY `keyword` (`keyword`),
  KEY `assetId` (`assetId`)
) TYPE=MyISAM;
CREATE TABLE `assetVersionTag` (
  `tagId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `isCommitted` int(11) NOT NULL DEFAULT '0',
  `creationDate` bigint(20) NOT NULL DEFAULT '0',
  `createdBy` char(22) binary NOT NULL,
  `commitDate` bigint(20) NOT NULL DEFAULT '0',
  `committedBy` char(22) binary NOT NULL,
  `isLocked` int(11) NOT NULL DEFAULT '0',
  `lockedBy` char(22) binary NOT NULL,
  `groupToUse` char(22) binary NOT NULL,
  `workflowId` char(22) binary NOT NULL,
  `workflowInstanceId` char(22) binary DEFAULT NULL,
  `comments` text,
  `startTime` datetime DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `isSiteWide` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagId`)
) TYPE=MyISAM;
CREATE TABLE `authentication` (
  `userId` char(22) binary NOT NULL,
  `authMethod` char(30) NOT NULL,
  `fieldName` char(128) NOT NULL,
  `fieldData` text,
  PRIMARY KEY (`userId`,`authMethod`,`fieldName`)
) TYPE=MyISAM;
CREATE TABLE `bucketLog` (
  `userId` char(22) binary NOT NULL,
  `Bucket` char(22) binary NOT NULL,
  `duration` int(11) DEFAULT NULL,
  `timeStamp` datetime DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `cache` (
  `namespace` char(128) NOT NULL,
  `cachekey` char(128) NOT NULL,
  `expires` bigint(20) NOT NULL,
  `size` int(11) NOT NULL,
  `content` mediumblob,
  PRIMARY KEY (`namespace`,`cachekey`),
  KEY `namespace_cachekey_size` (`namespace`,`cachekey`,`expires`)
) TYPE=MyISAM;
CREATE TABLE `cart` (
  `cartId` char(22) binary NOT NULL,
  `sessionId` char(22) binary NOT NULL,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `shipperId` char(22) binary DEFAULT NULL,
  `posUserId` char(22) binary DEFAULT NULL,
  `creationDate` int(20) DEFAULT NULL,
  PRIMARY KEY (`cartId`),
  KEY `sessionId` (`sessionId`)
) TYPE=MyISAM;
CREATE TABLE `cartItem` (
  `itemId` char(22) binary NOT NULL,
  `cartId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `dateAdded` datetime NOT NULL,
  `options` longtext,
  `configuredTitle` char(255) DEFAULT NULL,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`itemId`),
  KEY `cartId_assetId_dateAdded` (`cartId`,`assetId`,`dateAdded`)
) TYPE=MyISAM;
CREATE TABLE `databaseLink` (
  `databaseLinkId` char(22) binary NOT NULL,
  `title` char(255) DEFAULT NULL,
  `DSN` char(255) DEFAULT NULL,
  `username` char(255) DEFAULT NULL,
  `identifier` char(255) DEFAULT NULL,
  `allowedKeywords` text,
  `allowMacroAccess` int(11) NOT NULL DEFAULT '0',
  `additionalParameters` char(255) NOT NULL,
  PRIMARY KEY (`databaseLinkId`)
) TYPE=MyISAM;
CREATE TABLE `deltaLog` (
  `userId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `delta` int(11) DEFAULT NULL,
  `timeStamp` bigint(20) DEFAULT NULL,
  `url` char(255) NOT NULL
) TYPE=MyISAM;
CREATE TABLE `donation` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `defaultPrice` float NOT NULL DEFAULT '100',
  `thankYouMessage` mediumtext,
  `templateId` char(22) binary NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `filePumpBundle` (
  `bundleId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `bundleName` char(255) NOT NULL DEFAULT 'New bundle',
  `lastModified` bigint(20) NOT NULL DEFAULT '0',
  `lastBuild` bigint(20) NOT NULL DEFAULT '0',
  `jsFiles` longtext NOT NULL,
  `cssFiles` longtext NOT NULL,
  `otherFiles` longtext NOT NULL,
  PRIMARY KEY (`bundleId`)
) TYPE=MyISAM;
CREATE TABLE `friendInvitations` (
  `inviteId` char(22) binary NOT NULL,
  `inviterId` char(22) binary NOT NULL,
  `friendId` char(22) binary NOT NULL,
  `dateSent` datetime NOT NULL,
  `comments` char(255) NOT NULL,
  `messageId` char(22) binary NOT NULL,
  PRIMARY KEY (`inviteId`)
) TYPE=MyISAM;
CREATE TABLE `groupGroupings` (
  `groupId` char(22) binary NOT NULL,
  `inGroup` char(22) binary NOT NULL
) TYPE=MyISAM;
CREATE TABLE `groupings` (
  `groupId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `expireDate` bigint(20) NOT NULL DEFAULT '2114402400',
  `groupAdmin` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`groupId`,`userId`),
  KEY `userId` (`userId`)
) TYPE=MyISAM;
CREATE TABLE `groups` (
  `groupId` char(22) binary NOT NULL,
  `groupName` char(100) DEFAULT NULL,
  `description` char(255) DEFAULT NULL,
  `expireOffset` int(11) NOT NULL DEFAULT '314496000',
  `karmaThreshold` int(11) NOT NULL DEFAULT '1000000000',
  `ipFilter` text,
  `dateCreated` int(11) NOT NULL DEFAULT '997938000',
  `lastUpdated` int(11) NOT NULL DEFAULT '997938000',
  `deleteOffset` int(11) NOT NULL DEFAULT '14',
  `expireNotifyOffset` int(11) NOT NULL DEFAULT '-14',
  `expireNotifyMessage` text,
  `expireNotify` int(11) NOT NULL DEFAULT '0',
  `scratchFilter` text,
  `autoAdd` int(11) NOT NULL DEFAULT '0',
  `autoDelete` int(11) NOT NULL DEFAULT '0',
  `databaseLinkId` char(22) binary NOT NULL,
  `groupCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `dbQuery` text,
  `isEditable` int(11) NOT NULL DEFAULT '1',
  `showInForms` int(11) NOT NULL DEFAULT '1',
  `ldapGroup` char(255) DEFAULT NULL,
  `ldapGroupProperty` char(255) DEFAULT NULL,
  `ldapRecursiveProperty` char(255) DEFAULT NULL,
  `ldapLinkId` char(22) binary DEFAULT NULL,
  `ldapRecursiveFilter` mediumtext,
  `isAdHocMailGroup` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`groupId`),
  KEY `groupName` (`groupName`)
) TYPE=MyISAM;
CREATE TABLE `imageColor` (
  `colorId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL DEFAULT 'untitled',
  `fillTriplet` char(7) NOT NULL DEFAULT '#000000',
  `fillAlpha` char(2) NOT NULL DEFAULT '00',
  `strokeTriplet` char(7) NOT NULL DEFAULT '#000000',
  `strokeAlpha` char(2) NOT NULL DEFAULT '00',
  PRIMARY KEY (`colorId`)
) TYPE=MyISAM;
CREATE TABLE `imageFont` (
  `fontId` char(22) binary NOT NULL,
  `name` char(255) DEFAULT NULL,
  `storageId` char(22) binary DEFAULT NULL,
  `filename` char(255) DEFAULT NULL,
  PRIMARY KEY (`fontId`)
) TYPE=MyISAM;
CREATE TABLE `imagePalette` (
  `paletteId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL DEFAULT 'untitled',
  PRIMARY KEY (`paletteId`)
) TYPE=MyISAM;
CREATE TABLE `imagePaletteColors` (
  `paletteId` char(22) binary NOT NULL,
  `colorId` char(22) binary NOT NULL,
  `paletteOrder` int(11) NOT NULL,
  PRIMARY KEY (`paletteId`,`paletteOrder`)
) TYPE=MyISAM;
CREATE TABLE `inbox` (
  `messageId` char(22) binary NOT NULL,
  `status` char(15) NOT NULL DEFAULT 'pending',
  `dateStamp` bigint(20) NOT NULL,
  `completedOn` bigint(20) DEFAULT NULL,
  `completedBy` char(22) binary DEFAULT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `groupId` char(22) binary DEFAULT NULL,
  `subject` char(255) NOT NULL DEFAULT 'No Subject',
  `message` mediumtext,
  `sentBy` char(22) binary NOT NULL DEFAULT '3',
  PRIMARY KEY (`messageId`),
  KEY `completedOn_dateStamp` (`completedOn`,`dateStamp`),
  KEY `pb_userId` (`userId`),
  KEY `pb_groupId` (`groupId`)
) TYPE=MyISAM;
CREATE TABLE `inbox_messageState` (
  `messageId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `isRead` tinyint(4) NOT NULL DEFAULT '0',
  `repliedTo` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`messageId`,`userId`)
) TYPE=MyISAM;
CREATE TABLE `incrementer` (
  `incrementerId` char(50) NOT NULL,
  `nextValue` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`incrementerId`)
) TYPE=MyISAM;
CREATE TABLE `karmaLog` (
  `userId` char(22) binary NOT NULL,
  `amount` int(11) NOT NULL DEFAULT '1',
  `source` char(255) DEFAULT NULL,
  `description` text,
  `dateModified` bigint(20) NOT NULL DEFAULT '0'
) TYPE=MyISAM;
CREATE TABLE `ldapLink` (
  `ldapLinkId` char(22) binary NOT NULL,
  `ldapLinkName` char(255) NOT NULL,
  `ldapUrl` char(255) NOT NULL,
  `connectDn` char(255) NOT NULL,
  `identifier` char(255) NOT NULL,
  `ldapUserRDN` char(255) DEFAULT NULL,
  `ldapIdentity` char(255) DEFAULT NULL,
  `ldapIdentityName` char(255) DEFAULT NULL,
  `ldapPasswordName` char(255) DEFAULT NULL,
  `ldapSendWelcomeMessage` char(2) DEFAULT NULL,
  `ldapWelcomeMessage` text,
  `ldapAccountTemplate` char(22) binary NOT NULL,
  `ldapCreateAccountTemplate` char(22) binary NOT NULL,
  `ldapLoginTemplate` char(22) binary NOT NULL,
  `ldapGlobalRecursiveFilter` mediumtext,
  PRIMARY KEY (`ldapLinkId`)
) TYPE=MyISAM;
CREATE TABLE `mailQueue` (
  `messageId` char(22) binary NOT NULL,
  `message` mediumtext,
  `toGroup` char(22) binary DEFAULT NULL,
  `isInbox` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`messageId`)
) TYPE=MyISAM;
CREATE TABLE `metaData_properties` (
  `fieldId` char(22) binary NOT NULL,
  `fieldName` char(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `fieldType` char(30) DEFAULT NULL,
  `possibleValues` text,
  `defaultValue` char(255) DEFAULT NULL,
  PRIMARY KEY (`fieldId`),
  UNIQUE KEY `field_unique` (`fieldName`)
) TYPE=MyISAM;
CREATE TABLE `metaData_values` (
  `fieldId` char(22) binary NOT NULL,
  `value` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  PRIMARY KEY (`fieldId`,`assetId`)
) TYPE=MyISAM;
CREATE TABLE `passiveAnalyticsStatus` (
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `running` int(2) DEFAULT '0',
  `userId` char(255) NOT NULL
) TYPE=MyISAM;
CREATE TABLE `passiveLog` (
  `userId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `sessionId` char(22) binary NOT NULL,
  `timeStamp` bigint(20) DEFAULT NULL,
  `url` char(255) NOT NULL
) TYPE=MyISAM;
CREATE TABLE `passiveProfileAOI` (
  `userId` char(22) binary NOT NULL,
  `fieldId` char(22) binary NOT NULL,
  `value` char(100) NOT NULL,
  `count` int(11) DEFAULT NULL,
  PRIMARY KEY (`userId`,`fieldId`,`value`)
) TYPE=MyISAM;
CREATE TABLE `passiveProfileLog` (
  `passiveProfileLogId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `sessionId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `dateOfEntry` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`passiveProfileLogId`)
) TYPE=MyISAM;
CREATE TABLE `paymentGateway` (
  `paymentGatewayId` char(22) binary NOT NULL,
  `className` char(255) DEFAULT NULL,
  `options` longtext,
  PRIMARY KEY (`paymentGatewayId`)
) TYPE=MyISAM;
CREATE TABLE `redirect` (
  `assetId` char(22) binary NOT NULL,
  `redirectUrl` text,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `redirectType` int(11) NOT NULL DEFAULT '302',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `replacements` (
  `replacementId` char(22) binary NOT NULL,
  `searchFor` char(255) DEFAULT NULL,
  `replaceWith` text,
  PRIMARY KEY (`replacementId`)
) TYPE=MyISAM;
CREATE TABLE `search` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `classLimiter` text,
  `searchRoot` char(22) binary NOT NULL DEFAULT 'PBasset000000000000001',
  `templateId` char(22) binary NOT NULL DEFAULT 'PBtmpl0000000000000200',
  `useContainers` int(11) NOT NULL DEFAULT '0',
  `paginateAfter` int(11) NOT NULL DEFAULT '25',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `settings` (
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`name`)
) TYPE=MyISAM;
CREATE TABLE `shipper` (
  `shipperId` char(22) binary NOT NULL,
  `className` char(255) DEFAULT NULL,
  `options` longtext,
  PRIMARY KEY (`shipperId`)
) TYPE=MyISAM;
CREATE TABLE `shopCredit` (
  `creditId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `amount` float NOT NULL DEFAULT '0',
  `comment` text,
  `dateOfAdjustment` datetime DEFAULT NULL,
  PRIMARY KEY (`creditId`),
  KEY `userId` (`userId`)
) TYPE=MyISAM;
CREATE TABLE `sku` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `description` mediumtext,
  `sku` char(35) NOT NULL,
  `vendorId` char(22) binary NOT NULL DEFAULT 'defaultvendor000000000',
  `displayTitle` tinyint(1) NOT NULL DEFAULT '1',
  `overrideTaxRate` tinyint(1) NOT NULL DEFAULT '0',
  `taxRateOverride` float NOT NULL DEFAULT '0',
  `taxConfiguration` longtext,
  `shipsSeparately` tinyint(1) NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `sku` (`sku`),
  KEY `vendorId` (`vendorId`)
) TYPE=MyISAM;
CREATE TABLE `snippet` (
  `assetId` char(22) binary NOT NULL,
  `snippet` mediumtext,
  `processAsTemplate` int(11) NOT NULL DEFAULT '0',
  `mimeType` char(50) NOT NULL DEFAULT 'text/html',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `snippetPacked` longtext,
  `usePacked` int(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
CREATE TABLE `taxDriver` (
  `className` char(255) NOT NULL,
  `options` longtext,
  PRIMARY KEY (`className`)
) TYPE=MyISAM;
CREATE TABLE `tax_eu_vatNumbers` (
  `userId` char(22) binary NOT NULL,
  `countryCode` char(3) NOT NULL,
  `vatNumber` char(20) NOT NULL,
  `viesValidated` tinyint(1) DEFAULT NULL,
  `viesErrorCode` int(3) DEFAULT NULL,
  `approved` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`userId`,`vatNumber`)
) TYPE=MyISAM;
CREATE TABLE `tax_generic_rates` (
  `taxId` char(22) binary NOT NULL,
  `country` char(100) NOT NULL,
  `state` char(100) DEFAULT NULL,
  `city` char(100) DEFAULT NULL,
  `code` char(100) DEFAULT NULL,
  `taxRate` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`taxId`)
) TYPE=MyISAM;
CREATE TABLE `template` (
  `template` mediumtext,
  `namespace` char(35) NOT NULL DEFAULT 'Page',
  `isEditable` int(11) NOT NULL DEFAULT '1',
  `showInForms` int(11) NOT NULL DEFAULT '1',
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `parser` char(255) NOT NULL DEFAULT 'WebGUI::Asset::Template::HTMLTemplate',
  `isDefault` int(1) DEFAULT '0',
  `templatePacked` longtext,
  `usePacked` int(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `namespace_showInForms` (`namespace`,`showInForms`)
) TYPE=MyISAM;
CREATE TABLE `template_attachments` (
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `url` varchar(256) NOT NULL,
  `type` varchar(20) DEFAULT NULL,
  `sequence` int(11) DEFAULT NULL,
  `attachId` char(22) binary NOT NULL,
  PRIMARY KEY (`attachId`)
) TYPE=MyISAM;
CREATE TABLE `transaction` (
  `transactionId` char(22) binary NOT NULL,
  `originatingTransactionId` char(22) binary DEFAULT NULL,
  `isSuccessful` tinyint(1) NOT NULL DEFAULT '0',
  `orderNumber` int(11) NOT NULL AUTO_INCREMENT,
  `transactionCode` char(100) DEFAULT NULL,
  `statusCode` char(35) DEFAULT NULL,
  `statusMessage` char(255) DEFAULT NULL,
  `userId` char(22) binary NOT NULL,
  `username` char(35) NOT NULL,
  `amount` float DEFAULT NULL,
  `shopCreditDeduction` float DEFAULT NULL,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `shippingAddressName` char(35) DEFAULT NULL,
  `shippingAddress1` char(35) DEFAULT NULL,
  `shippingAddress2` char(35) DEFAULT NULL,
  `shippingAddress3` char(35) DEFAULT NULL,
  `shippingCity` char(35) DEFAULT NULL,
  `shippingState` char(35) DEFAULT NULL,
  `shippingCountry` char(35) DEFAULT NULL,
  `shippingCode` char(35) DEFAULT NULL,
  `shippingPhoneNumber` char(35) DEFAULT NULL,
  `shippingDriverId` char(22) binary DEFAULT NULL,
  `shippingDriverLabel` char(35) DEFAULT NULL,
  `shippingPrice` float DEFAULT NULL,
  `paymentAddressId` char(22) binary DEFAULT NULL,
  `paymentAddressName` char(35) DEFAULT NULL,
  `paymentAddress1` char(35) DEFAULT NULL,
  `paymentAddress2` char(35) DEFAULT NULL,
  `paymentAddress3` char(35) DEFAULT NULL,
  `paymentCity` char(35) DEFAULT NULL,
  `paymentState` char(35) DEFAULT NULL,
  `paymentCountry` char(35) DEFAULT NULL,
  `paymentCode` char(35) DEFAULT NULL,
  `paymentPhoneNumber` char(35) DEFAULT NULL,
  `paymentDriverId` char(22) binary DEFAULT NULL,
  `paymentDriverLabel` char(35) DEFAULT NULL,
  `taxes` float DEFAULT NULL,
  `dateOfPurchase` datetime DEFAULT NULL,
  `isRecurring` tinyint(1) DEFAULT NULL,
  `notes` mediumtext,
  `cashierUserId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`transactionId`),
  UNIQUE KEY `orderNumber` (`orderNumber`)
) TYPE=MyISAM;
CREATE TABLE `transactionItem` (
  `itemId` char(22) binary NOT NULL,
  `transactionId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `configuredTitle` char(255) DEFAULT NULL,
  `options` longtext,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `shippingName` char(35) DEFAULT NULL,
  `shippingAddress1` char(35) DEFAULT NULL,
  `shippingAddress2` char(35) DEFAULT NULL,
  `shippingAddress3` char(35) DEFAULT NULL,
  `shippingCity` char(35) DEFAULT NULL,
  `shippingState` char(35) DEFAULT NULL,
  `shippingCountry` char(35) DEFAULT NULL,
  `shippingCode` char(35) DEFAULT NULL,
  `shippingPhoneNumber` char(35) DEFAULT NULL,
  `shippingTrackingNumber` char(255) DEFAULT NULL,
  `orderStatus` char(35) NOT NULL DEFAULT 'NotShipped',
  `lastUpdated` datetime DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT '1',
  `price` float DEFAULT NULL,
  `vendorId` char(22) binary NOT NULL DEFAULT 'defaultvendor000000000',
  `vendorPayoutStatus` char(10) DEFAULT 'NotPaid',
  `vendorPayoutAmount` decimal(8,2) DEFAULT '0.00',
  `taxRate` decimal(6,3) DEFAULT NULL,
  `taxConfiguration` longtext,
  PRIMARY KEY (`itemId`),
  KEY `transactionId` (`transactionId`),
  KEY `vendorId` (`vendorId`)
) TYPE=MyISAM;
CREATE TABLE `userInvitations` (
  `inviteId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `dateSent` date DEFAULT NULL,
  `email` char(255) NOT NULL,
  `newUserId` char(22) binary DEFAULT NULL,
  `dateCreated` date DEFAULT NULL,
  PRIMARY KEY (`inviteId`)
) TYPE=MyISAM;
CREATE TABLE `userLoginLog` (
  `userId` char(22) binary NOT NULL,
  `status` char(30) DEFAULT NULL,
  `timeStamp` int(11) DEFAULT NULL,
  `ipAddress` char(128) DEFAULT NULL,
  `userAgent` text,
  `sessionId` char(22) binary DEFAULT NULL,
  `lastPageViewed` int(11) DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `userProfileCategory` (
  `profileCategoryId` char(22) binary NOT NULL,
  `label` char(255) NOT NULL DEFAULT 'Undefined',
  `shortLabel` char(255) DEFAULT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `visible` int(11) NOT NULL DEFAULT '1',
  `editable` int(11) NOT NULL DEFAULT '1',
  `protected` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`profileCategoryId`)
) TYPE=MyISAM;
CREATE TABLE `userProfileData` (
  `userId` char(22) binary NOT NULL,
  `email` char(255) DEFAULT NULL,
  `firstName` char(255) DEFAULT NULL,
  `middleName` char(255) DEFAULT NULL,
  `lastName` char(255) DEFAULT NULL,
  `icq` char(255) DEFAULT NULL,
  `aim` char(255) DEFAULT NULL,
  `msnIM` char(255) DEFAULT NULL,
  `yahooIM` char(255) DEFAULT NULL,
  `cellPhone` char(255) DEFAULT NULL,
  `pager` char(255) DEFAULT NULL,
  `emailToPager` char(255) DEFAULT NULL,
  `language` char(255) DEFAULT NULL,
  `homeAddress` char(255) DEFAULT NULL,
  `homeCity` char(255) DEFAULT NULL,
  `homeState` char(255) DEFAULT NULL,
  `homeZip` char(255) DEFAULT NULL,
  `homeCountry` char(255) DEFAULT NULL,
  `homePhone` char(255) DEFAULT NULL,
  `workAddress` char(255) DEFAULT NULL,
  `workCity` char(255) DEFAULT NULL,
  `workState` char(255) DEFAULT NULL,
  `workZip` char(255) DEFAULT NULL,
  `workCountry` char(255) DEFAULT NULL,
  `workPhone` char(255) DEFAULT NULL,
  `gender` char(255) DEFAULT NULL,
  `birthdate` bigint(20) DEFAULT NULL,
  `homeURL` char(255) DEFAULT NULL,
  `workURL` char(255) DEFAULT NULL,
  `workName` char(255) DEFAULT NULL,
  `timeZone` char(255) DEFAULT NULL,
  `dateFormat` char(255) DEFAULT NULL,
  `timeFormat` char(255) DEFAULT NULL,
  `discussionLayout` char(255) DEFAULT NULL,
  `firstDayOfWeek` char(255) DEFAULT NULL,
  `uiLevel` char(255) DEFAULT NULL,
  `alias` char(255) DEFAULT NULL,
  `signature` longtext,
  `publicProfile` longtext,
  `toolbar` char(255) DEFAULT NULL,
  `photo` char(22) binary DEFAULT NULL,
  `avatar` char(22) binary DEFAULT NULL,
  `department` char(255) DEFAULT NULL,
  `allowPrivateMessages` longtext,
  `ableToBeFriend` tinyint(4) DEFAULT NULL,
  `showMessageOnLoginSeen` bigint(20) DEFAULT NULL,
  `showOnline` tinyint(1) DEFAULT NULL,
  `versionTagMode` char(255) DEFAULT NULL,
  `wg_privacySettings` longtext,
  `receiveInboxEmailNotifications` tinyint(1) DEFAULT NULL,
  `receiveInboxSmsNotifications` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`userId`)
) TYPE=MyISAM;
CREATE TABLE `userProfileField` (
  `fieldName` char(128) NOT NULL,
  `label` char(255) NOT NULL DEFAULT 'Undefined',
  `visible` int(11) NOT NULL DEFAULT '0',
  `required` int(11) NOT NULL DEFAULT '0',
  `fieldType` char(128) NOT NULL DEFAULT 'text',
  `possibleValues` text,
  `dataDefault` text,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `profileCategoryId` char(22) binary NOT NULL,
  `protected` int(11) NOT NULL DEFAULT '0',
  `editable` int(11) NOT NULL DEFAULT '1',
  `forceImageOnly` int(11) DEFAULT '1',
  `showAtRegistration` int(11) NOT NULL DEFAULT '0',
  `requiredForPasswordRecovery` int(11) NOT NULL DEFAULT '0',
  `extras` text,
  `defaultPrivacySetting` char(128) DEFAULT NULL,
  PRIMARY KEY (`fieldName`)
) TYPE=MyISAM;
CREATE TABLE `userSession` (
  `sessionId` char(22) binary NOT NULL,
  `expires` int(11) DEFAULT NULL,
  `lastPageView` int(11) DEFAULT NULL,
  `adminOn` int(11) NOT NULL DEFAULT '0',
  `lastIP` char(50) DEFAULT NULL,
  `userId` char(22) binary NOT NULL,
  PRIMARY KEY (`sessionId`),
  KEY `expires` (`expires`)
) TYPE=MyISAM;
CREATE TABLE `userSessionScratch` (
  `sessionId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`sessionId`,`name`)
) TYPE=MyISAM;
CREATE TABLE `users` (
  `userId` char(22) binary NOT NULL,
  `username` char(100) DEFAULT NULL,
  `authMethod` char(30) NOT NULL DEFAULT 'WebGUI',
  `dateCreated` int(11) NOT NULL DEFAULT '1019867418',
  `lastUpdated` int(11) NOT NULL DEFAULT '1019867418',
  `karma` int(11) NOT NULL DEFAULT '0',
  `status` char(35) NOT NULL DEFAULT 'Active',
  `referringAffiliate` char(22) binary NOT NULL,
  `friendsGroup` char(22) binary NOT NULL,
  PRIMARY KEY (`userId`),
  UNIQUE KEY `username_unique` (`username`)
) TYPE=MyISAM;
CREATE TABLE `vendor` (
  `vendorId` char(22) binary NOT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `name` char(255) DEFAULT NULL,
  `userId` char(22) binary NOT NULL DEFAULT '3',
  `preferredPaymentType` char(255) DEFAULT NULL,
  `paymentInformation` text,
  `paymentAddressId` char(22) binary DEFAULT NULL,
  `url` text,
  PRIMARY KEY (`vendorId`),
  KEY `userId` (`userId`)
) TYPE=MyISAM;
CREATE TABLE `webguiVersion` (
  `webguiVersion` char(10) DEFAULT NULL,
  `versionType` char(30) DEFAULT NULL,
  `dateApplied` int(11) DEFAULT NULL
) TYPE=MyISAM;
CREATE TABLE `wobject` (
  `displayTitle` int(11) NOT NULL DEFAULT '1',
  `description` mediumtext,
  `assetId` char(22) binary NOT NULL,
  `styleTemplateId` char(22) binary NOT NULL,
  `printableStyleTemplateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `mobileStyleTemplateId` char(22) binary DEFAULT 'PBtmpl0000000000000060',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM;
ALTER TABLE `Article` DISABLE KEYS;
INSERT INTO `Article` VALUES (NULL,NULL,'NK8bqlwVRILJknqeCDPBHg','PBtmpl0000000000000002',1147642515,3600,'0jTuDoyTcQK6ju8cs8a4ew'),(NULL,NULL,'bX5rYxb6tZ9docY6sUhBlw','PBtmpl0000000000000002',1147642514,3600,'r3QdZwvuVK9o9kLb7mpHGQ'),(NULL,NULL,'OhdaFLE7sXOzo_SIP2ZUgA','PBtmpl0000000000000002',1147642513,3600,'GY5wyiuNmZZyLdgFt3zluQ'),(NULL,NULL,'IWFxZDyGhQ3-SLZhELa3qw','PBtmpl0000000000000002',1147642514,3600,'BS9OtDY_8oUnmzStD-wPmg'),(NULL,NULL,'6QuS-0rosuZTdTv11fobig','PBtmpl0000000000000002',1147642515,3600,'qDIYM6Jcmkk_LmWZIqqJ7w'),(NULL,NULL,'ix1p0AbwKAz8QWB-T-HHfg','PBtmpl0000000000000002',1147642516,3600,'gU8kZk0nV6SqcwKqSiojQQ'),(NULL,NULL,'4Yfz9hqBqM8OYMGuQK8oLw','PBtmpl0000000000000002',1147642516,3600,'x4_4U_yb-MAGELG0jxAqpQ'),(NULL,NULL,'LBuiKzg2mWwmOPS9AgV3bg','PBtmpl0000000000000002',1147642517,3600,'UYaT3bhIk9HXmX1io5MdlQ'),(NULL,NULL,'jTNggl7AoVSUc_ZzrvuCmw','PBtmpl0000000000000002',1147642517,3600,'NWhmkoojuu9dA4_zv3a4pg'),(NULL,'http://','j_1qEqM6iLfQLiR6VKy0aA','PBtmpl0000000000000002',1215718151,3600,'2k_h890E0bVoT1Jq6s-Edg'),(NULL,'http://','diZvW4bSgZWwyyGP3qXi1g','PBtmpl0000000000000002',1215717972,3600,'kjLi5s-xRSCL63HfE8ArtA'),(NULL,NULL,'FOvmwGC0GtZo5VTxJIL3OA','PBtmpl0000000000000103',1247779862,3600,'EBxIv4lhFPtYw-pPtiBqmg'),(NULL,NULL,'Wl8WZ43g2rK5AYr9o4zY7w','PBtmpl0000000000000103',1247779880,3600,'x1ypCI9yBd2SYyeWNWGiag'),(NULL,NULL,'iCYOjohB9SKvAPr6bXElKA','PBtmpl0000000000000103',1247779898,3600,'TlE3LEEoLsOLiuTpAnxxUw');
ALTER TABLE `Article` ENABLE KEYS;
ALTER TABLE `Collaboration` DISABLE KEYS;
INSERT INTO `Collaboration` VALUES ('pbproto000000000000002','2','2',0,'PBtmpl0000000000000208','PBtmpl0000000000000209','PBtmpl0000000000000210','','','assetData.revisionDate','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,2592000,10,30,NULL,1,0,'PBrichedit000000000002',0,0,1163019036,0,'pbworkflow000000000003','pbworkflow000000000003',100,NULL,NULL,NULL,NULL,NULL,0,300,'NpRVTSR-NX2sD52LUc520A',3600,1,1,0,0,0,0,'12',1,'default_post_received1','PBrichedit000000000002','javascript');
ALTER TABLE `Collaboration` ENABLE KEYS;
ALTER TABLE `DataForm` DISABLE KEYS;
INSERT INTO `DataForm` VALUES ('Thank you for telling your friends about WebGUI!',1,'PBtmpl0000000000000085','PBtmpl0000000000000104','PBtmpl0000000000000021','Szs5eev3OMssmnsyLRZmWA','PBtmpl0000000000000020',0,1213317790,'7',0,0,1,'[{\"width\":\"0\",\"options\":\"\",\"status\":\"required\",\"tabId\":null,\"name\":\"from\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"Your Email Address\",\"type\":\"Email\",\"defaultValue\":\"\"},{\"width\":\"0\",\"options\":\"\",\"status\":\"required\",\"tabId\":null,\"name\":\"to\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"Your Friends Email Address\",\"type\":\"Email\",\"defaultValue\":\"\"},{\"width\":\"0\",\"options\":null,\"status\":\"hidden\",\"tabId\":null,\"name\":\"cc\",\"rows\":null,\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":null,\"label\":\"Cc\",\"type\":\"Email\",\"defaultValue\":null},{\"width\":\"0\",\"options\":null,\"status\":\"hidden\",\"tabId\":null,\"name\":\"bcc\",\"rows\":null,\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":null,\"label\":\"Bcc\",\"type\":\"Email\",\"defaultValue\":null},{\"width\":\"0\",\"options\":\"\",\"status\":\"hidden\",\"tabId\":null,\"name\":\"subject\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"Subject\",\"type\":\"Text\",\"defaultValue\":\"Cool CMS\"},{\"width\":\"0\",\"options\":\"\",\"status\":\"visible\",\"tabId\":null,\"name\":\"url\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"URL\",\"type\":\"Url\",\"defaultValue\":\"http://www.webgui.org\"},{\"width\":\"300\",\"options\":\"\",\"status\":\"required\",\"tabId\":null,\"name\":\"message\",\"rows\":\"100\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"0\",\"subtext\":\"\",\"label\":\"Message\",\"type\":\"Textarea\",\"defaultValue\":\"Hey I just wanted to tell you about this great program called WebGUI that I found: http://www.webgui.org\\r\\n\\r\\nYou should really check it out.\"}]','[]',NULL,'**Use_Default_Editor**');
ALTER TABLE `DataForm` ENABLE KEYS;
ALTER TABLE `FileAsset` DISABLE KEYS;
INSERT INTO `FileAsset` VALUES ('7-0-style0000000000002','_Vo1Pvl3sPPANyxz-IcCtA','body_bg.jpg','PBtmpl0000000000000088',1147642492,3600),('7-0-style0000000000004','Gemp7cEVjh2_M2IicUYs-g','gui_bottom.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000005','ry-yzLVH-vxn71H9byjGXA','header.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000006','VEPa65fhY3dok6vj-beFCA','main_bg.gif','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000007','Cfay1MNkC-73WKJ7fX_pVw','main_bg.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000008','iEBE--vQb_lxuZd5AP8tuw','nav1_center_on.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000009','XR1Yjf3MkYA53TJlcpRBsw','nav1_off.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000010','sxvAS8na-QAdY_eycd2gKw','nav1_off_center.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000011','2lhmrXW46ZMLvpbaaX2g7Q','nav1_off_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000012','sEoRwhmonl877RBgx2nE1w','nav1_off_right.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000013','AoSfRkPI3fl7vAooT4Fj_A','nav1_on.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000014','MgNDJRsghd_zQZ292hqVMQ','nav1_on_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000015','aUG1FZaIqHaQHlieZ4_Mkg','nav1_on_right.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000016','HyhLnkaJMfr8eJsLIX8XeA','nav2_center_on.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000017','aledEnWoD-JVNURWSklfdg','nav2_off_center.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000018','Ffd33PToWon9X7mcKZqUAQ','nav2_off_left.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000019','B3TTkcOlr-VzcxRwQXZmyg','nav2_off_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000020','RxGSyn-8W4p64SQ-NYzNOg','nav2_on_left.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000021','NciEByP8ssN6qDYyKcoGWw','nav2_on_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000022','9OVg_Nxo0gha5pWZsS_dmw','nav_bg.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000023','VKtJGCmBtsMj8ZeAJ6ePNw','nav_on.jpg','PBtmpl0000000000000088',1147642498,3600),('7-0-style0000000000024','ryQb0A4YeEwYZo9hdgrCcw','orange_left01.jpg','PBtmpl0000000000000088',1147642498,3600),('7-0-style0000000000030','coew3C1i9AORof9ezjWLDg','webgui_btn.jpg','PBtmpl0000000000000088',1147642499,3600),('7-0-style0000000000032','HEySmh0CRxpkI-tjzgkDDw','context_bg.jpg','PBtmpl0000000000000088',1147642500,3600),('7-0-style0000000000034','HPn3mVDaMkn8Iu0GAq7cAw','leftCol_header.jpg','PBtmpl0000000000000088',1147642500,3600),('7-0-style0000000000035','IqaSdxJqqN_8C-7OWeyE2g','leftCol_header02.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000036','M0cIcS1GDFIV8lwAw3U2hA','main_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000037','77rakTqCXGBihEOXoh4ZXQ','nav_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000038','5najYvfJiZBBaiCVxaNkcQ','navbar_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000039','27XAOBKNfJ2euexImD73Aw','navbar_left.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000040','sgd1YdmVKj-n6IyIWJicXg','navbar_right.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000041','i1oJph6lb3hxEsTNu_3Y7g','page_title.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000042','qMwO_tp9KOya_N-kyIHDJQ','page_title_bg.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000043','l5hF84u5R9MoqMvS9gpp6g','pb.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000044','Eh4IRmClOEzDAU1IVn5vHQ','pb_wg.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000045','e8yirsGt9FZEgzfeHLgRiw','pb_wg_bg.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000046','hDmN6gu1w_jtrcxgTRN5OQ','rightCol_bg.jpg','PBtmpl0000000000000088',1147642504,3600),('7-0-style0000000000048','_QhSdbnBeA1zio6iAuGIag','wg.jpg','PBtmpl0000000000000088',1147642504,3600),('7-0-style0000000000052','VRqMCZ_-GgaJiDeOrnwlQg','footer_bg.jpg','PBtmpl0000000000000088',1147642505,3600),('7-0-style0000000000053','baxoDEB4C8eLjZbnENMs9w','footer_right.jpg','PBtmpl0000000000000088',1147642505,3600),('7-0-style0000000000054','FlivcrAW0pKW4q_2fvlVpw','header_bg.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000055','5hgdAMRWeSmHDrRFM_qbBw','header_left.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000056','lV6l3Sctxx8J1JmYlXwSDA','header_right.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000057','FKGH2yiNQoC2E_FqbMYebw','main_bg.jpg','PBtmpl0000000000000088',1147642507,3600),('7-0-style0000000000058','UGtgwjDaqCtCPnEkuLPtIw','main_bottom.jpg','PBtmpl0000000000000088',1147642507,3600),('7-0-style0000000000060','XsuCCMz5vyyfC8Xr89pb1Q','main_top_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000061','is_6p2ROuy6AhCR1eJ8SdQ','nav_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000062','3rpFbJWSV14AWeDZqqPSSw','nav_bg1.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000063','NcTFm_t9rn63ejwtBQnDQw','nav_bg1_on.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000064','XLKBWi6Asbz5CtZdnwzZmg','nav_bg2.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000065','02cdKPH5-SyFEb_Zo_WL8A','nav_bg2_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000066','0QQpTB8bi6JZvFrW74SOWg','nav_bg_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000067','DdhQHfqGq-yC1ukTdlqoEg','pb.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000068','Y4AWquISZVLcwVQLzd_u7w','spacer.gif','PBtmpl0000000000000088',1147642510,3600),('7-0-style0000000000071','mJOrQFemh2R3xn2HYviQlQ','wg.jpg','PBtmpl0000000000000088',1147642511,3600),('m4YJFaqzultnB_sj1Uq0aw','JX9y6tHiSaAv3-Jq6QXHGw','advert01.swf','pbtmpl0000000000000220',1147642514,3600),('Vzv1pWpg_w6R_o-b0rM2qQ','PMKX5QYkNFvrCD15QVo8Tg','Tutorial.swf','pbtmpl0000000000000221',1147642515,3600),('bANo8aiAPA7aY_oQZKxIWw','l0vJttSGYiITS96pOJIh2Q','rss.gif','PBtmpl0000000000000088',1197330678,0),('fdd8tGExyVwHyrB8RBbKXg','H8qvtaTvDkNHOm-h0yfpAg','next.gif','PBtmpl0000000000000088',1197330839,0),('BpisgHl4ZDcSECJp6oib1w','B3fjChKsXh4QFgvs1Gf4BQ','play.gif','PBtmpl0000000000000088',1197330840,0),('zshreRgPAXtnF0DtVbQ1Yg','tYxidtXD9bXmPkEZsinI-A','previous.gif','PBtmpl0000000000000088',1197330840,0),('2ci_v2d4x4uvyjTRlC49OA','QBcmUnAdUKoMQoP9OxDdqA','moveDown.gif','PBtmpl0000000000000088',1209499188,0),('O-EsSzKgAk1KolFT-x_KsA','g8rvEQyyvxfs0sNklPNzsQ','moveUp.gif','PBtmpl0000000000000088',1209499188,0),('POVcY79vIqAHR8OfGt36aw','NGu3NiVKD4TV1Sw4N5YmIg','pagination_button.jpg','PBtmpl0000000000000088',1209499189,0),('hIB-z34r8Xl-vYVYCkKr-w','i1uZztdNddqvW9Tt_JOBzw','bar-btn-r.jpg','PBtmpl0000000000000088',1209499189,0),('-mPUoFlYcjqjPUPRLAlxNQ','X7PA2VUynp_X5b1mHRqvnA','search-field-r.jpg','PBtmpl0000000000000088',1209499189,0),('MDpUOR-N8KMyt1J7Hh_h4w','ed1kbQ8Aed2Uh09gIo5HTQ','bar-btn.jpg','PBtmpl0000000000000088',1209499189,0),('YfXKByTwDZVituMc4h13Dg','SMhIjHLxVLJSjOsSvbLcMA','pagination_bg.jpg','PBtmpl0000000000000088',1209499189,0),('esko_HSU0Gh-uJZ1h3xRmQ','av317NZvdb5ATKy1BctVyg','search-field-l.jpg','PBtmpl0000000000000088',1209499189,0),('oSqpGswzpBG_ErdfYwIO8A','gyukfQn4q_CoHrieNClI3A','top_bg.jpg','PBtmpl0000000000000088',1209499189,0),('MXJklShZvLLB_DSnZQmXrQ','fEBf-KYzxE-cPJYrKkpyHg','title_bg.jpg','PBtmpl0000000000000088',1209499189,0),('BthxD5oJ0idmsyI3ioA2FA','ZzZWC22vEsrgqSbNABaiSw','bar-btn-l.jpg','PBtmpl0000000000000088',1209499189,0),('aZ-1HYQamkRHYXvzAra8WQ','--qeq91xu4bPCfTNHQTN6g','search-field.jpg','PBtmpl0000000000000088',1209499189,0),('eRkb94OYcS5AdcrrerOP5Q','VTYx-kkmpTSFtdKzX9FRcw','rss.gif','PBtmpl0000000000000088',1209499189,0),('TbnkjAJQEASORXIpYqDkcA','rysPVifAyGtsgqtkgS6RTw','blank-image.jpg','PBtmpl0000000000000088',1209499189,0),('er-3faBjY-hhlDcc5aKqdQ','AGRuD_tUqpjUhixhisn8rA','top_bg.jpg','PBtmpl0000000000000088',1209499189,0),('8bFsu2FJUqHRUiHcozcVFw','KQJheWAz7PTd1Gl194tzcg','sub-btn-l.jpg','PBtmpl0000000000000088',1209499189,0),('34Aayx5eA320D8VfhdfDBw','qx70ceBPO3mE5H_ZqhHa3A','sub-btn-r.jpg','PBtmpl0000000000000088',1209499189,0),('TlhKOVmWblZOsAdqmhEpeg','q9zSV7MQt6cwmXLWqoRCHQ','sub-btn.jpg','PBtmpl0000000000000088',1209499189,0),('Nx0ypjO3cN6QdZUBUEE0lA','UX3aGyzXzStKrn0BME9eSQ','pic-title-bg.jpg','PBtmpl0000000000000088',1209499189,0),('CmFZLN7iPS7XXvUEsxKPKA','3rRxsOMTV6hkG8TCywAxQg','row-2.jpg','PBtmpl0000000000000088',1209499190,0),('v_XBgwwZqgW1D5s4y05qfg','SHaZ0680E30gPydYkaxPPQ','addtl-info.gif','PBtmpl0000000000000088',1209499190,0),('4TdAkKoQbSCvI7QWcW889A','JsG1nDZj8IB7zdaEpqxljQ','row-1.jpg','PBtmpl0000000000000088',1209499190,0),('SAgK6eDPCG1cgkJ59WapHQ','blLNHs44P_vzBevRm3EKVg','prev-btn.gif','PBtmpl0000000000000088',1209499190,0),('XJYLuvGy9ubF7JNKyINtpA','7Fb1GdqH0E_1Or-ltSpW5Q','play-btn.gif','PBtmpl0000000000000088',1209499190,0),('RWj7hyv2SpZuXxwj1Wocug','WPuDj1dkyhluxUfsNHnPhg','next-btn.gif','PBtmpl0000000000000088',1209499190,0),('aq8QElnlm3YufAoxRz9Pcg','sDgpNdN1VdgPUQS6h57gVw','data-bg.jpg','PBtmpl0000000000000088',1209499190,0),('_bZJ9LA_KNekZiFPaP2SeQ','RwcPC6VO-WH3HPaMNxQdxQ','shelf-titles.jpg','PBtmpl0000000000000088',1210777868,0),('hQ7z33_jOYkQ8WNX5xy9Sw','HCc0_yDJrhZIoKV__wiUDw','style-button.gif','PBtmpl0000000000000088',1209509455,0),('vWW_DcHiYSrKZOkkIfEfcQ','t_FrH8_ktSJtHQGQLDeudA','row-2.jpg','PBtmpl0000000000000088',1209509433,0),('_bPYzRA87NTAUIKlfrJMHg','EgZoQgSAhCrNP3sXjRDPkw','row-1.jpg','PBtmpl0000000000000088',1209509433,0),('nJjZHRwdDs5MAZYsAyioHw','edb4FERsJ0pU0mmnfsiCig','title-bg.jpg','PBtmpl0000000000000088',1209509433,0),('8hxfkrJPeFVRWF5piCNJ1A','hRM4w6S2cqFdDRPcUP6FIg','field-bg.jpg','PBtmpl0000000000000088',1209509433,0),('Osx7WN52iIKHZFT4vqUBHQ','Wa42mXdBWCT9B9kgqzh9CQ','search-btn.gif','PBtmpl0000000000000088',1209509433,0),('oWff8fGzRdHPyq5VNREe9Q','j-AYUZHpCRd0yYH2Youp4A','top-bg.jpg','PBtmpl0000000000000088',1209509433,0),('uqbkvb1b9443VvfkyRz95w','JXBzB0XDxTHC_KRk0jROGQ','save-button.gif','PBtmpl0000000000000088',1209509433,0),('8YiMkcz32xalkAn3WBLpag','3lttrXIB4qCFnsKxFTJoKw','go-btn.gif','PBtmpl0000000000000088',1210181860,0),('2q5fxatSFLgIhXaUX-oSvg','j5rX358i5J9yPV4DoEHwxg','bottom-left.jpg','PBtmpl0000000000000088',1204149033,0),('_d5WTkKjnwct-_Dk7gZHvQ','tpvHAIwy2uRbYM8spLAfVA','bottom-right.jpg','PBtmpl0000000000000088',1204149033,0),('Iz2mUR3jCPKyemwAea4b2g','7wvz-X76oSFQc4y88amMIA','input_bg.jpg','PBtmpl0000000000000088',1204149033,0),('JU9bjsLRoWj7GVHs__prig','hT-SRTK5QszwKt9YV7bSDg','top-left.jpg','PBtmpl0000000000000088',1204149033,0),('noOlnjQGexHg8c4bGVUo9g','itESNdKblVlX-kLwnt3qVw','top-right.jpg','PBtmpl0000000000000088',1204149033,0),('7-0-style0000000000059','QOhEl8bdecbSrml06V84iw','main_top.jpg','PBtmpl0000000000000088',1213386091,0),('o_pq_e4vRyhMOKFzs61eag','zTRhj1ZmjPc6b4ytLNIdLg','book-covers.jpg','PBtmpl0000000000000088',1215714957,0),('hBpisL-_URyZnh9clR5ohA','IYUoN4EWQWHZHQj-f5ex0g','no_photo.gif','PBtmpl0000000000000088',1227634417,0),('FOBV6KkifreXa4GmEAUU4A','69Zh__B-EI01IWjf9KBDrw','no_photo_sm.gif','PBtmpl0000000000000088',1227634447,0);
ALTER TABLE `FileAsset` ENABLE KEYS;
ALTER TABLE `Folder` DISABLE KEYS;
INSERT INTO `Folder` VALUES ('PBasset000000000000002','PBtmpl0000000000000078',1124395696,3600,0,'ASC'),('7-0-style0000000000001','PBtmpl0000000000000078',1147642492,3600,0,'ASC'),('7-0-style0000000000031','PBtmpl0000000000000078',1147642500,3600,0,'ASC'),('PBasset000000000000003','PBtmpl0000000000000078',1147642437,3600,0,'ASC'),('nbSrhXZQuxIjhWFaFPSuVA','PBtmpl0000000000000078',1147642465,3600,0,'ASC'),('S1A9iAwKcQQ6P20uTqw-Ew','PBtmpl0000000000000078',1147642468,3600,0,'ASC'),('N13SD1Fpqk00UgBt1Z8ivQ','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('-WM2dt0ZGpDasuL2wWocxg','PBtmpl0000000000000078',1222803056,3600,0,'ASC'),('3uuBf8cYuj1sew2OJXl9tg','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('2OcUWHVsu_L1sDFzIMWYqw','PBtmpl0000000000000078',1222803070,3600,0,'ASC'),('cj2y4papTVGZRFdwTI-_fw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('bBzO4CWjqU_ile3gf5Iypw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('jEz8iTGNWEt2I05IhVV19Q','PBtmpl0000000000000078',1147642477,3600,0,'ASC'),('Da6KWn805L4B5e4HFgQRQA','PBtmpl0000000000000078',1147642479,3600,0,'ASC'),('bbiA9Zq5Gy2oCFBlILO3QA','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('Efe2W0UgrSRDltNJ87jlfg','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('RrV4aAPnn4dM0ZcU3OXnlw','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('9wKWdum0_8z-OhhquWLtSQ','PBtmpl0000000000000078',1147642483,3600,0,'ASC'),('CSN-ZON7Uwv8kxf3F1fh5Q','PBtmpl0000000000000078',1147642484,3600,0,'ASC'),('TCtybxdqmdwdvRn555zpCQ','PBtmpl0000000000000078',1147642484,3600,0,'ASC'),('tempspace0000000000000','PBtmpl0000000000000078',1185754574,3600,0,'ASC'),('Tsg7xmPYv782j6IVz7yHFg','PBtmpl0000000000000078',1213244777,3600,0,'ASC'),('4qh0kIsFUdd4Ox-Iu1JZgg','PBtmpl0000000000000078',1208725439,3600,0,'ASC'),('TYo2Bwl7aafzTtdHlS-arQ','PBtmpl0000000000000078',1211664878,3600,0,'ASC'),('6tK47xsaIH-ELw0IBo0uRQ','PBtmpl0000000000000078',1210777115,3600,0,'ASC'),('gbnRhcWNk1iQe32LFEB5eQ','PBtmpl0000000000000078',1212086102,3600,0,'ASC'),('6D4Z-oruXPS6OlH_Kx8pBg','PBtmpl0000000000000078',1209509389,3600,0,'ASC'),('C5fPz-Wg85vkYRvCdl-Xqw','PBtmpl0000000000000078',1212160830,3600,0,'ASC'),('aNmgn0cd6tldmC1FpW4KbA','PBtmpl0000000000000078',1213122695,3600,0,'ASC'),('gI_TxK-5S4DNuv42wpImmw','PBtmpl0000000000000078',1213734379,3600,0,'ASC'),('jnYdqDkUR8x7Pv2eGR1qTA','PBtmpl0000000000000078',1216250666,3600,0,'ASC'),('1z9J1O08n_7gVVlBwSRBJQ','PBtmpl0000000000000078',1222803099,3600,0,'ASC'),('zyWi26q9na-iiZqL4yedog','PBtmpl0000000000000078',1222803114,3600,0,'ASC'),('tBL7BWiQRZFed2Y-Zjo9tQ','PBtmpl0000000000000078',1222803200,3600,0,'ASC'),('GdkQpvjRtJqtzOUbwIIQRA','PBtmpl0000000000000078',1222803205,3600,0,'ASC'),('tnc5iYyynX2hfdEs9D3P8w','PBtmpl0000000000000078',1222803213,3600,0,'ASC'),('vgXdBcFTqU7h4wBG1ewdBw','PBtmpl0000000000000078',1222803217,3600,0,'ASC'),('hcFlqnXlsmC1ujN6Id0F0A','PBtmpl0000000000000078',1222803234,3600,0,'ASC'),('eRJR52fvlaxfetv3DQkQYw','PBtmpl0000000000000078',1222803238,3600,0,'ASC'),('5HIDHq5lAWHV5gpYGS0zLg','PBtmpl0000000000000078',1222803244,3600,0,'ASC'),('rYEFwXXo0tkGhQTcbDibvg','PBtmpl0000000000000078',1222803249,3600,0,'ASC'),('V3l5S5TtI7wMm1WpIMhvOA','PBtmpl0000000000000078',1222803253,3600,0,'ASC'),('nqNbSUAhk9Vd1zda2SCz9A','PBtmpl0000000000000078',1222803258,3600,0,'ASC'),('y8XkRdxIperLKkJ3bL5sSQ','PBtmpl0000000000000078',1222803264,3600,0,'ASC'),('vTymIDYL2YqEh6PV50F7ew','PBtmpl0000000000000078',1222803302,3600,0,'ASC'),('lo1ac3BsoJx3ijGQ3gR-bQ','PBtmpl0000000000000078',1222803309,3600,0,'ASC'),('huASapWvFDzqwOSbcN-JFQ','PBtmpl0000000000000078',1222803313,3600,0,'ASC'),('9A-mg2gwWmaYi9o_1C7ArQ','PBtmpl0000000000000078',1222803338,3600,0,'ASC'),('yD1SMHelczihzjEmx6eXBA','PBtmpl0000000000000078',1222803342,3600,0,'ASC'),('pV7GnZdpjR3XpZaSINIoeg','PBtmpl0000000000000078',1222803347,3600,0,'ASC'),('71e17KeduiXgODLMlUxiow','PBtmpl0000000000000078',1222803352,3600,0,'ASC'),('xSmREZO3GNzK3M5PaueOOQ','PBtmpl0000000000000078',1222803378,3600,0,'ASC'),('0bx-xoL8TSXXubFuqKAoVQ','PBtmpl0000000000000078',1222803383,3600,0,'ASC'),('taX2UYkFF21ALpFZY2rhMw','PBtmpl0000000000000078',1222803387,3600,0,'ASC'),('K0q_N885Httqev1VCqUWxg','PBtmpl0000000000000078',1222803391,3600,0,'ASC'),('fq1ZkYhH24R5tb96kuT10Q','PBtmpl0000000000000078',1222803395,3600,0,'ASC'),('oHk7fAFhEEkB7dHzi0QOQA','PBtmpl0000000000000078',1222803399,3600,0,'ASC'),('9M-lrlPQWeeNWfvnDnK_Xg','PBtmpl0000000000000078',1222803405,3600,0,'ASC'),('_gBYAdTcbkiyamnqi2Xskg','PBtmpl0000000000000078',1222803409,3600,0,'ASC'),('Ik9HHky10DIyFTKehUD1dw','PBtmpl0000000000000078',1222803478,3600,0,'ASC'),('NywJYmGWe1f6EBXJnWg9Xg','PBtmpl0000000000000078',1222803638,3600,0,'ASC'),('AgyFhx3eXlfZXNp2MkrsiQ','PBtmpl0000000000000078',1222803665,3600,0,'ASC'),('F7MAQ-cpuvQ1KuC7J4P5zQ','PBtmpl0000000000000078',1222803673,3600,0,'ASC'),('Q4uX_C557arTp6D_jwB1jQ','PBtmpl0000000000000078',1222803760,3600,0,'ASC'),('BmLaN4rmAANkCglXUViEbg','PBtmpl0000000000000078',1222803871,3600,0,'ASC'),('X7DrzUcj8pOKFa_6k9D5iw','PBtmpl0000000000000078',1222804045,3600,0,'ASC'),('UL-ItI4L1Z6-WSuhuXVvsQ','PBtmpl0000000000000078',1225139673,3600,0,'ASC'),('7-0-style0000000000049','PBtmpl0000000000000078',1224117144,3600,0,'ASC'),('QpmlAiYZz6VsKBM-_0wXaw','PBtmpl0000000000000078',1224616691,3600,0,'ASC'),('HPDOcsj4gBme8D4svHodBw','PBtmpl0000000000000078',1225404573,3600,0,'ASC'),('IZkrow_zwvbf4FCH-taVTQ','PBtmpl0000000000000078',1226011853,3600,0,'ASC'),('K0YjxqOqr7RupSo6sIdcAg','PBtmpl0000000000000078',1227074310,3600,0,'ASC'),('_ilRXNR3s8F2vGJ_k9ePcg','PBtmpl0000000000000078',1226643205,3600,0,'ASC'),('qaVcU0FFzzraMX_bzELqzw','PBtmpl0000000000000078',1227074362,3600,0,'ASC'),('LdiozcIUciWuvt3Z-na5Ww','PBtmpl0000000000000078',1232673968,3600,0,'ASC'),('QHn6T9rU7KsnS3Y70KCNTg','PBtmpl0000000000000078',1233173545,3600,0,'ASC'),('HW-sPoDDZR8wBZ0YgFgPtg','PBtmpl0000000000000078',1227634350,3600,0,'ASC'),('AOjPG2NHgfL9Cq6dDJ7mew','PBtmpl0000000000000078',1236960881,3600,0,'ASC'),('TvOZs8U1kRXLtwtmyW75pg','PBtmpl0000000000000078',1255485472,3600,0,'ASC'),('jmlI9IK-lV8n2WMYmmPhAA','PBtmpl0000000000000078',1238106173,3600,0,'ASC'),('6uvSLY-ak_w4p_wS8q33cA','PBtmpl0000000000000078',1239213092,3600,0,'ASC'),('GaBAW-2iVhLMJaZQzVLE5A','PBtmpl0000000000000078',1240103565,3600,0,'ASC'),('lo1rpxn3t8YPyKGers5eQg','PBtmpl0000000000000078',1238625621,3600,0,'ASC'),('aNNC62qLAS6TB-0_MCYjsw','PBtmpl0000000000000078',1246969327,3600,0,'ASC'),('BFfNj5wA9bDw8H3cnr8pTw','PBtmpl0000000000000078',1247046273,3600,0,'ASC'),('f_tn9FfoSfKWX43F83v_3w','PBtmpl0000000000000078',1247053009,3600,0,'ASC'),('oGfxez5sksyB_PcaAsEm_Q','PBtmpl0000000000000078',1247053097,3600,0,'ASC'),('tPagC0AQErZXjLFZQ6OI1g','PBtmpl0000000000000078',1246966459,3600,0,'ASC'),('GYaFxnMu9UsEG8oanwB6TA','PBtmpl0000000000000078',1246965871,3600,0,'ASC'),('VZK3CRgiMb8r4dBjUmCTgQ','PBtmpl0000000000000078',1247046242,3600,0,'ASC'),('tXwf1zaOXTvsqPn6yu-GSw','PBtmpl0000000000000078',1246965607,3600,0,'ASC'),('kaPRSaf8UKiskiGEgJgLAw','PBtmpl0000000000000078',1250190850,3600,0,'ASC'),('brxm_faNdZX5tRo3p50g3g','PBtmpl0000000000000078',1250190850,3600,0,'ASC'),('5bnNzteN7w3NnK9mF4XiCg','PBtmpl0000000000000078',1250243000,3600,0,'ASC'),('RSAMkc6WQmfRE3TOr1_3Mw','PBtmpl0000000000000078',1250243000,3600,0,'ASC'),('fowHfgOkJtAxdst7rugTog','PBtmpl0000000000000078',1250243000,3600,0,'ASC'),('GNOAsX98vCsl0JRwfwL-gg','PBtmpl0000000000000078',1255485473,3600,0,'ASC'),('-K8Hj45mbelljN9-0CXZxg','PBtmpl0000000000000078',1256702482,3600,0,'ASC');
ALTER TABLE `Folder` ENABLE KEYS;
ALTER TABLE `ImageAsset` DISABLE KEYS;
INSERT INTO `ImageAsset` VALUES ('7-0-style0000000000002',50,NULL,1147642492,NULL),('7-0-style0000000000004',50,NULL,1147642493,NULL),('7-0-style0000000000005',50,NULL,1147642493,NULL),('7-0-style0000000000006',50,NULL,1147642493,NULL),('7-0-style0000000000007',50,NULL,1147642493,NULL),('7-0-style0000000000008',50,NULL,1147642494,NULL),('7-0-style0000000000009',50,NULL,1147642494,NULL),('7-0-style0000000000010',50,NULL,1147642494,NULL),('7-0-style0000000000011',50,NULL,1147642495,NULL),('7-0-style0000000000012',50,NULL,1147642495,NULL),('7-0-style0000000000013',50,NULL,1147642495,NULL),('7-0-style0000000000014',50,NULL,1147642495,NULL),('7-0-style0000000000015',50,NULL,1147642496,NULL),('7-0-style0000000000016',50,NULL,1147642496,NULL),('7-0-style0000000000017',50,NULL,1147642496,NULL),('7-0-style0000000000018',50,NULL,1147642496,NULL),('7-0-style0000000000019',50,NULL,1147642497,NULL),('7-0-style0000000000020',50,NULL,1147642497,NULL),('7-0-style0000000000021',50,NULL,1147642497,NULL),('7-0-style0000000000022',50,NULL,1147642497,NULL),('7-0-style0000000000023',50,NULL,1147642498,NULL),('7-0-style0000000000024',50,NULL,1147642498,NULL),('7-0-style0000000000030',50,NULL,1147642499,NULL),('7-0-style0000000000032',50,NULL,1147642500,NULL),('7-0-style0000000000034',50,NULL,1147642500,NULL),('7-0-style0000000000035',50,NULL,1147642501,NULL),('7-0-style0000000000036',50,NULL,1147642501,NULL),('7-0-style0000000000037',50,NULL,1147642501,NULL),('7-0-style0000000000038',50,NULL,1147642501,NULL),('7-0-style0000000000039',50,NULL,1147642502,NULL),('7-0-style0000000000040',50,NULL,1147642502,NULL),('7-0-style0000000000041',50,NULL,1147642502,NULL),('7-0-style0000000000042',50,NULL,1147642502,NULL),('7-0-style0000000000043',50,NULL,1147642503,NULL),('7-0-style0000000000044',50,NULL,1147642503,NULL),('7-0-style0000000000045',50,NULL,1147642503,NULL),('7-0-style0000000000046',50,NULL,1147642504,NULL),('7-0-style0000000000048',50,NULL,1147642504,NULL),('7-0-style0000000000052',50,'style=\"border-style:none;\"',1147642505,NULL),('7-0-style0000000000053',50,'style=\"border-style:none;\"',1147642505,NULL),('7-0-style0000000000054',50,'style=\"border-style:none;\"',1147642506,NULL),('7-0-style0000000000055',50,'style=\"border-style:none;\"',1147642506,NULL),('7-0-style0000000000056',50,'style=\"border-style:none;\"',1147642506,NULL),('7-0-style0000000000057',50,'style=\"border-style:none;\"',1147642507,NULL),('7-0-style0000000000058',50,'style=\"border-style:none;\"',1147642507,NULL),('7-0-style0000000000060',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000061',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000062',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000063',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000064',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000065',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000066',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000067',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000068',50,'style=\"border-style:none;\"',1147642510,NULL),('7-0-style0000000000071',50,'style=\"border-style:none;\"',1147642511,NULL),('bANo8aiAPA7aY_oQZKxIWw',50,'style=\"border-style:none;\" alt=\"rss.gif\"',1197330678,''),('fdd8tGExyVwHyrB8RBbKXg',50,'style=\"border-style:none;\" alt=\"next.gif\"',1197330839,''),('BpisgHl4ZDcSECJp6oib1w',50,'style=\"border-style:none;\" alt=\"play.gif\"',1197330840,''),('zshreRgPAXtnF0DtVbQ1Yg',50,'style=\"border-style:none;\" alt=\"previous.gif\"',1197330840,''),('2ci_v2d4x4uvyjTRlC49OA',50,'style=\"border-style:none;\" alt=\"moveDown.gif\"',1209499188,''),('O-EsSzKgAk1KolFT-x_KsA',50,'style=\"border-style:none;\" alt=\"moveUp.gif\"',1209499188,''),('POVcY79vIqAHR8OfGt36aw',50,'style=\"border-style:none;\" alt=\"pagination_button.jpg\"',1209499189,''),('hIB-z34r8Xl-vYVYCkKr-w',50,'style=\"border-style:none;\" alt=\"bar-btn-r.jpg\"',1209499189,''),('-mPUoFlYcjqjPUPRLAlxNQ',50,'style=\"border-style:none;\" alt=\"search-field-r.jpg\"',1209499189,''),('MDpUOR-N8KMyt1J7Hh_h4w',50,'style=\"border-style:none;\" alt=\"bar-btn.jpg\"',1209499189,''),('YfXKByTwDZVituMc4h13Dg',50,'style=\"border-style:none;\" alt=\"pagination_bg.jpg\"',1209499189,''),('esko_HSU0Gh-uJZ1h3xRmQ',50,'style=\"border-style:none;\" alt=\"search-field-l.jpg\"',1209499189,''),('oSqpGswzpBG_ErdfYwIO8A',50,'style=\"border-style:none;\" alt=\"top_bg.jpg\"',1209499189,''),('MXJklShZvLLB_DSnZQmXrQ',50,'style=\"border-style:none;\" alt=\"title_bg.jpg\"',1209499189,''),('BthxD5oJ0idmsyI3ioA2FA',50,'style=\"border-style:none;\" alt=\"bar-btn-l.jpg\"',1209499189,''),('aZ-1HYQamkRHYXvzAra8WQ',50,'style=\"border-style:none;\" alt=\"search-field.jpg\"',1209499189,''),('eRkb94OYcS5AdcrrerOP5Q',50,'style=\"border-style:none;\" alt=\"rss.gif\"',1209499189,''),('TbnkjAJQEASORXIpYqDkcA',50,'style=\"border-style:none;\" alt=\"blank-image.jpg\"',1209499189,''),('er-3faBjY-hhlDcc5aKqdQ',50,'style=\"border-style:none;\" alt=\"top_bg.jpg\"',1209499189,''),('8bFsu2FJUqHRUiHcozcVFw',50,'style=\"border-style:none;\" alt=\"sub-btn-l.jpg\"',1209499189,''),('34Aayx5eA320D8VfhdfDBw',50,'style=\"border-style:none;\" alt=\"sub-btn-r.jpg\"',1209499189,''),('TlhKOVmWblZOsAdqmhEpeg',50,'style=\"border-style:none;\" alt=\"sub-btn.jpg\"',1209499189,''),('Nx0ypjO3cN6QdZUBUEE0lA',50,'style=\"border-style:none;\" alt=\"pic-title-bg.jpg\"',1209499189,''),('CmFZLN7iPS7XXvUEsxKPKA',50,'style=\"border-style:none;\" alt=\"row-2.jpg\"',1209499190,''),('v_XBgwwZqgW1D5s4y05qfg',50,'style=\"border-style:none;\" alt=\"addtl-info.gif\"',1209499190,''),('4TdAkKoQbSCvI7QWcW889A',50,'style=\"border-style:none;\" alt=\"row-1.jpg\"',1209499190,''),('SAgK6eDPCG1cgkJ59WapHQ',50,'style=\"border-style:none;\" alt=\"prev-btn.gif\"',1209499190,''),('XJYLuvGy9ubF7JNKyINtpA',50,'style=\"border-style:none;\" alt=\"play-btn.gif\"',1209499190,''),('RWj7hyv2SpZuXxwj1Wocug',50,'style=\"border-style:none;\" alt=\"next-btn.gif\"',1209499190,''),('aq8QElnlm3YufAoxRz9Pcg',50,'style=\"border-style:none;\" alt=\"data-bg.jpg\"',1209499190,''),('_bZJ9LA_KNekZiFPaP2SeQ',50,'style=\"border-style:none;\" alt=\"shelf-titles.jpg\"',1210777868,NULL),('hQ7z33_jOYkQ8WNX5xy9Sw',50,'style=\"border-style:none;\" alt=\"style-button.gif\"',1209509455,NULL),('vWW_DcHiYSrKZOkkIfEfcQ',50,'style=\"border-style:none;\" alt=\"row-2.jpg\"',1209509433,NULL),('_bPYzRA87NTAUIKlfrJMHg',50,'style=\"border-style:none;\" alt=\"row-1.jpg\"',1209509433,NULL),('nJjZHRwdDs5MAZYsAyioHw',50,'style=\"border-style:none;\" alt=\"title-bg.jpg\"',1209509433,NULL),('8hxfkrJPeFVRWF5piCNJ1A',50,'style=\"border-style:none;\" alt=\"field-bg.jpg\"',1209509433,NULL),('Osx7WN52iIKHZFT4vqUBHQ',50,'style=\"border-style:none;\" alt=\"search-btn.gif\"',1209509433,NULL),('oWff8fGzRdHPyq5VNREe9Q',50,'style=\"border-style:none;\" alt=\"top-bg.jpg\"',1209509433,NULL),('uqbkvb1b9443VvfkyRz95w',50,'style=\"border-style:none;\" alt=\"save-button.gif\"',1209509433,NULL),('8YiMkcz32xalkAn3WBLpag',50,'style=\"border-style:none;\" alt=\"go-btn.gif\"',1210181860,NULL),('2q5fxatSFLgIhXaUX-oSvg',50,'style=\"border-style:none;\" alt=\"bottom-left.jpg\"',1204149033,NULL),('_d5WTkKjnwct-_Dk7gZHvQ',50,'style=\"border-style:none;\" alt=\"bottom-right.jpg\"',1204149033,NULL),('Iz2mUR3jCPKyemwAea4b2g',50,'style=\"border-style:none;\" alt=\"input_bg.jpg\"',1204149033,NULL),('JU9bjsLRoWj7GVHs__prig',50,'style=\"border-style:none;\" alt=\"top-left.jpg\"',1204149033,NULL),('noOlnjQGexHg8c4bGVUo9g',50,'style=\"border-style:none;\" alt=\"top-right.jpg\"',1204149033,NULL),('7-0-style0000000000059',50,'alt=\"main_top.jpg\"',1213386091,NULL),('o_pq_e4vRyhMOKFzs61eag',50,'style=\"border-style:none;\" alt=\"book-covers.jpg\"',1215714957,NULL),('hBpisL-_URyZnh9clR5ohA',50,'style=\"border-style:none;\" alt=\"no_photo.gif\"',1227634417,''),('FOBV6KkifreXa4GmEAUU4A',50,'style=\"border-style:none;\" alt=\"no_photo_sm.gif\"',1227634447,'');
ALTER TABLE `ImageAsset` ENABLE KEYS;
ALTER TABLE `Layout` DISABLE KEYS;
INSERT INTO `Layout` VALUES ('68sKwDgf9cGH58-NZcU4lg','PBtmpl0000000000000054','TKzUMeIxRLrZ3NAEez6CXQ,sWVXMZGibxHe2Ekj1DCldA',NULL,1124395696,'asc','PBtmpl0000000000000054'),('_iHetEvMQUOoxS-T2CM0sQ','PBtmpl0000000000000054','x_WjMvFmilhX-jvZuIpinw',NULL,1124395696,'asc','PBtmpl0000000000000054'),('8Bb8gu-me2mhL3ljFyiWLg','PBtmpl0000000000000094','6QuS-0rosuZTdTv11fobig.FOvmwGC0GtZo5VTxJIL3OA,ix1p0AbwKAz8QWB-T-HHfg,iCYOjohB9SKvAPr6bXElKA.4Yfz9hqBqM8OYMGuQK8oLw,Wl8WZ43g2rK5AYr9o4zY7w,LBuiKzg2mWwmOPS9AgV3bg,jTNggl7AoVSUc_ZzrvuCmw.',NULL,1124395696,'asc','PBtmpl0000000000000054'),('2TqQc4OISddWCZmRY1_m8A','PBtmpl0000000000000054','fK-HMSboA3uu0c1KYkYspA',NULL,1124395696,'asc','PBtmpl0000000000000054'),('Swf6L8poXKc7hUaNPkBevw','PBtmpl0000000000000054','Szs5eev3OMssmnsyLRZmWA',NULL,1124395696,'asc','PBtmpl0000000000000054'),('x3OFY6OJh_qsXkZfPwug4A','PBtmpl0000000000000054','pJd5TLAjfWMVXD6sCRLwUg',NULL,1124395696,'asc','PBtmpl0000000000000054'),('mTOiwwk3q4k9g5-XykXhPA','PBtmpl0000000000000054','diZvW4bSgZWwyyGP3qXi1g,o_pq_e4vRyhMOKFzs61eag,j_1qEqM6iLfQLiR6VKy0aA',NULL,1218149728,'asc','PBtmpl0000000000000054');
ALTER TABLE `Layout` ENABLE KEYS;
ALTER TABLE `Navigation` DISABLE KEYS;
INSERT INTO `Navigation` VALUES ('pJd5TLAjfWMVXD6sCRLwUg','descendants','specificUrl','root',55,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000001','self\nancestors','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000093',55,1124395696,'text/html',0),('PBnav00000000000000014','pedigree','relativeToRoot','1',55,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000015','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000016','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000017','self\nsiblings','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000018','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000019','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000020','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000021','descendants','specificUrl','home',3,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000002','descendants','specificUrl','home',3,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000006','descendants','specificUrl','home',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000007','descendants','relativeToRoot','1',1,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000008','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000009','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000124',55,1124395696,'text/html',0),('PBnav00000000000000010','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000011','self\ndescendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000130',55,1124395696,'text/html',0),('PBnav00000000000000012','descendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000134',55,1124395696,'text/html',0),('PBnav00000000000000013','self\ndescendants','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000136',55,1124395696,'text/html',0),('7-0-style0000000000025','descendants','relativeToRoot','1',1,0,0,0,'stevenav00000000000001',55,1147642498,'text/html',0),('7-0-style0000000000026','descendants','relativeToRoot','2',1,0,0,0,'PBnav000000style01lvl2',55,1147642499,'text/html',0),('7-0-style0000000000070','descendants','relativeToRoot','1',55,0,0,0,'stevecoolmenu000000001',55,1147642510,'text/html',0),('jVKLVakT_iA2010_oEuAwg','self\ndescendants','specificUrl','department',1,0,0,0,'stevecoolmenu000000001',55,1224116526,'text/html',0),('Vch1Ww7G_JpBhOhXX07RDg','ancestors','relativeToCurrentUrl','0',55,0,1,0,'alraubvBu-YJJ614jAHD5w',1,1235705952,'text/html',0);
ALTER TABLE `Navigation` ENABLE KEYS;
ALTER TABLE `RichEdit` DISABLE KEYS;
INSERT INTO `RichEdit` VALUES ('PBrichedit000000000002',0,0,0,0,0,0,0,0,0,0,'ltr','bottom',NULL,'a[name|href|target|title],strong/b[class],em/i[class],strike[class],u[class],p[dir|class|align],ol,ul,li,br,img[class|src|border=0|alt|title|hspace|vspace|width|height|align],sub,sup,blockquote[dir|style],table[border=0|cellspacing|cellpadding|width|height|class|align],tr[class|rowspan|width|height|align|valign],td[dir|class|colspan|rowspan|width|height|align|valign],div[dir|class|align],span[class|align],pre[class|align],address[class|align],h1[dir|class|align],h2[dir|class|align],h3[dir|class|align],h4[dir|class|align],h5[dir|class|align],h6[dir|class|align],hr','bold\nitalic\nbullist\nnumlist\nlink\nunlink\nemotions',NULL,NULL,0,1124395696,0,0,NULL),('PBrichedit000000000001',0,0,0,0,600,500,0,0,0,0,'ltr','bottom',NULL,'*[*]','bold\nitalic\njustifyleft\njustifyright\njustifycenter\njustifyfull\nindent\noutdent\nsub\nsup\nformatselect\nremoveformat','bullist\nnumlist\nlink\nwgpagetree\nanchor\nunlink\nadvhr\nimage\nwginsertimage\ncharmap\nwgmacro','tablecontrols\nvisualaid\npreview\ncode\ncleanup\nreplace',1,1207240829,0,0,NULL);
ALTER TABLE `RichEdit` ENABLE KEYS;
ALTER TABLE `Survey_questionTypes` DISABLE KEYS;
INSERT INTO `Survey_questionTypes` VALUES ('Scale','[]'),('Gender','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Male\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Female\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Education','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Elementary or some high school\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"High school/GED\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Some college/vocational school\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"College graduate\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Some graduate work\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Master\'s degree\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Doctorate (of any type)\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":1,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Other degree (verbatim)\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Importance','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all important\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely important\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Yes/No','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Yes\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"No\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Confidence','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all confident\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely confident\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Effectiveness','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all effective\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely effective\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Oppose/Support','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly oppose\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly support\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Certainty','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all certain\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely certain\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('True/False','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"True\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"False\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Concern','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all concerned\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely concerned\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Ideology','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly liberal\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Liberal\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Somewhat liberal\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Middle of the road\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Slightly conservative\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Conservative\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly conservative\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Security','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all secure\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely secure\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Risk','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"No risk\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extreme risk\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Agree/Disagree','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly disagree\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly agree\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Race','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"American Indian\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Asian\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Black\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Hispanic\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"White non-Hispanic\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":1,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Something else (verbatim)\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Threat','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"No threat\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extreme threat\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Party','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Democratic party\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Republican party (or GOP)\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Independent party\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":1,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Other party (verbatim)\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Likelihood','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all likely\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely likely\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Multiple Choice','[]'),('Satisfaction','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all satisfied\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely satisfied\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]');
ALTER TABLE `Survey_questionTypes` ENABLE KEYS;
ALTER TABLE `SyndicatedContent` DISABLE KEYS;
INSERT INTO `SyndicatedContent` VALUES ('http://www.plainblack.com/news/news?func=viewRSS',3,'fK-HMSboA3uu0c1KYkYspA','GNvjCFQWjY2AF2uf0aCM8Q',1124395696,'',3600,0);
ALTER TABLE `SyndicatedContent` ENABLE KEYS;
ALTER TABLE `Workflow` DISABLE KEYS;
INSERT INTO `Workflow` VALUES ('pbworkflow000000000001','Daily Maintenance Tasks','This workflow runs daily maintenance tasks such as cleaning up old temporary files and cache.',1,'None','singleton'),('pbworkflow000000000002','Weekly Maintenance Tasks','This workflow runs once per week to perform maintenance tasks like cleaning up log files.',1,'None','singleton'),('pbworkflow000000000004','Hourly Maintenance Tasks','This workflow runs once per hour to perform maintenance tasks like deleting expired user sessions.',1,'None','singleton'),('pbworkflow000000000003','Commit Without Approval','This workflow commits all the assets in this version tag without asking for any approval.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000005','Commit With Approval','This workflow commits all the assets in this version tag after getting approval from content managers.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000006','Unlock Version Tag and Notify Owner','This workflow is used when a version tag approval is denied. It unlocks the version tag, making it available for editing, and notifies the tag owner.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000007','Send Queued Email Messages','Sends all the messages in the mail queue.',1,'None','singleton'),('csworkflow000000000001','Get CS Mail','Retrieves mail from a POP3 account for the given Collaboration System.',1,'WebGUI::Asset::Wobject::Collaboration','singleton'),('AuthLDAPworkflow000001','Synchronize Profile To LDAP','Synchronizes a users LDAP information to their WebGUI User Profile',1,'WebGUI::User','singleton'),('DPWwf20061030000000002','Delete Exported Files','Deletes exported files from an asset being deleted or moved.',1,'None','parallel'),('PassiveAnalytics000001','Analyze Passive Analytics','Manual changes to this workflow will be lost.  Please only use the Passive Analytics screen to make changes',1,'None','singleton'),('send_webgui_statistics','Send WebGUI Stats','This workflow sends some information about your site to the central WebGUI statistics repository. No personal information is sent. The information is used to help determine the future direction WebGUI should take.',0,'None','singleton'),('taxeurecheckworkflow01','Recheck unverified EU VAT numbers','Utility workflow that automatically rechecks VAT numbers that could not be checked when they were submitted',1,'None','parallel');
ALTER TABLE `Workflow` ENABLE KEYS;
ALTER TABLE `WorkflowActivity` DISABLE KEYS;
INSERT INTO `WorkflowActivity` VALUES ('pbwfactivity0000000001','pbworkflow000000000001','Delete temp files older than 24 hours',NULL,1,'WebGUI::Workflow::Activity::CleanTempStorage'),('pbwfactivity0000000002','pbworkflow000000000001','Prune file cache larger than 100MB',NULL,3,'WebGUI::Workflow::Activity::CleanFileCache'),('pbwfactivity0000000022','pbworkflow000000000001','Prune database cache larger than 100MB',NULL,4,'WebGUI::Workflow::Activity::CleanDatabaseCache'),('pbwfactivity0000000005','pbworkflow000000000001','Archive old CS threads',NULL,5,'WebGUI::Workflow::Activity::ArchiveOldThreads'),('vtagactivity0000000002','pbworkflow000000000003','Wait Until','This workflow waits until the value chosen in the \"Wait Until\" field has passed and then continues',1,'WebGUI::Workflow::Activity::WaitUntil'),('pbwfactivity0000000007','pbworkflow000000000001','deal with user groupings that have expired',NULL,6,'WebGUI::Workflow::Activity::ExpireGroupings'),('pbwfactivity0000000011','pbworkflow000000000001','Expire old subscription codes',NULL,7,'WebGUI::Workflow::Activity::ExpireSubscriptionCodes'),('pbwfactivity0000000014','pbworkflow000000000001','Summarize Passive Profiling Data',NULL,8,'WebGUI::Workflow::Activity::SummarizePassiveProfileLog'),('pbwfactivity0000000015','pbworkflow000000000001','Sync User Profiles With LDAP',NULL,9,'WebGUI::Workflow::Activity::SyncProfilesToLdap'),('pbwfactivity0000000003','pbworkflow000000000002','Delete login entries older than 90 days',NULL,1,'WebGUI::Workflow::Activity::CleanLoginHistory'),('pbwfactivity0000000004','pbworkflow000000000002','Move clipboard items older than 30 days to trash',NULL,2,'WebGUI::Workflow::Activity::TrashClipboard'),('pbwfactivity0000000008','pbworkflow000000000002','delete asset revisions older than a year from the database',NULL,3,'WebGUI::Workflow::Activity::PurgeOldAssetRevisions'),('pbwfactivity0000000010','pbworkflow000000000002','delete assets from trash that have been sitting around for 30 days',NULL,4,'WebGUI::Workflow::Activity::PurgeOldTrash'),('pbwfactivity0000000009','pbworkflow000000000004','delete expired sessions',NULL,1,'WebGUI::Workflow::Activity::DeleteExpiredSessions'),('pbwfactivity0000000012','pbworkflow000000000004','Get syndicated content',NULL,2,'WebGUI::Workflow::Activity::GetSyndicatedContent'),('vtagactivity0000000001','pbworkflow000000000005','Wait Until','This workflow waits until the value chosen in the \"Wait Until\" field has passed and then continues',2,'WebGUI::Workflow::Activity::WaitUntil'),('pbwfactivity0000000017','pbworkflow000000000005','Get Approval from Content Managers',NULL,1,'WebGUI::Workflow::Activity::RequestApprovalForVersionTag'),('pbwfactivity0000000019','pbworkflow000000000006','Unlock Version Tag',NULL,1,'WebGUI::Workflow::Activity::UnlockVersionTag'),('pbwfactivity0000000020','pbworkflow000000000006','Notify Committer of Denial',NULL,2,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('pbwfactivity0000000021','pbworkflow000000000007','Send Queued Messages',NULL,1,'WebGUI::Workflow::Activity::SendQueuedMailMessages'),('csactivity000000000001','csworkflow000000000001','Get the mail',NULL,1,'WebGUI::Workflow::Activity::GetCsMail'),('Dl_3P-4y1OoOTf3cRwQ7EA','AuthLDAPworkflow000001','Synchronize Profile To LDAP',NULL,1,'WebGUI::Workflow::Activity::SyncProfileToLdap'),('DPWwfa2006103000000002','DPWwf20061030000000002','Delete Exported Files',NULL,1,'WebGUI::Workflow::Activity::DeleteExportedFiles'),('SWHs3shndnc8LuLpmLeeNw','pbworkflow000000000004','Update Calendar Feeds','This activity imports calendar events from calendar feeds',3,'WebGUI::Workflow::Activity::CalendarUpdateFeeds'),('pbwfactivity0000000006','pbworkflow000000000003','Commit Assets',NULL,2,'WebGUI::Workflow::Activity::CommitVersionTag'),('newslettersendactivity','pbworkflow000000000002','Send Newsletters For Newsletter Assets',NULL,5,'WebGUI::Workflow::Activity::SendNewsletters'),('unansweredfriends_____','pbworkflow000000000001','Deny Friend Requests Older Than A Month',NULL,10,'WebGUI::Workflow::Activity::DenyUnansweredFriends'),('pbwfactivity0000000016','pbworkflow000000000005','Commit Assets',NULL,3,'WebGUI::Workflow::Activity::CommitVersionTag'),('pbwfactivity0000000018','pbworkflow000000000005','Notify Committer of Approval',NULL,4,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('4X02MxKDfvNwzyY4u_yEwQ','PassiveAnalytics000001','Perform duration analysis',NULL,1,'WebGUI::Workflow::Activity::SummarizePassiveAnalytics'),('zUZZLAyKNUl933pI4RspPg','PassiveAnalytics000001','Please log entries into buckets',NULL,2,'WebGUI::Workflow::Activity::BucketPassiveAnalytics'),('1BbO0rpY9-fGqlfpMDHang','pbworkflow000000000001','Remove old carts',NULL,11,'WebGUI::Workflow::Activity::RemoveOldCarts'),('C2v8fZHn-epffECKPWE87g','pbworkflow000000000004','Expire Purchased Thingy Records','Expire any expired thingy records. Send notifications of imminent expiration.',4,'WebGUI::Workflow::Activity::ExpirePurchasedThingyRecords'),('LT8Y9qSH4mOkgH7GVlj6ww','pbworkflow000000000001','Archive Old Stories','Archive old stories, based on the settings of the Story Archives that own them',12,'WebGUI::Workflow::Activity::ArchiveOldStories'),('send_webgui_statistics','send_webgui_statistics','Send WebGUI Stats',NULL,1,'WebGUI::Workflow::Activity::SendWebguiStats'),('ixOnGnjE6D1m71WzhSxcFQ','pbworkflow000000000001','Expire Incomplete Survey Responses','Expires incomplete Survey Responses according to per-instance Survey settings',13,'WebGUI::Workflow::Activity::ExpireIncompleteSurveyResponses'),('taxeurecheckactivity01','taxeurecheckworkflow01','Untitled',NULL,1,'WebGUI::Workflow::Activity::RecheckVATNumber');
ALTER TABLE `WorkflowActivity` ENABLE KEYS;
ALTER TABLE `WorkflowActivityData` DISABLE KEYS;
INSERT INTO `WorkflowActivityData` VALUES ('pbwfactivity0000000001','storageTimeout','86400'),('pbwfactivity0000000002','sizeLimit','1000000000'),('pbwfactivity0000000022','sizeLimit','1000000000'),('vtagactivity0000000002','type','startTime'),('pbwfactivity0000000003','ageToDelete','7776000'),('pbwfactivity0000000004','trashAfter','2592000'),('pbwfactivity0000000008','purgeAfter','31536000'),('pbwfactivity0000000010','purgeAfter','2592000'),('vtagactivity0000000001','type','startTime'),('pbwfactivity0000000017','message','A new version tag awaits your approval.'),('pbwfactivity0000000017','doOnDeny','pbworkflow000000000006'),('pbwfactivity0000000017','groupToApprove','4'),('pbwfactivity0000000020','message','Your version tag was denied. Please take corrective actions and recommit your changes.'),('pbwfactivity0000000020','who','committer'),('unansweredfriends_____','timeout','2592000'),('pbwfactivity0000000006','trashAfter','2592000'),('pbwfactivity0000000018','who','committer'),('pbwfactivity0000000018','message','Your version tag was approved.');
ALTER TABLE `WorkflowActivityData` ENABLE KEYS;
ALTER TABLE `WorkflowSchedule` DISABLE KEYS;
INSERT INTO `WorkflowSchedule` VALUES ('pbcron0000000000000001','Daily Maintenance',1,0,'30','23','*','*','*','pbworkflow000000000001',NULL,NULL,3,NULL),('pbcron0000000000000002','Weekly Maintenance',1,0,'30','1','*','*','0','pbworkflow000000000002',NULL,NULL,3,NULL),('pbcron0000000000000003','Hourly Maintenance',1,0,'15','*','*','*','*','pbworkflow000000000004',NULL,NULL,3,NULL),('pbcron0000000000000004','Send Queued Email Messages Every 5 Minutes',1,0,'*/5','*','*','*','*','pbworkflow000000000007',NULL,NULL,3,NULL),('NpRVTSR-NX2sD52LUc520A','Request Tracker Mail',0,0,'*/5','*','*','*','*','csworkflow000000000001','WebGUI::Asset::Wobject::Collaboration','new',2,'{\n    \"parameters\" : \"pbproto000000000000002\"\n}');
ALTER TABLE `WorkflowSchedule` ENABLE KEYS;
ALTER TABLE `asset` DISABLE KEYS;
INSERT INTO `asset` VALUES ('PBasset000000000000001','infinity','000001','published','WebGUI::Asset',1124395696,'3','997995720','3',NULL,1,NULL),('PBasset000000000000002','PBasset000000000000001','000001000001','published','WebGUI::Asset::Wobject::Folder',1124395696,'3','997995720','3',NULL,1,NULL),('68sKwDgf9cGH58-NZcU4lg','PBasset000000000000001','000001000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('iCYOjohB9SKvAPr6bXElKA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000004','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('ix1p0AbwKAz8QWB-T-HHfg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000003','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('_iHetEvMQUOoxS-T2CM0sQ','68sKwDgf9cGH58-NZcU4lg','000001000002000001','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('FOvmwGC0GtZo5VTxJIL3OA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000002','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('8Bb8gu-me2mhL3ljFyiWLg','68sKwDgf9cGH58-NZcU4lg','000001000002000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('m4YJFaqzultnB_sj1Uq0aw','68sKwDgf9cGH58-NZcU4lg','000001000002000008','published','WebGUI::Asset::File',1147642514,'3','997995720','3',NULL,0,NULL),('IWFxZDyGhQ3-SLZhELa3qw','68sKwDgf9cGH58-NZcU4lg','000001000002000009','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('bX5rYxb6tZ9docY6sUhBlw','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000001','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('Vzv1pWpg_w6R_o-b0rM2qQ','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000002','published','WebGUI::Asset::File',1147642515,'3','997995720','3',NULL,0,NULL),('NK8bqlwVRILJknqeCDPBHg','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000003','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('6QuS-0rosuZTdTv11fobig','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000001','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('2TqQc4OISddWCZmRY1_m8A','68sKwDgf9cGH58-NZcU4lg','000001000002000003','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('fK-HMSboA3uu0c1KYkYspA','2TqQc4OISddWCZmRY1_m8A','000001000002000003000001','published','WebGUI::Asset::Wobject::SyndicatedContent',1124395696,'3','997995720','3',NULL,0,NULL),('Swf6L8poXKc7hUaNPkBevw','68sKwDgf9cGH58-NZcU4lg','000001000002000004','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('Szs5eev3OMssmnsyLRZmWA','Swf6L8poXKc7hUaNPkBevw','000001000002000004000001','published','WebGUI::Asset::Wobject::DataForm',1124395696,'3','997995720','3',NULL,0,NULL),('x3OFY6OJh_qsXkZfPwug4A','68sKwDgf9cGH58-NZcU4lg','000001000002000006','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('pJd5TLAjfWMVXD6sCRLwUg','x3OFY6OJh_qsXkZfPwug4A','000001000002000006000001','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000003','7-0-style0000000000001','000001000001000052000002','published','WebGUI::Asset::Snippet',1147642492,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000001','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000008','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000014','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000009','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000015','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000010','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000016','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000011','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000017','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000012','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000018','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000013','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000019','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000014','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000020','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000015','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000021','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000016','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000002','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000017','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000006','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000018','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000007','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000019','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000008','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000020','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000009','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000021','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000010','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000022','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000011','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000023','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000012','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000024','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000013','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000025','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('Wl8WZ43g2rK5AYr9o4zY7w','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000006','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('4Yfz9hqBqM8OYMGuQK8oLw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000005','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000005','7-0-style0000000000001','000001000001000052000004','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000006','7-0-style0000000000001','000001000001000052000005','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000103','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000002','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000115','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000066','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000080','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000097','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000112','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000121','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000067','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000026','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000128','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000079','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000009','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000083','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000010','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000082','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000011','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000056','TYo2Bwl7aafzTtdHlS-arQ','000001000001000028000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000135','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000131','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000054','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000024','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000088','tPagC0AQErZXjLFZQ6OI1g','000001000001000017000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000078','GYaFxnMu9UsEG8oanwB6TA','000001000001000014000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('-PkdI8l1idu-8gDX3iOdcw','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000007','published','WebGUI::Asset::Template',1247482172,'3','997995720','3',NULL,0,NULL),('VyCINX2KixKYr2pzQGX9Mg','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000006','published','WebGUI::Asset::Snippet',1246968584,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000109','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000094','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000133','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000012','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000065','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000055','VZK3CRgiMb8r4dBjUmCTgQ','000001000001000027000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000020','-K8Hj45mbelljN9-0CXZxg','000001000001000010000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000085','-K8Hj45mbelljN9-0CXZxg','000001000001000010000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000104','-K8Hj45mbelljN9-0CXZxg','000001000001000010000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000021','-K8Hj45mbelljN9-0CXZxg','000001000001000010000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000033','N13SD1Fpqk00UgBt1Z8ivQ','000001000001000016000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000047','cj2y4papTVGZRFdwTI-_fw','000001000001000023000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000029','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000013','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000032','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000014','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000027','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000015','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000031','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000016','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('jTNggl7AoVSUc_ZzrvuCmw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000008','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('LBuiKzg2mWwmOPS9AgV3bg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000007','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('GNvjCFQWjY2AF2uf0aCM8Q','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000068','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000017','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000099','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000018','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000114','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000019','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000092','V3l5S5TtI7wMm1WpIMhvOA','000001000001000021000009000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000044','V3l5S5TtI7wMm1WpIMhvOA','000001000001000021000009000002','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000059','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000040000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('IZkrow_zwvbf4FCH-taVTQ','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000002','published','WebGUI::Asset::Wobject::Folder',1226011853,'3','997995720','3',NULL,0,NULL),('QHn6T9rU7KsnS3Y70KCNTg','PBasset000000000000002','000001000001000002','published','WebGUI::Asset::Wobject::Folder',1227080251,'3','997995720','3',NULL,0,NULL),('HPDOcsj4gBme8D4svHodBw','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000001','published','WebGUI::Asset::Wobject::Folder',1225404573,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000002','TCtybxdqmdwdvRn555zpCQ','000001000001000034000002','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000063','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000062','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000061','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000007','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000012','published','WebGUI::Asset::Template',1236594030,'3','1238119576','3',NULL,0,NULL),('PBtmpl0000000000000116','-K8Hj45mbelljN9-0CXZxg','000001000001000010000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000007','7-0-style0000000000001','000001000001000052000006','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000093','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000108','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000117','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000124','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000130','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000134','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000077','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000020','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000098','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000021','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000122','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000022','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000136','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000013','9M-lrlPQWeeNWfvnDnK_Xg','000001000001000005000007000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000010','K0q_N885Httqev1VCqUWxg','000001000001000005000004000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000011','fq1ZkYhH24R5tb96kuT10Q','000001000001000005000005000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000014','_gBYAdTcbkiyamnqi2Xskg','000001000001000005000008000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000012','oHk7fAFhEEkB7dHzi0QOQA','000001000001000005000006000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000006','taX2UYkFF21ALpFZY2rhMw','000001000001000005000003000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000004','xSmREZO3GNzK3M5PaueOOQ','000001000001000005000001000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000005','0bx-xoL8TSXXubFuqKAoVQ','000001000001000005000002000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000057','Ik9HHky10DIyFTKehUD1dw','000001000001000032000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000060','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('pbrobot000000000000001','PBasset000000000000002','000001000001000035','published','WebGUI::Asset::Snippet',1147642511,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000111','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000137','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000132','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000123','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000081','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000023','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000101','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000024','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000065','7-0-style0000000000049','000001000001000054000016','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('OhdaFLE7sXOzo_SIP2ZUgA','68sKwDgf9cGH58-NZcU4lg','000001000002000007','published','WebGUI::Asset::Wobject::Article',1147642513,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000113','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000025','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000037','GdkQpvjRtJqtzOUbwIIQRA','000001000001000021000002000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000038','tnc5iYyynX2hfdEs9D3P8w','000001000001000021000003000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000036','tBL7BWiQRZFed2Y-Zjo9tQ','000001000001000021000001000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000039','vgXdBcFTqU7h4wBG1ewdBw','000001000001000021000004000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000091','vgXdBcFTqU7h4wBG1ewdBw','000001000001000021000004000002','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000107','vgXdBcFTqU7h4wBG1ewdBw','000001000001000021000004000003','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000040','hcFlqnXlsmC1ujN6Id0F0A','000001000001000021000005000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000041','eRJR52fvlaxfetv3DQkQYw','000001000001000021000006000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000042','5HIDHq5lAWHV5gpYGS0zLg','000001000001000021000007000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000045','y8XkRdxIperLKkJ3bL5sSQ','000001000001000021000011000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000043','rYEFwXXo0tkGhQTcbDibvg','000001000001000021000008000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('7-0-style0000000000064','7-0-style0000000000049','000001000001000054000015','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000001','TCtybxdqmdwdvRn555zpCQ','000001000001000034000001','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000053','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000017','published','WebGUI::Asset::Template',1124395696,'3','1222802960','3',NULL,0,NULL),('PBtmpl0000000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000003000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000140','Da6KWn805L4B5e4HFgQRQA','000001000001000039000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000141','-K8Hj45mbelljN9-0CXZxg','000001000001000010000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000066','7-0-style0000000000049','000001000001000054000017','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000062','7-0-style0000000000049','000001000001000054000013','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000060','7-0-style0000000000049','000001000001000054000011','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000061','7-0-style0000000000049','000001000001000054000012','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000057','7-0-style0000000000049','000001000001000054000008','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000058','7-0-style0000000000049','000001000001000054000009','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000059','7-0-style0000000000049','000001000001000054000010','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000056','7-0-style0000000000049','000001000001000054000007','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000052','7-0-style0000000000049','000001000001000054000003','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000053','7-0-style0000000000049','000001000001000054000004','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000054','7-0-style0000000000049','000001000001000054000005','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000055','7-0-style0000000000049','000001000001000054000006','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('stevecoolmenu000000001','7-0-style0000000000049','000001000001000054000001','published','WebGUI::Asset::Template',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000051','7-0-style0000000000049','000001000001000054000002','published','WebGUI::Asset::Snippet',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000049','PBasset000000000000002','000001000001000054','published','WebGUI::Asset::Wobject::Folder',1147642504,'3','997995720','3',NULL,0,NULL),('stevestyle000000000002','7-0-style0000000000031','000001000001000053000016','published','WebGUI::Asset::Template',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000048','7-0-style0000000000031','000001000001000053000017','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000046','7-0-style0000000000031','000001000001000053000015','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000044','7-0-style0000000000031','000001000001000053000013','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000045','7-0-style0000000000031','000001000001000053000014','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000043','7-0-style0000000000031','000001000001000053000012','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000041','7-0-style0000000000031','000001000001000053000010','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000042','7-0-style0000000000031','000001000001000053000011','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000038','7-0-style0000000000031','000001000001000053000007','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000039','7-0-style0000000000031','000001000001000053000008','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000040','7-0-style0000000000031','000001000001000053000009','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000036','7-0-style0000000000031','000001000001000053000005','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000037','7-0-style0000000000031','000001000001000053000006','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000034','7-0-style0000000000031','000001000001000053000003','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000035','7-0-style0000000000031','000001000001000053000004','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000032','7-0-style0000000000031','000001000001000053000001','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000033','7-0-style0000000000031','000001000001000053000002','published','WebGUI::Asset::Snippet',1147642500,'3','997995720','3',NULL,0,NULL),('PBnav000000style01lvl2','7-0-style0000000000001','000001000001000052000028','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000030','7-0-style0000000000001','000001000001000052000029','published','WebGUI::Asset::File::Image',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000031','PBasset000000000000002','000001000001000053','published','WebGUI::Asset::Wobject::Folder',1147642500,'3','997995720','3',NULL,0,NULL),('stevenav00000000000001','7-0-style0000000000001','000001000001000052000027','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000025','7-0-style0000000000001','000001000001000052000024','published','WebGUI::Asset::Wobject::Navigation',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000026','7-0-style0000000000001','000001000001000052000025','published','WebGUI::Asset::Wobject::Navigation',1147642499,'3','997995720','3',NULL,0,NULL),('stevestyle000000000001','7-0-style0000000000001','000001000001000052000026','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000023','7-0-style0000000000001','000001000001000052000022','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000024','7-0-style0000000000001','000001000001000052000023','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000022','7-0-style0000000000001','000001000001000052000021','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000021','7-0-style0000000000001','000001000001000052000020','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000018','7-0-style0000000000001','000001000001000052000017','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000019','7-0-style0000000000001','000001000001000052000018','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000020','7-0-style0000000000001','000001000001000052000019','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000017','7-0-style0000000000001','000001000001000052000016','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000016','7-0-style0000000000001','000001000001000052000015','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000015','7-0-style0000000000001','000001000001000052000014','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000014','7-0-style0000000000001','000001000001000052000013','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000012','7-0-style0000000000001','000001000001000052000011','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000013','7-0-style0000000000001','000001000001000052000012','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000010','7-0-style0000000000001','000001000001000052000009','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000011','7-0-style0000000000001','000001000001000052000010','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000009','7-0-style0000000000001','000001000001000052000008','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000008','7-0-style0000000000001','000001000001000052000007','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000067','7-0-style0000000000049','000001000001000054000018','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBtmplHelp000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000003000002','published','WebGUI::Asset::Template',1124395706,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000001','PBasset000000000000002','000001000001000052','published','WebGUI::Asset::Wobject::Folder',1147642492,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000001','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000003','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000002','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000004','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000003','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000005','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000004','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000006','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000063','7-0-style0000000000049','000001000001000054000014','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('stevestyle000000000003','7-0-style0000000000049','000001000001000054000020','published','WebGUI::Asset::Template',1147642510,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000002','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000001','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000001','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000002','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000003','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000003','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000004','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000004','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000005','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000004','7-0-style0000000000001','000001000001000052000003','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000002','3uuBf8cYuj1sew2OJXl9tg','000001000001000018000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000001','3uuBf8cYuj1sew2OJXl9tg','000001000001000018000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('PBtmplBlankStyle000001','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('DashboardViewTmpl00001','S1A9iAwKcQQ6P20uTqw-Ew','000001000001000009000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('WeatherDataTmpl0000001','9wKWdum0_8z-OhhquWLtSQ','000001000001000050000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000002','Efe2W0UgrSRDltNJ87jlfg','000001000001000041000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000001','Efe2W0UgrSRDltNJ87jlfg','000001000001000041000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('MultiSearchTmpl0000001','bBzO4CWjqU_ile3gf5Iypw','000001000001000024000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000068','7-0-style0000000000049','000001000001000054000019','published','WebGUI::Asset::File::Image',1147642510,'3','997995720','3',NULL,0,NULL),('ZipArchiveTMPL00000001','CSN-ZON7Uwv8kxf3F1fh5Q','000001000001000056000001','published','WebGUI::Asset::Template',1133743240,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000002','7-0-style0000000000001','000001000001000052000001','published','WebGUI::Asset::File::Image',1147642492,'3','997995720','3',NULL,0,NULL),('WVtmpl0000000000000001','nqNbSUAhk9Vd1zda2SCz9A','000001000001000021000010000001','published','WebGUI::Asset::Template',1133743240,'3','1222803175','3',NULL,0,NULL),('2CS-BErrjMmESOtGT90qOg','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000003','published','WebGUI::Asset::Template',1227070888,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000208','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000026','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000209','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000027','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000210','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000028','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0004','yD1SMHelczihzjEmx6eXBA','000001000001000031000002000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0003','pV7GnZdpjR3XpZaSINIoeg','000001000001000031000003000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0002','71e17KeduiXgODLMlUxiow','000001000001000031000004000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0001','9A-mg2gwWmaYi9o_1C7ArQ','000001000001000031000001000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('TimeTrackingTMPL000002','vTymIDYL2YqEh6PV50F7ew','000001000001000048000001000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('TimeTrackingTMPL000003','lo1ac3BsoJx3ijGQ3gR-bQ','000001000001000048000002000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('TimeTrackingTMPL000001','huASapWvFDzqwOSbcN-JFQ','000001000001000048000003000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('PBtmpl0000000000000200','f_tn9FfoSfKWX43F83v_3w','000001000001000036000001','published','WebGUI::Asset::Template',1147642427,'3','997995720','3',NULL,0,NULL),('PBasset000000000000003','PBasset000000000000001','000001000003','published','WebGUI::Asset::Wobject::Folder',1147642437,'3','997995720','3',NULL,1,NULL),('pbproto000000000000002','PBasset000000000000002','000001000001000033','published','WebGUI::Asset::Wobject::Collaboration',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000220','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000002','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000221','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000003','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('nbSrhXZQuxIjhWFaFPSuVA','PBasset000000000000002','000001000001000003','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('TvOZs8U1kRXLtwtmyW75pg','PBasset000000000000002','000001000001000004','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('xSmREZO3GNzK3M5PaueOOQ','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000001','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('0bx-xoL8TSXXubFuqKAoVQ','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000002','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('taX2UYkFF21ALpFZY2rhMw','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000003','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('K0q_N885Httqev1VCqUWxg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000004','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('fq1ZkYhH24R5tb96kuT10Q','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000005','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('oHk7fAFhEEkB7dHzi0QOQA','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000006','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('9M-lrlPQWeeNWfvnDnK_Xg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000007','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('_gBYAdTcbkiyamnqi2Xskg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000008','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('GNOAsX98vCsl0JRwfwL-gg','PBasset000000000000002','000001000001000008','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('S1A9iAwKcQQ6P20uTqw-Ew','PBasset000000000000002','000001000001000009','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('-K8Hj45mbelljN9-0CXZxg','PBasset000000000000002','000001000001000010','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('tXwf1zaOXTvsqPn6yu-GSw','PBasset000000000000002','000001000001000013','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('GYaFxnMu9UsEG8oanwB6TA','PBasset000000000000002','000001000001000014','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('N13SD1Fpqk00UgBt1Z8ivQ','PBasset000000000000002','000001000001000016','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('tPagC0AQErZXjLFZQ6OI1g','PBasset000000000000002','000001000001000017','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('default_post_received1','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000029','published','WebGUI::Asset::Template',1222708029,'3','1222803001','3',NULL,0,NULL),('3uuBf8cYuj1sew2OJXl9tg','PBasset000000000000002','000001000001000018','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('aNNC62qLAS6TB-0_MCYjsw','PBasset000000000000002','000001000001000019','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('tBL7BWiQRZFed2Y-Zjo9tQ','zyWi26q9na-iiZqL4yedog','000001000001000021000001','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','1222803175','3',NULL,0,NULL),('GdkQpvjRtJqtzOUbwIIQRA','zyWi26q9na-iiZqL4yedog','000001000001000021000002','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','1222803175','3',NULL,0,NULL),('tnc5iYyynX2hfdEs9D3P8w','zyWi26q9na-iiZqL4yedog','000001000001000021000003','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','1222803175','3',NULL,0,NULL),('vgXdBcFTqU7h4wBG1ewdBw','zyWi26q9na-iiZqL4yedog','000001000001000021000004','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','1222803175','3',NULL,0,NULL),('hcFlqnXlsmC1ujN6Id0F0A','zyWi26q9na-iiZqL4yedog','000001000001000021000005','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('eRJR52fvlaxfetv3DQkQYw','zyWi26q9na-iiZqL4yedog','000001000001000021000006','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('5HIDHq5lAWHV5gpYGS0zLg','zyWi26q9na-iiZqL4yedog','000001000001000021000007','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('rYEFwXXo0tkGhQTcbDibvg','zyWi26q9na-iiZqL4yedog','000001000001000021000008','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('V3l5S5TtI7wMm1WpIMhvOA','zyWi26q9na-iiZqL4yedog','000001000001000021000009','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('nqNbSUAhk9Vd1zda2SCz9A','zyWi26q9na-iiZqL4yedog','000001000001000021000010','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','1222803175','3',NULL,0,NULL),('y8XkRdxIperLKkJ3bL5sSQ','zyWi26q9na-iiZqL4yedog','000001000001000021000011','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','1222803175','3',NULL,0,NULL),('LdiozcIUciWuvt3Z-na5Ww','PBasset000000000000002','000001000001000022','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('cj2y4papTVGZRFdwTI-_fw','PBasset000000000000002','000001000001000023','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('bBzO4CWjqU_ile3gf5Iypw','PBasset000000000000002','000001000001000024','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('BFfNj5wA9bDw8H3cnr8pTw','PBasset000000000000002','000001000001000025','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('AgyFhx3eXlfZXNp2MkrsiQ','NywJYmGWe1f6EBXJnWg9Xg','000001000001000030000001','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222803652','3',NULL,0,NULL),('F7MAQ-cpuvQ1KuC7J4P5zQ','NywJYmGWe1f6EBXJnWg9Xg','000001000001000030000002','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222803653','3',NULL,0,NULL),('jEz8iTGNWEt2I05IhVV19Q','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000016','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222802937','3',NULL,0,NULL),('VZK3CRgiMb8r4dBjUmCTgQ','PBasset000000000000002','000001000001000027','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('TYo2Bwl7aafzTtdHlS-arQ','PBasset000000000000002','000001000001000028','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('9A-mg2gwWmaYi9o_1C7ArQ','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000001','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('yD1SMHelczihzjEmx6eXBA','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000002','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('pV7GnZdpjR3XpZaSINIoeg','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000003','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('71e17KeduiXgODLMlUxiow','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000004','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','1222803147','3',NULL,0,NULL),('Ik9HHky10DIyFTKehUD1dw','PBasset000000000000002','000001000001000032','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('f_tn9FfoSfKWX43F83v_3w','PBasset000000000000002','000001000001000036','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('Da6KWn805L4B5e4HFgQRQA','PBasset000000000000002','000001000001000039','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('bbiA9Zq5Gy2oCFBlILO3QA','PBasset000000000000002','000001000001000040','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('Efe2W0UgrSRDltNJ87jlfg','PBasset000000000000002','000001000001000041','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('RrV4aAPnn4dM0ZcU3OXnlw','PBasset000000000000002','000001000001000043','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('5bnNzteN7w3NnK9mF4XiCg','PBasset000000000000002','000001000001000044','published','WebGUI::Asset::Wobject::Folder',1147642481,'3','997995720','3',NULL,0,NULL),('oGfxez5sksyB_PcaAsEm_Q','PBasset000000000000002','000001000001000045','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','997995720','3',NULL,0,NULL),('vTymIDYL2YqEh6PV50F7ew','2OcUWHVsu_L1sDFzIMWYqw','000001000001000048000001','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','1222803153','3',NULL,0,NULL),('lo1ac3BsoJx3ijGQ3gR-bQ','2OcUWHVsu_L1sDFzIMWYqw','000001000001000048000002','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','1222803153','3',NULL,0,NULL),('huASapWvFDzqwOSbcN-JFQ','2OcUWHVsu_L1sDFzIMWYqw','000001000001000048000003','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','1222803153','3',NULL,0,NULL),('9wKWdum0_8z-OhhquWLtSQ','PBasset000000000000002','000001000001000050','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','997995720','3',NULL,0,NULL),('CSN-ZON7Uwv8kxf3F1fh5Q','PBasset000000000000002','000001000001000056','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('TCtybxdqmdwdvRn555zpCQ','PBasset000000000000002','000001000001000034','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000070','7-0-style0000000000049','000001000001000054000021','published','WebGUI::Asset::Wobject::Navigation',1147642510,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000071','7-0-style0000000000049','000001000001000054000022','published','WebGUI::Asset::File::Image',1147642511,'3','997995720','3',NULL,0,NULL),('PBnav00000000000bullet','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000026','published','WebGUI::Asset::Template',1148579524,'3','1222803972','3',NULL,0,NULL),('PBnav00000000indentnav','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000027','published','WebGUI::Asset::Template',1148579525,'3','1222803972','3',NULL,0,NULL),('MK4fCNoyrx5SE8eyDfOpxg','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000004','published','WebGUI::Asset::Template',1247489252,'3','997995720','3',NULL,0,NULL),('PcRRPhh-0KfvLLNIPdxJTw','PBasset000000000000002','000001000001000051','published','WebGUI::Asset::Snippet',1247055282,'3','997995720','3',NULL,0,NULL),('i5kt5aodVs_oepNEkE7Okw','VZK3CRgiMb8r4dBjUmCTgQ','000001000001000027000002','published','WebGUI::Asset::Snippet',1242312883,'3','997995720','3',NULL,0,NULL),('zb_OPKNqcTuIjdvvbEkRjw','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000005','published','WebGUI::Asset::Snippet',1247484073,'3','997995720','3',NULL,0,NULL),('FEDP3dk8J3Chw_gyr7_XEQ','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000028','published','WebGUI::Asset::Snippet',1246278679,'3','997995720','3',NULL,0,NULL),('BmLaN4rmAANkCglXUViEbg','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000005','published','WebGUI::Asset::Wobject::Folder',1157679165,'3','1222803845','3',NULL,0,NULL),('ProjectManagerTMPL0006','BmLaN4rmAANkCglXUViEbg','000001000001000031000005000001','published','WebGUI::Asset::Template',1157679165,'3','1222803845','3',NULL,0,NULL),('ProjectManagerTMPL0005','BmLaN4rmAANkCglXUViEbg','000001000001000031000005000002','published','WebGUI::Asset::Template',1157679165,'3','1222803845','3',NULL,0,NULL),('Q4uX_C557arTp6D_jwB1jQ','PBasset000000000000002','000001000001000055','published','WebGUI::Asset::Wobject::Folder',1165460175,'3','997995720','3',NULL,0,NULL),('WikiRCTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000001','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiFrontTmpl000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000002','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiSearchTmpl00000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000003','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPHTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000004','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPageTmpl0000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000005','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPageEditTmpl000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000006','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiMPTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000007','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('SQLReportDownload00001','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000040000002','published','WebGUI::Asset::Template',1171466654,'3','1222803962','3',NULL,0,NULL),('X7DrzUcj8pOKFa_6k9D5iw','PBasset000000000000002','000001000001000026','published','WebGUI::Asset::Wobject::Folder',1185754569,'3','997995720','3',NULL,0,NULL),('newsletter000000000001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000026000001','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('newslettercs0000000001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000026000002','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('newslettersubscrip0001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000026000003','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('MBmWlA_YEA2I6D29OMGtRg','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000004','published','WebGUI::Asset::Template',1226542675,'3','997995720','3',NULL,0,NULL),('FJbUTvZ2nUTn65LpW6gjsA','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000001','published','WebGUI::Asset::Template',1227070381,'3','997995720','3',NULL,0,NULL),('WikiKeyword00000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000055000008','published','WebGUI::Asset::Template',1185754571,'3','1222803956','3',NULL,0,NULL),('tempspace0000000000000','PBasset000000000000001','000001000004','published','WebGUI::Asset::Wobject::Folder',1185754574,'3','997995720','3',NULL,1,NULL),('75CmQgpcCSkdsL-oawdn3Q','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000002','published','WebGUI::Asset::Template',1227052575,'3','997995720','3',NULL,0,NULL),('gI_TxK-5S4DNuv42wpImmw','PBasset000000000000002','000001000001000015','published','WebGUI::Asset::Wobject::Folder',1197330678,'3','997995720','3',NULL,0,NULL),('jME5BEDYVDlBZ8jIQA9-jQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000001','published','WebGUI::Asset::Template',1197927169,'3','997995720','3',NULL,0,NULL),('azCqD0IjdQSlM3ar29k5Sg','gI_TxK-5S4DNuv42wpImmw','000001000001000015000002','published','WebGUI::Asset::Template',1197881748,'3','997995720','3',NULL,0,NULL),('05FpjceLYhq4csF1Kww1KQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000003','published','WebGUI::Asset::Template',1197879361,'3','997995720','3',NULL,0,NULL),('q5O62aH4pjUXsrQR3Pq4lw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000004','published','WebGUI::Asset::Template',1197825772,'3','997995720','3',NULL,0,NULL),('KAMdiUdJykjN02CPHpyZOw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000005','published','WebGUI::Asset::Template',1197825787,'3','997995720','3',NULL,0,NULL),('OkphOEdaSGTXnFGhK4GT5A','gI_TxK-5S4DNuv42wpImmw','000001000001000015000006','published','WebGUI::Asset::Template',1197825794,'3','997995720','3',NULL,0,NULL),('TEId5V-jEvUULsZA0wuRuA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000007','published','WebGUI::Asset::Template',1197989443,'3','997995720','3',NULL,0,NULL),('6X-7Twabn5KKO_AbgK3PEw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000008','published','WebGUI::Asset::Template',1197987780,'3','997995720','3',NULL,0,NULL),('7JCTAiu1U_bT9ldr655Blw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000009','published','WebGUI::Asset::Template',1197825824,'3','997995720','3',NULL,0,NULL),('0X4Q3tBWUb_thsVbsYz9xQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000010','published','WebGUI::Asset::Template',1197987372,'3','997995720','3',NULL,0,NULL),('m3IbBavqzuKDd2PGGhKPlA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000011','published','WebGUI::Asset::Template',1197825845,'3','997995720','3',NULL,0,NULL),('UTNFeV7B_aSCRmmaFCq4Vw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000012','published','WebGUI::Asset::Template',1197825856,'3','997995720','3',NULL,0,NULL),('zcX-wIUct0S_np14xxOA-A','gI_TxK-5S4DNuv42wpImmw','000001000001000015000013','published','WebGUI::Asset::Template',1197825866,'3','997995720','3',NULL,0,NULL),('MBZK_LPVzqhb4TV4mMRTJg','gI_TxK-5S4DNuv42wpImmw','000001000001000015000014','published','WebGUI::Asset::Snippet',1197330678,'3','997995720','3',NULL,0,NULL),('_hELmIJfgbAyXFNqPyApxQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000015','published','WebGUI::Asset::Snippet',1197330678,'3','997995720','3',NULL,0,NULL),('_9_eiaPgxzF_x_upt6-PNQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000016','published','WebGUI::Asset::Snippet',1197988920,'3','997995720','3',NULL,0,NULL),('kaPRSaf8UKiskiGEgJgLAw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000017','published','WebGUI::Asset::Wobject::Folder',1197330678,'3','997995720','3',NULL,0,NULL),('bANo8aiAPA7aY_oQZKxIWw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000001','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('2ci_v2d4x4uvyjTRlC49OA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000002','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('O-EsSzKgAk1KolFT-x_KsA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000003','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('fdd8tGExyVwHyrB8RBbKXg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000004','published','WebGUI::Asset::File::Image',1197330839,'3','997995720','3',NULL,0,NULL),('BpisgHl4ZDcSECJp6oib1w','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000005','published','WebGUI::Asset::File::Image',1197330840,'3','997995720','3',NULL,0,NULL),('zshreRgPAXtnF0DtVbQ1Yg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000006','published','WebGUI::Asset::File::Image',1197330840,'3','997995720','3',NULL,0,NULL),('mM3bjP_iG9sv5nQb4S17tQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000018','published','WebGUI::Asset::Template',1197879662,'3','997995720','3',NULL,0,NULL),('ilu5BrM-VGaOsec9Lm7M6Q','gI_TxK-5S4DNuv42wpImmw','000001000001000015000019','published','WebGUI::Asset::Template',1197878780,'3','997995720','3',NULL,0,NULL),('-ANLpoTEP-n4POAdRxCzRw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000020','published','WebGUI::Asset::Template',1197880641,'3','997995720','3',NULL,0,NULL),('OxJWQgnGsgyGohP2L3zJPQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000021','published','WebGUI::Asset::Template',1204663962,'3','997995720','3',NULL,0,NULL),('Tsg7xmPYv782j6IVz7yHFg','PBasset000000000000002','000001000001000006','published','WebGUI::Asset::Wobject::Folder',1204890713,'3','997995720','3',NULL,0,NULL),('kj3b-X3i6zRKnhLb4ZiCLw','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000001','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('uRL9qtk7Rb0YRJ41LmHOJw','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000002','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarWeek0000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000003','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarDay00000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000004','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarEvent000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000005','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarEventEdit00001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000006','published','WebGUI::Asset::Template',1205160982,'3','997995720','3',NULL,0,NULL),('CalendarMonth000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000007','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarSearch00000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000008','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarPrintEvent0001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000009','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintMonth0001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000010','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintWeek00001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000011','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintDay000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000012','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('jnYdqDkUR8x7Pv2eGR1qTA','PBasset000000000000002','000001000001000046','published','WebGUI::Asset::Wobject::Folder',1205431513,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000001','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000001','published','WebGUI::Asset::Template',1205003608,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000002','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000002','published','WebGUI::Asset::Template',1205003676,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000003','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000003','published','WebGUI::Asset::Template',1205003711,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000004','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000004','published','WebGUI::Asset::Template',1205158717,'3','997995720','3',NULL,0,NULL),('7fE8md51vTCcuJFOvxNaGA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000022','published','WebGUI::Asset::Snippet',1205443600,'3','997995720','3',NULL,0,NULL),('1oGhfj00KkCzP1ez01AfKA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000023','published','WebGUI::Asset::Snippet',1205635970,'3','997995720','3',NULL,0,NULL),('3qiVYhNTXMVC5hfsumVHgg','gI_TxK-5S4DNuv42wpImmw','000001000001000015000024','published','WebGUI::Asset::Snippet',1206743306,'3','997995720','3',NULL,0,NULL),('vrKXEtluIhbmAS9xmPukDA','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000010','published','WebGUI::Asset::Template',1212092352,'3','1222802925','3',NULL,0,NULL),('4qh0kIsFUdd4Ox-Iu1JZgg','PBasset000000000000002','000001000001000012','published','WebGUI::Asset::Wobject::Folder',1208725439,'3','997995720','3',NULL,0,NULL),('BMybD3cEnmXVk2wQ_qEsRQ','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000001','published','WebGUI::Asset::Template',1208530113,'3','997995720','3',NULL,0,NULL),('OOyMH33plAy6oCj_QWrxtg','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000002','published','WebGUI::Asset::Template',1207951375,'3','997995720','3',NULL,0,NULL),('2rC4ErZ3c77OJzJm7O5s3w','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000003','published','WebGUI::Asset::Template',1208721232,'3','997995720','3',NULL,0,NULL),('PsFn7dJt4wMwBa8hiE3hOA','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000004','published','WebGUI::Asset::Template',1208558071,'3','997995720','3',NULL,0,NULL),('yBwydfooiLvhEFawJb0VTQ','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000005','published','WebGUI::Asset::Template',1208629936,'3','997995720','3',NULL,0,NULL),('63ix2-hU0FchXGIWkG3tow','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000011','published','WebGUI::Asset::Template',1209588387,'3','1222802925','3',NULL,0,NULL),('POVcY79vIqAHR8OfGt36aw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000007','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('hIB-z34r8Xl-vYVYCkKr-w','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000008','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('-mPUoFlYcjqjPUPRLAlxNQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000009','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('MDpUOR-N8KMyt1J7Hh_h4w','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000010','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('YfXKByTwDZVituMc4h13Dg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000011','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('esko_HSU0Gh-uJZ1h3xRmQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000012','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('oSqpGswzpBG_ErdfYwIO8A','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000013','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('MXJklShZvLLB_DSnZQmXrQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000014','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('BthxD5oJ0idmsyI3ioA2FA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000015','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('aZ-1HYQamkRHYXvzAra8WQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000016','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('eRkb94OYcS5AdcrrerOP5Q','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000017','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('TbnkjAJQEASORXIpYqDkcA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000018','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('er-3faBjY-hhlDcc5aKqdQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000019','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('8bFsu2FJUqHRUiHcozcVFw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000020','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('34Aayx5eA320D8VfhdfDBw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000021','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('TlhKOVmWblZOsAdqmhEpeg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000022','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('Nx0ypjO3cN6QdZUBUEE0lA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000023','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('CmFZLN7iPS7XXvUEsxKPKA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000024','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('v_XBgwwZqgW1D5s4y05qfg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000025','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('4TdAkKoQbSCvI7QWcW889A','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000026','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('SAgK6eDPCG1cgkJ59WapHQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000027','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('XJYLuvGy9ubF7JNKyINtpA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000028','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('RWj7hyv2SpZuXxwj1Wocug','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000029','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('aq8QElnlm3YufAoxRz9Pcg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000030','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('gbnRhcWNk1iQe32LFEB5eQ','PBasset000000000000002','000001000001000037','published','WebGUI::Asset::Wobject::Folder',1210779723,'3','997995720','3',NULL,0,NULL),('6tK47xsaIH-ELw0IBo0uRQ','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000001','published','WebGUI::Asset::Wobject::Folder',1210777115,'3','997995720','3',NULL,0,NULL),('_bZJ9LA_KNekZiFPaP2SeQ','6tK47xsaIH-ELw0IBo0uRQ','000001000001000037000001000001','published','WebGUI::Asset::File::Image',1210777868,'3','997995720','3',NULL,0,NULL),('nFen0xjkZn8WkpM93C9ceQ','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000002','published','WebGUI::Asset::Template',1210779326,'3','997995720','3',NULL,0,NULL),('1XOJDcg_ITRYwVM-QnIcPw','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000003','published','WebGUI::Asset::Snippet',1210779441,'3','997995720','3',NULL,0,NULL),('4e-_rNs6mSWedZhQ_V5kJA','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000004','published','WebGUI::Asset::Snippet',1210779672,'3','997995720','3',NULL,0,NULL),('eqb9sWjFEVq0yHunGV8IGw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000012','published','WebGUI::Asset::Template',1213182595,'3','1222802925','3',NULL,0,NULL),('6D4Z-oruXPS6OlH_Kx8pBg','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000005','published','WebGUI::Asset::Wobject::Folder',1209509389,'3','997995720','3',NULL,0,NULL),('hQ7z33_jOYkQ8WNX5xy9Sw','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000001','published','WebGUI::Asset::File::Image',1209509455,'3','997995720','3',NULL,0,NULL),('vWW_DcHiYSrKZOkkIfEfcQ','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000002','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('_bPYzRA87NTAUIKlfrJMHg','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000003','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('nJjZHRwdDs5MAZYsAyioHw','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000004','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('8hxfkrJPeFVRWF5piCNJ1A','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000005','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('Osx7WN52iIKHZFT4vqUBHQ','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000006','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('oWff8fGzRdHPyq5VNREe9Q','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000007','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('uqbkvb1b9443VvfkyRz95w','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000008','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('8YiMkcz32xalkAn3WBLpag','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000009','published','WebGUI::Asset::File::Image',1210181860,'3','997995720','3',NULL,0,NULL),('3n3H85BsdeRQ0I08WmvlOg','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000006','published','WebGUI::Asset::Snippet',1212091492,'3','997995720','3',NULL,0,NULL),('5m5I7__l40C4hhv4ydqAHQ','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000007','published','WebGUI::Asset::Snippet',1210181698,'3','997995720','3',NULL,0,NULL),('C5fPz-Wg85vkYRvCdl-Xqw','PBasset000000000000002','000001000001000049','published','WebGUI::Asset::Wobject::Folder',1212160830,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000001','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000049000001','published','WebGUI::Asset::Template',1212159641,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000002','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000049000002','published','WebGUI::Asset::Template',1212000800,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000003','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000049000003','published','WebGUI::Asset::Template',1212001437,'3','997995720','3',NULL,0,NULL),('usuxw9V3jN4d4pujRiEYxg','7-0-style0000000000049','000001000001000054000023','published','WebGUI::Asset::Snippet',1209494150,'3','997995720','3',NULL,0,NULL),('aNmgn0cd6tldmC1FpW4KbA','PBasset000000000000002','000001000001000038','published','WebGUI::Asset::Wobject::Folder',1213122695,'3','997995720','3',NULL,0,NULL),('2q5fxatSFLgIhXaUX-oSvg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000001','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('_d5WTkKjnwct-_Dk7gZHvQ','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000002','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('Iz2mUR3jCPKyemwAea4b2g','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000003','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('JU9bjsLRoWj7GVHs__prig','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000004','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('noOlnjQGexHg8c4bGVUo9g','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000005','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('aIpCmr9Hi__vgdZnDTz1jw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000006','published','WebGUI::Asset::Template',1209921197,'3','997995720','3',NULL,0,NULL),('XNd7a_g_cTvJVYrVHcx2Mw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000007','published','WebGUI::Asset::Template',1212099009,'3','997995720','3',NULL,0,NULL),('2gtFt7c0qAFNU3BG_uvNvg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000008','published','WebGUI::Asset::Template',1211824430,'3','997995720','3',NULL,0,NULL),('bPz1yk6Y9uwMDMBcmMsSCg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000009','published','WebGUI::Asset::Template',1211829604,'3','997995720','3',NULL,0,NULL),('3womoo7Teyy2YKFa25-MZg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000013','published','WebGUI::Asset::Template',1212098997,'3','1222802925','3',NULL,0,NULL),('EBlxJpZQ9o-8VBOaGQbChA','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000014','published','WebGUI::Asset::Template',1212093746,'3','1222802925','3',NULL,0,NULL),('g8W53Pd71uHB9pxaXhWf_A','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000015','published','WebGUI::Asset::Template',1213184121,'3','1222802925','3',NULL,0,NULL),('mTOiwwk3q4k9g5-XykXhPA','68sKwDgf9cGH58-NZcU4lg','000001000002000005','published','WebGUI::Asset::Wobject::Layout',1215717999,'3','1215733893','3',NULL,0,NULL),('j_1qEqM6iLfQLiR6VKy0aA','mTOiwwk3q4k9g5-XykXhPA','000001000002000005000001','published','WebGUI::Asset::Wobject::Article',1215718151,'3','1215733893','3',NULL,0,NULL),('o_pq_e4vRyhMOKFzs61eag','mTOiwwk3q4k9g5-XykXhPA','000001000002000005000002','published','WebGUI::Asset::File::Image',1215714957,'3','1215733893','3',NULL,0,NULL),('diZvW4bSgZWwyyGP3qXi1g','mTOiwwk3q4k9g5-XykXhPA','000001000002000005000003','published','WebGUI::Asset::Wobject::Article',1215717972,'3','1215733893','3',NULL,0,NULL),('PBEmsBadgeTemplate0000','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000006','published','WebGUI::Asset::Template',1221077977,'3','1222802972','3',NULL,0,NULL),('-WM2dt0ZGpDasuL2wWocxg','PBasset000000000000002','000001000001000031','published','WebGUI::Asset::Wobject::Folder',1222803056,'3','997995720','3',NULL,0,NULL),('2OcUWHVsu_L1sDFzIMWYqw','PBasset000000000000002','000001000001000048','published','WebGUI::Asset::Wobject::Folder',1222803070,'3','997995720','3',NULL,0,NULL),('1z9J1O08n_7gVVlBwSRBJQ','PBasset000000000000002','000001000001000005','published','WebGUI::Asset::Wobject::Folder',1222803099,'3','997995720','3',NULL,0,NULL),('zyWi26q9na-iiZqL4yedog','PBasset000000000000002','000001000001000021','published','WebGUI::Asset::Wobject::Folder',1222803114,'3','997995720','3',NULL,0,NULL),('NywJYmGWe1f6EBXJnWg9Xg','PBasset000000000000002','000001000001000030','published','WebGUI::Asset::Wobject::Folder',1222803606,'3','997995720','3',NULL,0,NULL),('UL-ItI4L1Z6-WSuhuXVvsQ','PBasset000000000000002','000001000001000011','published','WebGUI::Asset::Wobject::Folder',1225139673,'3','997995720','3',NULL,0,NULL),('3rjnBVJRO6ZSkxlFkYh_ug','UL-ItI4L1Z6-WSuhuXVvsQ','000001000001000011000001','published','WebGUI::Asset::Template',1225139643,'3','997995720','3',NULL,0,NULL),('TuYPpHx7TUyk08639Pc8Bg','UL-ItI4L1Z6-WSuhuXVvsQ','000001000001000011000002','published','WebGUI::Asset::Template',1225139643,'3','997995720','3',NULL,0,NULL),('THQhn1C-ooj-TLlEP7aIJQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000025','published','WebGUI::Asset::Snippet',1225313951,'3','1234301624','3',NULL,0,NULL),('jVKLVakT_iA2010_oEuAwg','7-0-style0000000000049','000001000001000054000024','published','WebGUI::Asset::Wobject::Navigation',1224116526,'3','997995720','3',NULL,0,NULL),('QpmlAiYZz6VsKBM-_0wXaw','zyWi26q9na-iiZqL4yedog','000001000001000021000012','published','WebGUI::Asset::Wobject::Folder',1224616691,'3','1234301591','3',NULL,0,NULL),('h_T2xtOxGRQ9QJOR6ebLpQ','QpmlAiYZz6VsKBM-_0wXaw','000001000001000021000012000001','published','WebGUI::Asset::Template',1224616545,'3','1234301591','3',NULL,0,NULL),('4Ekp0kJoJllRRRo_J1Rj6w','QpmlAiYZz6VsKBM-_0wXaw','000001000001000021000012000002','published','WebGUI::Asset::Template',1224616672,'3','1234301591','3',NULL,0,NULL),('gfZOwaTWYjbSoVaQtHBBEw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000001','published','WebGUI::Asset::Template',1226974679,'3','997995720','3',NULL,0,NULL),('c8xrwVuu5QE0XtF9DiVzLw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000002','published','WebGUI::Asset::Template',1226894351,'3','997995720','3',NULL,0,NULL),('0n4HtbXaWa_XJHkFjetnLQ','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000003','published','WebGUI::Asset::Template',1226894994,'3','997995720','3',NULL,0,NULL),('ErEzulFiEKDkaCDVmxUavw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000004','published','WebGUI::Asset::Template',1226895484,'3','997995720','3',NULL,0,NULL),('6uQEULvXFgCYlRWnYzZsuA','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000005','published','WebGUI::Asset::Template',1226896682,'3','997995720','3',NULL,0,NULL),('DUoxlTBXhVS-Zl3CFDpt9g','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000006','published','WebGUI::Asset::Template',1226896802,'3','997995720','3',NULL,0,NULL),('1Q4Je3hKCJzeo0ZBB5YB8g','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000007','published','WebGUI::Asset::Template',1226898445,'3','997995720','3',NULL,0,NULL),('5A8Hd9zXvByTDy4x-H28qw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000008','published','WebGUI::Asset::Template',1226899462,'3','997995720','3',NULL,0,NULL),('VBkY05f-E3WJS50WpdKd1Q','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000009','published','WebGUI::Asset::Template',1226899241,'3','997995720','3',NULL,0,NULL),('XgcsoDrbC0duVla7N7JAdw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000010','published','WebGUI::Asset::Template',1226973330,'3','997995720','3',NULL,0,NULL),('cR0UFm7I1qUI2Wbpj--08Q','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000011','published','WebGUI::Asset::Template',1226964738,'3','997995720','3',NULL,0,NULL),('SVIhz68689hwUGgcDM-gWw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000012','published','WebGUI::Asset::Template',1226973314,'3','997995720','3',NULL,0,NULL),('K0YjxqOqr7RupSo6sIdcAg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000003','published','WebGUI::Asset::Wobject::Folder',1227074310,'3','997995720','3',NULL,0,NULL),('zrNpGbT3odfIkg6nFSUy8Q','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000001','published','WebGUI::Asset::Template',1226994016,'3','997995720','3',NULL,0,NULL),('1Yn_zE_dSiNuaBGNLPbxtw','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000002','published','WebGUI::Asset::Template',1226994422,'3','997995720','3',NULL,0,NULL),('AZFU33p0jpPJ-E6qLSWZng','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000003','published','WebGUI::Asset::Template',1226994865,'3','997995720','3',NULL,0,NULL),('AGJBGviWGAwjnwziiPjvDg','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000004','published','WebGUI::Asset::Template',1226995497,'3','997995720','3',NULL,0,NULL),('7Ijdd8SW32lVgg2H8R-Aqw','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000005','published','WebGUI::Asset::Template',1226995714,'3','997995720','3',NULL,0,NULL),('K8F0j_cq_jgo8dvWY_26Ag','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000006','published','WebGUI::Asset::Template',1226995643,'3','997995720','3',NULL,0,NULL),('G5V6neXIDiFXN05oL-U3AQ','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000007','published','WebGUI::Asset::Template',1226995768,'3','997995720','3',NULL,0,NULL),('_ilRXNR3s8F2vGJ_k9ePcg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000004','published','WebGUI::Asset::Wobject::Folder',1226643205,'3','997995720','3',NULL,0,NULL),('9ThW278DWLV0-Svf68ljFQ','_ilRXNR3s8F2vGJ_k9ePcg','000001000001000002000004000001','published','WebGUI::Asset::Template',1226647187,'3','997995720','3',NULL,0,NULL),('AOjPG2NHgfL9Cq6dDJ7mew','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000005','published','WebGUI::Asset::Wobject::Folder',1226659753,'3','997995720','3',NULL,0,NULL),('aUDsJ-vB9RgP-AYvPOy8FQ','AOjPG2NHgfL9Cq6dDJ7mew','000001000001000002000005000001','published','WebGUI::Asset::Template',1226660439,'3','997995720','3',NULL,0,NULL),('qaVcU0FFzzraMX_bzELqzw','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000006','published','WebGUI::Asset::Wobject::Folder',1227074362,'3','997995720','3',NULL,0,NULL),('b4n3VyUIsAHyIvT-W-jziA','qaVcU0FFzzraMX_bzELqzw','000001000001000002000006000001','published','WebGUI::Asset::Template',1227074747,'3','997995720','3',NULL,0,NULL),('1IzRpX0tgW7iuCfaU2Kk0A','qaVcU0FFzzraMX_bzELqzw','000001000001000002000006000002','published','WebGUI::Asset::Template',1227079721,'3','997995720','3',NULL,0,NULL),('N716tpSna0iIQTKxS4gTWA','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000007','published','WebGUI::Asset::Template',1226604666,'3','997995720','3',NULL,0,NULL),('GRUNFctldUgop-qRLuo_DA','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000004','published','WebGUI::Asset::Template',1227254010,'3','997995720','3',NULL,0,NULL),('d8jMMMRddSQ7twP4l1ZSIw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000005','published','WebGUI::Asset::Template',1227248175,'3','997995720','3',NULL,0,NULL),('CxMpE_UPauZA3p8jdrOABw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000006','published','WebGUI::Asset::Template',1227556536,'3','997995720','3',NULL,0,NULL),('1oBRscNIcFOI-pETrCOspA','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000007','published','WebGUI::Asset::Template',1226009642,'3','997995720','3',NULL,0,NULL),('wAc4azJViVTpo-2NYOXWvg','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000008','published','WebGUI::Asset::Template',1226009650,'3','997995720','3',NULL,0,NULL),('AjhlNO3wZvN5k4i4qioWcg','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000009','published','WebGUI::Asset::Template',1226009658,'3','997995720','3',NULL,0,NULL),('itransact_credentials1','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000018','published','WebGUI::Asset::Template',1228953856,'3','1234301682','3',NULL,0,NULL),('hkj6WeChxFyqfP85UlRP8w','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000006','published','WebGUI::Asset::Snippet',1232664229,'3','997995720','3',NULL,0,NULL),('kJf77eCr9GAMiEzWrzsBTA','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000007','published','WebGUI::Asset::Snippet',1229639255,'3','997995720','3',NULL,0,NULL),('4LQT4-bGW4FkiEQLSY5gvQ','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000008','published','WebGUI::Asset::Snippet',1232400287,'3','997995720','3',NULL,0,NULL),('alraubvBu-YJJ614jAHD5w','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000009','published','WebGUI::Asset::Template',1232664015,'3','997995720','3',NULL,0,NULL),('Vch1Ww7G_JpBhOhXX07RDg','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000010','published','WebGUI::Asset::Wobject::Navigation',1232664082,'3','997995720','3',NULL,0,NULL),('_XfvgNH__bY1ykMiKYSobQ','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000008','published','WebGUI::Asset::Snippet',1233168041,'3','997995720','3',NULL,0,NULL),('HW-sPoDDZR8wBZ0YgFgPtg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000009','published','WebGUI::Asset::Wobject::Folder',1227634350,'3','997995720','3',NULL,0,NULL),('hBpisL-_URyZnh9clR5ohA','HW-sPoDDZR8wBZ0YgFgPtg','000001000001000002000009000001','published','WebGUI::Asset::File::Image',1227634417,'3','997995720','3',NULL,0,NULL),('FOBV6KkifreXa4GmEAUU4A','HW-sPoDDZR8wBZ0YgFgPtg','000001000001000002000009000002','published','WebGUI::Asset::File::Image',1227634447,'3','997995720','3',NULL,0,NULL),('qsG6B24a0SC5KrhQjmdZBw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000010','published','WebGUI::Asset::Snippet',1233860274,'3','1234301655','3',NULL,0,NULL),('wrq7hMxb1ewQqZ46xmd8Gg','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000011','published','WebGUI::Asset::Snippet',1235706620,'3','1238119575','3',NULL,0,NULL),('matrixtmpl000000000006','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000013','published','WebGUI::Asset::Template',1236889702,'3','1238119576','3',NULL,0,NULL),('-zxyB-O50W8YnL39Ouoc4Q','AOjPG2NHgfL9Cq6dDJ7mew','000001000001000002000005000002','published','WebGUI::Asset::Template',1236959717,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000016','fq1ZkYhH24R5tb96kuT10Q','000001000001000005000005000003','published','WebGUI::Asset::Template',1237407798,'3','1238119553','3',NULL,0,NULL),('RSAMkc6WQmfRE3TOr1_3Mw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000011','published','WebGUI::Asset::Wobject::Folder',1234828062,'3','1238119589','3',NULL,0,NULL),('ExpireIncResptmpl00001','RSAMkc6WQmfRE3TOr1_3Mw','000001000001000044000011000001','published','WebGUI::Asset::Template',1236752721,'3','1238119589','3',NULL,0,NULL),('XdlKhCDvArs40uqBhvzR3w','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000006','published','WebGUI::Asset::Template',1255485472,'3','997995720','3',NULL,0,NULL),('VCFhB9WOsDsH2Apj3c6DpQ','PBasset000000000000002','000001000001000057','published','WebGUI::Asset::Template',1255485472,'3','997995720','3',NULL,0,NULL),('NBVSVNLp9X_bV7WrCprtCA','tPagC0AQErZXjLFZQ6OI1g','000001000001000017000002','published','WebGUI::Asset::Template',1237842096,'3','1238119599','3',NULL,0,NULL),('jmlI9IK-lV8n2WMYmmPhAA','PBasset000000000000002','000001000001000001','published','WebGUI::Asset::Wobject::Folder',1238106173,'3','997995720','3',NULL,0,NULL),('AldPGu0u-jm_5xK13atCSQ','jmlI9IK-lV8n2WMYmmPhAA','000001000001000001000001','published','WebGUI::Asset::Template',1238106805,'3','997995720','3',NULL,0,NULL),('ohjyzab5i-yW6GOWTeDUHg','jmlI9IK-lV8n2WMYmmPhAA','000001000001000001000002','published','WebGUI::Asset::Template',1238106805,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000015','fq1ZkYhH24R5tb96kuT10Q','000001000001000005000005000002','published','WebGUI::Asset::Template',1237647040,'3','1238119545','3',NULL,0,NULL),('6uvSLY-ak_w4p_wS8q33cA','PBasset000000000000002','000001000001000007','published','WebGUI::Asset::Wobject::Folder',1239213092,'3','997995720','3',NULL,0,NULL),('CarouselTmpl0000000001','6uvSLY-ak_w4p_wS8q33cA','000001000001000007000001','published','WebGUI::Asset::Template',1239290719,'3','997995720','3',NULL,0,NULL),('CarouselTmpl0000000002','6uvSLY-ak_w4p_wS8q33cA','000001000001000007000002','published','WebGUI::Asset::Template',1238878995,'3','997995720','3',NULL,0,NULL),('7F-BuEHi7t9bPi008H8xZQ','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000012','published','WebGUI::Asset::Template',1239248021,'3','1251849727','3',NULL,0,NULL),('GaBAW-2iVhLMJaZQzVLE5A','PBasset000000000000002','000001000001000047','published','WebGUI::Asset::Wobject::Folder',1240103565,'3','997995720','3',NULL,0,NULL),('TKmhv8boP3TD2xwSwUBq0g','GaBAW-2iVhLMJaZQzVLE5A','000001000001000047000001','published','WebGUI::Asset::Template',1240103436,'3','997995720','3',NULL,0,NULL),('fowHfgOkJtAxdst7rugTog','PBasset000000000000002','000001000001000042','published','WebGUI::Asset::Wobject::Folder',1236184911,'3','997995720','3',NULL,0,NULL),('3QpYtHrq_jmAk1FNutQM5A','fowHfgOkJtAxdst7rugTog','000001000001000042000001','published','WebGUI::Asset::Template',1239237827,'3','997995720','3',NULL,0,NULL),('yxD5ka7XHebPLD-LXBwJqw','fowHfgOkJtAxdst7rugTog','000001000001000042000002','published','WebGUI::Asset::Template',1239918573,'3','997995720','3',NULL,0,NULL),('E3tzZjzhmYoNlAyP2VW33Q','fowHfgOkJtAxdst7rugTog','000001000001000042000003','published','WebGUI::Asset::Template',1239236292,'3','997995720','3',NULL,0,NULL),('TbDcVLbbznPi0I0rxQf2CQ','fowHfgOkJtAxdst7rugTog','000001000001000042000004','published','WebGUI::Asset::Template',1237524306,'3','997995720','3',NULL,0,NULL),('A16v-YjWAShXWvSACsraeg','fowHfgOkJtAxdst7rugTog','000001000001000042000005','published','WebGUI::Asset::Template',1239918710,'3','997995720','3',NULL,0,NULL),('0EAJ9EYb9ap2XwfrcXfdLQ','fowHfgOkJtAxdst7rugTog','000001000001000042000006','published','WebGUI::Asset::Template',1240262820,'3','997995720','3',NULL,0,NULL),('b1316COmd9xRv4fCI3LLGA','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000013','published','WebGUI::Asset::Template',1236956475,'3','1251849906','3',NULL,0,NULL),('lo1rpxn3t8YPyKGers5eQg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000010','published','WebGUI::Asset::Wobject::Folder',1238625621,'3','1251850125','3',NULL,0,NULL),('64tqS80D53Z0JoAs2cX2VQ','lo1rpxn3t8YPyKGers5eQg','000001000001000002000010000001','published','WebGUI::Asset::Template',1239400975,'3','1251850125','3',NULL,0,NULL),('lG2exkH9FeYvn4pA63idNg','lo1rpxn3t8YPyKGers5eQg','000001000001000002000010000002','published','WebGUI::Asset::Template',1239383808,'3','1251850125','3',NULL,0,NULL),('nWNVoMLrMo059mDRmfOp9g','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000015','published','WebGUI::Asset::Template',1242259265,'3','1251849915','3',NULL,0,NULL),('brxm_faNdZX5tRo3p50g3g','PBasset000000000000002','000001000001000020','published','WebGUI::Asset::Wobject::Folder',1238054297,'3','997995720','3',NULL,0,NULL),('9j0_Z1j3Jd0QBbY2akb6qw','brxm_faNdZX5tRo3p50g3g','000001000001000020000001','published','WebGUI::Asset::Template',1238053232,'3','997995720','3',NULL,0,NULL),('oHh0UqAJeY7u2n--WD-BAA','brxm_faNdZX5tRo3p50g3g','000001000001000020000002','published','WebGUI::Asset::Template',1238040667,'3','997995720','3',NULL,0,NULL),('u9vfx33XDk5la1-QC5FK7g','brxm_faNdZX5tRo3p50g3g','000001000001000020000003','published','WebGUI::Asset::Template',1238048383,'3','997995720','3',NULL,0,NULL),('D6cJpRcey35aSkh9Q_FPUQ','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000019','published','WebGUI::Asset::Template',1242407725,'3','1251849978','3',NULL,0,NULL),('S2_LsvVa95OSqc66ITAoig','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000007','published','WebGUI::Asset::Template',1242730712,'3','1251849967','3',NULL,0,NULL),('S3zpVitAmhy58CAioH359Q','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000013','published','WebGUI::Asset::Template',1242893798,'3','1251849727','3',NULL,0,NULL),('kwTL1SWCk0GlpiJ5zAAEPQ','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000014','published','WebGUI::Asset::Snippet',1244488512,'3','1251849727','3',NULL,0,NULL),('YP9WaMPJHvCJl-YwrLVcPw','PBasset000000000000002','000001000001000029','published','WebGUI::Asset::Template',1245376837,'3','997995720','3',NULL,0,NULL),('i9-G00ALhJOr0gMh-vHbKA','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000014','published','WebGUI::Asset::Template',1250408924,'3','1251849906','3',NULL,0,NULL),('2GxjjkRuRkdUg_PccRPjpA','PBasset000000000000002','000001000001000058','published','WebGUI::Asset::Template',1256702483,'3','997995720','3',NULL,0,NULL),('mRtqRuVikSe82BQsYBlD0A','PBasset000000000000002','000001000001000059','published','WebGUI::Asset::Template',1263358862,'3','997995720','3',NULL,0,NULL);
ALTER TABLE `asset` ENABLE KEYS;
ALTER TABLE `assetAspectRssFeed` DISABLE KEYS;
INSERT INTO `assetAspectRssFeed` VALUES ('fK-HMSboA3uu0c1KYkYspA',1124395696,25,NULL,'','',NULL,'','','rss\natom'),('pbproto000000000000002',1163019036,25,NULL,'','',NULL,'','','');
ALTER TABLE `assetAspectRssFeed` ENABLE KEYS;
ALTER TABLE `assetData` DISABLE KEYS;
INSERT INTO `assetData` VALUES ('PBasset000000000000001',1124395696,'3','pbversion0000000000001','approved','Root','Root','root','3','7','3',NULL,0,1,0,0,0,158,NULL,0,1,0,1242380151,NULL,0),('PBasset000000000000002',1124395696,'3','pbversion0000000000001','approved','Import Node','Import','root/import','3','7','12',NULL,0,1,0,0,0,309,NULL,0,1,0,1242380151,NULL,0),('68sKwDgf9cGH58-NZcU4lg',1124395696,'3','pbversion0000000000001','approved','Home','Home','home','3','7','3',NULL,0,0,0,0,0,354,NULL,0,1,0,1242380142,NULL,0),('_iHetEvMQUOoxS-T2CM0sQ',1124395696,'3','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started','3','7','3',NULL,0,0,0,0,0,370,NULL,0,1,0,1242380165,NULL,0),('8Bb8gu-me2mhL3ljFyiWLg',1124395696,'3','pbversion0000000000001','approved','What should you do next?','Your Next Step','your_next_step','3','7','3',NULL,0,0,0,0,0,539,NULL,0,1,0,1242380146,NULL,0),('Vzv1pWpg_w6R_o-b0rM2qQ',1147642515,'3','pbversion0000000000001','approved','Ad','Ad','home/ad2','3','7','4',NULL,0,1,0,0,0,2155188,NULL,0,1,0,1242380164,NULL,0),('NK8bqlwVRILJknqeCDPBHg',1147642515,'3','pbversion0000000000001','approved','Getting Started (part 2)','Getting Started (part 2)','getting_started/getting-started-part2','3','7','4',NULL,0,1,0,0,0,1693,NULL,0,1,0,1242380151,NULL,0),('6QuS-0rosuZTdTv11fobig',1147642515,'3','pbversion0000000000001','approved','Talk to the Experts','Talk to the Experts','yns/experts','3','7','4',NULL,0,1,0,0,0,703,NULL,0,1,0,1242380142,NULL,0),('ix1p0AbwKAz8QWB-T-HHfg',1147642516,'3','pbversion0000000000001','approved','Get Support','Get Support','yns/support','3','7','4',NULL,0,1,0,0,0,739,NULL,0,1,0,1242380149,NULL,0),('4Yfz9hqBqM8OYMGuQK8oLw',1147642516,'3','pbversion0000000000001','approved','Get Features','Get Features','yns/features','3','7','4',NULL,0,1,0,0,0,772,NULL,0,1,0,1242380142,NULL,0),('LBuiKzg2mWwmOPS9AgV3bg',1147642517,'3','pbversion0000000000001','approved','Get Translated','Get Translated','yns/translated','3','7','4',NULL,0,1,0,0,0,728,NULL,0,1,0,1242380150,NULL,0),('jTNggl7AoVSUc_ZzrvuCmw',1147642517,'3','pbversion0000000000001','approved','Get Promoted','Get Promoted','yns/promotion','3','7','4',NULL,0,1,0,0,0,721,NULL,0,1,0,1242380150,NULL,0),('2TqQc4OISddWCZmRY1_m8A',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news','3','7','3',NULL,0,0,0,0,0,370,NULL,0,1,0,1242380142,NULL,0),('fK-HMSboA3uu0c1KYkYspA',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news/the_latest_news','3','7','3',NULL,0,1,0,0,0,513,NULL,0,1,0,1242380148,NULL,0),('Swf6L8poXKc7hUaNPkBevw',1124395696,'3','pbversion0000000000001','approved','Tell A Friend','Tell A Friend','tell_a_friend','3','7','3',NULL,0,0,0,0,0,364,NULL,0,1,0,1242380163,NULL,0),('x3OFY6OJh_qsXkZfPwug4A',1124395696,'3','pbversion0000000000001','approved','Site Map','Site Map','site_map','3','7','3',NULL,0,0,0,0,0,349,NULL,0,1,0,1242380165,NULL,0),('pJd5TLAjfWMVXD6sCRLwUg',1124395696,'3','pbversion0000000000001','approved','Site Map','Site Map','site_map/site_map','3','7','3',NULL,0,1,0,0,0,364,NULL,0,1,0,1242380162,NULL,0),('7-0-style0000000000003',1147642492,'3','pbversion0000000000001','approved','css01.css','css01.css','style1/css01.css','3','7','12',NULL,0,0,0,0,0,9086,NULL,0,1,0,1242380143,NULL,0),('PBnav00000000000000001',1124395696,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail','3','7','12',NULL,0,1,0,0,0,371,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000014',1124395696,'3','pbversion0000000000001','approved','FlexMenu','FlexMenu','flexmenu','3','7','12',NULL,0,1,0,0,0,353,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000015',1124395696,'3','pbversion0000000000001','approved','currentMenuVertical','currentMenuVertical','currentmenuvertical','3','7','12',NULL,0,1,0,0,0,394,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000016',1124395696,'3','pbversion0000000000001','approved','currentMenuHorizontal','currentMenuHorizontal','currentmenuhorizontal','3','7','12',NULL,0,1,0,0,0,400,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000017',1124395696,'3','pbversion0000000000001','approved','PreviousDropMenu','PreviousDropMenu','previousdropmenu','3','7','12',NULL,0,1,0,0,0,388,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000018',1124395696,'3','pbversion0000000000001','approved','previousMenuVertical','previousMenuVertical','previousmenuvertical','3','7','12',NULL,0,1,0,0,0,398,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000019',1124395696,'3','pbversion0000000000001','approved','previousMenuHorizontal','previousMenuHorizontal','previousmenuhorizontal','3','7','12',NULL,0,1,0,0,0,404,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000020',1124395696,'3','pbversion0000000000001','approved','rootmenu','rootmenu','rootmenu','3','7','12',NULL,0,1,0,0,0,355,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000021',1124395696,'3','pbversion0000000000001','approved','SpecificDropMenu','SpecificDropMenu','specificdropmenu','3','7','12',NULL,0,1,0,0,0,379,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000002',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuVertical','SpecificSubMenuVertical','specificsubmenuvertical','3','7','12',NULL,0,1,0,0,0,400,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000006',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal','specificsubmenuhorizontal','3','7','12',NULL,0,1,0,0,0,406,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000007',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuVertical','TopLevelMenuVertical','toplevelmenuvertical','3','7','12',NULL,0,1,0,0,0,391,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000008',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuHorizontal','TopLevelMenuHorizontal','toplevelmenuhorizontal','3','7','12',NULL,0,1,0,0,0,397,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000009',1124395696,'3','pbversion0000000000001','approved','RootTab','RootTab','roottab','3','7','12',NULL,0,1,0,0,0,352,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000010',1124395696,'3','pbversion0000000000001','approved','TopDropMenu','TopDropMenu','topdropmenu','3','7','12',NULL,0,1,0,0,0,364,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000011',1124395696,'3','pbversion0000000000001','approved','dtree','dtree','dtree','3','7','12',NULL,0,1,0,0,0,352,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000012',1124395696,'3','pbversion0000000000001','approved','coolmenu','coolmenu','coolmenu','3','7','12',NULL,0,1,0,0,0,356,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000013',1124395696,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis','3','7','12',NULL,0,1,0,0,0,367,NULL,0,1,0,1247779653,NULL,0),('7-0-style0000000000006',1147642493,'3','pbversion0000000000001','approved','main_bg.gif','main_bg.gif','style1/main_bg.gif','3','7','12',NULL,0,0,0,0,0,1149,NULL,0,1,0,1242380143,NULL,0),('PBrichedit000000000002',1124395696,'3','pbversion0000000000001','approved','Forum Rich Edit','Forum Rich Edit','forum_rich_edit','3','7','12',NULL,0,0,0,0,0,873,NULL,0,1,0,1242380152,NULL,0),('7-0-style0000000000068',1147642510,'3','pbversion0000000000001','approved','spacer.gif','spacer.gif','style3/spacer.gif','3','7','12',NULL,0,0,0,0,0,358,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000066',1147642509,'3','pbversion0000000000001','approved','nav_bg_on.jpg','nav_bg_on.jpg','style3/nav_bg_on.jpg','3','7','12',NULL,0,0,0,0,0,658,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000067',1147642509,'3','pbversion0000000000001','approved','pb.jpg','pb.jpg','style3/pb.jpg','3','7','12',NULL,0,0,0,0,0,24981,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000062',1147642508,'3','pbversion0000000000001','approved','nav_bg1.jpg','nav_bg1.jpg','style3/nav_bg1.jpg','3','7','12',NULL,0,0,0,0,0,672,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000063',1147642508,'3','pbversion0000000000001','approved','nav_bg1_on.jpg','nav_bg1_on.jpg','style3/nav_bg1_on.jpg','3','7','12',NULL,0,0,0,0,0,683,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000064',1147642509,'3','pbversion0000000000001','approved','nav_bg2.jpg','nav_bg2.jpg','style3/nav_bg2.jpg','3','7','12',NULL,0,0,0,0,0,675,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000065',1147642509,'3','pbversion0000000000001','approved','nav_bg2_on.jpg','nav_bg2_on.jpg','style3/nav_bg2_on.jpg','3','7','12',NULL,0,0,0,0,0,688,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000061',1147642508,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style3/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,669,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000057',1147642507,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style3/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,639,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000058',1147642507,'3','pbversion0000000000001','approved','main_bottom.jpg','main_bottom.jpg','style3/main_bottom.jpg','3','7','12',NULL,0,0,0,0,0,2630,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000060',1147642508,'3','pbversion0000000000001','approved','main_top_bg.jpg','main_top_bg.jpg','style3/main_top_bg.jpg','3','7','12',NULL,0,0,0,0,0,687,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000054',1147642506,'3','pbversion0000000000001','approved','header_bg.jpg','header_bg.jpg','style3/header_bg.jpg','3','7','12',NULL,0,0,0,0,0,715,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000055',1147642506,'3','pbversion0000000000001','approved','header_left.jpg','header_left.jpg','style3/header_left.jpg','3','7','12',NULL,0,0,0,0,0,23983,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000056',1147642506,'3','pbversion0000000000001','approved','header_right.jpg','header_right.jpg','style3/header_right.jpg','3','7','12',NULL,0,0,0,0,0,24757,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000053',1147642505,'3','pbversion0000000000001','approved','footer_right.jpg','footer_right.jpg','style3/footer_right.jpg','3','7','12',NULL,0,0,0,0,0,2886,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000052',1147642505,'3','pbversion0000000000001','approved','footer_bg.jpg','footer_bg.jpg','style3/footer_bg.jpg','3','7','12',NULL,0,0,0,0,0,680,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000048',1147642504,'3','pbversion0000000000001','approved','wg.jpg','wg.jpg','style2/wg.jpg','3','7','12',NULL,0,0,0,0,0,20795,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000046',1147642504,'3','pbversion0000000000001','approved','rightCol_bg.jpg','rightCol_bg.jpg','style2/rightcol_bg.jpg','3','7','12',NULL,0,0,0,0,0,720,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000043',1147642503,'3','pbversion0000000000001','approved','pb.jpg','pb.jpg','style2/pb.jpg','3','7','12',NULL,0,0,0,0,0,22948,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000044',1147642503,'3','pbversion0000000000001','approved','pb_wg.jpg','pb_wg.jpg','style2/pb_wg.jpg','3','7','12',NULL,0,0,0,0,0,2720,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000040',1147642502,'3','pbversion0000000000001','approved','navbar_right.jpg','navbar_right.jpg','style2/navbar_right.jpg','3','7','12',NULL,0,0,0,0,0,960,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000041',1147642502,'3','pbversion0000000000001','approved','page_title.jpg','page_title.jpg','style2/page_title.jpg','3','7','12',NULL,0,0,0,0,0,24856,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000042',1147642502,'3','pbversion0000000000001','approved','page_title_bg.jpg','page_title_bg.jpg','style2/page_title_bg.jpg','3','7','12',NULL,0,0,0,0,0,720,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000038',1147642501,'3','pbversion0000000000001','approved','navbar_bg.jpg','navbar_bg.jpg','style2/navbar_bg.jpg','3','7','12',NULL,0,0,0,0,0,625,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000039',1147642502,'3','pbversion0000000000001','approved','navbar_left.jpg','navbar_left.jpg','style2/navbar_left.jpg','3','7','12',NULL,0,0,0,0,0,663,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000036',1147642501,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style2/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,764,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000037',1147642501,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style2/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,602,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000033',1147642500,'3','pbversion0000000000001','approved','css02.css','css02.css','style2/css02.css','3','7','12',NULL,0,0,0,0,0,5530,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000034',1147642500,'3','pbversion0000000000001','approved','leftCol_header.jpg','leftCol_header.jpg','style2/leftcol_header.jpg','3','7','12',NULL,0,0,0,0,0,10987,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000035',1147642501,'3','pbversion0000000000001','approved','leftCol_header02.jpg','leftCol_header02.jpg','style2/leftcol_header02.jpg','3','7','12',NULL,0,0,0,0,0,4606,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000030',1147642499,'3','pbversion0000000000001','approved','webgui_btn.jpg','webgui_btn.jpg','style1/webgui_btn.jpg','3','7','12',NULL,0,0,0,0,0,5180,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000031',1147642500,'3','pbversion0000000000001','approved','WebGUI 7 Style 2','WebGUI 7 Style 2','root/import/webgui-7-style-2','3','7','12',NULL,0,0,0,0,0,325,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000032',1147642500,'3','pbversion0000000000001','approved','context_bg.jpg','context_bg.jpg','style2/context_bg.jpg','3','7','12',NULL,0,0,0,0,0,661,NULL,0,1,0,1242380143,NULL,0),('PBnav000000style01lvl2',1147642499,'3','pbversion0000000000001','approved','Style 01 Nav lvl2','untitled','style1_nav_lvl2','3','7','12',NULL,0,0,0,0,0,1695,NULL,0,1,0,1242380152,NULL,0),('7-0-style0000000000026',1147642499,'3','pbversion0000000000001','approved','RootTab Level 1','RootTab Level 1','roottab_level1','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1242380143,NULL,0),('stevenav00000000000001',1147642499,'3','pbversion0000000000001','approved','Style 01 Nav','Style 01 Nav','style1_nav','3','7','12',NULL,0,0,0,0,0,1665,NULL,0,1,0,1242380162,NULL,0),('7-0-style0000000000025',1147642498,'3','pbversion0000000000001','approved','RootTab Level 0','RootTab Level 0','roottab_level0','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000022',1147642497,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style1/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,1109,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000023',1147642498,'3','pbversion0000000000001','approved','nav_on.jpg','nav_on.jpg','style1/nav_on.jpg','3','7','12',NULL,0,0,0,0,0,919,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000024',1147642498,'3','pbversion0000000000001','approved','orange_left01.jpg','orange_left01.jpg','style1/orange_left01.jpg','3','7','12',NULL,0,0,0,0,0,2747,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000018',1147642496,'3','pbversion0000000000001','approved','nav2_off_left.jpg','nav2_off_left.jpg','style1/nav2_off_left.jpg','3','7','12',NULL,0,0,0,0,0,752,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000019',1147642497,'3','pbversion0000000000001','approved','nav2_off_right.jpg','nav2_off_right.jpg','style1/nav2_off_right.jpg','3','7','12',NULL,0,0,0,0,0,748,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000017',1147642496,'3','pbversion0000000000001','approved','nav2_off_center.jpg','nav2_off_center.jpg','style1/nav2_off_center.jpg','3','7','12',NULL,0,0,0,0,0,837,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000015',1147642496,'3','pbversion0000000000001','approved','nav1_on_right.jpg','nav1_on_right.jpg','style1/nav1_on_right.jpg','3','7','12',NULL,0,0,0,0,0,1134,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000014',1147642495,'3','pbversion0000000000001','approved','nav1_on_left.jpg','nav1_on_left.jpg','style1/nav1_on_left.jpg','3','7','12',NULL,0,0,0,0,0,1195,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000013',1147642495,'3','pbversion0000000000001','approved','nav1_on.jpg','nav1_on.jpg','style1/nav1_on.jpg','3','7','12',NULL,0,0,0,0,0,2426,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000011',1147642495,'3','pbversion0000000000001','approved','nav1_off_left.jpg','nav1_off_left.jpg','style1/nav1_off_left.jpg','3','7','12',NULL,0,0,0,0,0,1230,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000012',1147642495,'3','pbversion0000000000001','approved','nav1_off_right.jpg','nav1_off_right.jpg','style1/nav1_off_right.jpg','3','7','12',NULL,0,0,0,0,0,1178,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000010',1147642494,'3','pbversion0000000000001','approved','nav1_off_center.jpg','nav1_off_center.jpg','style1/nav1_off_center.jpg','3','7','12',NULL,0,0,0,0,0,1468,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000009',1147642494,'3','pbversion0000000000001','approved','nav1_off.jpg','nav1_off.jpg','style1/nav1_off.jpg','3','7','12',NULL,0,0,0,0,0,2591,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000007',1147642493,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style1/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,1149,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000001',1147642492,'3','pbversion0000000000001','approved','WebGUI 7 Style 1','WebGUI 7 Style 1','root/import/webgui-7-style-1','3','7','12',NULL,0,0,0,0,0,325,NULL,0,1,0,1242380142,NULL,0),('SynConXSLT000000000001',1124395707,'3','pbversion0000000000001','approved','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT','xslt/rss0.9.xsl','3','7','12',NULL,0,0,0,0,0,5040,NULL,0,1,0,1247779653,NULL,0),('SynConXSLT000000000002',1124395707,'3','pbversion0000000000001','approved','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT','xslt/rss0.91.xsl','3','7','12',NULL,0,0,0,0,0,4717,NULL,0,1,0,1247779654,NULL,0),('SynConXSLT000000000003',1124395707,'3','pbversion0000000000001','approved','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT','xslt/rss1.0.xsl','3','7','12',NULL,0,0,0,0,0,5186,NULL,0,1,0,1247779654,NULL,0),('SynConXSLT000000000004',1124395707,'3','pbversion0000000000001','approved','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT','xslt/rss2.0.xsl','3','7','12',NULL,0,0,0,0,0,4852,NULL,0,1,0,1247779654,NULL,0),('PBtmpl0000000000000036',1129049186,'3','pbversion0000000000001','approved','Default Admin Toggle Macro','Default Admin Toggle Macro','default_admin_toggle_macro','3','7','12',NULL,0,1,0,0,0,448,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000037',1129049186,'3','pbversion0000000000001','approved','Default Account Macro','Default Account Macro','default_account_macro','3','7','12',NULL,0,1,0,0,0,479,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000038',1129049186,'3','pbversion0000000000001','approved','Default Editable Toggle Macro','Default Editable Toggle Macro','default_editable_toggle_macro','3','7','12',NULL,0,1,0,0,0,460,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000040',1129049186,'3','pbversion0000000000001','approved','Default Group Add Macro','Default Group Add Macro','default_group_add_macro','3','7','12',NULL,0,1,0,0,0,432,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000041',1129049186,'3','pbversion0000000000001','approved','Default Group Delete Macro','Default Group Delete Macro','default_group_delete_macro','3','7','12',NULL,0,1,0,0,0,444,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000042',1129049186,'3','pbversion0000000000001','approved','Default Homelink','Default Homelink','default_homelink','3','7','12',NULL,0,1,0,0,0,459,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000043',1129049186,'3','pbversion0000000000001','approved','Default LoginToggle','Default LoginToggle','default_logintoggle','3','7','12',NULL,0,1,0,0,0,475,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000045',1129049186,'3','pbversion0000000000001','approved','Default Make Printable','Default Make Printable','default_make_printable','3','7','12',NULL,0,1,0,0,0,500,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000091',1129049189,'3','pbversion0000000000001','approved','File no icon','File no icon','file_no_icon','3','7','12',NULL,0,1,0,0,0,391,NULL,0,1,0,1242380160,NULL,0),('PBtmpl0000000000000132',1129049190,'3','pbversion0000000000001','approved','Empty','Empty','empty','3','7','12',NULL,0,1,0,0,0,296,NULL,0,1,0,1242380161,NULL,0),('PBtmpl0000000000000140',1129573244,'3','pbversion0000000000001','approved','Default Shortcut','Default Shortcut','pbtmpl0000000000000140','3','7','12',NULL,0,1,0,0,0,1719,NULL,0,1,0,1242380161,NULL,0),('PBtmplHelp000000000001',1147642410,'3','pbversion0000000000001','approved','Help','Help','help','3','7','12',NULL,0,0,0,0,0,2162,'<style type=\"text/css\">\ndd {\n	margin-bottom: 15px;\n}\n\ndt {\n	font-weight: bold;	\n}\n</style>\n\n',0,1,0,1242380162,'<style type=\"text/css\">dd{margin-bottom:15px;}dt{font-weight:bold;}</style>',0),('ProjectManagerTMPL0004',1222574693,'3','pbversion0000000000001','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,8699,'<style type=\"text/css\">\r\n.PM_small {\r\n	font-size:8pt;\r\n}\r\ntr.clearNoBG a {\r\n	text-decoration:none;\r\n	color:navy;\r\n}\r\n</style>\r\n',0,1,0,1242380162,'<style type=\"text/css\">.PM_small{font-size:8pt;}tr.clearNoBG a{text-decoration:none;color:navy;}</style>',0),('7-0-style0000000000071',1147642511,'3','pbversion0000000000001','approved','wg.jpg','wg.jpg','style3/wg.jpg','3','7','12',NULL,0,0,0,0,0,27499,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000070',1147642510,'3','pbversion0000000000001','approved','Style3 Coolmenu','Style3 Coolmenu','style3_coolmenu','3','7','12',NULL,0,0,0,0,0,377,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000004',1147642493,'3','pbversion0000000000001','approved','gui_bottom.jpg','gui_bottom.jpg','style1/gui_bottom.jpg','3','7','12',NULL,0,0,0,0,0,11011,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000002',1147642492,'3','pbversion0000000000001','approved','body_bg.jpg','body_bg.jpg','style1/body_bg.jpg','3','7','12',NULL,0,0,0,0,0,598,NULL,0,1,0,1242380142,NULL,0),('PBtmpl0000000000000006',1147642414,'3','pbversion0000000000001','approved','Default LDAP Login Template','Default LDAP Login Template','default_ldap_login_template','3','7','12',NULL,0,1,0,0,0,1945,NULL,0,1,0,1242380152,NULL,0),('PBtmpl0000000000000047',1147642414,'3','pbversion0000000000001','approved','Default Message Board','Default Message Board','default_message_board','3','7','12',NULL,0,1,0,0,0,5583,'<style type=\"text/css\">\n.defaultMessageBoard {\n\n}\n.defaultMessageBoard .tableHeader{\n	font-weight:bold;\n	border-bottom:solid gray 3px;\n	text-align:center;\n}\n.defaultMessageBoard td {\n	font-family:arial;\n	font-size:9pt;\n	border-bottom:solid gray 1px;\n}\n.defaultMessageBoard td a {\n	color:#29587E;\n}\n.defaultMessageBoard td.even {\n	background-color:#DADADA;\n	border-bottom:solid gray 1px;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n</style>',0,1,0,1242380153,'<style type=\"text/css\">.defaultMessageBoard{}.defaultMessageBoard .tableHeader{font-weight:bold;border-bottom:solid gray 3px;text-align:center;}.defaultMessageBoard td{font-family:arial;font-size:9pt;border-bottom:solid gray 1px;}.defaultMessageBoard td a{color:#29587E;}.defaultMessageBoard td.even{background-color:#DADADA;border-bottom:solid gray 1px;}h2{font-family:arial;margin-top:3px;margin-bottom:3px;}</style>',0),('TimeTrackingTMPL000002',1147642417,'3','pbversion0000000000001','approved','Default Time Tracking Manager View','Default Time Tracking Manager View','default-tt-template-manager','3','7','12',NULL,0,0,0,0,0,408,'	',0,1,0,1242380163,NULL,0),('PBtmpl0000000000000013',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Login Template','Default WebGUI Login Template','default_webgui_login_template','3','7','12',NULL,0,1,0,0,0,2230,NULL,0,1,0,1242380152,NULL,0),('PBtmpl0000000000000012',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template','default_webgui_password_reset_template','3','7','12',NULL,0,1,0,0,0,2055,NULL,0,1,0,1242380152,NULL,0),('PBtmpl0000000000000057',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt','default_webgui_yes/no_prompt','3','7','12',NULL,0,1,0,0,0,793,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000107',1147642420,'3','pbversion0000000000001','approved','File with size','File with size','file_with_size','3','7','12',NULL,0,1,0,0,0,661,NULL,0,1,0,1242380160,NULL,0),('WVtmpl0000000000000001',1147642426,'3','pbversion0000000000001','approved','Random Thread Macro Default Template','Random Thread Macro Default Template','randomthread-template','3','7','12',NULL,0,0,0,0,0,9130,NULL,0,1,0,1242380165,NULL,0),('PBtmplBlankStyle000001',1147642431,'3','pbversion0000000000001','approved','WebGUI 6 Blank Style','WebGUI 6 Blank Style','pbtmplblankstyle000001','3','7','12',NULL,0,1,0,0,0,1396,NULL,0,1,0,1242380162,NULL,0),('7-0-style0000000000005',1147642493,'3','pbversion0000000000001','approved','header.jpg','header.jpg','style1/header.jpg','3','7','12',NULL,0,0,0,0,0,45014,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000008',1147642494,'3','pbversion0000000000001','approved','nav1_center_on.jpg','nav1_center_on.jpg','style1/nav1_center_on.jpg','3','7','12',NULL,0,0,0,0,0,1382,NULL,0,1,0,1242380143,NULL,0),('bX5rYxb6tZ9docY6sUhBlw',1147642514,'3','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started/getting-started','3','7','4',NULL,0,1,0,0,0,679,NULL,0,1,0,1242380147,NULL,0),('IWFxZDyGhQ3-SLZhELa3qw',1147642514,'3','pbversion0000000000001','approved','Key Benefits','Key Benefits','home/key-benefits','3','7','4',NULL,0,1,0,0,0,2052,NULL,0,1,0,1242380149,NULL,0),('m4YJFaqzultnB_sj1Uq0aw',1147642514,'3','pbversion0000000000001','approved','Ad','Ad','home/ad','3','7','4',NULL,0,1,0,0,0,92376,NULL,0,1,0,1242380150,NULL,0),('7-0-style0000000000045',1147642503,'3','pbversion0000000000001','approved','pb_wg_bg.jpg','pb_wg_bg.jpg','style2/pb_wg_bg.jpg','3','7','12',NULL,0,0,0,0,0,21720,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000021',1147642497,'3','pbversion0000000000001','approved','nav2_on_right.jpg','nav2_on_right.jpg','style1/nav2_on_right.jpg','3','7','12',NULL,0,0,0,0,0,720,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000020',1147642497,'3','pbversion0000000000001','approved','nav2_on_left.jpg','nav2_on_left.jpg','style1/nav2_on_left.jpg','3','7','12',NULL,0,0,0,0,0,732,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000016',1147642496,'3','pbversion0000000000001','approved','nav2_center_on.jpg','nav2_center_on.jpg','style1/nav2_center_on.jpg','3','7','12',NULL,0,0,0,0,0,807,NULL,0,1,0,1242380143,NULL,0),('PBasset000000000000003',1147642437,'3','pbversion0000000000001','approved','Media','Media','media','3','7','12',NULL,0,0,0,0,0,296,NULL,0,1,0,1242380151,NULL,0),('OhdaFLE7sXOzo_SIP2ZUgA',1147642513,'3','pbversion0000000000001','approved','Welcome','Welcome','home/welcome','3','7','4',NULL,0,1,0,0,0,1863,NULL,0,1,0,1242380151,NULL,0),('nbSrhXZQuxIjhWFaFPSuVA',1147642465,'3','pbversion0000000000001','approved','AdminConsole','AdminConsole','root/import/adminconsole','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1242380150,NULL,0),('S1A9iAwKcQQ6P20uTqw-Ew',1147642468,'3','pbversion0000000000001','approved','Dashboard','Dashboard','root/import/dashboard','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380162,NULL,0),('71e17KeduiXgODLMlUxiow',1222803352,'3','pbversion0000000000001','approved','project','project','root/import/projectmanager/project','3','7','12',NULL,0,0,0,0,0,342,NULL,0,1,0,1242380145,NULL,0),('N13SD1Fpqk00UgBt1Z8ivQ',1147642470,'3','pbversion0000000000001','approved','HttpProxy','HttpProxy','root/import/httpproxy','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380150,NULL,0),('3uuBf8cYuj1sew2OJXl9tg',1147642470,'3','pbversion0000000000001','approved','InOutBoard','InOutBoard','root/import/inoutboard','3','7','12',NULL,0,0,0,0,0,307,NULL,0,1,0,1242380142,NULL,0),('ProjectManagerTMPL0002',1222574693,'3','pbversion0000000000001','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,12801,'<style type=\"text/css\">\r\n	body, html {\r\n		margin:0px;\r\n		padding:0px;\r\n	}\r\n	.project {\r\n		position:relative;\r\n		margin-top:5px;\r\n		margin-left:5px;\r\n	}\r\n	.project td {\r\n		border:solid silver 1px;\r\n		border-bottom:solid gray 1px;\r\n		font-size:9pt;\r\n		font-family:arial;		\r\n	}\r\n	.project a {\r\n	    color:#000000;\r\n		font-weight: normal;\r\n		font-size: 9pt;\r\n		text-decoration: none;\r\n	}\r\n	\r\n	.project a:hover {\r\n	    color:#7AB7E9;\r\n		font-weight: normal;\r\n		font-size: 9pt;\r\n		text-decoration: none;\r\n	}\r\n	\r\n	.taskname {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 295px;\r\n    }\r\n	.taskduration {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 25px;\r\n	}\r\n	.taskdate {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 68px;\r\n	}\r\n	.taskdependant {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 20px;\r\n	}\r\n	tr.monthNames td {		\r\n		text-align:center;		\r\n	}\r\n	tr.dates td {\r\n		width:16px;\r\n	}\r\n	div.scroller {		\r\n		overflow:scroll;		\r\n		position:relative;\r\n		width:400px;		\r\n	}\r\n	\r\n	* html div.scroller {\r\n		overflow-x:scroll;\r\n	}\r\n	\r\n	td.empty {\r\n		background-color:transparent;\r\n		border-style:none;\r\n		height:20px;\r\n	}\r\n	\r\n	div.barPositions {\r\n		position:relative;\r\n	}\r\n	div.projectBar {\r\n		position:absolute;\r\n		height:10px;\r\n		z-index:2;\r\n		padding:0px;\r\n		margin:0px;\r\n		font-size:1pt;\r\n	}\r\n	div.statusBar {	\r\n		background-color:#000;\r\n		position:absolute;	\r\n		height:5px;\r\n		z-index:3;\r\n		padding:0px;\r\n		top:2px;\r\n		margin:0px;		\r\n		font-size:1pt;		\r\n	}\r\n	\r\n	div.projectLineH {		\r\n		background: url(\'images/dot.gif\') top repeat-x;		\r\n		font-size:1pt;\r\n		text-align:right;\r\n		position:absolute;\r\n	}		\r\n	div.projectLineV {\r\n		width:1px;\r\n		background-color:black;\r\n		position:relative;\r\n		font-size:1pt;	\r\n		height:100%;\r\n		float:right;\r\n	}\r\n	\r\n	div.projectLabel {\r\n		position:absolute;\r\n		margin-top:-3px;\r\n		white-space:nowrap;\r\n		font-family: verdana;\r\n		font-size:8px;\r\n	}\r\n	\r\n	div.milestone {\r\n		color:#000000;\r\n		position:absolute;\r\n		z-index:4;\r\n		margin:0px;\r\n		padding:0px;		\r\n		margin-top:-3px;\r\n		font-size: 10px;\r\n		font-family: times;\r\n	}\r\n	\r\n	#links {\r\n		margin-top:7px;\r\n		margin-left:5px;\r\n		font-family:arial;\r\n		font-size:9pt;\r\n	}\r\n	\r\n	#links a {\r\n		color:#7AB7E9;\r\n	}\r\n</style>\r\n\r\n<style>\r\n.popUp {\r\n			width:100%;\r\n			border:solid black 0px;\r\n			background-color:#F5F5F5;\r\n		}\r\n		.popUp td {\r\n			font-size:9pt;	\r\n			font-family:arial;\r\n			border-top:solid #E0E0E0 1px;\r\n		}	\r\n		.popUp tr.clear td {\r\n			border-style:none;\r\n			background-color:#F0F0F0;\r\n		}\r\n		.popUp tr.clearNoBG td {\r\n			border-style:none;\r\n		}\r\n		.popUp td.header {\r\n			font-weight:bold;\r\n		}\r\n		.popUp td span.header {\r\n			font-weight:bold;\r\n		}\r\n		a.saveBtn {\r\n			width:40px;\r\n			height:15px;\r\n			background-color:silver;\r\n			padding:1px;\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:white;\r\n			border:solid gray 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;\r\n			display:block;\r\n			float:right;\r\n			text-align:center;\r\n		}\r\n		a.saveBtn:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n</style>\r\n',0,1,0,1242380162,'<style type=\"text/css\">body,html{margin:0px;padding:0px;}.project{position:relative;margin-top:5px;margin-left:5px;}.project td{border:solid silver 1px;border-bottom:solid gray 1px;font-size:9pt;font-family:arial;}.project a{color:#000000;font-weight:normal;font-size:9pt;text-decoration:none;}.project a:hover{color:#7AB7E9;font-weight:normal;font-size:9pt;text-decoration:none;}.taskname{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:295px;}.taskduration{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:25px;}.taskdate{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:68px;}.taskdependant{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:20px;}tr.monthNames td{text-align:center;}tr.dates td{width:16px;}div.scroller{overflow:scroll;position:relative;width:400px;}* html div.scroller{overflow-x:scroll;}td.empty{background-color:transparent;border-style:none;height:20px;}div.barPositions{position:relative;}div.projectBar{position:absolute;height:10px;z-index:2;padding:0px;margin:0px;font-size:1pt;}div.statusBar{background-color:#000;position:absolute;height:5px;z-index:3;padding:0px;top:2px;margin:0px;font-size:1pt;}div.projectLineH{background:url(\'images/dot.gif\') top repeat-x;font-size:1pt;text-align:right;position:absolute;}div.projectLineV{width:1px;background-color:black;position:relative;font-size:1pt;height:100%;float:right;}div.projectLabel{position:absolute;margin-top:-3px;white-space:nowrap;font-family:verdana;font-size:8px;}div.milestone{color:#000000;position:absolute;z-index:4;margin:0px;padding:0px;margin-top:-3px;font-size:10px;font-family:times;}#links{margin-top:7px;margin-left:5px;font-family:arial;font-size:9pt;}#links a{color:#7AB7E9;}</style><style>\r\n.popUp {\r\n			width:100%;\r\n			border:solid black 0px;\r\n			background-color:#F5F5F5;\r\n		}\r\n		.popUp td {\r\n			font-size:9pt;	\r\n			font-family:arial;\r\n			border-top:solid #E0E0E0 1px;\r\n		}	\r\n		.popUp tr.clear td {\r\n			border-style:none;\r\n			background-color:#F0F0F0;\r\n		}\r\n		.popUp tr.clearNoBG td {\r\n			border-style:none;\r\n		}\r\n		.popUp td.header {\r\n			font-weight:bold;\r\n		}\r\n		.popUp td span.header {\r\n			font-weight:bold;\r\n		}\r\n		a.saveBtn {\r\n			width:40px;\r\n			height:15px;\r\n			background-color:silver;\r\n			padding:1px;\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:white;\r\n			border:solid gray 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;\r\n			display:block;\r\n			float:right;\r\n			text-align:center;\r\n		}\r\n		a.saveBtn:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n</style>',0),('cj2y4papTVGZRFdwTI-_fw',1147642475,'3','pbversion0000000000001','approved','MessageBoard','MessageBoard','root/import/messageboard','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1242380147,NULL,0),('bBzO4CWjqU_ile3gf5Iypw',1147642475,'3','pbversion0000000000001','approved','MultiSearch','MultiSearch','root/import/multisearch','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1242380147,NULL,0),('jEz8iTGNWEt2I05IhVV19Q',1147642477,'3','pbversion0000000000001','approved','Operation/RedeemSubscription','Operation/RedeemSubscription','root/import/operation/redeemsubscription','3','7','12',NULL,0,0,0,0,0,368,NULL,0,1,0,1242380149,NULL,0),('Da6KWn805L4B5e4HFgQRQA',1147642479,'3','pbversion0000000000001','approved','Shortcut','Shortcut','root/import/shortcut','3','7','12',NULL,0,0,0,0,0,301,NULL,0,1,0,1242380148,NULL,0),('bbiA9Zq5Gy2oCFBlILO3QA',1147642480,'3','pbversion0000000000001','approved','SQLReport','SQLReport','root/import/sqlreport','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380147,NULL,0),('Efe2W0UgrSRDltNJ87jlfg',1147642480,'3','pbversion0000000000001','approved','StockData','StockData','root/import/stockdata','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380148,NULL,0),('RrV4aAPnn4dM0ZcU3OXnlw',1147642480,'3','pbversion0000000000001','approved','style','style','root/import/style','3','7','12',NULL,0,0,0,0,0,292,NULL,0,1,0,1242380162,NULL,0),('9wKWdum0_8z-OhhquWLtSQ',1147642483,'3','pbversion0000000000001','approved','WeatherData','WeatherData','root/import/weatherdata','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1242380146,NULL,0),('CSN-ZON7Uwv8kxf3F1fh5Q',1147642484,'3','pbversion0000000000001','approved','ZipArchiveAsset','ZipArchiveAsset','root/import/ziparchiveasset','3','7','12',NULL,0,0,0,0,0,322,NULL,0,1,0,1242380147,NULL,0),('TCtybxdqmdwdvRn555zpCQ',1147642484,'3','pbversion0000000000001','approved','RichEdit','RichEdit','root/import/richedit','3','7','12',NULL,0,0,0,0,0,301,NULL,0,1,0,1242380163,NULL,0),('PBtmpl0000000000000044',1148579524,'3','pbversion0000000000001','approved','Default Login Box','Default Login Box','default_login_box','3','7','12',NULL,0,1,0,0,0,1868,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000092',1148579524,'3','pbversion0000000000001','approved','Horizontal Login Box','Horizontal Login Box','horizontal_login_box','3','7','12',NULL,0,1,0,0,0,2061,NULL,0,1,0,1242380160,NULL,0),('PBtmpl0000000000000039',1154535073,'3','pbversion0000000000001','approved','Default File Macro','Default File Macro','default_file_macro','3','7','12',NULL,0,1,0,0,0,630,NULL,0,1,0,1242380153,NULL,0),('Szs5eev3OMssmnsyLRZmWA',1213317790,'3','pbversion0000000000001','approved','Tell A Friend','Tell A Friend','tell_a_friend/tell_a_friend','3','7','3',NULL,0,1,0,0,0,2062,NULL,0,1,0,1242380163,NULL,0),('PBtmpl0000000000000111',1154535074,'3','pbversion0000000000001','approved','Make Page Printable','Make Page Printable','make_page_printable','3','7','12',NULL,0,1,0,0,0,3579,NULL,0,1,0,1242380160,NULL,0),('PBtmpl0000000000000053',1154535074,'3','pbversion0000000000001','approved','Subscription code redemption','Subscription code redemption','subscription_code_redemption','3','7','12',NULL,0,1,0,0,0,575,NULL,0,1,0,1242380153,NULL,0),('WikiPageEditTmpl000001',1221692341,'3','pbversion0000000000001','approved','Default Wiki Page Edit','Default Wiki Page Edit','default-wiki-page-edit','3','7','12',NULL,0,0,0,0,0,2251,'\n',0,1,0,1242380164,NULL,0),('ProjectManagerTMPL0006',1157679165,'3','pbversion0000000000001','approved','Default Resource List','Default Resource List','default-pm-resource-list','3','7','12',NULL,0,0,0,0,0,1793,NULL,0,1,0,1242380162,NULL,0),('ProjectManagerTMPL0003',1159989349,'3','pbversion0000000000001','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,3753,NULL,0,1,0,1242380162,NULL,0),('pbproto000000000000002',1163019036,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-prototype','3','7','12',NULL,0,0,0,1,0,595,NULL,0,1,0,1263358861,NULL,0),('WikiPHTmpl000000000001',1165460175,'3','pbversion0000000000001','approved','Default Page History','Default Page History','default-wiki-page-history','3','7','12',NULL,0,0,0,0,0,653,NULL,0,1,0,1242380165,NULL,0),('WikiMPTmpl000000000001',1165460175,'3','pbversion0000000000001','approved','Default Most Popular','Default Most Popular','default-wiki-most-popular','3','7','12',NULL,0,0,0,0,0,1029,NULL,0,1,0,1242380164,NULL,0),('IOB0000000000000000002',1166019641,'3','pbversion0000000000001','approved','Default InOutBoard Report Template','Default InOutBoard Report Template','iob-report-template','3','7','12',NULL,0,0,0,0,0,2719,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob a {\n	color:#29587E;\n}\n.iob .formDescription {\n	background-color:#DADADA;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}\n</style>',0,1,0,1242380149,'<style type=\"text/css\">.fontSettings{font-family:arial;font-size:9pt;}h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.iob td{font-family:arial;font-size:9pt;border:solid silver 1px;}.iob a{color:#29587E;}.iob .formDescription{background-color:#DADADA;}.pagination{-moz-box-sizing:border-box;background:#C0C0C0;width:100%;text-align:center;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.pagination a{color:white;}</style>',0),('WikiSearchTmpl00000001',1168480840,'3','pbversion0000000000001','approved','Default Wiki Search','Default Wiki Search','default-wiki-search','3','7','12',NULL,0,0,0,0,0,2432,'\n\n',0,1,0,1242380165,NULL,0),('WikiRCTmpl000000000001',1169092823,'3','pbversion0000000000001','approved','Default Recent Changes','Default Recent Changes','default-wiki-recent-changes','3','7','12',NULL,0,0,0,0,0,1645,NULL,0,1,0,1242380165,NULL,0),('ZipArchiveTMPL00000001',1169738426,'3','pbversion0000000000001','approved','Default Zip Archive Template','Default Zip Archive Template','zip-archive-template','3','7','12',NULL,0,0,0,0,0,1040,NULL,0,1,0,1242380165,NULL,0),('IOB0000000000000000001',1169795123,'3','pbversion0000000000001','approved','Default InOutBoard Template','Default InOutBoard Template','iob-template','3','7','12',NULL,0,0,0,0,0,3815,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob {\n			\n}	\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob td.odd {\n	background-color:#DADADA;\n}\n.iob td.noBorder {\n	border:none;\n}	\n.iob a {\n	color:#29587E;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}   \n\n</style>',0,1,0,1242380149,'<style type=\"text/css\">.fontSettings{font-family:arial;font-size:9pt;}h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.iob{}.iob td{font-family:arial;font-size:9pt;border:solid silver 1px;}.iob td.odd{background-color:#DADADA;}.iob td.noBorder{border:none;}.iob a{color:#29587E;}.pagination{-moz-box-sizing:border-box;background:#C0C0C0;width:100%;text-align:center;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.pagination a{color:white;}</style>',0),('SQLReportDownload00001',1171466654,'3','pbversion0000000000001','approved','SQLReport Download Default Template','untitled','SQLReportDownload0001','3','7','12',NULL,0,0,0,0,0,6145,NULL,0,1,0,1242380162,NULL,0),('newsletter000000000001',1185754569,'3','pbversion0000000000001','approved',' Summary Newsletter (default)',' Summary Newsletter','newsletterdefaulttemplate','3','7','3',NULL,0,0,0,0,0,668,NULL,0,1,0,1242380151,NULL,0),('PBtmpl0000000000000010',1227026287,'3','pbversion0000000000001','approved','Default WebGUI Account Display Template','Default WebGUI Account Display Template','default_webgui_account_display_template','3','7','12',NULL,0,1,0,0,0,2743,NULL,0,1,0,1242380152,NULL,0),('PBtmpl0000000000000014',1227218041,'3','pbversion0000000000001','approved','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template','default_webgui_password_recovery_template','3','7','12',NULL,0,1,0,0,0,3029,NULL,0,1,0,1242380152,NULL,0),('PBtmpl0000000000000004',1227026214,'3','pbversion0000000000001','approved','Default LDAP Account Display Template','Default LDAP Account Display Template','default_ldap_account_display_template','3','7','12',NULL,0,1,0,0,0,1348,NULL,0,1,0,1242380152,NULL,0),('WikiFrontTmpl000000001',1185754572,'3','pbversion0000000000001','approved','Default Wiki Front Page','Default Wiki Front Page','default-wiki-front-page','3','7','12',NULL,0,0,0,0,0,2185,NULL,0,1,0,1242380164,NULL,0),('tempspace0000000000000',1185754574,'3','pbversion0000000000001','approved','Tempspace','Tempspace','tempspace','3','7','3',NULL,0,0,0,0,0,307,NULL,0,1,0,1242380163,NULL,0),('MBZK_LPVzqhb4TV4mMRTJg',1197330678,'3','pbversion0000000000001','approved','admin_ie7.css','admin_ie7.css','root/import/gallery-templates/admin_ie7.css','3','7','3',NULL,0,1,0,0,0,380,NULL,0,1,0,1244130527,NULL,0),('bANo8aiAPA7aY_oQZKxIWw',1197330678,'3','pbversion0000000000001','approved','rss.gif','rss.gif','root/import/gallery-templates/images/rss.gif','3','7','3',NULL,0,1,0,0,0,1389,NULL,0,1,0,1244130527,NULL,0),('fdd8tGExyVwHyrB8RBbKXg',1197330839,'3','pbversion0000000000001','approved','next.gif','next.gif','root/import/gallery-templates/images/next.gif','3','7','3',NULL,0,1,0,0,0,1676,NULL,0,1,0,1244130527,NULL,0),('BpisgHl4ZDcSECJp6oib1w',1197330840,'3','pbversion0000000000001','approved','play.gif','play.gif','root/import/gallery-templates/images/play.gif','3','7','3',NULL,0,1,0,0,0,2113,NULL,0,1,0,1244130527,NULL,0),('zshreRgPAXtnF0DtVbQ1Yg',1197330840,'3','pbversion0000000000001','approved','previous.gif','previous.gif','root/import/gallery-templates/images/previous.gif','3','7','3',NULL,0,1,0,0,0,1682,NULL,0,1,0,1244130527,NULL,0),('TimeTrackingTMPL000001',1201205738,'3','pbversion0000000000001','approved','Default Time Tracking User View','Default Time Tracking User View','default-tt-template-user','3','7','12',NULL,0,0,0,0,0,18629,'\n	<style type=\"text/css\">\n		.timeTracking02 {			\n			width:850px;\n		}\n		.timeTracking02 td {\n			border:solid silver 1px;\n			border-bottom:solid gray 1px;\n			font-size:9pt;\n			font-family:arial;			\n		}\n		tr.tt_title td {\n			font-weight:bold;			\n			background-color:#F0F0F0;\n			border-style:none;\n			font-size:11pt;\n		}\n		tr.tt_header td {\n			font-weight:bold;\n			text-align:center;		\n		}\n		tr.tt_empty td {\n			border-style:none;\n		}\n		\n		a.PM_blueLink {\n			color:#29587E;\n			text-decoration:none;\n			font-weight:bold;\n		}\n		a.PM_blueLink:hover {\n			text-decoration:underline;\n		}	\n		\n		.pt-select {\n	       font-weight: normal;\n	       color: black;\n  	       width: 175px;\n        }\n		.date-select {\n		   font-weight: normal;\n	           color: black;\n  	           width: 110px;\n		}\n	</style>\n',0,1,0,1242380163,'<style type=\"text/css\">.timeTracking02{width:850px;}.timeTracking02 td{border:solid silver 1px;border-bottom:solid gray 1px;font-size:9pt;font-family:arial;}tr.tt_title td{font-weight:bold;background-color:#F0F0F0;border-style:none;font-size:11pt;}tr.tt_header td{font-weight:bold;text-align:center;}tr.tt_empty td{border-style:none;}a.PM_blueLink{color:#29587E;text-decoration:none;font-weight:bold;}a.PM_blueLink:hover{text-decoration:underline;}.pt-select{font-weight:normal;color:black;width:175px;}.date-select{font-weight:normal;color:black;width:110px;}</style>',0),('CalendarPrintMonth0001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Month','Default Calendar Print Month','root/import/calendar-templates/default-calendar-print-month','3','7','12',NULL,0,0,0,0,0,2436,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1242380147,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('CalendarPrintWeek00001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Week','Default Calendar Print Week','root/import/calendar-templates/default-calendar-print-week','3','7','12',NULL,0,0,0,0,0,2636,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1242380147,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('CalendarPrintDay000001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Day','Default Calendar Print Day','root/import/calendar-templates/default-calendar-print-day','3','7','12',NULL,0,0,0,0,0,2376,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1242380147,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('PBrichedit000000000001',1207240829,'3','pbversion0000000000001','approved','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit','content_managers_rich_edit','3','7','12',NULL,0,0,0,0,0,549,NULL,0,1,0,1242380152,NULL,0),('3qiVYhNTXMVC5hfsumVHgg',1206743306,'3','pbversion0000000000001','approved','browserdetect.js','browserdetect.js','root/import/gallery-templates/browserdetect.js','3','7','3',NULL,0,1,0,0,0,4375,NULL,0,1,0,1244130528,NULL,0),('F7MAQ-cpuvQ1KuC7J4P5zQ',1222803673,'3','pbversion0000000000001','approved','View','View','root/import/profile/view','3','7','12',NULL,0,0,0,0,0,326,NULL,0,1,0,1242380148,NULL,0),('Tsg7xmPYv782j6IVz7yHFg',1213244777,'3','pbversion0000000000001','approved','Calendar Templates','Calendar Templates','root/import/calendar-templates','3','7','12',NULL,0,1,0,0,0,353,NULL,0,1,0,1242380164,NULL,0),('Q4uX_C557arTp6D_jwB1jQ',1222803760,'3','pbversion0000000000001','approved','Wiki','Wiki','root/import/wiki','3','12','12',NULL,0,0,0,0,0,312,NULL,0,1,0,1242380162,NULL,0),('4qh0kIsFUdd4Ox-Iu1JZgg',1208725439,'3','pbversion0000000000001','approved','EMS','EMS','root/import/ems','3','7','12',NULL,0,1,0,0,0,321,NULL,0,1,0,1242380142,NULL,0),('PsFn7dJt4wMwBa8hiE3hOA',1208558071,'3','pbversion0000000000001','approved','Print Badge (Default)','Print Badge (Default)','root/import/ems/print-badge-default','3','7','12',NULL,0,1,0,0,0,2304,NULL,0,1,0,1242380162,NULL,0),('yBwydfooiLvhEFawJb0VTQ',1208629936,'3','pbversion0000000000001','approved','Print Ticket (Default)','Print Ticket (Default)','root/import/ems/print-ticket-default','3','7','12',NULL,0,1,0,0,0,2368,NULL,0,1,0,1242380165,NULL,0),('NywJYmGWe1f6EBXJnWg9Xg',1222803638,'3','pbversion0000000000001','approved','Profile','Profile','root/import/profile','3','7','12',NULL,0,1,0,0,0,320,NULL,0,1,0,1242380151,NULL,0),('AgyFhx3eXlfZXNp2MkrsiQ',1222803665,'3','pbversion0000000000001','approved','Edit','Edit','root/import/profile/edit','3','7','12',NULL,0,0,0,0,0,326,NULL,0,1,0,1242380146,NULL,0),('_hELmIJfgbAyXFNqPyApxQ',1213309523,'3','pbversion0000000000001','approved','admin.css','admin.css','root/import/gallery-templates/admin.css','3','7','3',NULL,0,1,0,0,0,3478,NULL,0,1,0,1244130527,NULL,0),('2ci_v2d4x4uvyjTRlC49OA',1209499188,'3','pbversion0000000000001','approved','moveDown.gif','moveDown.gif','root/import/gallery-templates/images/movedown.gif','3','7','3',NULL,0,1,0,0,0,784,NULL,0,1,0,1244130527,NULL,0),('O-EsSzKgAk1KolFT-x_KsA',1209499188,'3','pbversion0000000000001','approved','moveUp.gif','moveUp.gif','root/import/gallery-templates/images/moveup.gif','3','7','3',NULL,0,1,0,0,0,772,NULL,0,1,0,1244130527,NULL,0),('POVcY79vIqAHR8OfGt36aw',1209499189,'3','pbversion0000000000001','approved','pagination_button.jpg','pagination_button.jpg','root/import/gallery-templates/images/pagination_button.jpg','3','7','12',NULL,0,1,0,0,0,1050,NULL,0,0,0,1244130527,NULL,0),('hIB-z34r8Xl-vYVYCkKr-w',1209499189,'3','pbversion0000000000001','approved','bar-btn-r.jpg','bar-btn-r.jpg','root/import/gallery-templates/images/bar-btn-r.jpg','3','7','12',NULL,0,1,0,0,0,830,NULL,0,0,0,1244130527,NULL,0),('-mPUoFlYcjqjPUPRLAlxNQ',1209499189,'3','pbversion0000000000001','approved','search-field-r.jpg','search-field-r.jpg','root/import/gallery-templates/images/search-field-r.jpg','3','7','12',NULL,0,1,0,0,0,848,NULL,0,0,0,1244130528,NULL,0),('MDpUOR-N8KMyt1J7Hh_h4w',1209499189,'3','pbversion0000000000001','approved','bar-btn.jpg','bar-btn.jpg','root/import/gallery-templates/images/bar-btn.jpg','3','7','12',NULL,0,1,0,0,0,708,NULL,0,0,0,1244130528,NULL,0),('YfXKByTwDZVituMc4h13Dg',1209499189,'3','pbversion0000000000001','approved','pagination_bg.jpg','pagination_bg.jpg','root/import/gallery-templates/images/pagination_bg.jpg','3','7','12',NULL,0,1,0,0,0,1131,NULL,0,0,0,1244130528,NULL,0),('esko_HSU0Gh-uJZ1h3xRmQ',1209499189,'3','pbversion0000000000001','approved','search-field-l.jpg','search-field-l.jpg','root/import/gallery-templates/images/search-field-l.jpg','3','7','12',NULL,0,1,0,0,0,874,NULL,0,0,0,1244130528,NULL,0),('oSqpGswzpBG_ErdfYwIO8A',1209499189,'3','pbversion0000000000001','approved','top_bg.jpg','top_bg.jpg','root/import/gallery-templates/images/top_bg.jpg','3','7','12',NULL,0,1,0,0,0,692,NULL,0,0,0,1244130528,NULL,0),('MXJklShZvLLB_DSnZQmXrQ',1209499189,'3','pbversion0000000000001','approved','title_bg.jpg','title_bg.jpg','root/import/gallery-templates/images/title_bg.jpg','3','7','12',NULL,0,1,0,0,0,1658,NULL,0,0,0,1244130528,NULL,0),('BthxD5oJ0idmsyI3ioA2FA',1209499189,'3','pbversion0000000000001','approved','bar-btn-l.jpg','bar-btn-l.jpg','root/import/gallery-templates/images/bar-btn-l.jpg','3','7','12',NULL,0,1,0,0,0,845,NULL,0,0,0,1244130528,NULL,0),('aZ-1HYQamkRHYXvzAra8WQ',1209499189,'3','pbversion0000000000001','approved','search-field.jpg','search-field.jpg','root/import/gallery-templates/images/search-field.jpg','3','7','12',NULL,0,1,0,0,0,750,NULL,0,0,0,1244130528,NULL,0),('eRkb94OYcS5AdcrrerOP5Q',1209499189,'3','pbversion0000000000001','approved','rss.gif','rss.gif','root/import/gallery-templates/images/rss2.gif','3','7','12',NULL,0,1,0,0,0,1391,NULL,0,0,0,1244130528,NULL,0),('TbnkjAJQEASORXIpYqDkcA',1209499189,'3','pbversion0000000000001','approved','blank-image.jpg','blank-image.jpg','root/import/gallery-templates/images/blank-image.jpg','3','7','12',NULL,0,1,0,0,0,3084,NULL,0,0,0,1244130528,NULL,0),('er-3faBjY-hhlDcc5aKqdQ',1209499189,'3','pbversion0000000000001','approved','top_bg.jpg','top_bg.jpg','root/import/gallery-templates/images/top_bg2.jpg','3','7','12',NULL,0,1,0,0,0,693,NULL,0,0,0,1244130528,NULL,0),('8bFsu2FJUqHRUiHcozcVFw',1209499189,'3','pbversion0000000000001','approved','sub-btn-l.jpg','sub-btn-l.jpg','root/import/gallery-templates/images/sub-btn-l.jpg','3','7','12',NULL,0,1,0,0,0,844,NULL,0,0,0,1244130528,NULL,0),('34Aayx5eA320D8VfhdfDBw',1209499189,'3','pbversion0000000000001','approved','sub-btn-r.jpg','sub-btn-r.jpg','root/import/gallery-templates/images/sub-btn-r.jpg','3','7','12',NULL,0,1,0,0,0,824,NULL,0,0,0,1244130528,NULL,0),('TlhKOVmWblZOsAdqmhEpeg',1209499189,'3','pbversion0000000000001','approved','sub-btn.jpg','sub-btn.jpg','root/import/gallery-templates/images/sub-btn.jpg','3','7','12',NULL,0,1,0,0,0,702,NULL,0,0,0,1244130528,NULL,0),('Nx0ypjO3cN6QdZUBUEE0lA',1209499189,'3','pbversion0000000000001','approved','pic-title-bg.jpg','pic-title-bg.jpg','root/import/gallery-templates/images/pic-title-bg.jpg','3','7','12',NULL,0,1,0,0,0,865,NULL,0,0,0,1244130528,NULL,0),('CmFZLN7iPS7XXvUEsxKPKA',1209499190,'3','pbversion0000000000001','approved','row-2.jpg','row-2.jpg','root/import/gallery-templates/images/row-2.jpg','3','7','12',NULL,0,1,0,0,0,806,NULL,0,0,0,1244130528,NULL,0),('v_XBgwwZqgW1D5s4y05qfg',1209499190,'3','pbversion0000000000001','approved','addtl-info.gif','addtl-info.gif','root/import/gallery-templates/images/addtl-info.gif','3','7','12',NULL,0,1,0,0,0,914,NULL,0,0,0,1244130528,NULL,0),('4TdAkKoQbSCvI7QWcW889A',1209499190,'3','pbversion0000000000001','approved','row-1.jpg','row-1.jpg','root/import/gallery-templates/images/row-1.jpg','3','7','12',NULL,0,1,0,0,0,791,NULL,0,0,0,1244130528,NULL,0),('SAgK6eDPCG1cgkJ59WapHQ',1209499190,'3','pbversion0000000000001','approved','prev-btn.gif','prev-btn.gif','root/import/gallery-templates/images/prev-btn.gif','3','7','12',NULL,0,1,0,0,0,2015,NULL,0,0,0,1244130528,NULL,0),('XJYLuvGy9ubF7JNKyINtpA',1209499190,'3','pbversion0000000000001','approved','play-btn.gif','play-btn.gif','root/import/gallery-templates/images/play-btn.gif','3','7','12',NULL,0,1,0,0,0,2543,NULL,0,0,0,1244130528,NULL,0),('RWj7hyv2SpZuXxwj1Wocug',1209499190,'3','pbversion0000000000001','approved','next-btn.gif','next-btn.gif','root/import/gallery-templates/images/next-btn.gif','3','7','12',NULL,0,1,0,0,0,2045,NULL,0,0,0,1244130528,NULL,0),('aq8QElnlm3YufAoxRz9Pcg',1209499190,'3','pbversion0000000000001','approved','data-bg.jpg','data-bg.jpg','root/import/gallery-templates/images/data-bg.jpg','3','7','12',NULL,0,1,0,0,0,821,NULL,0,0,0,1244130528,NULL,0),('7fE8md51vTCcuJFOvxNaGA',1209503742,'3','pbversion0000000000001','approved','thumbnails.js','thumbnails.js','root/import/gallery-templates/thumbnails.js','3','7','3',NULL,0,1,0,0,0,5881,NULL,0,1,0,1244130528,NULL,0),('mTOiwwk3q4k9g5-XykXhPA',1218149728,'3','pbversion0000000000001','approved','Documentation','Documentation','documentation','3','7','3',NULL,0,0,0,0,0,561,NULL,0,1,0,1242380150,NULL,0),('TYo2Bwl7aafzTtdHlS-arQ',1211664878,'3','pbversion0000000000001','approved','Product','Product','root/import/product','3','7','12',NULL,0,0,0,0,0,320,NULL,0,1,0,1242380164,NULL,0),('gbnRhcWNk1iQe32LFEB5eQ',1212086102,'3','pbversion0000000000001','approved','Shelf','Shelf','root/import/shelf2','3','7','12',NULL,0,1,0,0,0,315,NULL,0,1,0,1242380149,NULL,0),('6tK47xsaIH-ELw0IBo0uRQ',1210777115,'3','pbversion0000000000001','approved','images','images','root/import/shelf2/images','3','7','12',NULL,0,1,0,0,0,330,NULL,0,1,0,1242380142,NULL,0),('_bZJ9LA_KNekZiFPaP2SeQ',1210777868,'3','pbversion0000000000001','approved','shelf-titles.jpg','shelf-titles.jpg','root/import/shelf2/images/shelf-titles.jpg','3','7','12',NULL,0,1,0,0,0,1038,NULL,0,0,0,1242380165,NULL,0),('4e-_rNs6mSWedZhQ_V5kJA',1210779672,'3','pbversion0000000000001','approved','shelf-ie.css','shelf-ie.css','root/import/shelf2/shelf-ie.css','3','7','12',NULL,0,1,0,0,0,1092,NULL,0,1,0,1242380142,NULL,0),('6D4Z-oruXPS6OlH_Kx8pBg',1209509389,'3','pbversion0000000000001','approved','images','images','root/import/thingy-templates/images','3','7','12',NULL,0,1,0,0,0,340,NULL,0,1,0,1242380142,NULL,0),('hQ7z33_jOYkQ8WNX5xy9Sw',1209509455,'3','pbversion0000000000001','approved','style-button.gif','style-button.gif','root/import/thingy-templates/images/style-button.gif','3','7','12',NULL,0,1,0,0,0,923,NULL,0,0,0,1242380149,NULL,0),('vWW_DcHiYSrKZOkkIfEfcQ',1209509433,'3','pbversion0000000000001','approved','row-2.jpg','row-2.jpg','root/import/thingy-templates/images/row-2.jpg','3','7','12',NULL,0,1,0,0,0,805,NULL,0,0,0,1242380164,NULL,0),('_bPYzRA87NTAUIKlfrJMHg',1209509433,'3','pbversion0000000000001','approved','row-1.jpg','row-1.jpg','root/import/thingy-templates/images/row-1.jpg','3','7','12',NULL,0,1,0,0,0,790,NULL,0,0,0,1242380165,NULL,0),('nJjZHRwdDs5MAZYsAyioHw',1209509433,'3','pbversion0000000000001','approved','title-bg.jpg','title-bg.jpg','root/import/thingy-templates/images/title-bg.jpg','3','7','12',NULL,0,1,0,0,0,1105,NULL,0,0,0,1242380151,NULL,0),('8hxfkrJPeFVRWF5piCNJ1A',1209509433,'3','pbversion0000000000001','approved','field-bg.jpg','field-bg.jpg','root/import/thingy-templates/images/field-bg.jpg','3','7','12',NULL,0,1,0,0,0,721,NULL,0,0,0,1242380146,NULL,0),('Osx7WN52iIKHZFT4vqUBHQ',1209509433,'3','pbversion0000000000001','approved','search-btn.gif','search-btn.gif','root/import/thingy-templates/images/search-btn.gif','3','7','12',NULL,0,1,0,0,0,1263,NULL,0,0,0,1242380151,NULL,0),('oWff8fGzRdHPyq5VNREe9Q',1209509433,'3','pbversion0000000000001','approved','top-bg.jpg','top-bg.jpg','root/import/thingy-templates/images/top-bg.jpg','3','7','12',NULL,0,1,0,0,0,691,NULL,0,0,0,1242380151,NULL,0),('uqbkvb1b9443VvfkyRz95w',1209509433,'3','pbversion0000000000001','approved','save-button.gif','save-button.gif','root/import/thingy-templates/images/save-button.gif','3','7','12',NULL,0,1,0,0,0,1271,NULL,0,0,0,1242380164,NULL,0),('8YiMkcz32xalkAn3WBLpag',1210181860,'3','pbversion0000000000001','approved','go-btn.gif','go-btn.gif','root/import/thingy-templates/images/go-btn.gif','3','7','12',NULL,0,1,0,0,0,430,NULL,0,0,0,1242380146,NULL,0),('C5fPz-Wg85vkYRvCdl-Xqw',1212160830,'3','pbversion0000000000001','approved','UserList','UserList','root/import/userlist','3','7','12',NULL,0,1,0,0,0,323,NULL,0,1,0,1242380147,NULL,0),('usuxw9V3jN4d4pujRiEYxg',1209494150,'3','pbversion0000000000001','approved','css03-ie.css','css03-ie.css','style3/css03-ie.css','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1242380164,NULL,0),('aNmgn0cd6tldmC1FpW4KbA',1213122695,'3','pbversion0000000000001','approved','Shop','Shop','shopping-cart-collateral-items','3','7','3',NULL,0,1,0,0,0,324,NULL,0,0,0,1242380146,NULL,0),('2q5fxatSFLgIhXaUX-oSvg',1204149033,'3','pbversion0000000000001','approved','bottom-left.jpg','bottom-left.jpg','shopping-cart-collateral-items/bottom-left.jpg','3','7','3',NULL,0,1,0,0,0,32254,NULL,0,0,0,1242380141,NULL,0),('_d5WTkKjnwct-_Dk7gZHvQ',1204149033,'3','pbversion0000000000001','approved','bottom-right.jpg','bottom-right.jpg','shopping-cart-collateral-items/bottom-right.jpg','3','7','3',NULL,0,1,0,0,0,32258,NULL,0,0,0,1242380165,NULL,0),('Iz2mUR3jCPKyemwAea4b2g',1204149033,'3','pbversion0000000000001','approved','input_bg.jpg','input_bg.jpg','shopping-cart-collateral-items/input_bg.jpg','3','7','3',NULL,0,1,0,0,0,30076,NULL,0,0,0,1242380149,NULL,0),('JU9bjsLRoWj7GVHs__prig',1204149033,'3','pbversion0000000000001','approved','top-left.jpg','top-left.jpg','shopping-cart-collateral-items/top-left.jpg','3','7','3',NULL,0,1,0,0,0,32207,NULL,0,0,0,1242380150,NULL,0),('noOlnjQGexHg8c4bGVUo9g',1204149033,'3','pbversion0000000000001','approved','top-right.jpg','top-right.jpg','shopping-cart-collateral-items/top-right.jpg','3','7','3',NULL,0,1,0,0,0,32245,NULL,0,0,0,1242380151,NULL,0),('bPz1yk6Y9uwMDMBcmMsSCg',1211829604,'3','pbversion0000000000001','approved','Email Receipt (Default)','Email Receipt (Default)','shopping-cart-collateral-items/email-receipt-default','3','7','3',NULL,0,1,0,0,0,4632,NULL,0,1,0,1242380147,NULL,0),('EBlxJpZQ9o-8VBOaGQbChA',1212093746,'3','pbversion0000000000001','approved','MiniCart','MiniCart','shopping-cart-collateral-items/minicart','3','7','3',NULL,0,1,0,0,0,2611,'<style>\r\n	.wgMiniCart * a:link,\r\n	.wgMiniCart * a:visited {\r\n		color:black;\r\n	}\r\n	.wgMiniCart{\r\n		background:#f1f1f1;\r\n		border:solid #e0e0e0 1px;\r\n		-moz-border-radius:15px;\r\n	}\r\n	.wgMiniCart h2.title {\r\n		background-color:#e0e0e0;\r\n		margin:0px;\r\n		-moz-border-radius-topLeft:15px;\r\n		-moz-border-radius-topRight:15px;\r\n		padding:3px;\r\n		border-bottom:solid white 1px;\r\n	}\r\n	.wgMiniCart .items {\r\n		border-top:solid #e0e0e0 1px;\r\n	}\r\n	.wgMiniCart .item {\r\n		border-bottom:solid #e0e0e0 1px;\r\n		border-top:solid #fff 1px;\r\n		padding:3px 0px 3px 15px;\r\n	}\r\n	.wgMiniCart .total {\r\n		padding:3px 0px 3px 15px;\r\n		border-top:solid white 1px;\r\n	}\r\n	.wgMiniCart .cart {\r\n		background-color:white;\r\n		-moz-border-radius-bottomLeft:15px;\r\n		-moz-border-radius-bottomRight:15px;\r\n		padding:3px;\r\n		margin-top:10px;\r\n	}\r\n</style>',0,1,0,1242380148,'<style>\r\n	.wgMiniCart * a:link,\r\n	.wgMiniCart * a:visited {\r\n		color:black;\r\n	}\r\n	.wgMiniCart{\r\n		background:#f1f1f1;\r\n		border:solid #e0e0e0 1px;\r\n		-moz-border-radius:15px;\r\n	}\r\n	.wgMiniCart h2.title {\r\n		background-color:#e0e0e0;\r\n		margin:0px;\r\n		-moz-border-radius-topLeft:15px;\r\n		-moz-border-radius-topRight:15px;\r\n		padding:3px;\r\n		border-bottom:solid white 1px;\r\n	}\r\n	.wgMiniCart .items {\r\n		border-top:solid #e0e0e0 1px;\r\n	}\r\n	.wgMiniCart .item {\r\n		border-bottom:solid #e0e0e0 1px;\r\n		border-top:solid #fff 1px;\r\n		padding:3px 0px 3px 15px;\r\n	}\r\n	.wgMiniCart .total {\r\n		padding:3px 0px 3px 15px;\r\n		border-top:solid white 1px;\r\n	}\r\n	.wgMiniCart .cart {\r\n		background-color:white;\r\n		-moz-border-radius-bottomLeft:15px;\r\n		-moz-border-radius-bottomRight:15px;\r\n		padding:3px;\r\n		margin-top:10px;\r\n	}\r\n</style>',0),('WeatherDataTmpl0000001',1210711353,'3','pbversion0000000000001','approved','WeatherData Default View','WeatherData Default View','weatherdatatmpl0000001','3','7','12',NULL,0,1,0,0,0,5505,'<script type=\"text/javascript\" src=\"^Extras(/yui/build/yahoo/yahoo-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(/yui/build/event/event-min.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\n// correctly handle PNG transparency in Win IE 5.5 or higher.\r\n    var correctPNG = function() {\r\n        if (YAHOO.util.Event.isIE) {\r\n            for(var i=0; i<document.images.length; i++) {\r\n                var img = document.images[i]\r\n                var imgName = img.src.toUpperCase()\r\n                if (imgName.substring(imgName.length-3, imgName.length) == \"PNG\") {\r\n                    var imgID = (img.id) ? \"id=\'\" + img.id + \"\' \" : \"\"\r\n                    var imgClass = (img.className) ? \"class=\'\" + img.className + \"\' \" : \"\"\r\n                    var imgTitle = (img.title) ? \"title=\'\" + img.title + \"\' \" : \"title=\'\" + img.alt + \"\' \"\r\n                    var imgStyle = \"display:inline-block;\" + img.style.cssText\r\n                    if (img.align == \"left\") imgStyle = \"float:left;\" + imgStyle\r\n                    if (img.align == \"right\") imgStyle = \"float:right;\" + imgStyle\r\n                    if (img.parentElement.href) imgStyle = \"cursor:hand;\" + imgStyle\r\n                    var strNewHTML = \"<span \" + imgID + imgClass + imgTitle\r\n                        + \" style=\\\"\" + \"width:\" + img.width + \"px; height:\" + img.height + \"px;\" + imgStyle + \";\"\r\n                        + \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"\r\n                        + \"(src=\\\'\" + img.src + \"\\\', sizingMethod=\'scale\');\\\"></span>\"\r\n                    img.outerHTML = strNewHTML\r\n                    i = i-1\r\n                }\r\n            }\r\n        }\r\n    }\r\n    YAHOO.util.Event.onDOMReady(correctPNG);\r\n</script>',0,1,0,1242380164,'<script type=\"text/javascript\" src=\"^Extras(/yui/build/yahoo/yahoo-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(/yui/build/event/event-min.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/var correctPNG=function(){if(YAHOO.util.Event.isIE){for(var i=0;i<document.images.length;i++){var d=document.images[i]var g=d.src.toUpperCase()if(g.substring(g.length-3,g.length)==\"PNG\"){var c=(d.id)?\"id=\'\"+d.id+\"\' \":\"\"var f=(d.className)?\"class=\'\"+d.className+\"\' \":\"\"var b=(d.title)?\"title=\'\"+d.title+\"\' \":\"title=\'\"+d.alt+\"\' \"var e=\"display:inline-block;\"+d.style.cssText if(d.align==\"left\")e=\"float:left;\"+e if(d.align==\"right\")e=\"float:right;\"+e if(d.parentElement.href)e=\"cursor:hand;\"+e var a=\"<span \"+c+f+b+\" style=\\\"\"+\"width:\"+d.width+\"px; height:\"+d.height+\"px;\"+e+\";\"+\"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"+\"(src=\\\'\"+d.src+\"\\\', sizingMethod=\'scale\');\\\"></span>\"d.outerHTML=a i=i-1}}}}YAHOO.util.Event.onDOMReady(correctPNG);/*]]>*/</script>',0),('Ik9HHky10DIyFTKehUD1dw',1222803478,'3','pbversion0000000000001','approved','Prompt','Prompt','root/import/prompt','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1242380149,NULL,0),('gI_TxK-5S4DNuv42wpImmw',1213734379,'3','pbversion0000000000001','approved','Gallery Templates','Gallery Templates','root/import/gallery-templates','3','7','3',NULL,0,0,0,0,0,362,NULL,0,1,0,1244130527,NULL,0),('BmLaN4rmAANkCglXUViEbg',1222803871,'3','pbversion0000000000001','approved','Resource','Resource','root/import/projectmanager/resource','3','12','12',NULL,0,0,0,0,0,346,NULL,0,1,0,1242380147,NULL,0),('X7DrzUcj8pOKFa_6k9D5iw',1222804045,'3','pbversion0000000000001','approved','Newsletter','Newsletter','root/import/newsletter','3','12','3',NULL,0,0,0,0,0,329,NULL,0,1,0,1242380165,NULL,0),('7-0-style0000000000059',1213386091,'3','pbversion0000000000001','approved','main_top.jpg','main_top.jpg','style3/main_top.jpg','3','7','12',NULL,0,0,0,0,0,3594,NULL,0,1,0,1242380144,NULL,0),('CalendarPrintEvent0001',1215396964,'3','pbversion0000000000001','approved','Default Calendar Print Event','Default Calendar Print Event','root/import/calendar-templates/default-calendar-print-event','3','7','12',NULL,0,0,0,0,0,4156,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1242380147,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('_gBYAdTcbkiyamnqi2Xskg',1222803409,'3','pbversion0000000000001','approved','WebGUI/Recovery','WebGUI/Recovery','root/import/auth/webgui/recovery','3','7','12',NULL,0,0,0,0,0,356,NULL,0,1,0,1242380165,NULL,0),('j_1qEqM6iLfQLiR6VKy0aA',1215718151,'3','pbversion0000000000001','approved','Free Documentation','Free Documentation','documentation/free-documentation','3','7','3',NULL,0,1,0,0,0,1415,NULL,0,1,0,1242380150,NULL,0),('o_pq_e4vRyhMOKFzs61eag',1215714957,'3','pbversion0000000000001','approved','book-covers.jpg','book-covers.jpg','documentation/book-covers.jpg','3','7','3',NULL,0,1,0,0,0,106078,NULL,0,0,0,1242380151,NULL,0),('diZvW4bSgZWwyyGP3qXi1g',1215717972,'3','pbversion0000000000001','approved','Commercial Documentation','Commercial Documentation','documentation/commercial-documentation','3','7','3',NULL,0,1,0,0,0,1110,NULL,0,1,0,1242380148,NULL,0),('oHk7fAFhEEkB7dHzi0QOQA',1222803399,'3','pbversion0000000000001','approved','WebGUI/Expired','WebGUI/Expired','root/import/auth/webgui/expired','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1242380151,NULL,0),('fq1ZkYhH24R5tb96kuT10Q',1222803395,'3','pbversion0000000000001','approved','WebGUI/Create','WebGUI/Create','root/import/auth/webgui/create','3','7','12',NULL,0,0,0,0,0,350,NULL,0,1,0,1242380148,NULL,0),('63ix2-hU0FchXGIWkG3tow',1216169693,'3','pbversion0000000000001','approved','Flat Discount (Default)','Flat Discount (Default)','root/import/flat-discount-default','3','7','12',NULL,0,1,0,0,0,1265,NULL,0,1,0,1242380142,NULL,0),('K0q_N885Httqev1VCqUWxg',1222803391,'3','pbversion0000000000001','approved','WebGUI/Account','WebGUI/Account','root/import/auth/webgui/account','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1242380150,NULL,0),('jnYdqDkUR8x7Pv2eGR1qTA',1216250666,'3','pbversion0000000000001','approved','Thingy Templates','Thingy Templates','root/import/thingy-templates','3','7','12',NULL,0,1,0,0,0,347,NULL,0,1,0,1242380149,NULL,0),('taX2UYkFF21ALpFZY2rhMw',1222803387,'3','pbversion0000000000001','approved','LDAP/Login','LDAP/Login','root/import/auth/ldap/login','3','7','12',NULL,0,0,0,0,0,341,NULL,0,1,0,1242380163,NULL,0),('5m5I7__l40C4hhv4ydqAHQ',1216227786,'3','pbversion0000000000001','approved','thingy-ie.css','thingy-ie.css','root/import/thingy-templates/thingy-ie.css','3','7','12',NULL,0,1,0,0,0,1329,NULL,0,1,0,1242380142,NULL,0),('9M-lrlPQWeeNWfvnDnK_Xg',1222803405,'3','pbversion0000000000001','approved','WebGUI/Login','WebGUI/Login','root/import/auth/webgui/login','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1242380146,NULL,0),('xSmREZO3GNzK3M5PaueOOQ',1222803378,'3','pbversion0000000000001','approved','LDAP/Account','LDAP/Account','root/import/auth/ldap/account','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1242380165,NULL,0),('0bx-xoL8TSXXubFuqKAoVQ',1222803383,'3','pbversion0000000000001','approved','LDAP/Create','LDAP/Create','root/import/auth/ldap/create','3','7','12',NULL,0,0,0,0,0,344,NULL,0,1,0,1242380141,NULL,0),('1oGhfj00KkCzP1ez01AfKA',1218582812,'3','pbversion0000000000001','approved','slideshow.js','slideshow.js','root/import/gallery-templates/slideshow.js','3','7','3',NULL,0,1,0,0,0,10453,NULL,0,1,0,1244130528,NULL,0),('pV7GnZdpjR3XpZaSINIoeg',1222803347,'3','pbversion0000000000001','approved','gantt','gantt','root/import/projectmanager/gantt','3','7','12',NULL,0,0,0,0,0,336,NULL,0,1,0,1242380162,NULL,0),('9A-mg2gwWmaYi9o_1C7ArQ',1222803338,'3','pbversion0000000000001','approved','dashboard','dashboard','root/import/projectmanager/dashboard','3','7','12',NULL,0,0,0,0,0,348,NULL,0,1,0,1242380146,NULL,0),('yD1SMHelczihzjEmx6eXBA',1222803342,'3','pbversion0000000000001','approved','editTask','editTask','root/import/projectmanager/edittask','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380165,NULL,0),('BFfNj5wA9bDw8H3cnr8pTw',1247046273,'3','pbversion0000000000001','approved','Navigation','Navigation','root/import/navigation','3','7','12',NULL,0,0,0,0,0,329,NULL,0,1,0,1247779656,NULL,0),('PBtmpl0000000000000094',1220655703,'3','pbversion0000000000001','approved','News','News','plainblacknews','3','7','12',NULL,0,1,0,0,0,5945,'<style type=\"text/css\">\r\n.firstColumn {\r\n	float: left;\r\n	width: 50%;\r\n}\r\n.secondColumn {\r\n	float: left;\r\n	width: auto;\r\n	max-width: 50%;\r\n}\r\n.endFloat {\r\n	clear: both;\r\n}\r\n</style>\r\n\r\n\r\n',0,1,0,1247779651,'<style type=\"text/css\">.firstColumn{float:left;width:50%;}.secondColumn{float:left;width:auto;max-width:50%;}.endFloat{clear:both;}</style>',0),('1XOJDcg_ITRYwVM-QnIcPw',1219175575,'3','pbversion0000000000001','approved','shelf.css','shelf.css','root/import/shelf2/shelf.css','3','7','12',NULL,0,1,0,0,0,2431,NULL,0,1,0,1242380141,NULL,0),('aNNC62qLAS6TB-0_MCYjsw',1246969327,'3','pbversion0000000000001','approved','Layout','Layout','root/import/layout','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1247779656,NULL,0),('huASapWvFDzqwOSbcN-JFQ',1222803313,'3','pbversion0000000000001','approved','user','user','root/import/timetracking/user','3','7','12',NULL,0,0,0,0,0,331,NULL,0,1,0,1242380149,NULL,0),('lo1ac3BsoJx3ijGQ3gR-bQ',1222803309,'3','pbversion0000000000001','approved','row','row','root/import/timetracking/row','3','7','12',NULL,0,0,0,0,0,328,NULL,0,1,0,1242380150,NULL,0),('1z9J1O08n_7gVVlBwSRBJQ',1222803099,'3','pbversion0000000000001','approved','Auth','Auth','root/import/auth','3','7','12',NULL,0,1,0,0,0,311,NULL,0,1,0,1242380141,NULL,0),('zyWi26q9na-iiZqL4yedog',1222803114,'3','pbversion0000000000001','approved','Macro','Macro','root/import/macro','3','7','12',NULL,0,1,0,0,0,314,NULL,0,1,0,1242380165,NULL,0),('tBL7BWiQRZFed2Y-Zjo9tQ',1222803200,'3','pbversion0000000000001','approved','AdminToggle','AdminToggle','root/import/macro/admintoggle','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380163,NULL,0),('GdkQpvjRtJqtzOUbwIIQRA',1222803205,'3','pbversion0000000000001','approved','a_account','a_account','root/import/macro/a_account','3','7','12',NULL,0,0,0,0,0,339,NULL,0,1,0,1242380149,NULL,0),('tnc5iYyynX2hfdEs9D3P8w',1222803213,'3','pbversion0000000000001','approved','EditableToggle','EditableToggle','root/import/macro/editabletoggle','3','7','12',NULL,0,0,0,0,0,354,NULL,0,1,0,1242380164,NULL,0),('vgXdBcFTqU7h4wBG1ewdBw',1222803217,'3','pbversion0000000000001','approved','File','File','root/import/macro/file','3','7','12',NULL,0,0,0,0,0,324,NULL,0,1,0,1242380164,NULL,0),('hcFlqnXlsmC1ujN6Id0F0A',1222803234,'3','pbversion0000000000001','approved','GroupAdd','GroupAdd','root/import/macro/groupadd','3','7','12',NULL,0,0,0,0,0,336,NULL,0,1,0,1242380149,NULL,0),('eRJR52fvlaxfetv3DQkQYw',1222803238,'3','pbversion0000000000001','approved','GroupDelete','GroupDelete','root/import/macro/groupdelete','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380148,NULL,0),('5HIDHq5lAWHV5gpYGS0zLg',1222803244,'3','pbversion0000000000001','approved','H_homeLink','H_homeLink','root/import/macro/h_homelink','3','7','12',NULL,0,0,0,0,0,342,NULL,0,1,0,1242380142,NULL,0),('rYEFwXXo0tkGhQTcbDibvg',1222803249,'3','pbversion0000000000001','approved','LoginToggle','LoginToggle','root/import/macro/logintoggle','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380162,NULL,0),('-WM2dt0ZGpDasuL2wWocxg',1222803056,'3','pbversion0000000000001','approved','ProjectManager','ProjectManager','root/import/projectmanager','3','7','12',NULL,0,1,0,0,0,341,NULL,0,1,0,1242380141,NULL,0),('2OcUWHVsu_L1sDFzIMWYqw',1222803070,'3','pbversion0000000000001','approved','TimeTracking','TimeTracking','root/import/timetracking','3','7','12',NULL,0,1,0,0,0,335,NULL,0,1,0,1242380141,NULL,0),('vTymIDYL2YqEh6PV50F7ew',1222803302,'3','pbversion0000000000001','approved','manager','manager','root/import/timetracking/manager','3','7','12',NULL,0,0,0,0,0,340,NULL,0,1,0,1242380164,NULL,0),('nqNbSUAhk9Vd1zda2SCz9A',1222803258,'3','pbversion0000000000001','approved','RandomThread','RandomThread','root/import/macro/randomthread','3','7','12',NULL,0,0,0,0,0,348,NULL,0,1,0,1242380151,NULL,0),('y8XkRdxIperLKkJ3bL5sSQ',1222803264,'3','pbversion0000000000001','approved','r_printable','r_printable','root/import/macro/r_printable','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380165,NULL,0),('V3l5S5TtI7wMm1WpIMhvOA',1222803253,'3','pbversion0000000000001','approved','L_loginBox','L_loginBox','root/import/macro/l_loginbox','3','7','12',NULL,0,0,0,0,0,342,NULL,0,1,0,1242380164,NULL,0),('PBEmsBadgeTemplate0000',1221692339,'3','pbversion0000000000001','approved','Default EMS Badge Template','Default EMS Badge Template','default_emsbadge','3','7','4',NULL,0,0,0,0,0,2563,NULL,0,1,0,1242380151,NULL,0),('PBtmpl0000000000000005',1221612327,'3','pbversion0000000000001','approved','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template','default_ldap_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,5961,'<style type=\"text/css\">\r\n    .submitData {\r\n        text-align:right;\r\n        border-top:solid gray 1px;\r\n    }\r\n    .authfield_required_off {\r\n        background-color: #FFFFFF;\r\n    }\r\n    .authfield_required {\r\n        background-color: #FFFFBB;\r\n    }\r\n    .authfield_error {\r\n        background-color: #FF9494;\r\n    }\r\n</style>\r\n<script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\r\n<script type=\"text/javascript\">\r\n   YAHOO.util.Event.onDOMReady(function () {\r\n        var setFieldColor = function ( evt, obj ) {\r\n            var field     = obj.field;\r\n            var hasError  = obj.hasError;\r\n            var origClass = field.className;\r\n            YAHOO.util.Dom.removeClass(field,origClass);\r\n            if(field.value == \"\") {\r\n                var newClass  = hasError?\"authfield_error\":\"authfield_required\";\r\n                YAHOO.util.Dom.replaceClass(field,origClass,newClass);\r\n            }\r\n            else {\r\n                YAHOO.util.Dom.replaceClass(field,origClass,\"authfield_required_off\");\r\n            }\r\n        }\r\n\r\n        var rFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");\r\n        var eFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");\r\n        var oFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");\r\n\r\n        for (var i = 0; i < rFields.length; i++) {\r\n            YAHOO.util.Event.addListener(rFields[i],\"change\",setFieldColor, {\r\n                field   : rFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < eFields.length; i++) {\r\n            YAHOO.util.Event.addListener(eFields[i],\"change\",setFieldColor, {\r\n                field   : eFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < oFields.length; i++) {\r\n            YAHOO.util.Event.addListener(oFields[i],\"change\",setFieldColor, {\r\n                field   : oFields[i],\r\n                hasError: (oFields.length > 0)\r\n            });\r\n        }\r\n       \r\n   });\r\n</script>',0,1,0,1242380152,'<style type=\"text/css\">.submitData{text-align:right;border-top:solid gray 1px;}.authfield_required_off{background-color:#FFFFFF;}.authfield_required{background-color:#FFFFBB;}.authfield_error{background-color:#FF9494;}</style><script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){var h=function(c,a){var f=a.field;var e=a.hasError;var d=f.className;YAHOO.util.Dom.removeClass(f,d);if(f.value==\"\"){var b=e?\"authfield_error\":\"authfield_required\";YAHOO.util.Dom.replaceClass(f,d,b)}else{YAHOO.util.Dom.replaceClass(f,d,\"authfield_required_off\")}}var g=YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");var k=YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");var j=YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");for(var i=0;i<g.length;i++){YAHOO.util.Event.addListener(g[i],\"change\",h,{field:g[i],hasError:(k.length>0)})}for(var i=0;i<k.length;i++){YAHOO.util.Event.addListener(k[i],\"change\",h,{field:k[i],hasError:(k.length>0)})}for(var i=0;i<j.length;i++){YAHOO.util.Event.addListener(j[i],\"change\",h,{field:j[i],hasError:(j.length>0)})}});/*]]>*/</script>',0),('newslettersubscrip0001',1221692339,'3','pbversion0000000000001','approved','My Subscriptions (default)',' My Subscriptions','newslettermysubscriptionstemplate','3','7','3',NULL,0,0,0,0,0,1173,NULL,0,1,0,1242380151,NULL,0),('eqb9sWjFEVq0yHunGV8IGw',1222574693,'3','pbversion0000000000001','approved','Subscription (Default)','Subscription (Default)','root/import/subscription-default','3','7','12',NULL,0,1,0,0,0,2850,'<style type=\"text/css\">\r\n	.wgSubscription {\r\n\r\n	}\r\n	.wgSubscription .controls {\r\n		background-color:black;\r\n		padding:3px 10px;\r\n		color:white;\r\n		margin:5px 0px;\r\n	}\r\n	.wgSubscription h3.title {\r\n		margin-bottom:3px;\r\n	}\r\n	.wgSubscription .description * {\r\n		margin-top:0px;\r\n	}\r\n	.wgSubscription .controls a {\r\n		color:white;\r\n	}\r\n	.wgSubscription .smaller {\r\n		font-size:10px;\r\n		margin-bottom:10px;\r\n	}\r\n</style>\n',0,1,0,1242380148,'<style type=\"text/css\">.wgSubscription{}.wgSubscription .controls{background-color:black;padding:3px 10px;color:white;margin:5px 0px;}.wgSubscription h3.title{margin-bottom:3px;}.wgSubscription .description *{margin-top:0px;}.wgSubscription .controls a{color:white;}.wgSubscription .smaller{font-size:10px;margin-bottom:10px;}</style>',0),('stevestyle000000000001',1222383245,'3','pbversion0000000000001','approved','Style 01','Style 01','style_01','3','7','12',NULL,0,0,0,0,0,2811,NULL,0,1,0,1242380162,NULL,0),('stevestyle000000000002',1222383245,'3','pbversion0000000000001','approved','Style 02','Style 02','style_02','3','7','12',NULL,0,0,0,0,0,4753,NULL,0,1,0,1242380162,NULL,0),('ThingyTmpl000000000002',1222574693,'3','pbversion0000000000001','approved','Default Thingy View Thing','Default Thingy View Thing','templates/thingy-default-view-thing','3','7','12',NULL,0,0,0,0,0,4793,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\n',0,1,0,1242380163,'<style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('UL-ItI4L1Z6-WSuhuXVvsQ',1225139673,'3','pbversion0000000000001','approved','DataTable','DataTable','root/import/datatable','3','7','3',NULL,0,0,0,0,0,325,NULL,0,1,0,1242380164,NULL,0),('THQhn1C-ooj-TLlEP7aIJQ',1225313951,'3','pbversion0000000000001','approved','gallery-ie.css','gallery-ie.css','root/import/gallery-templates/gallery-ie.css','3','7','3',NULL,0,1,0,0,0,623,NULL,0,1,0,1244130528,NULL,0),('7-0-style0000000000049',1224117144,'3','pbversion0000000000001','approved','WebGUI 7 Style 3','WebGUI 7 Style 3','root/import/webgui-7-style-3','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1242380144,NULL,0),('stevecoolmenu000000001',1224116942,'3','pbversion0000000000001','approved','Site Nav','Site Nav','webgui7/style3/hierarchical-top-nav','3','7','12',NULL,0,0,0,0,0,3716,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\r\n',0,1,0,1242380162,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>',0),('7-0-style0000000000051',1224117026,'3','pbversion0000000000001','approved','css03.css','css03.css','style3/css03.css','3','7','12',NULL,0,0,0,0,0,5975,NULL,0,1,0,1242380144,NULL,0),('jVKLVakT_iA2010_oEuAwg',1224116526,'3','pbversion0000000000001','approved','Style3 Coolmenu','Style3 Coolmenu','department_nav','3','7','12',NULL,0,0,0,0,0,386,NULL,0,1,0,1242380150,NULL,0),('stevestyle000000000003',1224795533,'3','pbversion0000000000001','approved','Style 03','Style 03','style_03','3','7','12',NULL,0,0,0,0,0,2868,NULL,0,1,0,1242380163,NULL,0),('ThingyTmpl000000000003',1224518002,'3','pbversion0000000000001','approved','Default Thingy Edit Thing','Default Thingy Edit Thing','templates/thingy-default-edit-thing','3','7','12',NULL,0,0,0,0,0,6242,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\r\n\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/thingy-templates/thingy-ie.css););\r\n	</style>\r\n<![endif]-->\r\n',0,1,0,1242380163,'<style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('QpmlAiYZz6VsKBM-_0wXaw',1224616691,'3','pbversion0000000000001','approved','UsersOnline Macro','UsersOnline Macro','users-online-macro-templates','3','7','3',NULL,0,0,0,0,0,368,NULL,0,1,0,1242380162,NULL,0),('h_T2xtOxGRQ9QJOR6ebLpQ',1224616545,'3','pbversion0000000000001','approved','UsersOnline Default View','UsersOnline Default View','users-online-macro-templates/usersonline-default-view','3','7','3',NULL,0,1,0,0,0,2479,'<style type=\"text/css\">\r\n.UsersOnlineTable { \r\n	border-collapse: collapse;\r\n}\r\n\r\n.UsersOnlineTable th, .UsersOnlineTable td {\r\n	text-align: left;\r\n	border: 2px ridge;\r\n}\r\n\r\n.UsersOnlineTable img {\r\n	max-width: 3em;\r\n	max-height: 3em;\r\n	float: left;\r\n}\r\n</style>\r\n\r\n',0,1,0,1242380149,'<style type=\"text/css\">.UsersOnlineTable{border-collapse:collapse;}.UsersOnlineTable th,.UsersOnlineTable td{text-align:left;border:2px ridge;}.UsersOnlineTable img{max-width:3em;max-height:3em;float:left;}</style>',0),('4Ekp0kJoJllRRRo_J1Rj6w',1224616672,'3','pbversion0000000000001','approved','UsersOnline Detailed View','UsersOnline Detailed View','users-online-macro-templates/usersonline-detailed-view','3','7','3',NULL,0,1,0,0,0,4271,'<style type=\"text/css\">\r\n.UsersOnlineTable { \r\n	border-collapse: collapse;\r\n}\r\n\r\n.UsersOnlineTable th, .UsersOnlineTable td {\r\n	text-align: left;\r\n	border: 2px ridge;\r\n}\r\n\r\n.UsersOnlineTable img {\r\n	max-width: 3em;\r\n	max-height: 3em;\r\n	float: left;\r\n}\r\n</style>\r\n\r\n',0,1,0,1242380142,'<style type=\"text/css\">.UsersOnlineTable{border-collapse:collapse;}.UsersOnlineTable th,.UsersOnlineTable td{text-align:left;border:2px ridge;}.UsersOnlineTable img{max-width:3em;max-height:3em;float:left;}</style>',0),('HPDOcsj4gBme8D4svHodBw',1225404573,'3','pbversion0000000000001','approved','Profile','Profile','root/import/account/profile','3','7','12',NULL,0,1,0,0,0,334,NULL,0,1,0,1250190873,NULL,0),('IZkrow_zwvbf4FCH-taVTQ',1226011853,'3','pbversion0000000000001','approved','Inbox','Inbox','root/import/account/inbox','3','7','12',NULL,0,1,0,0,0,328,NULL,0,1,0,1250190873,NULL,0),('K0YjxqOqr7RupSo6sIdcAg',1227074310,'3','pbversion0000000000001','approved','Friends','Friends','root/import/account/friends','3','7','12',NULL,0,1,0,0,0,334,NULL,0,1,0,1250190873,NULL,0),('_ilRXNR3s8F2vGJ_k9ePcg',1226643205,'3','pbversion0000000000001','approved','User','User','root/import/account/user','3','7','12',NULL,0,1,0,0,0,325,NULL,0,1,0,1250190873,NULL,0),('qaVcU0FFzzraMX_bzELqzw',1227074362,'3','pbversion0000000000001','approved','Contributions','Contributions','root/import/account/contributions','3','7','12',NULL,0,1,0,0,0,352,NULL,0,1,0,1250190873,NULL,0),('vrKXEtluIhbmAS9xmPukDA',1226698051,'3','pbversion0000000000001','approved','Donation (Default)','Donation (Default)','root/import/default-donation-template','3','7','12',NULL,0,1,0,0,0,2486,'<style type=\"text/css\">\r\n	.wgDonation h3.title {\r\n		background: #000;\r\n		height:42px;\r\n		color:white;\r\n		font-size:18px;\r\n		font-weight:bold;\r\n		letter-spacing:1px;			\r\n		line-height:42px;\r\n		padding-left:15px;\r\n		margin-bottom:0px;\r\n	}\r\n	.wgDonation .cart {\r\n		margin:15px 0px 15px 25px;\r\n	}\r\n	.wgDonation #price_formId {\r\n		background-color:white;\r\n		border:solid black 1px;\r\n	}\r\n</style>\r\n',0,0,0,1242380164,'<style type=\"text/css\">.wgDonation h3.title{background:#000;height:42px;color:white;font-size:18px;font-weight:bold;letter-spacing:1px;line-height:42px;padding-left:15px;margin-bottom:0px;}.wgDonation .cart{margin:15px 0px 15px 25px;}.wgDonation #price_formId{background-color:white;border:solid black 1px;}</style>',0),('PBtmpl0000000000000137',1236787780,'3','pbversion0000000000001','approved','Admin Console Style','Admin Console','admin_console','3','7','12',NULL,0,1,0,0,0,1272,NULL,0,1,0,1255485470,NULL,0),('3womoo7Teyy2YKFa25-MZg',1226703362,'3','pbversion0000000000001','approved','Address Book (Default)','Address Book (Default)','shopping-cart-collateral-items/address-book-default','3','7','3',NULL,0,1,0,0,0,3053,'<style>\r\n	.wgAddressBook .item {\r\n		float:left;\r\n		margin:15px;\r\n		width:210px;\r\n		background-color:white;\r\n		border:solid black 1px;\r\n	}\r\n	.wgAddressBook .default {\r\n		border:double black 3px;\r\n	}\r\n	.wgAddressBook .use input {\r\n		width:210px;\r\n		background-color:white;\r\n		font-size:10px;\r\n		cursor:pointer;\r\n		border:gray outset 2px;\r\n		font-weight:bold;\r\n		margin-bottom:10px;\r\n		color:green;\r\n	}\r\n	.wgAddressBook .label {\r\n		text-align:center;\r\n		font-size:15px;\r\n		font-weight:bold;\r\n	}\r\n	.wgAddressBook .address {\r\n		padding:5px;\r\n		margin-bottom:15px;\r\n	}\r\n	.wgAddressBook .delete input,\r\n	.wgAddressBook .edit input {\r\n		float:left;\r\n		width:70px;\r\n		font-size:10px;\r\n		border:gray outset 1px;\r\n		background-color:white;\r\n		cursor:pointer;\r\n	}\r\n	.wgAddressBook .delete input {\r\n		color:red;\r\n	}\r\n	.wgAddressBook * input:hover {\r\n		background-color:#FFFFEC;\r\n	}\r\n</style>\r\n',0,1,0,1242380142,'<style>\r\n	.wgAddressBook .item {\r\n		float:left;\r\n		margin:15px;\r\n		width:210px;\r\n		background-color:white;\r\n		border:solid black 1px;\r\n	}\r\n	.wgAddressBook .default {\r\n		border:double black 3px;\r\n	}\r\n	.wgAddressBook .use input {\r\n		width:210px;\r\n		background-color:white;\r\n		font-size:10px;\r\n		cursor:pointer;\r\n		border:gray outset 2px;\r\n		font-weight:bold;\r\n		margin-bottom:10px;\r\n		color:green;\r\n	}\r\n	.wgAddressBook .label {\r\n		text-align:center;\r\n		font-size:15px;\r\n		font-weight:bold;\r\n	}\r\n	.wgAddressBook .address {\r\n		padding:5px;\r\n		margin-bottom:15px;\r\n	}\r\n	.wgAddressBook .delete input,\r\n	.wgAddressBook .edit input {\r\n		float:left;\r\n		width:70px;\r\n		font-size:10px;\r\n		border:gray outset 1px;\r\n		background-color:white;\r\n		cursor:pointer;\r\n	}\r\n	.wgAddressBook .delete input {\r\n		color:red;\r\n	}\r\n	.wgAddressBook * input:hover {\r\n		background-color:#FFFFEC;\r\n	}\r\n</style>',0),('ThingyTmpl000000000004',1227044214,'3','pbversion0000000000001','approved','Default Thingy Search Thing','Default Thingy Search Thing','templates/thingy-default-search-thing','3','7','12',NULL,0,0,0,0,0,9339,'<script type=\"text/javascript\">\r\n	var timer;\r\n	var tempThing;\r\n	function showHide(tempThingId) {	\r\n			tempThing = document.getElementById(tempThingId);\r\n			var tempVis = tempThing.style.display;			\r\n			tempChildren = tempThing.childNodes;			\r\n			for(i=0;i<tempThing.childNodes.length;i++) {\r\n				if(tempThing.childNodes[i].tagName == \"A\") {					\r\n					tempThing.childNodes[i].onmouseout = mouseOutHide;\r\n					tempThing.childNodes[i].onmouseover = cancelTimer;\r\n				}\r\n			}			\r\n			if(tempVis == \"block\")\r\n				tempThing.style.display = \"none\";\r\n			else\r\n				tempThing.style.display = \"block\";\r\n	}\r\n\r\n	function mouseOutHide() {					\r\n		var parentVis = this.parentNode.style.display;		\r\n		timer = setTimeout(\"tempThing.style.display = \'none\'\", 125);			\r\n\r\n	}\r\n	function cancelTimer() {						\r\n		clearTimeout(timer);\r\n	}	\r\n</script>\r\n\r\n<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\r\n\r\n<!--[if IE]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/thingy-templates/thingy-ie.css););\r\n	</style>\r\n<![endif]-->\r\n',0,1,0,1242380163,'<script type=\"text/javascript\">/*<![CDATA[*/var timer;var tempThing;function showHide(b){tempThing=document.getElementById(b);var a=tempThing.style.display;tempChildren=tempThing.childNodes;for(i=0;i<tempThing.childNodes.length;i++){if(tempThing.childNodes[i].tagName==\"A\"){tempThing.childNodes[i].onmouseout=mouseOutHide;tempThing.childNodes[i].onmouseover=cancelTimer}}if(a==\"block\")tempThing.style.display=\"none\";else tempThing.style.display=\"block\"}function mouseOutHide(){var a=this.parentNode.style.display;timer=setTimeout(\"tempThing.style.display = \'none\'\",125)}function cancelTimer(){clearTimeout(timer)}/*]]>*/</script><style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('UserListTmpl0000000001',1228125743,'3','pbversion0000000000001','approved','Default UserList','Default UserList','root/import/userlist/default-userlist','3','7','12',NULL,0,1,0,0,0,5131,NULL,0,1,0,1242380164,NULL,0),('UserListTmpl0000000003',1228125758,'3','pbversion0000000000001','approved','UserList with multiple search keywords','UserList with multiple search keywords','root/import/userlist/userlist-with-multiple-search-keywords','3','7','12',NULL,0,1,0,0,0,5417,NULL,0,1,0,1242380164,NULL,0),('UserListTmpl0000000002',1228125752,'3','pbversion0000000000001','approved','UserList with search field selection','UserList with search field selection','root/import/userlist/userlist-with-search-field-selection','3','7','12',NULL,0,1,0,0,0,5049,NULL,0,1,0,1242380164,NULL,0),('matrixtmpl000000000004',1228834590,'3','pbversion0000000000001','approved','Matrix Default Edit Listing','Matrix Default Edit Listing','default-matrix-edit-listing-template','3','7','12',NULL,0,0,0,0,0,522,NULL,0,1,0,1242380150,NULL,0),('TimeTrackingTMPL000003',1229311434,'3','pbversion0000000000001','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,5662,NULL,0,1,0,1242380163,NULL,0),('uRL9qtk7Rb0YRJ41LmHOJw',1229311072,'3','pbversion0000000000001','approved','Default Calendar Print List View','Default Calendar Print List View','root/import/calendar-templates/default-calendar-print-list-view','3','7','3',NULL,0,1,0,0,0,1719,NULL,0,1,0,1242380164,NULL,0),('StockDataTMPL000000001',1229453697,'3','pbversion0000000000001','approved','StockData Default View','StockData Default View','stockdatatmpl000000001','3','7','12',NULL,0,1,0,0,0,9001,'\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras;wobject/StockData/tools.css\" />',0,1,0,1242380163,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras;wobject/StockData/tools.css\" />',0),('DashboardViewTmpl00001',1230358389,'3','pbversion0000000000001','approved','Dashboard Default View','Dashboard Default View','dashboard-default-view-template','3','7','12',NULL,0,0,0,0,0,14755,'<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/draggable.css);\"; </style>\r\n<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/dashboard.css);\"; </style>\r\n<script src=\"^Extras(wobject/Dashboard/draggable.js);\" type=\"text/javascript\"></script>\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\ndiv.dragTitle\r\n{\r\n	overflow-x:hidden;\r\n}\r\n</style>\r\n<![endif]-->',0,1,0,1242380148,'<style type=\"text/css\">@import \"^Extras(wobject/Dashboard/draggable.css);\";</style><style type=\"text/css\">@import \"^Extras(wobject/Dashboard/dashboard.css);\";</style><script src=\"^Extras(wobject/Dashboard/draggable.js);\" type=\"text/javascript\"></script>',0),('ProjectManagerTMPL0005',1229579830,'3','pbversion0000000000001','approved','Default Resource Popup','Default Resource Popup','default-pm-resource-popup','3','7','12',NULL,0,0,0,0,0,3562,NULL,0,1,0,1242380162,NULL,0),('ProjectManagerTMPL0001',1229579830,'3','pbversion0000000000001','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,6708,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\n.projectView td {\n	border:solid silver 1px;\n	border-bottom:solid gray 1px;\n	font-size:9pt;\n	font-family:arial;\n}\n.projectView a {\n	color:#3391DD;\n}\ntr.header td {\n	font-weight:bold;\n}\ntd.projectNames {\n	white-space:nowrap;\n}\ntd.projectNames a {\n	display:block;\n	color:#3391DD;\n}\ntd.projectNames a.level1 {\n	margin:0 10px;\n}\ntd.projectNames a.level2 {\n	margin:0px 10px 0px 20px;\n}\ntd.projectNames a.level3 {\n	margin:0px 10px 0px 30px;\n}\ntd.projectNames a.level4 {\n	margin:0px 10px 0px 40px;\n}\ntd.projectNames a.level5 {\n	margin:0px 10px 0px 50px;\n}\ntr.alt td {\n	background-color:#F0F0F0;\n}\ndiv.completeContainer {\n	position:relative;\n	z-index:0;\n	background: #000;\n	color:white;\n	text-align:center;\n}\ndiv.completeBar {\n	position:absolute;\n	height:100%;\n	top:0px;\n	left:0px;\n	background: #7AB7E9;\n	z-index:1;\n}\ndiv.completeText {\n	position:relative;\n	height:100%;\n	top:0px;\n	left:0px;\n	z-index:2;\n}\n</style>',0,1,0,1242380162,'<style type=\"text/css\">.fontSettings{font-family:arial;font-size:9pt;}.projectView td{border:solid silver 1px;border-bottom:solid gray 1px;font-size:9pt;font-family:arial;}.projectView a{color:#3391DD;}tr.header td{font-weight:bold;}td.projectNames{white-space:nowrap;}td.projectNames a{display:block;color:#3391DD;}td.projectNames a.level1{margin:0 10px;}td.projectNames a.level2{margin:0px 10px 0px 20px;}td.projectNames a.level3{margin:0px 10px 0px 30px;}td.projectNames a.level4{margin:0px 10px 0px 40px;}td.projectNames a.level5{margin:0px 10px 0px 50px;}tr.alt td{background-color:#F0F0F0;}div.completeContainer{position:relative;z-index:0;background:#000;color:white;text-align:center;}div.completeBar{position:absolute;height:100%;top:0px;left:0px;background:#7AB7E9;z-index:1;}div.completeText{position:relative;height:100%;top:0px;left:0px;z-index:2;}</style>',0),('PBtmpl0000000000000033',1230159454,'3','pbversion0000000000001','approved','Default HTTP Proxy','Default HTTP Proxy','default_http_proxy','3','7','12',NULL,0,1,0,0,0,2008,NULL,0,1,0,1242380153,NULL,0),('PBtmpl0000000000000059',1229907401,'3','pbversion0000000000001','approved','Default SQL Report','Default SQL Report','default_sql_report','3','7','12',NULL,0,1,0,0,0,7473,NULL,0,1,0,1242380153,NULL,0),('MultiSearchTmpl0000001',1230269962,'3','pbversion0000000000001','approved','MultiSearch Default Display','MultiSearch Default Display','multisearchtmpl0000001','3','7','12',NULL,0,1,0,0,0,3510,'<style type=\"text/css\">\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.multiSearch {\n	background-color:#DADADA;\n	border:solid gray 1px;	\n}\n</style>',0,1,0,1242380150,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.multiSearch{background-color:#DADADA;border:solid gray 1px;}</style>',0),('CalendarDay00000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Day','Default Calendar Day','root/import/calendar-templates/default-calendar-day','3','7','12',NULL,0,0,0,0,0,13634,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n            }\r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n        }\r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n            }\r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n                        -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n                        background-color:#E9ECF3;\r\n            width:400px;\r\n            position:relative;\r\n                    vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n                        -moz-border-radius-bottomLeft:8px;\r\n            border:solid #CCD2E3 1px;\r\n        }\r\n        #mCAL .curDay {\r\n            background-color:#FFE4B3;\r\n            border-color:orange;\r\n        }\r\n                    #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n                margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n\r\n                                    #mCAL span.border {\r\n                        text-align:center;\r\n            padding:5px;\r\n            font-weight:bold;\r\n            -moz-border-radius-bottomRight:5px;\r\n            -moz-border-radius-topLeft:5px;\r\n                        color:black;\r\n            border-right:solid #CCD2E3 1px;\r\n            border-bottom: solid #CCD2E3 1px;\r\n            background-color:#ABB7D1;\r\n            -moz-box-sizing:border-box;\r\n            top:5px;\r\n            position:relative;\r\n            \r\n        }\r\n        #mCAL .curDay span.border {\r\n            background-color:orange;\r\n            color:black;\r\n            border-color:orange;\r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n                        font-weight:bold;\r\n        }\r\n        #mCAL .event a {\r\n            color:#4F4F4F;\r\n            text-decoration:none;\r\n            font-size:9px;\r\n        }\r\n        #mCAL .moreButton {\r\n            border-style:none;\r\n            z-index:5;\r\n            position:absolute;\r\n            bottom:0px;\r\n            width:100%;\r\n            height:9px;\r\n                background-color:#517AC8;\r\n            font-size:5px;\r\n            text-align:center;\r\n        }\r\n        #mCAL .moreButton:hover {\r\n            background-color:orange;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n                        background-color:#DFE3EE;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n                        text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n                        background-color:#fff;\r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:center;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>',0,1,0,1242380147,'<style type=\"text/css\">#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .curDay{background-color:#FFE4B3;border-color:orange;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #CCD2E3 1px;border-bottom:solid #CCD2E3 1px;background-color:#ABB7D1;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:orange;color:black;border-color:orange;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:30px;color:#526896;}</style>',0),('CalendarEvent000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Event','Default Calendar Event','root/import/calendar-templates/default-calendar-event','3','7','12',NULL,0,0,0,0,0,11714,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        body * {\r\n            margin:0px;\r\n        }   \r\n        #mCAL {\r\n            \r\n        }\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n        }   \r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n        }   \r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n        }   \r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n            -moz-border-radius-topRight:8px;            \r\n        }\r\n        #mCAL .day {\r\n            background-color:#E9ECF3;           \r\n            width:400px;\r\n            position:relative;\r\n            vertical-align:top;     \r\n            -moz-border-radius-topLeft:8px;\r\n            -moz-border-radius-bottomLeft:8px;          \r\n            border:solid #CCD2E3 1px;\r\n        }\r\n\r\n        \r\n        #mCAL .months {\r\n            text-align:center;\r\n            background-color:#DFE3EE;   \r\n            color:#3E4D75;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n            text-decoration:none;           \r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n        }   \r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n            background-color:#fff;          \r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:center;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n\r\n        #mCAL .searchField {\r\n            margin: 2px 10px;\r\n            border:solid #ABB7D1 1px;\r\n        }\r\n        #mCAL .searchBtn {\r\n            background-color: #ABB7D1;\r\n            border:solid #CCD2E3 1px;\r\n            color:white;\r\n            font-weight:bold;\r\n            cursor:pointer;\r\n        }\r\n        \r\n        #mCAL .eventWrapper {\r\n            margin:2px 10px;\r\n        }\r\n    </style>',0,1,0,1242380147,'<style type=\"text/css\">body *{margin:0px;}#mCAL{}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .months{text-align:center;background-color:#DFE3EE;color:#3E4D75;font-size:14px;font-weight:bold;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#mCAL .searchField{margin:2px 10px;border:solid #ABB7D1 1px;}#mCAL .searchBtn{background-color:#ABB7D1;border:solid #CCD2E3 1px;color:white;font-weight:bold;cursor:pointer;}#mCAL .eventWrapper{margin:2px 10px;}</style>',0),('CalendarSearch00000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Search','Default Calendar Search','root/import/calendar-templates/default-calendar-search','3','7','12',NULL,0,0,0,0,0,14697,'    <style type=\"text/css\">\r\n        body * {\r\n            margin:0px;\r\n            }\r\n        #mCAL {\r\n            \r\n        }\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n            }\r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n        }\r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n            }\r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n                        -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n                        background-color:#E9ECF3;\r\n            width:400px;\r\n            position:relative;\r\n                    vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n                        -moz-border-radius-bottomLeft:8px;\r\n            border:solid #CCD2E3 1px;\r\n        }\r\n        #mCAL .curDay {\r\n            background-color:#FFE4B3;\r\n            border-color:orange;\r\n        }\r\n                    #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n                margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n\r\n                                    #mCAL span.border {\r\n                        text-align:center;\r\n            padding:5px;\r\n            font-weight:bold;\r\n            -moz-border-radius-bottomRight:5px;\r\n            -moz-border-radius-topLeft:5px;\r\n                        color:black;\r\n            border-right:solid #CCD2E3 1px;\r\n            border-bottom: solid #CCD2E3 1px;\r\n            background-color:#ABB7D1;\r\n            -moz-box-sizing:border-box;\r\n            top:5px;\r\n            position:relative;\r\n            \r\n        }\r\n        #mCAL .curDay span.border {\r\n            background-color:orange;\r\n            color:black;\r\n            border-color:orange;\r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n                        font-weight:bold;\r\n        }\r\n        #mCAL .event a {\r\n            color:#4F4F4F;\r\n            text-decoration:none;\r\n            font-size:9px;\r\n        }\r\n        #mCAL .moreButton {\r\n            border-style:none;\r\n            z-index:5;\r\n            position:absolute;\r\n            bottom:0px;\r\n            width:100%;\r\n            height:9px;\r\n                background-color:#517AC8;\r\n            font-size:5px;\r\n            text-align:center;\r\n        }\r\n        #mCAL .moreButton:hover {\r\n            background-color:orange;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n                        background-color:#DFE3EE;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n                        text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n                        background-color:#fff;\r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:left;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>',0,1,0,1242380147,'<style type=\"text/css\">body *{margin:0px;}#mCAL{}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .curDay{background-color:#FFE4B3;border-color:orange;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #CCD2E3 1px;border-bottom:solid #CCD2E3 1px;background-color:#ABB7D1;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:orange;color:black;border-color:orange;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:left;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:30px;color:#526896;}</style>',0),('CalendarWeek0000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Week','Default Calendar Week','root/import/calendar-templates/default-calendar-week','3','7','12',NULL,0,0,0,0,0,12645,'<style type=\"text/css\">\r\n		#mCAL * {\r\n			/*margin:0px;*/\r\n		}\r\n		#mCAL td {\r\n			font-size:10px;\r\n			font-family:arial;\r\n		}\r\n		#mCAL .tab {\r\n\r\n			border-bottom-style:none;\r\n			font-weight:bold;\r\n			padding: 2px 15px 0px 15px;\r\n			text-align;center;\r\n			background-color:#E9ECF3;\r\n			-moz-border-radius-topLeft:10px;\r\n			-moz-border-radius-topRight:10px;\r\n			color:#7588B5;\r\n			text-decoration:none;\r\n			font-size:10pt;\r\n			display:block;\r\n			float:left;\r\n			margin-right:5px;\r\n		}\r\n		#mCAL .tab:hover {\r\n			color:black;\r\n		}	\r\n		#mCAL .active {\r\n			background-color:#DFE3EE;\r\n			color:#404F77;\r\n			border-bottom:solid #DFE3EE 1px;\r\n		}	\r\n		#mCAL .controls {\r\n			float:right;\r\n			vertical-align:bottom;\r\n		}\r\n		#mCAL a {\r\n			font-size:11px;\r\n			color:#517AC8;\r\n		}	\r\n		#mCAL .heading {\r\n			width:200px;\r\n			-moz-box-sizing:border-box;\r\n			background-color:#ABB7D1;\r\n			text-align:center;\r\n			font-weight:bold;\r\n			color:#374664;\r\n			font-size:9px;\r\n			letter-spacing:1px;\r\n			text-transform:uppercase;\r\n			text-align:right;\r\n			vertical-align:top;\r\n			-moz-border-radius-bottomRight:8px;\r\n			-moz-border-radius-topRight:8px;			\r\n		}\r\n		#mCAL .day {\r\n			background-color:#E9ECF3;			\r\n			width:400px;\r\n			position:relative;\r\n			vertical-align:top;		\r\n			-moz-border-radius-topLeft:8px;\r\n			-moz-border-radius-bottomLeft:8px;			\r\n			border:solid #CCD2E3 1px;\r\n		}\r\n		#mCAL .curDay {\r\n			background-color:#FFE4B3;\r\n			border-color:orange;\r\n		}\r\n		#mCAL .dayWrapper {			\r\n			height:100%;\r\n			width:100%;\r\n			position:relative;\r\n			z-index:0;\r\n			margin:0px;	\r\n			padding:0px 0px 2px 5px;;\r\n			-moz-box-sizing:border-box;\r\n		}\r\n		html > body #mCAL .dayWrapper {\r\n			height:auto;\r\n			min-height:100%;\r\n		}\r\n		#mCAL .dayNum {\r\n			width:100%;\r\n			text-align:right;\r\n			\r\n		}\r\n\r\n		#mCAL span.border {							\r\n			text-align:center;			\r\n			padding:5px;\r\n			font-weight:bold;\r\n			-moz-border-radius-bottomRight:5px;\r\n			-moz-border-radius-topLeft:5px;\r\n			color:black;			\r\n			border-right:solid #CCD2E3 1px;\r\n			border-bottom: solid #CCD2E3 1px;\r\n			background-color:#ABB7D1;\r\n			-moz-box-sizing:border-box;\r\n			top:5px;\r\n			position:relative;\r\n			\r\n		}\r\n		#mCAL .curDay span.border {\r\n			background-color:orange;\r\n			color:black;\r\n			border-color:orange;\r\n		}\r\n		#mCAL .event {\r\n			padding:3px;\r\n			padding-top:8px;\r\n			clear:left;\r\n			font-weight:bold;			\r\n		}\r\n		#mCAL .event a {\r\n			color:#4F4F4F;\r\n			text-decoration:none;\r\n			font-size:9px;\r\n		}\r\n		#mCAL .moreButton {\r\n			border-style:none;\r\n			z-index:5;\r\n			position:absolute;\r\n			bottom:0px;\r\n			width:100%;\r\n			height:9px;\r\n			background-color:#517AC8;	\r\n			font-size:5px;\r\n			text-align:center;\r\n		}\r\n		#mCAL .moreButton:hover {\r\n			background-color:orange;\r\n		}\r\n		#mCAL .empty {\r\n			border-style:none;\r\n			background-color:#CCD2E3;\r\n			-moz-border-radius:10px;\r\n			\r\n		}\r\n		#mCAL .months {\r\n			text-align:center;\r\n			background-color:#DFE3EE;			\r\n		}\r\n		#mCAL .months a {\r\n			color:#517AC8;\r\n			text-decoration:none;\r\n		}\r\n		#mCAL .months .monthLink {\r\n			text-decoration:none;			\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:#AAB8D5;\r\n			font-size:12px;\r\n			font-weight:bold;\r\n		}	\r\n		#mCAL .months .current {\r\n			color:#517AC8;\r\n		}\r\n		#mCAL .current {\r\n			font-weight:bold;\r\n			color:#517AC8;\r\n			background-color:#fff;			\r\n			-moz-border-radius:5px;\r\n		}\r\n		#mCAL .curMonth {\r\n			text-align:center;\r\n			margin: 2px 0px;\r\n			background-color:#517AC8;\r\n			color:white;\r\n			font-size:14px;\r\n			font-weight:bold;\r\n		}\r\n		\r\n		/* MORE STYLES */\r\n		#more1 {\r\n			position:absolute;\r\n			top:170px;\r\n			left:10px;			\r\n			\r\n		}\r\n		* html #more1 {\r\n			top:158px;\r\n			left:12px;\r\n\r\n		}\r\n		.moreDisplay {\r\n			border:solid orange 1px;\r\n			border-top:solid orange 2px;\r\n			font-family:arial;\r\n			font-size:10px;\r\n			width:300px;\r\n			padding:2px;\r\n			background-color:#FFD3A8;\r\n			z-index:10;			\r\n		}\r\n		ul.eventList {\r\n			margin:0px;\r\n			padding:0px;\r\n			margin-left:50px;\r\n			color:#526896;\r\n		}\r\n\r\n\r\n</style>',0,1,0,1242380147,'<style type=\"text/css\">#mCAL *{}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n			text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .curDay{background-color:#FFE4B3;border-color:orange;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #CCD2E3 1px;border-bottom:solid #CCD2E3 1px;background-color:#ABB7D1;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:orange;color:black;border-color:orange;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:50px;color:#526896;}</style>',0),('0X4Q3tBWUb_thsVbsYz9xQ',1230581176,'3','pbversion0000000000001','approved','Default Gallery Add Archive','Default Gallery Add Archive','root/import/gallery-templates/default-gallery-add-archive','3','7','3',NULL,0,1,0,0,0,3075,'	<link href=\"^/(root/import/gallery-templates/admin.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n\r\n	<!--[if IE 7]>\r\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n	<![endif]-->',0,1,0,1255485471,'<link href=\"^/(root/import/gallery-templates/admin.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('mM3bjP_iG9sv5nQb4S17tQ',1230581176,'3','pbversion0000000000001','approved','Default Gallery View Album RSS','Default Gallery View Album RSS','root/import/gallery-templates/default-gallery-album-rss','3','7','3',NULL,0,1,0,0,0,1243,NULL,0,1,0,1255485471,NULL,0),('ilu5BrM-VGaOsec9Lm7M6Q',1230581176,'3','pbversion0000000000001','approved','Default Gallery List Albums RSS','Default Gallery List Albums RSS','root/import/gallery-templates/default-gallery-list-albums-rss','3','7','3',NULL,0,1,0,0,0,1252,NULL,0,1,0,1255485471,NULL,0),('-ANLpoTEP-n4POAdRxCzRw',1230581176,'3','pbversion0000000000001','approved','Default Gallery List Files For User RSS','Default Gallery List Files For User RSS','root/import/gallery-templates/default-gallery-list-files-for-user-rss','3','7','3',NULL,0,1,0,0,0,1284,NULL,0,1,0,1255485471,NULL,0),('KAMdiUdJykjN02CPHpyZOw',1230581176,'3','pbversion0000000000001','approved','Default Gallery View Album Slideshow','Default Gallery View Album Slideshow','root/import/gallery-templates/default-gallery-view-album-slideshow','3','7','3',NULL,0,1,0,0,0,7792,'<style type=\"text/css\">\r\n	@import url(^/(root/import/gallery-templates/gallery.css););\r\n</style>\r\n	\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n	</style>\r\n<![endif]-->\r\n\r\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script> \r\n<script src=\"^Extras(yui/build/event/event-min.js);\"></script>  \r\n<script src=\"^Extras(yui/build/dom/dom-min.js);\"></script>  \r\n<script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/slideshow.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\n	var ss  = new WebGUI.Slideshow();\r\n</script>',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style><script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script><script src=\"^Extras(yui/build/event/event-min.js);\"></script><script src=\"^Extras(yui/build/dom/dom-min.js);\"></script><script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/slideshow.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/var ss=new WebGUI.Slideshow();/*]]>*/</script>',0),('itransact_credentials1',1228953856,'3','pbversion0000000000001','approved','ITransact Credentials (Default)','ITransact Credentials (Default)','shopping-cart-collateral-items/itransact-credentials','3','7','4',NULL,0,0,0,0,0,5321,'<style type=\"text/css\">\r\n	.wgAddress h2.title {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgAddress table {\r\n		margin-top:15px;\r\n	}\r\n\r\n	.wgAddress .label {\r\n		background:#000;\r\n		color:white;\r\n		font-weight:bold;\r\n		padding-left:5px;\r\n	}\r\n	.wgAddress input, .wgAddress select {\r\n		border:solid #555 1px;\r\n	}\r\n</style>\n',0,1,0,1242380149,'<style type=\"text/css\">.wgAddress h2.title{background:black;padding:5px;padding-left:15px;line-height:32px;color:white;margin:0px;height:32px;}.wgAddress table{margin-top:15px;}.wgAddress .label{background:#000;color:white;font-weight:bold;padding-left:5px;}.wgAddress input,.wgAddress select{border:solid #555 1px;}</style>',0),('StockDataTMPL000000002',1229494994,'3','pbversion0000000000001','approved','StockData Default Display','StockData Default Display','stockdatatmpl000000002','3','7','12',NULL,0,1,0,0,0,20449,NULL,0,1,0,1242380163,NULL,0),('LdiozcIUciWuvt3Z-na5Ww',1232673968,'3','pbversion0000000000001','approved','Matrix','Matrix','root/import/matrix','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1242380150,NULL,0),('kJf77eCr9GAMiEzWrzsBTA',1229639255,'3','pbversion0000000000001','approved','matrix-ie.css','matrix-ie.css','new-matrix/matrix-ie.css','3','7','12',NULL,0,1,0,0,0,764,NULL,0,1,0,1242380150,NULL,0),('4LQT4-bGW4FkiEQLSY5gvQ',1232400287,'3','pbversion0000000000001','approved','show-hide.js','show-hide.js','new-matrix/show-hide.js','3','7','12',NULL,0,1,0,0,0,933,NULL,0,1,0,1242380142,NULL,0),('QHn6T9rU7KsnS3Y70KCNTg',1233173545,'3','pbversion0000000000001','approved','Account','Account','root/import/account','3','7','12',NULL,0,1,0,0,0,320,NULL,0,1,0,1250190873,NULL,0),('HW-sPoDDZR8wBZ0YgFgPtg',1227634350,'3','pbversion0000000000001','approved','images','images','root/import/account/images','3','7','12',NULL,0,1,0,0,0,331,NULL,0,1,0,1250190873,NULL,0),('hBpisL-_URyZnh9clR5ohA',1227634417,'3','pbversion0000000000001','approved','no_photo.gif','no_photo.gif','root/import/account/images/no_photo.gif','3','7','12',NULL,0,1,0,0,0,2564,NULL,0,1,0,1250190873,NULL,0),('FOBV6KkifreXa4GmEAUU4A',1227634447,'3','pbversion0000000000001','approved','no_photo_sm.gif','no_photo_sm.gif','root/import/account/images/no_photo_sm.gif','3','7','12',NULL,0,1,0,0,0,1580,NULL,0,1,0,1250190873,NULL,0),('TuYPpHx7TUyk08639Pc8Bg',1233861621,'3','pbversion0000000000001','approved','Default DataTable Template (HTML)','Default DataTable Template (HTML)','root/import/datatable/default-datatable-template-html','3','7','3',NULL,0,1,0,0,0,1360,NULL,0,1,0,1242380164,NULL,0),('3rjnBVJRO6ZSkxlFkYh_ug',1233861835,'3','pbversion0000000000001','approved','Default DataTable Template (YUI)','Default DataTable Template (YUI)','root/import/datatable/default-datatable-template-yui','3','7','3',NULL,0,1,0,0,0,1023,NULL,0,1,0,1242380142,NULL,0),('6X-7Twabn5KKO_AbgK3PEw',1233872216,'3','pbversion0000000000001','approved','Default Gallery Edit Album','Default Gallery Edit Album','root/import/gallery-templates/default-gallery-edit-album','3','7','3',NULL,0,1,0,0,0,6148,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('7JCTAiu1U_bT9ldr655Blw',1233872075,'3','pbversion0000000000001','approved','Default Gallery Edit Photo','Default Gallery Edit Photo','root/import/gallery-templates/default-gallery-edit-photo','3','7','3',NULL,0,1,0,0,0,7124,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('m3IbBavqzuKDd2PGGhKPlA',1233871747,'3','pbversion0000000000001','approved','Default Gallery Make Shortcut','Default Gallery Make Shortcut','root/import/gallery-templates/default-gallery-make-shortcut','3','7','3',NULL,0,1,0,0,0,4843,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('zcX-wIUct0S_np14xxOA-A',1234568742,'3','pbversion0000000000001','approved','Default Gallery Delete File','Default Gallery Delete File','root/import/gallery-templates/default-gallery-delete-file','3','7','3',NULL,0,1,0,0,0,4466,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('OxJWQgnGsgyGohP2L3zJPQ',1234564647,'3','pbversion0000000000001','approved','Default Gallery Edit Comment','Default Gallery Edit Comment','root/import/gallery-templates/default-gallery-edit-comment','3','7','3',NULL,0,1,0,0,0,5463,'<link rel=\"stylesheet\" href=\"^/(root/import/gallery-templates/gallery.css);\" type=\"text/css\" />',0,1,0,1255485471,'<link rel=\"stylesheet\" href=\"^/(root/import/gallery-templates/gallery.css);\" type=\"text/css\" />',0),('azCqD0IjdQSlM3ar29k5Sg',1234561066,'3','pbversion0000000000001','approved','Default Gallery List Albums View','Default Gallery List Albums View','root/import/gallery-templates/default-gallery-list-albums-view','3','7','3',NULL,0,1,0,0,0,5772,'	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery.css););\r\n	</style>\r\n	\r\n	<!--[if IE ]>\r\n		<style type=\"text/css\">\r\n			@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n		</style>\r\n	<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('OkphOEdaSGTXnFGhK4GT5A',1234560760,'3','pbversion0000000000001','approved','Default Gallery List Files For User','Default Gallery List Files For User','root/import/gallery-templates/default-gallery-list-files-for-user','3','7','3',NULL,0,1,0,0,0,7618,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('jME5BEDYVDlBZ8jIQA9-jQ',1234565056,'3','pbversion0000000000001','approved','Default Gallery Search','Default Gallery Search','root/import/gallery-templates/default-gallery-search','3','7','3',NULL,0,1,0,0,0,10749,'\n<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n	\n<!--[if IE]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('TEId5V-jEvUULsZA0wuRuA',1234568469,'3','pbversion0000000000001','approved','Default Gallery View Photo','Default Gallery View Photo','root/import/gallery-templates/default-gallery-view-photo','3','7','3',NULL,0,1,0,0,0,12325,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<script type=\"text/javascript\">\nfunction toggleView( link, first, second, eid ) {\n	var e = document.getElementById( eid );\n	if ( e.style.display == \"none\" ) {\n		e.style.display = \"block\";\n		link.innerHTML = second;\n	}\n	else {\n		e.style.display = \"none\";\n		link.innerHTML = first;\n	}\n}\n</script>',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style><script type=\"text/javascript\">/*<![CDATA[*/function toggleView(a,b,c,d){var e=document.getElementById(d);if(e.style.display==\"none\"){e.style.display=\"block\";a.innerHTML=c}else{e.style.display=\"none\";a.innerHTML=b}}/*]]>*/</script>',0),('wrq7hMxb1ewQqZ46xmd8Gg',1235706620,'3','pbversion0000000000001','approved','equal-cols.js','equal-cols.js','matrix/equal-cols.js','3','7','12',NULL,0,1,0,0,0,796,NULL,0,1,0,1242380165,NULL,0),('Vch1Ww7G_JpBhOhXX07RDg',1235705952,'3','pbversion0000000000001','approved','matrx-nav','matrix-nav','new-matrix/matrix-nav','3','7','12',NULL,0,1,0,0,0,375,NULL,0,1,0,1242380164,NULL,0),('aIpCmr9Hi__vgdZnDTz1jw',1237379632,'3','pbversion0000000000001','approved','Cart (Default)','Cart (Default)','default-shopping-cart-template','3','7','3',NULL,0,1,0,0,0,11646,'	<style type=\"text/css\">\r\n			#shoppingCart {\r\n				font-family:arial;\r\n				font-size:12px;\r\n			}\r\n\r\n			#shoppingCart tr.header td {\r\n				font-weight:bold;\r\n				text-align:right;\r\n				padding:3px 5px;\r\n			}\r\n\r\n			#shoppingCart tr.data td {\r\n				text-align:right;\r\n				padding:3px 5px;\r\n			}\r\n\r\n			#chooseAddressButton, #checkoutButton {\r\n				color: white;\r\n				background-color: green;					\r\n			}\r\n			#shoppingCart tr.alt td {\r\n				background-color:#F0F0F0;\r\n			}\r\n			#shoppingCart tr.alt td.delete {\r\n				padding-left:10px;\r\n				-moz-border-radius-topLeft:10px;\r\n				-moz-border-radius-bottomLeft:10px;\r\n				border-top-left-radius:10px;\r\n				border-bottom-left-radius:10px;\r\n			}\r\n			#shoppingCart tr.alt td.shipping {\r\n				padding-right:10px;\r\n				-moz-border-radius-topRight:10px;\r\n				-moz-border-radius-bottomRight:10px;\r\n				border-top-right-radius:10px;\r\n				border-bottom-right-radius:10px;\r\n			}\r\n			#shoppingCart tr.topLine td {\r\n				margin-top:10px;\r\n				border-top:solid silver 1px;\r\n			}\r\n			#shoppingCart tr.summary td {\r\n				background-color: #f3f3f3;\r\n				padding:5px 10px 5px 10px;\r\n			}\r\n			#shoppingCart .summary .empty {\r\n				background-color: transparent;\r\n				border-style:none;\r\n			}\r\n			#shoppingCart .summary .topLeft {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\r\n			}\r\n			#shoppingCart .summary .topRight {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\r\n			}\r\n			#shoppingCart .summary .bottomLeft {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\r\n			}\r\n			#shoppingCart .summary .bottomRight {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\r\n			}\r\n			#shoppingCart .summary select {\r\n				padding-right:0px;\r\n				text-align:left;\r\n			}\r\n			#shoppingCart tr.bottomLine td {\r\n				border-bottom: solid 1px silver;\r\n			}\r\n			#shoppingCart tr.topLine td {\r\n				border-top: solid 1px #fff;\r\n			}\r\n		</style>',0,1,0,1255485470,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#chooseAddressButton,#checkoutButton{color:white;background-color:green;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}</style>',0),('matrixtmpl000000000006',1236889702,'3','pbversion0000000000001','approved','Matrix Default Screenshots','Matrix Default Screenshots','matrix-default-screenshots','3','7','12',NULL,0,0,0,0,0,2864,NULL,0,1,0,1255485470,NULL,0),('AOjPG2NHgfL9Cq6dDJ7mew',1236960881,'3','pbversion0000000000001','approved','Shop','Shop','root/import/account/shop','3','7','12',NULL,0,1,0,0,0,325,NULL,0,1,0,1250190873,NULL,0),('05FpjceLYhq4csF1Kww1KQ',1236641791,'3','pbversion0000000000001','approved','Default Gallery View Album','Default Gallery View Album','root/import/gallery-templates/default-gallery-view-album','3','7','3',NULL,0,1,0,0,0,7698,'	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery.css););\n	</style>\n	\n	<!--[if IE ]>\n		<style type=\"text/css\">\n			@import url(^/(root/import/gallery-templates/gallery-ie.css););\n		</style>\n	<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('TvOZs8U1kRXLtwtmyW75pg',1255485472,'3','pbversion0000000000001','approved','Article','Article','root/import/article','3','7','12',NULL,0,0,0,0,0,322,'\r\n',0,1,0,1255485475,NULL,0),('zb_OPKNqcTuIjdvvbEkRjw',1255485472,'3','pbversion0000000000001','approved','article.css','article.css','article.css','3','7','12',NULL,0,1,0,0,0,733,'\r\n',0,1,0,1255485475,NULL,0),('VyCINX2KixKYr2pzQGX9Mg',1255485472,'3','pbversion0000000000001','approved','layout.css','layout.css','layout.css','3','7','12',NULL,0,1,0,0,0,1388,'\r\n',0,1,0,1255485476,NULL,0),('FJbUTvZ2nUTn65LpW6gjsA',1255485472,'3','pbversion0000000000001','approved','Profile Account Layout','Profile Account Layout','root/import/account/profile/profile-account-layout','3','7','12',NULL,0,1,0,0,0,4101,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0,1,0,1255485475,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('_XfvgNH__bY1ykMiKYSobQ',1255485472,'3','pbversion0000000000001','approved','account.css','account.css','root/import/account/account.css','3','7','12',NULL,0,1,0,0,0,42908,NULL,0,1,0,1255485475,NULL,0),('GNOAsX98vCsl0JRwfwL-gg',1255485473,'3','pbversion0000000000001','approved','Collaboration','Collaboration','root/import/collaboration','3','7','12',NULL,0,0,0,0,0,338,NULL,0,1,0,1255485475,NULL,0),('PBtmpl0000000000000066',1255485473,'3','pbversion0000000000001','approved','Default USS','Default USS','default_uss','3','7','12',NULL,0,1,0,0,0,4949,'<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n\n</style>\n\n\n',0,1,0,1255485475,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000080',1255485473,'3','pbversion0000000000001','approved','FAQ','FAQ','faqtemplate','3','7','12',NULL,0,1,0,0,0,3916,NULL,0,1,0,1255485475,NULL,0),('PBtmpl0000000000000097',1255485473,'3','pbversion0000000000001','approved','Traditional with Thumbnails','Traditional with Thumbnails','traditional_with_thumbnails','3','7','12',NULL,0,1,0,0,0,6623,'<style type=\"text/css\">\n.forumHead {\n	background-color: #DADADA;\n	border: 2px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n	font-family:arial;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;	\n	font-family:arial;\n}\n.forumHead a\n{\n	color:#29587E;\n}\n.oddThread a\n{\n	color:#29587E;\n}\n.evenThread a\n{\n	color:#29587E;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n	background-color:#EEEEEE;\n	font-family:arial;\n}\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.pagination a:hover {\n	text-decoration:none;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1255485475,'<style type=\"text/css\">.forumHead{background-color:#DADADA;border:2px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;font-family:arial;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;font-family:arial;}.forumHead a{color:#29587E;}.oddThread a{color:#29587E;}.evenThread a{color:#29587E;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;background-color:#EEEEEE;font-family:arial;}.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}h2{font-family:arial;}</style>',0),('NBVSVNLp9X_bV7WrCprtCA',1237842096,'3','pbversion0000000000001','approved','Annotate Image','Annotate Image','image3','3','7','12',NULL,0,1,0,0,0,675,NULL,0,1,0,1255485469,NULL,0),('jmlI9IK-lV8n2WMYmmPhAA',1238106173,'3','pbversion0000000000001','approved','Ad Sku','Ad Sku','root/import/ad-sku','3','7','12',NULL,0,1,0,0,0,317,NULL,0,1,0,1242380149,NULL,0),('PBtmpl0000000000000015',1237647040,'3','pbversion0000000000001','approved','Default WebGUI Welcome Message Template','Default WebGUI Welcome Message Template','root/import/auth/webgui/create/default-webgui-welcome-message-template','3','7','12',NULL,0,1,0,0,0,696,NULL,0,1,0,1253052785,NULL,0),('ThingyTmpl000000000001',1237914005,'3','pbversion0000000000001','approved','Default Thingy','Default Thingy','templates/thingy-default','3','7','12',NULL,0,0,0,0,0,2531,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>',0,1,0,1255485470,'<style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('6uvSLY-ak_w4p_wS8q33cA',1239213092,'3','pbversion0000000000001','approved','Carousel','Carousel','root/import/carousel','3','7','12',NULL,0,1,0,0,0,323,NULL,0,1,0,1242380142,NULL,0),('CarouselTmpl0000000002',1239475937,'3','pbversion0000000000001','approved','Carousel hidden textareas','Carousel hidden textareas','root/import/carousel/carousel-hidden-textareas','3','7','12',NULL,0,0,0,0,0,1048,NULL,0,1,0,1255485470,NULL,0),('GaBAW-2iVhLMJaZQzVLE5A',1240103565,'3','pbversion0000000000001','approved','ThingyRecord Templates','ThingyRecord Templates','root/import/thingyrecord-templates','3','7','3',NULL,0,0,0,0,0,364,NULL,0,1,0,1242380149,NULL,0),('b1316COmd9xRv4fCI3LLGA',1236956475,'3','pbversion0000000000001','approved','Inbox Notification','Inbox Notification','inbox_notification','3','7','4',NULL,0,0,0,0,0,414,NULL,0,1,0,1255485470,NULL,0),('lo1rpxn3t8YPyKGers5eQg',1238625621,'3','pbversion0000000000001','approved','Friend Manager','Friend Manager','root/import/account/friendmanager','3','7','12',NULL,0,1,0,0,0,388,NULL,0,1,0,1242380168,NULL,0),('64tqS80D53Z0JoAs2cX2VQ',1239400975,'3','pbversion0000000000001','approved','FriendManager View Template','FriendManager View Template','root/import/account/friendmanager/view','3','7','4',NULL,0,0,0,0,0,4432,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\"                     rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/paginator/assets/skins/sam/button.css);\"    rel=\"stylesheet\" type=\"text/css\" />\n\n<script src=\"^Extras(yui/build/utilities/utilities.js);\"              type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/json/json-min.js);\"                    type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"  type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/element/element-min.js);\"              type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/paginator/paginator-min.js);\"          type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/datasource/datasource-min.js);\"        type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/datatable/datatable-min.js);\"          type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/button/button-min.js);\"                type=\"text/javascript\"></script>\n<script src=\"^Extras(yui-webgui/build/i18n/i18n.js);\"                 type=\"text/javascript\"></script>\n\n<script src=\"^Extras(yui-webgui/build/friendManager/friendManager.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\"> #paging a { color: #0000de; } #search form { display: inline; } </style>\n\n',0,1,0,1255485470,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/paginator/assets/skins/sam/button.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/element/element-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/button/button-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui-webgui/build/i18n/i18n.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui-webgui/build/friendManager/friendManager.js);\" type=\"text/javascript\"></script><style type=\"text/css\">#paging a{color:#0000de;}#search form{display:inline;}</style>',0),('lG2exkH9FeYvn4pA63idNg',1239383808,'3','pbversion0000000000001','approved','Friend Manager Edit Friends','Friend Manager Edit Friends','root/import/account/friendmanager/edit','3','7','4',NULL,0,0,0,0,0,2555,'<style>\ndiv.fmAdd, div.fmRemove {\n    float: left;\n    margin: 5px;\n    padding: 3px;\n}\n\n</style>',0,1,0,1253052785,'<style>\ndiv.fmAdd, div.fmRemove {\n    float: left;\n    margin: 5px;\n    padding: 3px;\n}\n\n</style>',0),('XNd7a_g_cTvJVYrVHcx2Mw',1242306865,'3','pbversion0000000000001','approved','Address (Default)','Address (Default)','shopping-cart-collateral-items/address-default','3','7','3',NULL,0,1,0,0,0,5814,'<style type=\"text/css\">\r\n	.wgAddress h2.title {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgAddress table {\r\n		margin-top:15px;\r\n	}\r\n\r\n	.wgAddress .label {\r\n		background:#000;\r\n		color:white;\r\n		font-weight:bold;\r\n		padding-left:5px;\r\n	}\r\n	.wgAddress input, .wgAddress select {\r\n		border:solid #555 1px;\r\n	}\r\n\r\n        .copyFromProfileButtons form, .copyFromProfileButtons div {\r\n                display : inline;\r\n        }\r\n\r\n</style>\r\n',0,1,0,1255485470,'<style type=\"text/css\">.wgAddress h2.title{background:black;padding:5px;padding-left:15px;line-height:32px;color:white;margin:0px;height:32px;}.wgAddress table{margin-top:15px;}.wgAddress .label{background:#000;color:white;font-weight:bold;padding-left:5px;}.wgAddress input,.wgAddress select{border:solid #555 1px;}.copyFromProfileButtons form,.copyFromProfileButtons div{display:inline;}</style>',0),('D6cJpRcey35aSkh9Q_FPUQ',1242407725,'3','pbversion0000000000001','approved','Default EU User Screen','Default EU User Screen','root/import/default-eu-user-screen','3','7','12',NULL,0,1,0,0,0,1605,NULL,0,1,0,1255485470,NULL,0),('2rC4ErZ3c77OJzJm7O5s3w',1242467983,'3','pbversion0000000000001','approved','EMS Badge Listing (default)','EMS Badge Listing (default)','root/import/ems/ems-badge-listing-default','3','7','12',NULL,0,1,0,0,0,10220,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n\r\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n\r\n		<style type=\"text/css\">\r\n		.badgeDescription {\r\n		background-color: white;\r\n		max-width: 400px;\r\n		border:1px solid #000;\r\n		padding:10px;\r\n		}\r\n		.forwardButton {\r\n			background-color: green;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		.backwardButton {\r\n			background-color: red;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		</style>\r\n',0,1,0,1255485471,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">.badgeDescription{background-color:white;max-width:400px;border:1px solid #000;padding:10px;}.forwardButton{background-color:green;color:white;font-weight:bold;padding:3px;}.backwardButton{background-color:red;color:white;font-weight:bold;padding:3px;}</style>',0),('matrixtmpl000000000007',1242660972,'3','pbversion0000000000001','approved','Matrix Default Screenshots Config','Matrix Default Screenshots Config','matrix-default-screenshots-config','3','7','12',NULL,0,0,0,0,0,3765,NULL,0,1,0,1255485469,NULL,0),('kj3b-X3i6zRKnhLb4ZiCLw',1243445504,'3','pbversion0000000000001','approved','Default Calendar List View','Default Calendar List View','root/import/calendar-templates/default-calendar-list-view','3','7','3',NULL,0,1,0,0,0,5680,'<style type=\"text/css\">\n	#wgListView * {\n		padding:0px;\n		margin:0px;\n	}	\n	#wgListView a:link,\n	#wgListView a:visited {			\n		font-weight:bold;\n	}\n	#wgListView .newUnit {\n		font-weight:bold;\n	}\n	#wgListView .allEvents {\n		padding-left:20px;\n	}\n	#wgListView .controls {\n		margin-top:20px;\n	}	\n	#wgListView .tab:link,\n	#wgListView .tab:visited {;\n		font-weight: bold;\n		padding: 2px 15px 0px 15px;\n		text-align: center;\n		font-size: 15px;\n		line-height:15px;\n		margin-right: 5px;		\n	}\n	#wgListView .bar {\n		text-align:right;\n	}\n	* html #wgListView .bar {\n		height:1%;\n	}\n	#wgListView .bar a:hover {\n		text-decoration:underline;\n	}\n	#wgListView .allEvents {\n		padding:15px;\n	}\n	#wgListView .event {\n		margin:10px 0px;\n	}\n	#wgListView .event .wgDate {\n		font-size:9px;\n		font-style:italic;\n	}\n	#wgListView h3 a:link,\n	#wgListView h3 a:visited {\n		font-size:16px;\n		margin-bottom:2px;\n	}\n</style>\n',0,1,0,1255485471,'<style type=\"text/css\">#wgListView *{padding:0px;margin:0px;}#wgListView a:link,#wgListView a:visited{font-weight:bold;}#wgListView .newUnit{font-weight:bold;}#wgListView .allEvents{padding-left:20px;}#wgListView .controls{margin-top:20px;}#wgListView .tab:link,#wgListView .tab:visited{;font-weight:bold;padding:2px 15px 0px 15px;text-align:center;font-size:15px;line-height:15px;margin-right:5px;}#wgListView .bar{text-align:right;}* html #wgListView .bar{height:1%;}#wgListView .bar a:hover{text-decoration:underline;}#wgListView .allEvents{padding:15px;}#wgListView .event{margin:10px 0px;}#wgListView .event .wgDate{font-size:9px;font-style:italic;}#wgListView h3 a:link,#wgListView h3 a:visited{font-size:16px;margin-bottom:2px;}</style>',0),('UTNFeV7B_aSCRmmaFCq4Vw',1244073447,'3','pbversion0000000000001','approved','Default Gallery Delete Album','Default Gallery Delete Album','root/import/gallery-templates/default-gallery-delete-album','3','7','3',NULL,0,1,0,0,0,4444,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('iCYOjohB9SKvAPr6bXElKA',1247779898,'3','pbversion0000000000001','approved','Get Hosting','Get Hosting','yns/hosting','3','7','4',NULL,0,1,0,0,0,697,NULL,0,1,0,1247779898,NULL,0),('YP9WaMPJHvCJl-YwrLVcPw',1245376837,'3','pbversion0000000000001','approved','Progress Bar','Progress Bar','admin_progress_bar','3','7','12',NULL,0,1,0,0,0,2586,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" />\n<script type=\"text/javascript\">\n/** updateWgProgressBar()\n  * called every time the server sends updated progress\n  * convenient place to hook in your own UI behaviour\n*/\nfunction updateWgProgressBar(counter, message) {\n    document.getElementById(\"progressMeter\").style.width = counter;\n    document.getElementById(\"progressStatus\").innerHTML = message;\n}\n</script>',0,1,0,1255485469,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" /><script type=\"text/javascript\">/*<![CDATA[*/function updateWgProgressBar(a,b){document.getElementById(\"progressMeter\").style.width=a;document.getElementById(\"progressStatus\").innerHTML=b}/*]]>*/</script>',0),('3n3H85BsdeRQ0I08WmvlOg',1245107956,'3','pbversion0000000000001','approved','thingy.css','thingy.css','root/import/thingy-templates/thingy.css','3','7','12',NULL,0,1,0,0,0,4731,NULL,0,1,0,1245445679,NULL,0),('FOvmwGC0GtZo5VTxJIL3OA',1247779862,'3','pbversion0000000000001','approved','Get Documentation','Get Documentation','yns/docs','3','7','4',NULL,0,1,0,0,0,622,NULL,0,1,0,1247779862,NULL,0),('Wl8WZ43g2rK5AYr9o4zY7w',1247779880,'3','pbversion0000000000001','approved','Get Style','Get Style','yns/style','3','7','4',NULL,0,1,0,0,0,607,NULL,0,1,0,1247779880,NULL,0),('FEDP3dk8J3Chw_gyr7_XEQ',1246278679,'3','pbversion0000000000001','approved','navigation.css','navigation.css','navigation.css','3','7','12',NULL,0,1,0,0,0,2676,NULL,0,1,0,1247779656,NULL,0),('f_tn9FfoSfKWX43F83v_3w',1247053009,'3','pbversion0000000000001','approved','Search','Search','root/import/search','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1247779657,NULL,0),('oGfxez5sksyB_PcaAsEm_Q',1247053097,'3','pbversion0000000000001','approved','SyndicatedContent','SyndicatedContent','root/import/syndicatedcontent','3','7','12',NULL,0,0,0,0,0,350,NULL,0,1,0,1247779657,NULL,0),('tPagC0AQErZXjLFZQ6OI1g',1246966459,'3','pbversion0000000000001','approved','ImageAsset','ImageAsset','root/import/imageasset','3','7','12',NULL,0,0,0,0,0,329,NULL,0,1,0,1247779656,NULL,0),('pbtmpl0000000000000220',1247488979,'3','pbversion0000000000001','approved','Flash Style 3 Template','Flash Style 3 Template','flash-style-3-template','3','7','12',NULL,0,0,0,0,0,1377,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script>\r\n<script type=\"text/javascript\">\r\n	swfobject.registerObject(\"myFlashContent\", \"9.0.0\", \"^Extras(ukplayer/expressinstall.swf\"););\r\n</script>\r\n',0,1,0,1255485470,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/swfobject.registerObject(\"myFlashContent\",\"9.0.0\",\"^Extras(ukplayer/expressinstall.swf\"););/*]]>*/</script>',0),('PBtmpl0000000000000001',1247535846,'3','pbversion0000000000001','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,5858,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" />\n<script src=\"^Extras(adminConsole/adminConsole.js);\" type=\"text/javascript\"></script>',0,1,0,1255485471,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" /><script src=\"^Extras(adminConsole/adminConsole.js);\" type=\"text/javascript\"></script>',0),('GYaFxnMu9UsEG8oanwB6TA',1246965871,'3','pbversion0000000000001','approved','Folder','Folder','root/import/folder','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1247779656,NULL,0),('pbtmpl0000000000000221',1247487940,'3','pbversion0000000000001','approved','Flash Tutorial Template','Flash Tutorial Template','flash-tutorial-template','3','7','12',NULL,0,0,0,0,0,2088,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script>\r\n<script type=\"text/javascript\">\r\n	swfobject.registerObject(\"myFlashContent\", \"9.0.0\", \"^Extras(ukplayer/expressinstall.swf\"););\r\n</script>\r\n',0,1,0,1255485469,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/swfobject.registerObject(\"myFlashContent\",\"9.0.0\",\"^Extras(ukplayer/expressinstall.swf\"););/*]]>*/</script>',0),('VZK3CRgiMb8r4dBjUmCTgQ',1247046242,'3','pbversion0000000000001','approved','Poll','Poll','root/import/poll','3','7','12',NULL,0,0,0,0,0,311,NULL,0,1,0,1247779656,NULL,0),('PcRRPhh-0KfvLLNIPdxJTw',1247055282,'3','pbversion0000000000001','approved','webgui.css','webgui.css','webgui.css','3','7','3',NULL,0,1,0,0,0,721,NULL,0,1,0,1253052783,NULL,0),('i5kt5aodVs_oepNEkE7Okw',1242312883,'3','pbversion0000000000001','approved','poll.css','poll.css','poll.css','3','7','12',NULL,0,1,0,0,0,499,NULL,0,1,0,1247779656,NULL,0),('tXwf1zaOXTvsqPn6yu-GSw',1246965607,'3','pbversion0000000000001','approved','FileAsset','FileAsset','root/import/fileasset','3','7','12',NULL,0,0,0,0,0,326,NULL,0,1,0,1247779656,NULL,0),('nFen0xjkZn8WkpM93C9ceQ',1247864696,'3','pbversion0000000000001','approved','Shelf (Default)','Shelf (Default)','root/import/shelf-default','3','7','12',NULL,0,1,0,0,0,4327,'<style type=\"text/css\">\n	@import url(^/(root/import/shelf2/shelf.css););\n</style>\n<!--[if IE]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/shelf2/shelf-ie.css););\n	</style>\n<![endif]-->',0,1,0,1255485470,'<style type=\"text/css\">@import url(^/(root/import/shelf2/shelf.css);</style>',0),('kaPRSaf8UKiskiGEgJgLAw',1250190850,'3','pbversion0000000000001','approved','images','images','root/import/gallery-templates/images','3','7','3',NULL,0,0,0,0,0,340,NULL,0,1,0,1250190876,NULL,0),('brxm_faNdZX5tRo3p50g3g',1250190850,'3','pbversion0000000000001','approved','Map Templates','Map Templates','home/map/map-templates','3','7','3',NULL,0,0,0,0,0,334,NULL,0,1,0,1250190876,NULL,0),('75CmQgpcCSkdsL-oawdn3Q',1248549085,'3','pbversion0000000000001','approved','Default Edit Profile Template','Default Edit Profile Template','root/import/account/profile/default-edit-profile-template','3','7','12',NULL,0,1,0,0,0,3283,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function() {\n    var tabView = new YAHOO.widget.TabView(\'wgAccountTabs\');\n});\n</script>',0,1,0,1255485469,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){var a=new YAHOO.widget.TabView(\'wgAccountTabs\')});/*]]>*/</script>',0),('2CS-BErrjMmESOtGT90qOg',1248549087,'3','pbversion0000000000001','approved','Default View Profile Template','Default View Profile Template','root/import/account/profile/default-view-profile-template','3','7','12',NULL,0,1,0,0,0,7546,NULL,0,1,0,1255485469,NULL,1),('MBmWlA_YEA2I6D29OMGtRg',1248549086,'3','pbversion0000000000001','approved','Default Profile Error Template','Default Profile Error Template','root/import/account/profile/default-profile-error-template','3','7','12',NULL,0,1,0,0,0,1211,NULL,0,1,0,1255485469,NULL,0),('gfZOwaTWYjbSoVaQtHBBEw',1249407461,'3','pbversion0000000000001','approved','Inbox Account Layout','Inbox Account Layout','root/import/account/inbox-account-layout','3','7','12',NULL,0,1,0,0,0,3141,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0,1,0,1255485469,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('0n4HtbXaWa_XJHkFjetnLQ',1248549086,'3','pbversion0000000000001','approved','Default Inbox View Message Template','Default Inbox View Message Template','root/import/account/inbox/default-inbox-view-message-template','3','7','12',NULL,0,1,0,0,0,4962,NULL,0,1,0,1255485469,NULL,0),('ErEzulFiEKDkaCDVmxUavw',1248549086,'3','pbversion0000000000001','approved','Default Inbox Error Template','Default Inbox Error Template','root/import/account/inbox/default-inbox-error-template','3','7','12',NULL,0,1,0,0,0,730,NULL,0,1,0,1255485469,NULL,0),('6uQEULvXFgCYlRWnYzZsuA',1248549086,'3','pbversion0000000000001','approved','Default Inbox Send Message Template','Default Inbox Send Message Template','root/import/account/inbox/default-inbox-send-message-template','3','7','12',NULL,0,1,0,0,0,8966,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras;yui/build/container/assets/skins/sam/container.css\" />\n\n<script>\n   var removeText = \'^International(remove text,Account_Inbox);\';\n</script>\n<script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\n<script type=\"text/javascript\" src=\"^Extras;yui/build/container/container-min.js\"></script>\n<script type=\"text/javascript\" src=\"^Extras;account/inbox.js\"></script>',0,1,0,1255485469,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras;yui/build/container/assets/skins/sam/container.css\" /><script>\n   var removeText = \'^International(remove text,Account_Inbox);\';\n</script><script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script><script type=\"text/javascript\" src=\"^Extras;yui/build/container/container-min.js\"></script><script type=\"text/javascript\" src=\"^Extras;account/inbox.js\"></script>',0),('DUoxlTBXhVS-Zl3CFDpt9g',1248549086,'3','pbversion0000000000001','approved','Default Message Confirm Template','Default Message Confirm Template','root/import/account/inbox/default-message-confirm-template','3','7','12',NULL,0,1,0,0,0,783,NULL,0,1,0,1255485470,NULL,0),('1Q4Je3hKCJzeo0ZBB5YB8g',1248549086,'3','pbversion0000000000001','approved','Default Manage Invitations Template','Default Manage Invitations Template','root/import/account/inbox/default-manage-invitations-template','3','7','12',NULL,0,1,0,0,0,9680,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function(){\n   function isMessageCheckBox( element ) {\n      if(element.name == \"inviteId\") return true;\n      return false;\n   }\n   \n   function toggleAllChecked(evt) {\n      var allBox     = YAHOO.util.Dom.get(\"check_all\");\n      var checkBoxes = YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"inboxTbl\");\n      for (var i = 0; i < checkBoxes.length; i++) {\n         checkBoxes[i].checked = allBox.checked;\n      }\n   }\n   \n   YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked);\n});\n</script>',0,1,0,1255485470,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){function isMessageCheckBox(a){if(a.name==\"inviteId\")return true;return false}function toggleAllChecked(b){var a=YAHOO.util.Dom.get(\"check_all\");var c=YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"inboxTbl\");for(var i=0;i<c.length;i++){c[i].checked=a.checked}}YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked)});/*]]>*/</script>',0),('5A8Hd9zXvByTDy4x-H28qw',1248549086,'3','pbversion0000000000001','approved','Default Invitation Confirmation Template','Default Invitation Confirmation Template','root/import/account/inbox/default-invitation-confirmation-template','3','7','12',NULL,0,1,0,0,0,1540,NULL,0,1,0,1255485470,NULL,0),('VBkY05f-E3WJS50WpdKd1Q',1248549087,'3','pbversion0000000000001','approved','Default View Invitation Template','Default View Invitation Template','root/import/account/inbox/default-view-invitation-template','3','7','12',NULL,0,1,0,0,0,3807,NULL,0,1,0,1255485470,NULL,0),('XgcsoDrbC0duVla7N7JAdw',1248549086,'3','pbversion0000000000001','approved','Default Invite User Email Template','Default Invite User Email Template','root/import/account/inbox/default-invite-user-email-template','3','7','12',NULL,0,1,0,0,0,489,NULL,0,1,0,1255485470,NULL,0),('cR0UFm7I1qUI2Wbpj--08Q',1248549086,'3','pbversion0000000000001','approved','Default Invite User Form Template','Default Invite User Form Template','root/import/account/inbox/default-invite-user-form-template','3','7','12',NULL,0,1,0,0,0,3933,NULL,0,1,0,1255485470,NULL,0),('SVIhz68689hwUGgcDM-gWw',1248549086,'3','pbversion0000000000001','approved','Default Invite User Confirm Template','Default Invite User Confirm Template','root/import/account/inbox/default-invite-user-confirm-template','3','7','12',NULL,0,1,0,0,0,817,NULL,0,1,0,1255485470,NULL,0),('zrNpGbT3odfIkg6nFSUy8Q',1249407461,'3','pbversion0000000000001','approved','Friends Layout Template','Friends Layout Template','root/import/account/friends/friends-layout-template','3','7','12',NULL,0,1,0,0,0,2552,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1255485470,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('1Yn_zE_dSiNuaBGNLPbxtw',1248549086,'3','pbversion0000000000001','approved','Default Friends View Template','Default Friends View Template','root/import/account/friends/default-friends-view-template','3','7','12',NULL,0,1,0,0,0,8014,NULL,0,1,0,1255485470,NULL,0),('AZFU33p0jpPJ-E6qLSWZng',1248549086,'3','pbversion0000000000001','approved','Default Friends Edit Template','Default Friends Edit Template','root/import/account/friends/default-friends-edit-template','3','7','12',NULL,0,1,0,0,0,9770,NULL,0,1,0,1255485470,NULL,0),('AGJBGviWGAwjnwziiPjvDg',1248549087,'3','pbversion0000000000001','approved','Default Send Request Template','Default Send Request Template','root/import/account/friends/default-send-request-template','3','7','12',NULL,0,1,0,0,0,2757,NULL,0,1,0,1255485470,NULL,0),('7Ijdd8SW32lVgg2H8R-Aqw',1248549086,'3','pbversion0000000000001','approved','Default Friends Error Template','Default Friends Error Template','root/import/account/friends/default-friends-error-template','3','7','12',NULL,0,1,0,0,0,772,NULL,0,1,0,1255485470,NULL,0),('K8F0j_cq_jgo8dvWY_26Ag',1248549086,'3','pbversion0000000000001','approved','Default Friends Confirmation Template','Default Friends Confirmation Template','root/import/account/friends/default-friends-confirmation-template','3','7','12',NULL,0,1,0,0,0,938,NULL,0,1,0,1255485470,NULL,0),('G5V6neXIDiFXN05oL-U3AQ',1248549087,'3','pbversion0000000000001','approved','Default Remove Friends Confirmation Template','Default Remove Friends Confirmation Template','root/import/account/friends/default-remove-friends-confirmation-template','3','7','12',NULL,0,1,0,0,0,1162,NULL,0,1,0,1255485470,NULL,0),('9ThW278DWLV0-Svf68ljFQ',1249407460,'3','pbversion0000000000001','approved','Account Layout','Account Layout','root/import/account/user/account-layout','3','7','12',NULL,0,1,0,0,0,1619,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1255485470,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('-zxyB-O50W8YnL39Ouoc4Q',1248563425,'3','pbversion0000000000001','approved','Default My Sales Template','Default My Sales Template','root/import/default-my-sales-template','3','7','12',NULL,0,1,0,0,0,3621,NULL,0,1,0,1255485470,NULL,0),('b4n3VyUIsAHyIvT-W-jziA',1249407461,'3','pbversion0000000000001','approved','Contributions Layout','Contributions Layout','root/import/account/contributions/contributions-layout','3','7','12',NULL,0,1,0,0,0,1644,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1255485470,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('_9_eiaPgxzF_x_upt6-PNQ',1250022514,'3','pbversion0000000000001','approved','gallery.css','gallery.css','root/import/gallery-templates/gallery.css','3','7','3',NULL,0,1,0,0,0,19058,NULL,0,1,0,1250190876,NULL,0),('PBtmpl0000000000000056',1248729559,'3','pbversion0000000000001','approved','Default Product','Default Product','default_product','3','7','12',NULL,0,1,0,0,0,13170,'<style type=\"text/css\">\n	.wgProduct {\n\n	}\n	.wgProduct h3.title {\n		margin-bottom:2px;\n		padding-bottom:0px;\n	}\n	.wgProduct .images {\n		float:left;\n		min-width:1%;\n		margin:10px;\n	}\n	.wgProduct .images ul, \n	.wgProduct .images li {\n		padding:0px;\n		margin:0px;\n		margin-left:15px;\n		color:#787878;\n	}	\n	.wgProduct .images .controls .title {\n		background-color:#E0E0E0;\n		padding:2px;\n		font-weight:bold;\n		margin-bottom:5px;\n	}	\n	.wgProduct .images .controls {\n		margin-top:10px;\n		display:block;\n		background-color:#F1F1F1;\n		padding-bottom:5px;\n		border:1px ridge #E0E0E0;		\n	}\n	.wgProduct .images .controls a {\n		font-size:10px;\n		letter-spacing:0px;\n		display:block;\n		padding:0px 3px;\n		color:#787878;\n	}	\n	.wgProduct .images .buttons {\n		margin:10px 0px;\n	}\n	.wgProduct .images .buttons a {\n		background-color:#F1F1F1;\n		padding:2px 5px;\n		color:#787878;\n		text-decoration:none;\n		border:1px ridge #E0E0E0;\n		font-size:10px;\n		display:block;\n		margin:1px 0px;\n	}\n	\n	\n	\n	\n	.wgProduct .product {\n		float:left;\n		margin-left:40px;\n		padding:0px 10px 10px 0px;\n	}\n	.wgProduct .product .description {\n		margin-left:-20px;\n	}\n	.wgProduct .product form {\n		margin:20px 0px;\n	}	\n	.wgProduct .product ul,\n	.wgProduct .product li {\n		margin:0px;\n		padding:0px;\n	}\n	.wgProduct .product ul {\n		margin-bottom:15px;\n	}\n	.wgProduct .product li {\n		margin-left:15px;\n	}\n\n.hoverbox {\n	cursor: default;\n	list-style: none;\n}\n\n.hoverbox a {\n	cursor: default;\n}\n\n.hoverbox a .bigImage {\n	display: none;\n}\n\n.hoverbox a:hover .bigImage {\n	display: block;\n	position: absolute;\n	top: -33px;\n	left: -45px;\n	z-index: 1;\n}\n\n.hoverbox img {\n	background: #fff;\n	border: 1px solid #000000;\n	color: inherit;\n	padding: 2px;\n	vertical-align: top;\n}\n\n.hoverbox li\n{\n	background: #eee;\n	border: 1px solid #000000;\n	color: inherit;\n	display: inline;\n	float: left;\n	margin: 3px;\n	padding: 5px;\n	position: relative;\n}\n\n\n\n.hoverbox .bigImage {\n	border-color: #000;\n	max-width: 600px;\n	max-height: 480px;\n}		\n</style>\n\n',0,1,0,1255485470,'<style type=\"text/css\">.wgProduct{}.wgProduct h3.title{margin-bottom:2px;padding-bottom:0px;}.wgProduct .images{float:left;min-width:1%;margin:10px;}.wgProduct .images ul,.wgProduct .images li{padding:0px;margin:0px;margin-left:15px;color:#787878;}.wgProduct .images .controls .title{background-color:#E0E0E0;padding:2px;font-weight:bold;margin-bottom:5px;}.wgProduct .images .controls{margin-top:10px;display:block;background-color:#F1F1F1;padding-bottom:5px;border:1px ridge #E0E0E0;}.wgProduct .images .controls a{font-size:10px;letter-spacing:0px;display:block;padding:0px 3px;color:#787878;}.wgProduct .images .buttons{margin:10px 0px;}.wgProduct .images .buttons a{background-color:#F1F1F1;padding:2px 5px;color:#787878;text-decoration:none;border:1px ridge #E0E0E0;font-size:10px;display:block;margin:1px 0px;}.wgProduct .product{float:left;margin-left:40px;padding:0px 10px 10px 0px;}.wgProduct .product .description{margin-left:-20px;}.wgProduct .product form{margin:20px 0px;}.wgProduct .product ul,.wgProduct .product li{margin:0px;padding:0px;}.wgProduct .product ul{margin-bottom:15px;}.wgProduct .product li{margin-left:15px;}.hoverbox{cursor:default;list-style:none;}.hoverbox a{cursor:default;}.hoverbox a .bigImage{display:none;}.hoverbox a:hover .bigImage{display:block;position:absolute;top:-33px;left:-45px;z-index:1;}.hoverbox img{background:#fff;border:1px solid #000000;color:inherit;padding:2px;vertical-align:top;}.hoverbox li{background:#eee;border:1px solid #000000;color:inherit;display:inline;float:left;margin:3px;padding:5px;position:relative;}.hoverbox .bigImage{border-color:#000;max-width:600px;max-height:480px;}</style>',0),('alraubvBu-YJJ614jAHD5w',1250147475,'3','pbversion0000000000001','approved','matrix-nav-tmpl','matrix-nav-tmpl','new-matrix/matrix-nav-tmpl','3','7','12',NULL,0,1,0,0,0,676,NULL,0,1,0,1255485469,NULL,0),('q5O62aH4pjUXsrQR3Pq4lw',1248833148,'3','pbversion0000000000001','approved','Default Gallery View Album Thumbnails','Default Gallery View Album Thumbnails','root/import/gallery-templates/default-gallery-view-album-thumbnails','3','7','3',NULL,0,1,0,0,0,7494,'<style type=\"text/css\">\r\n	@import url(^/(root/import/gallery-templates/gallery.css););\r\n</style>\r\n\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n	</style>\r\n<![endif]-->\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/dom/dom-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/event/event-min.js);\"></script>',0,1,0,1255485471,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/dom/dom-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/event/event-min.js);\"></script>',0),('CarouselTmpl0000000001',1250809023,'3','pbversion0000000000001','approved','Default Carousel','Default Carousel','root/import/carousel/carousel-default','3','7','12',NULL,0,0,0,0,0,3129,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts.css);\">\n<link type=\"text/css\" rel=\"stylesheet\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\">\n<script src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script src=\"^Extras(yui/build/element/element-beta-min.js);\"></script>\n<script src=\"^Extras(yui/build/utilities/utilities.js);\"></script>\n<script src=\"^Extras(yui/build/carousel/carousel-beta-min.js);\"></script>',0,1,0,1255485470,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts.css);\"><link type=\"text/css\" rel=\"stylesheet\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\"><script src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script src=\"^Extras(yui/build/element/element-beta-min.js);\"></script><script src=\"^Extras(yui/build/utilities/utilities.js);\"></script><script src=\"^Extras(yui/build/carousel/carousel-beta-min.js);\"></script>',0),('oHh0UqAJeY7u2n--WD-BAA',1250724545,'3','pbversion0000000000001','approved','Default Edit Map Point','Default Edit Map Point','home/map/map-templates/default-edit-map-point','3','7','3',NULL,0,1,0,0,0,1720,NULL,0,1,0,1255485470,NULL,0),('u9vfx33XDk5la1-QC5FK7g',1250723423,'3','pbversion0000000000001','approved','Default Map Point View','Default Map Point View','home/map/map-templates/default-map-point-view','3','7','3',NULL,0,1,0,0,0,1608,NULL,0,1,0,1255485470,NULL,0),('i9-G00ALhJOr0gMh-vHbKA',1250408924,'3','pbversion0000000000001','approved','Inbox SMS Notification','Inbox SMS Notification','root/import/inbox-sms-notification','3','7','4',NULL,0,0,0,0,0,446,NULL,0,1,0,1255485469,NULL,0),('matrixtmpl000000000002',1251054814,'3','pbversion0000000000001','approved','Matrix Default Compare','Matrix Default Compare','matrix-default-compare-template','3','7','12',NULL,0,0,0,0,0,21189,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->\n\n',0,1,0,1255485469,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script><script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script><script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script><style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style>',0),('ohjyzab5i-yW6GOWTeDUHg',1251425384,'3','pbversion0000000000001','approved','Default Manage Ad Sku Template','Default Manage Ad Sku Template','root/import/ad-sku/default-manage-ad-sku-template','3','7','12',NULL,0,0,0,0,0,2618,NULL,0,1,0,1255485469,NULL,0),('AldPGu0u-jm_5xK13atCSQ',1251419124,'3','pbversion0000000000001','approved','Default Purchase Ad Sku Template','Default Purchase Ad Sku Template','root/import/ad-sku/default-purchase-ad-sku-template','3','7','12',NULL,0,0,0,0,0,3882,NULL,0,1,0,1255485469,NULL,0),('5bnNzteN7w3NnK9mF4XiCg',1250243000,'3','pbversion0000000000001','approved','Survey','Survey','root/import/survey','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1253052788,NULL,0),('PBtmpl0000000000000063',1250243000,'3','pbversion0000000000001','approved','Default Overview Report','Default Overview Report','root/import/survey/default-overview-report','3','7','12',NULL,0,1,0,0,0,5596,NULL,0,1,0,1255485470,NULL,0),('PBtmpl0000000000000062',1250243000,'3','pbversion0000000000001','approved','Default Gradebook Report','Default Gradebook Report','root/import/survey/default-gradebook-report','3','7','12',NULL,0,1,0,0,0,4820,NULL,0,1,0,1255485470,NULL,0),('PBtmpl0000000000000061',1250243000,'3','pbversion0000000000001','approved','Default Survey','Default Survey','root/import/survey/default-survey','3','7','12',NULL,0,1,0,0,0,2867,NULL,0,1,0,1255485470,NULL,0),('d8jMMMRddSQ7twP4l1ZSIw',1250243000,'3','pbversion0000000000001','approved','Default Survey Take','Default Survey Take','root/import/survey/default-survey-take','3','7','12',NULL,0,1,0,0,0,4001,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts-min.css);\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/assets/skins/sam/skin.css);\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^/(survey.css);\" />\n\n',0,1,0,1255485470,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts-min.css);\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/assets/skins/sam/skin.css);\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"^/(survey.css);\" />',0),('CxMpE_UPauZA3p8jdrOABw',1250243000,'3','pbversion0000000000001','approved','Default Questions','Default Questions','root/import/survey/default-questions','3','7','12',NULL,0,1,0,0,0,17294,NULL,0,1,0,1255485470,NULL,0),('1oBRscNIcFOI-pETrCOspA',1250243000,'3','pbversion0000000000001','approved','Default Section Edit','Default Section Edit','root/import/survey/default-section-edit','3','7','12',NULL,0,1,0,0,0,13450,NULL,0,1,0,1255485470,NULL,0),('wAc4azJViVTpo-2NYOXWvg',1250243000,'3','pbversion0000000000001','approved','Default Question Edit','Default Question Edit','root/import/survey/default-question-edit','3','7','12',NULL,0,1,0,0,0,12656,NULL,0,1,0,1255485469,NULL,0),('AjhlNO3wZvN5k4i4qioWcg',1250243000,'3','pbversion0000000000001','approved','Default Answer Edit','Default Answer Edit','root/import/survey/default-answer-edit','3','7','12',NULL,0,1,0,0,0,9539,NULL,0,1,0,1255485469,NULL,0),('qsG6B24a0SC5KrhQjmdZBw',1250243000,'3','pbversion0000000000001','approved','survey.css','survey.css','survey.css','3','7','12',NULL,0,1,0,0,0,5192,NULL,0,1,0,1253052788,NULL,0),('RSAMkc6WQmfRE3TOr1_3Mw',1250243000,'3','pbversion0000000000001','approved','ExpireIncompleteSurveyResponses','ExpireIncompleteSurveyResponses','root/import/expireincompletesurveyresponses','3','7','12',NULL,0,1,0,0,0,399,NULL,0,1,0,1253052788,NULL,0),('ExpireIncResptmpl00001',1250243000,'3','pbversion0000000000001','approved','ExpireIncompleteSurveyResponses','ExpireIncompleteSurveyResponses','root/import/expireincompletesurveyresponses/expireincompletesurveyresponses','3','7','12',NULL,0,1,0,0,0,809,NULL,0,1,0,1255485470,NULL,0),('7F-BuEHi7t9bPi008H8xZQ',1250243000,'3','pbversion0000000000001','approved','Default Survey Summary','Default Survey Summary','root/import/survey/default-survey-summary','3','7','12',NULL,0,1,0,0,0,2281,NULL,0,1,0,1253052789,NULL,0),('S3zpVitAmhy58CAioH359Q',1250243000,'3','pbversion0000000000001','approved','Default Test Results','Default Test Results','root/import/survey/default-test-results','3','7','12',NULL,0,1,0,0,0,6153,'<style type=\"text/css\">\n.fail {\n  color: red;\n}\n.pass {\n  color: green;\n}\n/* All lines other than tests */\n.plan, .pragma, .comment, .bailout, .version, .unknown {\n  color: blue;\n}\n</style>',0,1,0,1255485469,'<style type=\"text/css\">.fail{color:red;}.pass{color:green;}.plan,.pragma,.comment,.bailout,.version,.unknown{color:blue;}</style>',0),('kwTL1SWCk0GlpiJ5zAAEPQ',1250243000,'3','pbversion0000000000001','approved','surveyedit.css','surveyedit.css','root/import/survey/surveyedit.css','3','7','12',NULL,0,1,0,0,0,5215,NULL,0,1,0,1253052789,NULL,0),('nWNVoMLrMo059mDRmfOp9g',1250243000,'3','pbversion0000000000001','approved','Default Feedback','Default Feedback','root/import/survey/default-feedback','3','7','12',NULL,0,1,0,0,0,1232,NULL,0,1,0,1255485470,NULL,0),('3QpYtHrq_jmAk1FNutQM5A',1252186123,'3','pbversion0000000000001','approved','Story Template','Story Template','root/import/storymanager/storytemplate','3','7','4',NULL,0,0,0,0,0,6530,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\">\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/carousel/carousel-beta.js);\"></script>',0,1,0,1253052788,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\"><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/carousel/carousel-beta.js);\"></script>',0),('matrixtmpl000000000003',1252087641,'3','pbversion0000000000001','approved','Matrix Default Detailed Listing','Matrix Default Detailed Listing','matrix-default-detailed-listing','3','7','12',NULL,0,0,0,0,0,15768,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->',0,1,0,1255485469,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script><script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script><style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style>',0),('PBtmpl0000000000000016',1250243000,'3','pbversion0000000000001','approved','Default WebGUI Account Activation Template','Default WebGUI Account Activation Template','root/import/auth/webgui/create/default-webgui-account-activation-template','3','7','3',NULL,0,1,0,0,0,601,NULL,0,1,0,1255485471,NULL,0),('OOyMH33plAy6oCj_QWrxtg',1252004440,'3','pbversion0000000000001','approved','Lookup Registrant (Default)','Lookup Registrant (Default)','root/import/ems/lookup-registrant-default','3','7','12',NULL,0,1,0,0,0,7091,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\ndiv.search, p {\n	text-align: left;\n}\n\n</style>\n',0,1,0,1253052788,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">div.search,p{text-align:left;}</style>',0),('TbDcVLbbznPi0I0rxQf2CQ',1252187598,'3','pbversion0000000000001','approved','Story Template Topic','Story Template Topic','root/import/storymanager/storytemplatetopic','3','7','4',NULL,0,0,0,0,0,4311,NULL,0,1,0,1255485470,NULL,0),('newslettercs0000000001',1252682678,'3','pbversion0000000000001','approved','Newsletter Manager (default)',' Newsletter Manager','newslettercstemplate','3','7','3',NULL,0,0,0,0,0,2763,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n</style>\n',0,1,0,1253052788,'<style type=\"text/css\">.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}</style>',0),('1IzRpX0tgW7iuCfaU2Kk0A',1250243000,'3','pbversion0000000000001','approved','Default Contributions View','Default Contributions View','root/import/account/contributions/default-contributions-view','3','7','12',NULL,0,1,0,0,0,7747,'<link rel=\"stylesheet\" href=\"^/(root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1255485470,'<link rel=\"stylesheet\" href=\"^/(root/import/account/account.css);\" type=\"text/css\">',0),('aUDsJ-vB9RgP-AYvPOy8FQ',1250243000,'3','pbversion0000000000001','approved','Shop Account Layout','Shop Account Layout','root/import/account/shop/shop-account-layout','3','7','12',NULL,0,1,0,0,0,3142,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1255485470,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('fowHfgOkJtAxdst7rugTog',1250243000,'3','pbversion0000000000001','approved','Story Manager','Story Manager','root/import/storymanager','3','7','12',NULL,0,1,0,0,0,337,NULL,0,1,0,1253052788,NULL,0),('yxD5ka7XHebPLD-LXBwJqw',1250243000,'3','pbversion0000000000001','approved','StoryArchive','StoryArchive','root/import/storymanager/storyarchive','3','7','4',NULL,0,0,0,0,0,2047,NULL,0,1,0,1255485470,NULL,0),('E3tzZjzhmYoNlAyP2VW33Q',1250243000,'3','pbversion0000000000001','approved','Edit Story','Edit Story','root/import/storymanager/editstory','3','7','4',NULL,0,0,0,0,0,5762,NULL,0,1,0,1255485470,NULL,0),('0EAJ9EYb9ap2XwfrcXfdLQ',1250243000,'3','pbversion0000000000001','approved','Story Archive Asset List','Story Archive Asset List','root/import/storymanager/keywordlist','3','7','4',NULL,0,0,0,0,0,576,NULL,0,1,0,1255485470,NULL,0),('hkj6WeChxFyqfP85UlRP8w',1250243000,'3','pbversion0000000000001','approved','matrix.css','matrix.css','new-matrix/matrix.css','3','7','12',NULL,0,1,0,0,0,16408,NULL,0,1,0,1253052788,NULL,0),('TKmhv8boP3TD2xwSwUBq0g',1250243000,'3','pbversion0000000000001','approved','Default ThingyRecord View','Default ThingyRecord View','home/thinyrecord-templates/default-thingyrecord-view','3','7','3',NULL,0,1,0,0,0,1762,NULL,0,1,0,1255485470,NULL,0),('PBtmpl0000000000000011',1250243000,'3','pbversion0000000000001','approved','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template','default_webgui_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,6734,'<style type=\"text/css\">\r\n    .submitData {\r\n        text-align:right;\r\n        border-top:solid gray 1px;\r\n    }\r\n    .authfield_required_off {\r\n        background-color: #FFFFFF;\r\n    }\r\n    .authfield_required {\r\n        background-color: #FFFFBB;\r\n    }\r\n    .authfield_error {\r\n        background-color: #FF9494;\r\n    }\r\n</style>\r\n<script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\r\n<script type=\"text/javascript\">\r\n   YAHOO.util.Event.onDOMReady(function () {\r\n        var setFieldColor = function ( evt, obj ) {\r\n            var field     = obj.field;\r\n            var hasError  = obj.hasError;\r\n            var origClass = field.className;\r\n            YAHOO.util.Dom.removeClass(field,origClass);\r\n            if(field.value == \"\") {\r\n                var newClass  = hasError?\"authfield_error\":\"authfield_required\";\r\n                YAHOO.util.Dom.replaceClass(field,origClass,newClass);\r\n            }\r\n            else {\r\n                YAHOO.util.Dom.replaceClass(field,origClass,\"authfield_required_off\");\r\n            }\r\n        }\r\n\r\n        var rFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");\r\n        var eFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");\r\n        var oFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");\r\n\r\n        for (var i = 0; i < rFields.length; i++) {\r\n            YAHOO.util.Event.addListener(rFields[i],\"change\",setFieldColor, {\r\n                field   : rFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < eFields.length; i++) {\r\n            YAHOO.util.Event.addListener(eFields[i],\"change\",setFieldColor, {\r\n                field   : eFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < oFields.length; i++) {\r\n            YAHOO.util.Event.addListener(oFields[i],\"change\",setFieldColor, {\r\n                field   : oFields[i],\r\n                hasError: (oFields.length > 0)\r\n            });\r\n        }\r\n       \r\n   });\r\n</script>',0,1,0,1255485471,'<style type=\"text/css\">.submitData{text-align:right;border-top:solid gray 1px;}.authfield_required_off{background-color:#FFFFFF;}.authfield_required{background-color:#FFFFBB;}.authfield_error{background-color:#FF9494;}</style><script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){var h=function(c,a){var f=a.field;var e=a.hasError;var d=f.className;YAHOO.util.Dom.removeClass(f,d);if(f.value==\"\"){var b=e?\"authfield_error\":\"authfield_required\";YAHOO.util.Dom.replaceClass(f,d,b)}else{YAHOO.util.Dom.replaceClass(f,d,\"authfield_required_off\")}}var g=YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");var k=YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");var j=YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");for(var i=0;i<g.length;i++){YAHOO.util.Event.addListener(g[i],\"change\",h,{field:g[i],hasError:(k.length>0)})}for(var i=0;i<k.length;i++){YAHOO.util.Event.addListener(k[i],\"change\",h,{field:k[i],hasError:(k.length>0)})}for(var i=0;i<j.length;i++){YAHOO.util.Event.addListener(j[i],\"change\",h,{field:j[i],hasError:(j.length>0)})}});/*]]>*/</script>',0),('c8xrwVuu5QE0XtF9DiVzLw',1250243000,'3','pbversion0000000000001','approved','Default Inbox View Template','Default Inbox View Template','root/import/account/inbox/default-inbox-view-template','3','7','12',NULL,0,1,0,0,0,10792,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function(){\n   function isMessageCheckBox( element ) {\n      if(element.name == \"message\") return true;\n      return false;\n   }\n   \n   function toggleAllChecked(evt) {\n      var allBox     = YAHOO.util.Dom.get(\"check_all\");\n      var checkBoxes = YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"WGinboxTbl\");\n      for (var i = 0; i < checkBoxes.length; i++) {\n         checkBoxes[i].checked = allBox.checked;\n      }\n   }\n   \n   YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked);\n});\n</script>',0,1,0,1255485469,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){function isMessageCheckBox(a){if(a.name==\"message\")return true;return false}function toggleAllChecked(b){var a=YAHOO.util.Dom.get(\"check_all\");var c=YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"WGinboxTbl\");for(var i=0;i<c.length;i++){c[i].checked=a.checked}}YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked)});/*]]>*/</script>',0),('WikiKeyword00000000001',1254284569,'3','pbversion0000000000001','approved',' Wiki Pages By Keyword (default)',' Wiki Pages By Keyword','wiki-master-by-keyword-template.tmpl','3','7','3',NULL,0,0,0,0,0,820,NULL,0,1,0,1254284571,NULL,0),('A16v-YjWAShXWvSACsraeg',1254284570,'3','pbversion0000000000001','approved','StoryTopic','StoryTopic','root/import/storymanager/storytopic','3','7','4',NULL,0,0,0,0,0,1650,NULL,0,1,0,1255485470,NULL,0),('CalendarMonth000000001',1254284570,'3','pbversion0000000000001','approved','Default Calendar Month','Default Calendar Month','root/import/calendar-templates/default-calendar-month','3','7','12',NULL,0,0,0,0,0,15945,'<style type=\"text/css\">\n		#mCAL * {\n			margin:0px;			\n		}\n		#mCAL td {\n			font-size:10px;\n			font-family:arial;\n		}\n		#mCAL .tab {\n\n			border-bottom-style: none;\n			font-weight: bold;\n			padding: 2px 15px 0px 15px;\n			text-align: center;\n			background-color: #E9ECF3;\n			-moz-border-radius-topLeft: 10px;\n			-moz-border-radius-topRight: 10px;\n			color: #7588B5;\n			text-decoration: none;\n			font-size: 10pt;\n			display: block;\n			float: left;\n			margin-right: 5px;\n		}\n		#mCAL .tab:hover {\n			color:black;\n		}	\n		#mCAL .active {\n			background-color:#DFE3EE;\n			color:#404F77;\n			border-bottom:solid #DFE3EE 1px;\n		}	\n		#mCAL .controls {\n			float:right;\n			vertical-align:bottom;\n		}\n		#mCAL a {\n			font-size:11px;\n			color:#517AC8;\n		}	\n		#mCAL .months {\n			text-align:center;\n			background-color:#DFE3EE;			\n		}\n		#mCAL .months a {\n			color:#517AC8;\n			text-decoration:none;\n		}\n		#mCAL .months .monthLink {\n			text-decoration:none;			\n			padding-left:5px;\n			padding-right:5px;\n			color:#AAB8D5;\n			font-size:12px;\n			font-weight:bold;\n		}	\n\n		#mCAL .months .current, #mCAL .months .monthLink:hover {\n			font-weight:bold;\n			color:#517AC8;\n			background-color:#fff;			\n			-moz-border-radius:5px;\n		}\n		#mCAL .curMonth {\n			text-align:center;\n			margin: 2px 0px;\n			background-color:#517AC8;\n			color:white;\n			font-size:14px;\n			font-weight:bold;\n		}\n\n\n\n/**** Month view ****/\n/* Table */\n#mCAL table#month\n{\n\n}\n\n#mCAL table#month *\n{\n	padding:		0px;\n	margin:			0px;\n}\n\n#mCAL table#month a\n{\n	text-decoration:	none;\n}\n\n#mCAL table#month th\n{\n	-moz-box-sizing:border-box;\n	width:			85px;\n	background-color:	#517AC8;\n	text-align:		center;\n	font-weight:		bold;\n	color:			white;	\n}\n\n#mCAL table#month div\n{\n	position:		relative;\n	width:			85px;\n	height:			85px;\n	margin:			0px;\n	background-color:	#E9ECF3;\n}\n\n#mCAL table#month ul \n{	\n	overflow:		hidden;\n}\n\n#mCAL table#month .active \n{\n	-moz-border-radius-topLeft:	8px;\n	-moz-border-radius-bottomLeft:	8px;\n	-moz-border-radius-bottomRight:	8px;\n	vertical-align:		top;		\n	background-color:	#CCD2E3;\n	border:			solid #CCD2E3 1px;\n}\n\n#mCAL table#month .current \n{\n	background-color:	#FFE4B3;\n	border-color:		orange;\n}\n\n#mCAL table#month .number \n{\n	-moz-border-radius-bottomLeft:5px;\n	display:		block;\n	position:		absolute;\n	top:			0px;\n	right:			0px;\n	height:			10px;\n	width:			13px;\n	background-color:	#516BA4;\n	color:			white;\n	text-align:		center;\n	vertical-align:		middle;\n	padding:		0px 3px 2px 2px;\n	font-weight:		bold;\n}\n\n#mCAL table#month .current .number\n{\n	background-color:	orange;\n	color:			black;\n}\n\n#mCAL table#month .events \n{\n	padding:		3px;\n	padding-top:		8px;\n	font-weight:		bold;			\n}\n\n#mCAL table#month .events a \n{\n	color:			#4F4F4F;\n	text-decoration:	none;\n	font-size:		9px;\n}\n\n#mCAL table#month .moreButton \n{\n	border-style:		none;\n	position:		absolute;\n	bottom:			0px;\n	width:			100%;\n	height:			9px;\n	background-color:	#517AC8;	\n	font-size:		5px;\n	text-align:		center;\n	-moz-border-radius-bottomLeft:	8px;\n	-moz-border-radius-bottomRight:	8px;\n}\n\n#mCAL table#month .moreButton img\n{\n	border:			none;\n}\n\n\n/* MORE STYLES */\n\n.moreDisplay \n{\n	position: 		absolute;\n	border:			solid orange 1px;\n	border-top:		solid orange 2px;\n	font-family:		arial;\n	font-size:		10px;\n	width:			300px;\n	height: 		auto;\n	padding:		2px;\n	background-color:	#FFD3A8;\n	color:			black;\n	display:        none;\n	z-index: 		100;\n}\n\n.moreDisplay a {\n   color: black;\n}\n\n* html body table#month td { position: relative; z-index: 1; }\n</style>\n\n<script type=\"text/javascript\" src=\'^Extras;yui/build/yahoo/yahoo.js\'></script>\n<script type=\"text/javascript\" src=\'^Extras;yui/build/event/event.js\' ></script>\n\n<script>\n<!--\n//<![CDATA[\n	\n   //-----------------------------------------------------------------------------------   	\n   function isSelfOrChildOf(parent,node) {\n      if(parent == node) return true;\n	  if(parent == null || node == null) return false;\n	  var childLen = parent.childNodes.length;\n      for (var i = 0; i < childLen; i++) {\n         var child = parent.childNodes[i];\n	     if(child.nodeType != 1) continue; //Skip text and attribute nodes\n	     if(isSelfOrChildOf (child,node)) {\n	        return true;\n	     }\n      }\n      return false;\n   }	\n   \n   //-----------------------------------------------------------------------------------   \n   function findParentNodeFromChild (node,tagName) {\n      if(node == null) return node;\n	  var parent = node.parentNode;\n	  if(parent == null) return node;\n	  if(parent.tagName == tagName) {\n	     return parent;\n	  }\n	  return findParentNodeFromChild (parent,tagName);\n   }\n   \n   \n   //-----------------------------------------------------------------------------------   \n   function showEvents(eventId) {\n	  var evt = YAHOO.util.Event.getEvent();\n      var targ = YAHOO.util.Event.getTarget(evt);\n	  \n	  var elem = document.getElementById(eventId);\n	  var td;\n      var pPagex;\n      var pPagey;\n          \n      //IE is stupid\n      var isIE = navigator.userAgent.indexOf(\"MSIE\") > -1;\n      var isIE7 = navigator.userAgent.indexOf(\"MSIE 7\") > -1;\n      var isIE8 = navigator.userAgent.indexOf(\"MSIE 8.0\") > -1;\n      if(isIE && !(isIE7 || isIE8)) {\n         //IE 6 and below don\'t register offsetTop or offsetLeft for the div\n         td = findParentNodeFromChild(targ,\"TD\");\n         pPagex = td.offsetTop;\n         pPagey = td.offsetLeft;\n      } else {\n         var cDiv = findParentNodeFromChild(targ,\"DIV\");\n	     pPagex = cDiv.offsetTop;\n	     pPagey = cDiv.offsetLeft;\n         td = findParentNodeFromChild(cDiv,\"TD\");\n      }\n      \n      var tdHeight = td.offsetHeight;\n\n	  var eventX = tdHeight + pPagex;\n	  var eventY = pPagey;\n		  \n	  elem.style.top = eventX + \'px\';\n	  elem.style.left = eventY + \'px\';\n	  elem.style.display = \"block\";\n      \n	  //Register listener\n	  YAHOO.util.Event.addListener(document.body,\"mousemove\",hideEvents,{ \"targ\":targ, \"elem\": elem, \"td\": td })\n	  return false;\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function hideEvents(e, el) {\n	  if(!e || !el) return;\n	  \n	  var elem = el.elem;\n	  var td = el.td;\n	  var targ = el.targ;\n	  \n	  var evtTarg = YAHOO.util.Event.getTarget(e);\n	  \n	  var inDiv = isSelfOrChildOf(elem,evtTarg);\n      var inTd = isSelfOrChildOf(td,evtTarg);\n	  var inTarget = isSelfOrChildOf(targ,evtTarg);\n	  \n	  if(inDiv || inTd || inTarget) {\n	     //do nothing\n	  } else {\n	     elem.style.display = \"none\";\n		 YAHOO.util.Event.removeListener (document.body,\"mousemove\",hideEvents);    \n	  }\n	  return false;\n   }\n   \n//]]>\n-->      \n</script>',0,1,0,1255485471,'<style type=\"text/css\">#mCAL *{margin:0px;}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;text-align:center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current,#mCAL .months .monthLink:hover{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#mCAL table#month{}#mCAL table#month *{padding:0px;margin:0px;}#mCAL table#month a{text-decoration:none;}#mCAL table#month th{-moz-box-sizing:border-box;width:85px;background-color:#517AC8;text-align:center;font-weight:bold;color:white;}#mCAL table#month div{position:relative;width:85px;height:85px;margin:0px;background-color:#E9ECF3;}#mCAL table#month ul{overflow:hidden;}#mCAL table#month .active{-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;-moz-border-radius-bottomRight:8px;vertical-align:top;background-color:#CCD2E3;border:solid #CCD2E3 1px;}#mCAL table#month .current{background-color:#FFE4B3;border-color:orange;}#mCAL table#month .number{-moz-border-radius-bottomLeft:5px;display:block;position:absolute;top:0px;right:0px;height:10px;width:13px;background-color:#516BA4;color:white;text-align:center;vertical-align:middle;padding:0px 3px 2px 2px;font-weight:bold;}#mCAL table#month .current .number{background-color:orange;color:black;}#mCAL table#month .events{padding:3px;padding-top:8px;font-weight:bold;}#mCAL table#month .events a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL table#month .moreButton{border-style:none;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;-moz-border-radius-bottomLeft:8px;-moz-border-radius-bottomRight:8px;}#mCAL table#month .moreButton img{border:none;}.moreDisplay{position:absolute;border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;height:auto;padding:2px;background-color:#FFD3A8;color:black;display:none;z-index:100;}.moreDisplay a{color:black;}* html body table#month td{position:relative;z-index:1;}</style><script type=\"text/javascript\" src=\'^Extras;yui/build/yahoo/yahoo.js\'></script><script type=\"text/javascript\" src=\'^Extras;yui/build/event/event.js\'></script><script>\n      \n</script>',0),('N716tpSna0iIQTKxS4gTWA',1254284570,'3','pbversion0000000000001','approved','Default Account Layout','Default Account Layout','root/import/account/default-account-layout2','3','7','12',NULL,0,1,0,0,0,1381,'<link rel=\"stylesheet\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" type=\"text/css\">\n<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0,1,0,1255485470,'<link rel=\"stylesheet\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" type=\"text/css\"><link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('S2_LsvVa95OSqc66ITAoig',1254284570,'3','pbversion0000000000001','approved','EMS Schedule Listing (default)','EMS Schedule Listing (default)','root/import/ems/ems-schedule-listing-default2','3','7','12',NULL,0,1,0,0,0,14244,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n	<style type=\"text/css\">\n        #emsDatePaginator {\n                       display: inline; \n                       float : left;\n                       width:  100px;\n        }\n	 #emsDatePaginator .yui-pg-pages { \n	     display: block; \n	} \n	#emsDatePaginator .yui-pg-page { \n	    display: block; \n	    background-color: blue; \n	    background: transparent; \n	    border: none; \n	    white-space: normal; \n	} \n	#emsDatePaginator .yui-pg-current-page { \n	    background-color: white; \n        }\n                .locationHeader {\n                       font-weight: bold;\n                       color: blue;\n                 }\n                .dateHeader {\n                       font-weight: bold;\n                       color: green;\n                 }\n                .datePaginatorLink {\n		     background-color: blue;\n                 }\n                .emptyCell {\n		     background-color: light-grey;\n                 }\n		.eventDescription {\n		     background-color: white;\n		    max-width: 400px;\n		    border:1px solid #000;\n		    padding:10px;\n		}\n		.forwardButton {\n			background-color: green;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n		.backwardButton {\n			background-color: red;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n                .yui-dt thead {display:none;} \n	</style>\n',0,1,0,1254284571,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">#emsDatePaginator{display:inline;float:left;width:100px;}#emsDatePaginator .yui-pg-pages{display:block;}#emsDatePaginator .yui-pg-page{display:block;background-color:blue;background:transparent;border:none;white-space:normal;}#emsDatePaginator .yui-pg-current-page{background-color:white;}.locationHeader{font-weight:bold;color:blue;}.dateHeader{font-weight:bold;color:green;}.datePaginatorLink{background-color:blue;}.emptyCell{background-color:light-grey;}.eventDescription{background-color:white;max-width:400px;border:1px solid #000;padding:10px;}.forwardButton{background-color:green;color:white;font-weight:bold;padding:3px;}.backwardButton{background-color:red;color:white;font-weight:bold;padding:3px;}.yui-dt thead{display:none;}</style>',0),('WikiPageTmpl0000000001',1254284570,'3','pbversion0000000000001','approved','Default Wiki Page','Default Wiki Page','default-wiki-page','3','7','12',NULL,0,0,0,0,0,6135,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview.css);\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview-core.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/connection/connection-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\n\n<style type=\"text/css\">\n#wikipage.yui-navset .yui-nav li a {\n    border:1px solid #000;  /* label and content borders */\n}\n\n#wikipage.yui-navset .yui-content {\n        border-top: 1px solid #000;\n        border-bottom: 1px solid #000;\n}\n\n\n#wikipage.yui-navset .yui-nav .selected a {\n    background-color:black; /* active tab, tab hover, and content bgcolor */\n        color: white;\n    border-bottom-width:0; /* no bottom border for active tab */\n    padding-bottom:1px; /* to match height of other tabs */\n}\n\n#wikipage.yui-navset-top .yui-nav .selected a {\n    border-bottom:0; /* no bottom border for active tab */\n    padding-bottom:1px; /* to match height of other tabs */\n}\n\n#wikipage.yui-navset-top .yui-content {\n    margin-top:-1px; /* for active tab overlap */\n}\n\n#wikipage .yui-content {\n    padding-top:1em; \n    padding-bottom:1em; \n}\n#wikipage .loading {\n    background-image:url(^Extras(yui/examples/tabview/img/loading.gif););\n    background-position:center center;\n    background-repeat:no-repeat;\n}\n\n#wikipage .loading * {\n    display:none;\n}\n\n</style>\n',0,1,0,1254284571,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview.css);\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview-core.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/connection/connection-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script><style type=\"text/css\">#wikipage.yui-navset .yui-nav li a{border:1px solid #000;}#wikipage.yui-navset .yui-content{border-top:1px solid #000;border-bottom:1px solid #000;}#wikipage.yui-navset .yui-nav .selected a{background-color:black;color:white;border-bottom-width:0;padding-bottom:1px;}#wikipage.yui-navset-top .yui-nav .selected a{border-bottom:0;padding-bottom:1px;}#wikipage.yui-navset-top .yui-content{margin-top:-1px;}#wikipage .yui-content{padding-top:1em;padding-bottom:1em;}#wikipage .loading{background-image:url(^Extras(yui/examples/tabview/img/loading.gif););background-position:center center;background-repeat:no-repeat;}#wikipage .loading *{display:none;}</style>',0),('PBtmpl0000000000000112',1255485473,'3','pbversion0000000000001','approved','Weblog','Weblog','weblog','3','7','12',NULL,0,1,0,0,0,5088,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n.weblogTitleBar {\n	font-weight: bold;\n	font-size: 14px;\n	font-family:arial;\n}\n\n.weblogLegend {\n	font-size: 9px;\n	color: #999999;\n	font-family:arial;\n}\n\n.weblogLegend a\n{\n	color:#29587E;\n}\n\n.weblogReadMore {\n	text-align: right;\n	font-size: 9px;\n	width: 100%;\n	font-family:arial;\n}\n\n.weblogSynopsis {\n	border: 1px solid #bbbbbb;\n	font-size: 13px;\n	padding: 5px;\n	-moz-border-radius: 6px;\n	font-family:arial;\n}\n</style>',0,1,0,1255485475,'<style type=\"text/css\">.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}.weblogTitleBar{font-weight:bold;font-size:14px;font-family:arial;}.weblogLegend{font-size:9px;color:#999999;font-family:arial;}.weblogLegend a{color:#29587E;}.weblogReadMore{text-align:right;font-size:9px;width:100%;font-family:arial;}.weblogSynopsis{border:1px solid #bbbbbb;font-size:13px;padding:5px;-moz-border-radius:6px;font-family:arial;}</style>',0),('PBtmpl0000000000000121',1255485473,'3','pbversion0000000000001','approved','Photo Gallery','Photo Gallery','photo_gallery','3','7','12',NULL,0,1,0,0,0,3154,'<style type=\"text/css\">\n.picture {\n	padding: 0px;\n	margin: 10px;\n	float: left;\n	font-size: 12px;\n	width: 150px;\n	height: 100px;\n}\n\nhtml > body .picture {\nheight:auto;\nmin-height:150px;\nwidth:auto;\nmin-width:100px;\n}\n</style>\n\n',0,1,0,1255485475,'<style type=\"text/css\">.picture{padding:0px;margin:10px;float:left;font-size:12px;width:150px;height:100px;}html > body .picture{height:auto;min-height:150px;width:auto;min-width:100px;}</style>',0),('PBtmpl0000000000000067',1255485473,'3','pbversion0000000000001','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,22377,'<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	background-color: #eeeeee;\n	padding: 3px;\n}\n.postData td {\n	font-size: 9pt;\n	color: black;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #676767;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\n	display:block;\n	-moz-box-sizing:border-box;\n	text-align:right;\n	margin-top:1px;\n}\n.postControls a:link, .postControls a:visited\n{\n	text-decoration:underline;\n	color:white;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\n</style>\n',0,1,0,1255485475,'<style type=\"text/css\">.defaultSubmissionDetails{float:right;padding:2px;margin:2px;font-size:9pt;font-family:arial;margin-bottom:20px;}.defaultSubmissionDetails a{color:#29587E;}.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;font-family:arial;}.postData{border-bottom:1px solid #cccccc;background-color:#eeeeee;padding:3px;}.postData td{font-size:9pt;color:black;font-family:arial;}.postControls{border-top:1px solid #cccccc;background-color:#676767;color:black;padding:3px;font-family:arial;clear:both;width:100%;display:block;-moz-box-sizing:border-box;text-align:right;margin-top:1px;}.postControls a:link,.postControls a:visited{text-decoration:underline;color:white;}.postControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;font-family:arial;}.threadData{font-size:11px;padding:3px;font-family:arial;}.collaborationThreadContent{font-family:arial;font-size:9pt;}</style>',0),('PBtmpl0000000000000026',1255485473,'3','pbversion0000000000001','approved','Default Forum','Default Forum','default_forum','3','7','12',NULL,0,1,0,0,0,7866,'<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n',0,1,0,1255485475,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000128',1255485473,'3','pbversion0000000000001','approved','Classifieds','Classifieds','classifieds','3','7','12',NULL,0,1,0,0,0,3239,'<style type=\"text/css\">\n.ad {\n	border: 1px dotted #aaaaaa;\n	padding: 10px;\n	margin: 0px;\n	float: left;\n	width: 140px;\n	font-size: 12px;\n	height: 175px;\n	overflow: hidden;\n}\n</style>\n\n',0,1,0,1255485475,'<style type=\"text/css\">.ad{border:1px dotted #aaaaaa;padding:10px;margin:0px;float:left;width:140px;font-size:12px;height:175px;overflow:hidden;}</style>',0),('PBtmpl0000000000000079',1255485473,'3','pbversion0000000000001','approved','Topics','Topics','topics','3','7','12',NULL,0,1,0,0,0,4906,'<style type=\"text/css\">\n.postControls\n{\n	background:#676767;\n	color:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.postControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a\n{\n	color:white;\n	font-size:8pt;\n}\n.pagination a:hover {\n	text-decoration:none;\n}\n.topicsTitle\n{\n	-moz-box-sizing:border-box;\n	width:95%;\n	border-bottom:solid silver 1px;\n	margin-bottom:3px;\n	font-family:arial;\n}\n\n.topicContent\n{\n	-moz-box-sizing:border-box;\n	font-family:arial;\n	font-size:9pt;\n	width:95%;\n	display:block;\n	border:solid silver 1px;\n	padding:3px;\n}\n\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">.postControls{background:#676767;color:#C0C0C0;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.postControls a{color:white;font-size:8pt;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.pagination{-moz-box-sizing:border-box;background:#676767;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;}.pagination a:hover{text-decoration:none;}.topicsTitle{-moz-box-sizing:border-box;width:95%;border-bottom:solid silver 1px;margin-bottom:3px;font-family:arial;}.topicContent{-moz-box-sizing:border-box;font-family:arial;font-size:9pt;width:95%;display:block;border:solid silver 1px;padding:3px;}</style>',0),('PBtmpl0000000000000083',1255485473,'3','pbversion0000000000001','approved','Link List','Link List','link_list','3','7','12',NULL,0,1,0,0,0,3667,NULL,0,1,0,1255485476,NULL,0),('PBtmpl0000000000000082',1255485473,'3','pbversion0000000000001','approved','Unordered List','Unordered List','unordered_list','3','7','12',NULL,0,1,0,0,0,4582,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n.unorderedList\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}.unorderedList{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000133',1255485474,'3','pbversion0000000000001','approved','Guest Book','Guest Book','guest_book','3','7','12',NULL,0,1,0,0,0,3046,NULL,0,1,0,1255485476,NULL,0),('PBtmpl0000000000000029',1255485474,'3','pbversion0000000000001','approved','Default Post Form','Default Post Form','default_post_form','3','7','12',NULL,0,1,0,0,0,3907,'<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">table.defaultPostForm td{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000032',1255485474,'3','pbversion0000000000001','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,11566,'<style type=\"text/css\">\n	.postBorder {\n		border: 1px solid #cccccc;\n		margin-bottom: 10px;\n	}\n 	.postBorderCurrent {\n		border: 3px dotted black;\n		margin-bottom: 10px;\n	}\n	.postSubject {\n		border-bottom: 1px solid #cccccc;\n		font-weight: bold;\n		padding: 3px;\n	}\n	.postData {\n		border-bottom: 1px solid #cccccc;\n		font-size: 9pt;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.postData a {\n		color:#29587E;\n		text-decoration:underline;\n	}\n	.postData a:hover {\n		text-decoration:none;\n	}\n	.postControls {\n		border-top: 1px solid #cccccc;\n		background-color: #676767;\n		color: black;\n		padding: 3px;\n		text-align:right;\n	}\n	.postControls a:link, .postControls a:visited {\n		color:white;\n		text-decoration:underline;\n	}\n	.postControls a:hover {\n		text-decoration:none;\n	}\n	.bottomControls {\n		background-color:#676767;\n		padding: 3px;\n		text-align:right;\n	}\n	.bottomControls a:link, .bottomControls a:visited {\n		color:white;\n		text-decoration:underline;\n	}	\n	.bottomControls a:hover {\n		text-decoration:none;\n	}\n	.postMessage {\n		padding: 3px;\n	}\n	.currentThread {\n		background-color: #eeeeee;\n	}\n	.threadHead {\n		font-weight: bold;\n		border-bottom: 1px solid #cccccc;\n		font-size: 9pt;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.threadData {\n		font-size: 11px;\n		padding: 3px;\n	}\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;}.postData{border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.postData a{color:#29587E;text-decoration:underline;}.postData a:hover{text-decoration:none;}.postControls{border-top:1px solid #cccccc;background-color:#676767;color:black;padding:3px;text-align:right;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.bottomControls{background-color:#676767;padding:3px;text-align:right;}.bottomControls a:link,.bottomControls a:visited{color:white;text-decoration:underline;}.bottomControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.threadData{font-size:11px;padding:3px;}</style>',0),('PBtmpl0000000000000031',1255485474,'3','pbversion0000000000001','approved','Default Forum Search','Default Forum Search','default_forum_search','3','7','12',NULL,0,1,0,0,0,3818,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n}\n.searchResults{\n	border:solid silver 1px;\n	margin-top:5px;\n}\n.searchResults td{\n	font-family:arial;\n	font-size:9pt;\n}\n.searchResults td a{\n	color:#29587E;\n}\n.searchResults td.odd{\n	background-color:#DADADA;\n}\n.searchResults td.tableHeader{\n	background-color:gray;\n	color:white;\n	border-bottom:double solid silver 3px;\n	font-weight:bold;\n}\n.pagination\n{\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.postControls a\n{\n	color:white;\n}\n\n</style>',0,1,0,1255485476,'<style type=\"text/css\">h2{font-family:arial;}.searchResults{border:solid silver 1px;margin-top:5px;}.searchResults td{font-family:arial;font-size:9pt;}.searchResults td a{color:#29587E;}.searchResults td.odd{background-color:#DADADA;}.searchResults td.tableHeader{background-color:gray;color:white;border-bottom:double solid silver 3px;font-weight:bold;}.pagination{background:#C0C0C0;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.postControls a{color:white;}</style>',0),('PBtmpl0000000000000068',1255485474,'3','pbversion0000000000001','approved','Default Submission Form','Default Submission Form','default_submission_form','3','7','12',NULL,0,1,0,0,0,4829,'<style type=\"text/css\">\ntable.defaultSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">table.defaultSubmissionForm td{font-family:arial;font-size:9pt;}.defaultSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000099',1255485474,'3','pbversion0000000000001','approved','FAQ Submission Form','FAQ Submission Form','faq_submission_form','3','7','12',NULL,0,1,0,0,0,4120,'<style type=\"text/css\">\ntable.faqSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.faqSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">table.faqSubmissionForm td{font-family:arial;font-size:9pt;}.faqSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000114',1255485474,'3','pbversion0000000000001','approved','Link List Submission Form','Link List Submission Form','link_list_submission_form','3','7','12',NULL,0,1,0,0,0,5280,'<style type=\"text/css\">\ntable.linkSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.linkSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">table.linkSubmissionForm td{font-family:arial;font-size:9pt;}.linkSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000077',1255485474,'3','pbversion0000000000001','approved','Job Listing','Job Listing','job_listing','3','7','12',NULL,0,1,0,0,0,4681,'<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n',0,1,0,1255485476,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000098',1255485474,'3','pbversion0000000000001','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,19943,'<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n	font-size:9pt;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#676767;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n\n.tableHeader\n{\n	width:20%;\n	background-color:#DADADA;\n	font-family:arial;\n	font-size:9pt;	\n}\n\n.tableData\n{\n	width:80%;\n	border:solid #DADADA 1px;\n	font-family:arial;\n	font-size:9pt;	\n}\n</style>',0,1,0,1255485476,'<style type=\"text/css\">.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;font-family:arial;font-size:9pt;}.postData{border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.postControls{background:#676767;display:block;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-top:1px;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.threadData{font-family:arial;font-size:9pt;padding:3px;}.tableHeader{width:20%;background-color:#DADADA;font-family:arial;font-size:9pt;}.tableData{width:80%;border:solid #DADADA 1px;font-family:arial;font-size:9pt;}</style>',0),('PBtmpl0000000000000122',1255485474,'3','pbversion0000000000001','approved','Job Submission Form','Job Submission Form','job_submission_form','3','7','12',NULL,0,1,0,0,0,5899,'<style type=\"text/css\">\ntable.jobSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.jobSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">table.jobSubmissionForm td{font-family:arial;font-size:9pt;}.jobSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000081',1255485474,'3','pbversion0000000000001','approved','Q and A','Q and A','q_and_a','3','7','12',NULL,0,1,0,0,0,4416,'<style type=\"text/css\">\n.collab-qa { position: relative; }\n.collab-qa .dropcap { position: absolute; left: -1.5em; top: 0px; width: 1.4em; text-align: center; } \n.collab-qa dt, .collab-qa dd { margin-left: 1.5em; padding-left: 0.5em; position: relative; }\n.collab-qa dt, .collab-qa dt .dropcap { font-weight: bold; background-color: #ccc; line-height: 2em; height: 2em; vertical-align: bottom; }\n.collab-qa dt p { /* stupid controls */ margin: 0; vertical-align: top !important; }\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">.collab-qa{position:relative;}.collab-qa .dropcap{position:absolute;left:-1.5em;top:0px;width:1.4em;text-align:center;}.collab-qa dt,.collab-qa dd{margin-left:1.5em;padding-left:0.5em;position:relative;}.collab-qa dt,.collab-qa dt .dropcap{font-weight:bold;background-color:#ccc;line-height:2em;height:2em;vertical-align:bottom;}.collab-qa dt p{margin:0;vertical-align:top !important;}</style>',0),('PBtmpl0000000000000101',1255485474,'3','pbversion0000000000001','approved','Ordered List','Ordered List','ordered_list','3','7','12',NULL,0,1,0,0,0,3720,NULL,0,1,0,1255485476,NULL,0),('PBtmpl0000000000000113',1255485474,'3','pbversion0000000000001','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,18836,'<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#676767;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n.linkContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.linkContent a\n{\n	color:#29587E;\n}\nh2\n{\n	font-family:arial;\n}\n</style>',0,1,0,1255485476,'<style type=\"text/css\">.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;font-family:arial;font-size:9pt;padding:3px;}.postData{border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.postControls{background:#676767;display:block;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-top:1px;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.threadData{font-family:arial;font-size:9pt;padding:3px;}.linkContent{font-family:arial;font-size:9pt;}.linkContent a{color:#29587E;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000208',1255485474,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-template','3','7','12',NULL,0,0,0,0,0,6743,'\n<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n\n',0,1,0,1255485476,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000209',1255485474,'3','pbversion0000000000001','approved','Request Tracker Thread','Request Tracker Thread','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,22156,'<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	background-color: #eeeeee;\n	padding: 3px;\n}\n.postData td {\n	font-size: 9pt;\n	color: black;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\ndisplay:block;\n	-moz-box-sizing:border-box;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#676767;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n</style>\n',0,1,0,1255485476,'<style type=\"text/css\">.defaultSubmissionDetails{float:right;padding:2px;margin:2px;font-size:9pt;font-family:arial;margin-bottom:20px;}.defaultSubmissionDetails a{color:#29587E;}.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;font-family:arial;}.postData{border-bottom:1px solid #cccccc;background-color:#eeeeee;padding:3px;}.postData td{font-size:9pt;color:black;font-family:arial;}.postControls{border-top:1px solid #cccccc;background-color:#eeeeee;color:black;padding:3px;font-family:arial;clear:both;width:100%;display:block;-moz-box-sizing:border-box;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;font-family:arial;}.threadData{font-size:11px;padding:3px;font-family:arial;}.postControls{background:#676767;display:block;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-top:1px;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.collaborationThreadContent{font-family:arial;font-size:9pt;}</style>',0),('PBtmpl0000000000000210',1255485474,'3','pbversion0000000000001','approved','Request Tracker Post Form','Request Tracker Post Form','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,5698,'<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n\n\n',0,1,0,1255485476,'<style type=\"text/css\">table.defaultPostForm td{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('default_post_received1',1255485475,'3','pbversion0000000000001','approved','Default Post Received','Default Post Received','default_post_received','3','7','4',NULL,0,0,0,0,0,541,NULL,0,1,0,1255485476,NULL,0),('g8W53Pd71uHB9pxaXhWf_A',1256702481,'3','pbversion0000000000001','approved','My Purchases Detail (Default)','My Purchases Detail (Default)','shopping-cart-collateral-items/my-purchases-detail-default','3','7','3',NULL,0,1,0,0,0,8065,'<style type=\"text/css\">\n	.wgPurchase {\n\n	}\n\n    .wgPurchase .endOfList {\n        clear: left;\n    }\n\n	.wgPurchase h3.title {\n		font-size:14px;\n		background-color:black;\n		color:white;\n		padding:3px;\n	}\n\n	.wgPurchase ul.dataList,\n	.wgPurchase ul.dataList li {\n		margin:0px;\n		padding:0px;\n		list-style-type:none;\n		font-size:10px;\n	}\n	.wgPurchase ul.dataList li {\n		background-color:#F1F1F1;\n		margin:6px;\n		line-height:20px;\n	}\n	.wgPurchase ul.dataList span {\n		background-color:#E0E0E0;\n		font-weight:bold;\n		width:200px;\n		display:block;\n		float:left;\n		margin-right:5px;\n		padding-right:5px;\n		text-align:right;\n		border-right:solid white 1px;\n	}\n	.wgPurchase .address {\n		float:left;\n		margin:6px;\n	}\n	.wgPurchase .address {\n		background-color:#f1f1f1;\n		-moz-border-radius:15px;\n		width:48%;\n	}\n	.wgPurchase .address div:first-child {\n		font-weight:bold;\n		background-color:#E0E0E0;\n		-moz-border-radius-topLeft:15px;\n		-moz-border-radius-topRight:15px;\n		padding:5px;\n	}\n	.wgPurchase .address div:last-child {\n		padding:10px;\n	}\n\n	.wgPurchase .transactionItems {\n		clear:both;\n		width:98%;\n		margin-top:15px;\n	}\n	.wgPurchase .transactionItems th {\n		background-color:#E0E0E0;\n		padding:3px;\n		text-align:left;\n		border-left:solid #AAAAAA 1px;\n		border-right:solid #f1f1f1 1px;\n	}\n	.wgPurchase .transactionItems th:first-child {\n		-moz-border-radius-topLeft: 15px;\n		border-left-style:none;\n	}\n	.wgPurchase .transactionItems th:last-child {\n		-moz-border-radius-topRight: 15px;\n		border-right-style:none;\n	}\n	.wgPurchase .transactionItems td {\n		background-color:#F1F1F1;\n		border-bottom:solid #E0E0E0 1PX;\n		border-top:solid #fff 1px;\n		border-left:solid #e0e0e0 1px;\n		border-right:solid white 1px;\n		padding:3px;		\n	}\n</style>\n',0,1,0,1256702483,'<style type=\"text/css\">.wgPurchase{}.wgPurchase .endOfList{clear:left;}.wgPurchase h3.title{font-size:14px;background-color:black;color:white;padding:3px;}.wgPurchase ul.dataList,.wgPurchase ul.dataList li{margin:0px;padding:0px;list-style-type:none;font-size:10px;}.wgPurchase ul.dataList li{background-color:#F1F1F1;margin:6px;line-height:20px;}.wgPurchase ul.dataList span{background-color:#E0E0E0;font-weight:bold;width:200px;display:block;float:left;margin-right:5px;padding-right:5px;text-align:right;border-right:solid white 1px;}.wgPurchase .address{float:left;margin:6px;}.wgPurchase .address{background-color:#f1f1f1;-moz-border-radius:15px;width:48%;}.wgPurchase .address div:first-child{font-weight:bold;background-color:#E0E0E0;-moz-border-radius-topLeft:15px;-moz-border-radius-topRight:15px;padding:5px;}.wgPurchase .address div:last-child{padding:10px;}.wgPurchase .transactionItems{clear:both;width:98%;margin-top:15px;}.wgPurchase .transactionItems th{background-color:#E0E0E0;padding:3px;text-align:left;border-left:solid #AAAAAA 1px;border-right:solid #f1f1f1 1px;}.wgPurchase .transactionItems th:first-child{-moz-border-radius-topLeft:15px;border-left-style:none;}.wgPurchase .transactionItems th:last-child{-moz-border-radius-topRight:15px;border-right-style:none;}.wgPurchase .transactionItems td{background-color:#F1F1F1;border-bottom:solid #E0E0E0 1PX;border-top:solid #fff 1px;border-left:solid #e0e0e0 1px;border-right:solid white 1px;padding:3px;}</style>',0),('PBtmpl0000000000000027',1256702482,'3','pbversion0000000000001','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,3058,NULL,0,1,0,1256702483,NULL,0),('CalendarEventEdit00001',1256702482,'3','pbversion0000000000001','approved','Default Calendar Event Edit','Default Calendar Event Edit','root/import/calendar-templates/default-calendar-event-edit','3','7','12',NULL,0,0,0,0,0,17038,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/dom/dom.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/dragdrop/dragdrop.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/logger/logger.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(textFix.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script>\n    <style type=\"text/css\">\n        body * {\n            margin:0px;\n        }\n        table td {\n            font-family:Arial;\n            font-size:10px;\n        }\n        #tabs a {\n            border:solid #F0F0F0 1px;\n            -moz-border-radius-topLeft: 20px;\n            -moz-border-radius-topRight: 20px;\n            font-weight:bold;\n            padding: 2px 15px 0px 15px;\n            text-align;center;\n            background-color:#FBFBFB;\n            border-top:solid #F0F0F0 2px;\n            color:#b0b0b0;\n            text-decoration:none;\n            font-size:10pt;\n            display:block;\n            float:left;\n            margin-right:5px;\n        }\n        #tabs a:hover {\n            color:black;\n        }\n        #tabs .active {\n            background-color:#F0F0F0;\n            color:#404040;\n        }\n        table a {\n            font-size:11px;\n            color:#447BFD;\n        }\n        input, select {\n            font-size:10px;\n            border:gray solid 1px;\n            background-color:#F0F0F0;\n            cursor:pointer;\n        }\n    </style>\n\n',0,1,0,1256702483,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dom/dom.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dragdrop/dragdrop.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/logger/logger.js);\" type=\"text/javascript\"></script><script src=\"^Extras(textFix.js);\" type=\"text/javascript\"></script><script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script><style type=\"text/css\">body *{margin:0px;}table td{font-family:Arial;font-size:10px;}#tabs a{border:solid #F0F0F0 1px;-moz-border-radius-topLeft:20px;-moz-border-radius-topRight:20px;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#FBFBFB;border-top:solid #F0F0F0 2px;color:#b0b0b0;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#tabs a:hover{color:black;}#tabs .active{background-color:#F0F0F0;color:#404040;}table a{font-size:11px;color:#447BFD;}input,select{font-size:10px;border:gray solid 1px;background-color:#F0F0F0;cursor:pointer;}</style>',0),('9j0_Z1j3Jd0QBbY2akb6qw',1256702482,'3','pbversion0000000000001','approved','Default Map View','Default Map View','home/map/map-templates/default-map-view','3','7','3',NULL,0,1,0,0,0,1289,'<style type=\"text/css\">\r\n.wg_editMapPoint label {\r\n    display: block;\r\n}\r\n.wg_editMapPoint input, .wg_editMapPoint textarea, .wg_editMapPoint select {\r\n    display: block;\r\n}\r\n.wg_editMapPoint textarea {\r\n    width: 100%;\r\n}\r\n\r\n#editPoint .bd { height: 500px; width: 500px; overflow-y: scroll }\r\n</style>',0,1,0,1256702483,'<style type=\"text/css\">.wg_editMapPoint label{display:block;}.wg_editMapPoint input,.wg_editMapPoint textarea,.wg_editMapPoint select{display:block;}.wg_editMapPoint textarea{width:100%;}#editPoint .bd{height:500px;width:500px; overflow-y: scroll}</style>',0),('-K8Hj45mbelljN9-0CXZxg',1256702482,'3','pbversion0000000000001','approved','DataForm','DataForm','root/import/dataform','3','7','12',NULL,0,0,0,0,0,336,NULL,0,1,0,1256702483,NULL,0),('PBtmpl0000000000000020',1256702482,'3','pbversion0000000000001','approved','Mail Form','Mail Form','mail_form','3','7','12',NULL,0,1,0,0,0,4556,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.fontSettings{\n	font-family:arial;\n	font-size:9pt;\n}\n.mailForm td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>\n',0,1,0,1256702483,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.fontSettings{font-family:arial;font-size:9pt;}.mailForm td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('PBtmpl0000000000000085',1256702482,'3','pbversion0000000000001','approved','Default Email','Default Email','default_email','3','7','12',NULL,0,1,0,0,0,2008,NULL,0,1,0,1256702483,NULL,0),('PBtmpl0000000000000104',1256702482,'3','pbversion0000000000001','approved','Default Acknowledgement','Default Acknowledgement','default_acknowledgement','3','7','12',NULL,0,1,0,0,0,1736,'<style type=\"text/css\">\n.acknowledgement\n{\n	margin-top:5px;\n}\n.acknowledgement td\n{\n	font-size:9pt;\n	font-family:arial;\n}\n\na.blackLabel\n{\n	color:#29587E;\n}\n\n</style>',0,1,0,1256702483,'<style type=\"text/css\">.acknowledgement{margin-top:5px;}.acknowledgement td{font-size:9pt;font-family:arial;}a.blackLabel{color:#29587E;}</style>',0),('PBtmpl0000000000000021',1256702482,'3','pbversion0000000000001','approved','Data List','Data List','data_list','3','7','12',NULL,0,1,0,0,0,4024,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.errors{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultData td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>',0,1,0,1256702483,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.errors{font-family:arial;font-size:9pt;}.defaultData td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('PBtmpl0000000000000116',1256702482,'3','pbversion0000000000001','approved','Tab Form','Tab Form','tab_form','3','7','12',NULL,0,1,0,0,0,5667,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.fontSettings{\n	font-family:arial;\n	font-size:9pt;\n}\n.tabForm td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>\n',0,1,0,1256702483,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.fontSettings{font-family:arial;font-size:9pt;}.tabForm td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('PBtmpl0000000000000141',1256702482,'3','pbversion0000000000001','approved','Default DataForm','Default DataForm','pbtmpl0000000000000141','3','7','12',NULL,0,1,0,0,0,5973,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.errors{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultData td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>\n',0,1,0,1256702483,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.errors{font-family:arial;font-size:9pt;}.defaultData td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('2GxjjkRuRkdUg_PccRPjpA',1256702483,'3','pbversion0000000000001','approved','Select Gateway (Default)','Select Gateway (Default)','shopping-cart-collateral-items/select-gateway-default','3','7','3',NULL,0,1,0,0,0,614,'\r\n',0,1,0,1256702483,NULL,0),('2gtFt7c0qAFNU3BG_uvNvg',1256702483,'3','pbversion0000000000001','approved','My Purchases (Default)','My Purchases (Default)','shopping-cart-collateral-items/my-purchases-default','3','7','3',NULL,0,1,0,0,0,3045,'<style type=\"text/css\">\n	.wgPurchase h3.title {\n		margin-bottom:0px;\n	}\n	.wgPurchase .transactionItems {\n		clear:both;\n		width:98%;\n		margin-top:15px;\n	}\n	.wgPurchase .transactionItems th {\n		background-color:#E0E0E0;\n		padding:3px;\n		text-align:left;\n		border-left:solid #AAAAAA 1px;\n		border-right:solid #f1f1f1 1px;\n	}\n	.wgPurchase .transactionItems th:first-child {\n		-moz-border-radius-topLeft: 15px;\n		border-left-style:none;\n	}\n	.wgPurchase .transactionItems th:last-child {\n		-moz-border-radius-topRight: 15px;\n		border-right-style:none;\n	}\n	.wgPurchase .transactionItems td {\n		background-color:#F1F1F1;\n		border-bottom:solid #E0E0E0 1PX;\n		border-top:solid #fff 1px;\n		border-left:solid #e0e0e0 1px;\n		border-right:solid white 1px;\n		padding:3px;		\n	}\n</style>\n',0,1,0,1256702483,'<style type=\"text/css\">.wgPurchase h3.title{margin-bottom:0px;}.wgPurchase .transactionItems{clear:both;width:98%;margin-top:15px;}.wgPurchase .transactionItems th{background-color:#E0E0E0;padding:3px;text-align:left;border-left:solid #AAAAAA 1px;border-right:solid #f1f1f1 1px;}.wgPurchase .transactionItems th:first-child{-moz-border-radius-topLeft:15px;border-left-style:none;}.wgPurchase .transactionItems th:last-child{-moz-border-radius-topRight:15px;border-right-style:none;}.wgPurchase .transactionItems td{background-color:#F1F1F1;border-bottom:solid #E0E0E0 1PX;border-top:solid #fff 1px;border-left:solid #e0e0e0 1px;border-right:solid white 1px;padding:3px;}</style>',0),('PBtmpl0000000000000060',1256702483,'3','pbversion0000000000001','approved','Fail Safe','Fail Safe','fail_safe','3','7','12',NULL,0,1,0,0,0,1756,NULL,0,1,0,1256702483,NULL,0),('pbrobot000000000000001',1256702483,'3','pbversion0000000000001','approved','robots.txt','robots.txt','robots.txt','3','7','12',NULL,0,0,0,0,0,474,NULL,0,1,0,1256702483,NULL,0),('PBtmpl0000000000000117',1259128608,'3','pbversion0000000000001','approved','DropMenu','DropMenu','dropmenu','3','7','12',NULL,0,1,0,0,0,2566,'<script type=\"text/javascript\" defer=\"defer\">\n//<![CDATA[\nfunction go(formObj) {\n	if (formObj.chooser.options[formObj.chooser.selectedIndex].value != \"none\") {\n		location = formObj.chooser.options[formObj.chooser.selectedIndex].value;\n	}\n}\n//]]>\n</script>',0,1,0,1259128610,'<script type=\"text/javascript\" defer=\"defer\">/*<![CDATA[*/function go(a){if(a.chooser.options[a.chooser.selectedIndex].value!=\"none\"){location=a.chooser.options[a.chooser.selectedIndex].value}}/*]]>*/</script>',0),('PBtmpl0000000000000136',1259128608,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis2','3','7','12',NULL,0,1,0,0,0,1641,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000093',1259128608,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail2','3','7','12',NULL,0,1,0,0,0,1405,NULL,0,1,0,1259128610,NULL,0),('GNvjCFQWjY2AF2uf0aCM8Q',1259128608,'3','pbversion0000000000001','approved','Syndicated Articles','Syndicated Articles','syndicated_articles','3','7','12',NULL,0,1,0,0,0,2288,NULL,0,1,0,1259128610,NULL,0),('-PkdI8l1idu-8gDX3iOdcw',1259128608,'3','pbversion0000000000001','approved','One Over Two','One Over Two','one_over_two','3','7','12',NULL,0,1,0,0,0,5991,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1259128610,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000103',1259128608,'3','pbversion0000000000001','approved','Article With Image','Article With Image','article-with-image','3','7','12',NULL,0,1,0,0,0,1961,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--article-->',0,1,0,1259128610,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000024',1259128608,'3','pbversion0000000000001','approved','File','File','file','3','7','12',NULL,0,1,0,0,0,894,NULL,0,1,0,1259128610,NULL,0),('XdlKhCDvArs40uqBhvzR3w',1259128608,'3','pbversion0000000000001','approved','Article With Pagination','Article With Pagination','article-with-pagination','3','7','12',NULL,0,1,0,0,0,3096,'\n',0,1,0,1259128610,NULL,0),('PBnav00000000indentnav',1259128608,'3','pbversion0000000000001','approved','Indent Nav','Indent Nav','indent_nav','3','7','12',NULL,0,0,0,0,0,1877,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0,1,0,1259128610,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000124',1259128609,'3','pbversion0000000000001','approved','Tabs','Tabs','tabs','3','7','12',NULL,0,1,0,0,0,1678,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0,1,0,1259128610,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000131',1259128609,'3','pbversion0000000000001','approved','Right Column','Right Column','right_column','3','7','12',NULL,0,1,0,0,0,4643,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1259128610,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000134',1259128609,'3','pbversion0000000000001','approved','Hierarchical Top Nav','Hierarchical Top Nav','import/hierarchical-top-nav','3','7','12',NULL,0,1,0,0,0,3913,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\n<!-- Page-specific script -->\n<script type=\"text/javascript\">\n//<![CDATA[\n    YAHOO.util.Event.onAvailable(\"webguinavigation\", function() {\n        var wgMenuBar = new YAHOO.widget.MenuBar(\"webguinavigation\", {\n            autosubmenudisplay : true,\n            showdelay          : 250,\n            hidedelay          : 750,\n            lazyload           : true\n        });\n        wgMenuBar.render();\n    });\n//]]>\n</script>\n',0,1,0,1259128610,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onAvailable(\"webguinavigation\",function(){var a=new YAHOO.widget.MenuBar(\"webguinavigation\",{autosubmenudisplay:true,showdelay:250,hidedelay:750,lazyload:true});a.render()});/*]]>*/</script>',0),('PBtmpl0000000000000088',1259128609,'3','pbversion0000000000001','approved','Image','Image','image','3','7','12',NULL,0,1,0,0,0,778,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000078',1259128609,'3','pbversion0000000000001','approved','File Folder','File Folder','file_folder','3','7','12',NULL,0,1,0,0,0,3708,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000055',1259128609,'3','pbversion0000000000001','approved','Default Poll','Default Poll','default_poll','3','7','12',NULL,0,1,0,0,0,2928,'<link href=\"^/(poll.css);\" type=\"text/css\" rel=\"stylesheet\" /><!--poll-->',0,1,0,1259128610,'<link href=\"^/(poll.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000065',1259128609,'3','pbversion0000000000001','approved','Default Syndicated Content','Default Syndicated Content','default_syndicated_content','3','7','12',NULL,0,1,0,0,0,2246,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000054',1259128609,'3','pbversion0000000000001','approved','Default Page','Default Page','default_page','3','7','12',NULL,0,1,0,0,0,2912,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1259128610,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000108',1259128609,'3','pbversion0000000000001','approved','horizontalMenu','horizontalMenu','horizontalmenu','3','7','12',NULL,0,1,0,0,0,1888,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0,1,0,1259128610,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000115',1259128609,'3','pbversion0000000000001','approved','Linked Image with Caption','Linked Image with Caption','linked_image_with_caption','3','7','12',NULL,0,1,0,0,0,2246,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--article-->',0,1,0,1259128610,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000109',1259128609,'3','pbversion0000000000001','approved','One Over Three','One Over Three','one_over_three','3','7','12',NULL,0,1,0,0,0,7556,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1259128610,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('VCFhB9WOsDsH2Apj3c6DpQ',1259128609,'3','pbversion0000000000001','approved','Three Columns','Three Columns','three-columns','3','7','12',NULL,0,1,0,0,0,5620,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1259128610,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000002',1259128609,'3','pbversion0000000000001','approved','Default Article','Default Article','default_article','3','7','12',NULL,0,1,0,0,0,2070,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000123',1259128609,'3','pbversion0000000000001','approved','Item','Item','item','3','7','12',NULL,0,1,0,0,0,2111,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000200',1259128609,'3','pbversion0000000000001','approved','Default Search','Default Search','default_search2','3','7','12',NULL,0,0,0,0,0,3831,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000135',1259128610,'3','pbversion0000000000001','approved','Side By Side','Side By Side','side_by_side','3','7','12',NULL,0,1,0,0,0,4241,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->\n',0,1,0,1259128610,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('MK4fCNoyrx5SE8eyDfOpxg',1259128610,'3','pbversion0000000000001','approved','Flash File','Flash File','flash-file','3','7','12',NULL,0,1,0,0,0,1731,NULL,0,1,0,1259128610,NULL,0),('PBtmpl0000000000000130',1259128610,'3','pbversion0000000000001','approved','Tree Navigation','Tree Navigation','root/import/navigation/tree-navigation','3','7','12',NULL,0,1,0,0,0,3424,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/treeview/assets/skins/sam/treeview.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/treeview/treeview-min.js);\"></script>\n',0,1,0,1259128610,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/treeview/assets/skins/sam/treeview.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/treeview/treeview-min.js);\"></script>',0),('PBnav00000000000bullet',1261540404,'3','pbversion0000000000001','approved','Bulleted List','Bulleted List','bulleted_list','3','7','12',NULL,0,0,0,0,0,2319,'\r\n',0,1,0,1261540406,NULL,0),('matrixtmpl000000000001',1261540405,'3','pbversion0000000000001','approved','Matrix Default View','Matrix Default View','matrix-default-view-template','3','7','12',NULL,0,0,0,0,0,22183,'<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->\n\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\n\n\n',0,1,0,1261540405,'<style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style><script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>',0),('GRUNFctldUgop-qRLuo_DA',1261540405,'3','pbversion0000000000001','approved','Default Survey Edit','Default Survey Edit','root/import/survey/default-survey-edit','3','7','12',NULL,0,1,0,0,0,6574,NULL,0,1,0,1261540406,NULL,0),('matrixtmpl000000000005',1261540405,'3','pbversion0000000000001','approved','Matrix Default Search','Matrix Default Search','matrix-search-template','3','7','12',NULL,0,0,0,0,0,10239,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->',0,1,0,1261540406,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script><script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script><style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style>',0),('mRtqRuVikSe82BQsYBlD0A',1263358862,'3','pbversion0000000000001','approved','Bare Image','Bare Image','bare_image','3','7','12',NULL,0,1,0,0,0,558,NULL,0,1,0,1263358862,NULL,0),('BMybD3cEnmXVk2wQ_qEsRQ',1263358862,'3','pbversion0000000000001','approved','Badge Builder (Default)','Badge Builder (Default)','root/import/ems/badge-builder-default','3','7','12',NULL,0,1,0,0,0,35893,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui-webgui/build/string/string.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\n		.skuDescription {\n		background-color: white;\n		max-width: 400px;\n		border:1px solid #000;\n		padding:10px;\n		}\n		.forwardButton {\n			background-color: green;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n		.backwardButton {\n			background-color: red;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n		#emstickets p, #emsribbons p, #emstokens p { text-align: left; padding: 5px; }\n		#badge {\n			font-size: 15px;\n			-moz-border-radius: 10px;\n			-webkit-border-radius: 10px;\n			border-radius: 10px;\n			border: 3px solid #2647a0;\n		}\n		#badgeHolderName {\n			background-color: #2647a0;\n			width: 100%;\n			color: white;\n			font-family: bold;\n			font-size: 25px;\n			padding: 5px 0px 5px 0px;\n			margin: 5px 0px 5px 0px;\n			margin-bottom: 5px;\n		}\n		#badgeTicketList div , #badgeRibbonList div , #badgeTokenList div {\n			border-top: 1px solid #808080;\n			width: 100%;\n			font-size: 13px;\n			padding: 5px 0px 5px 0px;\n			margin-top: 5px;\n		}\n</style>\n\n',0,1,0,1263358862,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui-webgui/build/string/string.js);\" type=\"text/javascript\"></script><style type=\"text/css\">.skuDescription{background-color:white;max-width:400px;border:1px solid #000;padding:10px;}.forwardButton{background-color:green;color:white;font-weight:bold;padding:3px;}.backwardButton{background-color:red;color:white;font-weight:bold;padding:3px;}#emstickets p,#emsribbons p,#emstokens p{text-align:left;padding:5px;}#badge{font-size:15px;-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px;border:3px solid #2647a0;}#badgeHolderName{background-color:#2647a0;width:100%;color:white;font-family:bold;font-size:25px;padding:5px 0px 5px 0px;margin:5px 0px 5px 0px;margin-bottom:5px;}#badgeTicketList div,#badgeRibbonList div,#badgeTokenList div{border-top:1px solid #808080;width:100%;font-size:13px;padding:5px 0px 5px 0px;margin-top:5px;}</style>',0);
ALTER TABLE `assetData` ENABLE KEYS;
ALTER TABLE `assetIndex` DISABLE KEYS;
INSERT INTO `assetIndex` VALUES ('PBasset000000000000003','Media','Media Media media','media',1147642437,1147642437,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Media Media media','000001000003'),('PBtmpl0000000000000112','Weblog','Weblog Weblog weblog','weblog',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Weblog Weblog weblog Collaboration','000001000001000008000004'),('PBtmplBlankStyle000001','WebGUI 6 Blank Style','WebGUI 6 Blank Style WebGUI 6 Blank Style pbtmplblankstyle000001','pbtmplblankstyle000001',1133743239,1147642431,'3','7','12','WebGUI::Asset::Template',0,'WebGUI 6 Blank Style WebGUI 6 Blank Style pbtmplblankstyle000001 style','000001000001000043000005'),('PBtmpl0000000000000079','Topics','Topics Topics topics','topics',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Topics Topics topics Collaboration','000001000001000008000009'),('PBtmpl0000000000000097','Traditional with Thumbnails','Traditional with Thumbnails Traditional with Thumbnails traditional with thumbnails','traditional_with_thumbnails',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Traditional with Thumbnails Traditional with Thumbnails traditional with thumbnails Collaboration','000001000001000008000003'),('PBtmpl0000000000000082','Unordered List','Unordered List Unordered List unordered list','unordered_list',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Unordered List Unordered List unordered list Collaboration','000001000001000008000011'),('PBtmpl0000000000000124','Tabs','Tabs Tabs tabs','tabs',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Tabs Tabs tabs Navigation','000001000001000025000004'),('GNvjCFQWjY2AF2uf0aCM8Q','Syndicated Articles','Syndicated Articles Syndicated Articles syndicated articles','syndicated_articles',1124395696,1259128608,'3','7','12','WebGUI::Asset::Template',0,'Syndicated Articles Syndicated Articles syndicated articles SyndicatedContent','000001000001000045000002'),('PBtmpl0000000000000136','Synopsis','Synopsis Synopsis synopsis2','synopsis2',1124395696,1259128608,'3','7','12','WebGUI::Asset::Template',0,'Synopsis Synopsis synopsis2 Navigation','000001000001000025000007'),('PBtmpl0000000000000116','Tab Form','Tab Form Tab Form tab form','tab_form',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Tab Form Tab Form tab form DataForm','000001000001000010000005'),('GRUNFctldUgop-qRLuo_DA','Default Survey Edit','Default Survey Edit Default Survey Edit root import survey default survey edit','root/import/survey/default-survey-edit',1227254010,1261540405,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Edit Default Survey Edit root import survey default survey edit Survey/Edit','000001000001000044000004'),('ProjectManagerTMPL0004','Default Project Manager Edit Task','Default Project Manager Edit Task Default Project Manager Edit Task default pm template edit task','default-pm-template-edit-task',1147642415,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Default Project Manager Edit Task Default Project Manager Edit Task default pm template edit task ProjectManager_editTask','000001000001000031000002000001'),('ProjectManagerTMPL0002','Default Project Display','Default Project Display Default Project Display default pm template project display','default-pm-template-project-display',1147642415,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Default Project Display Default Project Display default pm template project display ProjectManager_project','000001000001000031000004000001'),('PBtmpl0000000000000137','Admin Console Style','Admin Console Style Admin Console admin console','admin_console',1124395696,1236787780,'3','7','12','WebGUI::Asset::Template',0,'Admin Console Style Admin Console admin console style','000001000001000043000003'),('StockDataTMPL000000001','StockData Default View','StockData Default View StockData Default View stockdatatmpl000000001','stockdatatmpl000000001',1133743239,1229453697,'3','7','12','WebGUI::Asset::Template',0,'StockData Default View StockData Default View stockdatatmpl000000001 StockData','000001000001000041000002'),('PBtmpl0000000000000135','Side By Side','Side By Side Side By Side side by side','side_by_side',1124395696,1259128610,'3','7','12','WebGUI::Asset::Template',0,'Side By Side Side By Side side by side Layout','000001000001000019000001'),('PBtmpl0000000000000200','Default Search','Default Search Default Search default search2','default_search2',1147642427,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Default Search Default Search default search2 Search','000001000001000036000001'),('PBtmpl0000000000000101','Ordered List','Ordered List Ordered List ordered list','ordered_list',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Ordered List Ordered List ordered list Collaboration','000001000001000008000024'),('PBtmpl0000000000000121','Photo Gallery','Photo Gallery Photo Gallery photo gallery','photo_gallery',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Photo Gallery Photo Gallery photo gallery Collaboration','000001000001000008000005'),('PBtmpl0000000000000081','Q and A','Q and A Q and A q and a','q_and_a',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Q and A Q and A q and a Collaboration','000001000001000008000023'),('WVtmpl0000000000000001','Random Thread Macro Default Template','Random Thread Macro Default Template Random Thread Macro Default Template randomthread template','randomthread-template',1133743240,1147642426,'3','7','12','WebGUI::Asset::Template',0,'Random Thread Macro Default Template Random Thread Macro Default Template randomthread template Macro/RandomThread','000001000001000021000010000001'),('PBtmpl0000000000000131','Right Column','Right Column Right Column right column','right_column',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Right Column Right Column right column Layout','000001000001000019000002'),('PBtmpl0000000000000094','News','News News plainblacknews','plainblacknews',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',0,'News News plainblacknews Layout','000001000001000019000005'),('matrixtmpl000000000005','Matrix Default Search','Matrix Default Search Matrix Default Search matrix search template','matrix-search-template',1133743239,1261540405,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Search Matrix Default Search matrix search template Matrix/Search','000001000001000022000005'),('MultiSearchTmpl0000001','MultiSearch Default Display','MultiSearch Default Display MultiSearch Default Display multisearchtmpl0000001','multisearchtmpl0000001',1133743239,1230269962,'3','7','12','WebGUI::Asset::Template',0,'MultiSearch Default Display MultiSearch Default Display multisearchtmpl0000001 MultiSearch','000001000001000024000001'),('matrixtmpl000000000002','Matrix Default Compare','Matrix Default Compare Matrix Default Compare matrix default compare template','matrix-default-compare-template',1133743238,1251054814,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Compare Matrix Default Compare matrix default compare template Matrix/Compare','000001000001000022000001'),('PBtmpl0000000000000111','Make Page Printable','Make Page Printable Make Page Printable make page printable','make_page_printable',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',0,'Make Page Printable Make Page Printable make page printable style','000001000001000043000002'),('PBtmpl0000000000000020','Mail Form','Mail Form Mail Form mail form','mail_form',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Mail Form Mail Form mail form DataForm','000001000001000010000001'),('PBtmpl0000000000000113','Link','Link Link link','link',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Link Link link Collaboration/Thread','000001000001000008000025'),('PBtmpl0000000000000083','Link List','Link List Link List link list','link_list',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Link List Link List link list Collaboration','000001000001000008000010'),('PBtmpl0000000000000114','Link List Submission Form','Link List Submission Form Link List Submission Form link list submission form','link_list_submission_form',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Link List Submission Form Link List Submission Form link list submission form Collaboration/PostForm','000001000001000008000019'),('PBtmpl0000000000000115','Linked Image with Caption','Linked Image with Caption Linked Image with Caption linked image with caption','linked_image_with_caption',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Linked Image with Caption Linked Image with Caption linked image with caption Article','000001000001000004000003'),('PBtmpl0000000000000098','Job','Job Job job','job',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Job Job job Collaboration/Thread','000001000001000008000021'),('PBtmpl0000000000000077','Job Listing','Job Listing Job Listing job listing','job_listing',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Job Listing Job Listing job listing Collaboration','000001000001000008000020'),('PBtmpl0000000000000122','Job Submission Form','Job Submission Form Job Submission Form job submission form','job_submission_form',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Job Submission Form Job Submission Form job submission form Collaboration/PostForm','000001000001000008000022'),('PBtmpl0000000000000103','Article With Image','Article With Image Article With Image article with image','article-with-image',1124395696,1259128608,'3','7','12','WebGUI::Asset::Template',0,'Article With Image Article With Image article with image Article','000001000001000004000001'),('PBtmpl0000000000000092','Horizontal Login Box','Horizontal Login Box Horizontal Login Box horizontal login box','horizontal_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',0,'Horizontal Login Box Horizontal Login Box horizontal login box Macro/L_loginBox','000001000001000021000009000001'),('PBtmpl0000000000000108','horizontalMenu','horizontalMenu horizontalMenu horizontalmenu','horizontalmenu',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'horizontalMenu horizontalMenu horizontalmenu Navigation','000001000001000025000002'),('PBtmpl0000000000000088','Image','Image Image image','image',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Image Image image ImageAsset','000001000001000017000001'),('IOB0000000000000000002','Default InOutBoard Report Template','Default InOutBoard Report Template Default InOutBoard Report Template iob report template','iob-report-template',1133743239,1166019641,'3','7','12','WebGUI::Asset::Template',0,'Default InOutBoard Report Template Default InOutBoard Report Template iob report template InOutBoard/Report','000001000001000018000001'),('IOB0000000000000000001','Default InOutBoard Template','Default InOutBoard Template Default InOutBoard Template iob template','iob-template',1133743239,1169795123,'3','7','12','WebGUI::Asset::Template',0,'Default InOutBoard Template Default InOutBoard Template iob template InOutBoard','000001000001000018000002'),('PBtmpl0000000000000123','Item','Item Item item','item',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Item Item item Article','000001000001000004000004'),('PBtmpl0000000000000024','File','File File file','file',1124395696,1259128608,'3','7','12','WebGUI::Asset::Template',0,'File File file FileAsset','000001000001000013000001'),('PBtmpl0000000000000078','File Folder','File Folder File Folder file folder','file_folder',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'File Folder File Folder file folder Folder','000001000001000014000001'),('PBtmpl0000000000000107','File with size','File with size File with size file with size','file_with_size',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',0,'File with size File with size file with size Macro/File','000001000001000021000004000003'),('PBtmpl0000000000000133','Guest Book','Guest Book Guest Book guest book','guest_book',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Guest Book Guest Book guest book Collaboration','000001000001000008000012'),('PBtmpl0000000000000117','DropMenu','DropMenu DropMenu dropmenu','dropmenu',1124395696,1259128608,'3','7','12','WebGUI::Asset::Template',0,'DropMenu DropMenu dropmenu Navigation','000001000001000025000003'),('PBtmpl0000000000000130','Tree Navigation','Tree Navigation Tree Navigation root import navigation tree navigation','root/import/navigation/tree-navigation',1124395696,1259128610,'3','7','12','WebGUI::Asset::Template',0,'Tree Navigation Tree Navigation root import navigation tree navigation Navigation','000001000001000025000005'),('PBtmpl0000000000000060','Fail Safe','Fail Safe Fail Safe fail safe','fail_safe',1124395696,1256702483,'3','7','12','WebGUI::Asset::Template',0,'Fail Safe Fail Safe fail safe style','000001000001000043000001'),('PBtmpl0000000000000080','FAQ','FAQ FAQ faqtemplate','faqtemplate',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'FAQ FAQ faqtemplate Collaboration','000001000001000008000002'),('PBtmpl0000000000000099','FAQ Submission Form','FAQ Submission Form FAQ Submission Form faq submission form','faq_submission_form',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'FAQ Submission Form FAQ Submission Form faq submission form Collaboration/PostForm','000001000001000008000018'),('PBtmpl0000000000000010','Default WebGUI Account Display Template','Default WebGUI Account Display Template Default WebGUI Account Display Template default webgui account display template','default_webgui_account_display_template',1124395696,1227026287,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Account Display Template Default WebGUI Account Display Template default webgui account display template Auth/WebGUI/Account','000001000001000005000004000001'),('PBtmpl0000000000000013','Default WebGUI Login Template','Default WebGUI Login Template Default WebGUI Login Template default webgui login template','default_webgui_login_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Login Template Default WebGUI Login Template default webgui login template Auth/WebGUI/Login','000001000001000005000007000001'),('PBtmpl0000000000000012','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template Default WebGUI Password Reset Template default webgui password reset template','default_webgui_password_reset_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Password Reset Template Default WebGUI Password Reset Template default webgui password reset template Auth/WebGUI/Expired','000001000001000005000006000001'),('PBtmpl0000000000000057','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt Default WebGUI Yes/No Prompt default webgui yes no prompt','default_webgui_yes/no_prompt',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Yes/No Prompt Default WebGUI Yes/No Prompt default webgui yes no prompt prompt','000001000001000032000001'),('PBtmpl0000000000000066','Default USS','Default USS Default USS default uss','default_uss',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Default USS Default USS default uss Collaboration','000001000001000008000001'),('TimeTrackingTMPL000001','Default Time Tracking User View','Default Time Tracking User View Default Time Tracking User View default tt template user','default-tt-template-user',1147642417,1201205738,'3','7','12','WebGUI::Asset::Template',0,'Default Time Tracking User View Default Time Tracking User View default tt template user TimeTracking_user','000001000001000048000003000001'),('TimeTrackingTMPL000003','Default Time Tracking Row Template','Default Time Tracking Row Template Default Time Tracking Row Template default tt template row','default-tt-template-row',1147642417,1229311434,'3','7','12','WebGUI::Asset::Template',0,'Default Time Tracking Row Template Default Time Tracking Row Template default tt template row TimeTracking_row','000001000001000048000002000001'),('TimeTrackingTMPL000002','Default Time Tracking Manager View','Default Time Tracking Manager View Default Time Tracking Manager View default tt template manager','default-tt-template-manager',1147642417,1147642417,'3','7','12','WebGUI::Asset::Template',0,'Default Time Tracking Manager View Default Time Tracking Manager View default tt template manager TimeTracking_manager','000001000001000048000001000001'),('X7DrzUcj8pOKFa_6k9D5iw','Newsletter','Newsletter Newsletter root import newsletter','root/import/newsletter',1185754569,1222804045,'3','12','3','WebGUI::Asset::Wobject::Folder',1,'Newsletter Newsletter root import newsletter','000001000001000026'),('PBtmpl0000000000000065','Default Syndicated Content','Default Syndicated Content Default Syndicated Content default syndicated content','default_syndicated_content',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Default Syndicated Content Default Syndicated Content default syndicated content SyndicatedContent','000001000001000045000001'),('CxMpE_UPauZA3p8jdrOABw','Default Questions','Default Questions Default Questions root import survey default questions','root/import/survey/default-questions',1227556536,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Questions Default Questions root import survey default questions Survey/Take','000001000001000044000006'),('PBtmpl0000000000000059','Default SQL Report','Default SQL Report Default SQL Report default sql report','default_sql_report',1124395696,1229907401,'3','7','12','WebGUI::Asset::Template',0,'Default SQL Report Default SQL Report default sql report SQLReport','000001000001000040000001'),('PBtmpl0000000000000067','Default Submission','Default Submission Default Submission default submission','default_submission',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Default Submission Default Submission default submission Collaboration/Thread','000001000001000008000006'),('PBtmpl0000000000000068','Default Submission Form','Default Submission Form Default Submission Form default submission form','default_submission_form',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Default Submission Form Default Submission Form default submission form Collaboration/PostForm','000001000001000008000017'),('ProjectManagerTMPL0003','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart Default Project Manager Gantt Chart default pm template gantt chart','default-pm-template-gantt-chart',1147642415,1159989349,'3','7','12','WebGUI::Asset::Template',0,'Default Project Manager Gantt Chart Default Project Manager Gantt Chart default pm template gantt chart ProjectManager_gantt','000001000001000031000003000001'),('ProjectManagerTMPL0001','Default Project Management System Dashboard','Default Project Management System Dashboard Default Project Management System Dashboard default pm template dashboard','default-pm-template-dashboard',1147642415,1229579830,'3','7','12','WebGUI::Asset::Template',0,'Default Project Management System Dashboard Default Project Management System Dashboard default pm template dashboard ProjectManager_dashboard','000001000001000031000001000001'),('PBtmpl0000000000000055','Default Poll','Default Poll Default Poll default poll','default_poll',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Default Poll Default Poll default poll Poll','000001000001000027000001'),('PBtmpl0000000000000029','Default Post Form','Default Post Form Default Post Form default post form','default_post_form',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Default Post Form Default Post Form default post form Collaboration/PostForm','000001000001000008000013'),('PBtmpl0000000000000056','Default Product','Default Product Default Product default product','default_product',1124395696,1248729559,'3','7','12','WebGUI::Asset::Template',0,'Default Product Default Product default product Product','000001000001000028000001'),('PBtmpl0000000000000033','Default HTTP Proxy','Default HTTP Proxy Default HTTP Proxy default http proxy','default_http_proxy',1124395696,1230159454,'3','7','12','WebGUI::Asset::Template',0,'Default HTTP Proxy Default HTTP Proxy default http proxy HttpProxy','000001000001000016000001'),('PBtmpl0000000000000004','Default LDAP Account Display Template','Default LDAP Account Display Template Default LDAP Account Display Template default ldap account display template','default_ldap_account_display_template',1124395696,1227026214,'3','7','12','WebGUI::Asset::Template',0,'Default LDAP Account Display Template Default LDAP Account Display Template default ldap account display template Auth/LDAP/Account','000001000001000005000001000001'),('PBtmpl0000000000000006','Default LDAP Login Template','Default LDAP Login Template Default LDAP Login Template default ldap login template','default_ldap_login_template',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',0,'Default LDAP Login Template Default LDAP Login Template default ldap login template Auth/LDAP/Login','000001000001000005000003000001'),('PBtmpl0000000000000044','Default Login Box','Default Login Box Default Login Box default login box','default_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',0,'Default Login Box Default Login Box default login box Macro/L_loginBox','000001000001000021000009000002'),('PBtmpl0000000000000047','Default Message Board','Default Message Board Default Message Board default message board','default_message_board',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',0,'Default Message Board Default Message Board default message board MessageBoard','000001000001000023000001'),('PBtmpl0000000000000054','Default Page','Default Page Default Page default page','default_page',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Default Page Default Page default page Layout','000001000001000019000003'),('Q4uX_C557arTp6D_jwB1jQ','Wiki','Wiki Wiki root import wiki','root/import/wiki',1165460175,1222803760,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'Wiki Wiki root import wiki','000001000001000055'),('BmLaN4rmAANkCglXUViEbg','Resource','Resource Resource root import projectmanager resource','root/import/projectmanager/resource',1157679165,1222803871,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'Resource Resource root import projectmanager resource','000001000001000031000005'),('PBtmpl0000000000000039','Default File Macro','Default File Macro Default File Macro default file macro','default_file_macro',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',0,'Default File Macro Default File Macro default file macro Macro/File','000001000001000021000004000001'),('PBtmpl0000000000000026','Default Forum','Default Forum Default Forum default forum','default_forum',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Default Forum Default Forum default forum Collaboration','000001000001000008000007'),('PBtmpl0000000000000031','Default Forum Search','Default Forum Search Default Forum Search default forum search','default_forum_search',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Default Forum Search Default Forum Search default forum search Collaboration/Search','000001000001000008000016'),('PBtmpl0000000000000093','crumbTrail','crumbTrail crumbTrail crumbtrail2','crumbtrail2',1124395696,1259128608,'3','7','12','WebGUI::Asset::Template',0,'crumbTrail crumbTrail crumbtrail2 Navigation','000001000001000025000001'),('DashboardViewTmpl00001','Dashboard Default View','Dashboard Default View Dashboard Default View dashboard default view template','dashboard-default-view-template',1133743239,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Dashboard Default View Dashboard Default View dashboard default view template Dashboard','000001000001000009000001'),('PBtmpl0000000000000021','Data List','Data List Data List data list','data_list',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Data List Data List data list DataForm/List','000001000001000010000004'),('PBtmpl0000000000000104','Default Acknowledgement','Default Acknowledgement Default Acknowledgement default acknowledgement','default_acknowledgement',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Default Acknowledgement Default Acknowledgement default acknowledgement DataForm','000001000001000010000003'),('PBtmpl0000000000000002','Default Article','Default Article Default Article default article','default_article',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Default Article Default Article default article Article','000001000001000004000002'),('PBtmpl0000000000000141','Default DataForm','Default DataForm Default DataForm pbtmpl0000000000000141','pbtmpl0000000000000141',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Default DataForm Default DataForm pbtmpl0000000000000141 DataForm','000001000001000010000006'),('WikiRCTmpl000000000001','Default Recent Changes','Default Recent Changes Default Recent Changes default wiki recent changes','default-wiki-recent-changes',1165460175,1169092823,'3','7','12','WebGUI::Asset::Template',0,'Default Recent Changes Default Recent Changes default wiki recent changes WikiMaster_recentChanges','000001000001000055000001'),('PBtmpl0000000000000128','Classifieds','Classifieds Classifieds classifieds','classifieds',1124395696,1255485473,'3','7','12','WebGUI::Asset::Template',0,'Classifieds Classifieds classifieds Collaboration','000001000001000008000008'),('PBtmpl0000000000000134','Hierarchical Top Nav','Hierarchical Top Nav Hierarchical Top Nav import hierarchical top nav','import/hierarchical-top-nav',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Hierarchical Top Nav Hierarchical Top Nav import hierarchical top nav Navigation','000001000001000025000006'),('PBtmplHelp000000000001','Help','Help Help help','help',1124395706,1147642410,'3','7','12','WebGUI::Asset::Template',0,'Help Help help AdminConsole','000001000001000003000002'),('PBtmpl0000000000000208','Request Tracker','Request Tracker Request Tracker request tracker template','request-tracker-template',1147642410,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Request Tracker Request Tracker request tracker template Collaboration','000001000001000008000026'),('wAc4azJViVTpo-2NYOXWvg','Default Question Edit','Default Question Edit Default Question Edit root import survey default question edit','root/import/survey/default-question-edit',1226009650,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Question Edit Default Question Edit root import survey default question edit Survey/Edit','000001000001000044000008'),('1z9J1O08n_7gVVlBwSRBJQ','Auth','Auth Auth root import auth','root/import/auth',1222803099,1222803099,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth Auth root import auth','000001000001000005'),('zyWi26q9na-iiZqL4yedog','Macro','Macro Macro root import macro','root/import/macro',1222803114,1222803114,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro Macro root import macro','000001000001000021'),('PBtmpl0000000000000209','Request Tracker Thread','Request Tracker Thread Request Tracker Thread request tracker post template','request-tracker-post-template',1147642410,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Request Tracker Thread Request Tracker Thread request tracker post template Collaboration/Thread','000001000001000008000027'),('PBtmpl0000000000000109','One Over Three','One Over Three One Over Three one over three','one_over_three',1124395696,1259128609,'3','7','12','WebGUI::Asset::Template',0,'One Over Three One Over Three one over three Layout','000001000001000019000004'),('PBtmpl0000000000000001','Admin Console','Admin Console Admin Console admin console2','admin_console2',1124395696,1247535846,'3','7','12','WebGUI::Asset::Template',0,'Admin Console Admin Console admin console2 AdminConsole','000001000001000003000001'),('LBuiKzg2mWwmOPS9AgV3bg','Get Translated','Let our team of professional translators bring your site to new customers by translating your content into additional languages. Our translation services are never machine automated. They\'re always done by professional translators that have years of exper','yns/translated',1147642517,1147642517,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Translated Get Translated yns translated Let our team of professional translators bring your site to new customers by translating your content into additional languages Our translation services are never machine automated They\'re always done by professional translators that have years of experience reading writing and speaking many languages  ','000001000002000002000007'),('jTNggl7AoVSUc_ZzrvuCmw','Get Promoted','Now that you have a brilliant WebGUI site, you need to get people to visit it. We can help there too. Our marketing specialists can work with you to develop and execute the right combination of search engine placement, advertising buys, and affilliate pro','yns/promotion',1147642517,1147642517,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Promoted Get Promoted yns promotion Now that you have a brilliant WebGUI site you need to get people to visit it We can help there too Our marketing specialists can work with you to develop and execute the right combination of search engine placement advertising buys and affilliate programs to ensure your site gets the traffic it needs  ','000001000002000002000008'),('Wl8WZ43g2rK5AYr9o4zY7w','Get Style','Not a designer? No problem! Plain Black\'s professional design team can make your site look great. Our team is fast, easy to work with, and can even migrate your existing content into your new WebGUI site. ','yns/style',1147642516,1247779880,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Style Get Style yns style Not a designer No problem Plain Black\'s professional design team can make your site look great Our team is fast easy to work with and can even migrate your existing content into your new WebGUI site  ','000001000002000002000006'),('ix1p0AbwKAz8QWB-T-HHfg','Get Support','Plain Black provides support packages to fit any budget or need. Start out with online support which costs only $500 per year! And grow support as your needs grow. We build custom support packages to match our client\'s needs. And no matter what level of s','yns/support',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Support Get Support yns support Plain Black provides support packages to fit any budget or need Start out with online support which costs only $500 per year And grow support as your needs grow We build custom support packages to match our client\'s needs And no matter what level of support you purchase you get WebGUI Documentation included in your purchase  ','000001000002000002000003'),('iCYOjohB9SKvAPr6bXElKA','Get Hosting','Who better to host your WebGUI sites than Plain Black. Let us deal with upgrades, security, and server management. Doing so lets you focus on building your WebGUI site, which is where your time and expertise should be spent. And when you sign up with host','yns/hosting',1147642516,1247779898,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Hosting Get Hosting yns hosting Who better to host your WebGUI sites than Plain Black Let us deal with upgrades security and server management Doing so lets you focus on building your WebGUI site which is where your time and expertise should be spent And when you sign up with hosting online support is included  ','000001000002000002000004'),('4Yfz9hqBqM8OYMGuQK8oLw','Get Features','What\'s that you say? WebGUI\'s thousands of features are still missing some important ones? No problem, our professional development team can add any features you need for your site. We\'ve built hundreds of custom apps for people. From simple macros, to cu','yns/features',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Features Get Features yns features What\'s that you say WebGUI\'s thousands of features are still missing some important ones No problem our professional development team can add any features you need for your site We\'ve built hundreds of custom apps for people From simple macros to custom single sign on systems to applications that will manage your entire company our team can do it  ','000001000002000002000005'),('Vzv1pWpg_w6R_o-b0rM2qQ','Ad','Ad Ad home ad2','home/ad2',1147642515,1147642515,'3','7','4','WebGUI::Asset::File',1,'Ad Ad home ad2','000001000002000001000002'),('FOvmwGC0GtZo5VTxJIL3OA','Get Documentation','WebGUI Documentation is the ultimate compendium to WebGUI. This is a must for anyone working in WebGUI, and Plain Black offers vast bulk discounts so you can give it to everyone in your organization. ','yns/docs',1147642515,1247779862,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Documentation Get Documentation yns docs WebGUI Documentation is the ultimate compendium to WebGUI This is a must for anyone working in WebGUI and Plain Black offers vast bulk discounts so you can give it to everyone in your organization  ','000001000002000002000002'),('6QuS-0rosuZTdTv11fobig','Talk to the Experts','Plain Black&reg; created the WebGUI Content Engine&reg; and is here to answer your questions and provide you with services to make sure your WebGUI implementation is entirely successful. We bend over backwards to make sure you\'re a success. Contact us tod','yns/experts',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Talk to the Experts Talk to the Experts yns experts Plain Black® created the WebGUI Content Engine® and is here to answer your questions and provide you with services to make sure your WebGUI implementation is entirely successful We bend over backwards to make sure you\'re a success Contact us today to see how we can help you  ','000001000002000002000001'),('NK8bqlwVRILJknqeCDPBHg','Getting Started (part 2)','\n\nNow you should log in and go into admin mode. The default username is \"admin\" and the default password is \"123qwe\", but you probably customized both of those when you visited this site for the very first time.\n \n\nNow that you\'re logged in, we recommend ','getting_started/getting-started-part2',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting Started part 2 Getting Started part 2 getting started getting started part2 Now you should log in and go into admin mode The default username is admin and the default password is 123qwe but you probably customized both of those when you visited this site for the very first time Now that you\'re logged in we recommend that you add a new user for yourself with admin privileges just in case you forget the login information for your primary admin account Don\'t worry if you lock yourself out you can always contact Plain Black® support to get instructions to get back in NOTE If you appear to be get logged out while moving between pages this is most likely your browser displaying a cached version of the page Click on your browser\'s refresh button to correct the problem No doubt after you enabled admin mode you saw a menu along the left side of the screen that\'s called the Admin Bar Use that to add content and access administrative functions You\'re now ready to begin exploring your new WebGUI site For more information about services related to WebGUI click here Enjoy your new WebGUI site  ','000001000002000001000003'),('m4YJFaqzultnB_sj1Uq0aw','Ad','Ad Ad home ad','home/ad',1147642514,1147642514,'3','7','4','WebGUI::Asset::File',1,'Ad Ad home ad','000001000002000008'),('IWFxZDyGhQ3-SLZhELa3qw','Key Benefits','\n\nEasy To Use - WebGUI is absolutely easy to use. WebGUI 7 has a completely revamped user interface to make it even easier to use. There are lots of visual cues, consistent icons, helper apps, and a huge repository of built-in help files.\n \n\nWorkflow &amp','home/key-benefits',1147642514,1147642514,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Key Benefits Key Benefits home key benefits Easy To Use  WebGUI is absolutely easy to use WebGUI 7 has a completely revamped user interface to make it even easier to use There are lots of visual cues consistent icons helper apps and a huge repository of built-in help files Workflow  Versioning  Never again worry about content getting put on your site that you don\'t want there Never again lose your old content after making an edit And never again push out new changes until you\'re absolutely ready to release them WebGUI\'s workflow and versioning system is fast flexible powerful and easy to use Everything\'s a Template  Worry nevermore about your CMS forcing you into a mould that doesn\'t suit you With WebGUI everything a site visitor can see is a customizable template so you can make it look exactly how you want Moreover if you\'re the type that strives for excellence rest in the knowledge that all the templates that come with WebGUI are XHTML 1.0 strict compliant Localization  WebGUI\'s entire user interface is set up to be internationalized Visit one of the WebGUI Worldwide member sites to get translations for your language Stay there to get support and services in your native language Feel confident in the knowledge that WebGUI will work with your native characters because it\'s UTF-8 compliant On top of that WebGUI allows you to customize dates currency and weights to match your locale Pluggable By Design  With WebGUI 7 you have many plug-in points to add your own functionality And best of all the API is stable and standardized Write it today and it will still work years from now and survive all upgrades  ','000001000002000009'),('bX5rYxb6tZ9docY6sUhBlw','Getting Started','\n\nIf you\'re reading this message that means you\'ve successfully installed and configured the WebGUI Content Engine&reg;. Great job! To get started with managing content, watch the short instructional video below.\n \nNOTE: Click on the green start icon on t','getting_started/getting-started',1147642514,1147642514,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting Started Getting Started getting started getting started If you\'re reading this message that means you\'ve successfully installed and configured the WebGUI Content Engine® Great job To get started with managing content watch the short instructional video below NOTE Click on the green start icon on the video to begin your tutorial  ','000001000002000001000001'),('Szs5eev3OMssmnsyLRZmWA','Tell A Friend','Tell a friend about WebGUI.','tell_a_friend/tell_a_friend',1124395696,1213317790,'3','7','3','WebGUI::Asset::Wobject::DataForm',1,'Tell A Friend Tell A Friend tell a friend tell a friend Tell a friend about WebGUI','000001000002000004000001'),('OhdaFLE7sXOzo_SIP2ZUgA','Welcome','The WebGUI Content Engine&reg; is a powerful and easy to use system for managing web sites, and building web applications. It provides thousands of features out of the box, and lots of plug-in points so you can extend it to match your needs. It\'s easy eno','home/welcome',1147642513,1147642513,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Welcome Welcome home welcome The WebGUI Content Engine® is a powerful and easy to use system for managing web sites and building web applications It provides thousands of features out of the box and lots of plug-in points so you can extend it to match your needs It\'s easy enough for the average business user but powerful enough for any large enterprise There are thousands of small and large businesses schools universities governments associations clubs churches projects and communities using WebGUI all over the world today A brief list of some of them can be found here Your site should be on that list If you\'re new to WebGUI click here to learn how to get started If you\'re getting up to speed check out some ways you can do more faster If this is all old hat to you then check out the latest news No matter what level you\'re at tell your friends about WebGUI  ','000001000002000007'),('7-0-style0000000000071','wg.jpg','wg.jpg wg.jpg style3 wg.jpg','style3/wg.jpg',1147642511,1147642511,'3','7','12','WebGUI::Asset::File::Image',1,'wg.jpg wg.jpg style3 wg.jpg','000001000001000054000022'),('7-0-style0000000000068','spacer.gif','spacer.gif spacer.gif style3 spacer.gif','style3/spacer.gif',1147642510,1147642510,'3','7','12','WebGUI::Asset::File::Image',1,'spacer.gif spacer.gif style3 spacer.gif','000001000001000054000019'),('7-0-style0000000000070','Style3 Coolmenu','Style3 Coolmenu Style3 Coolmenu style3 coolmenu','style3_coolmenu',1147642510,1147642510,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3 Coolmenu Style3 Coolmenu style3 coolmenu','000001000001000054000021'),('7-0-style0000000000066','nav_bg_on.jpg','nav_bg_on.jpg nav_bg_on.jpg style3 nav bg on.jpg','style3/nav_bg_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg_on.jpg nav_bg_on.jpg style3 nav bg on.jpg','000001000001000054000017'),('7-0-style0000000000064','nav_bg2.jpg','nav_bg2.jpg nav_bg2.jpg style3 nav bg2.jpg','style3/nav_bg2.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2.jpg nav_bg2.jpg style3 nav bg2.jpg','000001000001000054000015'),('7-0-style0000000000065','nav_bg2_on.jpg','nav_bg2_on.jpg nav_bg2_on.jpg style3 nav bg2 on.jpg','style3/nav_bg2_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2_on.jpg nav_bg2_on.jpg style3 nav bg2 on.jpg','000001000001000054000016'),('7-0-style0000000000067','pb.jpg','pb.jpg pb.jpg style3 pb.jpg','style3/pb.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'pb.jpg pb.jpg style3 pb.jpg','000001000001000054000018'),('7-0-style0000000000063','nav_bg1_on.jpg','nav_bg1_on.jpg nav_bg1_on.jpg style3 nav bg1 on.jpg','style3/nav_bg1_on.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1_on.jpg nav_bg1_on.jpg style3 nav bg1 on.jpg','000001000001000054000014'),('7-0-style0000000000060','main_top_bg.jpg','main_top_bg.jpg main_top_bg.jpg style3 main top bg.jpg','style3/main_top_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'main_top_bg.jpg main_top_bg.jpg style3 main top bg.jpg','000001000001000054000011'),('7-0-style0000000000062','nav_bg1.jpg','nav_bg1.jpg nav_bg1.jpg style3 nav bg1.jpg','style3/nav_bg1.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1.jpg nav_bg1.jpg style3 nav bg1.jpg','000001000001000054000013'),('7-0-style0000000000061','nav_bg.jpg','nav_bg.jpg nav_bg.jpg style3 nav bg.jpg','style3/nav_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg.jpg nav_bg.jpg style3 nav bg.jpg','000001000001000054000012'),('7-0-style0000000000059','main_top.jpg','main_top.jpg main_top.jpg style3 main top.jpg','style3/main_top.jpg',1147642507,1213386091,'3','7','12','WebGUI::Asset::File::Image',1,'main_top.jpg main_top.jpg style3 main top.jpg','000001000001000054000010'),('7-0-style0000000000057','main_bg.jpg','main_bg.jpg main_bg.jpg style3 main bg.jpg','style3/main_bg.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.jpg main_bg.jpg style3 main bg.jpg','000001000001000054000008'),('7-0-style0000000000058','main_bottom.jpg','main_bottom.jpg main_bottom.jpg style3 main bottom.jpg','style3/main_bottom.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bottom.jpg main_bottom.jpg style3 main bottom.jpg','000001000001000054000009'),('7-0-style0000000000055','header_left.jpg','header_left.jpg header_left.jpg style3 header left.jpg','style3/header_left.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_left.jpg header_left.jpg style3 header left.jpg','000001000001000054000006'),('7-0-style0000000000056','header_right.jpg','header_right.jpg header_right.jpg style3 header right.jpg','style3/header_right.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_right.jpg header_right.jpg style3 header right.jpg','000001000001000054000007'),('7-0-style0000000000054','header_bg.jpg','header_bg.jpg header_bg.jpg style3 header bg.jpg','style3/header_bg.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_bg.jpg header_bg.jpg style3 header bg.jpg','000001000001000054000005'),('7-0-style0000000000052','footer_bg.jpg','footer_bg.jpg footer_bg.jpg style3 footer bg.jpg','style3/footer_bg.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_bg.jpg footer_bg.jpg style3 footer bg.jpg','000001000001000054000003'),('7-0-style0000000000053','footer_right.jpg','footer_right.jpg footer_right.jpg style3 footer right.jpg','style3/footer_right.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_right.jpg footer_right.jpg style3 footer right.jpg','000001000001000054000004'),('7-0-style0000000000046','rightCol_bg.jpg','rightCol_bg.jpg rightCol_bg.jpg style2 rightcol bg.jpg','style2/rightcol_bg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'rightCol_bg.jpg rightCol_bg.jpg style2 rightcol bg.jpg','000001000001000053000015'),('stevestyle000000000002','Style 02','Style 02 Style 02 style 02','style_02',1147642504,1222383245,'3','7','12','WebGUI::Asset::Template',0,'Style 02 Style 02 style 02 style','000001000001000053000016'),('7-0-style0000000000049','WebGUI 7 Style 3','WebGUI 7 Style 3 WebGUI 7 Style 3 root import webgui 7 style 3','root/import/webgui-7-style-3',1147642504,1224117144,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI 7 Style 3 WebGUI 7 Style 3 root import webgui 7 style 3','000001000001000054'),('7-0-style0000000000048','wg.jpg','wg.jpg wg.jpg style2 wg.jpg','style2/wg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'wg.jpg wg.jpg style2 wg.jpg','000001000001000053000017'),('7-0-style0000000000045','pb_wg_bg.jpg','pb_wg_bg.jpg pb_wg_bg.jpg style2 pb wg bg.jpg','style2/pb_wg_bg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg_bg.jpg pb_wg_bg.jpg style2 pb wg bg.jpg','000001000001000053000014'),('7-0-style0000000000044','pb_wg.jpg','pb_wg.jpg pb_wg.jpg style2 pb wg.jpg','style2/pb_wg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg.jpg pb_wg.jpg style2 pb wg.jpg','000001000001000053000013'),('7-0-style0000000000043','pb.jpg','pb.jpg pb.jpg style2 pb.jpg','style2/pb.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb.jpg pb.jpg style2 pb.jpg','000001000001000053000012'),('7-0-style0000000000042','page_title_bg.jpg','page_title_bg.jpg page_title_bg.jpg style2 page title bg.jpg','style2/page_title_bg.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title_bg.jpg page_title_bg.jpg style2 page title bg.jpg','000001000001000053000011'),('7-0-style0000000000041','page_title.jpg','page_title.jpg page_title.jpg style2 page title.jpg','style2/page_title.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title.jpg page_title.jpg style2 page title.jpg','000001000001000053000010'),('7-0-style0000000000040','navbar_right.jpg','navbar_right.jpg navbar_right.jpg style2 navbar right.jpg','style2/navbar_right.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_right.jpg navbar_right.jpg style2 navbar right.jpg','000001000001000053000009'),('7-0-style0000000000039','navbar_left.jpg','navbar_left.jpg navbar_left.jpg style2 navbar left.jpg','style2/navbar_left.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_left.jpg navbar_left.jpg style2 navbar left.jpg','000001000001000053000008'),('7-0-style0000000000036','main_bg.jpg','main_bg.jpg main_bg.jpg style2 main bg.jpg','style2/main_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.jpg main_bg.jpg style2 main bg.jpg','000001000001000053000005'),('7-0-style0000000000038','navbar_bg.jpg','navbar_bg.jpg navbar_bg.jpg style2 navbar bg.jpg','style2/navbar_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_bg.jpg navbar_bg.jpg style2 navbar bg.jpg','000001000001000053000007'),('7-0-style0000000000035','leftCol_header02.jpg','leftCol_header02.jpg leftCol_header02.jpg style2 leftcol header02.jpg','style2/leftcol_header02.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header02.jpg leftCol_header02.jpg style2 leftcol header02.jpg','000001000001000053000004'),('7-0-style0000000000037','nav_bg.jpg','nav_bg.jpg nav_bg.jpg style2 nav bg.jpg','style2/nav_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg.jpg nav_bg.jpg style2 nav bg.jpg','000001000001000053000006'),('7-0-style0000000000032','context_bg.jpg','context_bg.jpg context_bg.jpg style2 context bg.jpg','style2/context_bg.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'context_bg.jpg context_bg.jpg style2 context bg.jpg','000001000001000053000001'),('7-0-style0000000000031','WebGUI 7 Style 2','WebGUI 7 Style 2 WebGUI 7 Style 2 root import webgui 7 style 2','root/import/webgui-7-style-2',1147642500,1147642500,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI 7 Style 2 WebGUI 7 Style 2 root import webgui 7 style 2','000001000001000053'),('7-0-style0000000000033','css02.css','css02.css css02.css style2 css02.css','style2/css02.css',1147642500,1147642500,'3','7','12','WebGUI::Asset::Snippet',0,'css02.css css02.css style2 css02.css body html  height:100  body  background:#7c9ab0 url(\'^FileUrl(style2/main_bg.jpg repeat-y right margin:0px  rightColumn  width:20 height:100 background eeeeee url(\'^FileUrl(style2/rightCol_bg.jpg repeat-y right text-align:center  rightColumn pb_wg_bg  background url(\'^FileUrl(style2/pb_wg_bg.jpg repeat-x width:100 text-align:left  rightColumn pb_wg  background url(\'^FileUrl(style2/pb_wg.jpg left no-repeat height:53px  leftColumn  width:80 background white url(\'^FileUrl(style2/context_bg.jpg repeat-y right  leftColumn header  width:100 background:#7c9ab0 url(\'^FileUrl(style2/leftCol_header.jpg right no-repeat height:86px position:relative  leftColumn header title leftColumn header title_bg  color:white font-size:36pt font-weight:bold font-family:arial font-variant:small-caps letter-spacing:12px top:15px left:5px position:absolute z-index:10  leftColumn header title a  color:white text-decoration:none  leftColumn header title_bg  color:black z-index:5 top:17px left:7px  leftColumn context  background fff url(\'^FileUrl(style2/context_bg.jpg repeat-y right  width:95 font-family:verdana font-size:9pt color:#242424 moz-box-sizing:border-box position:relative padding-left:1 padding-right:1 padding-bottom:15px  leftColumn context a  color:#7C9AB0 font-weight:bold  leftColumn context a:hover  text-decoration:none  leftColumn pageTitleBG  background url(\'^FileUrl(style2/page_title_bg.jpg repeat-x width:100  leftColumn pageTitleBG pageTitle  background url(\'^FileUrl(style2/page_title.jpg right no-repeat width:100 height:50px  leftColumn pageTitleBG pageTitle h2  font-size:14pt color:#696969 font-family:arial font-weight:normal margin:0px padding-top:2px padding-left:25px letter-spacing:3px  rightColumn nav  width:85 background b5b5b5 url(\'^FileUrl(style2/nav_bg.jpg repeat-x top border-right:solid 848484 1px margin-left:auto margin-right:auto text-align:left padding-left:3px padding-top:7px padding-bottom:7px  rightColumn nav a  color:white font-size:8pt font-weight:bold text-decoration:none font-family:arial line-height:8pt  rightColumn nav selectedMenuItem  color:yellow  loginStyles  font-size:8pt font-family:arial padding-bottom:25px  loginStyles a  color:#89ACCF font-weight:bold border-bottom:solid transparent 2px text-decoration:none  loginStyles a:hover  border-bottom:dotted B2C9D9 2px  copyright  border-top:solid silver 3px background-color:gray font-family:arial font-size:9pt color:silver text-align:center ','000001000001000053000002'),('7-0-style0000000000034','leftCol_header.jpg','leftCol_header.jpg leftCol_header.jpg style2 leftcol header.jpg','style2/leftcol_header.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header.jpg leftCol_header.jpg style2 leftcol header.jpg','000001000001000053000003'),('stevenav00000000000001','Style 01 Nav','Style 01 Nav Style 01 Nav style1 nav','style1_nav',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',0,'Style 01 Nav Style 01 Nav style1 nav Navigation','000001000001000052000027'),('PBnav000000style01lvl2','Style 01 Nav lvl2','Style 01 Nav lvl2 untitled style1 nav lvl2','style1_nav_lvl2',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',0,'Style 01 Nav lvl2 untitled style1 nav lvl2 Navigation','000001000001000052000028'),('7-0-style0000000000030','webgui_btn.jpg','webgui_btn.jpg webgui_btn.jpg style1 webgui btn.jpg','style1/webgui_btn.jpg',1147642499,1147642499,'3','7','12','WebGUI::Asset::File::Image',1,'webgui_btn.jpg webgui_btn.jpg style1 webgui btn.jpg','000001000001000052000029'),('stevestyle000000000001','Style 01','Style 01 Style 01 style 01','style_01',1147642499,1222383245,'3','7','12','WebGUI::Asset::Template',0,'Style 01 Style 01 style 01 style','000001000001000052000026'),('7-0-style0000000000026','RootTab Level 1','RootTab Level 1 RootTab Level 1 roottab level1','roottab_level1',1147642499,1147642499,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab Level 1 RootTab Level 1 roottab level1','000001000001000052000025'),('7-0-style0000000000024','orange_left01.jpg','orange_left01.jpg orange_left01.jpg style1 orange left01.jpg','style1/orange_left01.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'orange_left01.jpg orange_left01.jpg style1 orange left01.jpg','000001000001000052000023'),('7-0-style0000000000023','nav_on.jpg','nav_on.jpg nav_on.jpg style1 nav on.jpg','style1/nav_on.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'nav_on.jpg nav_on.jpg style1 nav on.jpg','000001000001000052000022'),('7-0-style0000000000025','RootTab Level 0','RootTab Level 0 RootTab Level 0 roottab level0','roottab_level0',1147642498,1147642498,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab Level 0 RootTab Level 0 roottab level0','000001000001000052000024'),('7-0-style0000000000019','nav2_off_right.jpg','nav2_off_right.jpg nav2_off_right.jpg style1 nav2 off right.jpg','style1/nav2_off_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_right.jpg nav2_off_right.jpg style1 nav2 off right.jpg','000001000001000052000018'),('7-0-style0000000000020','nav2_on_left.jpg','nav2_on_left.jpg nav2_on_left.jpg style1 nav2 on left.jpg','style1/nav2_on_left.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_left.jpg nav2_on_left.jpg style1 nav2 on left.jpg','000001000001000052000019'),('7-0-style0000000000022','nav_bg.jpg','nav_bg.jpg nav_bg.jpg style1 nav bg.jpg','style1/nav_bg.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg.jpg nav_bg.jpg style1 nav bg.jpg','000001000001000052000021'),('7-0-style0000000000021','nav2_on_right.jpg','nav2_on_right.jpg nav2_on_right.jpg style1 nav2 on right.jpg','style1/nav2_on_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_right.jpg nav2_on_right.jpg style1 nav2 on right.jpg','000001000001000052000020'),('7-0-style0000000000017','nav2_off_center.jpg','nav2_off_center.jpg nav2_off_center.jpg style1 nav2 off center.jpg','style1/nav2_off_center.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_center.jpg nav2_off_center.jpg style1 nav2 off center.jpg','000001000001000052000016'),('7-0-style0000000000016','nav2_center_on.jpg','nav2_center_on.jpg nav2_center_on.jpg style1 nav2 center on.jpg','style1/nav2_center_on.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_center_on.jpg nav2_center_on.jpg style1 nav2 center on.jpg','000001000001000052000015'),('7-0-style0000000000018','nav2_off_left.jpg','nav2_off_left.jpg nav2_off_left.jpg style1 nav2 off left.jpg','style1/nav2_off_left.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_left.jpg nav2_off_left.jpg style1 nav2 off left.jpg','000001000001000052000017'),('7-0-style0000000000015','nav1_on_right.jpg','nav1_on_right.jpg nav1_on_right.jpg style1 nav1 on right.jpg','style1/nav1_on_right.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_right.jpg nav1_on_right.jpg style1 nav1 on right.jpg','000001000001000052000014'),('7-0-style0000000000014','nav1_on_left.jpg','nav1_on_left.jpg nav1_on_left.jpg style1 nav1 on left.jpg','style1/nav1_on_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_left.jpg nav1_on_left.jpg style1 nav1 on left.jpg','000001000001000052000013'),('7-0-style0000000000013','nav1_on.jpg','nav1_on.jpg nav1_on.jpg style1 nav1 on.jpg','style1/nav1_on.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on.jpg nav1_on.jpg style1 nav1 on.jpg','000001000001000052000012'),('7-0-style0000000000011','nav1_off_left.jpg','nav1_off_left.jpg nav1_off_left.jpg style1 nav1 off left.jpg','style1/nav1_off_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_left.jpg nav1_off_left.jpg style1 nav1 off left.jpg','000001000001000052000010'),('7-0-style0000000000012','nav1_off_right.jpg','nav1_off_right.jpg nav1_off_right.jpg style1 nav1 off right.jpg','style1/nav1_off_right.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_right.jpg nav1_off_right.jpg style1 nav1 off right.jpg','000001000001000052000011'),('7-0-style0000000000009','nav1_off.jpg','nav1_off.jpg nav1_off.jpg style1 nav1 off.jpg','style1/nav1_off.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off.jpg nav1_off.jpg style1 nav1 off.jpg','000001000001000052000008'),('7-0-style0000000000010','nav1_off_center.jpg','nav1_off_center.jpg nav1_off_center.jpg style1 nav1 off center.jpg','style1/nav1_off_center.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_center.jpg nav1_off_center.jpg style1 nav1 off center.jpg','000001000001000052000009'),('7-0-style0000000000008','nav1_center_on.jpg','nav1_center_on.jpg nav1_center_on.jpg style1 nav1 center on.jpg','style1/nav1_center_on.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_center_on.jpg nav1_center_on.jpg style1 nav1 center on.jpg','000001000001000052000007'),('7-0-style0000000000006','main_bg.gif','main_bg.gif main_bg.gif style1 main bg.gif','style1/main_bg.gif',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.gif main_bg.gif style1 main bg.gif','000001000001000052000005'),('7-0-style0000000000007','main_bg.jpg','main_bg.jpg main_bg.jpg style1 main bg.jpg','style1/main_bg.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.jpg main_bg.jpg style1 main bg.jpg','000001000001000052000006'),('7-0-style0000000000004','gui_bottom.jpg','gui_bottom.jpg gui_bottom.jpg style1 gui bottom.jpg','style1/gui_bottom.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'gui_bottom.jpg gui_bottom.jpg style1 gui bottom.jpg','000001000001000052000003'),('7-0-style0000000000005','header.jpg','header.jpg header.jpg style1 header.jpg','style1/header.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'header.jpg header.jpg style1 header.jpg','000001000001000052000004'),('7-0-style0000000000001','WebGUI 7 Style 1','WebGUI 7 Style 1 WebGUI 7 Style 1 root import webgui 7 style 1','root/import/webgui-7-style-1',1147642492,1147642492,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI 7 Style 1 WebGUI 7 Style 1 root import webgui 7 style 1','000001000001000052'),('7-0-style0000000000002','body_bg.jpg','body_bg.jpg body_bg.jpg style1 body bg.jpg','style1/body_bg.jpg',1147642492,1147642492,'3','7','12','WebGUI::Asset::File::Image',1,'body_bg.jpg body_bg.jpg style1 body bg.jpg','000001000001000052000001'),('7-0-style0000000000003','css01.css','css01.css css01.css style1 css01.css','style1/css01.css',1147642492,1147642492,'3','7','12','WebGUI::Asset::Snippet',0,'css01.css css01.css style1 css01.css body html  text-align:center margin:0px height:100 background-color:#494949  main  width:800px background url(\'^FileUrl(style1/main_bg.jpg repeat-y height:100 margin-left:auto margin-right:auto margin-top:0px margin-bottom:0px position:relative  body > main  height:auto min-height:100  main mainHeader  width:800px height:133px background url(\'^FileUrl(style1/header.jpg top left no-repeat margin-bottom:0px position:relative  main mainHeader title  position:absolute top:23px left:145px font-size:32pt font-family:arial color:white font-weight:bold  main mainHeader title a  color:white text-decoration:none  main mainContent  background url(\'^FileUrl(style1/orange_left01.jpg left top no-repeat width:100 height:100 margin-top:0px text-align:left border:solid red 0px  main > mainContent  margin-top:0px min-height:500px  main > mainContent > p  margin-top:0px  main mainContent mainText a:link  color:#FF7F23  main mainContent mainText a:visited  color:#D25900   LEVEL 1 AND 2 NAVIGATION  main mainNav_1 main mainNav_2  border-bottom:dashed DADADA 1px width:621px height:25px text-align:left position:relative margin-left:137px clear:both  main mainNav_1 a:link main mainNav_1 a:visited main mainNav_2 a:link main mainNav_2 a:visited  color:white text-decoration:none top:5px position:relative moz-box-sizing:border-box  main mainNav_1 a:hover,#main mainNav_2 a:hover  color:black  main mainNav_1 div left main mainNav_2 div left  width:12px height:25px display:block float:left background url(\'^FileUrl(style1/nav1_off_left.jpg no-repeat top left  main mainNav_2 div left  background url(\'^FileUrl(style1/nav2_off_left.jpg no-repeat top left  main mainNav_1 div center main mainNav_2 div center  height:25px display:block float:left background url(\'^FileUrl(style1/nav1_off_center.jpg repeat-x top left color:white font-family:arial verdana font-size:8pt  main mainNav_2 div center  background url(\'^FileUrl(style1/nav2_off_center.jpg repeat-x top left  main mainNav_1 div right main mainNav_2 div right  width:10px height:25px display:block float:left background url(\'^FileUrl(style1/nav1_off_right.jpg no-repeat top left  main mainNav_2 div right  background url(\'^FileUrl(style1/nav2_off_right.jpg no-repeat top left  main mainNav_1 div.navOn left  background url(\'^FileUrl(style1/nav1_on_left.jpg no-repeat top left  main mainNav_1 div.navOn center  background url(\'^FileUrl(style1/nav1_center_on.jpg repeat-x top left  main mainNav_1 div.navOn right  background url(\'^FileUrl(style1/nav1_on_right.jpg no-repeat top left  main mainNav_2 div.navOn left  background url(\'^FileUrl(style1/nav2_on_left.jpg no-repeat top left  main mainNav_2 div.navOn center  background url(\'^FileUrl(style1/nav2_center_on.jpg repeat-x top left  main mainNav_2 div.navOn right  background url(\'^FileUrl(style1/nav2_on_right.jpg no-repeat top left  main mainNav_1 div.navOn a:link main mainNav_1 div.navOn a:visited main mainNav_2 div.navOn a:link main mainNav_2 div.navOn a:visited  color:black   ENDOF LEVEL 1 AND 2 NAVIGATION  main crumbTrail  margin-left:177px margin-bottom:0px color:gray font-size:8pt font-weight:bold  main crumbTrail a.crumbTrail:visited main crumbTrail a.crumbTrail:link  color:silver font-size:8pt font-family:arial text-decoration:none font-weight:normal  main crumbTrail a.crumbTrail:hover  color:gray  main mainText  padding-left:150px font-family:verdana font-size:9pt width:600px margin-top:0px  main gui  bottom:0px left:0px position:absolute width:135px font-size:8pt color:black font-family:arial text-align:right  main gui loginBox  padding-right:12px moz-box-sizing:border-box width:100px float:right margin-bottom:10px  main gui loginBox loginBoxField  width:75px  main gui loginBox loginBoxButton  background-color:#D65501 color:white border:solid white 2px margin-top:4px font-variant:small-caps  main gui a  color:white  copyright  color:#fff position:absolute top:110px right:40px font-family:verdana font-size:8pt font-weight:bold background-color:#2D2D2D opacity:0.4 moz-opacity:0.4 khtml-opacity:0.4 padding:2px   html copyright  background transparent ','000001000001000052000002'),('7F-BuEHi7t9bPi008H8xZQ','Default Survey Summary','Default Survey Summary Default Survey Summary root import survey default survey summary','root/import/survey/default-survey-summary',1239248021,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Summary Default Survey Summary root import survey default survey summary Survey/Summary','000001000001000044000012'),('CSN-ZON7Uwv8kxf3F1fh5Q','ZipArchiveAsset','ZipArchiveAsset ZipArchiveAsset root import ziparchiveasset','root/import/ziparchiveasset',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ZipArchiveAsset ZipArchiveAsset root import ziparchiveasset','000001000001000056'),('TCtybxdqmdwdvRn555zpCQ','RichEdit','RichEdit RichEdit root import richedit','root/import/richedit',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RichEdit RichEdit root import richedit','000001000001000034'),('NywJYmGWe1f6EBXJnWg9Xg','Profile','Profile Profile root import profile','root/import/profile',1222803606,1222803638,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Profile Profile root import profile','000001000001000030'),('9wKWdum0_8z-OhhquWLtSQ','WeatherData','WeatherData WeatherData root import weatherdata','root/import/weatherdata',1147642483,1147642483,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WeatherData WeatherData root import weatherdata','000001000001000050'),('AgyFhx3eXlfZXNp2MkrsiQ','Edit','Edit Edit root import profile edit','root/import/profile/edit',1147642477,1222803665,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Edit Edit root import profile edit','000001000001000030000001'),('F7MAQ-cpuvQ1KuC7J4P5zQ','View','View View root import profile view','root/import/profile/view',1147642477,1222803673,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'View View root import profile view','000001000001000030000002'),('oGfxez5sksyB_PcaAsEm_Q','SyndicatedContent','SyndicatedContent SyndicatedContent root import syndicatedcontent','root/import/syndicatedcontent',1147642482,1247053097,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SyndicatedContent SyndicatedContent root import syndicatedcontent','000001000001000045'),('5bnNzteN7w3NnK9mF4XiCg','Survey','Survey Survey root import survey','root/import/survey',1147642481,1250243000,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Survey Survey root import survey','000001000001000044'),('Efe2W0UgrSRDltNJ87jlfg','StockData','StockData StockData root import stockdata','root/import/stockdata',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'StockData StockData root import stockdata','000001000001000041'),('bbiA9Zq5Gy2oCFBlILO3QA','SQLReport','SQLReport SQLReport root import sqlreport','root/import/sqlreport',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SQLReport SQLReport root import sqlreport','000001000001000040'),('RrV4aAPnn4dM0ZcU3OXnlw','style','style style root import style','root/import/style',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'style style root import style','000001000001000043'),('Ik9HHky10DIyFTKehUD1dw','Prompt','Prompt Prompt root import prompt','root/import/prompt',1147642479,1222803478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Prompt Prompt root import prompt','000001000001000032'),('f_tn9FfoSfKWX43F83v_3w','Search','Search Search root import search','root/import/search',1147642479,1247053009,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Search Search root import search','000001000001000036'),('Da6KWn805L4B5e4HFgQRQA','Shortcut','Shortcut Shortcut root import shortcut','root/import/shortcut',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shortcut Shortcut root import shortcut','000001000001000039'),('TYo2Bwl7aafzTtdHlS-arQ','Product','Product Product root import product','root/import/product',1147642478,1211664878,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Product Product root import product','000001000001000028'),('VZK3CRgiMb8r4dBjUmCTgQ','Poll','Poll Poll root import poll','root/import/poll',1147642477,1247046242,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Poll Poll root import poll','000001000001000027'),('jEz8iTGNWEt2I05IhVV19Q','Operation/RedeemSubscription','Operation/RedeemSubscription Operation/RedeemSubscription root import operation redeemsubscription','root/import/operation/redeemsubscription',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Operation/RedeemSubscription Operation/RedeemSubscription root import operation redeemsubscription','000001000001000038000016'),('BFfNj5wA9bDw8H3cnr8pTw','Navigation','Navigation Navigation root import navigation','root/import/navigation',1147642475,1247046273,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Navigation Navigation root import navigation','000001000001000025'),('bBzO4CWjqU_ile3gf5Iypw','MultiSearch','MultiSearch MultiSearch root import multisearch','root/import/multisearch',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MultiSearch MultiSearch root import multisearch','000001000001000024'),('cj2y4papTVGZRFdwTI-_fw','MessageBoard','MessageBoard MessageBoard root import messageboard','root/import/messageboard',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MessageBoard MessageBoard root import messageboard','000001000001000023'),('3womoo7Teyy2YKFa25-MZg','Address Book (Default)','Address Book Default Address Book Default shopping cart collateral items address book default','shopping-cart-collateral-items/address-book-default',1212098997,1226703362,'3','7','3','WebGUI::Asset::Template',0,'Address Book Default Address Book Default shopping cart collateral items address book default Shop/AddressBook','000001000001000038000013'),('g8W53Pd71uHB9pxaXhWf_A','My Purchases Detail (Default)','My Purchases Detail Default My Purchases Detail Default shopping cart collateral items my purchases detail default','shopping-cart-collateral-items/my-purchases-detail-default',1213184121,1256702481,'3','7','3','WebGUI::Asset::Template',0,'My Purchases Detail Default My Purchases Detail Default shopping cart collateral items my purchases detail default Shop/MyPurchasesDetail','000001000001000038000015'),('-WM2dt0ZGpDasuL2wWocxg','ProjectManager','ProjectManager ProjectManager root import projectmanager','root/import/projectmanager',1222803056,1222803056,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager ProjectManager root import projectmanager','000001000001000031'),('LdiozcIUciWuvt3Z-na5Ww','Matrix','Matrix Matrix root import matrix','root/import/matrix',1147642474,1232673968,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Matrix Matrix root import matrix','000001000001000022'),('default_post_received1','Default Post Received','Default Post Received Default Post Received default post received','default_post_received',1222708029,1255485475,'3','7','4','WebGUI::Asset::Template',0,'Default Post Received Default Post Received default post received Collaboration/PostReceived','000001000001000008000029'),('aNNC62qLAS6TB-0_MCYjsw','Layout','Layout Layout root import layout','root/import/layout',1147642471,1246969327,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Layout Layout root import layout','000001000001000019'),('GYaFxnMu9UsEG8oanwB6TA','Folder','Folder Folder root import folder','root/import/folder',1147642470,1246965871,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Folder Folder root import folder','000001000001000014'),('N13SD1Fpqk00UgBt1Z8ivQ','HttpProxy','HttpProxy HttpProxy root import httpproxy','root/import/httpproxy',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'HttpProxy HttpProxy root import httpproxy','000001000001000016'),('tPagC0AQErZXjLFZQ6OI1g','ImageAsset','ImageAsset ImageAsset root import imageasset','root/import/imageasset',1147642470,1246966459,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ImageAsset ImageAsset root import imageasset','000001000001000017'),('3uuBf8cYuj1sew2OJXl9tg','InOutBoard','InOutBoard InOutBoard root import inoutboard','root/import/inoutboard',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'InOutBoard InOutBoard root import inoutboard','000001000001000018'),('PBtmpl0000000000000005','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template Default LDAP Anonymous Registration Template default ldap anonymous registration template','default_ldap_anonymous_registration_template',1124395696,1221612327,'3','7','12','WebGUI::Asset::Template',0,'Default LDAP Anonymous Registration Template Default LDAP Anonymous Registration Template default ldap anonymous registration template Auth/LDAP/Create','000001000001000005000002000001'),('PBtmpl0000000000000011','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template Default WebGUI Anonymous Registration Template default webgui anonymous registration template','default_webgui_anonymous_registration_template',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Anonymous Registration Template Default WebGUI Anonymous Registration Template default webgui anonymous registration template Auth/WebGUI/Create','000001000001000005000005000001'),('tXwf1zaOXTvsqPn6yu-GSw','FileAsset','FileAsset FileAsset root import fileasset','root/import/fileasset',1147642469,1246965607,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'FileAsset FileAsset root import fileasset','000001000001000013'),('S1A9iAwKcQQ6P20uTqw-Ew','Dashboard','Dashboard Dashboard root import dashboard','root/import/dashboard',1147642468,1147642468,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Dashboard Dashboard root import dashboard','000001000001000009'),('-K8Hj45mbelljN9-0CXZxg','DataForm','  ','root/import/dataform',1147642468,1256702482,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'DataForm DataForm root import dataform','000001000001000010'),('GNOAsX98vCsl0JRwfwL-gg','Collaboration','Collaboration Collaboration root import collaboration','root/import/collaboration',1147642466,1255485473,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Collaboration Collaboration root import collaboration','000001000001000008'),('pbproto000000000000002','Request Tracker','Request Tracker Request Tracker request tracker prototype','request-tracker-prototype',1147642465,1163019036,'3','7','12','WebGUI::Asset::Wobject::Collaboration',1,'Request Tracker Request Tracker request tracker prototype','000001000001000033'),('pbtmpl0000000000000220','Flash Style 3 Template','Flash Style 3 Template Flash Style 3 Template flash style 3 template','flash-style-3-template',1147642465,1247488979,'3','7','12','WebGUI::Asset::Template',0,'Flash Style 3 Template Flash Style 3 Template flash style 3 template FileAsset','000001000001000013000002'),('pbtmpl0000000000000221','Flash Tutorial Template','Flash Tutorial Template Flash Tutorial Template flash tutorial template','flash-tutorial-template',1147642465,1247487940,'3','7','12','WebGUI::Asset::Template',0,'Flash Tutorial Template Flash Tutorial Template flash tutorial template FileAsset','000001000001000013000003'),('nbSrhXZQuxIjhWFaFPSuVA','AdminConsole','AdminConsole AdminConsole root import adminconsole','root/import/adminconsole',1147642465,1147642465,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminConsole AdminConsole root import adminconsole','000001000001000003'),('TvOZs8U1kRXLtwtmyW75pg','Article','Article Article root import article','root/import/article',1147642465,1255485472,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Article Article root import article','000001000001000004'),('PBtmpl0000000000000027','Default Forum Notification','Default Forum Notification Default Forum Notification default forum notification','default_forum_notification',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Default Forum Notification Default Forum Notification default forum notification Collaboration/Notification','000001000001000008000015'),('-PkdI8l1idu-8gDX3iOdcw','One Over Two','One Over Two One Over Two one over two','one_over_two',1247482172,1259128608,'3','7','12','WebGUI::Asset::Template',0,'One Over Two One Over Two one over two Layout','000001000001000019000007'),('FEDP3dk8J3Chw_gyr7_XEQ','navigation.css','navigation.css navigation.css navigation.css','navigation.css',1246278679,1246278679,'3','7','12','WebGUI::Asset::Snippet',0,'navigation.css navigation.css navigation.css Horizontal Menu styles horizontalMenu ul.menu  padding 0 margin 0 0 1em list-style none width 100 clear floated li elements overflow auto clear floated li elements  horizontalMenu ul.menu li  float left  horizontalMenu ul.menu li a  float left padding 4px 8px margin-right 1px background ddd color 000 text-decoration none  horizontalMenu ul.menu li.current a  background:#eee  horizontalMenu ul.menu li a:hover  background:#fff  Tabs tabbed navigation styles tabsMenu ul.menu  margin 0 0 1em  tabsMenu ul.menu li  display inline  tabsMenu ul.menu li a  border 1px solid 999 border-bottom 0 padding 5px 10px 2px color 777 text-decoration:none  tabsMenu ul.menu li.current a tabsMenu ul.menu li a:hover  border 1px solid 000 border-bottom 0 color 000  Indent Nav styles indentMenu a.level0  margin-left:0px display:block  indentMenu a.level1  margin-left:15px display:block  indentMenu a.level2  margin-left:30px display:block  indentMenu a.level3  margin-left:45px display:block  indentMenu a.level4  margin-left:60px display:block ','000001000001000025000028'),('PBnav00000000indentnav','Indent Nav','Indent Nav Indent Nav indent nav','indent_nav',1148579525,1259128608,'3','7','12','WebGUI::Asset::Template',0,'Indent Nav Indent Nav indent nav Navigation','000001000001000025000027'),('PBtmpl0000000000000085','Default Email','Default Email Default Email default email','default_email',1124395696,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Default Email Default Email default email DataForm','000001000001000010000002'),('PBnav00000000000bullet','Bulleted List','Bulleted List Bulleted List bulleted list','bulleted_list',1148579524,1261540404,'3','7','12','WebGUI::Asset::Template',0,'Bulleted List Bulleted List bulleted list Navigation','000001000001000025000026'),('StockDataTMPL000000002','StockData Default Display','StockData Default Display StockData Default Display stockdatatmpl000000002','stockdatatmpl000000002',1133743239,1229494994,'3','7','12','WebGUI::Asset::Template',0,'StockData Default Display StockData Default Display stockdatatmpl000000002 StockData/Display','000001000001000041000001'),('2OcUWHVsu_L1sDFzIMWYqw','TimeTracking','TimeTracking TimeTracking root import timetracking','root/import/timetracking',1222803070,1222803070,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'TimeTracking TimeTracking root import timetracking','000001000001000048'),('PBtmpl0000000000000014','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template Default WebGUI Password Recovery Template default webgui password recovery template','default_webgui_password_recovery_template',1124395696,1227218041,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Password Recovery Template Default WebGUI Password Recovery Template default webgui password recovery template Auth/WebGUI/Recovery2','000001000001000005000008000001'),('ProjectManagerTMPL0006','Default Resource List','Default Resource List Default Resource List default pm resource list','default-pm-resource-list',1157679165,1157679165,'3','7','12','WebGUI::Asset::Template',0,'Default Resource List Default Resource List default pm resource list ProjectManager_resourceList','000001000001000031000005000001'),('ProjectManagerTMPL0005','Default Resource Popup','Default Resource Popup Default Resource Popup default pm resource popup','default-pm-resource-popup',1157679165,1229579830,'3','7','12','WebGUI::Asset::Template',0,'Default Resource Popup Default Resource Popup default pm resource popup ProjectManager_resourcePopup','000001000001000031000005000002'),('PBtmpl0000000000000032','Default Thread','Default Thread Default Thread default thread','default_thread',1124395696,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Default Thread Default Thread default thread Collaboration/Thread','000001000001000008000014'),('WeatherDataTmpl0000001','WeatherData Default View','WeatherData Default View WeatherData Default View weatherdatatmpl0000001','weatherdatatmpl0000001',1133743239,1210711353,'3','7','12','WebGUI::Asset::Template',0,'WeatherData Default View WeatherData Default View weatherdatatmpl0000001 WeatherData','000001000001000050000001'),('PBasset000000000000001','Root','Root Root root','root',1124395696,1124395696,'3','7','3','WebGUI::Asset',0,'Root Root root','000001'),('PBrichedit000000000001','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit Content Manager\'s Rich Edit content managers rich edit','content_managers_rich_edit',1124395696,1207240829,'3','7','12','WebGUI::Asset::RichEdit',0,'Content Manager\'s Rich Edit Content Manager\'s Rich Edit content managers rich edit','000001000001000034000001'),('PBrichedit000000000002','Forum Rich Edit','Forum Rich Edit Forum Rich Edit forum rich edit','forum_rich_edit',1124395696,1124395696,'3','7','12','WebGUI::Asset::RichEdit',0,'Forum Rich Edit Forum Rich Edit forum rich edit','000001000001000034000002'),('SynConXSLT000000000001','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT Stylesheet RSS 0.9 XSLT xslt rss0.9.xsl','xslt/rss0.9.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 0.9 XSLT Stylesheet RSS 0.9 XSLT xslt rss0.9.xsl You\'re viewing an RSS version 0.9 feed Please use an RSS feed reader to view this content as intended','000001000001000045000003'),('SynConXSLT000000000002','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT Stylesheet RSS 0.91 XSLT xslt rss0.91.xsl','xslt/rss0.91.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 0.91 XSLT Stylesheet RSS 0.91 XSLT xslt rss0.91.xsl You\'re viewing an RSS version 0.91 feed Please use an RSS feed reader to view this content as intended','000001000001000045000004'),('SynConXSLT000000000003','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT Stylesheet RSS 1.0 XSLT xslt rss1.0.xsl','xslt/rss1.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 1.0 XSLT Stylesheet RSS 1.0 XSLT xslt rss1.0.xsl You\'re viewing an RSS version 1.0 feed Please use an RSS feed reader to view this content as intended  ','000001000001000045000005'),('SynConXSLT000000000004','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT Stylesheet RSS 2.0 XSLT xslt rss2.0.xsl','xslt/rss2.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 2.0 XSLT Stylesheet RSS 2.0 XSLT xslt rss2.0.xsl You\'re viewing an RSS version 2.0 feed Please use an RSS feed reader to view this content as intended ','000001000001000045000006'),('vrKXEtluIhbmAS9xmPukDA','Donation (Default)','Donation Default Donation Default root import default donation template','root/import/default-donation-template',1212092352,1226698051,'3','7','12','WebGUI::Asset::Template',0,'Donation Default Donation Default root import default donation template Donation','000001000001000038000010'),('eqb9sWjFEVq0yHunGV8IGw','Subscription (Default)','Subscription Default Subscription Default root import subscription default','root/import/subscription-default',1213182595,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Subscription Default Subscription Default root import subscription default Subscription','000001000001000038000012'),('PBtmpl0000000000000036','Default Admin Toggle Macro','Default Admin Toggle Macro Default Admin Toggle Macro default admin toggle macro','default_admin_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Admin Toggle Macro Default Admin Toggle Macro default admin toggle macro Macro/AdminToggle','000001000001000021000001000001'),('PBtmpl0000000000000037','Default Account Macro','Default Account Macro Default Account Macro default account macro','default_account_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Account Macro Default Account Macro default account macro Macro/a_account','000001000001000021000002000001'),('PBtmpl0000000000000038','Default Editable Toggle Macro','Default Editable Toggle Macro Default Editable Toggle Macro default editable toggle macro','default_editable_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Editable Toggle Macro Default Editable Toggle Macro default editable toggle macro Macro/EditableToggle','000001000001000021000003000001'),('PBtmpl0000000000000040','Default Group Add Macro','Default Group Add Macro Default Group Add Macro default group add macro','default_group_add_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Group Add Macro Default Group Add Macro default group add macro Macro/GroupAdd','000001000001000021000005000001'),('PBtmpl0000000000000041','Default Group Delete Macro','Default Group Delete Macro Default Group Delete Macro default group delete macro','default_group_delete_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Group Delete Macro Default Group Delete Macro default group delete macro Macro/GroupDelete','000001000001000021000006000001'),('PBtmpl0000000000000042','Default Homelink','Default Homelink Default Homelink default homelink','default_homelink',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Homelink Default Homelink default homelink Macro/H_homeLink','000001000001000021000007000001'),('PBtmpl0000000000000043','Default LoginToggle','Default LoginToggle Default LoginToggle default logintoggle','default_logintoggle',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default LoginToggle Default LoginToggle default logintoggle Macro/LoginToggle','000001000001000021000008000001'),('PBtmpl0000000000000045','Default Make Printable','Default Make Printable Default Make Printable default make printable','default_make_printable',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Make Printable Default Make Printable default make printable Macro/r_printable','000001000001000021000011000001'),('PBtmpl0000000000000091','File no icon','File no icon File no icon file no icon','file_no_icon',1124395696,1129049189,'3','7','12','WebGUI::Asset::Template',0,'File no icon File no icon file no icon Macro/File','000001000001000021000004000002'),('MK4fCNoyrx5SE8eyDfOpxg','Flash File','Flash File Flash File flash file','flash-file',1247489252,1259128610,'3','7','12','WebGUI::Asset::Template',0,'Flash File Flash File flash file FileAsset','000001000001000013000004'),('PBtmpl0000000000000132','Empty','Empty Empty empty','empty',1124395696,1129049190,'3','7','12','WebGUI::Asset::Template',0,'Empty Empty empty style','000001000001000043000004'),('PBtmpl0000000000000140','Default Shortcut','Default Shortcut Default Shortcut pbtmpl0000000000000140','pbtmpl0000000000000140',1124395696,1129573244,'3','7','12','WebGUI::Asset::Template',0,'Default Shortcut Default Shortcut pbtmpl0000000000000140 Shortcut','000001000001000039000001'),('hkj6WeChxFyqfP85UlRP8w','matrix.css','matrix.css matrix.css new matrix matrix.css','new-matrix/matrix.css',1232664229,1250243000,'3','7','12','WebGUI::Asset::Snippet',0,'matrix.css matrix.css new matrix matrix.css wg-clear  display inline clear both font-size:0px line-height:0px   COLUMN STYLES  matrixLeft  float:left width:65 padding:1 min-height:1 background-color:#d2d2d2 moz-border-radius:4px webkit-border-radius 4px  matrixRight  float:left width:25 padding:0px min-height:1 moz-border-radius:4px webkit-border-radius 4px border solid silver 1px background-color:white margin-left:5px   DROPSHADOW BUTTONS  matrixLeft buttons span  background-color:#888 position:relative padding:5px 0px 0px 0px moz-border-radius:4px webkit-border-radius 4px  matrixLeft buttons button matrixLeft buttons a#return  border:solid 2f495e 2px position:relative background-color:#e1e1e1 padding:auto 3px margin:0px font-size:11px line-height:13px position:relative top:-6px left:-2px height:22px cursor:pointer moz-border-radius:4px webkit-border-radius 4px font-weight:bold text-decoration:none color:#333  matrixLeft buttons a#return  font-size:10px padding:3px 10px 2px 10px  matrixLeft buttons button:hover matrixLeft buttons a#return:hover  border-color:black color:white background-color:#444   WHITE AREA FOR THE LISTING OF OBJECTS TO COMPARE  matrixLeft matrixListing  background-color:white height:300px min-height:300px moz-border-radius:4px webkit-border-radius 4px margin:10px 2px 20px 2px padding:auto 10px  matrixLeft matrixListing table  border-collapse:collapse margin:0px padding:0px display:block  matrixLeft matrixListing table a:link  font-size:12px color:#111  matrixLeft matrixListing table a:visited  color:#333 font-size:12px text-decoration:none  matrixLeft matrixListing table a:hover  text-decoration:none   GRAY BAR THAT HOLDS THE SORT BUTTONS  matrixLeft matrixListing sortButtons  background-color:#f1f1f1 border:solid silver 1px moz-border-radius-topLeft:4px moz-border-radius-topRight:4px webkit-border-radius-topLeft 4px webkit-border-radius-topRight 4px border-bottom:solid D2D2D2 2px display:block   STYLES TO OVERRIDE THE SORT BUTTON CSS BUILT INTO THE PERL CODE  sortByViews-button sortByCompares-button sortByUpdated-button sortByClicks-button sortByName-button  background none white-space:nowrap border-style:none cursor:pointer padding-bottom:4px border-style:none background-color:transparent border-right:solid silver 1px color:#555  sortByViews-button:hover sortByCompares-button:hover sortByUpdated-button:hover sortByClicks-button:hover sortByName-button:hover  color:black   MATRIX STATISTICS  matrixRight mainTitle  font-size:20px padding:5px 10px border-bottom solid gray 1px background-color:#d2d2d2  matrixRight textBox  border-top:solid silver 1px padding:10px 5px  matrixStatistics  padding:10px  matrixStatistics title  font-weight:bold background-color:#f1f1f1 padding:2px 5px font-size:11px moz-border-radius:4px border:solid d2d2d2 1px  matrixStatistics statistics  margin-bottom:15px  matrixStatistics label  text-align:right width:100px font-size:10px  matrixStatistics data  font-size:10px  matrixStatistics data a  color:#111  matrixStatistics data a:hover  text-decoration:none   LINKS TO CONTROL ADMIN FUNCTIONS  adminLinks  background-color:#f1f1f1  adminLinks a:link adminLinks a:visited  display:block text-align:center text-decoration:none color:#555 font-weight:normal font-size:10px padding:2px 5px border-top:solid silver 1px  adminLinks a:hover  color:black  adminLinks a.newLink:link adminLinks a.newLink:visited  background-color:#3498d1 color:white display:block  adminLinks a.newLink:hover  background-color:#39a6e5   STYLE FOR THE DETAILED LISTING  matrixDetail  min-width:1000px  matrixDetail editBtns  font-size:9px line-height:11px vertical-align:middle font-weight:normal margin-left:10px  matrixDetail editBtns a  color:black text-decoration:underline  matrixDetail editBtns a:hover  text-decoration:none  matrixDetail stats screenshot  float:left margin-right:20px  matrixDetail commentsMail strong.title  margin-bottom:0px margin-top:20px display:block background-color:#d2d2d2 padding:2px 10px border:solid 1px gray border-bottom-color:silver moz-border-radius-topLeft:4px moz-border-radius-topRight:4px  matrixDetail assetAspectComments  margin:0px 0px 20px 0px border:solid gray 1px background-color:#f1f1f1 moz-border-radius-bottomLeft:4px moz-border-radius-bottomRight:4px  matrixDetail assetAspectComments assetAspectComment  border-top:solid silver 1px border-bottom:solid gray 1px padding:3px background-color:#f5f5f5  matrixDetail assetAspectComments assetAspectCommentForm  border-top:solid d2d2d2 5px padding:20px  matrixDetail stats ul matrixDetail stats ul li  list-style-type:none margin:0px padding:0px  matrixDetail stats ul li  display:block line-height:20px margin:4px 0px  matrixDetail stats ul li strong  display:block float:left width:130px text-align:right background-color:#f1f1f1 padding-right:5px margin-right:5px moz-border-radius:4px webkit-border-radius:3px font-size:11px border:solid d2d2d2 1px  showLink  background-color:#e1e1e1 border:2px solid 2F495E moz-border-radius:4px webkit-border-radius:4px padding:3px 10px text-decoration:none color:black  showLink:hover hideLink:hover  background-color:#555 color:white  hideLink  background-color:#f1f1f1 border:2px solid 2F495E border-bottom-style:none moz-border-radius-topLeft:4px moz-border-radius-topRight:4px webkit-border-radius-topLeft:4px webkit-border-radius-topRight:4px padding:3px 10px text-decoration:none color:black  matrixMail  background-color:#f1f1f1 padding:15px border:2px solid 2F495E moz-border-radius:4px moz-border-radius-topLeft:0px webkit-border-radius:4px webkit-border-radius-topLeft:0px margin-top:1px  matrixMail  tableData  padding:5px margin:0px  matrixMail  input  padding:0px margin:0px  matrixMail  formDescription  text-align:right vertical-align:middle padding-right:10px font-weight:bold  matrixMail form  img  margin-top:-18px  matrixMail verify_formId  height:45px line-height:45px font-size:35px padding:0px margin:0px margin-right:20px  matrixRatings  width:264px position:relative left:-2px top:12px  matrixRatings table  margin-left:0px  matrixRatings td  overflow:hidden  matrixRatings formDescription  text-align:right background-color:#97BCD1 border:solid 4D606B 1px padding:2px 5px font-weight:bold font-size:10x moz-border-radius:4px webkit-border-radius:4px color:#333  matrixRatings formDescription a:before  text-decoration:none  matrixRatings formDescription a  display:block color:red text-decoration:none  matrixRatings formDescription a:hover  text-decoration:underline  matrixAttributes  float:left width:40 min-width:20 max-width:45 margin-right:20px  rightDetails  float:left width:20 min-width:20 max-width:45  attributes  border:solid d2d2d2 1px background-color:#f1f1f1 margin-top:10px moz-border-radius:4px webkit-border-radius:4px padding:10px  attributes table  border-collapse:collapse padding:0px margin:0px  attributes table  td  padding:2px margin:0px  yui-dt0-col-value  font-weight:bold font-size:14px padding:3px white-space:no-wrap   COMPARISON STYLES  compareList table  border-collapse:collapse border:solid silver 1px margin-top:5px  compareList table  th a  color:black padding:1px 5px  compareList table  td  background-color:#f1f1f1 border-top:solid gray 1px border-bottom:solid silver 1px  compareList yui-dt-liner  color:#39A6E5  compareList yui-dt-col-name yui-dt-liner  font-style:italic font-size:10px color:#555  compareList yui-dt-col-name yui-dt-liner b  font-size:15px font-style:normal padding-right:25px color:black ','000001000001000022000006'),('ZipArchiveTMPL00000001','Default Zip Archive Template','Default Zip Archive Template Default Zip Archive Template zip archive template','zip-archive-template',1133743240,1169738426,'3','7','12','WebGUI::Asset::Template',0,'Default Zip Archive Template Default Zip Archive Template zip archive template ZipArchiveAsset','000001000001000056000001'),('PBasset000000000000002','Import Node','Import Node Import root import','root/import',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Import Node Import root import','000001000001'),('2TqQc4OISddWCZmRY1_m8A','The Latest News','The Latest News The Latest News the latest news','the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'The Latest News The Latest News the latest news','000001000002000003'),('68sKwDgf9cGH58-NZcU4lg','Home','Home Home home','home',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Home Home home','000001000002'),('8Bb8gu-me2mhL3ljFyiWLg','What should you do next?','What should you do next Your Next Step your next step','your_next_step',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'What should you do next Your Next Step your next step','000001000002000002'),('Swf6L8poXKc7hUaNPkBevw','Tell A Friend','Tell A Friend Tell A Friend tell a friend','tell_a_friend',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Tell A Friend Tell A Friend tell a friend','000001000002000004'),('_iHetEvMQUOoxS-T2CM0sQ','Getting Started','Getting Started Getting Started getting started','getting_started',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Getting Started Getting Started getting started','000001000002000001'),('x3OFY6OJh_qsXkZfPwug4A','Site Map','Site Map Site Map site map','site_map',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Site Map Site Map site map','000001000002000006'),('PBnav00000000000000001','crumbTrail','crumbTrail crumbTrail crumbtrail','crumbtrail',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'crumbTrail crumbTrail crumbtrail','000001000001000025000008'),('PBnav00000000000000002','SpecificSubMenuVertical','SpecificSubMenuVertical SpecificSubMenuVertical specificsubmenuvertical','specificsubmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuVertical SpecificSubMenuVertical specificsubmenuvertical','000001000001000025000017'),('PBnav00000000000000006','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal SpecificSubMenuHorizontal specificsubmenuhorizontal','specificsubmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuHorizontal SpecificSubMenuHorizontal specificsubmenuhorizontal','000001000001000025000018'),('PBnav00000000000000007','TopLevelMenuVertical','TopLevelMenuVertical TopLevelMenuVertical toplevelmenuvertical','toplevelmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuVertical TopLevelMenuVertical toplevelmenuvertical','000001000001000025000019'),('PBnav00000000000000008','TopLevelMenuHorizontal','TopLevelMenuHorizontal TopLevelMenuHorizontal toplevelmenuhorizontal','toplevelmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuHorizontal TopLevelMenuHorizontal toplevelmenuhorizontal','000001000001000025000020'),('PBnav00000000000000009','RootTab','RootTab RootTab roottab','roottab',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab RootTab roottab','000001000001000025000021'),('PBnav00000000000000010','TopDropMenu','TopDropMenu TopDropMenu topdropmenu','topdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopDropMenu TopDropMenu topdropmenu','000001000001000025000022'),('PBnav00000000000000011','dtree','dtree dtree dtree','dtree',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'dtree dtree dtree','000001000001000025000023'),('PBnav00000000000000012','coolmenu','coolmenu coolmenu coolmenu','coolmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'coolmenu coolmenu coolmenu','000001000001000025000024'),('PBnav00000000000000013','Synopsis','Synopsis Synopsis synopsis','synopsis',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Synopsis Synopsis synopsis','000001000001000025000025'),('PBnav00000000000000014','FlexMenu','FlexMenu FlexMenu flexmenu','flexmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'FlexMenu FlexMenu flexmenu','000001000001000025000009'),('PBnav00000000000000015','currentMenuVertical','currentMenuVertical currentMenuVertical currentmenuvertical','currentmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuVertical currentMenuVertical currentmenuvertical','000001000001000025000010'),('PBnav00000000000000016','currentMenuHorizontal','currentMenuHorizontal currentMenuHorizontal currentmenuhorizontal','currentmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuHorizontal currentMenuHorizontal currentmenuhorizontal','000001000001000025000011'),('PBnav00000000000000017','PreviousDropMenu','PreviousDropMenu PreviousDropMenu previousdropmenu','previousdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'PreviousDropMenu PreviousDropMenu previousdropmenu','000001000001000025000012'),('PBnav00000000000000018','previousMenuVertical','previousMenuVertical previousMenuVertical previousmenuvertical','previousmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuVertical previousMenuVertical previousmenuvertical','000001000001000025000013'),('PBnav00000000000000019','previousMenuHorizontal','previousMenuHorizontal previousMenuHorizontal previousmenuhorizontal','previousmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuHorizontal previousMenuHorizontal previousmenuhorizontal','000001000001000025000014'),('PBnav00000000000000020','rootmenu','rootmenu rootmenu rootmenu','rootmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'rootmenu rootmenu rootmenu','000001000001000025000015'),('PBnav00000000000000021','SpecificDropMenu','SpecificDropMenu SpecificDropMenu specificdropmenu','specificdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificDropMenu SpecificDropMenu specificdropmenu','000001000001000025000016'),('pJd5TLAjfWMVXD6sCRLwUg','Site Map','Site Map Site Map site map site map','site_map/site_map',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'Site Map Site Map site map site map','000001000002000006000001'),('fK-HMSboA3uu0c1KYkYspA','The Latest News','This is the latest news from Plain Black and WebGUI pulled directly from the site every hour.','the_latest_news/the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::SyndicatedContent',1,'The Latest News The Latest News the latest news the latest news This is the latest news from Plain Black and WebGUI pulled directly from the site every hour','000001000002000003000001'),('WikiFrontTmpl000000001','Default Wiki Front Page','Default Wiki Front Page Default Wiki Front Page default wiki front page','default-wiki-front-page',1165460175,1185754572,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Front Page Default Wiki Front Page default wiki front page WikiMaster_front','000001000001000055000002'),('WikiSearchTmpl00000001','Default Wiki Search','Default Wiki Search Default Wiki Search default wiki search','default-wiki-search',1165460175,1168480840,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Search Default Wiki Search default wiki search WikiMaster_search','000001000001000055000003'),('WikiPHTmpl000000000001','Default Page History','Default Page History Default Page History default wiki page history','default-wiki-page-history',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',0,'Default Page History Default Page History default wiki page history WikiPage_pageHistory','000001000001000055000004'),('WikiPageTmpl0000000001','Default Wiki Page','Default Wiki Page Default Wiki Page default wiki page','default-wiki-page',1165460175,1254284570,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Page Default Wiki Page default wiki page WikiPage','000001000001000055000005'),('WikiPageEditTmpl000001','Default Wiki Page Edit','Default Wiki Page Edit Default Wiki Page Edit default wiki page edit','default-wiki-page-edit',1165460175,1221692341,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Page Edit Default Wiki Page Edit default wiki page edit WikiPage_edit','000001000001000055000006'),('WikiMPTmpl000000000001','Default Most Popular','Default Most Popular Default Most Popular default wiki most popular','default-wiki-most-popular',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',0,'Default Most Popular Default Most Popular default wiki most popular WikiMaster_mostPopular','000001000001000055000007'),('SQLReportDownload00001','SQLReport Download Default Template','SQLReport Download Default Template untitled SQLReportDownload0001','SQLReportDownload0001',1171466654,1171466654,'3','7','12','WebGUI::Asset::Template',0,'SQLReport Download Default Template untitled SQLReportDownload0001 SQLReport/Download','000001000001000040000002'),('newsletter000000000001',' Summary Newsletter (default)','Summary Newsletter default Summary Newsletter newsletterdefaulttemplate','newsletterdefaulttemplate',1185754569,1185754569,'3','7','3','WebGUI::Asset::Template',0,'Summary Newsletter default Summary Newsletter newsletterdefaulttemplate newsletter','000001000001000026000001'),('newslettersubscrip0001','My Subscriptions (default)','My Subscriptions default My Subscriptions newslettermysubscriptionstemplate','newslettermysubscriptionstemplate',1185754569,1221692339,'3','7','3','WebGUI::Asset::Template',0,'My Subscriptions default My Subscriptions newslettermysubscriptionstemplate newsletter/mysubscriptions','000001000001000026000003'),('AjhlNO3wZvN5k4i4qioWcg','Default Answer Edit','Default Answer Edit Default Answer Edit root import survey default answer edit','root/import/survey/default-answer-edit',1226009658,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Answer Edit Default Answer Edit root import survey default answer edit Survey/Edit','000001000001000044000009'),('QHn6T9rU7KsnS3Y70KCNTg','Account','Account Account root import account','root/import/account',1227080251,1233173545,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Account Account root import account','000001000001000002'),('HPDOcsj4gBme8D4svHodBw','Profile','Profile Profile root import account profile','root/import/account/profile',1225404573,1225404573,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Profile Profile root import account profile','000001000001000002000001'),('WikiKeyword00000000001',' Wiki Pages By Keyword (default)','Wiki Pages By Keyword default Wiki Pages By Keyword wiki master by keyword template.tmpl','wiki-master-by-keyword-template.tmpl',1185754571,1254284569,'3','7','3','WebGUI::Asset::Template',0,'Wiki Pages By Keyword default Wiki Pages By Keyword wiki master by keyword template.tmpl WikiMaster_byKeyword','000001000001000055000008'),('tempspace0000000000000','Tempspace','Tempspace Tempspace tempspace','tempspace',1185754574,1185754574,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Tempspace Tempspace tempspace','000001000004'),('QpmlAiYZz6VsKBM-_0wXaw','UsersOnline Macro','  ','users-online-macro-templates',1224616691,1224616691,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'UsersOnline Macro UsersOnline Macro users online macro templates','000001000001000021000012'),('h_T2xtOxGRQ9QJOR6ebLpQ','UsersOnline Default View','UsersOnline Default View UsersOnline Default View users online macro templates usersonline default view','users-online-macro-templates/usersonline-default-view',1224616545,1224616545,'3','7','3','WebGUI::Asset::Template',0,'UsersOnline Default View UsersOnline Default View users online macro templates usersonline default view Macro/UsersOnline','000001000001000021000012000001'),('4Ekp0kJoJllRRRo_J1Rj6w','UsersOnline Detailed View','UsersOnline Detailed View UsersOnline Detailed View users online macro templates usersonline detailed view','users-online-macro-templates/usersonline-detailed-view',1224616672,1224616672,'3','7','3','WebGUI::Asset::Template',0,'UsersOnline Detailed View UsersOnline Detailed View users online macro templates usersonline detailed view Macro/UsersOnline','000001000001000021000012000002'),('THQhn1C-ooj-TLlEP7aIJQ','gallery-ie.css','gallery-ie.css gallery-ie.css root import gallery templates gallery ie.css','root/import/gallery-templates/gallery-ie.css',1225313951,1225313951,'3','7','3','WebGUI::Asset::Snippet',0,'gallery-ie.css gallery-ie.css root import gallery templates gallery ie.css wgPicture  float:left  wgAlbum  float:left  wgGallery pagination li wgGallery pagination a  float:left  wgGallery container  display:inline-block ','000001000001000015000025'),('itransact_credentials1','ITransact Credentials (Default)','ITransact Credentials Default ITransact Credentials Default shopping cart collateral items itransact credentials','shopping-cart-collateral-items/itransact-credentials',1228953856,1228953856,'3','7','4','WebGUI::Asset::Template',0,'ITransact Credentials Default ITransact Credentials Default shopping cart collateral items itransact credentials Shop/Credentials','000001000001000038000018'),('1oBRscNIcFOI-pETrCOspA','Default Section Edit','Default Section Edit Default Section Edit root import survey default section edit','root/import/survey/default-section-edit',1226009642,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Section Edit Default Section Edit root import survey default section edit Survey/Edit','000001000001000044000007'),('gI_TxK-5S4DNuv42wpImmw','Gallery Templates','  ','root/import/gallery-templates',1197330678,1213734379,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Gallery Templates Gallery Templates root import gallery templates','000001000001000015'),('jME5BEDYVDlBZ8jIQA9-jQ','Default Gallery Search','Default Gallery Search Default Gallery Search root import gallery templates default gallery search','root/import/gallery-templates/default-gallery-search',1197927169,1234565056,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Search Default Gallery Search root import gallery templates default gallery search Gallery/Search','000001000001000015000001'),('azCqD0IjdQSlM3ar29k5Sg','Default Gallery List Albums View','Default Gallery List Albums View Default Gallery List Albums View root import gallery templates default gallery list albums view','root/import/gallery-templates/default-gallery-list-albums-view',1197881748,1234561066,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Albums View Default Gallery List Albums View root import gallery templates default gallery list albums view Gallery/ListAlbums','000001000001000015000002'),('05FpjceLYhq4csF1Kww1KQ','Default Gallery View Album','Default Gallery View Album Default Gallery View Album root import gallery templates default gallery view album','root/import/gallery-templates/default-gallery-view-album',1197879361,1236641791,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album Default Gallery View Album root import gallery templates default gallery view album GalleryAlbum/View','000001000001000015000003'),('KAMdiUdJykjN02CPHpyZOw','Default Gallery View Album Slideshow','Default Gallery View Album Slideshow Default Gallery View Album Slideshow root import gallery templates default gallery view album slideshow','root/import/gallery-templates/default-gallery-view-album-slideshow',1197825787,1230581176,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album Slideshow Default Gallery View Album Slideshow root import gallery templates default gallery view album slideshow GalleryAlbum/ViewSlideshow','000001000001000015000005'),('OkphOEdaSGTXnFGhK4GT5A','Default Gallery List Files For User','Default Gallery List Files For User Default Gallery List Files For User root import gallery templates default gallery list files for user','root/import/gallery-templates/default-gallery-list-files-for-user',1197825794,1234560760,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Files For User Default Gallery List Files For User root import gallery templates default gallery list files for user Gallery/ListFilesForUser','000001000001000015000006'),('TEId5V-jEvUULsZA0wuRuA','Default Gallery View Photo','Default Gallery View Photo Default Gallery View Photo root import gallery templates default gallery view photo','root/import/gallery-templates/default-gallery-view-photo',1197989443,1234568469,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Photo Default Gallery View Photo root import gallery templates default gallery view photo GalleryFile/View','000001000001000015000007'),('6X-7Twabn5KKO_AbgK3PEw','Default Gallery Edit Album','Default Gallery Edit Album Default Gallery Edit Album root import gallery templates default gallery edit album','root/import/gallery-templates/default-gallery-edit-album',1197987780,1233872216,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Edit Album Default Gallery Edit Album root import gallery templates default gallery edit album GalleryAlbum/Edit','000001000001000015000008'),('7JCTAiu1U_bT9ldr655Blw','Default Gallery Edit Photo','Default Gallery Edit Photo Default Gallery Edit Photo root import gallery templates default gallery edit photo','root/import/gallery-templates/default-gallery-edit-photo',1197825824,1233872075,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Edit Photo Default Gallery Edit Photo root import gallery templates default gallery edit photo GalleryFile/Edit','000001000001000015000009'),('0X4Q3tBWUb_thsVbsYz9xQ','Default Gallery Add Archive','Default Gallery Add Archive Default Gallery Add Archive root import gallery templates default gallery add archive','root/import/gallery-templates/default-gallery-add-archive',1197987372,1230581176,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Add Archive Default Gallery Add Archive root import gallery templates default gallery add archive GalleryAlbum/AddArchive','000001000001000015000010'),('m3IbBavqzuKDd2PGGhKPlA','Default Gallery Make Shortcut','Default Gallery Make Shortcut Default Gallery Make Shortcut root import gallery templates default gallery make shortcut','root/import/gallery-templates/default-gallery-make-shortcut',1197825845,1233871747,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Make Shortcut Default Gallery Make Shortcut root import gallery templates default gallery make shortcut GalleryFile/MakeShortcut','000001000001000015000011'),('UTNFeV7B_aSCRmmaFCq4Vw','Default Gallery Delete Album','Default Gallery Delete Album Default Gallery Delete Album root import gallery templates default gallery delete album','root/import/gallery-templates/default-gallery-delete-album',1197825856,1244073447,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Delete Album Default Gallery Delete Album root import gallery templates default gallery delete album GalleryAlbum/Delete','000001000001000015000012'),('zcX-wIUct0S_np14xxOA-A','Default Gallery Delete File','Default Gallery Delete File Default Gallery Delete File root import gallery templates default gallery delete file','root/import/gallery-templates/default-gallery-delete-file',1197825866,1234568742,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Delete File Default Gallery Delete File root import gallery templates default gallery delete file GalleryFile/Delete','000001000001000015000013'),('MBZK_LPVzqhb4TV4mMRTJg','admin_ie7.css','admin_ie7.css admin_ie7.css root import gallery templates admin ie7.css','root/import/gallery-templates/admin_ie7.css',1197330678,1197330678,'3','7','3','WebGUI::Asset::Snippet',0,'admin_ie7.css admin_ie7.css root import gallery templates admin ie7.css input.captionEnter  margin-left 5px width 92px ','000001000001000015000014'),('_hELmIJfgbAyXFNqPyApxQ','admin.css','admin.css admin.css root import gallery templates admin.css','root/import/gallery-templates/admin.css',1197330678,1213309523,'3','7','3','WebGUI::Asset::Snippet',0,'admin.css admin.css root import gallery templates admin.css adminWrapper  text-align:left font-family:arial font-size:11px position relative z-index 2  h2  font-size:15px  messageStyle  font-weight:bold font-family:arial font-size:10px margin-bottom:8px  adminButton  border:solid silver 1px background-color:#e0e0e0 font-weight:bold font-size:10px color:#333 cursor:pointer padding 0.5em 1em  adminTable  border:solid silver 1px background-color:#F0F0F0 color black width:320px padding:5px  adminTable select adminTable input adminTable textarea border:solid gray 1px font-size:10px padding-left:5px  label  white-space:nowrap text-align:right padding-right:10px font-weight:bold width:1px vertical-align:top  galleryOrg  position:relative margin-top:0px padding-top:0px margin-left:5px border:gray solid 1px text-align:center margin-top:3px width 95 background-color DEDEDE  galleryOrg left  float left width 36  galleryOrg right  width 63  galleryOrg img  display:block height:150px margin:0px auto  promote  margin-left:3px  promote img  height:14px width:16px  demote  margin-right:3px  demote img  height:14px width:16px  delete img  height 14px  numbering  position:absolute top:0px left:0px padding:1px background-color:black color:white moz-border-radius-bottomRight:5px  input.captionEnter  width:93px clear:both margin-bottom:3px  galleryOrg button  border-style:none background:none  galleryOrg button img  width:16px height:auto  galleryOrg synopsis input  width:80px ','000001000001000015000015'),('bANo8aiAPA7aY_oQZKxIWw','rss.gif','rss.gif rss.gif root import gallery templates images rss.gif','root/import/gallery-templates/images/rss.gif',1197330678,1197330678,'3','7','3','WebGUI::Asset::File::Image',1,'rss.gif rss.gif root import gallery templates images rss.gif','000001000001000015000017000001'),('2ci_v2d4x4uvyjTRlC49OA','moveDown.gif','moveDown.gif moveDown.gif root import gallery templates images movedown.gif','root/import/gallery-templates/images/movedown.gif',1197330678,1209499188,'3','7','3','WebGUI::Asset::File::Image',1,'moveDown.gif moveDown.gif root import gallery templates images movedown.gif','000001000001000015000017000002'),('O-EsSzKgAk1KolFT-x_KsA','moveUp.gif','moveUp.gif moveUp.gif root import gallery templates images moveup.gif','root/import/gallery-templates/images/moveup.gif',1197330678,1209499188,'3','7','3','WebGUI::Asset::File::Image',1,'moveUp.gif moveUp.gif root import gallery templates images moveup.gif','000001000001000015000017000003'),('fdd8tGExyVwHyrB8RBbKXg','next.gif','next.gif next.gif root import gallery templates images next.gif','root/import/gallery-templates/images/next.gif',1197330839,1197330839,'3','7','3','WebGUI::Asset::File::Image',1,'next.gif next.gif root import gallery templates images next.gif','000001000001000015000017000004'),('BpisgHl4ZDcSECJp6oib1w','play.gif','play.gif play.gif root import gallery templates images play.gif','root/import/gallery-templates/images/play.gif',1197330840,1197330840,'3','7','3','WebGUI::Asset::File::Image',1,'play.gif play.gif root import gallery templates images play.gif','000001000001000015000017000005'),('zshreRgPAXtnF0DtVbQ1Yg','previous.gif','previous.gif previous.gif root import gallery templates images previous.gif','root/import/gallery-templates/images/previous.gif',1197330840,1197330840,'3','7','3','WebGUI::Asset::File::Image',1,'previous.gif previous.gif root import gallery templates images previous.gif','000001000001000015000017000006'),('mM3bjP_iG9sv5nQb4S17tQ','Default Gallery View Album RSS','Default Gallery View Album RSS Default Gallery View Album RSS root import gallery templates default gallery album rss','root/import/gallery-templates/default-gallery-album-rss',1197879662,1230581176,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album RSS Default Gallery View Album RSS root import gallery templates default gallery album rss GalleryAlbum/ViewRss','000001000001000015000018'),('ilu5BrM-VGaOsec9Lm7M6Q','Default Gallery List Albums RSS','Default Gallery List Albums RSS Default Gallery List Albums RSS root import gallery templates default gallery list albums rss','root/import/gallery-templates/default-gallery-list-albums-rss',1197878780,1230581176,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Albums RSS Default Gallery List Albums RSS root import gallery templates default gallery list albums rss Gallery/ListAlbumsRss','000001000001000015000019'),('-ANLpoTEP-n4POAdRxCzRw','Default Gallery List Files For User RSS','Default Gallery List Files For User RSS Default Gallery List Files For User RSS root import gallery templates default gallery list files for user rss','root/import/gallery-templates/default-gallery-list-files-for-user-rss',1197880641,1230581176,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Files For User RSS Default Gallery List Files For User RSS root import gallery templates default gallery list files for user rss Gallery/ListFilesForUserRss','000001000001000015000020'),('OxJWQgnGsgyGohP2L3zJPQ','Default Gallery Edit Comment','Default Gallery Edit Comment Default Gallery Edit Comment root import gallery templates default gallery edit comment','root/import/gallery-templates/default-gallery-edit-comment',1204663962,1234564647,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Edit Comment Default Gallery Edit Comment root import gallery templates default gallery edit comment GalleryFile/EditComment','000001000001000015000021'),('Tsg7xmPYv782j6IVz7yHFg','Calendar Templates','Calendar Templates Calendar Templates root import calendar templates','root/import/calendar-templates',1204890713,1213244777,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Calendar Templates Calendar Templates root import calendar templates','000001000001000006'),('kj3b-X3i6zRKnhLb4ZiCLw','Default Calendar List View','Default Calendar List View Default Calendar List View root import calendar templates default calendar list view','root/import/calendar-templates/default-calendar-list-view',1204890713,1243445504,'3','7','3','WebGUI::Asset::Template',0,'Default Calendar List View Default Calendar List View root import calendar templates default calendar list view Calendar/List','000001000001000006000001'),('uRL9qtk7Rb0YRJ41LmHOJw','Default Calendar Print List View','Default Calendar Print List View Default Calendar Print List View root import calendar templates default calendar print list view','root/import/calendar-templates/default-calendar-print-list-view',1204890713,1229311072,'3','7','3','WebGUI::Asset::Template',0,'Default Calendar Print List View Default Calendar Print List View root import calendar templates default calendar print list view Calendar/Print/List','000001000001000006000002'),('CalendarWeek0000000001','Default Calendar Week','Default Calendar Week Default Calendar Week root import calendar templates default calendar week','root/import/calendar-templates/default-calendar-week',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Week Default Calendar Week root import calendar templates default calendar week Calendar/Week','000001000001000006000003'),('CalendarDay00000000001','Default Calendar Day','Default Calendar Day Default Calendar Day root import calendar templates default calendar day','root/import/calendar-templates/default-calendar-day',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Day Default Calendar Day root import calendar templates default calendar day Calendar/Day','000001000001000006000004'),('CalendarEvent000000001','Default Calendar Event','Default Calendar Event Default Calendar Event root import calendar templates default calendar event','root/import/calendar-templates/default-calendar-event',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Event Default Calendar Event root import calendar templates default calendar event Calendar/Event','000001000001000006000005'),('CalendarEventEdit00001','Default Calendar Event Edit','Default Calendar Event Edit Default Calendar Event Edit root import calendar templates default calendar event edit','root/import/calendar-templates/default-calendar-event-edit',1205160982,1256702482,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Event Edit Default Calendar Event Edit root import calendar templates default calendar event edit Calendar/EventEdit','000001000001000006000006'),('CalendarSearch00000001','Default Calendar Search','Default Calendar Search Default Calendar Search root import calendar templates default calendar search','root/import/calendar-templates/default-calendar-search',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Search Default Calendar Search root import calendar templates default calendar search Calendar/Search','000001000001000006000008'),('CalendarPrintEvent0001','Default Calendar Print Event','Default Calendar Print Event Default Calendar Print Event root import calendar templates default calendar print event','root/import/calendar-templates/default-calendar-print-event',1204890714,1215396964,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Event Default Calendar Print Event root import calendar templates default calendar print event Calendar/Print/Event','000001000001000006000009'),('CalendarPrintMonth0001','Default Calendar Print Month','Default Calendar Print Month Default Calendar Print Month root import calendar templates default calendar print month','root/import/calendar-templates/default-calendar-print-month',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Month Default Calendar Print Month root import calendar templates default calendar print month Calendar/Print/Month','000001000001000006000010'),('CalendarPrintWeek00001','Default Calendar Print Week','Default Calendar Print Week Default Calendar Print Week root import calendar templates default calendar print week','root/import/calendar-templates/default-calendar-print-week',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Week Default Calendar Print Week root import calendar templates default calendar print week Calendar/Print/Week','000001000001000006000011'),('CalendarPrintDay000001','Default Calendar Print Day','Default Calendar Print Day Default Calendar Print Day root import calendar templates default calendar print day','root/import/calendar-templates/default-calendar-print-day',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Day Default Calendar Print Day root import calendar templates default calendar print day Calendar/Print/Day','000001000001000006000012'),('jnYdqDkUR8x7Pv2eGR1qTA','Thingy Templates','Thingy Templates Thingy Templates root import thingy templates','root/import/thingy-templates',1205431513,1216250666,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Thingy Templates Thingy Templates root import thingy templates','000001000001000046'),('ThingyTmpl000000000001','Default Thingy','Default Thingy Default Thingy templates thingy default','templates/thingy-default',1205003608,1237914005,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy Default Thingy templates thingy default Thingy','000001000001000046000001'),('ThingyTmpl000000000002','Default Thingy View Thing','Default Thingy View Thing Default Thingy View Thing templates thingy default view thing','templates/thingy-default-view-thing',1205003676,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy View Thing Default Thingy View Thing templates thingy default view thing Thingy/ViewThing','000001000001000046000002'),('ThingyTmpl000000000003','Default Thingy Edit Thing','Default Thingy Edit Thing Default Thingy Edit Thing templates thingy default edit thing','templates/thingy-default-edit-thing',1205003711,1224518002,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy Edit Thing Default Thingy Edit Thing templates thingy default edit thing Thingy/EditThing','000001000001000046000003'),('ThingyTmpl000000000004','Default Thingy Search Thing','Default Thingy Search Thing Default Thingy Search Thing templates thingy default search thing','templates/thingy-default-search-thing',1205158717,1227044214,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy Search Thing Default Thingy Search Thing templates thingy default search thing Thingy/SearchThing','000001000001000046000004'),('7fE8md51vTCcuJFOvxNaGA','thumbnails.js','thumbnails.js thumbnails.js root import gallery templates thumbnails.js','root/import/gallery-templates/thumbnails.js',1205443600,1209503742,'3','7','3','WebGUI::Asset::Snippet',0,'thumbnails.js thumbnails.js root import gallery templates thumbnails.js  Depends on BrowserDetect.js  Make the thumbnails a little bigger while the mouse is over them function scaleThumbUp  e anchor    IE6 doesn\'t like to do the right thing with the CSS stuff below exclude it if  BrowserDetect   if  BrowserDetect.browser == Explorer  BrowserDetect.version < 7   return    Make a new image with the same image src as the anchor var oldImage = anchor.getElementsByTagName(\"img\")[0 var newContainer = document.createElement(\"div newContainer.className = thumb-popup newContainer.style.position = absolute newContainer.style.zIndex = 1 var newWidth = oldImage.offsetWidth  3 var newHeight = oldImage.offsetHeight  3 var newLeft =   anchor.offsetLeft +  anchor.offsetWidth  2     newWidth  2   var newTop =   anchor.offsetTop +  anchor.offsetHeight  2     newHeight  2   newContainer.style.left = newLeft + px newContainer.style.top = newTop + px newContainer.style.width = newWidth + px newContainer.style.height = newHeight + px var newImage = document.createElement(\"img newImage.src = oldImage.src newImage.style.width = 100 newImage.style.height = 100 newContainer.appendChild newImage   Make some text for the caption var caption = document.createElement(\"div caption.appendChild document.createTextNode anchor.title   caption.className = caption newContainer.appendChild caption  var newBox = document.createElement(\"a newBox.href = anchor.href newBox.style.display = block newBox.style.position = absolute newBox.style.zIndex = 10 newBox.style.left =  anchor.offsetLeft  + px newBox.style.top =  anchor.offsetTop  + px newBox.style.height =  anchor.offsetHeight  + px newBox.style.width =  anchor.offsetWidth  + px newBox.style.border = 1px solid transparent anchor.parentNode.appendChild newContainer  anchor.parentNode.appendChild newBox  YAHOO.util.Event.addListener newBox click function   window.location.href = anchor.href   YAHOO.util.Event.addListener newContainer mouseout scaleThumbDown  newBox newContainer caption   YAHOO.util.Event.addListener newBox mouseout scaleThumbDown  newBox newContainer caption    function scaleThumbDown  e elements   for  var i = 0 i < elements.length i++   elements[i].parentNode.removeChild elements[i    var anchorTimeout function enterAnchor  e anchor   if  typeof anchorTimeout = undefined   clearTimeout anchorTimeout   anchorTimeout = setTimeout function  scaleThumbUp e anchor   150   function leaveAnchor  e anchor   if  typeof anchorTimeout = undefined   clearTimeout anchorTimeout    function initThumb   var anchors = YAHOO.util.Dom.getElementsByClassName thumb  for  var i = 0 i < anchors.length i++   YAHOO.util.Event.addListener anchors[i mouseover enterAnchor anchors[i  YAHOO.util.Event.addListener anchors[i mouseout leaveAnchor anchors[i    YAHOO.util.Event.onDOMReady initThumb ','000001000001000015000022'),('1oGhfj00KkCzP1ez01AfKA','slideshow.js','slideshow.js slideshow.js root import gallery templates slideshow.js','root/import/gallery-templates/slideshow.js',1205635970,1218582812,'3','7','3','WebGUI::Asset::Snippet',0,'slideshow.js slideshow.js root import gallery templates slideshow.js if  typeof WebGUI == undefined   WebGUI =    WebGUI.Slideshow  config  Configure and return a new Slideshow object config is an object with the following properties containerId  The ID of the element that contains the Slideshow items Defaults to slideshow-container currentIndex  The index of the first item in the Slideshow Defaults to 0 isPlaying  If true the slideshow will begin immediately itemClassName  The class name of the slideshow items Defaults to slideshow-item nextButtonId  The id of the button to go to the next item pauseImageSrc  The URL to the pause button image playDelay  The delay in milliseconds between slides Defaults to 5000 playImageSrc  The URL to the play button image playPauseButtonId  The id of the button to toggle between play and pause previousButtonId  The id of the button to go to the previous item wrap  If true the slideshow will wrap around  Control the slideshow To control the slideshow you can use the following methods next  Pause the slideshow and go to the next slide previous  Pause the slideshow and go to the previous slide play  Play the slideshow pause  Pause the slideshow togglePlay  If it\'s playing pause it If it\'s paused play it  WebGUI.Slideshow = function  config   this.containerId = config  config.containerId  config.containerId  slideshow-container this.currentIndex = config  config.currentIndex  config.currentIndex  0 this.isPlaying = config  config.isPlaying  config.isPlaying  false this.itemClassName = config  config.itemClassName  config.itemClassName  slideshow-item this.nextButtonId = config  config.nextButtonId  undefined this.pauseImageSrc = config  config.pauseImageSrc  undefined this.playDelay = config  config.playDelay  config.playDelay  5000 this.playImageSrc = config  config.playImageSrc  undefined this.playPauseButtonId = config  config.playPauseButtonId  undefined this.previousButtonId = config  config.previousButtonId  undefined this.wrap = config  config.wrap  config.wrap  false YAHOO.util.Event.onDOMReady this.init this true    clearPlayTimeout   Clears the timeout to move to the next slide  WebGUI.Slideshow.prototype.clearPlayTimeout = function   clearTimeout this.playTimeout  this.playTimeout = undefined   doPlayTick  self  Performs the action to move to the next slide and start a new timeout self is a new reference to the object to get around the scoping issues with setTimeout  WebGUI.Slideshow.prototype.doPlayTick = function self  self.showNext self.setPlayTimeout   getSlideshowContainer   Returns the HTMLElement for the Slideshow container  WebGUI.Slideshow.prototype.getSlideshowContainer = function   return document.getElementById this.containerId    getSlideshowItems   Returns an array of HTMLElements for the Slideshow\'s items  WebGUI.Slideshow.prototype.getSlideshowItems = function   var items = YAHOO.util.Dom.getElementsByClassName this.itemClassName undefined this.getSlideshowContainer  return items   init   Initialize the slideshow Performed after the DOM is ready  WebGUI.Slideshow.prototype.init = function    Add handlers to buttons if  this.playPauseButtonId   YAHOO.util.Event.addListener this.playPauseButtonId click this.togglePlay this true   if  this.nextButtonId   YAHOO.util.Event.addListener this.nextButtonId click this.next this true   if  this.previousButtonId   YAHOO.util.Event.addListener this.previousButtonId click this.previous this true    Hide all but the currentIndex var items = this.getSlideshowItems for  var i = 0 i < items.length i++   if  i = this.currentIndex   items i style.display = none  else  items i style.display = block    Start it off if necessary if  this.isPlaying   this.setPlayTimeout this.updatePlayPauseButton    next   Pause the slideshow and go to the next slide  WebGUI.Slideshow.prototype.next = function   this.pause this.showNext   play   Start the slideshow  WebGUI.Slideshow.prototype.play = function   if  this.isPlaying   this.isPlaying = true this.setPlayTimeout this.updatePlayPauseButton    previous   Pause the slideshow and show the previous slide  WebGUI.Slideshow.prototype.previous = function   this.pause this.showPrevious   pause   Pause the slideshow  WebGUI.Slideshow.prototype.pause = function   if  this.isPlaying   this.isPlaying = false this.clearPlayTimeout this.updatePlayPauseButton    setPlayTimeout   Sets the timeout to move to the next slide  WebGUI.Slideshow.prototype.setPlayTimeout = function   var self = this this.playTimeout = setTimeout function   self.doPlayTick(self  this.playDelay    showNext   Show the next slide  WebGUI.Slideshow.prototype.showNext = function   var items = this.getSlideshowItems var hideIndex = this.currentIndex var showIndex = this.currentIndex + 1  Wrap around if  this.wrap  showIndex >= items.length   showIndex = 0   Don\'t allow going past the last item else if  showIndex >= items.length   return   Do the switch if  items hideIndex   items hideIndex style.display = none if  items showIndex    items showIndex style.display = block this.currentIndex = showIndex    showPrevious   Show the previous slide  WebGUI.Slideshow.prototype.showPrevious = function   var items = this.getSlideshowItems var hideIndex = this.currentIndex var showIndex = this.currentIndex  1  Wrap around if  this.wrap  showIndex < 0   showIndex = items.length  1   Don\'t allow going past the last item else if  showIndex < 0   return   Do the switch items hideIndex style.display = none items showIndex style.display = block this.currentIndex = showIndex   togglePlay   If it\'s paused play it If it\'s playing pause it Return true if the slideshow is now playing  WebGUI.Slideshow.prototype.togglePlay = function   if  this.isPlaying == false   this.play return true  else  this.pause    updatePlayPauseButton   Update the Play/Pause button to have the correct image  WebGUI.Slideshow.prototype.updatePlayPauseButton = function   if  this.playPauseButtonId   if  this.isPlaying  this.playImageSrc   document.getElementById this.playPauseButtonId src = this.pauseImageSrc  else if  this.pauseImageSrc   document.getElementById this.playPauseButtonId src = this.playImageSrc   ','000001000001000015000023'),('3qiVYhNTXMVC5hfsumVHgg','browserdetect.js','browserdetect.js browserdetect.js root import gallery templates browserdetect.js','root/import/gallery-templates/browserdetect.js',1206743306,1206743306,'3','7','3','WebGUI::Asset::Snippet',0,'browserdetect.js browserdetect.js root import gallery templates browserdetect.js var BrowserDetect =  init function   this.browser = this.searchString(this.dataBrowser || An unknown browser this.version = this.searchVersion(navigator.userAgent || this.searchVersion(navigator.appVersion || an unknown version this.OS = this.searchString(this.dataOS || an unknown OS  searchString function data  for var i=0;i','000001000001000015000024'),('usuxw9V3jN4d4pujRiEYxg','css03-ie.css','css03-ie.css css03-ie.css style3 css03 ie.css','style3/css03-ie.css',1209494150,1209494150,'3','7','12','WebGUI::Asset::Snippet',0,'css03-ie.css css03-ie.css style3 css03 ie.css contentArea  height:500px padding-bottom:300px ','000001000001000054000023'),('POVcY79vIqAHR8OfGt36aw','pagination_button.jpg','pagination_button.jpg pagination_button.jpg root import gallery templates images pagination button.jpg','root/import/gallery-templates/images/pagination_button.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'pagination_button.jpg pagination_button.jpg root import gallery templates images pagination button.jpg','000001000001000015000017000007'),('hIB-z34r8Xl-vYVYCkKr-w','bar-btn-r.jpg','bar-btn-r.jpg bar-btn-r.jpg root import gallery templates images bar btn r.jpg','root/import/gallery-templates/images/bar-btn-r.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'bar-btn-r.jpg bar-btn-r.jpg root import gallery templates images bar btn r.jpg','000001000001000015000017000008'),('-mPUoFlYcjqjPUPRLAlxNQ','search-field-r.jpg','search-field-r.jpg search-field-r.jpg root import gallery templates images search field r.jpg','root/import/gallery-templates/images/search-field-r.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'search-field-r.jpg search-field-r.jpg root import gallery templates images search field r.jpg','000001000001000015000017000009'),('MDpUOR-N8KMyt1J7Hh_h4w','bar-btn.jpg','bar-btn.jpg bar-btn.jpg root import gallery templates images bar btn.jpg','root/import/gallery-templates/images/bar-btn.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'bar-btn.jpg bar-btn.jpg root import gallery templates images bar btn.jpg','000001000001000015000017000010'),('YfXKByTwDZVituMc4h13Dg','pagination_bg.jpg','pagination_bg.jpg pagination_bg.jpg root import gallery templates images pagination bg.jpg','root/import/gallery-templates/images/pagination_bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'pagination_bg.jpg pagination_bg.jpg root import gallery templates images pagination bg.jpg','000001000001000015000017000011'),('esko_HSU0Gh-uJZ1h3xRmQ','search-field-l.jpg','search-field-l.jpg search-field-l.jpg root import gallery templates images search field l.jpg','root/import/gallery-templates/images/search-field-l.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'search-field-l.jpg search-field-l.jpg root import gallery templates images search field l.jpg','000001000001000015000017000012'),('oSqpGswzpBG_ErdfYwIO8A','top_bg.jpg','top_bg.jpg top_bg.jpg root import gallery templates images top bg.jpg','root/import/gallery-templates/images/top_bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'top_bg.jpg top_bg.jpg root import gallery templates images top bg.jpg','000001000001000015000017000013'),('MXJklShZvLLB_DSnZQmXrQ','title_bg.jpg','title_bg.jpg title_bg.jpg root import gallery templates images title bg.jpg','root/import/gallery-templates/images/title_bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'title_bg.jpg title_bg.jpg root import gallery templates images title bg.jpg','000001000001000015000017000014'),('BthxD5oJ0idmsyI3ioA2FA','bar-btn-l.jpg','bar-btn-l.jpg bar-btn-l.jpg root import gallery templates images bar btn l.jpg','root/import/gallery-templates/images/bar-btn-l.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'bar-btn-l.jpg bar-btn-l.jpg root import gallery templates images bar btn l.jpg','000001000001000015000017000015'),('aZ-1HYQamkRHYXvzAra8WQ','search-field.jpg','search-field.jpg search-field.jpg root import gallery templates images search field.jpg','root/import/gallery-templates/images/search-field.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'search-field.jpg search-field.jpg root import gallery templates images search field.jpg','000001000001000015000017000016'),('eRkb94OYcS5AdcrrerOP5Q','rss.gif','rss.gif rss.gif root import gallery templates images rss2.gif','root/import/gallery-templates/images/rss2.gif',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'rss.gif rss.gif root import gallery templates images rss2.gif','000001000001000015000017000017'),('TbnkjAJQEASORXIpYqDkcA','blank-image.jpg','blank-image.jpg blank-image.jpg root import gallery templates images blank image.jpg','root/import/gallery-templates/images/blank-image.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'blank-image.jpg blank-image.jpg root import gallery templates images blank image.jpg','000001000001000015000017000018'),('er-3faBjY-hhlDcc5aKqdQ','top_bg.jpg','top_bg.jpg top_bg.jpg root import gallery templates images top bg2.jpg','root/import/gallery-templates/images/top_bg2.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'top_bg.jpg top_bg.jpg root import gallery templates images top bg2.jpg','000001000001000015000017000019'),('8bFsu2FJUqHRUiHcozcVFw','sub-btn-l.jpg','sub-btn-l.jpg sub-btn-l.jpg root import gallery templates images sub btn l.jpg','root/import/gallery-templates/images/sub-btn-l.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'sub-btn-l.jpg sub-btn-l.jpg root import gallery templates images sub btn l.jpg','000001000001000015000017000020'),('34Aayx5eA320D8VfhdfDBw','sub-btn-r.jpg','sub-btn-r.jpg sub-btn-r.jpg root import gallery templates images sub btn r.jpg','root/import/gallery-templates/images/sub-btn-r.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'sub-btn-r.jpg sub-btn-r.jpg root import gallery templates images sub btn r.jpg','000001000001000015000017000021'),('TlhKOVmWblZOsAdqmhEpeg','sub-btn.jpg','sub-btn.jpg sub-btn.jpg root import gallery templates images sub btn.jpg','root/import/gallery-templates/images/sub-btn.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'sub-btn.jpg sub-btn.jpg root import gallery templates images sub btn.jpg','000001000001000015000017000022'),('Nx0ypjO3cN6QdZUBUEE0lA','pic-title-bg.jpg','pic-title-bg.jpg pic-title-bg.jpg root import gallery templates images pic title bg.jpg','root/import/gallery-templates/images/pic-title-bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'pic-title-bg.jpg pic-title-bg.jpg root import gallery templates images pic title bg.jpg','000001000001000015000017000023'),('CmFZLN7iPS7XXvUEsxKPKA','row-2.jpg','row-2.jpg row-2.jpg root import gallery templates images row 2.jpg','root/import/gallery-templates/images/row-2.jpg',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'row-2.jpg row-2.jpg root import gallery templates images row 2.jpg','000001000001000015000017000024'),('v_XBgwwZqgW1D5s4y05qfg','addtl-info.gif','addtl-info.gif addtl-info.gif root import gallery templates images addtl info.gif','root/import/gallery-templates/images/addtl-info.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'addtl-info.gif addtl-info.gif root import gallery templates images addtl info.gif','000001000001000015000017000025'),('4TdAkKoQbSCvI7QWcW889A','row-1.jpg','row-1.jpg row-1.jpg root import gallery templates images row 1.jpg','root/import/gallery-templates/images/row-1.jpg',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'row-1.jpg row-1.jpg root import gallery templates images row 1.jpg','000001000001000015000017000026'),('SAgK6eDPCG1cgkJ59WapHQ','prev-btn.gif','prev-btn.gif prev-btn.gif root import gallery templates images prev btn.gif','root/import/gallery-templates/images/prev-btn.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'prev-btn.gif prev-btn.gif root import gallery templates images prev btn.gif','000001000001000015000017000027'),('XJYLuvGy9ubF7JNKyINtpA','play-btn.gif','play-btn.gif play-btn.gif root import gallery templates images play btn.gif','root/import/gallery-templates/images/play-btn.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'play-btn.gif play-btn.gif root import gallery templates images play btn.gif','000001000001000015000017000028'),('RWj7hyv2SpZuXxwj1Wocug','next-btn.gif','next-btn.gif next-btn.gif root import gallery templates images next btn.gif','root/import/gallery-templates/images/next-btn.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'next-btn.gif next-btn.gif root import gallery templates images next btn.gif','000001000001000015000017000029'),('aq8QElnlm3YufAoxRz9Pcg','data-bg.jpg','data-bg.jpg data-bg.jpg root import gallery templates images data bg.jpg','root/import/gallery-templates/images/data-bg.jpg',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'data-bg.jpg data-bg.jpg root import gallery templates images data bg.jpg','000001000001000015000017000030'),('6D4Z-oruXPS6OlH_Kx8pBg','images','images images root import thingy templates images','root/import/thingy-templates/images',1209509389,1209509389,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images images root import thingy templates images','000001000001000046000005'),('hQ7z33_jOYkQ8WNX5xy9Sw','style-button.gif','style-button.gif style-button.gif root import thingy templates images style button.gif','root/import/thingy-templates/images/style-button.gif',1209509455,1209509455,'3','7','12','WebGUI::Asset::File::Image',1,'style-button.gif style-button.gif root import thingy templates images style button.gif','000001000001000046000005000001'),('vWW_DcHiYSrKZOkkIfEfcQ','row-2.jpg','row-2.jpg row-2.jpg root import thingy templates images row 2.jpg','root/import/thingy-templates/images/row-2.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'row-2.jpg row-2.jpg root import thingy templates images row 2.jpg','000001000001000046000005000002'),('_bPYzRA87NTAUIKlfrJMHg','row-1.jpg','row-1.jpg row-1.jpg root import thingy templates images row 1.jpg','root/import/thingy-templates/images/row-1.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'row-1.jpg row-1.jpg root import thingy templates images row 1.jpg','000001000001000046000005000003'),('nJjZHRwdDs5MAZYsAyioHw','title-bg.jpg','title-bg.jpg title-bg.jpg root import thingy templates images title bg.jpg','root/import/thingy-templates/images/title-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'title-bg.jpg title-bg.jpg root import thingy templates images title bg.jpg','000001000001000046000005000004'),('8hxfkrJPeFVRWF5piCNJ1A','field-bg.jpg','field-bg.jpg field-bg.jpg root import thingy templates images field bg.jpg','root/import/thingy-templates/images/field-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'field-bg.jpg field-bg.jpg root import thingy templates images field bg.jpg','000001000001000046000005000005'),('Osx7WN52iIKHZFT4vqUBHQ','search-btn.gif','search-btn.gif search-btn.gif root import thingy templates images search btn.gif','root/import/thingy-templates/images/search-btn.gif',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'search-btn.gif search-btn.gif root import thingy templates images search btn.gif','000001000001000046000005000006'),('oWff8fGzRdHPyq5VNREe9Q','top-bg.jpg','top-bg.jpg top-bg.jpg root import thingy templates images top bg.jpg','root/import/thingy-templates/images/top-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'top-bg.jpg top-bg.jpg root import thingy templates images top bg.jpg','000001000001000046000005000007'),('uqbkvb1b9443VvfkyRz95w','save-button.gif','save-button.gif save-button.gif root import thingy templates images save button.gif','root/import/thingy-templates/images/save-button.gif',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'save-button.gif save-button.gif root import thingy templates images save button.gif','000001000001000046000005000008'),('8YiMkcz32xalkAn3WBLpag','go-btn.gif','go-btn.gif go-btn.gif root import thingy templates images go btn.gif','root/import/thingy-templates/images/go-btn.gif',1210181860,1210181860,'3','7','12','WebGUI::Asset::File::Image',1,'go-btn.gif go-btn.gif root import thingy templates images go btn.gif','000001000001000046000005000009'),('3n3H85BsdeRQ0I08WmvlOg','thingy.css','thingy.css thingy.css root import thingy templates thingy.css','root/import/thingy-templates/thingy.css',1212091492,1245107956,'3','7','12','WebGUI::Asset::Snippet',0,'thingy.css thingy.css root import thingy templates thingy.css wgThingy  margin:5px  wgThingy  styleButton  color:black margin:0px 5px display:block float:left  wgThingy  spacerOne  padding-left:15px  wgThingy  rowOne wgThingy  tr.rowOne td  background EEEEEE margin:1px border:solid CDCDCD 1px color:#000 padding:2px  wgThingy  rowTwo wgThingy  tr.rowTwo td  background DBDBDB margin:1px border:solid DDDDDD 1px color:#000 padding:2px  wgThingsWrapper img  display:block vertical-align:middle float:left  wgThingsWrapper label  font-weight:bold padding-left:15px  wgThingy h2.title  background 000 height:42px color:white font-size:18px font-weight:bold letter-spacing:1px line-height:42px padding-left:15px margin-bottom:0px  wgThingy  span.smaller  font-size:13px color:white  wgThingy controls  line-height:35px height:35px background f1f1f1 margin-top:0px margin-bottom:20px padding:0px  wgThingy  label  background:black color:white padding:2px 5px font-family:arial font-size:11px font-weight:bold vertical-align:middle  wgThingy label a  color:white  searchTable  input editThing  input  background white border:solid 555 1px  editThing  margin-top:15px  thingyList thingyList   margin:0px padding:0px  thingyList  position:relative float:left  thingyList goButton:link thingyList goButton:visited  padding:2px 25px 2px 2px background F1F1F1 url(^FileUrl(root/import/thingy-templates/images/go-btn.gif no-repeat right line-height:20px border:solid a2a2a2 1px color:#a2a2a2 text-decoration:none font-family:verdana arial font-size:10px font-weight:bold margin-left:20px letter-spacing:0px  thingyList goButton:hover  background-color:white  thingyList things  padding:0px margin:0px width:300px z-index:5000 position:absolute top:27px left:20px border:solid a2a2a2 1px border-top-style:none  thingyList things a:link thingyList things a:visited  display:block background-color:#f1f1f1 border-top:solid a2a2a2 1px border-bottom:solid 727272 1px line-height:12px font-size:10px height:12px padding:2px 5px text-decoration:none font-weight:bold color:#a2a2a2  thingyList things a:hover  background-color:white ','000001000001000046000006'),('5m5I7__l40C4hhv4ydqAHQ','thingy-ie.css','thingy-ie.css thingy-ie.css root import thingy templates thingy ie.css','root/import/thingy-templates/thingy-ie.css',1210181698,1216227786,'3','7','12','WebGUI::Asset::Snippet',0,'thingy-ie.css thingy-ie.css root import thingy templates thingy ie.css thingyList things  padding:0px margin:0px width:200px z-index:5000 position:absolute top:27px left:20px border:solid a2a2a2 1px border-top-style:none  thingyList things a:link thingyList things a:visited  display:block background-color:#f1f1f1 border-top:solid a2a2a2 1px border-bottom:solid 727272 1px line-height:12px font-size:10px height:12px padding:2px 5px text-decoration:none font-weight:bold color:#a2a2a2 width:190px  thingyList things a:hover  background-color:white ','000001000001000046000007'),('4qh0kIsFUdd4Ox-Iu1JZgg','EMS','  ','root/import/ems',1208725439,1208725439,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EMS EMS root import ems','000001000001000012'),('2rC4ErZ3c77OJzJm7O5s3w','EMS Badge Listing (default)','EMS Badge Listing default EMS Badge Listing default root import ems ems badge listing default','root/import/ems/ems-badge-listing-default',1208721232,1242467983,'3','7','12','WebGUI::Asset::Template',0,'EMS Badge Listing default EMS Badge Listing default root import ems ems badge listing default EMS','000001000001000012000003'),('PsFn7dJt4wMwBa8hiE3hOA','Print Badge (Default)','Print Badge Default Print Badge Default root import ems print badge default','root/import/ems/print-badge-default',1208558071,1208558071,'3','7','12','WebGUI::Asset::Template',0,'Print Badge Default Print Badge Default root import ems print badge default EMS/PrintBadge','000001000001000012000004'),('yBwydfooiLvhEFawJb0VTQ','Print Ticket (Default)','Print Ticket Default Print Ticket Default root import ems print ticket default','root/import/ems/print-ticket-default',1208629936,1208629936,'3','7','12','WebGUI::Asset::Template',0,'Print Ticket Default Print Ticket Default root import ems print ticket default EMS/PrintTicket','000001000001000012000005'),('63ix2-hU0FchXGIWkG3tow','Flat Discount (Default)','Flat Discount Default Flat Discount Default root import flat discount default','root/import/flat-discount-default',1209588387,1216169693,'3','7','12','WebGUI::Asset::Template',0,'Flat Discount Default Flat Discount Default root import flat discount default FlatDiscount','000001000001000038000011'),('gbnRhcWNk1iQe32LFEB5eQ','Shelf','Shelf Shelf root import shelf2','root/import/shelf2',1210779723,1212086102,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shelf Shelf root import shelf2','000001000001000037'),('1XOJDcg_ITRYwVM-QnIcPw','shelf.css','shelf.css shelf.css root import shelf2 shelf.css','root/import/shelf2/shelf.css',1210779441,1219175575,'3','7','12','WebGUI::Asset::Snippet',0,'shelf.css shelf.css root import shelf2 shelf.css wgShelf  font-size:12px font-family:arial verdana margin:15px 0px  wgShelf h2  background black padding:5px padding-left:15px line-height:32px color:white margin:0px height:32px  wgShelf wgShelves  background F1F1F1 height:29px padding:3px line-height:29px padding-left:30px  wgShelf product  margin:15px margin-left:0px text-align:left background-color:#f1f1f1 border:solid e1e1e1 1px width 200px display moz-inline-box  Moz  display inline-block  Op Saf IE  vertical-align top  IE Mac non capisce e a volte crea extra v space   wgShelf product thumbnail  display:block text-align:left margin:3px float:left  wgShelf product link  background e1e1e1 height:30px padding:3px line-height:24px margin-bottom:5px text-align:left display:block  wgShelf product link a:link wgShelf product link a:visited  color:#000 display:block  wgShelf product link a:hover  text-decoration:underline  wgShelf product price  display:block text-align:right font-size:18px font-weight:bold ','000001000001000037000003'),('C5fPz-Wg85vkYRvCdl-Xqw','UserList','UserList UserList root import userlist','root/import/userlist',1212160830,1212160830,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'UserList UserList root import userlist','000001000001000049'),('aNmgn0cd6tldmC1FpW4KbA','Shop','Shop Shop shopping cart collateral items','shopping-cart-collateral-items',1213122695,1213122695,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Shop Shop shopping cart collateral items','000001000001000038'),('2q5fxatSFLgIhXaUX-oSvg','bottom-left.jpg','bottom-left.jpg bottom-left.jpg shopping cart collateral items bottom left.jpg','shopping-cart-collateral-items/bottom-left.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'bottom-left.jpg bottom-left.jpg shopping cart collateral items bottom left.jpg','000001000001000038000001'),('_d5WTkKjnwct-_Dk7gZHvQ','bottom-right.jpg','bottom-right.jpg bottom-right.jpg shopping cart collateral items bottom right.jpg','shopping-cart-collateral-items/bottom-right.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'bottom-right.jpg bottom-right.jpg shopping cart collateral items bottom right.jpg','000001000001000038000002'),('Iz2mUR3jCPKyemwAea4b2g','input_bg.jpg','input_bg.jpg input_bg.jpg shopping cart collateral items input bg.jpg','shopping-cart-collateral-items/input_bg.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'input_bg.jpg input_bg.jpg shopping cart collateral items input bg.jpg','000001000001000038000003'),('JU9bjsLRoWj7GVHs__prig','top-left.jpg','top-left.jpg top-left.jpg shopping cart collateral items top left.jpg','shopping-cart-collateral-items/top-left.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'top-left.jpg top-left.jpg shopping cart collateral items top left.jpg','000001000001000038000004'),('noOlnjQGexHg8c4bGVUo9g','top-right.jpg','top-right.jpg top-right.jpg shopping cart collateral items top right.jpg','shopping-cart-collateral-items/top-right.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'top-right.jpg top-right.jpg shopping cart collateral items top right.jpg','000001000001000038000005'),('aIpCmr9Hi__vgdZnDTz1jw','Cart (Default)','Cart Default Cart Default default shopping cart template','default-shopping-cart-template',1209921197,1237379632,'3','7','3','WebGUI::Asset::Template',0,'Cart Default Cart Default default shopping cart template Shop/Cart','000001000001000038000006'),('4e-_rNs6mSWedZhQ_V5kJA','shelf-ie.css','shelf-ie.css shelf-ie.css root import shelf2 shelf ie.css','root/import/shelf2/shelf-ie.css',1210779672,1210779672,'3','7','12','WebGUI::Asset::Snippet',0,'shelf-ie.css shelf-ie.css root import shelf2 shelf ie.css wgShelf product  margin:15px margin-left:0px float:left text-align:left background-color:#f1f1f1 border:solid e1e1e1 1px min-height:100px min-width:200px width:200px height:100px  wgShelf product link  background url(^FileUrl(root/import/shelf2/images/shelf-titles.jpg no-repeat top right height:30px padding:3px line-height:24px margin-bottom:5px text-align:left display:block ','000001000001000037000004'),('2gtFt7c0qAFNU3BG_uvNvg','My Purchases (Default)','My Purchases Default My Purchases Default shopping cart collateral items my purchases default','shopping-cart-collateral-items/my-purchases-default',1211824430,1256702483,'3','7','3','WebGUI::Asset::Template',0,'My Purchases Default My Purchases Default shopping cart collateral items my purchases default Shop/MyPurchases','000001000001000038000008'),('bPz1yk6Y9uwMDMBcmMsSCg','Email Receipt (Default)','Email Receipt Default Email Receipt Default shopping cart collateral items email receipt default','shopping-cart-collateral-items/email-receipt-default',1211829604,1211829604,'3','7','3','WebGUI::Asset::Template',0,'Email Receipt Default Email Receipt Default shopping cart collateral items email receipt default Shop/EmailReceipt','000001000001000038000009'),('EBlxJpZQ9o-8VBOaGQbChA','MiniCart','MiniCart MiniCart shopping cart collateral items minicart','shopping-cart-collateral-items/minicart',1212093746,1212093746,'3','7','3','WebGUI::Asset::Template',0,'MiniCart MiniCart shopping cart collateral items minicart Shop/MiniCart','000001000001000038000014'),('PBtmpl0000000000000053','Subscription code redemption','Subscription code redemption Subscription code redemption subscription code redemption','subscription_code_redemption',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',0,'Subscription code redemption Subscription code redemption subscription code redemption Operation/RedeemSubscription','000001000001000038000017'),('6tK47xsaIH-ELw0IBo0uRQ','images','images images root import shelf2 images','root/import/shelf2/images',1210777115,1210777115,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images images root import shelf2 images','000001000001000037000001'),('XNd7a_g_cTvJVYrVHcx2Mw','Address (Default)','Address Default Address Default shopping cart collateral items address default','shopping-cart-collateral-items/address-default',1212099009,1242306865,'3','7','3','WebGUI::Asset::Template',0,'Address Default Address Default shopping cart collateral items address default Shop/Address','000001000001000038000007'),('_bZJ9LA_KNekZiFPaP2SeQ','shelf-titles.jpg','shelf-titles.jpg shelf-titles.jpg root import shelf2 images shelf titles.jpg','root/import/shelf2/images/shelf-titles.jpg',1210777868,1210777868,'3','7','12','WebGUI::Asset::File::Image',1,'shelf-titles.jpg shelf-titles.jpg root import shelf2 images shelf titles.jpg','000001000001000037000001000001'),('nFen0xjkZn8WkpM93C9ceQ','Shelf (Default)','Shelf Default Shelf Default root import shelf default','root/import/shelf-default',1210779326,1247864696,'3','7','12','WebGUI::Asset::Template',0,'Shelf Default Shelf Default root import shelf default Shelf','000001000001000037000002'),('mTOiwwk3q4k9g5-XykXhPA','Documentation','With any large system, having the right documentation to get you started is mandatory. The good news is that WebGUI has abundant documentation. ','documentation',1215717999,1218149728,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Documentation Documentation documentation With any large system having the right documentation to get you started is mandatory The good news is that WebGUI has abundant documentation','000001000002000005'),('j_1qEqM6iLfQLiR6VKy0aA','Free Documentation','There are hundreds of pages of free documentation available for WebGUI, provided by both Plain Black and the community at large. The following list is by no means comprehensive, but it should get you started in the right direction. \n\n\n\nPrimer - A download','documentation/free-documentation',1215718151,1215718151,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Free Documentation Free Documentation documentation free documentation There are hundreds of pages of free documentation available for WebGUI provided by both Plain Black and the community at large The following list is by no means comprehensive but it should get you started in the right direction Primer  A downloadable PDF that shows you the basics of publishing content in WebGUI Wiki  Hundreds of pages of WebGUI community contributed content featuring a variety of tutorials Worldwide  A collection of WebGUI related web sites from all over the world that have documentation and other resources for WebGUI API Docs  The documentation of all of the WebGUI source code Template Help  The documentation of all of WebGUI\'s template variables  ','000001000002000005000001'),('o_pq_e4vRyhMOKFzs61eag','book-covers.jpg','book-covers.jpg book-covers.jpg documentation book covers.jpg','documentation/book-covers.jpg',1215714957,1215714957,'3','7','3','WebGUI::Asset::File::Image',1,'book-covers.jpg book-covers.jpg documentation book covers.jpg','000001000002000005000002'),('diZvW4bSgZWwyyGP3qXi1g','Commercial Documentation','Plain Black has created a whole line of commercial books which total over 1500 pages of detailed documentation about WebGUI. Both black and white and full color editions of these books are available, and they are updated frequently to keep you on top of t','documentation/commercial-documentation',1215717972,1215717972,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Commercial Documentation Commercial Documentation documentation commercial documentation Plain Black has created a whole line of commercial books which total over 1500 pages of detailed documentation about WebGUI Both black and white and full color editions of these books are available and they are updated frequently to keep you on top of the latest WebGUI features Visit the book store today to stock your WebGUI library Other than hands on training there is no better way to hone your WebGUI skills No matter what your need Plain Black has created a book that\'s right for you and is creating new books each year  ','000001000002000005000003'),('PBEmsBadgeTemplate0000','Default EMS Badge Template','Default EMS Badge Template Default EMS Badge Template default emsbadge','default_emsbadge',1221077977,1221692339,'3','7','4','WebGUI::Asset::Template',0,'Default EMS Badge Template Default EMS Badge Template default emsbadge EMSBadge','000001000001000012000006'),('9A-mg2gwWmaYi9o_1C7ArQ','dashboard','dashboard dashboard root import projectmanager dashboard','root/import/projectmanager/dashboard',1147642478,1222803338,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'dashboard dashboard root import projectmanager dashboard','000001000001000031000001'),('yD1SMHelczihzjEmx6eXBA','editTask','editTask editTask root import projectmanager edittask','root/import/projectmanager/edittask',1147642478,1222803342,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'editTask editTask root import projectmanager edittask','000001000001000031000002'),('pV7GnZdpjR3XpZaSINIoeg','gantt','gantt gantt root import projectmanager gantt','root/import/projectmanager/gantt',1147642478,1222803347,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'gantt gantt root import projectmanager gantt','000001000001000031000003'),('71e17KeduiXgODLMlUxiow','project','project project root import projectmanager project','root/import/projectmanager/project',1147642479,1222803352,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'project project root import projectmanager project','000001000001000031000004'),('vTymIDYL2YqEh6PV50F7ew','manager','manager manager root import timetracking manager','root/import/timetracking/manager',1147642482,1222803302,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'manager manager root import timetracking manager','000001000001000048000001'),('lo1ac3BsoJx3ijGQ3gR-bQ','row','row row root import timetracking row','root/import/timetracking/row',1147642482,1222803309,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'row row root import timetracking row','000001000001000048000002'),('huASapWvFDzqwOSbcN-JFQ','user','user user root import timetracking user','root/import/timetracking/user',1147642483,1222803313,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'user user root import timetracking user','000001000001000048000003'),('xSmREZO3GNzK3M5PaueOOQ','LDAP/Account','LDAP/Account LDAP/Account root import auth ldap account','root/import/auth/ldap/account',1147642466,1222803378,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Account LDAP/Account root import auth ldap account','000001000001000005000001'),('0bx-xoL8TSXXubFuqKAoVQ','LDAP/Create','LDAP/Create LDAP/Create root import auth ldap create','root/import/auth/ldap/create',1147642466,1222803383,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Create LDAP/Create root import auth ldap create','000001000001000005000002'),('taX2UYkFF21ALpFZY2rhMw','LDAP/Login','LDAP/Login LDAP/Login root import auth ldap login','root/import/auth/ldap/login',1147642466,1222803387,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Login LDAP/Login root import auth ldap login','000001000001000005000003'),('K0q_N885Httqev1VCqUWxg','WebGUI/Account','WebGUI/Account WebGUI/Account root import auth webgui account','root/import/auth/webgui/account',1147642466,1222803391,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Account WebGUI/Account root import auth webgui account','000001000001000005000004'),('fq1ZkYhH24R5tb96kuT10Q','WebGUI/Create','WebGUI/Create WebGUI/Create root import auth webgui create','root/import/auth/webgui/create',1147642466,1222803395,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Create WebGUI/Create root import auth webgui create','000001000001000005000005'),('oHk7fAFhEEkB7dHzi0QOQA','WebGUI/Expired','WebGUI/Expired WebGUI/Expired root import auth webgui expired','root/import/auth/webgui/expired',1147642466,1222803399,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Expired WebGUI/Expired root import auth webgui expired','000001000001000005000006'),('9M-lrlPQWeeNWfvnDnK_Xg','WebGUI/Login','WebGUI/Login WebGUI/Login root import auth webgui login','root/import/auth/webgui/login',1147642466,1222803405,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Login WebGUI/Login root import auth webgui login','000001000001000005000007'),('_gBYAdTcbkiyamnqi2Xskg','WebGUI/Recovery','WebGUI/Recovery WebGUI/Recovery root import auth webgui recovery','root/import/auth/webgui/recovery',1147642466,1222803409,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Recovery WebGUI/Recovery root import auth webgui recovery','000001000001000005000008'),('tBL7BWiQRZFed2Y-Zjo9tQ','AdminToggle','AdminToggle AdminToggle root import macro admintoggle','root/import/macro/admintoggle',1147642471,1222803200,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminToggle AdminToggle root import macro admintoggle','000001000001000021000001'),('GdkQpvjRtJqtzOUbwIIQRA','a_account','a_account a_account root import macro a account','root/import/macro/a_account',1147642471,1222803205,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'a_account a_account root import macro a account','000001000001000021000002'),('tnc5iYyynX2hfdEs9D3P8w','EditableToggle','EditableToggle EditableToggle root import macro editabletoggle','root/import/macro/editabletoggle',1147642472,1222803213,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EditableToggle EditableToggle root import macro editabletoggle','000001000001000021000003'),('vgXdBcFTqU7h4wBG1ewdBw','File','File File root import macro file','root/import/macro/file',1147642472,1222803217,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'File File root import macro file','000001000001000021000004'),('hcFlqnXlsmC1ujN6Id0F0A','GroupAdd','GroupAdd GroupAdd root import macro groupadd','root/import/macro/groupadd',1147642473,1222803234,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'GroupAdd GroupAdd root import macro groupadd','000001000001000021000005'),('eRJR52fvlaxfetv3DQkQYw','GroupDelete','GroupDelete GroupDelete root import macro groupdelete','root/import/macro/groupdelete',1147642473,1222803238,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'GroupDelete GroupDelete root import macro groupdelete','000001000001000021000006'),('5HIDHq5lAWHV5gpYGS0zLg','H_homeLink','H_homeLink H_homeLink root import macro h homelink','root/import/macro/h_homelink',1147642473,1222803244,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'H_homeLink H_homeLink root import macro h homelink','000001000001000021000007'),('rYEFwXXo0tkGhQTcbDibvg','LoginToggle','LoginToggle LoginToggle root import macro logintoggle','root/import/macro/logintoggle',1147642473,1222803249,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LoginToggle LoginToggle root import macro logintoggle','000001000001000021000008'),('V3l5S5TtI7wMm1WpIMhvOA','L_loginBox','L_loginBox L_loginBox root import macro l loginbox','root/import/macro/l_loginbox',1147642473,1222803253,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'L_loginBox L_loginBox root import macro l loginbox','000001000001000021000009'),('nqNbSUAhk9Vd1zda2SCz9A','RandomThread','RandomThread RandomThread root import macro randomthread','root/import/macro/randomthread',1147642474,1222803258,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RandomThread RandomThread root import macro randomthread','000001000001000021000010'),('y8XkRdxIperLKkJ3bL5sSQ','r_printable','r_printable r_printable root import macro r printable','root/import/macro/r_printable',1147642474,1222803264,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'r_printable r_printable root import macro r printable','000001000001000021000011'),('UserListTmpl0000000002','UserList with search field selection','UserList with search field selection UserList with search field selection root import userlist userlist with search field selection','root/import/userlist/userlist-with-search-field-selection',1212000800,1228125752,'3','7','12','WebGUI::Asset::Template',0,'UserList with search field selection UserList with search field selection root import userlist userlist with search field selection UserList','000001000001000049000002'),('UserListTmpl0000000003','UserList with multiple search keywords','UserList with multiple search keywords UserList with multiple search keywords root import userlist userlist with multiple search keywords','root/import/userlist/userlist-with-multiple-search-keywords',1212001437,1228125758,'3','7','12','WebGUI::Asset::Template',0,'UserList with multiple search keywords UserList with multiple search keywords root import userlist userlist with multiple search keywords UserList','000001000001000049000003'),('UserListTmpl0000000001','Default UserList','Default UserList Default UserList root import userlist default userlist','root/import/userlist/default-userlist',1212159641,1228125743,'3','7','12','WebGUI::Asset::Template',0,'Default UserList Default UserList root import userlist default userlist UserList','000001000001000049000001'),('BMybD3cEnmXVk2wQ_qEsRQ','Badge Builder (Default)','Badge Builder Default Badge Builder Default root import ems badge builder default','root/import/ems/badge-builder-default',1208530113,1263358862,'3','7','12','WebGUI::Asset::Template',0,'Badge Builder Default Badge Builder Default root import ems badge builder default EMS/BadgeBuilder','000001000001000012000001'),('OOyMH33plAy6oCj_QWrxtg','Lookup Registrant (Default)','Lookup Registrant Default Lookup Registrant Default root import ems lookup registrant default','root/import/ems/lookup-registrant-default',1207951375,1252004440,'3','7','12','WebGUI::Asset::Template',0,'Lookup Registrant Default Lookup Registrant Default root import ems lookup registrant default EMS/LookupRegistrant','000001000001000012000002'),('stevecoolmenu000000001','Site Nav','Site Nav Site Nav webgui7 style3 hierarchical top nav','webgui7/style3/hierarchical-top-nav',1147642505,1224116942,'3','7','12','WebGUI::Asset::Template',0,'Site Nav Site Nav webgui7 style3 hierarchical top nav Navigation','000001000001000054000001'),('7-0-style0000000000051','css03.css','css03.css css03.css style3 css03.css','style3/css03.css',1147642505,1224117026,'3','7','12','WebGUI::Asset::Snippet',0,'css03.css css03.css style3 css03.css body html  margin:0px background-color:#b53018 padding:0px  body a  color:#EE963E;font-weight:bold letter-spacing:1px font-size:8pt  main  width:98 min-width:790px margin:0px padding:0px padding-top:20px padding-bottom:20px position:relative  header  background url(\'^FileUrl(style3/header_bg.jpg repeat-x width:100 margin:0px height:115px  headerTitle  background url(\'^FileUrl(style3/header_left.jpg no-repeat left top height:100 width:100  headerRight  background url(\'^FileUrl(style3/header_right.jpg no-repeat right top width:100 height:100 text-align:right position:relative  headerRight title  position:absolute top:25px left:20px font-family:arial text-align:left  title h1  text-transform:uppercase margin-bottom:0px font-weight:normal font-size:26pt margin-top:0px color:white  title h1 a  color:white text-decoration:none font-size 26pt font-weight normal  title h2  margin:0px font-size:12pt color:#bebebe padding-left:20px  title img  z-index:5  login  position:absolute font-size:8pt top:45 right:150px color:white z-index:6 font-family:arial  login a  color:white font-weight normal letter-spacing 0px  loginBox  font-size:8pt margin:0px display:inline  loginBox input  font-size:8pt  mainBody  width:100 margin:0px height:500px background fff position:relative z-index:0  main > mainBody  height:auto min-height:500px  contentArea  z-index:2 position:relative padding-top:10px padding-left:10px padding-right:20px padding-bottom:20px moz-box-sizing:border-box font-family:verdana font-size:9pt min-height:500px  html main mainBody contentArea  height:1  topCorner  width:100 height:214px position:absolute top:0px left:0px background url(^FileUrl(/style3/main_top.jpg no-repeat z-index:1  bottomCorner  width:100 height:211px position:absolute bottom:59px right:0px background url(\'^FileUrl(style3/main_bottom.jpg no-repeat right z-index:1   html bottomCorner  bottom:58px  footer  width:100 margin:0px background:#000 url(\'^FileUrl(style3/footer_right.jpg no-repeat right top height:57px border-top:solid B53018 2px text-align:right position:relative z-index:0  footer copyright  color:#3b3b3b font-family:arial position:absolute top:20px left:30px font-size:8pt  main yui-skin-sam  font-family:verdana font-size:9pt font-weight:normal ','000001000001000054000002'),('stevestyle000000000003','Style 03','Style 03 Style 03 style 03','style_03',1147642510,1224795533,'3','7','12','WebGUI::Asset::Template',0,'Style 03 Style 03 style 03 style','000001000001000054000020'),('jVKLVakT_iA2010_oEuAwg','Style3 Coolmenu','Style3 Coolmenu Style3 Coolmenu department nav','department_nav',1224116526,1224116526,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3 Coolmenu Style3 Coolmenu department nav','000001000001000054000024'),('UL-ItI4L1Z6-WSuhuXVvsQ','DataTable','DataTable DataTable root import datatable','root/import/datatable',1225139673,1225139673,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'DataTable DataTable root import datatable','000001000001000011'),('3rjnBVJRO6ZSkxlFkYh_ug','Default DataTable Template (YUI)','Default DataTable Template YUI Default DataTable Template YUI root import datatable default datatable template yui','root/import/datatable/default-datatable-template-yui',1225139643,1233861835,'3','7','3','WebGUI::Asset::Template',0,'Default DataTable Template YUI Default DataTable Template YUI root import datatable default datatable template yui DataTable','000001000001000011000001'),('TuYPpHx7TUyk08639Pc8Bg','Default DataTable Template (HTML)','Default DataTable Template HTML Default DataTable Template HTML root import datatable default datatable template html','root/import/datatable/default-datatable-template-html',1225139643,1233861621,'3','7','3','WebGUI::Asset::Template',0,'Default DataTable Template HTML Default DataTable Template HTML root import datatable default datatable template html DataTable','000001000001000011000002'),('IZkrow_zwvbf4FCH-taVTQ','Inbox','Inbox Inbox root import account inbox','root/import/account/inbox',1226011853,1226011853,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Inbox Inbox root import account inbox','000001000001000002000002'),('K0YjxqOqr7RupSo6sIdcAg','Friends','Friends Friends root import account friends','root/import/account/friends',1227074310,1227074310,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Friends Friends root import account friends','000001000001000002000003'),('_ilRXNR3s8F2vGJ_k9ePcg','User','User User root import account user','root/import/account/user',1226643205,1226643205,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'User User root import account user','000001000001000002000004'),('AOjPG2NHgfL9Cq6dDJ7mew','Shop','Shop Shop root import account shop','root/import/account/shop',1226659753,1236960881,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shop Shop root import account shop','000001000001000002000005'),('qaVcU0FFzzraMX_bzELqzw','Contributions','Contributions Contributions root import account contributions','root/import/account/contributions',1227074362,1227074362,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Contributions Contributions root import account contributions','000001000001000002000006'),('matrixtmpl000000000004','Matrix Default Edit Listing','Matrix Default Edit Listing Matrix Default Edit Listing default matrix edit listing template','default-matrix-edit-listing-template',1133743239,1228834590,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Edit Listing Matrix Default Edit Listing default matrix edit listing template Matrix/EditListing','000001000001000022000004'),('kJf77eCr9GAMiEzWrzsBTA','matrix-ie.css','matrix-ie.css matrix-ie.css new matrix matrix ie.css','new-matrix/matrix-ie.css',1229639255,1229639255,'3','7','12','WebGUI::Asset::Snippet',0,'matrix-ie.css matrix-ie.css new matrix matrix ie.css matrixLeft buttons span matrixRight buttons span  padding:0px 0px 0px 0px  matrixLeft buttons button matrixRight buttons a  top:-3px left:-2px height:22px  matrixRight buttons a  color:black text-decoration:none padding:1px 3px ','000001000001000022000007'),('4LQT4-bGW4FkiEQLSY5gvQ','show-hide.js','show-hide.js show-hide.js new matrix show hide.js','new-matrix/show-hide.js',1232400287,1232400287,'3','7','12','WebGUI::Asset::Snippet',0,'show-hide.js show-hide.js new matrix show hide.js function showHide(theLink,theId  var theId = document.getElementById(theId var theLink = document.getElementById(theLink if(theId.style.display == block  theId.style.display = none theLink.innerHTML = Send Creator a Message theLink.className = showLink  else  theId.style.display = block theLink.innerHTML = Hide theLink.className = hideLink  ','000001000001000022000008'),('Vch1Ww7G_JpBhOhXX07RDg','matrx-nav','matrx-nav matrix-nav new matrix matrix nav','new-matrix/matrix-nav',1232664082,1235705952,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'matrx-nav matrix-nav new matrix matrix nav','000001000001000022000010'),('PBtmpl0000000000000063','Default Overview Report','Default Overview Report Default Overview Report root import survey default overview report','root/import/survey/default-overview-report',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Overview Report Default Overview Report root import survey default overview report Survey/Overview','000001000001000044000001'),('HW-sPoDDZR8wBZ0YgFgPtg','images','images images root import account images','root/import/account/images',1227634350,1227634350,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images images root import account images','000001000001000002000009'),('hBpisL-_URyZnh9clR5ohA','no_photo.gif','no_photo.gif no_photo.gif root import account images no photo.gif','root/import/account/images/no_photo.gif',1227634417,1227634417,'3','7','12','WebGUI::Asset::File::Image',1,'no_photo.gif no_photo.gif root import account images no photo.gif','000001000001000002000009000001'),('FOBV6KkifreXa4GmEAUU4A','no_photo_sm.gif','no_photo_sm.gif no_photo_sm.gif root import account images no photo sm.gif','root/import/account/images/no_photo_sm.gif',1227634447,1227634447,'3','7','12','WebGUI::Asset::File::Image',1,'no_photo_sm.gif no_photo_sm.gif root import account images no photo sm.gif','000001000001000002000009000002'),('PBtmpl0000000000000061','Default Survey','Default Survey Default Survey root import survey default survey','root/import/survey/default-survey',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Default Survey root import survey default survey Survey','000001000001000044000003'),('_XfvgNH__bY1ykMiKYSobQ','account.css','account.css account.css root import account account.css','root/import/account/account.css',1233168041,1255485472,'3','7','12','WebGUI::Asset::Snippet',0,'account.css account.css root import account account.css  general  WGbutton  float:right padding-right:10px  centered  text-align center  WGaccount_message  background-color white border solid BECEF8 1px height 300px margin-bottom 10px margin-left 60px margin-top 20px overflow:-moz-scrollbars-vertical overflow-x:hidden overflow-y:scroll padding:10px text-align left vertical-align:top width 90  WGprofileMember  font-size:9px margin-right:20px text-align:right  WGmember  color:#3e4f77 font 9px Verdana Arial Helvetica sans-serif text-align:center  WGphotostyle  border:solid 3e4f77 2px margin-bottom:5px margin-top:5px  rightalign  float right  WGsend  float:right padding-right 75px   bio addtonetwork network  WGbordered  border-bottom dashed BECEF8 2px padding-bottom 10px  WGfriendpic  border solid BECEF8 1px  WGinvitemsg  width 600px height 150px  ol.WGProfile_interests  color:#0B2259 font-size:15px font-weight:bold list-style-type:none margin:0px padding:0px padding:5px 5px  ol.WGProfile_interests li  margin-bottom:15px  ol.WGProfile_interests span  font-size:12px font-weight:normal color:black  WGpBio  border-bottom:solid DDE6FB 1px margin:0px margin-bottom:5px padding-bottom:5px  WGpBio div  background-color:#DDE6FB padding:2px 5px margin-bottom:2px  WGprogram  font-size 9px   contributions  WGContribCount  font-size:12px text-align:left padding:3px  WGContribTitle  background-color:#f2f5fa border solid d8dee8 1px color:#0B2259 font-size:12px font-weight:bold min-height:25px padding:3px text-align:center text-decoration underline  WGContribTitleLeft  background-color:#f2f5fa border solid d8dee8 1px color:#0B2259 font-size:12px font-weight:bold min-height:25px padding:3px text-align:center text-decoration underline  WGContribEntry  text-align:center padding:3px  WGContribEntryLeft  text-align:left padding:3px   edit box  WGeditBox  background:white url(images/edit_box_bg.jpg no-repeat bottom left border:solid 8DABF1 2px display:block font-family:verdana font-size:9px font-weight:bold left:100px moz-box-sizing:border-box padding:5px position:absolute top:100px width:590px z-index:100  WGeditBox input WGeditBox select  font-size:9px   friends  WGfriends_name  font-weight:bold width:90  WGfriends_photo  font-weight:bold width:10  WGfriends_photo img  height 50px width 50px  WGfriends_private  float:right padding-bottom 5px width 50  WGfriends_ninety  vertical-align:top width 90  WGfriends_seventy  vertical-align:top width 70  WGfriends_ten  width 10  WGfriends_ten img  height 50px width 50px  WGfriends_twenty  width 20  WGaccepts  padding-bottom 5px   inbox  WGProfile_msgcontainer  padding:2px  WGinbox_count  font-size:12px font-weight:bold padding:3px text-align:left  WGinbox_errors  font-weight:bold color:red text-align:center  WG_inbox_InviteLabel  width:50px text-align:right  WG_inbox_InviteLabelView  font-weight:bold width:120px  WGmsgcontainer  padding:6px display:block margin-bottom:6px   inbox contacts  WGdatacells  border-bottom dashed BECEF8 1px  WGinbox_contactsTbl  background-color:#EEF2FD font-family:arial font-size:9pt width:100  contacts  height 275px overflow auto   inbox forms  WGbuttons_left  float left  WGbuttons_right  float right  WGinbox_from  color black font-weight normal text-decoration none  WGinbox_subject  width 530px  WGinbox_messageTo  background-color white border solid BECEF8 1px height 50px overflow:-moz-scrollbars-vertical overflow-x:hidden overflow-y:scroll width 530px   inbox pagination  WGinbox_buttons  display:inline float:left font-size:10px text-align:left width:70  WGinbox_pagination  display:inline text-align:right width:20  WGinbox_messagerpp  font-size:10px display:inline text-align:right width:20  WGmessage  display:inline float:left font-size:10px text-align:left width:70  WGmessagerpp  font-size:10px display:inline text-align:right float right  WG-previous-next  float right   inbox threads  WGevenThread  background-color e1e8fb border-bottom 1px solid bfcef9 padding 8px text-align:center  WGoddThread  background-color eef2fd border-bottom 1px solid bfcef9 padding 8px text-align center   pagination  WGProfile_pagination  font-size:10px text-align:right width:20  WGProfile_messagerpp  font-size:10px display:inline text-align:right width:20  WGProfile_paginationLeft  font-size:10px text-align:left width:20  WGProfile_paginationCenter  font-size:10px text-align:center width:20  WGProfile_pagination a  background-color:#f2f5fa border:solid bfc8dc 1px font-size:10px font-weight:bold padding:1px 5px text-decoration:none  WGProfile_pagination a:hover  background-color:#d8dee8 color:white  WGProfile_pagination prevNext  background-color transparent border none color black  WGProfile_pagination prevNext:hover  background-color transparent border none color black  WGProfile_pagination active  background-color:#d8dee8 border:solid bfc8dc 1px color:white font-size:10px font-weight:bold padding:1px 5px text-decoration:none  WGProfile_pagination img  vertical-align:middle margin-top:2px border:none   profile  WGProfile_registration  background:none border:none font-size:9pt font-family:arial margin:0 padding:0 width:100  WGProfile_registration header  background-color:#818997 color:#3e4f77 font-size:10px font-weight:bold text-align:left  WGProfile_registration header a  color:white text-decoration:none  WGProfile_registration help a  font-weight:bold text-decoration:none  WGProfile_registration inputText  font-size:10px margin-right:1px  WGProfile_registration label  font-size:9pt font-weight:bold text-align:right white-space:nowrap width:1  WGProfile_registration labelLeft  font-size:9pt font-weight:bold white-space:nowrap width:1 text-align left vertical-align top  WGProfile_registration smallLabel  font-size:8px text-align:center  WGProfile_registration smallText  font-size:9px  WGinboxTbl  display:block margin 4px padding 2px  WGProfile_registration bar WGProfile_registration barRight  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold margin:10px 0px 10px 0px min-height:25px padding:4px 4px 0px 4px vertical-align:middle  WGProfile_registration bar  text-align center  WGProfile_registration barRight  text-align right  WGProfile_registration bar a  color:#0B2259 font-size:10px font-weight:bold  WGProfile_registration barFive  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold text-align:center margin-right:3px min-height:25px padding:2px width:4.3  WGProfile_registration barTen  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold min-height:25px padding:2px text-align:center width:7.2  WGProfile_registration barFifteen  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold margin-right:3px min-height:25px padding:2px text-align:center width:15  WGProfile_registration barFifty  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold margin-right:3px min-height:25px padding:2px text-align:center width:50  WGbarContainer  display:block margin:10px 0px 10px 0px width:100   profile edit  WGfields  padding 2px  WGfields_left  padding:2px vertical-align:top width 15  WGfields_right  display:inline float:right padding:2px text-align:right width:80 vertical-align top  WGProfile  display:table margin 0 padding 0 width:100  WGProfileFields  border:0 padding 0 margin:0 width 100  WGProfileFields ol  display inline list-style-type none  WGProfileFields ul  list-style-type none display inline  WGProfileFields ul li  display inline-block display inline zoom 1   profile view  WGProfile_accepts  text-align:right background-color:gray padding:4px width:100  WGviewContainer  margin:0 padding:0 width:90  WGinternational  background-color:red color:white display:inline font-weight:bold padding:4px text-align:center  WGcategoryLabel  vertical-align:top width:90  WGprivateMessage  background-color:gray padding:4px text-align:right  WGprofileAlert  background-color:red color:white font-weight:bold padding:4px text-align:center width:100  WGprofilePhoto  vertical-align:top   profile errors  WGprofileErrors  background-color ff0000 color ffffff font-weight bold text-align center  WGprofilefield_required_off   WGprofilefield_required  background-color ffd6bb  WGprofilefield_error  background-color FF9494  WGerrorMsg  font-weight:bold color:red text-align:center   user  WGuserInvite_subject  background-color white border solid BECEF8 1px height 25px text-align left width 500px margin-left 50px margin-bottom 20px overflow:-moz-scrollbars-vertical overflow-x:hidden overflow-y:scroll   view profile  WGprofile_canEdit  text-align:center background-color:red padding:4px color:white font-weight:bold  WGprofile_fieldLabel  background DDE6FB padding:2px width:200px  WGprofile_fieldData  margin-left 5px  WGprofile_fieldStatus  padding:4px color:white font-weight:bold    TABS    TABS  outer  WGbottombutton  float:right padding-right:2px padding-top 2px position relative  WGcontent  padding:10px  WGcleartab  clear both height:0  WGsubContent   color setting for border under outer tabs that surrounds inner tabs  border solid d8dee8 6px  WGtopbutton  float:right clear:both padding-right:2px padding-top 2px position relative  ul.WGtopTabs ul.WGtopTabs li  list-style-type:none margin:10px 0px 0px 0px padding:0px position:relative width:auto Xposition:relative zoom:1  ul.WGtopTabs li  display:block float:left margin-right 3px  ul.WGtopTabs li b  background-color eef2fd border-top:solid d8dee8 1px display:block padding:4px 8px position:relative top:-1px  ul.WGtopTabs a   non-selected tabs color settings  display:block color:#9ea0bb font-size:12px font-family Arial Helvetica sans-serif text-decoration:none background-color:#f2f5fa border-left solid d8dee8 1px border-right solid d8dee8 1px  ul.WGtopTabs a:hover ul.WGtopTabs a:hover b ul.WGtopTabs a.selected ul.WGtopTabs a.selected b   selected tab color settings  background-color:#d8dee8 color:#3e4f77  text-align right  TABS  YUI  WGcleardiv  clear both margin 0px 0px 0px 0px padding 0px  WGviewProfile wgView  border none font bold 10px Verdana color 3e4f77 text-decoration:none  WGview  position absolute right 4px top:4px  WGprofile_displayView  x-system-font:none border:medium none color:#0B2258 display:inline float:right font-family:Verdana font-size:10px font-size-adjust:none font-stretch:normal font-style:normal font-variant:normal font-weight:bold line-height:normal padding-right:8px padding-top:3px text-decoration none  WGprofile_displaySubContent   border around friends tab content  border solid d8dee8 6px border-top solid d8dee8 18px   Copyright c 2008 Yahoo Inc All rights reserved Code licensed under the BSD License http://developer.yahoo.net/yui/license.txt version 2.6.0   yui tabs color settings below   yui-navset defaults to yui-navset-top  WGsubContent yui-skin-sam yui-navset yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav   protect nested tabviews from other orientations  border:solid eef2fd  color between tab list and content  border-width:0 0 5px Xposition:relative zoom:1  WGsubContent yui-skin-sam yui-navset yui-nav a WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav a  background:#ffffff  tab background  border:solid ffffff border-width:0 1px color:#bfccdd position:relative text-decoration:none font-size:12px font-family Arial Helvetica sans-serif font-weight bold  WGsubContent yui-skin-sam yui-navset yui-nav a em WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav a em  border:solid eef2fd border-width:1px 0 0 cursor:hand padding:0.25em 75em left:0 right 0 bottom 0  protect from other orientations  top:-1px  for 1px rounded corners  position:relative  WGsubContent yui-skin-sam yui-navset yui-nav selected a WGsubContent yui-skin-sam yui-navset yui-nav selected a:focus  no focus effect for selected  WGsubContent yui-skin-sam yui-navset yui-nav selected a:hover   no hover effect for selected  background eef2fd  selected tab background  color 3e4f77 font-size:12px font-family Arial Helvetica sans-serif text-decoration:none font-weight bold  WGsubContent yui-skin-sam yui-navset yui-nav selected a WGsubContent yui-skin-sam yui-navset yui-nav selected a em  border-color:#eef2fd  selected tab border color   WGsubContent yui-skin-sam yui-navset yui-nav a:hover WGsubContent yui-skin-sam yui-navset yui-nav a:focus  background eef2fd  hover tab background  color 3e4f77 outline:0 font-size:12px font-family Arial Helvetica sans-serif text-decoration:none font-weight bold  WGsubContent yui-skin-sam yui-navset yui-content  background eef2fd  content background color   WGsubContent yui-skin-sam yui-navset yui-content WGsubContent yui-skin-sam yui-navset yui-navset-top yui-content  border:5px solid eef2fd  content border  padding:0.75em 1em  content padding    left and right orientations  WGsubContent yui-skin-sam yui-navset-left yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav WGsubContent yui-skin-sam yui-navset-right yui-nav  border-width:0 5px 0 0 Xposition:absolute  from tabview-core have to reiterate for skin-sam due to pos:rel on skin-sam yui-nav  top:0 bottom:0  stretch to fill content height   WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav WGsubContent yui-skin-sam yui-navset-right yui-nav  border-width:0 0 0 5px  WGsubContent yui-skin-sam yui-navset-left yui-nav li WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav li WGsubContent yui-skin-sam yui-navset-right yui-nav li  margin:0 0 0.3em  space between tabs  padding:0 0 0 1px  gecko make room for overflow   WGsubContent yui-skin-sam yui-navset-right yui-nav li  padding:0 1px 0 0  gecko make room for overflow   WGsubContent yui-skin-sam yui-navset-left yui-nav selected WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav selected  margin:0 1px 0.16em 0  WGsubContent yui-skin-sam yui-navset-right yui-nav selected  margin:0 0 0.16em 1px  WGsubContent yui-skin-sam yui-navset-left yui-nav a WGsubContent yui-skin-sam yui-navset-right yui-nav a  border-width:1px 0  WGsubContent yui-skin-sam yui-navset-left yui-nav a em WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav a em WGsubContent yui-skin-sam yui-navset-right yui-nav a em  border-width:0 0 0 1px padding:0.2em 75em top:auto left:-1px  for 1px rounded corners   WGsubContent yui-skin-sam yui-navset-right yui-nav a em  border-width:0 1px 0 0 left:auto right:-1px  for 1px rounded corners   WGsubContent yui-skin-sam yui-navset-left yui-nav a WGsubContent yui-skin-sam yui-navset-left yui-nav selected a WGsubContent yui-skin-sam yui-navset-left yui-nav a:hover WGsubContent yui-skin-sam yui-navset-right yui-nav a WGsubContent yui-skin-sam yui-navset-right yui-nav selected a WGsubContent yui-skin-sam yui-navset-right yui-nav a:hover WGsubContent yui-skin-sam yui-navset-bottom yui-nav a WGsubContent yui-skin-sam yui-navset-bottom yui-nav selected a WGsubContent yui-skin-sam yui-navset-bottom yui-nav a:hover  background-image:none  no left-right or bottom-top gradient   WGsubContent yui-skin-sam yui-navset-left yui-content  border:1px solid d8dee8  content border    bottom orientation  WGsubContent yui-skin-sam yui-navset-bottom yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav  border-width:5px 0 0  color between tab list and content   WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav selected WGsubContent yui-skin-sam yui-navset-bottom yui-nav selected  margin:-1px 0.3em 0 0  for overlap   WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav li WGsubContent yui-skin-sam yui-navset-bottom yui-nav li  padding:0 0 1px 0  gecko make room for overflow  vertical-align:top  WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav li a WGsubContent yui-skin-sam yui-navset-bottom yui-nav li a   WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav a em WGsubContent yui-skin-sam yui-navset-bottom yui-nav a em  border-width:0 0 1px top:auto bottom:-1px  for 1px rounded corners   WGsubContent yui-skin-sam yui-navset-bottom yui-content WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-content  border:1px solid f2f5fa  content border   WGsubContent yui-skin-sam  background-color d8dee8 padding 10px 5 5 5px display:block   yui tab placement settings below  WGsubContent yui-skin-sam yui-navset yui-nav li WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav li  margin:0 0.3em 0 0  space between tabs  padding:5px 0 0  gecko make room for overflow  zoom:1  WGsubContent yui-skin-sam yui-navset yui-nav selected WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav selected  margin:0 0.3em 1px 0  for overlap   WGsubContent yui-navset yui-nav li,.yui-navset yui-navset-top yui-nav li WGsubContent yui-navset yui-navset-bottom yui-nav li  margin:0 0.5em 0 0  WGsubContent yui-navset-left yui-nav li,.yui-navset-right yui-nav li  margin:0 0 0.5em  WGsubContent yui-navset yui-content yui-hidden  display:none  WGsubContent yui-navset yui-navset-left yui-nav,.yui-navset yui-navset-right yui-nav WGsubContent yui-navset-left yui-nav,.yui-navset-right yui-nav  width:6em  WGsubContent yui-navset-top yui-nav,.yui-navset-bottom yui-nav  width:auto  WGsubContent yui-navset yui-navset-left,.yui-navset-left  padding:0 0 0 6em  WGsubContent yui-navset-right  padding:0 6em 0 0  WGsubContent yui-navset-top,.yui-navset-bottom  padding:auto  WGsubContent yui-nav,.yui-nav li  list-style:none margin:0 padding:0  WGsubContent yui-navset li em  font-style:normal  WGsubContent yui-navset  position:relative zoom:1  WGsubContent yui-navset yui-content  zoom:1  WGsubContent yui-navset yui-nav li,.yui-navset yui-navset-top yui-nav li WGsubContent yui-navset yui-navset-bottom yui-nav li  display:inline-block display:-moz-inline-stack display:inline vertical-align:bottom cursor:pointer zoom:1  WGsubContent yui-navset-left yui-nav li,.yui-navset-right yui-nav li  display:block  WGsubContent yui-navset yui-nav a  position:relative  WGsubContent yui-navset yui-nav li a,.yui-navset-top yui-nav li a WGsubContent yui-navset-bottom yui-nav li a  display:block display:inline-block vertical-align:bottom zoom:1  WGsubContent yui-navset-left yui-nav li a,.yui-navset-right yui-nav li a  display:block  WGsubContent yui-navset-bottom yui-nav li a  vertical-align:text-top  WGsubContent yui-navset yui-nav li a em,.yui-navset-top yui-nav li a em WGsubContent yui-navset-bottom yui-nav li a em  display:block  WGsubContent yui-navset yui-navset-left yui-nav,.yui-navset yui-navset-right yui-nav WGsubContent yui-navset-left yui-nav,.yui-navset-right yui-nav  position:absolute z-index:1  WGsubContent yui-navset-top yui-nav,.yui-navset-bottom yui-nav  position:static  WGsubContent yui-navset yui-navset-left yui-nav,.yui-navset-left yui-nav  left:0 right:auto  WGsubContent yui-navset yui-navset-right yui-nav,.yui-navset-right yui-nav  left:auto right:0  WGsubContent yui-skin-sam yui-navset yui-nav selected a em  padding:0.35em 0.75em  WGsubContent yui-skin-sam yui-navset-left yui-nav,.yui-skin-sam yui-navset yui-navset-left yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav,.yui-skin-sam yui-navset-right yui-nav  border-width:0 5px 0 0 bottom:0 top:0 Xposition:absolute  WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav,.yui-skin-sam yui-navset-right yui-nav  border-width:0 0 0 5px  WGsubContent yui-skin-sam yui-navset-left yui-nav li,.yui-skin-sam yui-navset yui-navset-left yui-nav li WGsubContent yui-skin-sam yui-navset-right yui-nav li  margin:0 0 0.16em padding:0 0 0 1px  WGsubContent yui-skin-sam yui-navset-right yui-nav li  padding:0 1px 0 0  WGsubContent yui-skin-sam yui-navset-left yui-nav a,.yui-skin-sam yui-navset-right yui-nav a  border-width:1px 0  WGsubContent yui-skin-sam yui-navset-left yui-nav a em,.yui-skin-sam yui-navset yui-navset-left yui-nav a em,.yui-skin-sam yui-navset-right yui-nav a em  border-width:0 0 0 1px left:-1px padding:0.2em 75em top:auto  WGsubContent yui-skin-sam yui-navset-right yui-nav a em  border-width:0 1px 0 0 left:auto right:-1px  WGsubContent yui-skin-sam yui-navset-left yui-nav a,.yui-skin-sam yui-navset-left yui-nav selected a,.yui-skin-sam yui-navset-left yui-nav a:hover WGsubContent yui-skin-sam yui-navset-right yui-nav a,.yui-skin-sam yui-navset-right yui-nav selected a,.yui-skin-sam yui-navset-right yui-nav a:hover WGsubContent yui-skin-sam yui-navset-bottom yui-nav a,.yui-skin-sam yui-navset-bottom yui-nav selected a WGsubContent yui-skin-sam yui-navset-bottom yui-nav a:hover  background-image:none  WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav selected WGsubContent yui-skin-sam yui-navset-bottom yui-nav selected  margin:-1px 0.16em 0 0  WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav li WGsubContent yui-skin-sam yui-navset-bottom yui-nav li  padding:0 0 1px 0 vertical-align:top ','000001000001000002000008'),('zb_OPKNqcTuIjdvvbEkRjw','article.css','article.css article.css article.css','article.css',1247484073,1255485472,'3','7','12','WebGUI::Asset::Snippet',0,'article.css article.css article.css  styles for the article asset  withImage articleContent linkedImage articleContent  width:100 overflow:hidden  withImage articleImage linkedImage articleImage  float:right margin:0 0 10px 10px  linkedImage caption  display:block ','000001000001000004000005'),('XdlKhCDvArs40uqBhvzR3w','Article With Pagination','Article With Pagination Article With Pagination article with pagination','article-with-pagination',1255485472,1259128608,'3','7','12','WebGUI::Asset::Template',0,'Article With Pagination Article With Pagination article with pagination Article','000001000001000004000006'),('PBtmpl0000000000000210','Request Tracker Post Form','Request Tracker Post Form Request Tracker Post Form request tracker template2','request-tracker-template2',1147642410,1255485474,'3','7','12','WebGUI::Asset::Template',0,'Request Tracker Post Form Request Tracker Post Form request tracker template2 Collaboration/PostForm','000001000001000008000028'),('VyCINX2KixKYr2pzQGX9Mg','layout.css','layout.css layout.css layout.css','layout.css',1246968584,1255485472,'3','7','12','WebGUI::Asset::Snippet',0,'layout.css layout.css layout.css  styles for the layout asset  wg-left  float left  wg-right  float right  wg-clear  clear both  sidebyside wg-content-position oneovertwo wg-content-position  width 49  oneovertwo wg-top  width 100  oneoverthree wg-first-column oneoverthree wg-second-column oneoverthree wg-third-column threeColumns wg-first-column threeColumns wg-second-column threeColumns wg-third-column  width 32  oneoverthree wg-first-column threeColumns wg-first-column  margin-right:2  rightcolumn wg-first-column  width 65  rightcolumn wg-second-column  width 33 ','000001000001000019000006'),('VCFhB9WOsDsH2Apj3c6DpQ','Three Columns','Three Columns Three Columns three columns','three-columns',1255485472,1259128609,'3','7','12','WebGUI::Asset::Template',0,'Three Columns Three Columns three columns Layout','000001000001000057'),('jmlI9IK-lV8n2WMYmmPhAA','Ad Sku','Ad Sku Ad Sku root import ad sku','root/import/ad-sku',1238106173,1238106173,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Ad Sku Ad Sku root import ad sku','000001000001000001'),('AldPGu0u-jm_5xK13atCSQ','Default Purchase Ad Sku Template','Default Purchase Ad Sku Template Default Purchase Ad Sku Template root import ad sku default purchase ad sku template','root/import/ad-sku/default-purchase-ad-sku-template',1238106805,1251419124,'3','7','12','WebGUI::Asset::Template',0,'Default Purchase Ad Sku Template Default Purchase Ad Sku Template root import ad sku default purchase ad sku template AdSku/Purchase','000001000001000001000001'),('ohjyzab5i-yW6GOWTeDUHg','Default Manage Ad Sku Template','Default Manage Ad Sku Template Default Manage Ad Sku Template root import ad sku default manage ad sku template','root/import/ad-sku/default-manage-ad-sku-template',1238106805,1251425384,'3','7','12','WebGUI::Asset::Template',0,'Default Manage Ad Sku Template Default Manage Ad Sku Template root import ad sku default manage ad sku template AdSku/Manage','000001000001000001000002'),('PBtmpl0000000000000015','Default WebGUI Welcome Message Template','Default WebGUI Welcome Message Template Default WebGUI Welcome Message Template root import auth webgui create default webgui welcome message template','root/import/auth/webgui/create/default-webgui-welcome-message-template',1237647040,1237647040,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Welcome Message Template Default WebGUI Welcome Message Template root import auth webgui create default webgui welcome message template Auth/WebGUI/Welcome','000001000001000005000005000002'),('PBtmpl0000000000000016','Default WebGUI Account Activation Template','Default WebGUI Account Activation Template Default WebGUI Account Activation Template root import auth webgui create default webgui account activation template','root/import/auth/webgui/create/default-webgui-account-activation-template',1237407798,1250243000,'3','7','3','WebGUI::Asset::Template',0,'Default WebGUI Account Activation Template Default WebGUI Account Activation Template root import auth webgui create default webgui account activation template Auth/WebGUI/Activation','000001000001000005000005000003'),('wrq7hMxb1ewQqZ46xmd8Gg','equal-cols.js','equal-cols.js equal-cols.js matrix equal cols.js','matrix/equal-cols.js',1235706620,1235706620,'3','7','12','WebGUI::Asset::Snippet',0,'equal-cols.js equal-cols.js matrix equal cols.js function equalCol  var colOne = document.getElementById(\'compareForm var colTwo = document.getElementById(\'matrixRight var colOneH = colOne.offsetHeight var colTwoH = colTwo.offsetHeight alert(colOneH +   + colTwoH colOne.style.overflow = scroll colOne.style.height = colTwoH  150 + px ','000001000001000022000011'),('matrixtmpl000000000007','Matrix Default Screenshots Config','Matrix Default Screenshots Config Matrix Default Screenshots Config matrix default screenshots config','matrix-default-screenshots-config',1236594030,1242660972,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Screenshots Config Matrix Default Screenshots Config matrix default screenshots config Matrix/ScreenshotsConfig','000001000001000022000012'),('matrixtmpl000000000006','Matrix Default Screenshots','Matrix Default Screenshots Matrix Default Screenshots matrix default screenshots','matrix-default-screenshots',1236889702,1236889702,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Screenshots Matrix Default Screenshots matrix default screenshots Matrix/Screenshots','000001000001000022000013'),('RSAMkc6WQmfRE3TOr1_3Mw','ExpireIncompleteSurveyResponses','ExpireIncompleteSurveyResponses ExpireIncompleteSurveyResponses root import expireincompletesurveyresponses','root/import/expireincompletesurveyresponses',1234828062,1250243000,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ExpireIncompleteSurveyResponses ExpireIncompleteSurveyResponses root import expireincompletesurveyresponses','000001000001000044000011'),('ExpireIncResptmpl00001','ExpireIncompleteSurveyResponses','ExpireIncompleteSurveyResponses ExpireIncompleteSurveyResponses root import expireincompletesurveyresponses expireincompletesurveyresponses','root/import/expireincompletesurveyresponses/expireincompletesurveyresponses',1236752721,1250243000,'3','7','12','WebGUI::Asset::Template',0,'ExpireIncompleteSurveyResponses ExpireIncompleteSurveyResponses root import expireincompletesurveyresponses expireincompletesurveyresponses ExpireIncompleteSurveyResponses','000001000001000044000011000001'),('NBVSVNLp9X_bV7WrCprtCA','Annotate Image','Annotate Image Annotate Image image3','image3',1237842096,1237842096,'3','7','12','WebGUI::Asset::Template',0,'Annotate Image Annotate Image image3 ImageAsset','000001000001000017000002'),('qsG6B24a0SC5KrhQjmdZBw','survey.css','survey.css survey.css survey.css','survey.css',1233860274,1250243000,'3','7','12','WebGUI::Asset::Snippet',0,'survey.css survey.css survey.css body  margin 0 background-repeat repeat-y background-position 0px 0px  survey-header  width 80 height 20px margin-left 80px  survey  margin-left 80px width 85  div.dateanswer  overflow auto  div.slider-bg  position relative background:url(/extras/wobject/Survey/bg-fader-500.gif 5px 0 no-repeat height:68px width:529px  div.slider-thumb  cursor:default position absolute top 30px left 4px  div.slider-min-thumb  cursor:default position absolute top 4px  div.slider-max-thumb  cursor:default position absolute top 4px  headertitle  display none  headertext  display none  questions  display none  input.mcbutton font-size 10px font-weight bold text-decoration none background-color CCCCCC background-repeat repeat-x text-align center display block margin 0.5em padding 8em min-width 60px font-family Verdana Arial Helvetica sans-serif color 000000 background-image url(/extras/wobject/Survey/gradient-glossy.png  input.mcbutton:hover background-color B6D2F1 font-family Verdana Arial Helvetica sans-serif font-size 10px color 000000  input.mcbutton-selected background-color 172D9D background-repeat repeat-x color FFFFFF font-family Verdana Arial Helvetica sans-serif font-size 10px margin 0.5em padding 8em width 60px text-align center display block font-weight bold background-image url(/extras/wobject/Survey/gradient-glossy.png background-position 0px 0px   By default the marker for invalid required fields is a red   survey-invalid-marker  color FF0000  survey  font-family Verdana Arial Helvetica sans-serif font-size 10px border 3px solid 1e1e1e  survey survey-header  background-color cfcfcf padding-top 1px  survey headertitle  padding-left 5px  survey progress  position relative top 26px right 5px text-align right font-style italic  survey progress:before  content Progress   survey headertext  border-bottom 2px solid 1e1e1e padding 5px position relative top 20px  survey questions  position relative top 20px  survey question  background-color dfdfdf padding 10px 5px 10px 5px  survey question p:before  content Q   survey scale:before  content A   survey submitbutton  margin-left 5px  restartMessage  color FF0000  chart  float left width 200px height 113px ','000001000001000044000010'),('6uvSLY-ak_w4p_wS8q33cA','Carousel','Carousel Carousel root import carousel','root/import/carousel',1239213092,1239213092,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Carousel Carousel root import carousel','000001000001000007'),('CarouselTmpl0000000001','Default Carousel','Default Carousel Default Carousel root import carousel carousel default','root/import/carousel/carousel-default',1239290719,1250809023,'3','7','12','WebGUI::Asset::Template',0,'Default Carousel Default Carousel root import carousel carousel default Carousel','000001000001000007000001'),('CarouselTmpl0000000002','Carousel hidden textareas','Carousel hidden textareas Carousel hidden textareas root import carousel carousel hidden textareas','root/import/carousel/carousel-hidden-textareas',1238878995,1239475937,'3','7','12','WebGUI::Asset::Template',0,'Carousel hidden textareas Carousel hidden textareas root import carousel carousel hidden textareas Carousel','000001000001000007000002'),('GaBAW-2iVhLMJaZQzVLE5A','ThingyRecord Templates','ThingyRecord Templates ThingyRecord Templates root import thingyrecord templates','root/import/thingyrecord-templates',1240103565,1240103565,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'ThingyRecord Templates ThingyRecord Templates root import thingyrecord templates','000001000001000047'),('TKmhv8boP3TD2xwSwUBq0g','Default ThingyRecord View','Default ThingyRecord View Default ThingyRecord View home thinyrecord templates default thingyrecord view','home/thinyrecord-templates/default-thingyrecord-view',1240103436,1250243000,'3','7','3','WebGUI::Asset::Template',0,'Default ThingyRecord View Default ThingyRecord View home thinyrecord templates default thingyrecord view ThingyRecord/View','000001000001000047000001'),('fowHfgOkJtAxdst7rugTog','Story Manager','Story Manager Story Manager root import storymanager','root/import/storymanager',1236184911,1250243000,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Story Manager Story Manager root import storymanager','000001000001000042'),('3QpYtHrq_jmAk1FNutQM5A','Story Template','Story Template Story Template root import storymanager storytemplate','root/import/storymanager/storytemplate',1239237827,1252186123,'3','7','4','WebGUI::Asset::Template',0,'Story Template Story Template root import storymanager storytemplate Story','000001000001000042000001'),('yxD5ka7XHebPLD-LXBwJqw','StoryArchive','StoryArchive StoryArchive root import storymanager storyarchive','root/import/storymanager/storyarchive',1239918573,1250243000,'3','7','4','WebGUI::Asset::Template',0,'StoryArchive StoryArchive root import storymanager storyarchive StoryArchive','000001000001000042000002'),('A16v-YjWAShXWvSACsraeg','StoryTopic','StoryTopic StoryTopic root import storymanager storytopic','root/import/storymanager/storytopic',1239918710,1254284570,'3','7','4','WebGUI::Asset::Template',0,'StoryTopic StoryTopic root import storymanager storytopic StoryTopic','000001000001000042000005'),('0EAJ9EYb9ap2XwfrcXfdLQ','Story Archive Asset List','Story Archive Asset List Story Archive Asset List root import storymanager keywordlist','root/import/storymanager/keywordlist',1240262820,1250243000,'3','7','4','WebGUI::Asset::Template',0,'Story Archive Asset List Story Archive Asset List root import storymanager keywordlist StoryArchive/KeywordList','000001000001000042000006'),('9j0_Z1j3Jd0QBbY2akb6qw','Default Map View','Default Map View Default Map View home map map templates default map view','home/map/map-templates/default-map-view',1238053232,1256702482,'3','7','3','WebGUI::Asset::Template',0,'Default Map View Default Map View home map map templates default map view Map/View','000001000001000020000001'),('oHh0UqAJeY7u2n--WD-BAA','Default Edit Map Point','Default Edit Map Point Default Edit Map Point home map map templates default edit map point','home/map/map-templates/default-edit-map-point',1238040667,1250724545,'3','7','3','WebGUI::Asset::Template',0,'Default Edit Map Point Default Edit Map Point home map map templates default edit map point MapPoint/Edit','000001000001000020000002'),('u9vfx33XDk5la1-QC5FK7g','Default Map Point View','Default Map Point View Default Map Point View home map map templates default map point view','home/map/map-templates/default-map-point-view',1238048383,1250723423,'3','7','3','WebGUI::Asset::Template',0,'Default Map Point View Default Map Point View home map map templates default map point view MapPoint/View','000001000001000020000003'),('kwTL1SWCk0GlpiJ5zAAEPQ','surveyedit.css','surveyedit.css surveyedit.css root import survey surveyedit.css','root/import/survey/surveyedit.css',1244488512,1250243000,'3','7','12','WebGUI::Asset::Snippet',0,'surveyedit.css surveyedit.css root import survey surveyedit.css editor_container  visibility hidden z-index 100  loading-mask  position absolute left 0 top 0 width 100 height 100 z-index 20000 background-color white opacity:0.6 filter:alpha(opacity=60  loading  position absolute left 50 top 50 padding 2px z-index 20001 height auto margin 35px 0 0 30px  loading loading-indicator  background url(^Extras(\"wobject/Survey/rel_interstitial_loading.gif no-repeat color 555 font bold 13px tahoma,arial,helvetica padding 18px 80px margin 0 text-align center height auto z-index 20002  div.testarea  width 200px height 100px z-index 999 border 1px solid gray background f7f7f7 position absolute top 5 left:5  div.trashcan  border 1px solid gray width 175px height 50px  div.editarea  margin-top:40px padding:10px float:left border 1px solid gray  div.editquestion  padding:10px float:left  div.editanswer  padding:10px float:left  submitbutton  padding:20px  div.entry  padding-bottom:10px padding-left:10px  ul.draglist  list-style none margin:0 padding:0  ul.draglist li  margin 1px  ul.questionList  position relative background f7f7f7 border 1px solid gray list-style none margin:0 padding:0 min-height 40px  li.section  background-color CCCCFF border:1px solid 7EA6B2 cursor move min-height 10px  li.question  background-color D1E6EC border:1px solid 7EA6B2 cursor move padding-left:10px min-height 10px  li.answer  background-color F1FFB8 border:1px solid 7EA6B2 cursor move padding-left:15px min-height 10px  sections-panel li.selected  background-image url(^Extras(\"toolbar/bullet/moveRight.gif background-position:99 center background-repeat no-repeat font-weight:bold  goto-yui-ac  width:15em margin-top:0.5em  wGwarning  background-color:#FF6666 border:1px solid red margin:5px padding:10px  warning  padding 5px  sections-panel bd  overflow auto background-color:#fff padding:10px  buttons  height 30px  sections-panel_c yui-resize yui-resize-handle-r  right 6px  make room for the scroll-bars   sections-panel div.ft  font-size 100 ','000001000001000044000014'),('YP9WaMPJHvCJl-YwrLVcPw','Progress Bar','Progress Bar Progress Bar admin progress bar','admin_progress_bar',1245376837,1245376837,'3','7','12','WebGUI::Asset::Template',0,'Progress Bar Progress Bar admin progress bar AdminConsole/ProgressBar','000001000001000029'),('i5kt5aodVs_oepNEkE7Okw','poll.css','poll.css poll.css poll.css','poll.css',1242312883,1242312883,'3','7','12','WebGUI::Asset::Snippet',0,'poll.css poll.css poll.css styles for the poll asset pollColor  background-color:#808080  pollOptions pollSubmit  border:0 margin:0 padding:0 ','000001000001000027000002'),('PcRRPhh-0KfvLLNIPdxJTw','webgui.css','webgui.css webgui.css webgui.css','webgui.css',1247055282,1247055282,'3','7','3','WebGUI::Asset::Snippet',0,'webgui.css webgui.css webgui.css wg-icon  border 0px none vertical-align middle  wg-clear  clear both  ul.wg-inline  margin:0 padding:0  ul.wg-inline li  display inline margin:0 padding:0  ul.wg-inline li.active  font-weight:bold ','000001000001000051'),('FJbUTvZ2nUTn65LpW6gjsA','Profile Account Layout','Profile Account Layout Profile Account Layout root import account profile profile account layout','root/import/account/profile/profile-account-layout',1227070381,1255485472,'3','7','12','WebGUI::Asset::Template',0,'Profile Account Layout Profile Account Layout root import account profile profile account layout Account/Layout','000001000001000002000001000001'),('75CmQgpcCSkdsL-oawdn3Q','Default Edit Profile Template','Default Edit Profile Template Default Edit Profile Template root import account profile default edit profile template','root/import/account/profile/default-edit-profile-template',1227052575,1248549085,'3','7','12','WebGUI::Asset::Template',0,'Default Edit Profile Template Default Edit Profile Template root import account profile default edit profile template Account/Profile/Edit','000001000001000002000001000002'),('2CS-BErrjMmESOtGT90qOg','Default View Profile Template','Default View Profile Template Default View Profile Template root import account profile default view profile template','root/import/account/profile/default-view-profile-template',1227070888,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default View Profile Template Default View Profile Template root import account profile default view profile template Account/Profile/View','000001000001000002000001000003'),('MBmWlA_YEA2I6D29OMGtRg','Default Profile Error Template','Default Profile Error Template Default Profile Error Template root import account profile default profile error template','root/import/account/profile/default-profile-error-template',1226542675,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Profile Error Template Default Profile Error Template root import account profile default profile error template Account/Profile/Error','000001000001000002000001000004'),('gfZOwaTWYjbSoVaQtHBBEw','Inbox Account Layout','Inbox Account Layout Inbox Account Layout root import account inbox account layout','root/import/account/inbox-account-layout',1226974679,1249407461,'3','7','12','WebGUI::Asset::Template',0,'Inbox Account Layout Inbox Account Layout root import account inbox account layout Account/Layout','000001000001000002000002000001'),('c8xrwVuu5QE0XtF9DiVzLw','Default Inbox View Template','Default Inbox View Template Default Inbox View Template root import account inbox default inbox view template','root/import/account/inbox/default-inbox-view-template',1226894351,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox View Template Default Inbox View Template root import account inbox default inbox view template Account/Inbox/View','000001000001000002000002000002'),('0n4HtbXaWa_XJHkFjetnLQ','Default Inbox View Message Template','Default Inbox View Message Template Default Inbox View Message Template root import account inbox default inbox view message template','root/import/account/inbox/default-inbox-view-message-template',1226894994,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox View Message Template Default Inbox View Message Template root import account inbox default inbox view message template Account/Inbox/ViewMessage','000001000001000002000002000003'),('ErEzulFiEKDkaCDVmxUavw','Default Inbox Error Template','Default Inbox Error Template Default Inbox Error Template root import account inbox default inbox error template','root/import/account/inbox/default-inbox-error-template',1226895484,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox Error Template Default Inbox Error Template root import account inbox default inbox error template Account/Inbox/Error','000001000001000002000002000004'),('6uQEULvXFgCYlRWnYzZsuA','Default Inbox Send Message Template','Default Inbox Send Message Template Default Inbox Send Message Template root import account inbox default inbox send message template','root/import/account/inbox/default-inbox-send-message-template',1226896682,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox Send Message Template Default Inbox Send Message Template root import account inbox default inbox send message template Account/Inbox/SendMessage','000001000001000002000002000005'),('DUoxlTBXhVS-Zl3CFDpt9g','Default Message Confirm Template','Default Message Confirm Template Default Message Confirm Template root import account inbox default message confirm template','root/import/account/inbox/default-message-confirm-template',1226896802,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Message Confirm Template Default Message Confirm Template root import account inbox default message confirm template Account/Inbox/Confirm','000001000001000002000002000006'),('1Q4Je3hKCJzeo0ZBB5YB8g','Default Manage Invitations Template','Default Manage Invitations Template Default Manage Invitations Template root import account inbox default manage invitations template','root/import/account/inbox/default-manage-invitations-template',1226898445,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Manage Invitations Template Default Manage Invitations Template root import account inbox default manage invitations template Account/Inbox/ManageInvitations','000001000001000002000002000007'),('5A8Hd9zXvByTDy4x-H28qw','Default Invitation Confirmation Template','Default Invitation Confirmation Template Default Invitation Confirmation Template root import account inbox default invitation confirmation template','root/import/account/inbox/default-invitation-confirmation-template',1226899462,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invitation Confirmation Template Default Invitation Confirmation Template root import account inbox default invitation confirmation template Account/Inbox/Confirm','000001000001000002000002000008'),('VBkY05f-E3WJS50WpdKd1Q','Default View Invitation Template','Default View Invitation Template Default View Invitation Template root import account inbox default view invitation template','root/import/account/inbox/default-view-invitation-template',1226899241,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default View Invitation Template Default View Invitation Template root import account inbox default view invitation template Account/Inbox/ViewInvitation','000001000001000002000002000009'),('XgcsoDrbC0duVla7N7JAdw','Default Invite User Email Template','Default Invite User Email Template Default Invite User Email Template root import account inbox default invite user email template','root/import/account/inbox/default-invite-user-email-template',1226973330,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invite User Email Template Default Invite User Email Template root import account inbox default invite user email template Account/Inbox/InviteUserMessage','000001000001000002000002000010'),('cR0UFm7I1qUI2Wbpj--08Q','Default Invite User Form Template','Default Invite User Form Template Default Invite User Form Template root import account inbox default invite user form template','root/import/account/inbox/default-invite-user-form-template',1226964738,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invite User Form Template Default Invite User Form Template root import account inbox default invite user form template Account/Inbox/InviteUser','000001000001000002000002000011'),('SVIhz68689hwUGgcDM-gWw','Default Invite User Confirm Template','Default Invite User Confirm Template Default Invite User Confirm Template root import account inbox default invite user confirm template','root/import/account/inbox/default-invite-user-confirm-template',1226973314,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invite User Confirm Template Default Invite User Confirm Template root import account inbox default invite user confirm template Account/Inbox/InviteUserConfirm','000001000001000002000002000012'),('zrNpGbT3odfIkg6nFSUy8Q','Friends Layout Template','Friends Layout Template Friends Layout Template root import account friends friends layout template','root/import/account/friends/friends-layout-template',1226994016,1249407461,'3','7','12','WebGUI::Asset::Template',0,'Friends Layout Template Friends Layout Template root import account friends friends layout template Account/Layout','000001000001000002000003000001'),('1Yn_zE_dSiNuaBGNLPbxtw','Default Friends View Template','Default Friends View Template Default Friends View Template root import account friends default friends view template','root/import/account/friends/default-friends-view-template',1226994422,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends View Template Default Friends View Template root import account friends default friends view template Account/Friends/View','000001000001000002000003000002'),('AZFU33p0jpPJ-E6qLSWZng','Default Friends Edit Template','Default Friends Edit Template Default Friends Edit Template root import account friends default friends edit template','root/import/account/friends/default-friends-edit-template',1226994865,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends Edit Template Default Friends Edit Template root import account friends default friends edit template Account/Friends/Edit','000001000001000002000003000003'),('AGJBGviWGAwjnwziiPjvDg','Default Send Request Template','Default Send Request Template Default Send Request Template root import account friends default send request template','root/import/account/friends/default-send-request-template',1226995497,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default Send Request Template Default Send Request Template root import account friends default send request template Account/Friends/SendRequest','000001000001000002000003000004'),('7Ijdd8SW32lVgg2H8R-Aqw','Default Friends Error Template','Default Friends Error Template Default Friends Error Template root import account friends default friends error template','root/import/account/friends/default-friends-error-template',1226995714,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends Error Template Default Friends Error Template root import account friends default friends error template Account/Friends/Error','000001000001000002000003000005'),('K8F0j_cq_jgo8dvWY_26Ag','Default Friends Confirmation Template','Default Friends Confirmation Template Default Friends Confirmation Template root import account friends default friends confirmation template','root/import/account/friends/default-friends-confirmation-template',1226995643,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends Confirmation Template Default Friends Confirmation Template root import account friends default friends confirmation template Account/Friends/Confirm','000001000001000002000003000006'),('G5V6neXIDiFXN05oL-U3AQ','Default Remove Friends Confirmation Template','Default Remove Friends Confirmation Template Default Remove Friends Confirmation Template root import account friends default remove friends confirmation template','root/import/account/friends/default-remove-friends-confirmation-template',1226995768,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default Remove Friends Confirmation Template Default Remove Friends Confirmation Template root import account friends default remove friends confirmation template Account/Friends/Confirm','000001000001000002000003000007'),('9ThW278DWLV0-Svf68ljFQ','Account Layout','Account Layout Account Layout root import account user account layout','root/import/account/user/account-layout',1226647187,1249407460,'3','7','12','WebGUI::Asset::Template',0,'Account Layout Account Layout root import account user account layout Account/Layout','000001000001000002000004000001'),('aUDsJ-vB9RgP-AYvPOy8FQ','Shop Account Layout','Shop Account Layout Shop Account Layout root import account shop shop account layout','root/import/account/shop/shop-account-layout',1226660439,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Shop Account Layout Shop Account Layout root import account shop shop account layout Account/Layout','000001000001000002000005000001'),('-zxyB-O50W8YnL39Ouoc4Q','Default My Sales Template','Default My Sales Template Default My Sales Template root import default my sales template','root/import/default-my-sales-template',1236959717,1248563425,'3','7','12','WebGUI::Asset::Template',0,'Default My Sales Template Default My Sales Template root import default my sales template Shop/MySales','000001000001000002000005000002'),('b4n3VyUIsAHyIvT-W-jziA','Contributions Layout','Contributions Layout Contributions Layout root import account contributions contributions layout','root/import/account/contributions/contributions-layout',1227074747,1249407461,'3','7','12','WebGUI::Asset::Template',0,'Contributions Layout Contributions Layout root import account contributions contributions layout Account/Layout','000001000001000002000006000001'),('1IzRpX0tgW7iuCfaU2Kk0A','Default Contributions View','Default Contributions View Default Contributions View root import account contributions default contributions view','root/import/account/contributions/default-contributions-view',1227079721,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Contributions View Default Contributions View root import account contributions default contributions view Account/Contrib/View','000001000001000002000006000002'),('N716tpSna0iIQTKxS4gTWA','Default Account Layout','Default Account Layout Default Account Layout root import account default account layout2','root/import/account/default-account-layout2',1226604666,1254284570,'3','7','12','WebGUI::Asset::Template',0,'Default Account Layout Default Account Layout root import account default account layout2 Account/Layout','000001000001000002000007'),('S2_LsvVa95OSqc66ITAoig','EMS Schedule Listing (default)','EMS Schedule Listing default EMS Schedule Listing default root import ems ems schedule listing default2','root/import/ems/ems-schedule-listing-default2',1242730712,1254284570,'3','7','12','WebGUI::Asset::Template',0,'EMS Schedule Listing default EMS Schedule Listing default root import ems ems schedule listing default2 EMS/Schedule','000001000001000012000007'),('CalendarMonth000000001','Default Calendar Month','Default Calendar Month Default Calendar Month root import calendar templates default calendar month','root/import/calendar-templates/default-calendar-month',1204890713,1254284570,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Month Default Calendar Month root import calendar templates default calendar month Calendar/Month','000001000001000006000007'),('q5O62aH4pjUXsrQR3Pq4lw','Default Gallery View Album Thumbnails','Default Gallery View Album Thumbnails Default Gallery View Album Thumbnails root import gallery templates default gallery view album thumbnails','root/import/gallery-templates/default-gallery-view-album-thumbnails',1197825772,1248833148,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album Thumbnails Default Gallery View Album Thumbnails root import gallery templates default gallery view album thumbnails GalleryAlbum/ViewThumbnails','000001000001000015000004'),('_9_eiaPgxzF_x_upt6-PNQ','gallery.css','gallery.css gallery.css root import gallery templates gallery.css','root/import/gallery-templates/gallery.css',1197988920,1250022514,'3','7','3','WebGUI::Asset::Snippet',0,'gallery.css gallery.css root import gallery templates gallery.css  FIXES FLOAT ISSUES WITHOUT THIS FLOATS GET ALL NUTSY ESPECIALLY IN OPERA AND SAFARI  clearfix:after  content  display block height 0 clear both visibility hidden  clearfix display inline-block  END FLOAT FIX  wgGallery  font-family:verdana arial text-align:left  firstBar  background black color:white font-size:18px font-weight:bold  firstBar title  margin-left:20px line-height:42px  firstBar title a  font-size:18px font-weight:bold color:white  firstBar buttons  float:right  firstBar buttons a  display:block float:left height:42px line-height:42px font-size:10px color:white font-weight:bold text-align:center padding:0px 5px  firstBar buttons rss  display:block height:29px position:relative background:transparent padding-top:13px  secondBar  background F1F1F1 text-align:left border-top:solid 8B8B8B 5px color black overflow hidden  secondBar author  font-size:10px  secondBar desc p  margin-left 20px margin-top 0 color black  pictures   searchArea  float:right  searchArea   float:left  searchArea input.searchText  border:solid black 1px width:100px margin:0px padding:2px margin-top:5px font-size:10px height:15px margin-right:10px  searchArea input.searchBtn  border:solid black 1px margin:0px padding:3px margin-top:5px font-size:10px vertical-align:middle cursor:pointer height:21px  searchArea a:link searchArea a:visited secondBar author a:link secondBar author a:visited  font-size:11px color:black  searchArea current  font-weight:bold text-transform:uppercase text-decoration:none font-size:10px  wgAlbum   display moz-inline-box Although this works in later versions of FireFox it does not work in 2.x  display:block float:left display inline-block  Op Saf IE  vertical-align top  IE Mac non capisce e a volte crea extra v space  width:250px margin:10px  wgAlbum albumTitle  background black color:white font-size:12px font-weight:bold padding:10px padding-right:50px border:solid 475f6f 1px border-bottom:solid 8B8B8B 5px text-align:left display:block  wgAlbum albumImage  background F1F1F1 border-left solid black 1px border-right solid black 1px padding-top:15px height:135px  wgAlbum albumImage a  height:135px width:200px overflow:hidden display:block margin:0px 23px  wgAlbum albumImage img  border-style:none display:block width:200px height:auto border:solid black 1px  wgAlbum albumDesc  background F1F1F1 border-left solid black 1px border-right solid black 1px border-bottom solid black 1px text-align:center padding 5px 23px  wgAlbum description  font-size:10px height:40px overflow:auto text-align:left border:solid silver 1px padding:5px background-color fff color:#222  albumDesc description   margin:2px 0px   PAGINATION STYLES  wgGallery paginationContainer  text-align:center background black height:42px  wgGallery container  clear:both text-align:center  wgGallery pagination  margin:0px auto 20px auto display:table list-style-type:none white-space:nowrap padding:0px height:42px  wgGallery pagination li  display:table-cell  wgGallery pagination a  display:block width:50px line-height:42px color:white font-size:10px text-align:center  wgPicture a:link wgPicture a:visited  color:black  wgPicture  width:250px margin:10px display moz-inline-box This does not work in earlier versions of Firefox  display:block float:left display inline-block  Op Saf IE  vertical-align top  IE Mac non capisce e a volte crea extra v space   wgPicture title  background:#e0e0e0 display:block font-size:12px text-align:center padding:2px 5px border:solid black 1px border-bottom:solid 8B8B8B 4px  wgPicture thumbnail  text-align:center background F1F1F1 padding:15px 23px 15px 23px margin:0px border-left:solid black 1px border-right:solid black 1px  wgPicture thumbnail a  display:block width:200px height:120px overflow:hidden border:solid black 1px  wgPicture thumbnail img  border-style:none width:200px height:auto  wgPicture pictureDesc  padding:0px border-top:solid e1e1e1 1px border-bottom:solid gray 1px border-left:solid black 1px border-right:solid black 1px background:#F1F1F1 margin:0px  wgPicture pictureDesc description  margin:0px padding:5px font-size:10px  wgPicture details  background:#e0e0e0 border:solid 999 1px border-top:solid aaa 1px font-size:9px padding:1px 3px  wgPicture details date  float:right  wgPicture details comments  float:left  wgPicture details a  font-size:9px    BEGIN STYLES FOR PHOTO VIEW   The Photo view uses some/all of the above classes plus those in this section  wgSnapshot  float:left margin:10px max-width:250px width:25  wgSnapshot fieldset  background-color:#fefefe border:solid 555 2px padding:10px background-color:#f9f9f9 text-align:center  wgSnapshot p  max-width:230px  wgSnapshot legend  color:#333 font-size:15px font-weight:bold max-width:250px  wgSnapshot a.thumbnail img  width:200px height:auto border:solid 555 2px  wgSnapshot description  font-size:9px border:solid 555555 2px padding:5px width:190px margin:0px auto background-color:#fff height:50px overflow:auto text-align:left overflow:auto  wgSnapshot a.fullSize  margin:0px auto  wgPictureDetails  float:left width:70 margin:10px  wgPictureDetails a:link wgPictureDetails a:visited  color:black  wgPictureDetails fieldset  background-color:#fefefe border:solid 555 2px padding:10px background-color:#f9f9f9 margin-bottom:10px  wgPictureDetails legend  color:#333 font-size:15px font-weight:bold  rowOne  background EFEFEF margin:1px border:solid CDCDCD 1px color:black padding:3px  rowTwo  background DCDCDC margin:1px border:solid DDDDDD 1px color:black padding:3px  rowOne label rowTwo label  margin-left:15px display:inline text-align:left font-weight:bold font-size:11px  rowOne data rowTwo data  font-size:10px margin-left:5px display:inline  a.fullSize:link a.fullSize:visited  color:black display:block text-align:center font-weight:bold font-size:10px  wgComments  font-size:9px margin:10px width:90  wgComments title  font-size:14px font-weight:bold color:#333 border-bottom:solid 555555 2px padding-bottom:2px  wgComments title a  color:navy text-decoration:none  wgComments comment wgComments commentAlt  position:relative padding:5px  wgComments comment  background-color:#e1e1e1 border-top:solid F7F7F7 1px border-bottom:solid C9C9C9 1px  wgComments commentAlt  background-color:#f0f0f0 border-bottom:solid CDCDCD 1px border-top:solid FBFBFB 1px  wgComments number  float:left font-size:30px color:silver margin:5px 10px 5px 5px  wgComments posted  font-style:italic padding-top:3px font-size:9px color:gray  wgComments posted a  color:navy text-decoration:underline    BEGIN STYLES FOR THUMBNAIL VIEW   The Thumbnail view uses some/all of the above classes plus those in this section  thumbView  width:400px height:auto  thumbView thumbnail a  display:block width:350px height:auto border:solid black 1px  thumbView thumbnail img  border-style:none width:350px height:auto  thumb  width:100px height:65px overflow:hidden display:block float:left border:solid black 2px margin:10px z-index 0 position relative  thumb:hover  background-color transparent z-index 50 overflow visible  thumb img  width:100px height:auto border-style:none  thumb:hover img  bottom 65px left 75px position absolute width 250px    BEGIN STYLES FOR SLIDESHOW VIEW   The Slideshow view uses some/all of the above classes plus those in this section  wgSlideshow controls  background url(^FileUrl(root/import/gallery-templates/images/pagination_bg.jpg repeat-x width:500px height:42px margin:0px auto border:solid black 2px  wgSlideshow  text-align:center  slideshow-container  width:500px height:auto margin:0px auto text-align:center border:solid black 2px position:relative z-index:0  slideshow-container slideshow-item img  width:100 height:auto border-style:none display:block  slideshow-container slideshow-item title  background-color:black padding:3px color:white border-top:solid white 1px border-bottom:solid white 1px  slideshow-container slideshow-item title a  color:white font-size:11px font-weight:bold  slideshow-container slideshow-item counter  background-color:black padding:3px color:white font-size:11px font-weight:bold  slideshow-container slideshow-item synopsis  width:494px background-color:white padding:3px color:black font-size:11px font-weight:bold border-top:solid black 1px text-align:left    BEGIN STYLES FOR SEARCH VIEW   The Search view uses some/all of the above classes plus those in this section  adminWrapper  margin-top:20px  adminWrapper label  background:black font-weight:bold font-size:10px color:white  adminWrapper td.data input  background f1f1f1 vertical-align:middle  adminWrapper td.radio input  border-style:none background:none  adminWrapper forwardButton  cursor:pointer float:rigbt  adminWrapper forwardButton:hover  color:gold ','000001000001000015000016'),('kaPRSaf8UKiskiGEgJgLAw','images','images images root import gallery templates images','root/import/gallery-templates/images',1197330678,1250190850,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'images images root import gallery templates images','000001000001000015000017'),('matrixtmpl000000000001','Matrix Default View','Matrix Default View Matrix Default View matrix default view template','matrix-default-view-template',1133743238,1261540405,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default View Matrix Default View matrix default view template Matrix','000001000001000022000002'),('matrixtmpl000000000003','Matrix Default Detailed Listing','Matrix Default Detailed Listing Matrix Default Detailed Listing matrix default detailed listing','matrix-default-detailed-listing',1133743238,1252087641,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Detailed Listing Matrix Default Detailed Listing matrix default detailed listing Matrix/Detail','000001000001000022000003'),('alraubvBu-YJJ614jAHD5w','matrix-nav-tmpl','matrix-nav-tmpl matrix-nav-tmpl new matrix matrix nav tmpl','new-matrix/matrix-nav-tmpl',1232664015,1250147475,'3','7','12','WebGUI::Asset::Template',0,'matrix-nav-tmpl matrix-nav-tmpl new matrix matrix nav tmpl Navigation','000001000001000022000009'),('PBtmpl0000000000000062','Default Gradebook Report','Default Gradebook Report Default Gradebook Report root import survey default gradebook report','root/import/survey/default-gradebook-report',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Gradebook Report Default Gradebook Report root import survey default gradebook report Survey/Gradebook','000001000001000044000002'),('d8jMMMRddSQ7twP4l1ZSIw','Default Survey Take','Default Survey Take Default Survey Take root import survey default survey take','root/import/survey/default-survey-take',1227248175,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Take Default Survey Take root import survey default survey take Survey/Take','000001000001000044000005'),('E3tzZjzhmYoNlAyP2VW33Q','Edit Story','Edit Story Edit Story root import storymanager editstory','root/import/storymanager/editstory',1239236292,1250243000,'3','7','4','WebGUI::Asset::Template',0,'Edit Story Edit Story root import storymanager editstory Story/Edit','000001000001000042000003'),('TbDcVLbbznPi0I0rxQf2CQ','Story Template Topic','Story Template Topic Story Template Topic root import storymanager storytemplatetopic','root/import/storymanager/storytemplatetopic',1237524306,1252187598,'3','7','4','WebGUI::Asset::Template',0,'Story Template Topic Story Template Topic root import storymanager storytemplatetopic Story','000001000001000042000004'),('brxm_faNdZX5tRo3p50g3g','Map Templates','Map Templates Map Templates home map map templates','home/map/map-templates',1238054297,1250190850,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Map Templates Map Templates home map map templates','000001000001000020'),('i9-G00ALhJOr0gMh-vHbKA','Inbox SMS Notification','Inbox SMS Notification Inbox SMS Notification root import inbox sms notification','root/import/inbox-sms-notification',1250408924,1250408924,'3','7','4','WebGUI::Asset::Template',0,'Inbox SMS Notification Inbox SMS Notification root import inbox sms notification Account/Inbox/Notification','000001000001000002000002000014'),('S3zpVitAmhy58CAioH359Q','Default Test Results','Default Test Results Default Test Results root import survey default test results','root/import/survey/default-test-results',1242893798,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Test Results Default Test Results root import survey default test results Survey/TestResults','000001000001000044000013'),('b1316COmd9xRv4fCI3LLGA','Inbox Notification','Inbox Notification Inbox Notification inbox notification','inbox_notification',1236956475,1236956475,'3','7','4','WebGUI::Asset::Template',0,'Inbox Notification Inbox Notification inbox notification Account/Inbox/Notification','000001000001000002000002000013'),('nWNVoMLrMo059mDRmfOp9g','Default Feedback','Default Feedback Default Feedback root import survey default feedback','root/import/survey/default-feedback',1242259265,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Feedback Default Feedback root import survey default feedback Survey/Feedback','000001000001000044000015'),('D6cJpRcey35aSkh9Q_FPUQ','Default EU User Screen','Default EU User Screen Default EU User Screen root import default eu user screen','root/import/default-eu-user-screen',1242407725,1242407725,'3','7','12','WebGUI::Asset::Template',0,'Default EU User Screen Default EU User Screen root import default eu user screen TaxDriver/EU/User','000001000001000038000019'),('lo1rpxn3t8YPyKGers5eQg','Friend Manager','Templates for the Friend Manager ','root/import/account/friendmanager',1238625621,1238625621,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Friend Manager Friend Manager root import account friendmanager Templates for the Friend Manager','000001000001000002000010'),('64tqS80D53Z0JoAs2cX2VQ','FriendManager View Template','FriendManager View Template FriendManager View Template root import account friendmanager view','root/import/account/friendmanager/view',1239400975,1239400975,'3','7','4','WebGUI::Asset::Template',0,'FriendManager View Template FriendManager View Template root import account friendmanager view Account/FriendManager/View','000001000001000002000010000001'),('lG2exkH9FeYvn4pA63idNg','Friend Manager Edit Friends','Friend Manager Edit Friends Friend Manager Edit Friends root import account friendmanager edit','root/import/account/friendmanager/edit',1239383808,1239383808,'3','7','4','WebGUI::Asset::Template',0,'Friend Manager Edit Friends Friend Manager Edit Friends root import account friendmanager edit Account/FriendManager/Edit','000001000001000002000010000002'),('newslettercs0000000001','Newsletter Manager (default)','Newsletter Manager default Newsletter Manager newslettercstemplate','newslettercstemplate',1185754569,1252682678,'3','7','3','WebGUI::Asset::Template',0,'Newsletter Manager default Newsletter Manager newslettercstemplate Collaboration','000001000001000026000002'),('pbrobot000000000000001','robots.txt','robots.txt robots.txt robots.txt','robots.txt',1147642511,1256702483,'3','7','12','WebGUI::Asset::Snippet',0,'robots.txt robots.txt robots.txt User-agent  Disallow op=auth Disallow op=account Disallow op=ajaxGetI18N Disallow op=makePrintable Disallow op=viewHelpIndex Disallow op=viewHelp','000001000001000035'),('2GxjjkRuRkdUg_PccRPjpA','Select Gateway (Default)','Select Gateway Default Select Gateway Default shopping cart collateral items select gateway default','shopping-cart-collateral-items/select-gateway-default',1256702483,1256702483,'3','7','3','WebGUI::Asset::Template',0,'Select Gateway Default Select Gateway Default shopping cart collateral items select gateway default Shop/selectGateway','000001000001000058'),('mRtqRuVikSe82BQsYBlD0A','Bare Image','Bare Image Bare Image bare image','bare_image',1263358862,1263358862,'3','7','12','WebGUI::Asset::Template',0,'Bare Image Bare Image bare image ImageAsset','000001000001000059');
ALTER TABLE `assetIndex` ENABLE KEYS;
ALTER TABLE `assetVersionTag` DISABLE KEYS;
INSERT INTO `assetVersionTag` VALUES ('pbversion0000000000001','Base 7.7.30 Install',1,1263358865,'3',1263358865,'3',0,'','3','',NULL,NULL,NULL,NULL,0);
ALTER TABLE `assetVersionTag` ENABLE KEYS;
ALTER TABLE `authentication` DISABLE KEYS;
INSERT INTO `authentication` VALUES ('1','LDAP','ldapUrl',NULL),('3','LDAP','ldapUrl',''),('1','LDAP','connectDN',NULL),('3','LDAP','connectDN',''),('1','WebGUI','identifier','No Login'),('3','WebGUI','identifier','RvlMjeFPs2aAhQdo/xt/Kg'),('1','WebGUI','passwordLastUpdated','1078704037'),('1','WebGUI','passwordTimeout','3122064000'),('1','WebGUI','changeUsername','1'),('1','WebGUI','changePassword','1'),('3','WebGUI','passwordLastUpdated','1078704037'),('3','WebGUI','passwordTimeout','3122064000'),('3','WebGUI','changeUsername','1'),('3','WebGUI','changePassword','1');
ALTER TABLE `authentication` ENABLE KEYS;
ALTER TABLE `databaseLink` DISABLE KEYS;
INSERT INTO `databaseLink` VALUES ('0',NULL,NULL,NULL,NULL,NULL,1,'');
ALTER TABLE `databaseLink` ENABLE KEYS;
ALTER TABLE `groupGroupings` DISABLE KEYS;
INSERT INTO `groupGroupings` VALUES ('4','12'),('6','12'),('8','12'),('11','12'),('3','2'),('3','4'),('3','6'),('3','7'),('3','8'),('3','13'),('3','11'),('3','12'),('3','14'),('3','pbgroup000000000000015'),('3','pbgroup000000000000016'),('3','pbgroup000000000000017');
ALTER TABLE `groupGroupings` ENABLE KEYS;
ALTER TABLE `groupings` DISABLE KEYS;
INSERT INTO `groupings` VALUES ('1','1',2114402400,0),('3','3',2114402400,0),('7','1',2114402400,0),('7','3',2114402400,0),('2','3',2114402400,0);
ALTER TABLE `groupings` ENABLE KEYS;
ALTER TABLE `groups` DISABLE KEYS;
INSERT INTO `groups` VALUES ('1','Visitors','This is the public group that has no privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('2','Registered Users','All registered users belong to this group automatically. There are no associated privileges other than that the user has an account and is logged in.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('3','Admins','Anyone who belongs to this group has privileges to do anything and everything.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('4','Content Managers','Users that have privileges to edit content on this site. The user still needs to be added to a group that has editing privileges on specific pages.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('6','Package Managers','Users that have privileges to add, edit, and delete packages of wobjects and pages to deploy.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('7','Everyone','A group that automatically includes all users including Visitors.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('8','Template Managers','Users that have privileges to edit templates for this site.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('13','Export Managers','Users in this group can export pages to disk.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('11','Secondary Admins','Users that have limited administrative privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('12','Turn Admin On','These users can enable admin mode.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('14','Product Managers','The group that is allowed to edit, delete and create products.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000015','Workflow Managers','People who can create, edit, and delete workflows.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000016','Version Tag Managers','People who can create, edit, and delete special version tags.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000017','Ad Manager','These users will be able to manage advertisements.',314496000,1000000000,NULL,1147642437,1147642437,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('Fwa7nt7HAQkelbjCRrtqKQ','Admin Friends','Friends of user 3',1892160000,1000000000,NULL,1251850059,1251850059,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0);
ALTER TABLE `groups` ENABLE KEYS;
ALTER TABLE `imageColor` DISABLE KEYS;
INSERT INTO `imageColor` VALUES ('UVL-iDSq7VTks3RCH2FEWg','Green','#31ca31','99','#31ca31','00'),('3Tf0W_tkAjR902FJcGZxCg','Blue','#007dff','99','#007dff','00'),('fuFripVJ4es4bUBPOq3ENQ','Yellow','#ffda08','99','#ffda08','00'),('n3yfk8JGilmChSer2xuZ0w','Orange','#FF8000','99','#FF8000','00'),('W683fO6r8uHgZ-Z-VodY7w','Red','#FF2000','99','#FF2000','00'),('pSnxDIInB9r0n06q6kKV3w','Purple','#FF00B0','99','#FF00B0','00');
ALTER TABLE `imageColor` ENABLE KEYS;
ALTER TABLE `imageFont` DISABLE KEYS;
INSERT INTO `imageFont` VALUES ('defaultFont','WebGUI default font',NULL,'default.ttf');
ALTER TABLE `imageFont` ENABLE KEYS;
ALTER TABLE `imagePalette` DISABLE KEYS;
INSERT INTO `imagePalette` VALUES ('defaultPalette','Default palette');
ALTER TABLE `imagePalette` ENABLE KEYS;
ALTER TABLE `imagePaletteColors` DISABLE KEYS;
INSERT INTO `imagePaletteColors` VALUES ('defaultPalette','UVL-iDSq7VTks3RCH2FEWg',1),('defaultPalette','3Tf0W_tkAjR902FJcGZxCg',2),('defaultPalette','fuFripVJ4es4bUBPOq3ENQ',3),('defaultPalette','n3yfk8JGilmChSer2xuZ0w',4),('defaultPalette','W683fO6r8uHgZ-Z-VodY7w',5),('defaultPalette','pSnxDIInB9r0n06q6kKV3w',6);
ALTER TABLE `imagePaletteColors` ENABLE KEYS;
ALTER TABLE `ldapLink` DISABLE KEYS;
INSERT INTO `ldapLink` VALUES ('1uBbhUm686mkFZ1ghv7Lag','Default LDAP Connection','ldap://ldap.mycompany.com:389/o=MyCompany','','','cn','shortname','LDAP Shortname','LDAP Password','0','Welcome to our site.','PBtmpl0000000000000004','PBtmpl0000000000000005','PBtmpl0000000000000006',NULL);
ALTER TABLE `ldapLink` ENABLE KEYS;
ALTER TABLE `passiveAnalyticsStatus` DISABLE KEYS;
INSERT INTO `passiveAnalyticsStatus` VALUES (NULL,NULL,0,'3');
ALTER TABLE `passiveAnalyticsStatus` ENABLE KEYS;
ALTER TABLE `paymentGateway` DISABLE KEYS;
INSERT INTO `paymentGateway` VALUES ('gzUxkEZJxREF9JpylOg2zw','WebGUI::Shop::PayDriver::Cash','{\"groupToUse\":7,\"label\":\"Cash\",\"enabled\":1}'),('BaSs55o1bnOlAj4F0hHYag','WebGUI::Shop::PayDriver::ITransact','{\"credentialsTemplateId\":\"itransact_credentials1\",\"groupToUse\":7,\"label\":\"ITransact\",\"enabled\":1}');
ALTER TABLE `paymentGateway` ENABLE KEYS;
ALTER TABLE `replacements` DISABLE KEYS;
INSERT INTO `replacements` VALUES ('1','[quote]','<blockquote><i>'),('2','[/quote]','</i></blockquote>'),('3','[image]','<img src=\"'),('4','[/image]','\" border=\"0\" / >'),('5','shit','crap'),('6','fuck','farg'),('7','asshole','icehole'),('8','nigger','guy'),('9','[b]','<b>'),('10','[/b]','</b>'),('11','[i]','<i>'),('12','[/i]','</i>');
ALTER TABLE `replacements` ENABLE KEYS;
ALTER TABLE `settings` DISABLE KEYS;
INSERT INTO `settings` VALUES ('maxAttachmentSize','100000'),('sessionTimeout','7200'),('smtpServer','localhost'),('companyEmail','info@mycompany.com'),('companyName','My Company'),('companyURL','http://www.mycompany.com'),('authMethod','WebGUI'),('anonymousRegistration','0'),('notFoundPage','68sKwDgf9cGH58-NZcU4lg'),('webguiRecoverPasswordEmail','Someone (probably you) requested your account information be sent. Your password has been reset. The following represents your new account information:'),('profileName','1'),('profileExtraContact','1'),('profileMisc','1'),('profileHome','0'),('profileWork','0'),('preventProxyCache','0'),('thumbnailSize','50'),('textBoxSize','30'),('defaultPage','68sKwDgf9cGH58-NZcU4lg'),('defaultVersionTagWorkflow','pbworkflow000000000003'),('useKarma','0'),('karmaPerLogin','1'),('runOnRegistration',''),('maxImageSize','100000'),('showDebug','0'),('richEditor','PBrichedit000000000001'),('selfDeactivation','1'),('snippetsPreviewLength','30'),('mailFooter','^c;\n^e;\n^u;\n'),('webguiSendWelcomeMessage','0'),('webguiWelcomeMessage','Welcome to our site.'),('encryptLogin','0'),('hostToUse','HTTP_HOST'),('webguiExpirePasswordOnCreation','0'),('webguiPasswordLength','0'),('webguiPasswordRecovery','0'),('webguiPasswordTimeout','3122064000'),('webguiChangePassword','1'),('webguiChangeUsername','1'),('metaDataEnabled','0'),('passiveProfilingEnabled','0'),('urlExtension',''),('AdminConsoleTemplate','PBtmpl0000000000000001'),('userFunctionStyleId','stevestyle000000000003'),('webguiValidateEmail','0'),('webguiUseCaptcha','1'),('webguiAccountTemplate','PBtmpl0000000000000010'),('webguiCreateAccountTemplate','PBtmpl0000000000000011'),('webguiExpiredPasswordTemplate','PBtmpl0000000000000012'),('webguiLoginTemplate','PBtmpl0000000000000013'),('webguiPasswordRecoveryTemplate','PBtmpl0000000000000014'),('ldapConnection','1uBbhUm686mkFZ1ghv7Lag'),('debugIp',''),('showPerformanceIndicators','0'),('mailReturnPath',NULL),('webguiNonWordCharacters','0'),('webguiRequiredMixedCase','0'),('webguiRequiredDigits','0'),('automaticLDAPRegistration','0'),('trashWorkflow',NULL),('purgeWorkflow',NULL),('changeUrlWorkflow',NULL),('webguiPasswordRecoveryRequireUsername','1'),('groupIdCashier','3'),('skipCommitComments','1'),('groupIdAdminCache','3'),('groupIdAdminSpectre','3'),('groupIdAdminAdSpace','3'),('groupIdAdminWorkflow','pbgroup000000000000015'),('groupIdAdminGroupAdmin','11'),('groupIdAdminProfileSettings','3'),('groupIdAdminDatabaseLink','3'),('groupIdAdminActiveSessions','3'),('groupIdAdminLDAPLink','3'),('groupIdAdminStatistics','3'),('groupIdAdminHelp','7'),('groupIdAdminCommerce','3'),('groupIdAdminWorkflowRun','3'),('groupIdAdminUserAdd','11'),('groupIdAdminUser','3'),('groupIdAdminVersionTag','12'),('groupIdAdminGraphics','3'),('groupIdAdminGroup','3'),('groupIdAdminCron','3'),('groupIdAdminLoginHistory','3'),('groupIdAdminReplacements','3'),('runOnAdminCreateUser',''),('runOnAdminUpdateUser',''),('shopCartTemplateId','aIpCmr9Hi__vgdZnDTz1jw'),('shopAddressBookTemplateId','3womoo7Teyy2YKFa25-MZg'),('shopAddressTemplateId','XNd7a_g_cTvJVYrVHcx2Mw'),('shopMyPurchasesTemplateId','2gtFt7c0qAFNU3BG_uvNvg'),('shopMyPurchasesDetailTemplateId','g8W53Pd71uHB9pxaXhWf_A'),('showMessageOnLoginTimes','0'),('showMessageOnLogin','0'),('showMessageOnLoginBody',''),('versionTagMode','autoCommit'),('profileStyleTemplateId',''),('profileLayoutTemplateId','FJbUTvZ2nUTn65LpW6gjsA'),('profileEditTemplateId','75CmQgpcCSkdsL-oawdn3Q'),('inboxStyleTemplateId',''),('inboxViewTemplateId','c8xrwVuu5QE0XtF9DiVzLw'),('inboxViewMessageTemplateId','0n4HtbXaWa_XJHkFjetnLQ'),('inboxSendMessageTemplateId','6uQEULvXFgCYlRWnYzZsuA'),('inboxErrorTemplateId','ErEzulFiEKDkaCDVmxUavw'),('inboxMessageConfirmationTemplateId','DUoxlTBXhVS-Zl3CFDpt9g'),('inboxManageInvitationsTemplateId','1Q4Je3hKCJzeo0ZBB5YB8g'),('inboxViewInvitationTemplateId','VBkY05f-E3WJS50WpdKd1Q'),('inboxInvitationConfirmTemplateId','5A8Hd9zXvByTDy4x-H28qw'),('inboxInviteUserEnabled','0'),('inboxInviteUserRestrictSubject','0'),('inboxInviteUserSubject','^International(invite subject,Account_Inbox,^u;);'),('inboxInviteUserRestrictMessage','0'),('inboxInviteUserMessage','^International(invite message,Account_Inbox);'),('inboxInviteUserMessageTemplateId','XgcsoDrbC0duVla7N7JAdw'),('inboxInviteUserTemplateId','cR0UFm7I1qUI2Wbpj--08Q'),('inboxInviteUserConfirmTemplateId','SVIhz68689hwUGgcDM-gWw'),('friendsStyleTemplateId',''),('friendsViewTemplateId','1Yn_zE_dSiNuaBGNLPbxtw'),('friendsEditTemplateId','AZFU33p0jpPJ-E6qLSWZng'),('friendsSendRequestTemplateId','AGJBGviWGAwjnwziiPjvDg'),('friendsErrorTemplateId','7Ijdd8SW32lVgg2H8R-Aqw'),('friendsConfirmTemplateId','K8F0j_cq_jgo8dvWY_26Ag'),('friendsRemoveConfirmTemplateId','G5V6neXIDiFXN05oL-U3AQ'),('userAccountStyleTemplateId',''),('userAccountLayoutTemplateId','9ThW278DWLV0-Svf68ljFQ'),('shopStyleTemplateId',''),('shopLayoutTemplateId','aUDsJ-vB9RgP-AYvPOy8FQ'),('contribStyleTemplateId',''),('contribLayoutTemplateId','b4n3VyUIsAHyIvT-W-jziA'),('contribViewTemplateId','1IzRpX0tgW7iuCfaU2Kk0A'),('profileViewTemplateId','2CS-BErrjMmESOtGT90qOg'),('profileErrorTemplateId','MBmWlA_YEA2I6D29OMGtRg'),('inboxLayoutTemplateId','gfZOwaTWYjbSoVaQtHBBEw'),('friendsLayoutTemplateId','zrNpGbT3odfIkg6nFSUy8Q'),('inboxRichEditId','PBrichedit000000000001'),('useRecaptcha',NULL),('recaptchaPublicKey',NULL),('recaptchaPrivateKey',NULL),('webguiAccountActivationTemplate','PBtmpl0000000000000016'),('groupIdAdminHistory','12'),('shopCartCheckoutMinimum','0.00'),('passiveAnalyticsInterval','300'),('passiveAnalyticsDeleteDelta','0'),('passiveAnalyticsEnabled','0'),('shopMySalesTemplateId','-zxyB-O50W8YnL39Ouoc4Q'),('webguiWelcomeMessageTemplate','PBtmpl0000000000000015'),('activeTaxPlugin','WebGUI::Shop::TaxDriver::Generic'),('globalHeadTags',''),('useMobileStyle','0'),('inboxCopySender','0'),('sendInboxNotificationsOnly','0'),('inboxNotificationTemplateId','b1316COmd9xRv4fCI3LLGA'),('smsGateway',''),('groupIdAdminFriends','3'),('fmViewTemplateId','64tqS80D53Z0JoAs2cX2VQ'),('fmEditTemplateId','lG2exkH9FeYvn4pA63idNg'),('groupsToManageFriends','2'),('overrideAbleToBeFriend','0'),('webguiUseEmailAsUsername','0'),('redirectAfterLoginUrl',NULL),('groupIdAdminFilePump','8'),('fmStyleTemplateId','stevestyle000000000003'),('fmLayoutTemplateId','N716tpSna0iIQTKxS4gTWA'),('smsGatewaySubject',''),('inboxNotificationsSubject',''),('inboxSmsNotificationTemplateId','i9-G00ALhJOr0gMh-vHbKA'),('shopSaleNotificationGroupId','3'),('shopReceiptEmailTemplateId','bPz1yk6Y9uwMDMBcmMsSCg'),('selectGatewayTemplateId','2GxjjkRuRkdUg_PccRPjpA'),('maxCacheTimeout','86400'),('specialState','init');
ALTER TABLE `settings` ENABLE KEYS;
ALTER TABLE `shipper` DISABLE KEYS;
INSERT INTO `shipper` VALUES ('defaultfreeshipping000','WebGUI::Shop::ShipDriver::FlatRate','{\"groupToUse\":7,\"label\":\"Free Shipping\",\"enabled\":1}');
ALTER TABLE `shipper` ENABLE KEYS;
ALTER TABLE `snippet` DISABLE KEYS;
INSERT INTO `snippet` VALUES ('SynConXSLT000000000001','<?xml version=\"1.0\"?>\n<!--\n  Based on XSLT stylesheets originally designed by Rich Manalang (http://manalang.com)\n  This XSLT sheet will convert any valid RSS 0.9 feed into basic HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:foo=\"http://my.netscape.com/rdf/simple/0.9/\">\n  <xsl:output method=\"html\"/>\n  <xsl:template match=\"/\">\n    <style>\n      <xsl:comment>\n        .syndication-content-area {\n        }\n        .syndication-title {\n        font-size: 1.1em;\n        font-weight: bold;\n        }\n        .syndication-description {\n        font-size: .9em;\n        margin: 0 0 10px 0;\n        }\n        .syndication-list {\n        font-size: .8em;\n        margin:0 0 0 20px;\n        }\n        .syndication-list-item {\n        margin: 0 0 5px 0;\n        }\n        .syndication-list-item a,\n        .syndication-list-item a:link {\n        color: blue;\n        }\n        .syndication-list-item a:active,\n        .syndication-list-item a:hover {\n        color: red;\n        }\n        li.syndication-list-item{\n        padding-bottom: .2em;\n        background-color: #e4e4e4;\n        }\n        .syndication-list-item a:visited {\n        color: black;\n        text-decoration: none;\n        }\n        .syndication-list-item-date {\n        font-size: .8em;\n        }\n        .syndication-list-item-description {\n        font-size: .9em;\n        }\n      </xsl:comment>\n    </style>\n    <xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:channel\">\nYou\'re viewing an <a href=\"http://www.purplepages.ie/RSS/netscape/rss0.90.html\">RSS version 0.9 feed</a>. Please use an RSS feed reader to view this content as intended.\n    <div class=\"syndication-content-area\">\n      <div class=\"syndication-title\">\n        <xsl:value-of select=\"foo:title\"/>\n      </div>\n      <div class=\"syndication-description\">\n        <xsl:value-of select=\"foo:description\"/>\n      </div>\n      <ul class=\"syndication-list\">\n        <xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n      </ul>\n    </div>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:item\">\n    <li class=\"syndication-list-item\">\n      <a href=\"{foo:link}\" title=\"{foo:description}\">\n        <xsl:value-of select=\"foo:title\"/>\n      </a>\n    </li>\n  </xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600,'<?xml version=\"1.0\"?>\n<!--\n  Based on XSLT stylesheets originally designed by Rich Manalang (http://manalang.com)\n  This XSLT sheet will convert any valid RSS 0.9 feed into basic HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:foo=\"http://my.netscape.com/rdf/simple/0.9/\">\n  <xsl:output method=\"html\"/>\n  <xsl:template match=\"/\">\n    <style>\n      <xsl:comment>\n        .syndication-content-area {\n        }\n        .syndication-title {\n        font-size: 1.1em;\n        font-weight: bold;\n        }\n        .syndication-description {\n        font-size: .9em;\n        margin: 0 0 10px 0;\n        }\n        .syndication-list {\n        font-size: .8em;\n        margin:0 0 0 20px;\n        }\n        .syndication-list-item {\n        margin: 0 0 5px 0;\n        }\n        .syndication-list-item a,\n        .syndication-list-item a:link {\n        color: blue;\n        }\n        .syndication-list-item a:active,\n        .syndication-list-item a:hover {\n        color: red;\n        }\n        li.syndication-list-item{\n        padding-bottom: .2em;\n        background-color: #e4e4e4;\n        }\n        .syndication-list-item a:visited {\n        color: black;\n        text-decoration: none;\n        }\n        .syndication-list-item-date {\n        font-size: .8em;\n        }\n        .syndication-list-item-description {\n        font-size: .9em;\n        }\n      </xsl:comment>\n    </style>\n    <xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:channel\">\nYou\'re viewing an <a href=\"http://www.purplepages.ie/RSS/netscape/rss0.90.html\">RSS version 0.9 feed</a>. Please use an RSS feed reader to view this content as intended.\n    <div class=\"syndication-content-area\">\n      <div class=\"syndication-title\">\n        <xsl:value-of select=\"foo:title\"/>\n      </div>\n      <div class=\"syndication-description\">\n        <xsl:value-of select=\"foo:description\"/>\n      </div>\n      <ul class=\"syndication-list\">\n        <xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n      </ul>\n    </div>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:item\">\n    <li class=\"syndication-list-item\">\n      <a href=\"{foo:link}\" title=\"{foo:description}\">\n        <xsl:value-of select=\"foo:title\"/>\n      </a>\n    </li>\n  </xsl:template>\n</xsl:stylesheet>',0),('SynConXSLT000000000002','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 0.91, 0.92, 0.93 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 0.91, 0.92, or 0.93 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://backend.userland.com/rss091\">RSS version 0.91 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600,'<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 0.91, 0.92, 0.93 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 0.91, 0.92, or 0.93 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://backend.userland.com/rss091\">RSS version 0.91 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0),('SynConXSLT000000000003','<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--\n  Title: RSS 1.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 1.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n  xmlns:foo=\"http://purl.org/rss/1.0/\">\n  	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://web.resource.org/rss/1.0/\">RSS version 1.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"foo:title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{foo:link}\" title=\"{foo:description}\">\n				<xsl:value-of select=\"foo:title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n						(\n				<xsl:value-of select=\"dc:date\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>\n',0,'application/xml',1124395707,3600,'<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--\n  Title: RSS 1.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 1.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n  xmlns:foo=\"http://purl.org/rss/1.0/\">\n  	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://web.resource.org/rss/1.0/\">RSS version 1.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"foo:title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{foo:link}\" title=\"{foo:description}\">\n				<xsl:value-of select=\"foo:title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n						(\n				<xsl:value-of select=\"dc:date\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>\n',0),('SynConXSLT000000000004','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 2.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 2.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://blogs.law.harvard.edu/tech/rss\">RSS version 2.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n		 		(<xsl:value-of select=\"pubDate\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600,'<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 2.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 2.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://blogs.law.harvard.edu/tech/rss\">RSS version 2.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n		 		(<xsl:value-of select=\"pubDate\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0),('7-0-style0000000000003','body, html\n{\n	text-align:center;\n	margin:0px;\n	height:100%;	\n	background-color:#494949;\n}\n\n#main\n{\n	width:800px;\n	background: url(\'^FileUrl(style1/main_bg.jpg);\') repeat-y;\n	height:100%;\n	margin-left:auto;\n	margin-right:auto;\n	margin-top:0px;\n	margin-bottom:0px;\n	position:relative;\n}\nbody > #main\n{\n	height:auto;\n	min-height:100%;\n}\n\n#main #mainHeader\n{\n	width:800px;\n	height:133px;\n	background: url(\'^FileUrl(style1/header.jpg);\') top left no-repeat;\n	margin-bottom:0px;\n	position:relative;\n}\n#main #mainHeader #title\n{\n	position:absolute;\n	top:23px;\n	left:145px;\n	font-size:32pt;\n	font-family:arial;\n	color:white;\n	font-weight:bold;\n}\n#main #mainHeader #title a {\n	color:white;\n	text-decoration:none;\n}\n\n#main #mainContent\n{\n	background: url(\'^FileUrl(style1/orange_left01.jpg);\') left top no-repeat;\n	width:100%;\n	height:100%;			\n	margin-top:0px;\n	text-align:left;\n	border:solid red 0px;\n}\n#main > #mainContent\n{\n	margin-top:0px;\n	min-height:500px;\n}\n#main > #mainContent > p {\n	margin-top:0px;\n}\n#main #mainContent #mainText a:link {\n	color:#FF7F23;\n}\n#main #mainContent #mainText a:visited {\n	color:#D25900;\n}\n\n/* LEVEL 1 AND 2 NAVIGATION */\n#main .mainNav_1, #main .mainNav_2 {\n	border-bottom:dashed #DADADA 1px;			\n	width:621px;\n	height:25px;\n	text-align:left;\n	position:relative;\n	margin-left:137px;	\n	clear:both;\n}\n#main .mainNav_1 a:link, #main .mainNav_1 a:visited, #main .mainNav_2 a:link, #main .mainNav_2 a:visited {\n	color:white;\n	text-decoration:none;\n	top:5px;\n	position:relative;\n	-moz-box-sizing:border-box;\n}\n#main .mainNav_1 a:hover,#main .mainNav_2 a:hover {\n	color:black;\n}\n#main .mainNav_1 div .left, #main .mainNav_2 div .left {\n	width:12px;\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div .left {\n	background: url(\'^FileUrl(style1/nav2_off_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div .center, #main .mainNav_2 div .center {			\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_center.jpg);\') repeat-x top left;\n	color:white;\n	font-family:arial, verdana;\n	font-size:8pt;\n}\n#main .mainNav_2 div .center {\n	background: url(\'^FileUrl(style1/nav2_off_center.jpg);\') repeat-x top left;\n}\n#main .mainNav_1 div .right, #main .mainNav_2 div .right {\n	width:10px;\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div .right {\n	background: url(\'^FileUrl(style1/nav2_off_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div.navOn .left {\n	background: url(\'^FileUrl(style1/nav1_on_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div.navOn .center {\n	background: url(\'^FileUrl(style1/nav1_center_on.jpg);\') repeat-x top left;\n}\n#main .mainNav_1 div.navOn .right {\n	background: url(\'^FileUrl(style1/nav1_on_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div.navOn .left {\n	background: url(\'^FileUrl(style1/nav2_on_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div.navOn .center {\n	background: url(\'^FileUrl(style1/nav2_center_on.jpg);\') repeat-x top left;\n}\n#main .mainNav_2 div.navOn .right {\n	background: url(\'^FileUrl(style1/nav2_on_right.jpg);\') no-repeat top left;\n}		\n#main .mainNav_1 div.navOn a:link, #main .mainNav_1 div.navOn a:visited, #main .mainNav_2 div.navOn a:link, #main .mainNav_2 div.navOn a:visited {\n	color:black;\n}\n/* ENDOF LEVEL 1 AND 2 NAVIGATION */\n\n#main #crumbTrail {\n	margin-left:177px;\n	margin-bottom:0px;\n	color:gray;\n	font-size:8pt;\n	font-weight:bold;\n}\n#main #crumbTrail a.crumbTrail:visited, #main #crumbTrail a.crumbTrail:link {\n	color:silver;\n	font-size:8pt;			\n	font-family:arial;\n	text-decoration:none;\n	font-weight:normal;\n}\n#main #crumbTrail a.crumbTrail:hover {\n	color:gray;\n}\n\n#main #mainText\n{\n	padding-left:150px;\n	font-family:verdana;\n	font-size:9pt;\n	width:600px;\n	margin-top:0px;\n}\n\n#main #gui\n{\n	bottom:0px;\n	left:0px;\n	position:absolute;\n	width:135px;\n	font-size:8pt;\n	color:black;\n	font-family:arial;\n	text-align:right;\n}\n#main #gui .loginBox {\n	padding-right:12px;\n	-moz-box-sizing:border-box;\n	width:100px;			\n	float:right;\n	margin-bottom:10px;\n}\n#main #gui .loginBox .loginBoxField {\n	width:75px;\n}\n#main #gui .loginBox .loginBoxButton {\n	background-color:#D65501;\n	color:white;\n	border:solid white 2px;\n	margin-top:4px;\n	font-variant:small-caps;\n}\n#main #gui a\n{\n	color:white;			\n}\n#copyright {\n	color:#fff;\n	position:absolute;\n	top:110px;\n	right:40px;\n	font-family:verdana;\n	font-size:8pt;\n	font-weight:bold;\n	background-color:#2D2D2D;\n	opacity:0.4;\n	-moz-opacity:0.4;\n	-khtml-opacity:0.4;	\n	padding:2px;\n}\n* html #copyright {\n	background: transparent;\n}\n',1,'text/css',1147642492,3600,'body,html{text-align:center;margin:0px;height:100%;background-color:#494949;}#main{width:800px;background:url(\'^FileUrl(style1/main_bg.jpg);\') repeat-y;height:100%;margin-left:auto;margin-right:auto;margin-top:0px;margin-bottom:0px;position:relative;}body > #main{height:auto;min-height:100%;}#main #mainHeader{width:800px;height:133px;background:url(\'^FileUrl(style1/header.jpg);\') top left no-repeat;margin-bottom:0px;position:relative;}#main #mainHeader #title{position:absolute;top:23px;left:145px;font-size:32pt;font-family:arial;color:white;font-weight:bold;}#main #mainHeader #title a{color:white;text-decoration:none;}#main #mainContent{background:url(\'^FileUrl(style1/orange_left01.jpg);\') left top no-repeat;width:100%;height:100%;margin-top:0px;text-align:left;border:solid red 0px;}#main > #mainContent{margin-top:0px;min-height:500px;}#main > #mainContent > p{margin-top:0px;}#main #mainContent #mainText a:link{color:#FF7F23;}#main #mainContent #mainText a:visited{color:#D25900;}#main .mainNav_1,#main .mainNav_2{border-bottom:dashed #DADADA 1px;width:621px;height:25px;text-align:left;position:relative;margin-left:137px;clear:both;}#main .mainNav_1 a:link,#main .mainNav_1 a:visited,#main .mainNav_2 a:link,#main .mainNav_2 a:visited{color:white;text-decoration:none;top:5px;position:relative;-moz-box-sizing:border-box;}#main .mainNav_1 a:hover,#main .mainNav_2 a:hover{color:black;}#main .mainNav_1 div .left,#main .mainNav_2 div .left{width:12px;height:25px;display:block;float:left;background:url(\'^FileUrl(style1/nav1_off_left.jpg);\') no-repeat top left;}#main .mainNav_2 div .left{background:url(\'^FileUrl(style1/nav2_off_left.jpg);\') no-repeat top left;}#main .mainNav_1 div .center,#main .mainNav_2 div .center{height:25px;display:block;float:left;background:url(\'^FileUrl(style1/nav1_off_center.jpg);\') repeat-x top left;color:white;font-family:arial,verdana;font-size:8pt;}#main .mainNav_2 div .center{background:url(\'^FileUrl(style1/nav2_off_center.jpg);\') repeat-x top left;}#main .mainNav_1 div .right,#main .mainNav_2 div .right{width:10px;height:25px;display:block;float:left;background:url(\'^FileUrl(style1/nav1_off_right.jpg);\') no-repeat top left;}#main .mainNav_2 div .right{background:url(\'^FileUrl(style1/nav2_off_right.jpg);\') no-repeat top left;}#main .mainNav_1 div.navOn .left{background:url(\'^FileUrl(style1/nav1_on_left.jpg);\') no-repeat top left;}#main .mainNav_1 div.navOn .center{background:url(\'^FileUrl(style1/nav1_center_on.jpg);\') repeat-x top left;}#main .mainNav_1 div.navOn .right{background:url(\'^FileUrl(style1/nav1_on_right.jpg);\') no-repeat top left;}#main .mainNav_2 div.navOn .left{background:url(\'^FileUrl(style1/nav2_on_left.jpg);\') no-repeat top left;}#main .mainNav_2 div.navOn .center{background:url(\'^FileUrl(style1/nav2_center_on.jpg);\') repeat-x top left;}#main .mainNav_2 div.navOn .right{background:url(\'^FileUrl(style1/nav2_on_right.jpg);\') no-repeat top left;}#main .mainNav_1 div.navOn a:link,#main .mainNav_1 div.navOn a:visited,#main .mainNav_2 div.navOn a:link,#main .mainNav_2 div.navOn a:visited{color:black;}#main #crumbTrail{margin-left:177px;margin-bottom:0px;color:gray;font-size:8pt;font-weight:bold;}#main #crumbTrail a.crumbTrail:visited,#main #crumbTrail a.crumbTrail:link{color:silver;font-size:8pt;font-family:arial;text-decoration:none;font-weight:normal;}#main #crumbTrail a.crumbTrail:hover{color:gray;}#main #mainText{padding-left:150px;font-family:verdana;font-size:9pt;width:600px;margin-top:0px;}#main #gui{bottom:0px;left:0px;position:absolute;width:135px;font-size:8pt;color:black;font-family:arial;text-align:right;}#main #gui .loginBox{padding-right:12px;-moz-box-sizing:border-box;width:100px;float:right;margin-bottom:10px;}#main #gui .loginBox .loginBoxField{width:75px;}#main #gui .loginBox .loginBoxButton{background-color:#D65501;color:white;border:solid white 2px;margin-top:4px;font-variant:small-caps;}#main #gui a{color:white;}#copyright{color:#fff;position:absolute;top:110px;right:40px;font-family:verdana;font-size:8pt;font-weight:bold;background-color:#2D2D2D;opacity:0.4;-moz-opacity:0.4;-khtml-opacity:0.4;padding:2px;}* html #copyright{background:transparent;}',0),('7-0-style0000000000033','body, html {			\n	height:100%;			\n}\nbody {\n	background:#7c9ab0 url(\'^FileUrl(style2/main_bg.jpg);\') repeat-y right; \n	margin:0px;\n}\n.rightColumn {\n	width:20%;\n	height:100%;\n	background: #eeeeee url(\'^FileUrl(style2/rightCol_bg.jpg);\') repeat-y right;			\n	text-align:center;	\n}\n.rightColumn #pb_wg_bg {\n	background: url(\'^FileUrl(style2/pb_wg_bg.jpg);\') repeat-x;\n	width:100%;\n	text-align:left;			\n}\n.rightColumn #pb_wg {\n	background: url(\'^FileUrl(style2/pb_wg.jpg);\') left no-repeat;\n	height:53px;\n}\n.leftColumn {			\n	width:80%;				\n	background: white url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right; \n}		\n.leftColumn #header {\n	width:100%;\n	background:#7c9ab0 url(\'^FileUrl(style2/leftCol_header.jpg);\') right no-repeat; \n	height:86px;\n	position:relative;\n}\n.leftColumn #header #title, .leftColumn #header #title_bg  {\n	color:white;\n	font-size:36pt;\n	font-weight:bold;\n	font-family:arial;\n	font-variant:small-caps;\n	letter-spacing:12px;\n	top:15px;\n	left:5px;\n	position:absolute;\n	z-index:10;\n}\n.leftColumn #header #title a {\n	color:white;\n	text-decoration:none;\n}\n.leftColumn #header #title_bg  {\n	color:black;\n	z-index:5;\n	top:17px;\n	left:7px;\n}\n.leftColumn #context {\n	/*background: #fff url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right; */\n	width:95%;\n	font-family:verdana;\n	font-size:9pt;\n	color:#242424;\n	-moz-box-sizing:border-box;			\n	position:relative;\n	padding-left:1%;\n	padding-right:1%;\n	padding-bottom:15px;\n}\n.leftColumn #context a {\n	color:#7C9AB0;\n	font-weight:bold;\n}\n.leftColumn #context a:hover {\n	text-decoration:none;\n}\n.leftColumn #pageTitleBG {\n	background: url(\'^FileUrl(style2/page_title_bg.jpg);\') repeat-x; \n	width:100%;\n}\n.leftColumn #pageTitleBG #pageTitle {\n	background: url(\'^FileUrl(style2/page_title.jpg);\') right no-repeat; \n	width:100%;\n	height:50px;\n}		\n.leftColumn #pageTitleBG #pageTitle h2 {\n	font-size:14pt;\n	color:#696969;\n	font-family:arial;\n	font-weight:normal;\n	margin:0px;\n	padding-top:2px;\n	padding-left:25px;\n	letter-spacing:3px;\n}\n.rightColumn #nav {\n	width:85%;\n	background: #b5b5b5 url(\'^FileUrl(style2/nav_bg.jpg);\') repeat-x top;			\n	border-right:solid #848484 1px;\n	margin-left:auto;\n	margin-right:auto;\n	text-align:left;\n	padding-left:3px;\n	padding-top:7px;\n	padding-bottom:7px;\n}\n.rightColumn #nav a {\n	color:white;\n	font-size:8pt;\n	font-weight:bold;\n	text-decoration:none;\n	font-family:arial;\n	line-height:8pt;			\n}		\n.rightColumn #nav .selectedMenuItem {\n	color:yellow;\n}\n#loginStyles {\n	font-size:8pt;\n	font-family:arial;\n	padding-bottom:25px;\n}\n#loginStyles a {\n	color:#89ACCF;\n	font-weight:bold;			\n	border-bottom:solid transparent 2px;\n	text-decoration:none;\n}\n#loginStyles a:hover {\n	border-bottom:dotted #B2C9D9 2px;\n}	\n\n.copyright {\n	border-top:solid silver 3px;\n	background-color:gray;\n	font-family:arial;\n	font-size:9pt;\n	color:silver;	\n	text-align:center;\n}\n',0,'text/css',1147642500,3600,'body,html{height:100%;}body{background:#7c9ab0 url(\'^FileUrl(style2/main_bg.jpg);\') repeat-y right;margin:0px;}.rightColumn{width:20%;height:100%;background:#eeeeee url(\'^FileUrl(style2/rightCol_bg.jpg);\') repeat-y right;text-align:center;}.rightColumn #pb_wg_bg{background:url(\'^FileUrl(style2/pb_wg_bg.jpg);\') repeat-x;width:100%;text-align:left;}.rightColumn #pb_wg{background:url(\'^FileUrl(style2/pb_wg.jpg);\') left no-repeat;height:53px;}.leftColumn{width:80%;background:white url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right;}.leftColumn #header{width:100%;background:#7c9ab0 url(\'^FileUrl(style2/leftCol_header.jpg);\') right no-repeat;height:86px;position:relative;}.leftColumn #header #title,.leftColumn #header #title_bg{color:white;font-size:36pt;font-weight:bold;font-family:arial;font-variant:small-caps;letter-spacing:12px;top:15px;left:5px;position:absolute;z-index:10;}.leftColumn #header #title a{color:white;text-decoration:none;}.leftColumn #header #title_bg{color:black;z-index:5;top:17px;left:7px;}.leftColumn #context{width:95%;font-family:verdana;font-size:9pt;color:#242424;-moz-box-sizing:border-box;position:relative;padding-left:1%;padding-right:1%;padding-bottom:15px;}.leftColumn #context a{color:#7C9AB0;font-weight:bold;}.leftColumn #context a:hover{text-decoration:none;}.leftColumn #pageTitleBG{background:url(\'^FileUrl(style2/page_title_bg.jpg);\') repeat-x;width:100%;}.leftColumn #pageTitleBG #pageTitle{background:url(\'^FileUrl(style2/page_title.jpg);\') right no-repeat;width:100%;height:50px;}.leftColumn #pageTitleBG #pageTitle h2{font-size:14pt;color:#696969;font-family:arial;font-weight:normal;margin:0px;padding-top:2px;padding-left:25px;letter-spacing:3px;}.rightColumn #nav{width:85%;background:#b5b5b5 url(\'^FileUrl(style2/nav_bg.jpg);\') repeat-x top;border-right:solid #848484 1px;margin-left:auto;margin-right:auto;text-align:left;padding-left:3px;padding-top:7px;padding-bottom:7px;}.rightColumn #nav a{color:white;font-size:8pt;font-weight:bold;text-decoration:none;font-family:arial;line-height:8pt;}.rightColumn #nav .selectedMenuItem{color:yellow;}#loginStyles{font-size:8pt;font-family:arial;padding-bottom:25px;}#loginStyles a{color:#89ACCF;font-weight:bold;border-bottom:solid transparent 2px;text-decoration:none;}#loginStyles a:hover{border-bottom:dotted #B2C9D9 2px;}.copyright{border-top:solid silver 3px;background-color:gray;font-family:arial;font-size:9pt;color:silver;text-align:center;}',0),('MBZK_LPVzqhb4TV4mMRTJg','input.captionEnter {\r\n	margin-left:		-5px;\r\n	width:			92px;\r\n}',0,'text/css',1197330678,3600,'input.captionEnter{margin-left:-5px;width:92px;}',0),('3qiVYhNTXMVC5hfsumVHgg','var BrowserDetect = {\r\n	init: function () {\r\n		this.browser = this.searchString(this.dataBrowser) || \"An unknown browser\";\r\n		this.version = this.searchVersion(navigator.userAgent)\r\n			|| this.searchVersion(navigator.appVersion)\r\n			|| \"an unknown version\";\r\n		this.OS = this.searchString(this.dataOS) || \"an unknown OS\";\r\n	},\r\n	searchString: function (data) {\r\n		for (var i=0;i<data.length;i++)	{\r\n			var dataString = data[i].string;\r\n			var dataProp = data[i].prop;\r\n			this.versionSearchString = data[i].versionSearch || data[i].identity;\r\n			if (dataString) {\r\n				if (dataString.indexOf(data[i].subString) != -1)\r\n					return data[i].identity;\r\n			}\r\n			else if (dataProp)\r\n				return data[i].identity;\r\n		}\r\n	},\r\n	searchVersion: function (dataString) {\r\n		var index = dataString.indexOf(this.versionSearchString);\r\n		if (index == -1) return;\r\n		return parseFloat(dataString.substring(index+this.versionSearchString.length+1));\r\n	},\r\n	dataBrowser: [\r\n		{ 	string: navigator.userAgent,\r\n			subString: \"OmniWeb\",\r\n			versionSearch: \"OmniWeb/\",\r\n			identity: \"OmniWeb\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"Apple\",\r\n			identity: \"Safari\"\r\n		},\r\n		{\r\n			prop: window.opera,\r\n			identity: \"Opera\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"iCab\",\r\n			identity: \"iCab\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"KDE\",\r\n			identity: \"Konqueror\"\r\n		},\r\n		{\r\n			string: navigator.userAgent,\r\n			subString: \"Firefox\",\r\n			identity: \"Firefox\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"Camino\",\r\n			identity: \"Camino\"\r\n		},\r\n		{		// for newer Netscapes (6+)\r\n			string: navigator.userAgent,\r\n			subString: \"Netscape\",\r\n			identity: \"Netscape\"\r\n		},\r\n		{\r\n			string: navigator.userAgent,\r\n			subString: \"MSIE\",\r\n			identity: \"Explorer\",\r\n			versionSearch: \"MSIE\"\r\n		},\r\n		{\r\n			string: navigator.userAgent,\r\n			subString: \"Gecko\",\r\n			identity: \"Mozilla\",\r\n			versionSearch: \"rv\"\r\n		},\r\n		{ 		// for older Netscapes (4-)\r\n			string: navigator.userAgent,\r\n			subString: \"Mozilla\",\r\n			identity: \"Netscape\",\r\n			versionSearch: \"Mozilla\"\r\n		}\r\n	],\r\n	dataOS : [\r\n		{\r\n			string: navigator.platform,\r\n			subString: \"Win\",\r\n			identity: \"Windows\"\r\n		},\r\n		{\r\n			string: navigator.platform,\r\n			subString: \"Mac\",\r\n			identity: \"Mac\"\r\n		},\r\n		{\r\n			string: navigator.platform,\r\n			subString: \"Linux\",\r\n			identity: \"Linux\"\r\n		}\r\n	]\r\n\r\n};\r\nBrowserDetect.init();',0,'text/javascript',1206743306,3600,'var BrowserDetect={init:function(){this.browser=this.searchString(this.dataBrowser)||\"An unknown browser\";this.version=this.searchVersion(navigator.userAgent)||this.searchVersion(navigator.appVersion)||\"an unknown version\";this.OS=this.searchString(this.dataOS)||\"an unknown OS\"},searchString:function(b){for(var i=0;i<b.length;i++){var c=b[i].string;var a=b[i].prop;this.versionSearchString=b[i].versionSearch||b[i].identity;if(c){if(c.indexOf(b[i].subString)!=-1)return b[i].identity}else if(a)return b[i].identity}},searchVersion:function(b){var a=b.indexOf(this.versionSearchString);if(a==-1)return;return parseFloat(b.substring(a+this.versionSearchString.length+1))},dataBrowser:[{string:navigator.userAgent,subString:\"OmniWeb\",versionSearch:\"OmniWeb/\",identity:\"OmniWeb\"},{string:navigator.vendor,subString:\"Apple\",identity:\"Safari\"},{prop:window.opera,identity:\"Opera\"},{string:navigator.vendor,subString:\"iCab\",identity:\"iCab\"},{string:navigator.vendor,subString:\"KDE\",identity:\"Konqueror\"},{string:navigator.userAgent,subString:\"Firefox\",identity:\"Firefox\"},{string:navigator.vendor,subString:\"Camino\",identity:\"Camino\"},{string:navigator.userAgent,subString:\"Netscape\",identity:\"Netscape\"},{string:navigator.userAgent,subString:\"MSIE\",identity:\"Explorer\",versionSearch:\"MSIE\"},{string:navigator.userAgent,subString:\"Gecko\",identity:\"Mozilla\",versionSearch:\"rv\"},{string:navigator.userAgent,subString:\"Mozilla\",identity:\"Netscape\",versionSearch:\"Mozilla\"}],dataOS:[{string:navigator.platform,subString:\"Win\",identity:\"Windows\"},{string:navigator.platform,subString:\"Mac\",identity:\"Mac\"},{string:navigator.platform,subString:\"Linux\",identity:\"Linux\"}]};BrowserDetect.init();',0),('_hELmIJfgbAyXFNqPyApxQ','#adminWrapper {\r\n	text-align:left;\r\n	font-family:arial;\r\n	font-size:11px;\r\n	position: relative;\r\n	z-index: 2;\r\n}\r\n\r\nh2 {\r\n	font-size:15px;\r\n}\r\n\r\n.messageStyle {\r\n	font-weight:bold;\r\n	font-family:arial;\r\n	font-size:10px;\r\n	margin-bottom:8px;\r\n}\r\n\r\n.adminButton {\r\n	border:solid silver 1px;\r\n	background-color:#e0e0e0;\r\n	font-weight:bold;\r\n	font-size:10px;\r\n	color:#333;\r\n	cursor:pointer;\r\n	padding: 0.5em 1em;\r\n}	\r\n\r\n.adminTable {\r\n	border:solid silver 1px;\r\n	background-color:#F0F0F0;\r\n	color: black;\r\n	width:320px;\r\n	padding:5px;\r\n}\r\n\r\n.adminTable select, .adminTable input, .adminTable textarea{\r\n	border:solid gray 1px;\r\n	font-size:10px;\r\n	padding-left:5px;\r\n}\r\n\r\n.label {\r\n	white-space:nowrap;\r\n	text-align:right;\r\n	padding-right:10px;\r\n	font-weight:bold;\r\n	width:1px;\r\n	vertical-align:top;\r\n}\r\n\r\n.galleryOrg {\r\n	position:relative;\r\n	margin-top:0px;\r\n	padding-top:0px;\r\n	margin-left:5px;\r\n	border:gray solid 1px;\r\n	text-align:center;\r\n	margin-top:3px;\r\n	width: 95%;\r\n	background-color: #DEDEDE\r\n}\r\n\r\n.galleryOrg .left {\r\n	float: left;\r\n	width: 36%;\r\n}\r\n\r\n.galleryOrg .right {\r\n	width: 63%;\r\n}\r\n \r\n.galleryOrg img {\r\n	display:block;\r\n	height:150px;\r\n	margin:0px auto;\r\n}\r\n\r\n.promote {\r\n	margin-left:3px;\r\n}\r\n\r\n.promote img {\r\n	height:14px;\r\n	width:16px;\r\n}\r\n\r\n.demote {\r\n	margin-right:3px;\r\n}\r\n\r\n.demote img {\r\n	height:14px;\r\n	width:16px;\r\n}\r\n\r\n.delete img {\r\n	height: 14px;\r\n}\r\n\r\n.numbering {\r\n	position:absolute;\r\n	top:0px;\r\n	left:0px;\r\n	padding:1px;\r\n	background-color:black;\r\n	color:white;\r\n	-moz-border-radius-bottomRight:5px\r\n}\r\n\r\ninput.captionEnter {\r\n	width:93px;\r\n	clear:both;\r\n	margin-bottom:3px\r\n}\r\n\r\n.galleryOrg button {\r\n	border-style:none;\r\n	background:none;\r\n}\r\n.galleryOrg button img {\r\n	width:16px;\r\n	height:auto;\r\n}\r\n.galleryOrg .synopsis input {\r\n	width:80px;\r\n}',0,'text/css',1213309523,3600,'#adminWrapper{text-align:left;font-family:arial;font-size:11px;position:relative;z-index:2;}h2{font-size:15px;}.messageStyle{font-weight:bold;font-family:arial;font-size:10px;margin-bottom:8px;}.adminButton{border:solid silver 1px;background-color:#e0e0e0;font-weight:bold;font-size:10px;color:#333;cursor:pointer;padding:0.5em 1em;}.adminTable{border:solid silver 1px;background-color:#F0F0F0;color:black;width:320px;padding:5px;}.adminTable select,.adminTable input,.adminTable textarea{border:solid gray 1px;font-size:10px;padding-left:5px;}.label{white-space:nowrap;text-align:right;padding-right:10px;font-weight:bold;width:1px;vertical-align:top;}.galleryOrg{position:relative;margin-top:0px;padding-top:0px;margin-left:5px;border:gray solid 1px;text-align:center;margin-top:3px;width:95%;\n	background-color: #DEDEDE}.galleryOrg .left{float:left;width:36%;}.galleryOrg .right{width:63%;}.galleryOrg img{display:block;height:150px;margin:0px auto;}.promote{margin-left:3px;}.promote img{height:14px;width:16px;}.demote{margin-right:3px;}.demote img{height:14px;width:16px;}.delete img{height:14px;}.numbering{position:absolute;top:0px;left:0px;padding:1px;background-color:black;color:white;\n	-moz-border-radius-bottomRight:5px}input.captionEnter{width:93px;clear:both;\n	margin-bottom:3px}.galleryOrg button{border-style:none;background:none;}.galleryOrg button img{width:16px;height:auto;}.galleryOrg .synopsis input{width:80px;}',0),('7fE8md51vTCcuJFOvxNaGA','// Depends on BrowserDetect.js\r\n\r\n// Make the thumbnails a little bigger while the mouse is over them\r\nfunction scaleThumbUp ( e, anchor ) {\r\n	\r\n	// IE6 doesn\'t like to do the right thing with the CSS stuff below, exclude it\r\n	if ( BrowserDetect ) {\r\n		if ( BrowserDetect.browser == \"Explorer\" && BrowserDetect.version < 7 ) {\r\n			return;\r\n		}\r\n	}\r\n\r\n        // Make a new image with the same image src as the anchor\r\n        var oldImage    = anchor.getElementsByTagName(\"img\")[0];\r\n\r\n        var newContainer	= document.createElement(\"div\");\r\n	newContainer.className	= \"thumb-popup\";\r\n        newContainer.style.position = \"absolute\";\r\n        newContainer.style.zIndex   = \"1\";\r\n        var newWidth    = oldImage.offsetWidth * 3;\r\n        var newHeight   = oldImage.offsetHeight * 3;\r\n        var newLeft     = ( ( anchor.offsetLeft + ( anchor.offsetWidth / 2 ) ) - ( newWidth / 2 ) );\r\n        var newTop      = ( ( anchor.offsetTop + ( anchor.offsetHeight / 2 ) ) - ( newHeight / 2 ) ); \r\n        newContainer.style.left     = newLeft + \"px\";\r\n        newContainer.style.top      = newTop + \"px\";\r\n        newContainer.style.width    = newWidth + \"px\";\r\n        newContainer.style.height   = newHeight + \"px\";\r\n\r\n	var newImage    = document.createElement(\"img\");\r\n        newImage.src    = oldImage.src;\r\n	newImage.style.width		= \"100%\";\r\n	newImage.style.height	= \"100%\";\r\n	newContainer.appendChild( newImage );\r\n \r\n        // Make some text for the caption\r\n        var caption         = document.createElement(\"div\");\r\n        caption.appendChild( document.createTextNode( anchor.title ) );\r\n        caption.className       = \"caption\";\r\n    	newContainer.appendChild( caption );\r\n\r\n        var newBox              = document.createElement(\"a\");\r\n        newBox.href             = anchor.href;\r\n        newBox.style.display    = \"block\";\r\n        newBox.style.position   = \"absolute\";\r\n        newBox.style.zIndex     = \"10\";\r\n        newBox.style.left       = ( anchor.offsetLeft ) + \"px\";\r\n        newBox.style.top        = ( anchor.offsetTop ) + \"px\";\r\n        newBox.style.height     = ( anchor.offsetHeight ) + \"px\";\r\n        newBox.style.width      = ( anchor.offsetWidth ) + \"px\";\r\n	newBox.style.border	= \"1px solid transparent\";\r\n\r\n        anchor.parentNode.appendChild( newContainer );\r\n        anchor.parentNode.appendChild( newBox );\r\n\r\n	YAHOO.util.Event.addListener( newBox, \"click\", function () { window.location.href = anchor.href } );\r\n        YAHOO.util.Event.addListener( newContainer, \"mouseout\", scaleThumbDown, [ newBox, newContainer, caption ] );\r\n        YAHOO.util.Event.addListener( newBox, \"mouseout\", scaleThumbDown, [ newBox, newContainer, caption ] );\r\n}\r\n\r\nfunction scaleThumbDown ( e, elements ) {\r\n        for ( var i = 0; i < elements.length; i++ ) {\r\n                elements[i].parentNode.removeChild( elements[i] );\r\n        }\r\n}\r\n\r\nvar anchorTimeout;\r\nfunction enterAnchor ( e, anchor ) {\r\n    if ( typeof anchorTimeout != \"undefined\" ) {\r\n        clearTimeout( anchorTimeout );\r\n    }\r\n    anchorTimeout = setTimeout( function() { scaleThumbUp( e, anchor ); }, 150 );\r\n}\r\n\r\nfunction leaveAnchor ( e, anchor ) {\r\n    if ( typeof anchorTimeout != \"undefined\" ) {\r\n        clearTimeout( anchorTimeout );\r\n    }\r\n}\r\n\r\nfunction initThumb () {\r\n        var anchors = YAHOO.util.Dom.getElementsByClassName( \"thumb\" );\r\n        for ( var i = 0; i < anchors.length; i++ ) {\r\n                YAHOO.util.Event.addListener( anchors[i], \"mouseover\", enterAnchor, anchors[i] );\r\n                YAHOO.util.Event.addListener( anchors[i], \"mouseout\", leaveAnchor, anchors[i] );\r\n        }\r\n}\r\n\r\nYAHOO.util.Event.onDOMReady( initThumb );\r\n',0,'text/javascript',1209503742,3600,'function scaleThumbUp(e,f){if(BrowserDetect){if(BrowserDetect.browser==\"Explorer\"&&BrowserDetect.version<7){return}}var h=f.getElementsByTagName(\"img\")[0];var a=document.createElement(\"div\");a.className=\"thumb-popup\";a.style.position=\"absolute\";a.style.zIndex=\"1\";var c=h.offsetWidth*3;var d=h.offsetHeight*3;var b=((f.offsetLeft+(f.offsetWidth/ 2 ) ) - ( c/2));var newTop=((anchor.offsetTop+(anchor.offsetHeight/ 2 ) ) - ( d /2));a.style.left=b+\"px\";a.style.top=newTop+\"px\";a.style.width=c+\"px\";a.style.height=d+\"px\";var i=document.createElement(\"img\");i.src=h.src;i.style.width=\"100%\";i.style.height=\"100%\";a.appendChild(i);var g=document.createElement(\"div\");g.appendChild(document.createTextNode(f.title));g.className=\"caption\";a.appendChild(g);var j=document.createElement(\"a\");j.href=f.href;j.style.display=\"block\";j.style.position=\"absolute\";j.style.zIndex=\"10\";j.style.left=(f.offsetLeft)+\"px\";j.style.top=(f.offsetTop)+\"px\";j.style.height=(f.offsetHeight)+\"px\";j.style.width=(f.offsetWidth)+\"px\";j.style.border=\"1px solid transparent\";f.parentNode.appendChild(a);f.parentNode.appendChild(j);YAHOO.util.Event.addListener(j,\"click\",function(){window.location.href=f.href});YAHOO.util.Event.addListener(a,\"mouseout\",scaleThumbDown,[j,a,g]);YAHOO.util.Event.addListener(j,\"mouseout\",scaleThumbDown,[j,a,g])}function scaleThumbDown(e,a){for(var i=0;i<a.length;i++){a[i].parentNode.removeChild(a[i])}}var anchorTimeout;function enterAnchor(e,a){if(typeof anchorTimeout!=\"undefined\"){clearTimeout(anchorTimeout)}anchorTimeout=setTimeout(function(){scaleThumbUp(e,a)},150)}function leaveAnchor(e,a){if(typeof anchorTimeout!=\"undefined\"){clearTimeout(anchorTimeout)}}function initThumb(){var a=YAHOO.util.Dom.getElementsByClassName(\"thumb\");for(var i=0;i<a.length;i++){YAHOO.util.Event.addListener(a[i],\"mouseover\",enterAnchor,a[i]);YAHOO.util.Event.addListener(a[i],\"mouseout\",leaveAnchor,a[i])}}YAHOO.util.Event.onDOMReady(initThumb);',0),('4e-_rNs6mSWedZhQ_V5kJA','.wgShelf .product {\r\n	margin:15px;\r\n	margin-left:0px;		\r\n	float:left;\r\n	text-align:left;\r\n	background-color:#f1f1f1;\r\n	border:solid #e1e1e1 1px;\r\n	min-height:100px;\r\n	min-width:200px;\r\n	width:200px;\r\n	height:100px;\r\n}\r\n.wgShelf .product .link {\r\n	background: url(^FileUrl(root/import/shelf2/images/shelf-titles.jpg);) no-repeat top right;\r\n	height:30px;\r\n	padding:3px;\r\n	line-height:24px;\r\n	margin-bottom:5px;	\r\n	text-align:left;\r\n	display:block;		\r\n}',0,'text/css',1210779672,0,'.wgShelf .product{margin:15px;margin-left:0px;float:left;text-align:left;background-color:#f1f1f1;border:solid #e1e1e1 1px;min-height:100px;min-width:200px;width:200px;height:100px;}.wgShelf .product .link{background:url(^FileUrl(root/import/shelf2/images/shelf-titles.jpg);) no-repeat top right;height:30px;padding:3px;line-height:24px;margin-bottom:5px;text-align:left;display:block;}',0),('usuxw9V3jN4d4pujRiEYxg','#contentArea {\r\n	height:500px;\r\n	padding-bottom:300px;\r\n}',0,'text/css',1209494150,1,'#contentArea{height:500px;padding-bottom:300px;}',0),('5m5I7__l40C4hhv4ydqAHQ','#thingyList .things {\r\n	padding:0px;\r\n	margin:0px;\r\n	width:200px;\r\n	z-index:5000;\r\n	position:absolute;\r\n	top:27px;\r\n	left:20px;\r\n	border:solid #a2a2a2 1px;\r\n	border-top-style:none;\r\n}\r\n\r\n#thingyList .things a:link,\r\n#thingyList .things a:visited {\r\n	display:block;\r\n	background-color:#f1f1f1;\r\n	border-top:solid #a2a2a2 1px;	\r\n	border-bottom:solid #727272 1px;\r\n	line-height:12px;\r\n	font-size:10px;\r\n	height:12px;\r\n	padding:2px 5px;\r\n	text-decoration:none;\r\n	font-weight:bold;\r\n	color:#a2a2a2;\r\n	width:190px;\r\n}\r\n#thingyList .things a:hover {\r\n	background-color:white;\r\n}',0,'text/css',1216227786,3600,'#thingyList .things{padding:0px;margin:0px;width:200px;z-index:5000;position:absolute;top:27px;left:20px;border:solid #a2a2a2 1px;border-top-style:none;}#thingyList .things a:link,#thingyList .things a:visited{display:block;background-color:#f1f1f1;border-top:solid #a2a2a2 1px;border-bottom:solid #727272 1px;line-height:12px;font-size:10px;height:12px;padding:2px 5px;text-decoration:none;font-weight:bold;color:#a2a2a2;width:190px;}#thingyList .things a:hover{background-color:white;}',0),('1oGhfj00KkCzP1ez01AfKA','if ( typeof WebGUI == \"undefined\" ) {\r\n    WebGUI  = {};\r\n}\r\n\r\n/**\r\n    WebGUI.Slideshow ( config ) \r\n    Configure and return a new Slideshow object. \r\n    config is an object with the following properties:\r\n        containerId         - The ID of the element that contains the Slideshow \r\n                              items. Defaults to \"slideshow-container\"\r\n        currentIndex        - The index of the first item in the Slideshow. \r\n                              Defaults to 0\r\n        isPlaying           - If true, the slideshow will begin immediately\r\n        itemClassName       - The class name of the slideshow items. Defaults to \r\n                              \"slideshow-item\"\r\n        nextButtonId        - The id of the button to go to the next item\r\n        pauseImageSrc       - The URL to the pause button image\r\n        playDelay           - The delay (in milliseconds) between slides. Defaults \r\n                              to 5000\r\n        playImageSrc        - The URL to the play button image\r\n        playPauseButtonId   - The id of the button to toggle between play and pause\r\n	previousButtonId    - The id of the button to go to the previous item\r\n        wrap                - If true, the slideshow will wrap around\r\n\r\n\r\n    *** Control the slideshow\r\n    To control the slideshow, you can use the following methods:\r\n        next()          - Pause the slideshow and go to the next slide\r\n        previous()      - Pause the slideshow and go to the previous slide\r\n        play()          - Play the slideshow\r\n        pause()         - Pause the slideshow\r\n        togglePlay()    - If it\'s playing, pause it. If it\'s paused, play it.\r\n\r\n*/\r\nWebGUI.Slideshow \r\n= function ( config ) {\r\n    this.containerId        = config && config.containerId   ? config.containerId       : \"slideshow-container\";\r\n    this.currentIndex       = config && config.currentIndex  ? config.currentIndex      : 0;\r\n    this.isPlaying          = config && config.isPlaying     ? config.isPlaying         : false;\r\n    this.itemClassName      = config && config.itemClassName ? config.itemClassName     : \"slideshow-item\";\r\n    this.nextButtonId       = config                         ? config.nextButtonId      : undefined;\r\n    this.pauseImageSrc      = config                         ? config.pauseImageSrc     : undefined;\r\n    this.playDelay          = config && config.playDelay     ? config.playDelay         : 5000;\r\n    this.playImageSrc       = config                         ? config.playImageSrc      : undefined;\r\n    this.playPauseButtonId  = config                         ? config.playPauseButtonId : undefined;\r\n    this.previousButtonId   = config                         ? config.previousButtonId  : undefined;\r\n    this.wrap               = config && config.wrap          ? config.wrap              : false;\r\n\r\n    YAHOO.util.Event.onDOMReady( this.init, this, true );\r\n};\r\n\r\n/**\r\n    clearPlayTimeout ( )\r\n    Clears the timeout to move to the next slide\r\n*/\r\nWebGUI.Slideshow.prototype.clearPlayTimeout\r\n= function () {\r\n    clearTimeout( this.playTimeout );\r\n    this.playTimeout    = undefined;\r\n}\r\n\r\n/**\r\n    doPlayTick ( self )\r\n    Performs the action to move to the next slide and start a new timeout.\r\n    self is a new reference to the object to get around the scoping issues\r\n    with setTimeout()\r\n*/\r\nWebGUI.Slideshow.prototype.doPlayTick\r\n= function (self) {\r\n    self.showNext();\r\n    self.setPlayTimeout();\r\n}\r\n\r\n/**\r\n    getSlideshowContainer ( )\r\n    Returns the HTMLElement for the Slideshow container.\r\n*/\r\nWebGUI.Slideshow.prototype.getSlideshowContainer \r\n= function () {\r\n    return document.getElementById( this.containerId );\r\n};\r\n\r\n/**\r\n    getSlideshowItems ( )\r\n    Returns an array of HTMLElements for the Slideshow\'s items.\r\n*/\r\nWebGUI.Slideshow.prototype.getSlideshowItems\r\n= function () {\r\n    var items  \r\n        = YAHOO.util.Dom.getElementsByClassName( \r\n            this.itemClassName, \r\n            undefined, \r\n            this.getSlideshowContainer() \r\n        );\r\n    return items;\r\n};\r\n\r\n/**\r\n    init ( )\r\n    Initialize the slideshow. Performed after the DOM is ready.\r\n*/\r\nWebGUI.Slideshow.prototype.init\r\n= function () {\r\n\r\n\r\n    \r\n    // Add handlers to buttons\r\n    if ( this.playPauseButtonId ) {\r\n        YAHOO.util.Event.addListener( this.playPauseButtonId, \"click\", this.togglePlay, this, true );\r\n    }\r\n    if ( this.nextButtonId ) {\r\n        YAHOO.util.Event.addListener( this.nextButtonId, \"click\", this.next, this, true );\r\n    }\r\n    if ( this.previousButtonId ) {\r\n        YAHOO.util.Event.addListener( this.previousButtonId, \"click\", this.previous, this, true );\r\n    }\r\n    \r\n    // Hide all but the currentIndex\r\n    var items   = this.getSlideshowItems();\r\n    for ( var i = 0; i < items.length; i++ ) {\r\n        if ( i != this.currentIndex ) {\r\n            items[ i ].style.display = \"none\";\r\n        }\r\n        else {\r\n            items[ i ].style.display = \"block\";\r\n        }\r\n    }\r\n\r\n    // Start it off if necessary\r\n    if ( this.isPlaying ) {\r\n        this.setPlayTimeout();\r\n        this.updatePlayPauseButton();\r\n    }\r\n};\r\n\r\n/**\r\n    next ( )\r\n    Pause the slideshow and go to the next slide\r\n*/\r\nWebGUI.Slideshow.prototype.next\r\n= function () {\r\n    this.pause();\r\n    this.showNext();\r\n}\r\n\r\n/**\r\n    play ( )\r\n    Start the slideshow\r\n*/\r\nWebGUI.Slideshow.prototype.play\r\n= function () {\r\n    if ( !this.isPlaying ) {\r\n        this.isPlaying  = true;\r\n        this.setPlayTimeout();\r\n        this.updatePlayPauseButton();\r\n    }\r\n}\r\n\r\n/**\r\n    previous ( )\r\n    Pause the slideshow and show the previous slide\r\n*/\r\nWebGUI.Slideshow.prototype.previous \r\n= function () {\r\n    this.pause();\r\n    this.showPrevious();\r\n}\r\n\r\n/**\r\n    pause ( )\r\n    Pause the slideshow\r\n*/\r\nWebGUI.Slideshow.prototype.pause\r\n= function () {\r\n    if ( this.isPlaying ) {\r\n        this.isPlaying  = false;\r\n        this.clearPlayTimeout();\r\n        this.updatePlayPauseButton();\r\n    }\r\n}\r\n\r\n/**\r\n    setPlayTimeout ( )\r\n    Sets the timeout to move to the next slide\r\n*/\r\nWebGUI.Slideshow.prototype.setPlayTimeout\r\n= function () {\r\n    var self    = this;\r\n    this.playTimeout = setTimeout( function () { self.doPlayTick(self) }, this.playDelay );\r\n}\r\n\r\n/**\r\n    showNext ( )\r\n    Show the next slide.\r\n*/\r\nWebGUI.Slideshow.prototype.showNext\r\n= function () {\r\n    var items       = this.getSlideshowItems();\r\n    \r\n    var hideIndex   = this.currentIndex;\r\n    var showIndex   = this.currentIndex + 1;\r\n\r\n    // Wrap around\r\n    if ( this.wrap && showIndex >= items.length ) {\r\n        showIndex   = 0;\r\n    }\r\n    // Don\'t allow going past the last item\r\n    else if ( showIndex >= items.length ) { \r\n        return;\r\n    }\r\n\r\n    // Do the switch\r\n    if ( items[ hideIndex ] )\r\n        items[ hideIndex ].style.display  = \"none\";\r\n    if ( items[ showIndex ] ) {\r\n        items[ showIndex ].style.display  = \"block\";\r\n        this.currentIndex   = showIndex;\r\n    }\r\n};\r\n\r\n/**\r\n    showPrevious ( )\r\n    Show the previous slide\r\n*/\r\nWebGUI.Slideshow.prototype.showPrevious\r\n= function () {\r\n    var items       = this.getSlideshowItems();\r\n    \r\n    var hideIndex   = this.currentIndex;\r\n    var showIndex   = this.currentIndex - 1;\r\n\r\n    // Wrap around\r\n    if ( this.wrap && showIndex < 0 ) {\r\n        showIndex   = items.length - 1;\r\n    }\r\n    // Don\'t allow going past the last item\r\n    else if ( showIndex < 0 ) { \r\n        return;\r\n    }\r\n\r\n    // Do the switch\r\n    items[ hideIndex ].style.display  = \"none\";\r\n    items[ showIndex ].style.display  = \"block\";\r\n    this.currentIndex   = showIndex;\r\n};\r\n\r\n/**\r\n    togglePlay ( )\r\n    If it\'s paused, play it. If it\'s playing, pause it.\r\n    Return true if the slideshow is now playing.\r\n*/\r\nWebGUI.Slideshow.prototype.togglePlay\r\n= function () {\r\n    if ( this.isPlaying  == false ) {\r\n        this.play();\r\n        return true;\r\n    }\r\n    else {\r\n        this.pause();\r\n    }\r\n};\r\n\r\n/**\r\n    updatePlayPauseButton ( )\r\n    Update the Play/Pause button to have the correct image\r\n*/\r\nWebGUI.Slideshow.prototype.updatePlayPauseButton\r\n= function () {\r\n    if ( this.playPauseButtonId ) {\r\n        if ( this.isPlaying && this.playImageSrc ) {\r\n            document.getElementById( this.playPauseButtonId ).src = this.pauseImageSrc;\r\n        }\r\n        else if ( this.pauseImageSrc ) {\r\n            document.getElementById( this.playPauseButtonId ).src = this.playImageSrc;\r\n        }\r\n    }\r\n};',0,'text/javascript',1218582812,3600,'if(typeof WebGUI==\"undefined\"){WebGUI={}}WebGUI.Slideshow=function(a){this.containerId=a&&a.containerId?a.containerId:\"slideshow-container\";this.currentIndex=a&&a.currentIndex?a.currentIndex:0;this.isPlaying=a&&a.isPlaying?a.isPlaying:false;this.itemClassName=a&&a.itemClassName?a.itemClassName:\"slideshow-item\";this.nextButtonId=a?a.nextButtonId:undefined;this.pauseImageSrc=a?a.pauseImageSrc:undefined;this.playDelay=a&&a.playDelay?a.playDelay:5000;this.playImageSrc=a?a.playImageSrc:undefined;this.playPauseButtonId=a?a.playPauseButtonId:undefined;this.previousButtonId=a?a.previousButtonId:undefined;this.wrap=a&&a.wrap?a.wrap:false;YAHOO.util.Event.onDOMReady(this.init,this,true)};WebGUI.Slideshow.prototype.clearPlayTimeout=function(){clearTimeout(this.playTimeout);this.playTimeout=undefined}WebGUI.Slideshow.prototype.doPlayTick=function(a){a.showNext();a.setPlayTimeout()}WebGUI.Slideshow.prototype.getSlideshowContainer=function(){return document.getElementById(this.containerId)};WebGUI.Slideshow.prototype.showPrevious=function(){var items=this.getSlideshowItems();var hideIndex=this.currentIndex;var showIndex=this.currentIndex-1;if(this.wrap&&showIndex<0){showIndex=items.length-1}/**\n    togglePlay ( )\n    If it\'s paused,play it.If it\'s playing,pause it.Return true if the slideshow is now playing.*/WebGUI.Slideshow.prototype.togglePlay=function(){if(this.isPlaying==false){this.play();return true}else{this.pause()}};WebGUI.Slideshow.prototype.updatePlayPauseButton=function(){if(this.playPauseButtonId){if(this.isPlaying&&this.playImageSrc){document.getElementById(this.playPauseButtonId).src=this.pauseImageSrc}else if(this.pauseImageSrc){document.getElementById(this.playPauseButtonId).src=this.playImageSrc}}};',0),('1XOJDcg_ITRYwVM-QnIcPw','	.wgShelf {\r\n		font-size:12px;\r\n		font-family:arial, verdana;		\r\n		margin:15px 0px;\r\n	}\r\n	.wgShelf h2 {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgShelf .wgShelves {\r\n		background: #F1F1F1;\r\n		height:29px;\r\n		padding:3px;\r\n		line-height:29px;\r\n		padding-left:30px;\r\n	}\r\n	.wgShelf .product {\r\n		margin:15px;\r\n		margin-left:0px;		\r\n		text-align:left;\r\n		background-color:#f1f1f1;\r\n		border:solid #e1e1e1 1px;\r\n		width: 200px;\r\n		display: -moz-inline-box; /* Moz */\r\n		display: inline-block; /* Op, Saf, IE \\*/\r\n		vertical-align: top; /* IE Mac non capisce e a volte crea extra v space */\r\n	}\r\n	.wgShelf .product .thumbnail {\r\n		display:block;\r\n		text-align:left;\r\n		margin:3px;\r\n		float:left;\r\n	}\r\n	.wgShelf .product .link {\r\n		background: #e1e1e1;\r\n		height:30px;\r\n		padding:3px;\r\n		line-height:24px;\r\n		margin-bottom:5px;	\r\n		text-align:left;\r\n		display:block;\r\n	}\r\n	.wgShelf .product .link a:link,\r\n	.wgShelf .product .link a:visited	{\r\n		color:#000;		\r\n		display:block;\r\n	}\r\n	.wgShelf .product .link a:hover {\r\n		text-decoration:underline;\r\n	}\r\n	.wgShelf .product .price {\r\n		display:block;\r\n		text-align:right;\r\n		font-size:18px;\r\n		font-weight:bold;\r\n	}',0,'text/css',1219175575,0,'.wgShelf{font-size:12px;font-family:arial,verdana;margin:15px 0px;}.wgShelf h2{background:black;padding:5px;padding-left:15px;line-height:32px;color:white;margin:0px;height:32px;}.wgShelf .wgShelves{background:#F1F1F1;height:29px;padding:3px;line-height:29px;padding-left:30px;}.wgShelf .product{margin:15px;margin-left:0px;text-align:left;background-color:#f1f1f1;border:solid #e1e1e1 1px;width:200px;display:-moz-inline-box;display:inline-block;/*\\*/\n		vertical-align:top; /**/}.wgShelf .product .thumbnail{display:block;text-align:left;margin:3px;float:left;}.wgShelf .product .link{background:#e1e1e1;height:30px;padding:3px;line-height:24px;margin-bottom:5px;text-align:left;display:block;}.wgShelf .product .link a:link,.wgShelf .product .link a:visited{color:#000;display:block;}.wgShelf .product .link a:hover{text-decoration:underline;}.wgShelf .product .price{display:block;text-align:right;font-size:18px;font-weight:bold;}',0),('THQhn1C-ooj-TLlEP7aIJQ','.wgPicture {\r\n	float:left;\r\n}\r\n.wgAlbum {\r\n	float:left;\r\n}\r\n.wgGallery .pagination li, \r\n.wgGallery .pagination a {\r\n	float:left;\r\n}\r\n.wgGallery .container {\r\n	display:inline-block;\r\n}',0,'text/html',1225313951,3600,'.wgPicture { float:left; }.wgAlbum { float:left; }.wgGallery .pagination li, .wgGallery .pagination a { float:left; }.wgGallery .container { display:inline-block; }',0),('7-0-style0000000000051','body, html {\r\n        margin:0px;\r\n        background-color:#b53018;\r\n        padding:0px;\r\n}\r\nbody a {\r\n        color:#EE963E;font-weight:bold;\r\n letter-spacing:1px;\r\n font-size:8pt;\r\n}\r\n#main {\r\n        width:98%;\r\n        /*min-width:790px;*/\r\n        margin:0px;\r\n        padding:0px;\r\n        padding-top:20px;\r\n        padding-bottom:20px;\r\n        position:relative;\r\n}\r\n#header { \r\n        background: url(\'^FileUrl(style3/header_bg.jpg);\') repeat-x;\r\n        width:100%;\r\n        margin:0px;\r\n        height:115px;\r\n}\r\n#headerTitle {\r\n        background: url(\'^FileUrl(style3/header_left.jpg);\') no-repeat left top;\r\n        height:100%;\r\n        width:100%;\r\n}\r\n#headerRight {\r\n        background: url(\'^FileUrl(style3/header_right.jpg);\') no-repeat right top;\r\n        width:100%;\r\n        height:100%;\r\n        text-align:right;\r\n        position:relative;\r\n}\r\n#headerRight #title {\r\n        position:absolute;\r\n        top:25px;\r\n        left:20px;\r\n        font-family:arial;\r\n        text-align:left;\r\n}\r\n#title h1 {\r\n        text-transform:uppercase;\r\n        margin-bottom:0px;\r\n        font-weight:normal;\r\n        font-size:26pt;\r\n        margin-top:0px;\r\n        color:white;\r\n}\r\n#title h1 a {\r\n        color:white;\r\n        text-decoration:none; font-size: 26pt; font-weight: normal; \r\n}\r\n#title h2 {\r\n        margin:0px;\r\n        font-size:12pt;\r\n        color:#bebebe;\r\n        padding-left:20px;\r\n}\r\n#title img {\r\n        z-index:5;\r\n}\r\n#login {\r\n        position:absolute;\r\n        font-size:8pt;\r\n        top:45%;\r\n        right:150px;\r\n        color:white;\r\n        z-index:6;\r\n        font-family:arial;\r\n}\r\n#login a {\r\n        color:white; font-weight: normal; letter-spacing: 0px;\r\n}\r\n.loginBox {\r\n        font-size:8pt;\r\n        margin:0px;\r\n        display:inline;\r\n}\r\n.loginBox input {\r\n        font-size:8pt;\r\n}\r\n\r\n#mainBody {\r\n        width:100%;\r\n        margin:0px;\r\n        height:500px;\r\n        background: #fff;\r\n        position:relative;\r\n	z-index:0;\r\n}\r\n#main > #mainBody {\r\n        height:auto;\r\n        min-height:500px;\r\n}\r\n#contentArea {\r\n        z-index:2;\r\n        position:relative;\r\n        padding-top:10px;\r\n        padding-left:10px;\r\n        padding-right:20px;\r\n        padding-bottom:20px;\r\n        -moz-box-sizing:border-box;\r\n        font-family:verdana;\r\n        font-size:9pt;\r\n	min-height:500px;\r\n}\r\nhtml #main #mainBody #contentArea {\r\n        height:1%;\r\n}\r\n#topCorner {\r\n        width:100%;\r\n        height:214px;\r\n        position:absolute;\r\n        top:0px;\r\n        left:0px;\r\n        background: url(^FileUrl(/style3/main_top.jpg);) no-repeat;\r\n        z-index:1;\r\n}\r\n#bottomCorner {\r\n        width:100%;\r\n        height:211px;\r\n        position:absolute;\r\n        bottom:59px;\r\n        right:0px;\r\n        background: url(\'^FileUrl(style3/main_bottom.jpg);\') no-repeat right;\r\n        z-index:1;\r\n}\r\n* html #bottomCorner {\r\n	bottom:58px;\r\n}\r\n\r\n#footer {\r\n        width:100%;\r\n        margin:0px;\r\n        background:#000 url(\'^FileUrl(style3/footer_right.jpg);\') no-repeat right top;\r\n        height:57px;\r\n        border-top:solid #B53018 2px;\r\n        text-align:right;\r\n        position:relative;\r\n		z-index:0;\r\n}\r\n#footer #copyright {\r\n        color:#3b3b3b;\r\n        font-family:arial;\r\n        position:absolute;\r\n        top:20px;\r\n        left:30px;\r\n        font-size:8pt;\r\n}\r\n#main .yui-skin-sam {\r\n	font-family:verdana;\r\n        font-size:9pt;\r\n        font-weight:normal;\r\n}',0,'text/css',1224117026,3600,'body,html{margin:0px;background-color:#b53018;padding:0px;}body a{color:#EE963E;font-weight:bold;letter-spacing:1px;font-size:8pt;}#main{width:98%;margin:0px;padding:0px;padding-top:20px;padding-bottom:20px;position:relative;}#header{background:url(\'^FileUrl(style3/header_bg.jpg);\') repeat-x;width:100%;margin:0px;height:115px;}#headerTitle{background:url(\'^FileUrl(style3/header_left.jpg);\') no-repeat left top;height:100%;width:100%;}#headerRight{background:url(\'^FileUrl(style3/header_right.jpg);\') no-repeat right top;width:100%;height:100%;text-align:right;position:relative;}#headerRight #title{position:absolute;top:25px;left:20px;font-family:arial;text-align:left;}#title h1{text-transform:uppercase;margin-bottom:0px;font-weight:normal;font-size:26pt;margin-top:0px;color:white;}#title h1 a{color:white;text-decoration:none;font-size:26pt;font-weight:normal;}#title h2{margin:0px;font-size:12pt;color:#bebebe;padding-left:20px;}#title img{z-index:5;}#login{position:absolute;font-size:8pt;top:45%;right:150px;color:white;z-index:6;font-family:arial;}#login a{color:white;font-weight:normal;letter-spacing:0px;}.loginBox{font-size:8pt;margin:0px;display:inline;}.loginBox input{font-size:8pt;}#mainBody{width:100%;margin:0px;height:500px;background:#fff;position:relative;z-index:0;}#main > #mainBody{height:auto;min-height:500px;}#contentArea{z-index:2;position:relative;padding-top:10px;padding-left:10px;padding-right:20px;padding-bottom:20px;-moz-box-sizing:border-box;font-family:verdana;font-size:9pt;min-height:500px;}html #main #mainBody #contentArea{height:1%;}#topCorner{width:100%;height:214px;position:absolute;top:0px;left:0px;background:url(^FileUrl(/style3/main_top.jpg);) no-repeat;z-index:1;}#bottomCorner{width:100%;height:211px;position:absolute;bottom:59px;right:0px;background:url(\'^FileUrl(style3/main_bottom.jpg);\') no-repeat right;z-index:1;}* html #bottomCorner{bottom:58px;}#footer{width:100%;margin:0px;background:#000 url(\'^FileUrl(style3/footer_right.jpg);\') no-repeat right top;height:57px;border-top:solid #B53018 2px;text-align:right;position:relative;z-index:0;}#footer #copyright{color:#3b3b3b;font-family:arial;position:absolute;top:20px;left:30px;font-size:8pt;}#main .yui-skin-sam{font-family:verdana;font-size:9pt;font-weight:normal;}',0),('kJf77eCr9GAMiEzWrzsBTA','.matrixLeft .buttons span,\r\n.matrixRight .buttons span {\r\n	padding:0px 0px 0px 0px;\r\n}\r\n\r\n.matrixLeft .buttons button,\r\n.matrixRight .buttons a {\r\n	top:-3px;\r\n	left:-2px;\r\n	height:22px;\r\n}\r\n.matrixRight .buttons a {\r\n	color:black;\r\n	text-decoration:none;\r\n	padding:1px 3px;\r\n}',0,'text/css',1229639255,3600,'.matrixLeft .buttons span,.matrixRight .buttons span{padding:0px 0px 0px 0px;}.matrixLeft .buttons button,.matrixRight .buttons a{top:-3px;left:-2px;height:22px;}.matrixRight .buttons a{color:black;text-decoration:none;padding:1px 3px;}',0),('4LQT4-bGW4FkiEQLSY5gvQ','function showHide(theLink,theId) {\r\n	var theId = document.getElementById(theId);\r\n	var theLink = document.getElementById(theLink);\r\n	if(theId.style.display == \'block\') {\r\n		theId.style.display = \'none\';\r\n		theLink.innerHTML = \"Send Creator a Message\";\r\n		theLink.className = \"showLink\"\r\n	}\r\n	else {\r\n		theId.style.display = \'block\';\r\n		theLink.innerHTML = \"Hide\";	\r\n		theLink.className = \"hideLink\"		\r\n	}\r\n}',0,'text/javascript',1232400287,0,'function showHide(b,a){var a=document.getElementById(a);var b=document.getElementById(b);if(a.style.display==\'block\'){a.style.display=\'none\';b.innerHTML=\"Send Creator a Message\";b.className=\"showLink\"}else{a.style.display=\'block\';b.innerHTML=\"Hide\";b.className=\"hideLink\"}}',0),('wrq7hMxb1ewQqZ46xmd8Gg','function equalCol() {\r\n	var colOne = document.getElementById(\'compareForm\');\r\n	var colTwo = document.getElementById(\'matrixRight\');	\r\n	var colOneH = colOne.offsetHeight;\r\n	var colTwoH = colTwo.offsetHeight;	\r\n	\r\n	//alert(colOneH + \", \" + colTwoH);\r\n	colOne.style.overflow = \"scroll\";\r\n	colOne.style.height = (colTwoH - 150) + \"px\";\r\n}',0,'text/javascript',1235706620,3600,'function equalCol(){var d=document.getElementById(\'compareForm\');var b=document.getElementById(\'matrixRight\');var a=d.offsetHeight;var c=b.offsetHeight;d.style.overflow=\"scroll\";d.style.height=(c-150)+\"px\"}',0),('3n3H85BsdeRQ0I08WmvlOg','.wgThingy {\n	margin:5px;\n}\n\n.wgThingy * .styleButton {\n	color:black;	\n	margin:0px 5px;\n	display:block;\n	float:left;\n}\n.wgThingy * .spacerOne {\n	padding-left:15px;\n}\n\n\n.wgThingy * .rowOne,\n.wgThingy * tr.rowOne td\n {\n	background: #EEEEEE;\n	margin:1px;\n	border:solid #CDCDCD 1px;\n	color:#000;\n	padding:2px;\n}\n.wgThingy * .rowTwo,\n.wgThingy * tr.rowTwo td {\n	background: #DBDBDB;\n	margin:1px;\n	border:solid #DDDDDD 1px;\n	color:#000;	\n	padding:2px;\n}\n.wgThingsWrapper img {	\n	display:block;\n	vertical-align:middle;\n	float:left;\n}\n.wgThingsWrapper .label {\n	font-weight:bold;	\n	padding-left:15px;\n}\n.wgThingy h2.title {\n	background: #000;\n	height:42px;\n	color:white;\n	font-size:18px;\n	font-weight:bold;\n	letter-spacing:1px;			\n	line-height:42px;\n	padding-left:15px;\n	margin-bottom:0px;\n}\n\n.wgThingy * span.smaller {\n	font-size:13px;\n	color:white;\n}\n.wgThingy .controls {\n	line-height:35px;\n	height:35px;\n	background: #f1f1f1;	\n	margin-top:0px;\n	margin-bottom:20px;\n	padding:0px;\n}\n\n\n.wgThingy * .label {\n	background:black;\n	color:white;\n	padding:2px 5px;\n	font-family:arial;\n	font-size:11px;\n	font-weight:bold;\n	vertical-align:middle;\n}\n.wgThingy .label a {\n	color:white;\n}\n\n.searchTable * input,\n.editThing * input {\n	background: white;\n	border:solid #555 1px;\n}\n\n\n\n\n.editThing {\n	margin-top:15px;	\n}	\n\n\n\n#thingyList, #thingyList * {\n	margin:0px;\n	padding:0px;\n}\n#thingyList {\n	position:relative;	\n	float:left;\n}\n#thingyList .goButton:link,\n#thingyList .goButton:visited {\n	padding:2px 25px 2px 2px;\n	background: #F1F1F1 url(^FileUrl(root/import/thingy-templates/images/go-btn.gif);) no-repeat right;\n	line-height:20px;\n	border:solid #a2a2a2 1px;\n	color:#a2a2a2;\n	text-decoration:none;\n	font-family:verdana, arial;\n	font-size:10px;\n	font-weight:bold;\n	margin-left:20px;\n	letter-spacing:0px;\n}\n#thingyList .goButton:hover {\n	background-color:white;\n}\n#thingyList .things {\n	padding:0px;\n	margin:0px;\n	width:300px;\n	z-index:5000;\n	position:absolute;\n	top:27px;\n	left:20px;\n	border:solid #a2a2a2 1px;\n	border-top-style:none;\n}\n#thingyList .things a:link,\n#thingyList .things a:visited {\n	display:block;\n	background-color:#f1f1f1;\n	border-top:solid #a2a2a2 1px;	\n	border-bottom:solid #727272 1px;\n	line-height:12px;\n	font-size:10px;\n	height:12px;\n	padding:2px 5px;\n	text-decoration:none;\n	font-weight:bold;\n	color:#a2a2a2;\n}\n#thingyList .things a:hover {\n	background-color:white;\n}',0,'text/css',1245107956,1,'.wgThingy{margin:5px;}.wgThingy * .styleButton{color:black;margin:0px 5px;display:block;float:left;}.wgThingy * .spacerOne{padding-left:15px;}.wgThingy * .rowOne,.wgThingy * tr.rowOne td{background:#EEEEEE;margin:1px;border:solid #CDCDCD 1px;color:#000;padding:2px;}.wgThingy * .rowTwo,.wgThingy * tr.rowTwo td{background:#DBDBDB;margin:1px;border:solid #DDDDDD 1px;color:#000;padding:2px;}.wgThingsWrapper img{display:block;vertical-align:center;float:left;}.wgThingsWrapper .label{font-weight:bold;padding-left:15px;}.wgThingy h2.title{background:#000;height:42px;color:white;font-size:18px;font-weight:bold;letter-spacing:1px;line-height:42px;padding-left:15px;margin-bottom:0px;}.wgThingy * span.smaller{font-size:13px;color:white;}.wgThingy .controls{line-height:35px;height:35px;background:#f1f1f1;margin-top:0px;margin-bottom:20px;padding:0px;}.wgThingy * .label{background:black;color:white;padding:2px 5px;font-family:arial;font-size:11px;font-weight:bold;vertical-align:middle;}.wgThingy .label a{color:white;}.searchTable * input,.editThing * input{background:white;border:solid #555 1px;}.editThing{margin-top:15px;}#thingyList,#thingyList *{margin:0px;padding:0px;}#thingyList{position:relative;float:left;}#thingyList .goButton:link,#thingyList .goButton:visited{padding:2px 25px 2px 2px;background:#F1F1F1 url(^FileUrl(root/import/thingy-templates/images/go-btn.gif);) no-repeat right;line-height:20px;border:solid #a2a2a2 1px;color:#a2a2a2;text-decoration:none;font-family:verdana,arial;font-size:10px;font-weight:bold;margin-left:20px;letter-spacing:0px;}#thingyList .goButton:hover{background-color:white;}#thingyList .things{padding:0px;margin:0px;width:300px;z-index:5000;position:absolute;top:27px;left:20px;border:solid #a2a2a2 1px;border-top-style:none;}#thingyList .things a:link,#thingyList .things a:visited{display:block;background-color:#f1f1f1;border-top:solid #a2a2a2 1px;border-bottom:solid #727272 1px;line-height:12px;font-size:10px;height:12px;padding:2px 5px;text-decoration:none;font-weight:bold;color:#a2a2a2;}#thingyList .things a:hover{background-color:white;}',0),('FEDP3dk8J3Chw_gyr7_XEQ','/*/Horizontal Menu styles/*/\r\n.horizontalMenu ul.menu {\r\n	padding: 0;\r\n	margin: 0 0 1em;\r\n	list-style: none;\r\n	width: 100%;	/*/clear floated li elements/*/\r\n	overflow: auto;	/*/clear floated li elements/*/\r\n}\r\n.horizontalMenu ul.menu li {\r\n	float: left;\r\n}\r\n.horizontalMenu ul.menu li a {\r\n	float: left;\r\n	padding: 4px 8px;\r\n	margin-right: 1px;\r\n	background: #ddd;\r\n	color: #000;\r\n	text-decoration: none;\r\n}\r\n.horizontalMenu ul.menu li.current a {\r\n	background:#eee;\r\n}\r\n.horizontalMenu ul.menu li a:hover {\r\n	background:#fff;\r\n}\r\n\r\n/*/Tabs (tabbed navigation) styles/*/\r\n.tabsMenu ul.menu {\r\n	margin: 0 0 1em;\r\n}\r\n.tabsMenu ul.menu li {\r\n	display: inline;\r\n}\r\n.tabsMenu ul.menu li a {\r\n	border: 1px solid #999;\r\n	border-bottom: 0;\r\n	padding: 5px 10px 2px;\r\n	color: #777;\r\n	text-decoration:none;\r\n}\r\n.tabsMenu ul.menu li.current a,\r\n.tabsMenu ul.menu li a:hover {\r\n	border: 1px solid #000;\r\n	border-bottom: 0;\r\n	color: #000;\r\n}\r\n\r\n/*/Indent Nav styles/*/\r\n.indentMenu a.level0 {\r\n	margin-left:0px;\r\n	display:block;\r\n}\r\n.indentMenu a.level1 {\r\n	margin-left:15px;\r\n	display:block;	\r\n}\r\n.indentMenu a.level2 {\r\n	margin-left:30px;\r\n	display:block;\r\n}\r\n.indentMenu a.level3 {\r\n	margin-left:45px;\r\n	display:block;\r\n}\r\n.indentMenu a.level4 {\r\n	margin-left:60px;\r\n	display:block;\r\n}',0,'text/css',1246278679,3600,'/*/Horizontal Menu styles/*/ .horizontalMenu ul.menu { padding: 0; margin: 0 0 1em; list-style: none; width: 100%;	/*/clear floated li elements/*/ overflow: auto;	/*/clear floated li elements/*/ }.horizontalMenu ul.menu li { float: left; }.horizontalMenu ul.menu li a { float: left; padding: 4px 8px; margin-right: 1px; background: #ddd; color: #000; text-decoration: none; }.horizontalMenu ul.menu li.current a { background:#eee; }.horizontalMenu ul.menu li a:hover { background:#fff; }/*/Tabs (tabbed navigation) styles/*/ .tabsMenu ul.menu { margin: 0 0 1em; }.tabsMenu ul.menu li { display: inline; }.tabsMenu ul.menu li a { border: 1px solid #999; border-bottom: 0; padding: 5px 10px 2px; color: #777; text-decoration:none; }.tabsMenu ul.menu li.current a, .tabsMenu ul.menu li a:hover { border: 1px solid #000; border-bottom: 0; color: #000; }/*/Indent Nav styles/*/ .indentMenu a.level0 { margin-left:0px; display:block; }.indentMenu a.level1 { margin-left:15px; display:block; }.indentMenu a.level2 { margin-left:30px; display:block; }.indentMenu a.level3 { margin-left:45px; display:block; }.indentMenu a.level4 { margin-left:60px; display:block; }',0),('i5kt5aodVs_oepNEkE7Okw','/*/styles for the poll asset/*/\r\n.pollColor {\r\nbackground-color:#808080;\r\n}\r\n.pollOptions, .pollSubmit {\r\nborder:0;\r\nmargin:0;\r\npadding:0;\r\n}',0,'text/css',1242312883,3600,'/*/styles for the poll asset/*/ .pollColor { background-color:#808080; }.pollOptions, .pollSubmit { border:0; margin:0; padding:0; }',0),('PcRRPhh-0KfvLLNIPdxJTw','.wg-icon {\r\n    border: 0px none;\r\n    vertical-align: middle;\r\n}\r\n.wg-clear {\r\n    clear: both;\r\n}\r\nul.wg-inline {\r\n    margin:0;\r\n    padding:0;\r\n}\r\nul.wg-inline li {\r\n    display: inline;\r\n    margin:0;\r\n    padding:0;\r\n}\r\nul.wg-inline li.active {\r\n    font-weight:bold;\r\n}\r\n',0,'text/css',1247055282,3600,'.wg-icon { border: 0px none; vertical-align: middle; }.wg-clear { clear: both; }ul.wg-inline { margin:0; padding:0; }ul.wg-inline li { display: inline; margin:0; padding:0; }ul.wg-inline li.active { font-weight:bold; }',0),('_9_eiaPgxzF_x_upt6-PNQ','/* FIXES FLOAT ISSUES. WITHOUT THIS, FLOATS GET ALL NUTSY ESPECIALLY IN OPERA AND SAFARI */\r\n.clearfix:after {\r\n    content: \".\";\r\n    display: block;\r\n    height: 0;\r\n    clear: both;\r\n    visibility: hidden;\r\n}\r\n.clearfix {display: inline-block;}\r\n/* END FLOAT FIX */\r\n\r\n\r\n\r\n.wgGallery {\r\n	font-family:verdana, arial;\r\n	text-align:left;\r\n}\r\n\r\n\r\n\r\n\r\n.firstBar {\r\n	background: black;\r\n	color:white;\r\n	font-size:18px;\r\n	font-weight:bold;\r\n}\r\n\r\n.firstBar .title {				\r\n	margin-left:20px;	\r\n	line-height:42px;	\r\n}\r\n.firstBar .title a {\r\n	font-size:18px;\r\n	font-weight:bold;\r\n	color:white;\r\n}\r\n.firstBar .buttons {\r\n	float:right;\r\n}\r\n.firstBar .buttons a {\r\n	display:block;\r\n	float:left;\r\n	height:42px;\r\n	line-height:42px;	\r\n	font-size:10px;\r\n	color:white;\r\n	font-weight:bold;\r\n	text-align:center;\r\n	padding:0px 5px;		\r\n}\r\n.firstBar .buttons .rss {\r\n	display:block;\r\n	height:29px;\r\n	position:relative;\r\n	background:transparent;\r\n	padding-top:13px;\r\n}\r\n\r\n\r\n\r\n\r\n.secondBar {\r\n	background: #F1F1F1;\r\n	text-align:left;\r\n	border-top:solid #8B8B8B 5px;	\r\n	color: black;\r\n	overflow: hidden;\r\n}\r\n.secondBar .author {\r\n	font-size:10px;\r\n}\r\n\r\n\r\n.secondBar .desc p {\r\n	margin-left: 20px;\r\n	margin-top: 0;\r\n	color: black;\r\n}\r\n\r\n.pictures {\r\n	\r\n}\r\n\r\n\r\n.searchArea {\r\n	float:right;\r\n}\r\n.searchArea * {\r\n	float:left;\r\n}	\r\n.searchArea input.searchText {\r\n	border:solid black 1px;	\r\n	width:100px;	\r\n	margin:0px;\r\n	padding:2px;\r\n	margin-top:5px;\r\n	font-size:10px;\r\n	height:15px;\r\n	margin-right:10px;\r\n}	\r\n.searchArea input.searchBtn {\r\n	border:solid black 1px;		\r\n	margin:0px;\r\n	padding:3px;\r\n	margin-top:5px;\r\n	font-size:10px;	\r\n	vertical-align:middle;\r\n	cursor:pointer;\r\n	height:21px;\r\n}	\r\n.searchArea a:link,\r\n.searchArea a:visited,\r\n.secondBar .author a:link,\r\n.secondBar .author a:visited {\r\n	font-size:11px;\r\n	color:black;\r\n}\r\n.searchArea .current {\r\n	font-weight:bold;\r\n	text-transform:uppercase;\r\n	text-decoration:none;\r\n	font-size:10px;\r\n}		\r\n\r\n\r\n\r\n\r\n.wgAlbum {\r\n	/* display: -moz-inline-box;  Although this works in later versions of FireFox, it does not work in 2.x */\r\n	display:block;\r\n	float:left;\r\n	display: inline-block; /* Op, Saf, IE \\*/\r\n	vertical-align: top; /* IE Mac non capisce e a volte crea extra v space */\r\n	width:250px;\r\n	margin:10px;\r\n}\r\n.wgAlbum .albumTitle {		\r\n	background: black;\r\n	color:white;\r\n	font-size:12px;\r\n	font-weight:bold;\r\n	padding:10px;\r\n	padding-right:50px;\r\n	border:solid #475f6f 1px;\r\n	border-bottom:solid #8B8B8B 5px;\r\n	text-align:left;\r\n	display:block;\r\n}\r\n.wgAlbum .albumImage {\r\n	background: #F1F1F1;\r\n	border-left: solid black 1px;\r\n	border-right: solid black 1px;\r\n	padding-top:15px;\r\n	height:135px;\r\n}		\r\n.wgAlbum .albumImage a {\r\n	height:135px;\r\n	width:200px;\r\n	overflow:hidden;	\r\n	display:block;\r\n	margin:0px 23px;\r\n}\r\n.wgAlbum .albumImage img {		\r\n	border-style:none;\r\n	display:block;\r\n	width:200px;\r\n	height:auto;	\r\n	border:solid black 1px;	\r\n}\r\n.wgAlbum .albumDesc {\r\n	background: #F1F1F1;\r\n	border-left: solid black 1px;\r\n	border-right: solid black 1px;\r\n	border-bottom: solid black 1px;\r\n	text-align:center;\r\n	padding: 5px 23px;\r\n}\r\n.wgAlbum .description {\r\n	font-size:10px;			\r\n	height:40px;\r\n	overflow:auto;\r\n	text-align:left;\r\n	border:solid silver 1px;\r\n	padding:5px;\r\n	background-color: #fff;\r\n	color:#222;\r\n}\r\n.albumDesc .description * {\r\n	margin:2px 0px;\r\n}\r\n\r\n\r\n\r\n\r\n/* PAGINATION STYLES */\r\n.wgGallery .paginationContainer {\r\n	text-align:center;	\r\n	background: black;\r\n	height:42px;\r\n}\r\n.wgGallery .container {\r\n	clear:both; \r\n	text-align:center;\r\n}\r\n.wgGallery .pagination {						\r\n	margin:0px auto 20px auto;\r\n	display:table;\r\n	list-style-type:none;\r\n	white-space:nowrap;\r\n	padding:0px;\r\n	height:42px;\r\n}\r\n.wgGallery .pagination li {\r\n	display:table-cell;\r\n}\r\n.wgGallery .pagination a {\r\n	display:block;\r\n	width:50px;	\r\n	line-height:42px;\r\n	color:white;	\r\n	font-size:10px;		\r\n	text-align:center;\r\n}\r\n\r\n\r\n\r\n.wgPicture a:link,\r\n.wgPicture a:visited {\r\n	color:black;\r\n}\r\n.wgPicture {\r\n	width:250px;\r\n	margin:10px;\r\n	/*display: -moz-inline-box;  This does not work in earlier versions of Firefox */\r\n	display:block;\r\n	float:left;\r\n	display: inline-block; /* Op, Saf, IE \\*/\r\n	vertical-align: top; /* IE Mac non capisce e a volte crea extra v space */\r\n}\r\n.wgPicture .title {\r\n	background:#e0e0e0;\r\n	display:block;\r\n	font-size:12px;\r\n	text-align:center;\r\n	padding:2px 5px;\r\n	border:solid black 1px;\r\n	border-bottom:solid #8B8B8B 4px;\r\n}\r\n.wgPicture .thumbnail {\r\n	text-align:center;\r\n	background: #F1F1F1;\r\n	padding:15px 23px 15px 23px;\r\n	margin:0px;\r\n	border-left:solid black 1px;\r\n\r\n\r\n\r\n\r\n\r\n	border-right:solid black 1px;\r\n}\r\n.wgPicture .thumbnail a {\r\n	display:block;\r\n	width:200px;\r\n	height:120px;\r\n	overflow:hidden;\r\n	border:solid black 1px;\r\n}\r\n.wgPicture .thumbnail img {\r\n	border-style:none;\r\n	width:200px;\r\n	height:auto;\r\n}\r\n.wgPicture .pictureDesc {\r\n	padding:0px;\r\n	border-top:solid #e1e1e1 1px;\r\n	border-bottom:solid gray 1px;\r\n	border-left:solid black 1px;\r\n	border-right:solid black 1px;\r\n	background:#F1F1F1;\r\n	margin:0px;\r\n}\r\n.wgPicture .pictureDesc .description {\r\n	margin:0px;\r\n	padding:5px;\r\n	font-size:10px;\r\n}\r\n.wgPicture .details {\r\n	background:#e0e0e0;\r\n	border:solid #999 1px;\r\n	border-top:solid #aaa 1px;\r\n	font-size:9px;\r\n	padding:1px 3px;	\r\n}\r\n.wgPicture .details .date {\r\n	float:right;\r\n}\r\n.wgPicture .details .comments {\r\n	float:left;\r\n}\r\n.wgPicture .details a {	\r\n	font-size:9px;	\r\n}\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR PHOTO VIEW --\r\n *	The Photo view uses some/all of the above classes, plus those in this section.\r\n*/\r\n.wgSnapshot {\r\n	float:left;\r\n	margin:10px;\r\n	max-width:250px;	\r\n	width:25%;\r\n}\r\n.wgSnapshot fieldset {	\r\n	background-color:#fefefe;\r\n	border:solid #555 2px;\r\n	padding:10px;\r\n	background-color:#f9f9f9;\r\n	text-align:center;\r\n}\r\n.wgSnapshot p {\r\n	max-width:230px;\r\n}\r\n.wgSnapshot legend {\r\n	color:#333;\r\n	font-size:15px;\r\n	font-weight:bold;\r\n       max-width:250px;\r\n}\r\n.wgSnapshot a.thumbnail img {\r\n	width:200px;\r\n	height:auto;\r\n	border:solid #555 2px;\r\n}\r\n.wgSnapshot .description {\r\n	font-size:9px;\r\n	border:solid #555555 2px;\r\n	padding:5px;\r\n	width:190px;\r\n	margin:0px auto;\r\n	background-color:#fff;\r\n	height:50px;\r\n	overflow:auto;\r\n	text-align:left;\r\n	overflow:auto;\r\n}\r\n.wgSnapshot a.fullSize {\r\n	margin:0px auto;\r\n}\r\n\r\n\r\n\r\n.wgPictureDetails {\r\n	float:left;\r\n	width:70%;	\r\n	margin:10px;\r\n} \r\n.wgPictureDetails a:link,\r\n.wgPictureDetails a:visited {\r\n	color:black;\r\n}\r\n.wgPictureDetails fieldset {	\r\n	background-color:#fefefe;\r\n	border:solid #555 2px;\r\n	padding:10px;\r\n	background-color:#f9f9f9;	\r\n	margin-bottom:10px;\r\n}\r\n.wgPictureDetails legend {\r\n	color:#333;\r\n	font-size:15px;\r\n	font-weight:bold;\r\n}\r\n\r\n\r\n\r\n.rowOne {\r\n	background: #EFEFEF;\r\n	margin:1px;\r\n	border:solid #CDCDCD 1px;\r\n	color:black;\r\n	padding:3px;\r\n}\r\n.rowTwo {\r\n	background: #DCDCDC;\r\n	margin:1px;\r\n	border:solid #DDDDDD 1px;\r\n	color:black;	\r\n	padding:3px;\r\n}\r\n.rowOne .label, .rowTwo .label {\r\n	margin-left:15px;\r\n	display:inline;\r\n	text-align:left;\r\n	font-weight:bold;\r\n	font-size:11px;\r\n}\r\n.rowOne .data, .rowTwo .data {		\r\n	font-size:10px;\r\n	margin-left:5px;\r\n	display:inline;\r\n}\r\na.fullSize:link,\r\na.fullSize:visited {	\r\n	color:black;\r\n	display:block;\r\n	text-align:center;\r\n	font-weight:bold;\r\n	font-size:10px;	\r\n}\r\n\r\n\r\n\r\n\r\n.wgComments {	\r\n	font-size:9px;	\r\n	margin:10px;\r\n	width:90%;\r\n}\r\n.wgComments .title {\r\n	font-size:14px;\r\n	font-weight:bold;\r\n	color:#333;\r\n	border-bottom:solid #555555 2px;\r\n	padding-bottom:2px;\r\n}	\r\n.wgComments .title a {\r\n	color:navy;\r\n	text-decoration:none;\r\n}\r\n.wgComments .comment, .wgComments .commentAlt {\r\n	position:relative;	\r\n	padding:5px;	\r\n}\r\n.wgComments .comment {\r\n	background-color:#e1e1e1;\r\n	border-top:solid #F7F7F7 1px;\r\n	border-bottom:solid #C9C9C9 1px;\r\n}\r\n.wgComments .commentAlt {\r\n	background-color:#f0f0f0;	\r\n	border-bottom:solid #CDCDCD 1px;\r\n	border-top:solid #FBFBFB 1px;\r\n}\r\n.wgComments .number {\r\n	float:left;\r\n	font-size:30px;\r\n	color:silver;\r\n	margin:5px 10px 5px 5px;\r\n}\r\n.wgComments  .posted {	\r\n	font-style:italic;\r\n	padding-top:3px;\r\n	font-size:9px;\r\n	color:gray;\r\n}\r\n.wgComments .posted a {\r\n	color:navy;\r\n	text-decoration:underline;\r\n}\r\n\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR THUMBNAIL VIEW --\r\n *	The Thumbnail view uses some/all of the above classes, plus those in this section.\r\n*/\r\n\r\n.thumbView {\r\n	width:400px;\r\n	height:auto;\r\n}\r\n.thumbView .thumbnail a {\r\n	display:block;\r\n	width:350px;\r\n	height:auto;	\r\n	border:solid black 1px;\r\n}\r\n.thumbView .thumbnail img {\r\n	border-style:none;\r\n	width:350px;\r\n	height:auto;\r\n}\r\n.thumb {\r\n	width:100px;\r\n	height:65px;\r\n	overflow:hidden;\r\n	display:block;\r\n	float:left;\r\n	border:solid black 2px;\r\n	margin:10px;\r\n        z-index: 0;\r\n        position: relative;\r\n}\r\n.thumb:hover {\r\n    background-color: transparent;\r\n    z-index: 50;\r\n    overflow: visible;\r\n}\r\n.thumb img {\r\n	width:100px;\r\n	height:auto;\r\n	border-style:none;\r\n}\r\n.thumb:hover img {\r\n    bottom: 65px;\r\n    left: -75px;\r\n    position: absolute;\r\n    width: 250px;\r\n}\r\n\r\n/* \r\n*	--BEGIN STYLES FOR SLIDESHOW VIEW --\r\n *	The Slideshow view uses some/all of the above classes, plus those in this section.\r\n*/\r\n.wgSlideshow .controls {\r\n	background: url(^FileUrl(root/import/gallery-templates/images/pagination_bg.jpg);) repeat-x;\r\n	width:500px;\r\n	height:42px;\r\n	margin:0px auto;\r\n	border:solid black 2px;\r\n}\r\n.wgSlideshow {	\r\n	text-align:center;\r\n}\r\n#slideshow-container {\r\n	width:500px;\r\n	height:auto;\r\n	margin:0px auto;\r\n	text-align:center;\r\n	border:solid black 2px;\r\n	position:relative;\r\n	z-index:0;\r\n}\r\n#slideshow-container .slideshow-item img {\r\n	width:100%;\r\n	height:auto;\r\n	border-style:none;\r\n	display:block;\r\n}\r\n#slideshow-container .slideshow-item .title {\r\n	background-color:black;\r\n	padding:3px;\r\n	color:white;\r\n	border-top:solid white 1px;\r\n	border-bottom:solid white 1px;\r\n}\r\n#slideshow-container .slideshow-item .title a {\r\n	color:white;\r\n	font-size:11px;\r\n	font-weight:bold;	\r\n}\r\n#slideshow-container .slideshow-item .counter {\r\n	background-color:black;\r\n	padding:3px;\r\n	color:white;\r\n	font-size:11px;\r\n	font-weight:bold;\r\n}\r\n#slideshow-container .slideshow-item .synopsis {\r\n	width:494px;\r\n	background-color:white;\r\n	padding:3px;\r\n	color:black;\r\n	font-size:11px;\r\n	font-weight:bold;\r\n	border-top:solid black 1px;\r\n	text-align:left;\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR SEARCH VIEW --\r\n *	The Search view uses some/all of the above classes, plus those in this section.\r\n*/\r\n#adminWrapper {\r\n	margin-top:20px;\r\n}\r\n#adminWrapper .label {\r\n	background:black;\r\n	font-weight:bold;	\r\n	font-size:10px;\r\n	color:white;\r\n}\r\n#adminWrapper td.data input {\r\n	background: #f1f1f1;\r\n	vertical-align:middle;\r\n}\r\n#adminWrapper td.radio input {\r\n	border-style:none;\r\n	background:none;\r\n}\r\n#adminWrapper .forwardButton {\r\n	cursor:pointer;\r\n	float:rigbt;\r\n}\r\n#adminWrapper .forwardButton:hover {\r\n	color:gold;\r\n}',0,'text/css',1250022514,3600,'.clearfix:after{content:\".\";display:block;height:0;clear:both;visibility:hidden;}.clearfix{display:inline-block;}.wgGallery{font-family:verdana,arial;text-align:left;}.firstBar{background:black;color:white;font-size:18px;font-weight:bold;}.firstBar .title{margin-left:20px;line-height:42px;}.firstBar .title a{font-size:18px;font-weight:bold;color:white;}.firstBar .buttons{float:right;}.firstBar .buttons a{display:block;float:left;height:42px;line-height:42px;font-size:10px;color:white;font-weight:bold;text-align:center;padding:0px 5px;}.firstBar .buttons .rss{display:block;height:29px;position:relative;background:transparent;padding-top:13px;}.secondBar{background:#F1F1F1;text-align:left;border-top:solid #8B8B8B 5px;color:black;overflow:hidden;}.secondBar .author{font-size:10px;}.secondBar .desc p{margin-left:20px;margin-top:0;color:black;}.pictures{}.searchArea{float:right;}.searchArea *{float:left;}.searchArea input.searchText{border:solid black 1px;width:100px;margin:0px;padding:2px;margin-top:5px;font-size:10px;height:15px;margin-right:10px;}.searchArea input.searchBtn{border:solid black 1px;margin:0px;padding:3px;margin-top:5px;font-size:10px;vertical-align:center;cursor:pointer;height:21px;}.searchArea a:link,.searchArea a:visited,.secondBar .author a:link,.secondBar .author a:visited{font-size:11px;color:black;}.searchArea .current{font-weight:bold;text-transform:uppercase;text-decoration:none;font-size:10px;}.wgAlbum{display:-moz-inline-box;display:inline-block;/*\\*/\n	vertical-align:top;/**/\n	width:250px;margin:10px;}.wgAlbum .albumTitle{background:black;color:white;font-size:12px;font-weight:bold;padding:10px;padding-right:50px;border:solid #475f6f 1px;border-bottom:solid #8B8B8B 5px;text-align:left;display:block;}.wgAlbum .albumImage{background:#F1F1F1;border-left:solid black 1px;border-right:solid black 1px;padding-top:15px;height:135px;}.wgAlbum .albumImage a{height:135px;width:200px;overflow:hidden;display:block;margin:0px 23px;}.wgAlbum .albumImage img{border-style:none;display:block;width:200px;height:auto;border:solid black 1px;}.wgAlbum .albumDesc{background:#F1F1F1;border-left:solid black 1px;border-right:solid black 1px;border-bottom:solid black 1px;text-align:center;padding:5px 23px;}.wgAlbum .description{font-size:10px;height:40px;overflow:auto;text-align:left;border:solid silver 1px;padding:5px;background-color:#fff;color:#222;}.albumDesc .description *{margin:2px 0px;}.wgGallery .paginationContainer{text-align:center;background:black;height:42px;}.wgGallery .container{clear:both;text-align:center;}.wgGallery .pagination{margin:0px auto 20px auto;display:table;list-style-type:none;white-space:nowrap;padding:0px;height:42px;}.wgGallery .pagination li{display:table-cell;}.wgGallery .pagination a{display:block;width:50px;line-height:42px;color:white;font-size:10px;text-align:center;}.wgPicture a:link,.wgPicture a:visited{color:black;}.wgPicture{width:250px;margin:10px;display:-moz-inline-box;display:inline-block;/*\\*/\n	vertical-align:top; /**/}.wgPicture .title{background:#e0e0e0;display:block;font-size:12px;text-align:center;padding:2px 5px;border:solid black 1px;border-bottom:solid #8B8B8B 4px;}.wgPicture .thumbnail{text-align:center;background:#F1F1F1;padding:15px 23px 15px 23px;margin:0px;border-left:solid black 1px;border-right:solid black 1px;}.wgPicture .thumbnail a{display:block;width:200px;height:120px;overflow:hidden;border:solid black 1px;}.wgPicture .thumbnail img{border-style:none;width:200px;height:auto;}.wgPicture .pictureDesc{padding:0px;border-top:solid #e1e1e1 1px;border-bottom:solid gray 1px;border-left:solid black 1px;border-right:solid black 1px;background:#F1F1F1;margin:0px;}.wgPicture .pictureDesc .description{margin:0px;padding:5px;font-size:10px;}.wgPicture .details{background:#e0e0e0;border:solid #999 1px;border-top:solid #aaa 1px;font-size:9px;padding:1px 3px;}.wgPicture .details .date{float:right;}.wgPicture .details .comments{float:left;}.wgPicture .details a{font-size:9px;}.wgSnapshot{float:left;margin:10px;max-width:250px;width:25%;}.wgSnapshot fieldset{background-color:#fefefe;border:solid #555 2px;padding:10px;background-color:#f9f9f9;text-align:center;}.wgSnapshot p{max-width:230px;}.wgSnapshot legend{color:#333;font-size:15px;font-weight:bold;max-width:250px;}.wgSnapshot a.thumbnail img{width:200px;height:auto;border:solid #555 2px;}.wgSnapshot .description{font-size:9px;border:solid #555555 2px;padding:5px;width:190px;margin:0px auto;background-color:#fff;height:50px;overflow:auto;text-align:left;overflow:auto;}.wgSnapshot a.fullSize{margin:0px auto;}.wgPictureDetails{float:left;width:70%;margin:10px;}.wgPictureDetails a:link,.wgPictureDetails a:visited{color:black;}.wgPictureDetails fieldset{background-color:#fefefe;border:solid #555 2px;padding:10px;background-color:#f9f9f9;margin-bottom:10px;}.wgPictureDetails legend{color:#333;font-size:15px;font-weight:bold;}.rowOne{background:#EFEFEF;margin:1px;border:solid #CDCDCD 1px;color:black;padding:3px;}.rowTwo{background:#DCDCDC;margin:1px;border:solid #DDDDDD 1px;color:black;padding:3px;}.rowOne .label,.rowTwo .label{margin-left:15px;display:inline;text-align:left;font-weight:bold;font-size:11px;}.rowOne .data,.rowTwo .data{font-size:10px;margin-left:5px;display:inline;}a.fullSize:link,a.fullSize:visited{color:black;display:block;text-align:center;font-weight:bold;font-size:10px;}.wgComments{font-size:9px;margin:10px;width:90%;}.wgComments .title{font-size:14px;font-weight:bold;color:#333;border-bottom:solid #555555 2px;padding-bottom:2px;}.wgComments .title a{color:navy;text-decoration:none;}.wgComments .comment,.wgComments .commentAlt{position:relative;padding:5px;}.wgComments .comment{background-color:#e1e1e1;border-top:solid #F7F7F7 1px;border-bottom:solid #C9C9C9 1px;}.wgComments .commentAlt{background-color:#f0f0f0;border-bottom:solid #CDCDCD 1px;border-top:solid #FBFBFB 1px;}.wgComments .number{float:left;font-size:30px;color:silver;margin:5px 10px 5px 5px;}.wgComments .posted{font-style:italic;padding-top:3px;font-size:9px;color:gray;}.wgComments .posted a{color:navy;text-decoration:underline;}.thumbView{width:400px;height:auto;}.thumbView .thumbnail a{display:block;width:350px;height:auto;border:solid black 1px;}.thumbView .thumbnail img{border-style:none;width:350px;height:auto;}.thumb{width:100px;height:65px;overflow:hidden;display:block;float:left;border:solid black 2px;margin:10px;}.thumb img{width:100px;height:auto;border-style:none;}.thumb-popup{border:solid #555 1px;padding:2px;padding-bottom:4px;padding-right:4px;background-color:silver;}.thumb-popup img{border:solid #555 1px;}.thumb-popup .caption{background-color:black;color:white;padding:4px;border:solid #555 2px;}.wgSlideshow .controls{background:url(^FileUrl(root/import/gallery-templates/images/pagination_bg.jpg);) repeat-x;width:500px;height:42px;margin:0px auto;border:solid black 2px;}.wgSlideshow{text-align:center;}#slideshow-container{width:500px;height:auto;margin:0px auto;text-align:center;border:solid black 2px;position:relative;z-index:0;}#slideshow-container .slideshow-item img{width:100%;height:auto;border-style:none;display:block;}#slideshow-container .slideshow-item .title{background-color:black;padding:3px;color:white;border-top:solid white 1px;border-bottom:solid white 1px;}#slideshow-container .slideshow-item .title a{color:white;font-size:11px;font-weight:bold;}#slideshow-container .slideshow-item .counter{background-color:black;padding:3px;color:white;font-size:11px;font-weight:bold;}#slideshow-container .slideshow-item .synopsis{width:494px;background-color:white;padding:3px;color:black;font-size:11px;font-weight:bold;border-top:solid black 1px;text-align:left;}#adminWrapper{margin-top:20px;}#adminWrapper .label{background:black;font-weight:bold;font-size:10px;color:white;}#adminWrapper td.data input{background:#f1f1f1;vertical-align:middle;}#adminWrapper td.radio input{border-style:none;background:none;}#adminWrapper .forwardButton{cursor:pointer;float:rigbt;}#adminWrapper .forwardButton:hover{color:gold;}',0),('qsG6B24a0SC5KrhQjmdZBw','body {\n    margin: 0;\n    background-repeat: repeat-y;\n    background-position: 0px 0px;\n}\n.survey-header {\n    width: 80%;\n    height: 20px;\n    margin-left: 80px;\n}\n#survey {\n    margin-left: 80px;\n    width: 85%;\n}\n\ndiv.dateanswer {\n    overflow: auto;\n}\ndiv.slider-bg {\n    position: relative;\n    background:url(/extras/wobject/Survey/bg-fader-500.gif) 5px 0 no-repeat;\n    height:68px;\n    width:529px; \n}\ndiv.slider-thumb {\n    cursor:default;\n    position: absolute;\n    top: 30px;\n    left: 4px;\n}\ndiv.slider-min-thumb {\n    cursor:default;\n    position: absolute;\n    top: 4px;\n}\ndiv.slider-max-thumb {\n    cursor:default;\n    position: absolute;\n    top: 4px;\n}\n#headertitle {\n    display: none;\n}\n#headertext {\n    display: none;\n}\n#questions {\n    display: none;\n}\ninput.mcbutton{\n    font-size: 10px;\n    font-weight: bold;\n    text-decoration: none;\n    background-color: #CCCCCC;\n    background-repeat: repeat-x;\n    text-align: center;\n    display: block;\n    margin: 0.5em;\n    padding: .8em;\n    min-width: 60px;\n    font-family: Verdana, Arial, Helvetica, sans-serif;\n    color: #000000;\n    background-image: url(/extras/wobject/Survey/gradient-glossy.png);\n}\ninput.mcbutton:hover{\n    background-color: #B6D2F1;\n    font-family: Verdana, Arial, Helvetica, sans-serif;\n    font-size: 10px;\n    color: #000000;\n}\ninput.mcbutton-selected{\n    background-color: #172D9D;\n    background-repeat: repeat-x;\n    color: #FFFFFF;\n    font-family: Verdana, Arial, Helvetica, sans-serif;\n    font-size: 10px;\n    margin: 0.5em;\n    padding: .8em;\n    width: 60px;\n    text-align: center;\n    display: block;\n    font-weight: bold;\n    background-image: url(/extras/wobject/Survey/gradient-glossy.png);\n    background-position: 0px 0px;\n}\n\n/* By default the marker for invalid (required) fields is a red \'*\' */  \n.survey-invalid-marker {\n	color: #FF0000;\n}\n\n\n#survey {\n	font-family: Verdana, Arial, Helvetica, sans-serif;\n	font-size: 10px;\n	border: 3px solid #1e1e1e;\n}\n\n#survey #survey-header {\n	background-color: #cfcfcf;\n	padding-top: 1px;\n}\n\n#survey #headertitle {\n	padding-left: 5px;\n}\n\n#survey #progress {\n	position: relative;\n	top: -26px;\n	right: 5px;\n	text-align: right;\n	font-style: italic;\n}\n\n#survey #progress:before {\n	content: \"Progress: \";\n}\n\n#survey #headertext {\n	border-bottom: 2px solid #1e1e1e;\n        padding: 5px;\n        position: relative;\n        top: -20px;\n}\n\n#survey #questions {\n        position: relative;\n        top: -20px;\n}\n\n#survey .question {\n	background-color: #dfdfdf;\n        padding: 10px 5px 10px 5px;\n}\n\n#survey .question p:before {\n	content: \"Q: \";\n}\n\n#survey .scale:before {\n	content: \"A: \";\n}\n\n#survey #submitbutton {\n        margin-left: 5px;\n}\n\n#restartMessage {\n    color: #FF0000;\n}\n\n#chart {\n    float: left;\n    width: 200px;\n    height: 113px;\n}',0,'text/css',1250243000,3600,'body{margin:0;background-repeat:repeat-y;background-position:0px 0px;}.survey-header{width:80%;height:20px;margin-left:80px;}#survey{margin-left:80px;width:85%;}div.dateanswer{min-height:250px;}div.slider-bg{position:relative;background:url(/extras/wobject/Survey/bg-fader-500.gif) 5px 0 no-repeat;height:68px;width:529px;}div.slider-thumb{cursor:default;position:absolute;top:30px;left:4px;}div.slider-min-thumb{cursor:default;position:absolute;top:4px;}div.slider-max-thumb{cursor:default;position:absolute;top:4px;}#headertitle{display:none;}#headertext{display:none;}#questions{display:none;}input.mcbutton{font-size:10px;font-weight:bold;text-decoration:none;background-color:#CCCCCC;background-repeat:repeat-x;text-align:center;display:block;margin:0.5em;padding:.8em;min-width:60px;font-family:Verdana,Arial,Helvetica,sans-serif;color:#000000;background-image:url(/extras/wobject/Survey/gradient-glossy.png);}input.mcbutton:hover{background-color:#B6D2F1;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;color:#000000;}input.mcbutton-selected{background-color:#172D9D;background-repeat:repeat-x;color:#FFFFFF;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;margin:0.5em;padding:.8em;width:60px;text-align:center;display:block;font-weight:bold;background-image:url(/extras/wobject/Survey/gradient-glossy.png);background-position:0px 0px;}.survey-invalid-marker{color:#FF0000;}#survey{font-family:Verdana,Arial,Helvetica,sans-serif;font-size:10px;border:3px solid #1e1e1e;}#survey #survey-header{background-color:#cfcfcf;padding-top:1px;}#survey #headertitle{padding-left:5px;}#survey #progress{position:relative;top:-26px;right:5px;text-align:right;font-style:italic;}#survey #progress:before{content:\"Progress: \";}#survey #headertext{border-bottom:2px solid #1e1e1e;padding:5px;position:relative;top:-20px;}#survey #questions{position:relative;top:-20px;}#survey .question{background-color:#dfdfdf;padding:10px 5px 10px 5px;}#survey .question p:before{content:\"Q: \";}#survey .scale:before{content:\"A: \";}#survey #submitbutton{margin-left:5px;}#restartMessage{color:#FF0000;}#chart{float:left;width:200px;height:113px;}',0),('kwTL1SWCk0GlpiJ5zAAEPQ','#editor_container {\r\n    visibility: hidden;\r\n    z-index:  100;\r\n}\r\n\r\n#loading-mask {\r\n  position: absolute;\r\n  left:     0;\r\n  top:      0;\r\n  width:    100%;\r\n  height:   100%;\r\n  z-index:  20000;\r\n  background-color: white;\r\n  opacity:0.6;\r\n  filter:alpha(opacity=60);\r\n}\r\n\r\n#loading {\r\n  position: absolute;\r\n  left:     50%;\r\n  top:      50%;\r\n  padding:  2px;\r\n  z-index:  20001;\r\n  height:   auto;\r\n  margin:   -35px 0 0 -30px;\r\n}\r\n\r\n#loading .loading-indicator {\r\n  background: url(^Extras(\"wobject/Survey/rel_interstitial_loading.gif\");) no-repeat;\r\n  color:      #555;\r\n  font:       bold 13px tahoma,arial,helvetica;\r\n  padding:    18px 80px;\r\n  margin:     0;\r\n  text-align: center;\r\n  height:     auto;\r\n  z-index:  20002;\r\n}\r\n\r\n\r\ndiv.testarea {\r\n    width: 200px;\r\n    height: 100px;\r\n    z-index: 999;\r\n    border: 1px solid gray;\r\n    background: #f7f7f7;\r\n    position: absolute;\r\n    top: 5%;\r\n    left:5%;\r\n}\r\n\r\ndiv.trashcan { \r\n    border: 1px solid gray;\r\n    width: 175px; \r\n    height: 50px; \r\n}\r\n\r\ndiv.editarea { \r\n	margin-top:40px;\r\n    padding:10px; \r\n    float:left;\r\n    border: 1px solid gray;\r\n}\r\n\r\ndiv.editquestion { \r\n	padding:10px; \r\n	float:left; \r\n}\r\ndiv.editanswer { \r\n	padding:10px; \r\n	float:left; \r\n}\r\n\r\n#submitbutton { padding:20px; }\r\n\r\ndiv.entry { \r\n    padding-bottom:10px;\r\n    padding-left:10px;\r\n}\r\n\r\nul.draglist { \r\n    list-style: none;\r\n    margin:0;\r\n    padding:0;\r\n}\r\n\r\nul.draglist li {\r\n    margin: 1px;\r\n}\r\n\r\nul.questionList {\r\n    position: relative;\r\n    background: #f7f7f7;\r\n    border: 1px solid gray;\r\n    list-style: none;\r\n    margin:0;\r\n    padding:0;\r\n    min-height: 40px\r\n}\r\n\r\nli.section {\r\n    background-color: #CCCCFF;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n    min-height: 10px;\r\n}\r\nli.question {\r\n    background-color: #D1E6EC;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n	padding-left:10px; \r\n    min-height: 10px;\r\n}\r\nli.answer {\r\n    background-color: #F1FFB8;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n	padding-left:15px; \r\n    min-height: 10px;\r\n}\r\n#sections-panel li.selected {\r\n    background-image: url(^Extras(\"toolbar/bullet/moveRight.gif\"););\r\n    background-position:99% center;\r\n    background-repeat: no-repeat;\r\n    font-weight:bold;\r\n}\r\n\r\n#goto-yui-ac {\r\n    width:15em;\r\n    margin-top:0.5em;\r\n}\r\n.wGwarning {\r\n    background-color:#FF6666;\r\n    border:1px solid red;\r\n    margin:5px;\r\n    padding:10px;\r\n}\r\n.warning {\r\n    padding: 5px;\r\n}\r\n#sections-panel .bd {\r\n    overflow: auto;\r\n    background-color:#fff;\r\n    padding:10px;\r\n}\r\n#buttons {\r\n    height: 30px; \r\n}\r\n#sections-panel_c .yui-resize .yui-resize-handle-r {\r\n    right: -6px; /* make room for the scroll-bars */\r\n}\r\n#sections-panel div.ft {\r\n    font-size: 100%;\r\n}\r\n',0,'text/css',1250243000,3600,'#editor_container { visibility: hidden; z-index: 100; }#loading-mask { position: absolute; left: 0; top: 0; width: 100%; height: 100%; z-index: 20000; background-color: white; opacity:0.6; filter:alpha(opacity=60); }#loading { position: absolute; left: 50%; top: 50%; padding: 2px; z-index: 20001; height: auto; margin: -35px 0 0 -30px; }#loading .loading-indicator { background: url(^Extras(\"wobject/Survey/rel_interstitial_loading.gif\");) no-repeat; color: #555; font: bold 13px tahoma,arial,helvetica; padding: 18px 80px; margin: 0; text-align: center; height: auto; z-index: 20002; }div.testarea { width: 200px; height: 100px; z-index: 999; border: 1px solid gray; background: #f7f7f7; position: absolute; top: 5%; left:5%; }div.trashcan { border: 1px solid gray; width: 175px; height: 50px; }div.editarea { margin-top:40px; padding:10px; float:left; border: 1px solid gray; }div.editquestion { padding:10px; float:left; }div.editanswer { padding:10px; float:left; }#submitbutton { padding:20px; } div.entry { padding-bottom:10px; padding-left:10px; }ul.draglist { list-style: none; margin:0; padding:0; }ul.draglist li { margin: 1px; }ul.questionList { position: relative; background: #f7f7f7; border: 1px solid gray; list-style: none; margin:0; padding:0; min-height: 40px }li.section { background-color: #CCCCFF; border:1px solid #7EA6B2; cursor: move; min-height: 10px; }li.question { background-color: #D1E6EC; border:1px solid #7EA6B2; cursor: move; padding-left:10px; min-height: 10px; }li.answer { background-color: #F1FFB8; border:1px solid #7EA6B2; cursor: move; padding-left:15px; min-height: 10px; }#sections-panel li.selected { background-image: url(^Extras(\"toolbar/bullet/moveRight.gif\");); background-position:99% center; background-repeat: no-repeat; font-weight:bold; }#goto-yui-ac { width:15em; margin-top:0.5em; }.wGwarning { background-color:#FF6666; border:1px solid red; margin:5px; padding:10px; }.warning { padding: 5px; }#sections-panel .bd { overflow: auto; background-color:#fff; padding:10px; }#buttons { height: 30px; }#sections-panel_c .yui-resize .yui-resize-handle-r { right: -6px; /* make room for the scroll-bars */ }#sections-panel div.ft { font-size: 100%; }',0),('hkj6WeChxFyqfP85UlRP8w','.wg-clear {\r\n	display: inline;\r\n	clear: both;\r\n	font-size:0px;\r\n	line-height:0px;\r\n}\r\n\r\n/* COLUMN STYLES */\r\n#matrixLeft {\r\n	float:left;\r\n	width:65%;\r\n	padding:1%;\r\n	min-height:1%;\r\n	background-color:#d2d2d2;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;	\r\n}\r\n#matrixRight {\r\n	float:left;\r\n	width:25%;\r\n	padding:0px;\r\n	min-height:1%;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;\r\n	border: solid silver 1px;\r\n	background-color:white;	\r\n	margin-left:5px;\r\n}\r\n\r\n\r\n\r\n/* DROPSHADOW BUTTONS */\r\n#matrixLeft .buttons span {\r\n	background-color:#888;\r\n	position:relative;\r\n	padding:5px 0px 0px 0px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;\r\n\r\n}\r\n#matrixLeft .buttons button,\r\n#matrixLeft .buttons a#return {\r\n	border:solid #2f495e 2px;\r\n	position:relative;\r\n	background-color:#e1e1e1;\r\n	padding:auto 3px;\r\n	margin:0px;\r\n	font-size:11px;\r\n	line-height:13px;\r\n	position:relative;\r\n	top:-6px;\r\n	left:-2px;\r\n	height:22px;\r\n	cursor:pointer;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;	\r\n	font-weight:bold;\r\n	text-decoration:none;\r\n	color:#333;\r\n}\r\n#matrixLeft .buttons a#return {\r\n	font-size:10px;\r\n	padding:3px 10px 2px 10px;\r\n}\r\n#matrixLeft .buttons button:hover,\r\n#matrixLeft .buttons a#return:hover {\r\n	border-color:black;\r\n	color:white;\r\n	background-color:#444;\r\n}\r\n\r\n\r\n\r\n/* WHITE AREA FOR THE LISTING OF OBJECTS TO COMPARE */\r\n#matrixLeft .matrixListing {\r\n	background-color:white;\r\n	_height:300px;\r\n	min-height:300px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;	\r\n	margin:10px 2px 20px 2px;\r\n	padding:auto 10px;\r\n}\r\n#matrixLeft .matrixListing table {\r\n	border-collapse:collapse;\r\n	margin:0px;\r\n	padding:0px;\r\n	display:block;\r\n}\r\n#matrixLeft .matrixListing table a:link {\r\n	font-size:12px;\r\n	color:#111;\r\n}\r\n#matrixLeft .matrixListing table a:visited {\r\n	color:#333;\r\n	font-size:12px;\r\n	text-decoration:none;\r\n}\r\n#matrixLeft .matrixListing table a:hover {\r\n	text-decoration:none;\r\n}\r\n\r\n\r\n\r\n/* GRAY BAR THAT HOLDS THE SORT BUTTONS */\r\n#matrixLeft .matrixListing .sortButtons {\r\n	background-color:#f1f1f1;\r\n	border:solid silver 1px;\r\n	-moz-border-radius-topLeft:4px;\r\n	-moz-border-radius-topRight:4px;\r\n	-webkit-border-radius-topLeft: 4px;\r\n	-webkit-border-radius-topRight: 4px;	\r\n	border-bottom:solid #D2D2D2 2px;\r\n	display:block;\r\n}\r\n\r\n\r\n\r\n/* STYLES TO OVERRIDE THE SORT BUTTON CSS BUILT INTO THE PERL CODE */\r\n#sortByViews-button,\r\n#sortByCompares-button,\r\n#sortByUpdated-button,\r\n#sortByClicks-button,\r\n#sortByName-button {\r\n	background: none;\r\n	white-space:nowrap;\r\n	border-style:none;\r\n	cursor:pointer;\r\n	padding-bottom:4px;\r\n	border-style:none;\r\n	background-color:transparent;\r\n	border-right:solid silver 1px;\r\n	color:#555;\r\n}\r\n#sortByViews-button:hover,\r\n#sortByCompares-button:hover,\r\n#sortByUpdated-button:hover,\r\n#sortByClicks-button:hover,\r\n#sortByName-button:hover {\r\n	color:black;\r\n}\r\n\r\n\r\n\r\n/* MATRIX STATISTICS */\r\n#matrixRight .mainTitle {\r\n	font-size:20px;\r\n	padding:5px 10px;\r\n	border-bottom: solid gray 1px;\r\n	background-color:#d2d2d2;\r\n}\r\n#matrixRight .textBox {\r\n	border-top:solid silver 1px;\r\n	padding:10px 5px;\r\n}\r\n.matrixStatistics {\r\n	padding:10px;\r\n}\r\n.matrixStatistics .title {\r\n	font-weight:bold;\r\n	background-color:#f1f1f1;\r\n	padding:2px 5px;\r\n	font-size:11px;\r\n	-moz-border-radius:4px;\r\n	border:solid #d2d2d2 1px;\r\n}\r\n.matrixStatistics .statistics {\r\n	margin-bottom:15px;\r\n}\r\n.matrixStatistics .label {\r\n	text-align:right;\r\n	width:100px;\r\n	font-size:10px;\r\n}\r\n.matrixStatistics .data {\r\n	font-size:10px;\r\n}\r\n.matrixStatistics .data a {\r\n	color:#111;\r\n}\r\n.matrixStatistics .data a:hover {\r\n	text-decoration:none;\r\n}\r\n\r\n\r\n\r\n/* LINKS TO CONTROL ADMIN FUNCTIONS */\r\n.adminLinks {\r\n	background-color:#f1f1f1;\r\n}\r\n.adminLinks a:link,\r\n.adminLinks a:visited {\r\n	display:block;\r\n	text-align:center;\r\n	text-decoration:none;\r\n	color:#555;\r\n	font-weight:normal;\r\n	font-size:10px;\r\n	padding:2px 5px;\r\n	border-top:solid silver 1px;\r\n}\r\n.adminLinks a:hover {\r\n	color:black;\r\n}\r\n.adminLinks a.newLink:link,\r\n.adminLinks a.newLink:visited {\r\n	background-color:#3498d1;\r\n	color:white;\r\n	display:block;\r\n}\r\n.adminLinks a.newLink:hover {\r\n	background-color:#39a6e5;\r\n}\r\n\r\n\r\n\r\n/* STYLE FOR THE DETAILED LISTING */\r\n#matrixDetail {\r\n	min-width:1000px;\r\n}\r\n#matrixDetail .editBtns  {\r\n	font-size:9px;\r\n	line-height:11px;\r\n	vertical-align:middle;\r\n	font-weight:normal;\r\n	margin-left:10px;\r\n}\r\n#matrixDetail .editBtns a {\r\n	color:black;\r\n	text-decoration:underline;\r\n}\r\n#matrixDetail .editBtns a:hover {\r\n	text-decoration:none;\r\n}\r\n\r\n#matrixDetail .stats .screenshot {\r\n	float:left;\r\n	margin-right:20px;\r\n}\r\n\r\n#matrixDetail .commentsMail strong.title {\r\n	margin-bottom:0px;\r\n	margin-top:20px;\r\n	display:block;\r\n	background-color:#d2d2d2;\r\n	padding:2px 10px;\r\n	border:solid 1px gray;\r\n	border-bottom-color:silver;\r\n	-moz-border-radius-topLeft:4px;\r\n	-moz-border-radius-topRight:4px;\r\n}\r\n\r\n#matrixDetail .assetAspectComments {\r\n	margin:0px 0px 20px 0px;\r\n	border:solid gray 1px;\r\n	background-color:#f1f1f1;\r\n	-moz-border-radius-bottomLeft:4px;\r\n	-moz-border-radius-bottomRight:4px;\r\n}\r\n#matrixDetail .assetAspectComments .assetAspectComment {\r\n	border-top:solid silver 1px;\r\n	border-bottom:solid gray 1px;\r\n	padding:3px;\r\n	background-color:#f5f5f5;\r\n}\r\n#matrixDetail .assetAspectComments .assetAspectCommentForm {\r\n	border-top:solid #d2d2d2 5px;\r\n	padding:20px;\r\n}\r\n\r\n\r\n\r\n#matrixDetail .stats ul, #matrixDetail .stats ul li {\r\n	list-style-type:none;\r\n	margin:0px;\r\n	padding:0px;\r\n}\r\n#matrixDetail .stats ul li {\r\n	display:block;\r\n	line-height:20px;\r\n	margin:4px 0px;\r\n}\r\n#matrixDetail .stats ul li strong {\r\n	display:block;\r\n	float:left;\r\n	width:130px;\r\n	text-align:right;\r\n	background-color:#f1f1f1;\r\n	padding-right:5px;\r\n	margin-right:5px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:3px;\r\n	font-size:11px;\r\n	border:solid #d2d2d2 1px;\r\n}\r\n\r\n\r\n.showLink {\r\n	background-color:#e1e1e1;\r\n	border:2px solid #2F495E;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:4px;\r\n	padding:3px 10px;\r\n	text-decoration:none;\r\n	color:black;\r\n}\r\n.showLink:hover,\r\n.hideLink:hover {\r\n	background-color:#555;\r\n	color:white;\r\n}\r\n.hideLink {\r\n	background-color:#f1f1f1;\r\n	border:2px solid #2F495E;\r\n	border-bottom-style:none;\r\n	-moz-border-radius-topLeft:4px;\r\n	-moz-border-radius-topRight:4px;\r\n	-webkit-border-radius-topLeft:4px;\r\n	-webkit-border-radius-topRight:4px;\r\n	padding:3px 10px;\r\n	text-decoration:none;\r\n	color:black;\r\n}\r\n\r\n#matrixMail {\r\n	background-color:#f1f1f1;\r\n	padding:15px;\r\n	border:2px solid #2F495E;\r\n	-moz-border-radius:4px;\r\n	-moz-border-radius-topLeft:0px;\r\n	-webkit-border-radius:4px;\r\n	-webkit-border-radius-topLeft:0px;\r\n	margin-top:1px;\r\n}\r\n#matrixMail * .tableData {\r\n	padding:5px;\r\n	margin:0px;\r\n}\r\n#matrixMail * input {\r\n	padding:0px;\r\n	margin:0px;\r\n}\r\n#matrixMail * .formDescription {\r\n	text-align:right;\r\n	vertical-align:middle;\r\n	padding-right:10px;\r\n	font-weight:bold;\r\n}\r\n#matrixMail form * img {\r\n	margin-top:-18px;\r\n}\r\n#matrixMail #verify_formId {\r\n	height:45px;\r\n	line-height:45px;\r\n	font-size:35px;\r\n	padding:0px;\r\n	margin:0px;\r\n	margin-right:20px;\r\n}\r\n\r\n#matrixRatings {\r\n	width:264px;\r\n	position:relative;\r\n	left:-2px;\r\n	top:12px;\r\n}\r\n#matrixRatings table {\r\n	margin-left:0px;\r\n}\r\n#matrixRatings td {\r\n	overflow:hidden;\r\n}\r\n#matrixRatings .formDescription {\r\n	text-align:right;\r\n	background-color:#97BCD1;\r\n	border:solid #4D606B 1px;\r\n	padding:2px 5px;\r\n	font-weight:bold;\r\n	font-size:10x;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:4px;\r\n	color:#333;\r\n}\r\n#matrixRatings .formDescription a:before {\r\n	text-decoration:none;\r\n}\r\n#matrixRatings .formDescription a {\r\n	display:block;\r\n	color:red;\r\n	text-decoration:none;\r\n}\r\n#matrixRatings .formDescription a:hover {\r\n	text-decoration:underline;\r\n}\r\n\r\n\r\n\r\n\r\n#matrixAttributes {\r\n	float:left;\r\n	_width:40%;\r\n	min-width:20%;\r\n	max-width:45%;\r\n	margin-right:20px;\r\n}\r\n#rightDetails {\r\n	float:left;\r\n	_width:20%;\r\n	min-width:20%;\r\n	max-width:45%;\r\n}\r\n\r\n\r\n\r\n#attributes {\r\n	border:solid #d2d2d2 1px;\r\n	background-color:#f1f1f1;\r\n	margin-top:10px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:4px;\r\n	padding:10px;\r\n}\r\n#attributes table {\r\n	border-collapse:collapse;\r\n	padding:0px;\r\n	margin:0px;\r\n}\r\n#attributes table * td {\r\n	padding:2px;\r\n	margin:0px;\r\n}\r\n\r\n\r\n.yui-dt0-col-value {\r\n	font-weight:bold;\r\n	font-size:14px;\r\n	padding:3px;\r\n	white-space:no-wrap;\r\n}\r\n\r\n\r\n\r\n/* COMPARISON STYLES */\r\n#compareList table {\r\n	border-collapse:collapse;\r\n	border:solid silver 1px;\r\n	margin-top:5px;\r\n}\r\n#compareList table * th a {\r\n	color:black;\r\n	padding:1px 5px;\r\n}\r\n#compareList table * td {\r\n	background-color:#f1f1f1;\r\n	border-top:solid gray 1px;\r\n	border-bottom:solid silver 1px;\r\n}\r\n\r\n#compareList .yui-dt-liner {\r\n	color:#39A6E5;\r\n}\r\n\r\n#compareList .yui-dt-col-name .yui-dt-liner {\r\n	font-style:italic;\r\n	font-size:10px;\r\n	color:#555;\r\n}\r\n#compareList .yui-dt-col-name .yui-dt-liner b {\r\n	font-size:15px;\r\n	font-style:normal;\r\n	padding-right:25px;\r\n	color:black;\r\n}',0,'text/css',1250243000,0,'.wg-clear{display:inline;clear:both;font-size:0px;line-height:0px;}#matrixLeft{float:left;width:65%;padding:1%;min-height:1%;background-color:#d2d2d2;-moz-border-radius:4px;-webkit-border-radius:4px;}#matrixRight{float:left;width:25%;padding:0px;min-height:1%;-moz-border-radius:4px;-webkit-border-radius:4px;border:solid silver 1px;background-color:white;margin-left:5px;}#matrixLeft .buttons span{background-color:#888;position:relative;padding:5px 0px 0px 0px;-moz-border-radius:4px;-webkit-border-radius:4px;}#matrixLeft .buttons button,#matrixLeft .buttons a#return{border:solid #2f495e 2px;position:relative;background-color:#e1e1e1;padding:auto 3px;margin:0px;font-size:11px;line-height:13px;position:relative;top:-6px;left:-2px;height:22px;cursor:pointer;-moz-border-radius:4px;-webkit-border-radius:4px;font-weight:bold;text-decoration:none;color:#333;}#matrixLeft .buttons a#return{font-size:10px;padding:3px 10px 2px 10px;}#matrixLeft .buttons button:hover,#matrixLeft .buttons a#return:hover{border-color:black;color:white;background-color:#444;}#matrixLeft .matrixListing{background-color:white;_height:300px;min-height:300px;-moz-border-radius:4px;-webkit-border-radius:4px;margin:10px 2px 20px 2px;padding:auto 10px;}#matrixLeft .matrixListing table{border-collapse:collapse;margin:0px;padding:0px;display:block;}#matrixLeft .matrixListing table a:link{font-size:12px;color:#111;}#matrixLeft .matrixListing table a:visited{color:#333;font-size:12px;text-decoration:none;}#matrixLeft .matrixListing table a:hover{text-decoration:none;}#matrixLeft .matrixListing .sortButtons{background-color:#f1f1f1;border:solid silver 1px;-moz-border-radius-topLeft:4px;-moz-border-radius-topRight:4px;-webkit-border-radius-topLeft:4px;-webkit-border-radius-topRight:4px;border-bottom:solid #D2D2D2 2px;display:block;}#sortByViews-button,#sortByCompares-button,#sortByUpdated-button,#sortByClicks-button,#sortByName-button{background:none;white-space:nowrap;border-style:none;cursor:pointer;padding-bottom:4px;border-style:none;background-color:transparent;border-right:solid silver 1px;color:#555;}#sortByViews-button:hover,#sortByCompares-button:hover,#sortByUpdated-button:hover,#sortByClicks-button:hover,#sortByName-button:hover{color:black;}#matrixRight .mainTitle{font-size:20px;padding:5px 10px;border-bottom:solid gray 1px;background-color:#d2d2d2;}#matrixRight .textBox{border-top:solid silver 1px;padding:10px 5px;}.matrixStatistics{padding:10px;}.matrixStatistics .title{font-weight:bold;background-color:#f1f1f1;padding:2px 5px;font-size:11px;-moz-border-radius:4px;border:solid #d2d2d2 1px;}.matrixStatistics .statistics{margin-bottom:15px;}.matrixStatistics .label{text-align:right;width:100px;font-size:10px;}.matrixStatistics .data{font-size:10px;}.matrixStatistics .data a{color:#111;}.matrixStatistics .data a:hover{text-decoration:none;}.adminLinks{background-color:#f1f1f1;}.adminLinks a:link,.adminLinks a:visited{display:block;text-align:center;text-decoration:none;color:#555;font-weight:normal;font-size:10px;padding:2px 5px;border-top:solid silver 1px;}.adminLinks a:hover{color:black;}.adminLinks a.newLink:link,.adminLinks a.newLink:visited{background-color:#3498d1;color:white;display:block;}.adminLinks a.newLink:hover{background-color:#39a6e5;}#matrixDetail{min-width:1000px;}#matrixDetail .editBtns{font-size:9px;line-height:11px;vertical-align:middle;font-weight:normal;margin-left:10px;}#matrixDetail .editBtns a{color:black;text-decoration:underline;}#matrixDetail .editBtns a:hover{text-decoration:none;}#matrixDetail .stats .screenshot{float:left;margin-right:20px;}#matrixDetail .commentsMail strong.title{margin-bottom:0px;margin-top:20px;display:block;background-color:#d2d2d2;padding:2px 10px;border:solid 1px gray;border-bottom-color:silver;-moz-border-radius-topLeft:4px;-moz-border-radius-topRight:4px;}#matrixDetail .assetAspectComments{margin:0px 0px 20px 0px;border:solid gray 1px;background-color:#f1f1f1;-moz-border-radius-bottomLeft:4px;-moz-border-radius-bottomRight:4px;}#matrixDetail .assetAspectComments .assetAspectComment{border-top:solid silver 1px;border-bottom:solid gray 1px;padding:3px;background-color:#f5f5f5;}#matrixDetail .assetAspectComments .assetAspectCommentForm{border-top:solid #d2d2d2 5px;padding:20px;}#matrixDetail .stats ul,#matrixDetail .stats ul li{list-style-type:none;margin:0px;padding:0px;}#matrixDetail .stats ul li{display:block;line-height:20px;margin:4px 0px;}#matrixDetail .stats ul li strong{display:block;float:left;width:130px;text-align:right;background-color:#f1f1f1;padding-right:5px;margin-right:5px;-moz-border-radius:4px;-webkit-border-radius:3px;font-size:11px;border:solid #d2d2d2 1px;}.showLink{background-color:#e1e1e1;border:2px solid #2F495E;-moz-border-radius:4px;-webkit-border-radius:4px;padding:3px 10px;text-decoration:none;color:black;}.showLink:hover,.hideLink:hover{background-color:#555;color:white;}.hideLink{background-color:#f1f1f1;border:2px solid #2F495E;border-bottom-style:none;-moz-border-radius-topLeft:4px;-moz-border-radius-topRight:4px;-webkit-border-radius-topLeft:4px;-webkit-border-radius-topRight:4px;padding:3px 10px;text-decoration:none;color:black;}#matrixMail{background-color:#f1f1f1;padding:15px;border:2px solid #2F495E;-moz-border-radius:4px;-moz-border-radius-topLeft:0px;-webkit-border-radius:4px;-webkit-border-radius-topLeft:0px;margin-top:1px;}#matrixMail * .tableData{padding:5px;margin:0px;}#matrixMail * input{padding:0px;margin:0px;}#matrixMail * .formDescription{text-align:right;vertical-align:middle;padding-right:10px;font-weight:bold;}#matrixMail form * img{margin-top:-18px;}#matrixMail #verify_formId{height:45px;line-height:45px;font-size:35px;padding:0px;margin:0px;margin-right:20px;}#matrixRatings{width:264px;position:relative;left:-2px;top:12px;}#matrixRatings table{margin-left:0px;}#matrixRatings td{overflow:hidden;}#matrixRatings .formDescription{text-align:right;background-color:#97BCD1;border:solid #4D606B 1px;padding:2px 5px;font-weight:bold;font-size:10x;-moz-border-radius:4px;-webkit-border-radius:4px;color:#333;}#matrixRatings .formDescription a:before{text-decoration:none;}#matrixRatings .formDescription a{display:block;color:red;text-decoration:none;}#matrixRatings .formDescription a:hover{text-decoration:underline;}#matrixAttributes{float:left;_width:40%;min-width:20%;max-width:45%;margin-right:20px;}#rightDetails{float:left;_width:20%;min-width:20%;max-width:45%;}#attributes{border:solid #d2d2d2 1px;background-color:#f1f1f1;margin-top:10px;-moz-border-radius:4px;-webkit-border-radius:4px;padding:10px;}#attributes table{border-collapse:collapse;padding:0px;margin:0px;}#attributes table * td{padding:2px;margin:0px;}.yui-dt0-col-value{font-weight:bold;font-size:14px;padding:3px;white-space:no-wrap;}#compareList table{border-collapse:collapse;border:solid silver 1px;margin-top:5px;}#compareList table * th a{color:black;padding:1px 5px;}#compareList table * td{background-color:#f1f1f1;border-top:solid gray 1px;border-bottom:solid silver 1px;}#compareList .yui-dt-liner{color:#39A6E5;}#compareList .yui-dt-col-name .yui-dt-liner{font-style:italic;font-size:10px;color:#555;}#compareList .yui-dt-col-name .yui-dt-liner b{font-size:15px;font-style:normal;padding-right:25px;color:black;}',0),('zb_OPKNqcTuIjdvvbEkRjw','/*/ styles for the article asset /*/\r\n.withImage .articleContent, .linkedImage .articleContent {\r\n  width:100%;\r\n  overflow:hidden;\r\n}\r\n.withImage .articleImage, .linkedImage .articleImage {\r\n  float:right;\r\n  margin:0 0 10px 10px;\r\n}\r\n.linkedImage .caption {\r\n  display:block;\r\n}\r\n',0,'text/css',1255485472,0,'/*/ styles for the article asset /*/ .withImage .articleContent, .linkedImage .articleContent { width:100%; overflow:hidden; }.withImage .articleImage, .linkedImage .articleImage { float:right; margin:0 0 10px 10px; }',0),('VyCINX2KixKYr2pzQGX9Mg','/*/ styles for the layout asset /*/\r\n.wg-left {\r\n  float: left;\r\n}\r\n.wg-right {\r\n  float: right;\r\n}\r\n.wg-clear {\r\n  clear: both;\r\n}\r\n.sidebyside .wg-content-position, .oneovertwo .wg-content-position {\r\n  width: 49%;\r\n}\r\n.oneovertwo .wg-top {\r\n  width: 100%;\r\n}\r\n.oneoverthree .wg-first-column, .oneoverthree .wg-second-column, .oneoverthree .wg-third-column,\r\n.threeColumns .wg-first-column, .threeColumns .wg-second-column, .threeColumns .wg-third-column {\r\n  width: 32%;\r\n}\r\n.oneoverthree .wg-first-column,\r\n.threeColumns .wg-first-column {\r\n  margin-right:2%;\r\n}\r\n.rightcolumn .wg-first-column {\r\n  width: 65%;\r\n}\r\n.rightcolumn .wg-second-column {\r\n  width: 33%;\r\n}\r\n',0,'text/css',1255485472,0,'/*/ styles for the layout asset /*/ .wg-left { float: left; }.wg-right { float: right; }.wg-clear { clear: both; }.sidebyside .wg-content-position, .oneovertwo .wg-content-position { width: 49%; }.oneovertwo .wg-top { width: 100%; }.oneoverthree .wg-first-column, .oneoverthree .wg-second-column, .oneoverthree .wg-third-column { width: 32%; }.oneoverthree .wg-first-column { margin-right:2%; }.rightcolumn .wg-first-column { width: 65%; }.rightcolumn .wg-second-column { width: 33%; }',0),('_XfvgNH__bY1ykMiKYSobQ','/* general */	\n\n.WGbutton {\n	float:right;\n	padding-right:10px;\n}	\n.centered {\n	text-align: center;\n}\n.WGaccount_message {\n	background-color: white;\n	border: solid #BECEF8 1px;\n	height: 300px;\n	margin-bottom: 10px;\n	margin-left: 60px;\n	margin-top: 20px;\n    overflow:-moz-scrollbars-vertical;\n    overflow-x:hidden;\n    overflow-y:scroll;\n	padding:10px;\n    text-align: left;\n	vertical-align:top;\n	width: 90%;\n}\n\n.WGprofileMember {\n	font-size:9px;\n	margin-right:20px;\n	text-align:right;\n}\n.WGmember {\n	color:#3e4f77;\n 	font: 9px Verdana, Arial, Helvetica, sans-serif;\n	text-align:center;\n}\n.WGphotostyle {\n	border:solid #3e4f77 2px;\n	margin-bottom:5px;\n	margin-top:5px\n		}\n#rightalign {\n	float: right;\n}\n/*.WGsend {\n	float:right;\n	padding-right: 75px;\n}*/\n\n\n/* bio, addtonetwork, network */\n.WGbordered {\n	border-bottom: dashed #BECEF8 2px;\n	padding-bottom: 10px;\n}\n.WGfriendpic {\n	border: solid #BECEF8 1px;\n}\n.WGinvitemsg {\n	width: 600px;\n	height: 150px;\n}\nol.WGProfile_interests {\n	color:#0B2259;\n	font-size:15px;\n	font-weight:bold;\n	list-style-type:none;\n	margin:0px;\n	padding:0px;\n	padding:5px 5px;\n}\nol.WGProfile_interests li {\n	margin-bottom:15px;\n}\nol.WGProfile_interests span {\n	font-size:12px;\n	font-weight:normal;\n	color:black;\n}\n.WGpBio {\n	border-bottom:solid #DDE6FB 1px;\n	margin:0px;\n	margin-bottom:5px;\n	padding-bottom:5px;			\n}\n.WGpBio div {\n	background-color:#DDE6FB;\n	padding:2px 5px;\n	margin-bottom:2px;\n}\n.WGprogram {\n	font-size: 9px;\n}\n\n/* contributions */\n\n.WGContribCount {\n	font-size:12px;\n	text-align:left;\n	padding:3px\n}\n.WGContribTitle {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#0B2259;\n	font-size:12px;\n	font-weight:bold;\n	min-height:25px;\n	padding:3px;\n    text-align:center;\n    text-decoration: underline;\n}\n.WGContribTitleLeft {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#0B2259;\n	font-size:12px;\n	font-weight:bold;\n	min-height:25px;\n	padding:3px;\n    text-align:center;\n    text-decoration: underline;\n}	\n.WGContribEntry {\n    text-align:center;\n	padding:3px;\n}\n.WGContribEntryLeft {\n	text-align:left;\n	padding:3px;\n}\n	\n/* edit box */\n.WGeditBox {\n	/*background:white url(images/edit_box_bg.jpg) no-repeat bottom left;*/\n	border:solid #8DABF1 2px;\n	display:block;\n	font-family:verdana;\n	font-size:9px;\n	font-weight:bold;\n	left:100px;\n	-moz-box-sizing:border-box;\n	padding:5px;\n	position:absolute;\n	top:100px;\n	width:590px;\n	z-index:100;\n	\n}\n.WGeditBox input, .WGeditBox select {\n	font-size:9px;	\n}\n\n/* friends */\n\n.WGfriends_name {\n	font-weight:bold;\n	width:90%;\n}\n.WGfriends_photo {\n	font-weight:bold;\n	width:10%;\n}\n.WGfriends_photo img {\n	height: 50px; \n	width: 50px;\n}\n.WGfriends_private { \n	float:right;\n	padding-bottom: 5px;\n	width: 50%;\n}\n.WGfriends_ninety { \n	vertical-align:top;\n	width: 90%;\n}\n.WGfriends_seventy { \n	vertical-align:top;\n	width: 70%;\n}\n.WGfriends_ten { \n	width: 10%;\n}\n.WGfriends_ten img {\n	height: 50px; \n	width: 50px;\n}\n.WGfriends_twenty { \n	width: 20%;\n}\n.WGaccepts {\n	padding-bottom: 5px;\n}\n\n/* inbox */\n\n.WGProfile_msgcontainer {\n    padding:2px;\n}\n.WGinbox_count {\n	 font-size:12px;\n	 font-weight:bold;\n	 padding:3px;\n	 text-align:left;\n}\n.WGinbox_errors {\n	font-weight:bold;\n	color:red;\n	text-align:center;\n}\n.WG_inbox_InviteLabel {\n	width:50px;\n	text-align:right;\n}\n.WG_inbox_InviteLabelView {\n	font-weight:bold;\n	width:120px;\n}\n.WGmsgcontainer {\n    padding:6px;\n	display:block;\n	margin-bottom:6px;\n}\n/* inbox contacts */\n.WGdatacells {\n	border-bottom: dashed #BECEF8 1px;\n}\n.WGinbox_contactsTbl {\n    background-color:#EEF2FD;\n	font-family:arial;\n	font-size:9pt;\n	width:100%;\n}\n#contacts {\n	height: 275px;\n	overflow: auto;\n}\n/* inbox forms */\n.WGbuttons_left {\n	float: left;\n}\n.WGbuttons_right {\n	float: right;\n}\n.WGinbox_from {\n    color: black;\n    font-weight: normal;\n    text-decoration: none;\n}\n.WGinbox_subject {\n    width: 530px;\n}\n.WGinbox_messageTo {\n	background-color: white;\n	border: solid #BECEF8 1px;\n	height: 50px;\n	overflow:-moz-scrollbars-vertical;\n    overflow-x:hidden;\n    overflow-y:scroll;\n    width: 530px;\n}\n/* inbox pagination */\n.WGinbox_buttons {\n	display:inline;\n	float:left;\n	font-size:10px;\n	text-align:left;\n	width:70%;	\n}\n.WGinbox_pagination {\n	display:inline;\n	text-align:right;\n	width:20%;\n}\n.WGinbox_messagerpp {\n	font-size:10px;\n	display:inline;\n	text-align:right;\n	width:20%;\n}\n.WGmessage {\n	display:inline;\n	float:left;\n	font-size:10px;\n	text-align:left;\n	width:70%;\n}\n\n.WGmessagerpp {\n	font-size:10px;\n	display:inline;\n	text-align:right;\n	float: right;\n}\n\n.WG-previous-next {\n	float: right;\n}\n\n/* inbox threads */\n\n.WGevenThread {\n	background-color: #e1e8fb;\n    border-bottom: 1px solid #bfcef9;\n    padding: 8px;\n    text-align:center;\n}\n.WGoddThread {\n	background-color: #eef2fd;\n    border-bottom: 1px solid #bfcef9;\n    padding: 8px;\n    text-align: center;\n}\n\n/* pagination */\n.WGProfile_pagination {\n	font-size:10px;\n	text-align:right;\n    width:20%;\n}\n.WGProfile_messagerpp {\n	font-size:10px;\n	display:inline;\n	text-align:right;\n	width:20%;\n}\n.WGProfile_paginationLeft {\n	font-size:10px;\n	text-align:left;\n	width:20%;\n}\n.WGProfile_paginationCenter {\n	font-size:10px;\n	text-align:center;\n	width:20%;\n}\n.WGProfile_pagination a {\n	background-color:#f2f5fa;\n	border:solid #bfc8dc 1px;\n	font-size:10px;\n	font-weight:bold;\n	padding:1px 5px;\n	text-decoration:none;\n}\n.WGProfile_pagination a:hover {\n	background-color:#d8dee8;\n	color:white;\n}\n.WGProfile_pagination .prevNext {\n    background-color: transparent;\n	border: none;\n    color: black;\n}\n.WGProfile_pagination .prevNext:hover {\n    background-color: transparent;\n	border: none;\n    color: black;\n}\n.WGProfile_pagination .active {\n    background-color:#d8dee8;\n	border:solid #bfc8dc 1px;\n	color:white; \n	font-size:10px;\n	font-weight:bold;\n	padding:1px 5px;\n	text-decoration:none;\n}\n.WGProfile_pagination img {\n	vertical-align:middle;\n	margin-top:2px;\n	border:none;\n}\n/* profile */\n.WGProfile_registration {\n	background:none;\n	border:none;\n	font-size:9pt;\n	font-family:arial;\n	margin:0;\n	padding:0;\n	width:100%;\n}\n.WGProfile_registration .header {\n	background-color:#818997;\n	color:#3e4f77;\n	font-size:10px;\n	font-weight:bold;\n	text-align:left;		\n}\n.WGProfile_registration .header a {\n	color:white;\n	text-decoration:none;			\n}\n.WGProfile_registration .help a {\n	font-weight:bold;\n	text-decoration:none;\n}\n.WGProfile_registration .inputText {\n	font-size:10px;\n	margin-right:1px;\n}\n.WGProfile_registration .label {\n	font-size:9pt;\n	font-weight:bold;\n	text-align:right;\n	white-space:nowrap;\n	width:1%;\n}	\n.WGProfile_registration .labelLeft {\n	font-size:9pt;\n	font-weight:bold;\n	white-space:nowrap;\n	width:1%;\n	text-align: left;\n	vertical-align: top;\n}\n.WGProfile_registration .smallLabel {\n	font-size:8px;\n	text-align:center;\n}\n.WGProfile_registration .smallText {\n	font-size:9px;\n}\n\n.WGinboxTbl {\n	display:block;\n	margin: 4px;\n	padding: 2px;\n}\n\n.WGProfile_registration .bar, .WGProfile_registration .barRight {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	margin:10px 0px 10px 0px;\n	min-height:25px;\n	padding:4px 4px 0px 4px;\n	vertical-align:middle;\n}\n.WGProfile_registration .bar {\n    text-align: center;\n}\n.WGProfile_registration .barRight {\n    text-align: right;\n}\n.WGProfile_registration .bar a {\n    color:#0B2259;\n    font-size:10px;\n	font-weight:bold;\n}\n.WGProfile_registration .barFive {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	text-align:center;\n	margin-right:3px;\n	min-height:25px;\n	padding:2px;\n	width:4.3%;\n}\n.WGProfile_registration .barTen {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	min-height:25px;\n	padding:2px;\n	text-align:center;\n	width:7.2%;\n}\n.WGProfile_registration .barFifteen {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	margin-right:3px;\n	min-height:25px;\n	padding:2px;\n	text-align:center;\n	width:15%;\n}\n.WGProfile_registration .barFifty {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	margin-right:3px;\n	min-height:25px;\n	padding:2px;\n	text-align:center;\n	width:50%;	\n}\n.WGbarContainer {\n	display:block;\n	margin:10px 0px 10px 0px;	\n	width:100%;\n\n}\n\n/* profile edit */\n\n.WGfields {\n	padding: 2px;\n\n}\n.WGfields_left {\n	padding:2px;\n	vertical-align:top;\n	width: 15%;\n}\n.WGfields_right {\n	display:inline\n	float:right;\n	padding:2px;\n	text-align:right;\n	width:80%;\n	vertical-align: top;\n}\n.WGProfile {\n	display:table;\n	margin: 0;\n	padding: 0;\n	width:100%;\n}\n.WGProfileFields {\n	border:0;\n	padding: 0;\n	margin:0;\n	width: 100%;\n	\n}\n.WGProfileFields ol {\n	display: inline;\n	list-style-type: none;\n	\n}\n.WGProfileFields ul {\n	list-style-type: none;\n	display: inline;\n}\n.WGProfileFields ul li {\n	display: inline-block;\n	*display: inline;\n	zoom: 1;\n}\n/* profile view */\n.WGProfile_accepts {\n	text-align:right;\n	background-color:gray;\n	padding:4px;\n	width:100%;\n}\n.WGviewContainer {\n	margin:0;\n	padding:0;\n	width:90%;\n}\n.WGinternational {\n	background-color:red;\n	color:white;\n	display:inline;\n	font-weight:bold;\n	padding:4px;\n	text-align:center;\n}\n\n.WGcategoryLabel {\n	vertical-align:top; \n	width:90%;\n}\n\n.WGprivateMessage {\n	background-color:gray;\n	padding:4px;\n	text-align:right;\n}\n\n.WGprofileAlert {\n	background-color:red;\n	color:white;\n	font-weight:bold;\n	padding:4px;\n	text-align:center;\n	width:100%;\n}\nWGprofilePhoto {\n	vertical-align:top;\n}\n\n/* profile errors */\n#WGprofileErrors {\n    background-color: #ff0000;\n	color: #ffffff;\n    font-weight: bold;\n    text-align: center;\n}\n.WGprofilefield_required_off {\n}\n.WGprofilefield_required {\n    background-color: #ffd6bb;\n}\n.WGprofilefield_error {\n    background-color: #FF9494;\n}\n.WGerrorMsg {\n	font-weight:bold;\n	color:red;\n	text-align:center;\n}\n/* user */\n.WGuserInvite_subject {\n 	background-color: white;\n	border: solid #BECEF8 1px;\n    height: 25px;\n    text-align: left;\n	width: 500px;\n    /*margin-left: 50px;*/\n    /*margin-bottom: 20px;*/\n    /*overflow:-moz-scrollbars-vertical;\n    overflow-x:hidden;\n	overflow-y:scroll;*/\n}\n/* view profile */\n\n.WGprofile_canEdit {\n	text-align:center;\n	background-color:red;\n	padding:4px;\n	color:white;\n	font-weight:bold;\n}\n.WGprofile_fieldLabel {\n	background: #DDE6FB;\n	padding:2px;\n	width:200px;\n}\n.WGprofile_fieldData {\n	margin-left: 5px;\n}\n.WGprofile_fieldStatus {\n	padding:4px;\n	color:white;\n	font-weight:bold\n}\n\n/**********************************************************************/\n/*                             TABS                                   */\n/**********************************************************************/\n\n/* TABS - outer */\n\n.WGbottombutton {\n    float:right;\n    padding-right:2px;\n    padding-top: 2px;\n    position: relative;\n} \n.WGcontent {\n	padding:10px;\n\n}\n.WGcleartab {\n	clear: both; \n	height:0;\n}\n.WGsubContent { /* color setting for border under outer tabs that surrounds inner tabs */\n	border: solid #d8dee8 6px;\n}\n.WGtopbutton {\n    float:right;\n    clear:both;\n    padding-right:2px;\n    padding-top: 2px;\n    position: relative;\n}\n\n\nul.WGtopTabs,\nul.WGtopTabs li {\n	list-style-type:none;\n	margin:10px 0px 0px 0px;\n	padding:0px;\n	position:relative;\n	width:auto;\n	Xposition:relative;\n	zoom:1;\n}\nul.WGtopTabs li {\n	display:block;\n	float:left;\n	margin-right: 3px;\n}\nul.WGtopTabs li b { \n	background-color: #eef2fd;\n	border-top:solid #d8dee8 1px;\n	display:block;\n	padding:4px 8px;\n	position:relative;\n	top:-1px;	\n}\nul.WGtopTabs a { /* non-selected tabs color settings */\n	display:block;\n	color:#9ea0bb;\n	font-size:12px;\n	font-family: Arial, Helvetica, sans-serif;\n	text-decoration:none;\n	background-color:#f2f5fa;\n	border-left: solid #d8dee8 1px;\n	border-right: solid #d8dee8 1px;	\n}\n\nul.WGtopTabs a:hover,\nul.WGtopTabs a:hover b,\nul.WGtopTabs a.selected,\nul.WGtopTabs a.selected b { /* selected tab color settings */\n	background-color:#d8dee8;\n	color:#3e4f77;\n}\ntext-align: right;\n/* TABS - YUI */\n\n.WGcleardiv {\n    clear: both;\n    margin: 0px 0px 0px 0px;\n    padding: 0px;\n}\n\n.WGviewProfile, .wgView {\n    border: none;\n    font: bold 10px Verdana;\n    color: #3e4f77;\n    text-decoration:none;\n}\n\n.WGview {\n    position: absolute;\n    right: 4px;\n    top:4px;\n}\n\n.WGprofile_displayView {\n    -x-system-font:none;\n    border:medium none;\n    color:#0B2258;\n    display:inline;\n    float:right;\n    font-family:Verdana;\n    font-size:10px;\n    font-size-adjust:none;\n    font-stretch:normal;\n    font-style:normal;\n    font-variant:normal;\n    font-weight:bold;\n    line-height:normal;\n    padding-right:8px;\n    padding-top:3px;\n    text-decoration: none;\n}\n\n.WGprofile_displaySubContent { /* border around friends tab content */\n	border: solid #d8dee8 6px;\n    border-top: solid #d8dee8 18px;\n}\n\n\n /*\nCopyright (c) 2008, Yahoo! Inc. All rights reserved.\nCode licensed under the BSD License:\nhttp://developer.yahoo.net/yui/license.txt\nversion: 2.6.0\n*/\n\n/* yui tabs color settings below */\n\n/* .yui-navset defaults to .yui-navset-top */\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-top .yui-nav { /* protect nested tabviews from other orientations */\n    border:solid #eef2fd; /* color between tab list and content */\n    border-width:0 0 5px;\n    Xposition:relative;\n    zoom:1;\n}\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav a,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-top .yui-nav a {\n    	background:#ffffff;  /* tab background */\n    	border:solid #ffffff;\n    	border-width:0 1px;\n    	color:#bfccdd;\n    	position:relative;\n    	text-decoration:none;\n    	font-size:12px;\n		font-family: Arial, Helvetica, sans-serif;\n		font-weight: bold;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav a em,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-top .yui-nav a em {\n    border:solid #eef2fd;\n    border-width:1px 0 0;\n    cursor:hand;\n    padding:0.25em .75em;\n    left:0; right: 0; bottom: 0; /* protect from other orientations */\n    top:-1px; /* for 1px rounded corners */\n    position:relative;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected a,\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected a:focus, /* no focus effect for selected */\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected a:hover { /* no hover effect for selected */\n    	background: #eef2fd; /* selected tab background */\n    	color: #3e4f77;\n    	font-size:12px;\n		font-family: Arial, Helvetica, sans-serif;\n		text-decoration:none;\n		font-weight: bold;\n}\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected a,\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected a em {\n    border-color:#eef2fd; /* selected tab border color */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav a:hover,\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav a:focus {\n    	background: #eef2fd; /* hover tab background */\n    	color: #3e4f77;\n    	outline:0;\n    	font-size:12px;\n		font-family: Arial, Helvetica, sans-serif;\n		text-decoration:none;\n		font-weight: bold;\n\n}\n.WGsubContent .yui-skin-sam .yui-navset .yui-content {\n    background: #eef2fd; /* content background color */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-content,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-top .yui-content {\n    border:5px solid #eef2fd; /* content border */\n    padding:0.75em 1em; /* content padding */\n}\n\n/* left and right orientations */\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-left .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-right .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav {\n    border-width:0 5px 0 0;\n    Xposition:absolute; /* from tabview-core; have to reiterate for skin-sam due to pos:rel on skin-sam yui-nav */\n    top:0; bottom:0; /* stretch to fill content height */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-right .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav {\n    border-width:0 0 0 5px;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav li,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-left .yui-nav li,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav li {\n    margin:0 0 0.3em; /* space between tabs */\n    padding:0 0 0 1px; /* gecko: make room for overflow */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav li {\n    padding:0 1px 0 0; /* gecko: make room for overflow */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav .selected,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-left .yui-nav .selected { \n    margin:0 -1px 0.16em 0;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav .selected { \n    margin:0 0 0.16em -1px;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a {\n    border-width:1px 0;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a em,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-left .yui-nav a em,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a em {\n    border-width:0 0 0 1px;\n    padding:0.2em .75em;\n    top:auto;\n    left:-1px; /* for 1px rounded corners */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a em {\n    border-width:0 1px 0 0;\n    left:auto;\n    right:-1px; /* for 1px rounded corners */\n}\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a,\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav .selected a,\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a:hover,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav .selected a,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a:hover,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav a,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav .selected a,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav a:hover {\n    background-image:none; /* no left-right or bottom-top gradient */\n}\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-content {\n    border:1px solid #d8dee8; /* content border */\n}\n/* bottom orientation */\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav {\n    border-width:5px 0 0; /* color between tab list and content */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav .selected,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav .selected { \n    margin:-1px 0.3em 0 0; /* for overlap */\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav li { \n    padding:0 0 1px 0; /* gecko: make room for overflow */\n    vertical-align:top;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li a,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav li a { \n}\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav a em,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav a em {\n    border-width:0 0 1px;\n    top:auto;\n    bottom:-1px; /* for 1px rounded corners */\n}\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-content,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-content {\n    border:1px solid #f2f5fa; /* content border */\n}\n.WGsubContent .yui-skin-sam {\n	background-color: #d8dee8;\n	padding: 10px 5 5 5px;\n	display:block;\n}\n\n/* yui tab placement settings below */\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav li,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-top .yui-nav li {\n    margin:0 0.3em 0 0; /* space between tabs */\n    padding:5px 0 0; /* gecko: make room for overflow */\n    zoom:1;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-top .yui-nav .selected { \n    margin:0 0.3em -1px 0; /* for overlap */\n}\n\n.WGsubContent .yui-navset .yui-nav li,.yui-navset .yui-navset-top .yui-nav li,\n.WGsubContent .yui-navset .yui-navset-bottom .yui-nav li {\n	margin:0 0.5em 0 0;\n}\n.WGsubContent .yui-navset-left .yui-nav li,.yui-navset-right .yui-nav li {\n	margin:0 0 0.5em;\n}\n.WGsubContent .yui-navset .yui-content .yui-hidden {\n	display:none;\n}\n.WGsubContent .yui-navset .yui-navset-left .yui-nav,.yui-navset .yui-navset-right .yui-nav,\n.WGsubContent .yui-navset-left .yui-nav,.yui-navset-right .yui-nav {\n	width:6em;\n}\n.WGsubContent .yui-navset-top .yui-nav,.yui-navset-bottom .yui-nav {\n	width:auto;\n}\n.WGsubContent .yui-navset .yui-navset-left,.yui-navset-left {\n	padding:0 0 0 6em;\n}\n.WGsubContent .yui-navset-right {\n	padding:0 6em 0 0;\n}\n.WGsubContent .yui-navset-top,.yui-navset-bottom {\n	padding:auto;\n}\n.WGsubContent .yui-nav,.yui-nav li {\n	list-style:none;\n	margin:0;\n	padding:0;	\n}\n.WGsubContent .yui-navset li em {\n	font-style:normal;\n}\n.WGsubContent .yui-navset {\n	position:relative;\n	zoom:1;\n}\n.WGsubContent .yui-navset .yui-content {\n	zoom:1;\n}\n.WGsubContent .yui-navset .yui-nav li,.yui-navset .yui-navset-top .yui-nav li,\n.WGsubContent .yui-navset .yui-navset-bottom .yui-nav li {\n	display:inline-block;\n	display:-moz-inline-stack;\n	*display:inline;\n	vertical-align:bottom;\n	cursor:pointer;\n	zoom:1;\n}\n.WGsubContent .yui-navset-left .yui-nav li,.yui-navset-right .yui-nav li {\n	display:block;\n}\n.WGsubContent .yui-navset .yui-nav a {\n	position:relative;\n}\n.WGsubContent .yui-navset .yui-nav li a,.yui-navset-top .yui-nav li a,\n.WGsubContent .yui-navset-bottom .yui-nav li a {\n	display:block;\n	display:inline-block;\n	vertical-align:bottom;\n	zoom:1;\n}\n.WGsubContent .yui-navset-left .yui-nav li a,.yui-navset-right .yui-nav li a {\n	display:block;\n}\n.WGsubContent .yui-navset-bottom .yui-nav li a {\n	vertical-align:text-top;\n}\n.WGsubContent .yui-navset .yui-nav li a em,.yui-navset-top .yui-nav li a em,\n.WGsubContent .yui-navset-bottom .yui-nav li a em {\n	display:block;\n}\n.WGsubContent .yui-navset .yui-navset-left .yui-nav,.yui-navset .yui-navset-right .yui-nav,\n.WGsubContent .yui-navset-left .yui-nav,.yui-navset-right .yui-nav {\n	position:absolute;\n	z-index:1;\n}\n.WGsubContent .yui-navset-top .yui-nav,.yui-navset-bottom .yui-nav {\n	position:static;\n}\n.WGsubContent .yui-navset .yui-navset-left .yui-nav,.yui-navset-left .yui-nav {\n	left:0;\n	right:auto;\n}\n.WGsubContent .yui-navset .yui-navset-right .yui-nav,.yui-navset-right .yui-nav {\n	left:auto;\n	right:0;\n}\n.WGsubContent .yui-skin-sam .yui-navset .yui-nav .selected a em {\n	padding:0.35em 0.75em;\n}\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav,\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-right .yui-nav,.yui-skin-sam .yui-navset-right .yui-nav {\n	border-width:0 5px 0 0;\n	bottom:0;\n	top:0;\n	Xposition:absolute;\n}\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-right .yui-nav,.yui-skin-sam .yui-navset-right .yui-nav {\n	border-width:0 0 0 5px;\n}\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav li,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav li,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav li {\n	margin:0 0 0.16em;\n	padding:0 0 0 1px;\n}\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav li {\n	padding:0 1px 0 0;\n}\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a,.yui-skin-sam .yui-navset-right .yui-nav a {\n	border-width:1px 0;\n}\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a em,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav a em,.yui-skin-sam .yui-navset-right .yui-nav a em {\n	border-width:0 0 0 1px;\n	left:-1px;\n	padding:0.2em .75em;\n	top:auto;\n}\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a em {\n	border-width:0 1px 0 0;\n	left:auto;\n	right:-1px;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset-left .yui-nav a,.yui-skin-sam .yui-navset-left .yui-nav .selected a,.yui-skin-sam .yui-navset-left .yui-nav a:hover,\n.WGsubContent .yui-skin-sam .yui-navset-right .yui-nav a,.yui-skin-sam .yui-navset-right .yui-nav .selected a,.yui-skin-sam .yui-navset-right .yui-nav a:hover,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav a,.yui-skin-sam .yui-navset-bottom .yui-nav .selected a,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav a:hover {\n	background-image:none;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav .selected,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav .selected {\n	margin:-1px 0.16em 0 0;\n}\n\n.WGsubContent .yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li,\n.WGsubContent .yui-skin-sam .yui-navset-bottom .yui-nav li {\n	padding:0 0 1px 0;\n	vertical-align:top;\n}\n',0,'text/css',1255485472,3600,'body{margin:0;padding:0;font:11px Verdana;}a{cursor:pointer;}button{cursor:pointer;}img{border:none;}.WGbutton{float:right;padding-right:10px;}.centered{text-align:center;}.WGaccount_message{background-color:white;border:solid #BECEF8 1px;height:300px;margin-bottom:10px;margin-left:60px;margin-top:20px;overflow:-moz-scrollbars-vertical;overflow-x:hidden;overflow-y:scroll;padding:10px;text-align:left;vertical-align:top;width:90%;}.WGprofileMember{font-size:9px;margin-right:20px;text-align:right;}.WGmember{color:#3e4f77;font:9px Verdana,Arial,Helvetica,sans-serif;text-align:center;}.WGphotostyle{border:solid #3e4f77 2px;margin-bottom:5px;\n	margin-top:5px}#rightalign{float:right;}.WGbordered{border-bottom:dashed #BECEF8 2px;padding-bottom:10px;}.WGfriendpic{border:solid #BECEF8 1px;}.WGinvitemsg{width:600px;height:150px;}ol.WGProfile_interests{color:#0B2259;font-size:15px;font-weight:bold;list-style-type:none;margin:0px;padding:0px;padding:5px 5px;}ol.WGProfile_interests li{margin-bottom:15px;}ol.WGProfile_interests span{font-size:12px;font-weight:normal;color:black;}.WGpBio{border-bottom:solid #DDE6FB 1px;margin:0px;margin-bottom:5px;padding-bottom:5px;}.WGpBio div{background-color:#DDE6FB;padding:2px 5px;margin-bottom:2px;}.WGprogram{font-size:9px;}.WGContribCount{font-size:12px;text-align:left;\n	padding:3px}.WGContribTitle{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#0B2259;font-size:12px;font-weight:bold;min-height:25px;padding:3px;text-align:center;text-decoration:underline;}.WGContribTitleLeft{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#0B2259;font-size:12px;font-weight:bold;min-height:25px;padding:3px;text-align:center;text-decoration:underline;}.WGContribEntry{text-align:center;padding:3px;}.WGContribEntryLeft{text-align:left;padding:3px;}.WGeditBox{border:solid #8DABF1 2px;display:block;font-family:verdana;font-size:9px;font-weight:bold;left:100px;-moz-box-sizing:border-box;padding:5px;position:absolute;top:100px;width:590px;z-index:100;}.WGeditBox input,.WGeditBox select{font-size:9px;}.WGfriends_name{font-weight:bold;width:90%;}.WGfriends_photo{font-weight:bold;width:10%;}.WGfriends_photo img{height:50px;width:50px;}.WGfriends_private{float:right;padding-bottom:5px;width:50%;}.WGfriends_ninety{vertical-align:top;width:90%;}.WGfriends_seventy{vertical-align:top;width:70%;}.WGfriends_ten{width:10%;}.WGfriends_ten img{height:50px;width:50px;}.WGfriends_twenty{width:20%;}.WGaccepts{padding-bottom:5px;}.WGProfile_msgcontainer{padding:2px;}.WGinbox_count{font-size:12px;font-weight:bold;padding:3px;text-align:left;}.WGinbox_errors{font-weight:bold;color:red;text-align:center;}.WG_inbox_InviteLabel{width:50px;text-align:right;}.WG_inbox_InviteLabelView{font-weight:bold;width:120px;}.WGmsgcontainer{padding:6px;display:block;margin-bottom:6px;}.WGdatacells{border-bottom:dashed #BECEF8 1px;}.WGinbox_contactsTbl{background-color:#EEF2FD;font-family:arial;font-size:9pt;width:100%;}#contacts{height:275px;overflow:auto;}.WGbuttons_left{float:left;}.WGbuttons_right{float:right;}.WGinbox_from{color:black;font-weight:normal;text-decoration:none;}.WGinbox_subject{width:530px;}.WGinbox_messageTo{background-color:white;border:solid #BECEF8 1px;height:50px;overflow:-moz-scrollbars-vertical;overflow-x:hidden;overflow-y:scroll;width:530px;}.WGinbox_buttons{display:inline;float:left;font-size:10px;text-align:left;width:70%;}.WGinbox_pagination{display:inline;text-align:right;width:20%;}.WGinbox_messagerpp{font-size:10px;display:inline;text-align:right;width:20%;}.WGmessage{display:inline;float:left;font-size:10px;text-align:left;width:70%;}.WGmessagerpp{font-size:10px;display:inline;text-align:right;float:right;}.WG-previous-next{float:right;}.WGevenThread{background-color:#e1e8fb;border-bottom:1px solid #bfcef9;padding:8px;text-align:center;}.WGoddThread{background-color:#eef2fd;border-bottom:1px solid #bfcef9;padding:8px;text-align:center;}.WGProfile_pagination{font-size:10px;text-align:right;width:20%;}.WGProfile_messagerpp{font-size:10px;display:inline;text-align:right;width:20%;}.WGProfile_paginationLeft{font-size:10px;text-align:left;width:20%;}.WGProfile_paginationCenter{font-size:10px;text-align:center;width:20%;}.WGProfile_pagination a{background-color:#f2f5fa;border:solid #bfc8dc 1px;font-size:10px;font-weight:bold;padding:1px 5px;text-decoration:none;}.WGProfile_pagination a:hover{background-color:#d8dee8;color:white;}.WGProfile_pagination .prevNext{background-color:transparent;border:none;color:black;}.WGProfile_pagination .prevNext:hover{background-color:transparent;border:none;color:black;}.WGProfile_pagination .active{background-color:#d8dee8;border:solid #bfc8dc 1px;color:white;font-size:10px;font-weight:bold;padding:1px 5px;text-decoration:none;}.WGProfile_pagination img{vertical-align:middle;margin-top:2px;border:none;}.WGProfile_registration{background:none;border:none;font-size:9pt;font-family:arial;margin:0;padding:0;width:100%;}.WGProfile_registration .header{background-color:#818997;color:#3e4f77;font-size:10px;font-weight:bold;text-align:left;}.WGProfile_registration .header a{color:white;text-decoration:none;}.WGProfile_registration .help a{font-weight:bold;text-decoration:none;}.WGProfile_registration .inputText{font-size:10px;margin-right:1px;}.WGProfile_registration .label{font-size:9pt;font-weight:bold;text-align:right;white-space:nowrap;width:1%;}.WGProfile_registration .labelLeft{font-size:9pt;font-weight:bold;white-space:nowrap;width:1%;text-align:left;vertical-align:top;}.WGProfile_registration .smallLabel{font-size:8px;text-align:center;}.WGProfile_registration .smallText{font-size:9px;}.WGinboxTbl{display:block;margin:4px;padding:2px;}.WGProfile_registration .bar,.WGProfile_registration .barRight{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#3e4f77;font-size:14px;font-weight:bold;margin:10px 0px 10px 0px;min-height:25px;padding:4px 4px 0px 4px;vertical-align:middle;}.WGProfile_registration .bar{text-align:center;}.WGProfile_registration .barRight{text-align:right;}.WGProfile_registration .bar a{color:#0B2259;font-size:10px;font-weight:bold;}.WGProfile_registration .barFive{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#3e4f77;font-size:14px;font-weight:bold;text-align:center;margin-right:3px;min-height:25px;padding:2px;width:4.3%;}.WGProfile_registration .barTen{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#3e4f77;font-size:14px;font-weight:bold;min-height:25px;padding:2px;text-align:center;width:7.2%;}.WGProfile_registration .barFifteen{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#3e4f77;font-size:14px;font-weight:bold;margin-right:3px;min-height:25px;padding:2px;text-align:center;width:15%;}.WGProfile_registration .barFifty{background-color:#f2f5fa;border:solid #d8dee8 1px;color:#3e4f77;font-size:14px;font-weight:bold;margin-right:3px;min-height:25px;padding:2px;text-align:center;width:50%;}.WGbarContainer{display:block;margin:10px 0px 10px 0px;width:100%;}.WGfields{padding:2px;}.WGfields_left{padding:2px;vertical-align:top;width:15%;}.WGfields_right{display:inline float:right;padding:2px;text-align:right;width:80%;vertical-align:top;}.WGProfile{display:table;margin:0;padding:0;width:100%;}.WGProfileFields{border:0;padding:0;margin:0;width:100%;}.WGProfileFields ol{display:inline;list-style-type:none;}.WGProfileFields ul{list-style-type:none;display:inline;}.WGProfileFields ul li{display:inline-block;*display:inline;zoom:1;}.WGProfile_accepts{text-align:right;background-color:gray;padding:4px;width:100%;}.WGviewContainer{margin:0;padding:0;width:90%;}.WGinternational{background-color:red;color:white;display:inline;font-weight:bold;padding:4px;text-align:center;}.WGcategoryLabel{vertical-align:top;width:90%;}.WGprivateMessage{background-color:gray;padding:4px;text-align:right;}.WGprofileAlert{background-color:red;color:white;font-weight:bold;padding:4px;text-align:center;width:100%;}WGprofilePhoto{vertical-align:top;}#WGprofileErrors{background-color:#ff0000;color:#ffffff;font-weight:bold;text-align:center;}.WGprofilefield_required_off{}.WGprofilefield_required{background-color:#ffd6bb;}.WGprofilefield_error{background-color:#FF9494;}.WGerrorMsg{font-weight:bold;color:red;text-align:center;}.WGuserInvite_subject{background-color:white;border:solid #BECEF8 1px;height:25px;text-align:left;width:500px;}.WGprofile_canEdit{text-align:center;background-color:red;padding:4px;color:white;font-weight:bold;}.WGprofile_fieldLabel{background:#DDE6FB;padding:2px;width:200px;}.WGprofile_fieldData{margin-left:5px;}.WGprofile_fieldStatus{padding:4px;color:white;\n	font-weight:bold}.WGbottombutton{float:right;padding-right:2px;padding-top:2px;position:relative;}.WGcontent{padding:10px;}.WGcleartab{clear:both;height:0;}.WGsubContent{border:solid #d8dee8 6px;}.WGtopbutton{float:right;clear:both;padding-right:2px;padding-top:2px;position:relative;}ul.WGtopTabs,ul.WGtopTabs li{list-style-type:none;margin:10px 0px 0px 0px;padding:0px;position:relative;width:auto;Xposition:relative;zoom:1;}ul.WGtopTabs li{display:block;float:left;margin-right:3px;}ul.WGtopTabs li b{background-color:#eef2fd;border-top:solid #d8dee8 1px;display:block;padding:4px 8px;position:relative;top:-1px;}ul.WGtopTabs a{display:block;color:#9ea0bb;font-size:12px;font-family:Arial,Helvetica,sans-serif;text-decoration:none;background-color:#f2f5fa;border-left:solid #d8dee8 1px;border-right:solid #d8dee8 1px;}ul.WGtopTabs a:hover,ul.WGtopTabs a:hover b,ul.WGtopTabs a.selected,ul.WGtopTabs a.selected b{background-color:#d8dee8;color:#3e4f77;}.WGcleardiv{clear:both;margin:0px 0px 0px 0px;padding:0px;}.WGview{border:none;font:bold 10px Verdana;color:#3e4f77;text-decoration:none;position:absolute;right:4px;top:4px;}.WGprofile_displayView{-x-system-font:none;border:medium none;color:#0B2258;display:inline;float:right;font-family:Verdana;font-size:10px;font-size-adjust:none;font-stretch:normal;font-style:normal;font-variant:normal;font-weight:bold;line-height:normal;padding-right:8px;padding-top:3px;text-decoration:none;}.WGprofile_displaySubContent{border:solid #d8dee8 6px;border-top:solid #d8dee8 18px;}.yui-skin-sam .yui-navset .yui-nav,.yui-skin-sam .yui-navset .yui-navset-top .yui-nav{border:solid #eef2fd;border-width:0 0 5px;Xposition:relative;zoom:1;}.yui-skin-sam .yui-navset .yui-nav a,.yui-skin-sam .yui-navset .yui-navset-top .yui-nav a{background:#ffffff;border:solid #ffffff;border-width:0 1px;color:#bfccdd;position:relative;text-decoration:none;font-size:12px;font-family:Arial,Helvetica,sans-serif;font-weight:bold;}.yui-skin-sam .yui-navset .yui-nav a em,.yui-skin-sam .yui-navset .yui-navset-top .yui-nav a em{border:solid #eef2fd;border-width:1px 0 0;cursor:hand;padding:0.25em .75em;left:0;right:0;bottom:0;top:-1px;position:relative;}.yui-skin-sam .yui-navset .yui-nav .selected a,.yui-skin-sam .yui-navset .yui-nav .selected a:focus,.yui-skin-sam .yui-navset .yui-nav .selected a:hover{background:#eef2fd;color:#3e4f77;font-size:12px;font-family:Arial,Helvetica,sans-serif;text-decoration:none;font-weight:bold;}.yui-skin-sam .yui-navset .yui-nav .selected a,.yui-skin-sam .yui-navset .yui-nav .selected a em{border-color:#eef2fd;}.yui-skin-sam .yui-navset .yui-nav a:hover,.yui-skin-sam .yui-navset .yui-nav a:focus{background:#eef2fd;color:#3e4f77;outline:0;font-size:12px;font-family:Arial,Helvetica,sans-serif;text-decoration:none;font-weight:bold;}.yui-skin-sam .yui-navset .yui-content{background:#eef2fd;}.yui-skin-sam .yui-navset .yui-content,.yui-skin-sam .yui-navset .yui-navset-top .yui-content{border:5px solid #eef2fd;padding:0.75em 1em;}.yui-skin-sam .yui-navset-left .yui-nav,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav,.yui-skin-sam .yui-navset .yui-navset-right .yui-nav,.yui-skin-sam .yui-navset-right .yui-nav{border-width:0 5px 0 0;Xposition:absolute;top:0;bottom:0;}.yui-skin-sam .yui-navset .yui-navset-right .yui-nav,.yui-skin-sam .yui-navset-right .yui-nav{border-width:0 0 0 5px;}.yui-skin-sam .yui-navset-left .yui-nav li,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav li,.yui-skin-sam .yui-navset-right .yui-nav li{margin:0 0 0.3em;padding:0 0 0 1px;}.yui-skin-sam .yui-navset-right .yui-nav li{padding:0 1px 0 0;}.yui-skin-sam .yui-navset-left .yui-nav .selected,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav .selected{margin:0 -1px 0.16em 0;}.yui-skin-sam .yui-navset-right .yui-nav .selected{margin:0 0 0.16em -1px;}.yui-skin-sam .yui-navset-left .yui-nav a,.yui-skin-sam .yui-navset-right .yui-nav a{border-width:1px 0;}.yui-skin-sam .yui-navset-left .yui-nav a em,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav a em,.yui-skin-sam .yui-navset-right .yui-nav a em{border-width:0 0 0 1px;padding:0.2em .75em;top:auto;left:-1px;}.yui-skin-sam .yui-navset-right .yui-nav a em{border-width:0 1px 0 0;left:auto;right:-1px;}.yui-skin-sam .yui-navset-left .yui-nav a,.yui-skin-sam .yui-navset-left .yui-nav .selected a,.yui-skin-sam .yui-navset-left .yui-nav a:hover,.yui-skin-sam .yui-navset-right .yui-nav a,.yui-skin-sam .yui-navset-right .yui-nav .selected a,.yui-skin-sam .yui-navset-right .yui-nav a:hover,.yui-skin-sam .yui-navset-bottom .yui-nav a,.yui-skin-sam .yui-navset-bottom .yui-nav .selected a,.yui-skin-sam .yui-navset-bottom .yui-nav a:hover{background-image:none;}.yui-skin-sam .yui-navset-left .yui-content{border:1px solid #d8dee8;}.yui-skin-sam .yui-navset-bottom .yui-nav,.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav{border-width:5px 0 0;}.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav .selected,.yui-skin-sam .yui-navset-bottom .yui-nav .selected{margin:-1px 0.3em 0 0;}.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li,.yui-skin-sam .yui-navset-bottom .yui-nav li{padding:0 0 1px 0;vertical-align:top;}.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li a,.yui-skin-sam .yui-navset-bottom .yui-nav li a{}.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav a em,.yui-skin-sam .yui-navset-bottom .yui-nav a em{border-width:0 0 1px;top:auto;bottom:-1px;}.yui-skin-sam .yui-navset-bottom .yui-content,.yui-skin-sam .yui-navset .yui-navset-bottom .yui-content{border:1px solid #f2f5fa;}.yui-skin-sam{background-color:#d8dee8;padding:10px 5 5 5px;display:block;}.yui-skin-sam .yui-navset .yui-nav li,.yui-skin-sam .yui-navset .yui-navset-top .yui-nav li{margin:0 0.3em 0 0;padding:5px 0 0;zoom:1;}.yui-skin-sam .yui-navset .yui-nav .selected,.yui-skin-sam .yui-navset .yui-navset-top .yui-nav .selected{margin:0 0.3em -1px 0;}.yui-navset .yui-nav li,.yui-navset .yui-navset-top .yui-nav li,.yui-navset .yui-navset-bottom .yui-nav li{margin:0 0.5em 0 0;}.yui-navset-left .yui-nav li,.yui-navset-right .yui-nav li{margin:0 0 