// Removes a substring from a string
function webdeveloper_removeSubstring(string, substring)
{
    // If the strings are not empty
    if(string && substring)
    {
        var substringStart = string.indexOf(substring);

        // If the substring is found in the string
        if(substring && substringStart != -1)
        {
            return string.substring(0, substringStart) + string.substring(substringStart + substring.length, string.length);
        }

        return string;
    }

    return "";
}

// Tests if a string ends with the given string
String.prototype.endsWith = function(endsWithString)
{
	return (this.substr(this.length - endsWithString.length) == endsWithString);
}

// Trims leading and trailing spaces from a string
String.prototype.trim = function()
{
    return this.replace(new RegExp("^\\s+|\\s+$", "gi"), "");
}
