// Open a dialog to choose an application
function webdeveloper_chooseApplication()
{
    var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);

    filePicker.init(window, document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_chooseApplication"), filePicker.modeOpen);

    // If the user selected an application
    if(filePicker.show() == filePicker.returnOK)
    {
        document.getElementById("webdeveloper.view.source.with.path").value = filePicker.file.path;
    }
}

// Clears the view source with option
function webdeveloper_clearViewSourceWith()
{
    window.opener.webdeveloper_viewSourceWithDescription = null;
    window.opener.webdeveloper_viewSourceWithKey         = null;
    window.opener.webdeveloper_viewSourceWithPath        = null;
}

// Initializes the view source with dialog box
function webdeveloper_initializeViewSourceWith()
{
    var modifiers    = null;
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If running on a Mac
    if(webdeveloper_isMac())
    {
        modifiers = stringBundle.getString("webdeveloper_keyboardShortcutModifiersMac");
    }
    else
    {
        modifiers = stringBundle.getString("webdeveloper_keyboardShortcutModifiers");
    }

    document.getElementById("webdeveloper-keyboard-shortcut-modifiers").value = modifiers;

    // If the first argument equals add
    if(window.arguments[0] == "add")
    {
        document.title = stringBundle.getString("webdeveloper_addViewSourceWith");
    }
    else
    {
        document.title = stringBundle.getString("webdeveloper_editViewSourceWith");

        document.getElementById("webdeveloper.view.source.with.description").value = window.arguments[1];
        document.getElementById("webdeveloper.view.source.with.path").value        = window.arguments[2];
        document.getElementById("webdeveloper.view.source.with.key").value         = window.arguments[3];
    }
}

// Saves the view source with option
function webdeveloper_saveViewSourceWith()
{
    var description  = document.getElementById("webdeveloper.view.source.with.description").value.trim();
    var errors       = "";
    var key          = document.getElementById("webdeveloper.view.source.with.key").value.trim();
    var path         = document.getElementById("webdeveloper.view.source.with.path").value.trim();
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the description is empty
    if(!description)
    {
        errors += stringBundle.getString("webdeveloper_emptyDescription") + "\n";
    }

    // If the path is empty
    if(!path)
    {
        errors += stringBundle.getString("webdeveloper_emptyPath") + "\n";
    }

    // If there are errors
    if(errors)
    {
        webdeveloper_error(errors.trim());

        return false;
    }
    else
    {
        window.opener.webdeveloper_viewSourceWithDescription = description;
        window.opener.webdeveloper_viewSourceWithKey         = key;
        window.opener.webdeveloper_viewSourceWithPath        = path;

        return true;
    }
}
