// Toggles the cache
function webdeveloper_toggleCache(element)
{
    webdeveloper_disablePreference(element, "browser.cache.disk.enable");
    webdeveloper_disablePreference(element, "browser.cache.memory.enable");
}

// Toggles Java
function webdeveloper_toggleJava(element)
{
    webdeveloper_disablePreference(element, "security.enable_java");
}

// Toggle JavaScript
function webdeveloper_toggleJavaScript(element)
{
    var javaScriptButton = document.getElementById("webdeveloper-javascript-statusbar");

    webdeveloper_disablePreference(element, "javascript.enabled");

    // If the JavaScript button exists
    if(javaScriptButton)
    {
        // If disabling JavaScript
        if(element.getAttribute("checked"))
        {
            javaScriptButton.setAttribute("class", "disabled");
            javaScriptButton.setAttribute("tooltiptext", document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_javaScriptDisabledTooltip"));
        }
        else
        {
            // If the JavaScript button has a class attribute
            if(javaScriptButton.hasAttribute("class"))
            {
                javaScriptButton.removeAttribute("class");
            }

            // If the JavaScript button has a tooltip text attribute
            if(javaScriptButton.hasAttribute("tooltiptext"))
            {
                javaScriptButton.removeAttribute("tooltiptext");
            }
        }
    }
}

// Toggles meta redirects
function webdeveloper_toggleMetaRedirects(element)
{
    var allowMetaRedirects = true;
    var browsers           = getBrowser().browsers;
    var browserLength      = browsers.length;

    // If the element is checked
    if(element.getAttribute("checked"))
    {
        allowMetaRedirects = false;
    }

    // Loop through the browsers
    for(var i = 0; i < browserLength; i++)
    {
        browsers[i].docShell.allowMetaRedirects = allowMetaRedirects;
    }

    webdeveloper_enablePreference(element, "webdeveloper.meta.redirects.disable");
}

// Toggles the minimum font size
function webdeveloper_toggleMinimumFontSize(element)
{
    var defaultFontSize = 10;
    var minimumFontSize = null;

    // If disabling the minimum font size
    if(element.getAttribute("checked"))
    {
        minimumFontSize = webdeveloper_getIntegerPreference("font.minimum-size.x-western", true);

        // If the minimum font size is not set
        if(minimumFontSize == 0)
        {
            minimumFontSize = defaultFontSize;
        }

        webdeveloper_deletePreference("font.minimum-size.x-western");
        webdeveloper_setIntegerPreference("webdeveloper.font.minimum.size", minimumFontSize);
    }
    else
    {
        minimumFontSize = webdeveloper_getIntegerPreference("webdeveloper.font.minimum.size", true);

        // If the minimum font size is not set
        if(minimumFontSize == 0)
        {
            minimumFontSize = defaultFontSize;
        }

        webdeveloper_deletePreference("webdeveloper.font.minimum.size");
        webdeveloper_setIntegerPreference("font.minimum-size.x-western", minimumFontSize);
    }

    BrowserReload();
}

// Toggles the page colors
function webdeveloper_togglePageColors(element)
{
    webdeveloper_disablePreference(element, "browser.display.use_document_colors");
    BrowserReload();
}

// Toggles the proxy settings
function webdeveloper_toggleProxy(element)
{
    // If disabling the proxy
    if(element.getAttribute("checked"))
    {
        webdeveloper_setIntegerPreference("webdeveloper.proxy.type", webdeveloper_getIntegerPreference("network.proxy.type", true));
        webdeveloper_deletePreference("network.proxy.type");
    }
    else
    {
        webdeveloper_setIntegerPreference("network.proxy.type", webdeveloper_getIntegerPreference("webdeveloper.proxy.type", true));
        webdeveloper_deletePreference("webdeveloper.proxy.type");
    }
}

// Toggles referrers
function webdeveloper_toggleReferrers(element)
{
    var sendReferrer = 2;

    // If disabling referrers
    if(element.getAttribute("checked"))
    {
        sendReferrer = 0;
    }

    webdeveloper_setIntegerPreference("network.http.sendRefererHeader", sendReferrer);
}

// Updates the disable menu
function webdeveloper_updateDisableMenu(suffix)
{
    var checked = !webdeveloper_getBooleanPreference("browser.cache.disk.enable", false) && !webdeveloper_getBooleanPreference("browser.cache.memory.enable", false);
    var menu    = document.getElementById("webdeveloper-disable-proxy-" + suffix);

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-cache-" + suffix), "checked", checked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-java-" + suffix), "checked", !webdeveloper_getBooleanPreference("security.enable_java", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-javascript-" + suffix), "checked", !webdeveloper_getBooleanPreference("javascript.enabled", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-meta-redirects-" + suffix), "checked", webdeveloper_getBooleanPreference("webdeveloper.meta.redirects.disable", true));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-minimum-font-size-" + suffix), "checked", webdeveloper_getIntegerPreference("font.minimum-size.x-western", true) == 0);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-page-colors-" + suffix), "checked", !webdeveloper_getBooleanPreference("browser.display.use_document_colors", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-popup-blocker-" + suffix), "checked", !webdeveloper_getBooleanPreference("dom.disable_open_during_load", false));

    // If the menu is set
    if(menu)
    {
        var proxyConfigured = webdeveloper_isPreferenceSet("network.proxy.type");
        var proxyDisabled   = webdeveloper_isPreferenceSet("webdeveloper.proxy.type");

        webdeveloper_configureElement(menu, "checked", !proxyConfigured && proxyDisabled);
        webdeveloper_configureElement(menu, "disabled", !proxyConfigured && !proxyDisabled);
    }

    // If the referrer preference is set to 0
    if(webdeveloper_getIntegerPreference("network.http.sendRefererHeader", false) == 0)
    {
        checked = true;
    }
    else
    {
        checked = false;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-referrers-" + suffix), "checked", checked);
}

// Updates the disable JavaScript menu
function webdeveloper_updateDisableJavaScriptMenu(suffix)
{
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-all-javascript-" + suffix), "checked", !webdeveloper_getBooleanPreference("javascript.enabled", false));
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-strict-javascript-warnings-" + suffix), "checked", !webdeveloper_getBooleanPreference("javascript.options.strict", false));
}
