import pwd
import os
import logging

import constants
import gtk
from gettext import gettext as _

def show_about_dialog():
    "Show an about dialog"
    icons = gtk.icon_theme_get_default()
    logo_pixbuf = icons.load_icon("gtk-paste", 32, 0)

    about = gtk.AboutDialog()
    about.set_name(constants.title)
    about.set_version(constants.version)
    about.set_license(constants.license)
    about.set_comments(_("Publish text notes and source code on a"\
                        " pastebin server for collaborative debugging"))
    about.set_authors(constants.authors)
    about.set_documenters(constants.documenters)
    about.set_translator_credits(_("translator_credits"))
    about.set_website(constants.website)
    about.set_logo(logo_pixbuf)

    about.run()
    about.hide()

def guess_user():
    "Guest the user name"
    full = pwd.getpwuid(os.getuid())[4].split(",")[0]
    if len(full) > 0:
        return full
    else:
        return pwd.getpwuid(os.getuid())[0]

def find_glade_file(glade):
    if os.path.isfile(os.path.join("data/", glade)):
        logging.debug("Using glade dev file data/%s" % (glade))
        return os.path.join("data/", glade)
    else:
        return os.path.join(constants.data_dir, glade)

def open_url(url):
        "Open a url in a browser"

        screen = gtk.gdk.screen_get_default()
        timestamp = gtk.get_current_event_time()
        gtk.show_uri(screen, url, timestamp)

def uri_from_dnd(data):
    """Convert a text/uri-list given to us by drag
    and drop to a list of uri"""
    uris = data.strip()
    uris = uris.split()
    return [uri.strip('\r\n\x00') for uri in uris]

import xmlrpclib
def send(post, language, pastebin, user):
    """ Send @post to @pastebin"""
    ret = False

    if not (pastebin[:7] == 'http://'):
        pastebin = 'http://' + pastebin
    
    rpcpath = '/server.pl' #FIXME Should be configurable
    server = xmlrpclib.Server(pastebin + rpcpath)
    
    # paste.debian.net limit name to 10 chars
    user = user[:10]
    logging.debug(user)

    try:
        #Handle error better
        rep = server.paste.addPaste(post, user, '', language)
        if rep['rc'] != 0 :
            logging.critical('An error occured : %s ' % (rep['statusmessage']))
            ret = False
        else:
            #Some how display this message to the user
            logging.info(rep['statusmessage'])
            logging.info('Code pasted at %s/%i' % (pastebin, rep['id']))
            ret =  str(rep['id'])
    except xmlrpclib.ProtocolError, err:
        logging.critical("A protocol error occurred")
        logging.critical("URL: %s" % err.url)
        logging.critical("HTTP/HTTPS headers: %s" % err.headers)
        logging.critical("Error code: %d" % err.errcode)
        logging.critical("Error message: %s" % err.errmsg)
        logging.exception(err)
        ret = False
    except Exception, err:
        logging.exception(err)
        ret = False
    return ret

