# wbhistory.py
# Manage the histroy of previous posts

import gtk
import gconf
import time
import datetime
import gettext
from gettext import gettext as _
gettext.bindtextdomain('webboard')
gettext.textdomain('webboard')
gtk.glade.bindtextdomain('webboard')
gtk.glade.textdomain('webboard')

class WebBoardHistory:
        def __init__(self, config, notify_func=None):
            self.config = config
            self.notify_func = notify_func
            self.config.gconf.notify_add("/apps/webboard/history", self.notify)
            self.update()

        def add(self, stamp_new, title_new, url_new):
            # do not cache more than five sites
            while len(self.sites) >= 5:
                self.sites.pop()
            # convert the nested history list to flat one
            # gconf doesn't only support flat lists
            _flat_list=[]
            _flat_list.extend((str(stamp_new), title_new, url_new))
            if len(self.sites) > 0:
                for id_old, stamp_old, title_old, url_old in self.sites:
                    _flat_list.extend((str(stamp_old),title_old, url_old))
            self.config.gconf.set_list("/apps/webboard/history", \
                                gconf.VALUE_STRING, _flat_list)

        def notify(self, client, cnxn_id, entry, user_data):
            # update the history
            self.update()
            # send the nofication signal to the childrens
            if self.notify_func is not None:
                 self.notify_func()

        def update(self):
            # read the history from gconf
            _flat_list = self.config.gconf.get_list("/apps/webboard/history", \
                                            gconf.VALUE_STRING)
            # convert the flat list into a nested one
            # e.g. [(stamp, title, url), (stamp2, title2, url2)]
            self.sites=[]
            try:
                if len(_flat_list) > 0:
                    while len(_flat_list) != 0:
                        stamp = float(_flat_list.pop(0))
                        title = _flat_list.pop(0)
                        url = _flat_list.pop(0)
                        id = len(self.sites)
                        self.sites.append((id, stamp, title, url))
            except:
                print "Failed to read the history from gconf - reseting"
                self.config.gconf.unset("/apps/webboard/history")

        def age(self, id):
            now = datetime.datetime.now()
            sent = datetime.datetime.fromtimestamp(float(self.sites[int(id)][1]))

            diff = now -sent
            weeks, days = divmod(diff.days, 7)
            minutes, seconds = divmod(diff.seconds, 60)
            hours, minutes = divmod(minutes, 60)

            if weeks > 0:
                ret = gettext.ngettext("%s week ago", "%s weeks ago", \
                                       weeks) % weeks
            elif days > 0:
                ret = gettext.ngettext("%s day ago", "%s days ago", 
                                       days) % days
            elif hours > 0:
                ret = gettext.ngettext("%s hour ago", "%s hours ago", \
                                       hours) % hours
            elif minutes > 0:
                ret = gettext.ngettext("%s minute ago", \
                                       "%s minutes ago", minutes) % minutes
            elif seconds > 0:
                ret = gettext.ngettext("%s second ago", "%s seconds ago",
                                       seconds) % seconds
            return ret

