(function() {

const {classes: Cc, interfaces: Ci, utils: Cu, results: Cr} = Components;
const kObserverTopic = "webapps-login";

Cu.import("resource://gre/modules/Services.jsm");

function collectCookies(msg) {
    var cookies = Services.cookies.getCookiesFromHost(msg.domain);
    dump("Collecting cookies\n");
    var cookieDict = {}
    while (cookies.hasMoreElements()){
        var cookie = cookies.getNext().QueryInterface(Ci.nsICookie);
        var hostCookies = ""
        if (cookie.host in cookieDict) {
            hostCookies = cookieDict[cookie.host];
            hostCookies += ";" + cookie.name + "=" + cookie.value;
        } else {
            hostCookies = cookie.name + "=" + cookie.value;
        }
        cookieDict[cookie.host] = hostCookies;
    }
    var plugin = document.getElementById("webaccountsExtensionId");
    plugin.setLoginInfo(JSON.stringify({
        login: msg.login,
        domain: msg.domain,
        cookies: cookieDict
    }));

}

window.addEventListener("load", function() {
    window.removeEventListener("load", arguments.callee, false);

    var WebAccountsObserver = {
        observe: function(subject, topic, login) {
            if (topic != 'webapps-login' || login == "") return;
            dump("Login: " + login + "\n");
            var loginObj = JSON.parse(login);
            if (loginObj.login) {
                collectCookies(loginObj);
            }
        }
    };

    Services.obs.addObserver(WebAccountsObserver, kObserverTopic, false);

    window.addEventListener("unload", function() {
        window.removeEventListener("unload", arguments.callee, false);

        Services.obs.removeObserver(WebAccountsObserver, kObserverTopic);

        dump("Webaccounts extension unloaded\n");
    }, false);

    dump("Webaccounts extension loaded\n");
}, false);

})();
