var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

dump("Webaccounts extension loaded\n");

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");

var cookieManager = Cc["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager2);

function collectCookies(msg) {
    var cookies = cookieManager.getCookiesFromHost(msg.domain);
    dump("Collecting cookies\n");
    var cookieDict = {}
    while (cookies.hasMoreElements()){
        var cookie = cookies.getNext().QueryInterface(Ci.nsICookie);
        var hostCookies = ""
        if (cookie.host in cookieDict) {
            hostCookies = cookieDict[cookie.host];
            hostCookies += ";" + cookie.name + "=" + cookie.value;
        } else {
            hostCookies = cookie.name + "=" + cookie.value;
        }
        cookieDict[cookie.host] = hostCookies;
    }
    var plugin = document.getElementById("webaccountsExtensionId");
    plugin.setLoginInfo(JSON.stringify({
        login: msg.login,
        domain: msg.domain,
        cookies: cookieDict
    }));

}

var observerService = Cc["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
observerService.addObserver({
    observe: function(subject, topic, login) {
        if (topic != 'webapps-login' || login == "") return;
        dump("Login: " + login + "\n");
        var loginObj = JSON.parse(login);
        if (loginObj.login) {
            collectCookies(loginObj);
        }
    }
}, 'webapps-login', false);

