# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for Siemens DirX

$Id: dirx.py,v 1.3 2011/10/17 17:57:59 michael Exp $
"""

from w2lapp.schema.syntaxes import DirectoryString,DistinguishedName,syntax_registry

from w2lapp.gui import DisplayDN

class LdapSSLCfgSubentryCN(DirectoryString):
  oid = 'LdapSSLCfgSubentryCN-oid'
  desc = 'CN of SSL configuration subentry'

  def displayValue(self,valueindex=0,commandbutton=0):
    return '' % (
      DisplayDN(sid,form,ls,dn,commandbutton=commandbutton),
      number,
      '<code>%s</code>' % HexString(
        dstring,delimiter=':',wrap=64,linesep='<br>'
      ),
    )

