# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for X.509 cert/CRL schema by DAASI

See also: 
http://tools.ietf.org/draft/draft-ietf-pkix-ldap-pkc-schema

$Id: pkcschema.py,v 1.3 2009/08/18 23:44:31 michael Exp $
"""

from w2lapp.schema.syntaxes import syntax_registry

try:
  from w2lapp.schema.syntaxes import DumpASN1CfgOID
except ImportError:
  pass
else:
  # This overrides the eventually configured OctetString syntax
  # and treats these attribute types as not human-readable and
  # not editable binary blobs
  syntax_registry.registerAttrType(
    DumpASN1CfgOID.oid,[
    '1.3.6.1.4.1.10126.1.5.3.3', # x509signatureAlgorithm
    '1.3.6.1.4.1.10126.1.5.3.8', # x509subjectPublicKeyInfoAlgorithm
    '1.3.6.1.4.1.10126.1.5.3.16', # x509policyInformationIdentifier
    '1.3.6.1.4.1.10126.1.5.3.22', # x509subjectRegisteredID
    '1.3.6.1.4.1.10126.1.5.3.28', # x509issuerRegisteredID
    '1.3.6.1.4.1.10126.1.5.3.30', # x509extKeyUsage
    ]
  )
