# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for PGP key server

$Id: pgpkeysrv.py,v 1.6 2011/02/11 20:12:23 michael Exp $
"""

import re

from w2lapp.schema.syntaxes import Binary,MultilineText,PreformattedMultilineText,syntax_registry


class PgpKey(PreformattedMultilineText):
  oid = 'PgpKey-oid'
  desc = 'PGP key'
  reObj=re.compile('^-----BEGIN PGP PUBLIC KEY BLOCK-----[a-zA-Z0-9.: ()+/ =\n-]+-----END PGP PUBLIC KEY BLOCK-----$',re.S+re.M)
  lineSep = '\n'
  mimeType = 'application/pgp-keys'
  cols = 64



syntax_registry.registerAttrType(
  PgpKey.oid,[
    '1.3.6.1.4.1.3401.8.2.11', # pgpKey
  ]
)


# Register all syntax classes in this module
for symbol_name in dir():
  syntax_registry.registerSyntaxClass(eval(symbol_name))
