# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for attributes defined for DHCP service

See http://tools.ietf.org/draft/draft-ietf-dhc-ldap-schema/

$Id: dhcp.py,v 1.9 2009/08/18 23:44:31 michael Exp $
"""

import re
from w2lapp.schema.syntaxes import IA5String,SelectList,DynamicDNSelectList,BitArrayInteger,DNSDomain,syntax_registry


class DHCPServerDN(DynamicDNSelectList):
  oid = 'DHCPServerDN-oid'
  desc = 'DN of DHCP server entry'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpServer)'

syntax_registry.registerAttrType(
  DHCPServerDN.oid,[
    '2.16.840.1.113719.1.203.4.1', # dhcpPrimaryDN
    '2.16.840.1.113719.1.203.4.2', # dhcpSecondaryDN
  ]
)


class DHCPOptionsDN(DynamicDNSelectList):
  oid = 'DHCPOptionsDN-oid'
  desc = 'DN of DHCP option object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpOptions)'

syntax_registry.registerAttrType(
  DHCPOptionsDN.oid,[
    '2.16.840.1.113719.1.203.4.9', # dhcpOptionsDN
  ]
)


class DHCPHostDN(DynamicDNSelectList):
  oid = 'DHCPHostDN-oid'
  desc = 'DN of DHCP host object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpHost)'

syntax_registry.registerAttrType(
  DHCPHostDN.oid,[
    '2.16.840.1.113719.1.203.4.10', # dhcpHostDN
  ]
)


class DHCPPoolDN(DynamicDNSelectList):
  oid = 'DHCPPoolDN-oid'
  desc = 'DN of DHCP pool object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpPool)'

syntax_registry.registerAttrType(
  DHCPPoolDN.oid,[
    '2.16.840.1.113719.1.203.4.11', # dhcpPoolDN
  ]
)


class DHCPGroupDN(DynamicDNSelectList):
  oid = 'DHCPGroupDN-oid'
  desc = 'DN of DHCP group object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpGroup)'

syntax_registry.registerAttrType(
  DHCPGroupDN.oid,[
    '2.16.840.1.113719.1.203.4.12', # dhcpGroupDN
  ]
)


class DHCPSubnetDN(DynamicDNSelectList):
  oid = 'DHCPSubnetDN-oid'
  desc = 'DN of DHCP subnet object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpSubnet)'

syntax_registry.registerAttrType(
  DHCPSubnetDN.oid,[
    '2.16.840.1.113719.1.203.4.13', # dhcpSubnetDN
  ]
)


class DHCPLeasesDN(DynamicDNSelectList):
  oid = 'DHCPLeasesDN-oid'
  desc = 'DN of DHCP leases object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpLeases)'

syntax_registry.registerAttrType(
  DHCPLeasesDN.oid,[
    '2.16.840.1.113719.1.203.4.14', # dhcpLeaseDN
    '2.16.840.1.113719.1.203.4.15', # dhcpLeasesDN
  ]
)


class DHCPClassesDN(DynamicDNSelectList):
  oid = 'DHCPClassesDN-oid'
  desc = 'DN of DHCP classes object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpClass)'

syntax_registry.registerAttrType(
  DHCPClassesDN.oid,[
    '2.16.840.1.113719.1.203.4.16', # dhcpClassesDN
  ]
)


class DHCPSubclassesDN(DynamicDNSelectList):
  oid = 'DHCPSubclassesDN-oid'
  desc = 'DN of DHCP Subclasses object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpSubclass)'

syntax_registry.registerAttrType(
  DHCPSubclassesDN.oid,[
    '2.16.840.1.113719.1.203.4.17', # dhcpSubclassesDN
  ]
)


class DHCPSharedNetworkDN(DynamicDNSelectList):
  oid = 'DHCPSharedNetworkDN-oid'
  desc = 'DN of DHCP shared network object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpSharedNetwork)'

syntax_registry.registerAttrType(
  DHCPSharedNetworkDN.oid,[
    '2.16.840.1.113719.1.203.4.18', # dhcpSharedNetworkDN
  ]
)


class DHCPServiceDN(DynamicDNSelectList):
  oid = 'DHCPServiceDN-oid'
  desc = 'DN of DHCP service object'
  ldap_url = 'ldap:///_?cn?sub?(objectClass=dhcpService)'

syntax_registry.registerAttrType(
  DHCPServiceDN.oid,[
    '2.16.840.1.113719.1.203.4.19', # dhcpServiceDN
  ]
)

class DHCPHWAddress(IA5String):
  oid = 'DHCPHWAddress-oid'
  desc = 'Network classifier and MAC address'
  reObj=re.compile("^ethernet [0-9A-F:]+$")

syntax_registry.registerAttrType(
  DHCPHWAddress.oid,[
    '2.16.840.1.113719.1.203.4.34', # dhcpHWAddress
  ]
)


class DHCPAddressState(SelectList):
  oid = 'DHCPAddressState-oid'
  desc = 'DHCP address state'

  attr_value_dict = {
    u'':u'',
    u'FREE':u'FREE',
    u'ACTIVE':u'ACTIVE',
    u'EXPIRED':u'EXPIRED',
    u'RELEASED':u'RELEASED',
    u'RESET':u'RESET',
    u'ABANDONED':u'ABANDONED',
    u'BACKUP':u'BACKUP',
    u'UNKNOWN':u'UNKNOWN',
    u'RESERVED':u'RESERVED (an address that is managed by DHCP that is reserved for a specific client)',
    u'RESERVED-ACTIVE':u'RESERVED-ACTIVE (same as reserved, but address is currently in use)',
    u'ASSIGNED':u'ASSIGNED (assigned manually or by some other mechanism)',
    u'UNASSIGNED':u'UNASSIGNED',
    u'NOTASSIGNABLE':u'NOTASSIGNABLE',
  }


syntax_registry.registerAttrType(
  DNSDomain.oid,[
    '2.16.840.1.113719.1.203.4.27', # dhcpDomainName
  ]
)


syntax_registry.registerAttrType(
  DHCPAddressState.oid,[
    '2.16.840.1.113719.1.203.4.22', # dhcpAddressState
  ]
)


# Register all syntax classes in this module
for symbol_name in dir():
  syntax_registry.registerSyntaxClass(eval(symbol_name))
